/*
 * Decompiled with CFR 0.152.
 */
class FlipH
extends GimmickObject {
    public static Animation flipAnimation;
    public AnimationDrawer drawer;
    public Line collisionLine;
    public boolean isUp;
    public boolean noTouch = true;
    public boolean justPop = false;
    public int leftBorder;
    public int rightBorder;

    protected FlipH(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (flipAnimation == null) {
            flipAnimation = new Animation("/animation/flip");
        }
        this.drawer = flipAnimation.getDrawer(2, true, this.iLeft == 0 ? 2 : 0);
        if (this.iLeft == 0) {
            this.rightBorder = this.posX;
            this.leftBorder = this.posX - 2432;
        } else {
            this.leftBorder = this.posX;
            this.rightBorder = this.posX + 2432;
        }
    }

    public void draw(MFGraphics mFGraphics) {
        this.drawInMap(mFGraphics, this.drawer);
        if (this.drawer.checkEnd()) {
            this.drawer.setActionId(2);
            this.drawer.setLoop(true);
        }
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        if (this.iLeft == 0) {
            this.collisionRect.setTwoPosition(n + 512, n2 - 512 + 1, n + 512 - 2880, n2 - 512 + 1 + 1536);
        } else {
            this.collisionRect.setRect(n - 512, n2 - 512 + 1, 2880, 1536);
        }
        if (this.collisionLine == null) {
            this.collisionLine = new Line();
        }
        if (this.iLeft == 0) {
            this.collisionLine.setProperty(n, n2 - 512, n - 2432, n2 + 704);
        } else {
            this.collisionLine.setProperty(n, n2 - 512, n + 2432, n2 + 704);
        }
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (playerObject == GameObject.player) {
            if (this.noTouch && !this.justPop) {
                if (n == 1 || n == 2 || n == 3) {
                    this.isUp = true;
                    this.noTouch = false;
                    if (this.firstTouch) {
                        if (GameObject.player.getFootPositionX() < this.leftBorder) {
                            GameObject.player.setFootPositionX(this.leftBorder);
                        } else if (GameObject.player.getFootPositionX() > this.rightBorder) {
                            GameObject.player.setFootPositionX(this.rightBorder);
                        }
                    }
                } else if (n == 0) {
                    this.isUp = false;
                    this.noTouch = false;
                }
            }
            if (!this.noTouch) {
                int n2 = this.collisionLine.getY(GameObject.player.getFootPositionX());
                int n3 = GameObject.player.getFootPositionY();
                if (this.isUp && n3 >= n2 && GameObject.player.getMoveDistance().y >= 0) {
                    GameObject.player.setNoKey();
                    GameObject.player.beStop(n2, 1, this);
                    GameObject.player.setFootPositionY(n2);
                    GameObject.player.setVelX(this.iLeft == 0 ? -128 : 128);
                    GameObject.player.setAnimationId(4);
                } else if (!this.isUp) {
                    // empty if block
                }
            }
            if (n == 0) {
                GameObject.player.beStop(0, 0, this);
            }
        }
    }

    public void logic() {
        if (this.justPop) {
            this.justPop = false;
        }
        if (!this.noTouch && Key.press(Key.gUp | 0x1000000)) {
            this.drawer.setActionId(3);
            this.drawer.setLoop(false);
            int n = GameObject.player.getFootPositionX();
            int n2 = 659 * Math.abs(n - (this.iLeft == 0 ? this.posX : this.posX)) / 2880;
            GameObject.player.bePop(n2 += 2163, 1);
            GameObject.player.setVelX(this.iLeft == 0 ? -n2 / 10 : n2 / 10);
            this.noTouch = true;
            this.justPop = true;
        }
    }

    public void doWhileNoCollision() {
        this.noTouch = true;
    }

    public void close() {
        this.drawer = null;
    }

    public static void releaseAllResource() {
        flipAnimation = null;
    }

    public int getPaintLayer() {
        return 0;
    }
}

