/*
 * Decompiled with CFR 0.152.
 */
public class CollisionRect {
    public int x0;
    public int y0;
    public int x1;
    public int y1;

    public void setTwoPosition(int n, int n2, int n3, int n4) {
        this.x0 = Math.min(n, n3);
        this.x1 = Math.max(n, n3);
        this.y0 = Math.min(n2, n4);
        this.y1 = Math.max(n2, n4);
    }

    public void setRect(int n, int n2, int n3, int n4) {
        if (n3 < 0) {
            this.x0 = n + n3;
            this.x1 = n;
        } else {
            this.x0 = n;
            this.x1 = n + n3;
        }
        if (n4 < 0) {
            this.y0 = n2 + n4;
            this.y1 = n2;
        } else {
            this.y0 = n2;
            this.y1 = n2 + n4;
        }
    }

    public boolean collisionChk(CollisionRect collisionRect) {
        if (this.y1 <= collisionRect.y0 || this.y0 > collisionRect.y1) {
            return false;
        }
        return this.x1 > collisionRect.x0 && this.x0 <= collisionRect.x1;
    }

    public boolean collisionChk(int n, int n2) {
        if (this.y1 <= n2 || this.y0 > n2) {
            return false;
        }
        return this.x1 > n && this.x0 <= n;
    }

    public boolean isLeftOf(CollisionRect collisionRect, int n) {
        return this.x1 <= collisionRect.x0 + n;
    }

    public boolean isRightOf(CollisionRect collisionRect, int n) {
        return this.x0 >= collisionRect.x1 - n;
    }

    public boolean isUpOf(CollisionRect collisionRect, int n) {
        return this.y1 <= collisionRect.y0 + n;
    }

    public boolean isDownOf(CollisionRect collisionRect, int n) {
        return this.y0 >= collisionRect.y1 - n;
    }

    public void draw(MFGraphics mFGraphics, Coordinate coordinate) {
        mFGraphics.setColor(0xFF0000);
        mFGraphics.drawRect(this.x0 - coordinate.x, this.y0 - coordinate.y, this.x1 - this.x0, this.y1 - this.y0);
    }

    public int getWidth() {
        return this.x1 - this.x0;
    }

    public int getHeight() {
        return this.y1 - this.y0;
    }

    public int getCenterX() {
        return this.x0 + this.x1 >> 1;
    }

    public int getCenterY() {
        return this.y0 + this.y1 >> 1;
    }

    public String toString() {
        return "x0:" + this.x0 + "|x1:" + this.x1 + "|y0:" + this.y0 + "|y1:" + this.y1;
    }
}

