/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public class CollisionMap
implements SonicDef {
    public static final byte[] noBlock = new byte[8];
    public static final byte[] hasBlock = new byte[8];
    public static byte[][] collisionInfo;
    public static byte[] directionInfo;
    public static short[][][] modelInfo;
    public static int loadStep;
    public static DataInputStream ds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean loadCollisionInfoStep(String string) {
        boolean bl = true;
        switch (loadStep) {
            case 0: {
                ds = new DataInputStream(MFDevice.getResourceAsStream("/map/" + string + ".ci"));
                break;
            }
            case 1: {
                modelInfo = new short[MapManager.mapModel.length][12][12];
                for (int i = 0; i < modelInfo.length; ++i) {
                    for (int j = 0; j < 12; ++j) {
                        for (int k = 0; k < 12; ++k) {
                            CollisionMap.modelInfo[i][k][j] = (short)(ds.readShort() & 0xFFFF);
                        }
                    }
                }
                if (ds == null) break;
                try {
                    ds.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break;
                catch (Exception exception) {
                    if (ds == null) break;
                    try {
                        ds.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break;
                    catch (Throwable throwable) {
                        if (ds != null) {
                            try {
                                ds.close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                }
            }
            case 2: {
                ds = new DataInputStream(MFDevice.getResourceAsStream("/map/" + string + ".co"));
                int n = ds.readShort();
                collisionInfo = new byte[n][8];
                directionInfo = new byte[n];
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < 8; ++j) {
                        CollisionMap.collisionInfo[i][j] = ds.readByte();
                    }
                    CollisionMap.directionInfo[i] = ds.readByte();
                }
                if (ds == null) break;
                try {
                    ds.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                break;
                catch (Exception exception) {
                    if (ds == null) break;
                    try {
                        ds.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    break;
                    catch (Throwable throwable) {
                        if (ds != null) {
                            try {
                                ds.close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                        throw throwable;
                    }
                }
            }
            case 3: {
                loadStep = 0;
                return true;
            }
        }
        if (bl) {
            ++loadStep;
        }
        return false;
    }

    public static void getCollisionInfoWithBlock(int n, int n2, int n3, CollisionBlock collisionBlock) {
        if (n2 < 0 || n2 >= MapManager.getMapHeight() * 12) {
            collisionBlock.setProperty(noBlock, false, false, 0, false);
            return;
        }
        if (n < 0) {
            collisionBlock.setProperty(hasBlock, false, false, 64, false);
            return;
        }
        if (n >= MapManager.getMapWidth() * 12) {
            n = (MapManager.getMapWidth() - 4) * 12 + (n - MapManager.getMapWidth() * 12) % 48;
        }
        int n4 = CollisionMap.getBlockIndexWithBlock(n, n2, n3);
        int n5 = n4 & 0x1FFF;
        boolean bl = (n4 & 0x8000) != 0;
        boolean bl2 = (n4 & 0x4000) != 0;
        boolean bl3 = (n4 & 0x2000) != 0;
        collisionBlock.setProperty(collisionInfo[n5], bl2, bl, directionInfo[n5], bl3);
    }

    public static int getBlockIndexWithBlock(int n, int n2, int n3) {
        int n4 = 0;
        n4 = n3 == 1 ? CollisionMap.getTileId(MapManager.mapBack, n, n2) : CollisionMap.getTileId(MapManager.mapFront, n, n2);
        return n4;
    }

    public static int getTileId(short[][] sArray, int n, int n2) {
        int n3 = n / 12;
        int n4 = n2 / 12;
        int n5 = n % 12;
        int n6 = n2 % 12;
        short[][] sArray2 = modelInfo[sArray[n3][n4]];
        return sArray2[n5][n6];
    }

    public static void closeMap() {
        collisionInfo = null;
        directionInfo = null;
        modelInfo = null;
    }

    static {
        for (int i = 0; i < hasBlock.length; ++i) {
            CollisionMap.hasBlock[i] = -120;
        }
        loadStep = 0;
    }
}

