/*
 * Decompiled with CFR 0.152.
 */
final class CRCUtil {
    public static int[] crc_table;

    public static void make_crc_table() {
        crc_table = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n = i;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1) == 1) {
                    n = 0xEDB88320 ^ n >>> 1;
                    continue;
                }
                n >>>= 1;
            }
            CRCUtil.crc_table[i] = n;
        }
    }

    public static int update_crc(byte[] byArray, int n, int n2) {
        int n3 = -1;
        if (crc_table == null) {
            CRCUtil.make_crc_table();
        }
        for (int i = n; i < n2 + n; ++i) {
            n3 = crc_table[(n3 ^ byArray[i]) & 0xFF] ^ n3 >>> 8;
        }
        return n3;
    }

    static int checksum(byte[] byArray, int n, int n2) {
        return ~CRCUtil.update_crc(byArray, n, n2);
    }

    CRCUtil() {
    }
}

