/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public final class BitmapFont {
    public String name = null;
    public final int min;
    public final int max;
    public final String charset;
    final int ascent;
    final int descent;
    final int height;
    public final int size;
    public final int[] clip;
    public final byte[] relX;
    public final byte[] relY;
    final byte[] advance;
    public MFImage sheet;
    public final int[] lookup;
    final int minAdvance;
    public static byte[] imgData;

    public BitmapFont(String string) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(MFDevice.getResourceAsStream(string));
        this.min = dataInputStream.readUnsignedShort();
        this.max = dataInputStream.readUnsignedShort();
        this.charset = dataInputStream.readUTF();
        int n = this.max - this.min;
        if (n > 128) {
            n = 128;
        }
        this.lookup = new int[n];
        int n2 = 0;
        int n3 = this.min;
        while (n2 < n) {
            this.lookup[n2] = this.charset.indexOf((char)n3);
            ++n2;
            ++n3;
        }
        this.ascent = dataInputStream.readByte();
        this.descent = dataInputStream.readByte();
        this.height = this.descent - this.ascent;
        this.size = dataInputStream.readUnsignedShort();
        this.clip = new int[this.size];
        for (n2 = 0; n2 < this.size; ++n2) {
            this.clip[n2] = dataInputStream.readInt();
        }
        this.relX = new byte[this.size];
        dataInputStream.readFully(this.relX);
        this.relY = new byte[this.size];
        dataInputStream.readFully(this.relY);
        this.advance = new byte[this.size];
        dataInputStream.readFully(this.advance);
        this.minAdvance = BitmapFont.findMinimum(this.advance, this.size);
        if (dataInputStream.readByte() != 0) {
            throw new IllegalArgumentException();
        }
        this.sheet = this.loadImageFromStream(dataInputStream);
        dataInputStream.close();
        dataInputStream = null;
    }

    public BitmapFont(BitmapFont bitmapFont) {
        this.name = bitmapFont.name;
        this.min = bitmapFont.min;
        this.max = bitmapFont.max;
        this.charset = bitmapFont.charset;
        this.ascent = bitmapFont.ascent;
        this.descent = bitmapFont.descent;
        this.height = bitmapFont.height;
        this.size = bitmapFont.size;
        this.clip = bitmapFont.clip;
        this.relX = bitmapFont.relX;
        this.relY = bitmapFont.relY;
        this.advance = bitmapFont.advance;
        this.sheet = bitmapFont.sheet;
        this.lookup = bitmapFont.lookup;
        this.minAdvance = bitmapFont.minAdvance;
    }

    public static int findMinimum(byte[] byArray, int n) {
        byte by;
        int by2 = Integer.MAX_VALUE;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] <= 0 || byArray[i] >= by) continue;
            by = byArray[i];
        }
        return by;
    }

    public int getIndex(char c) {
        int n = c - this.min;
        if (n >= 0 && n < this.lookup.length) {
            return this.lookup[n];
        }
        return this.charset.lastIndexOf(c);
    }

    public int getW(char[] cArray) {
        return this.getW(cArray, 0, cArray.length);
    }

    public int getW(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n4 < n2) {
            int n6 = this.getIndex(cArray[n5]);
            if (n6 >= 0) {
                n3 += this.advance[n6];
            }
            ++n4;
            ++n5;
        }
        return n3;
    }

    public void paint(MFGraphics mFGraphics, MFImage mFImage, int n, int n2, int n3) {
        int n4 = this.clip[n];
        mFGraphics.drawRegion(mFImage == null ? this.sheet : mFImage, n4 >> 0 & 0x1FF, n4 >> 9 & 0x1FF, n4 >> 18 & 0x7F, n4 >> 25 & 0x7F, 0, n2 + this.relX[n], n3 + this.relY[n], 20);
    }

    public final MFImage loadImageFromStream(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        if (imgData == null || imgData.length < n) {
            imgData = new byte[n > 2500 ? n : 2500];
        }
        dataInput.readFully(imgData, 0, n);
        MFImage mFImage = MFImage.createImage(new ByteArrayInputStream(imgData));
        return mFImage;
    }

    public void DrawString(MFGraphics mFGraphics, String string, int n, int n2, int n3) {
        this.DrawString(mFGraphics, string, null, n, n2, n3);
    }

    public void DrawString(MFGraphics mFGraphics, String string, MFImage mFImage, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = n;
        int n8 = string.length();
        char[] cArray = new char[n8];
        for (n5 = 0; n5 < n8; ++n5) {
            cArray[n5] = string.charAt(n5);
            n4 = this.getIndex(cArray[n5]);
            if (n4 == -1) continue;
            n6 += this.advance[n4];
        }
        if ((n3 & 1) != 0) {
            n7 -= n6 + 1 >> 1;
        }
        if ((n3 & 8) != 0) {
            n7 -= n6;
        }
        if ((n3 & 2) != 0) {
            n2 += this.height >> 1;
        }
        if ((n3 & 0x10) != 0) {
            n2 += 0;
        }
        if ((n3 & 0x20) != 0) {
            n2 += this.height;
        }
        for (n5 = 0; n5 < n8; ++n5) {
            n4 = this.getIndex(cArray[n5]);
            this.paint(mFGraphics, mFImage, n4, n7, n2);
            if (n4 == -1) continue;
            n7 += this.advance[n4];
        }
    }

    public BitmapFont getClone(Palette palette) {
        BitmapFont bitmapFont = new BitmapFont(this);
        PalettedImage palettedImage = PalettedImage.createPalettedImage(imgData);
        palettedImage.setPalette(palette);
        bitmapFont.sheet = palettedImage.getImage();
        return bitmapFont;
    }
}

