/*
 * Decompiled with CFR 0.152.
 */
public class SoundSystem {
    public static SoundSystem instance;
    public final String[] BgmName = new String[]{"bgm_12_st1_1", "bgm_14_st2_1", "bgm_16_st3_1", "bgm_20_st5_1", "bgm_04_zoneselect", "bgm_33_clear1", "bgm_37_gameover", "bgm_305_NewRecord", "bgm_306_TimeAttackGoal", "bgm_29_boss1", "bgm_307_1up", "bgm_12_st1_1_fast", "bgm_14_st2_1_fast", "bgm_16_st3_1_fast", "bgm_20_st5_1_fast", "bgm_29_boss1_fast", "m_invincible"};
    public final String BgmType;
    public final String[] SE_NAME = new String[]{"se_117.wav", "se_172.wav"};
    public String Path = "/mid/";
    public String BgmPrefix = "";
    public boolean nextBgmWaiting = false;
    public int nextBgmIndex = 0;
    public static byte currentBgmIndex;
    public final int[] VOLUME_OPTION = new int[]{0, 25, 60, 95};

    public SoundSystem() {
        this.BgmType = ".mid";
    }

    public static void open() {
        instance = new SoundSystem();
        instance.openImpl();
    }

    public static SoundSystem getInstance() {
        if (instance == null) {
            SoundSystem.open();
        }
        return instance;
    }

    public void openImpl() {
        this.nextBgmWaiting = false;
    }

    public void exec() {
        if (this.nextBgmWaiting && !this.bgmPlaying()) {
            this.nextBgmWaiting = false;
            if (PlayerObject.invincibleCount > 0) {
                this.nextBgmIndex = 16;
            }
            if (PlayerObject.speedCount > 0) {
                this.nextBgmIndex = StageManager.getFastBgmId();
            }
            this.playBgm(this.nextBgmIndex);
        }
    }

    public void playBgmSequence(int n, int n2) {
        this.playBgm(n, false);
        this.nextBgmWaiting = true;
        this.nextBgmIndex = n2;
    }

    public void playBgm(int n) {
        this.playBgm(n, true);
    }

    public void playBgm(int n, boolean bl) {
        MFSound.playBgm(this.Path.concat(this.BgmPrefix).concat(this.BgmName[n] + ".mid"), bl);
        currentBgmIndex = (byte)n;
    }

    public void stopBgm(boolean bl) {
        MFSound.stopBgm();
        this.nextBgmWaiting = false;
    }

    public void playSe(int n, boolean bl) {
        if (n < 2 && !MFSound.isBgmPlaying()) {
            MFSound.playSe("/se/" + this.SE_NAME[n], 1);
        }
    }

    public void playSe(int n) {
        this.playSe(n, false);
    }

    public void setVolume(int n) {
        MFSound.setVolume(n);
    }

    public int getVolume() {
        return MFSound.getVolume();
    }

    public void setBgmFlag(boolean bl) {
        MFSound.setBgmFlag(bl);
    }

    public void setSeFlag(boolean bl) {
        MFSound.setSeFlag(bl);
    }

    public boolean bgmPlaying() {
        return MFSound.isBgmPlaying();
    }

    public void setSoundState(int n) {
        switch (n) {
            case 0: {
                this.setBgmFlag(false);
                this.setSeFlag(false);
                break;
            }
            default: {
                if (n < 1 || n > 10) break;
                this.setBgmFlag(true);
                this.setVolume(100 * n / 10);
            }
        }
    }

    public void setSeState(int n) {
        switch (n) {
            case 0: {
                this.setSeFlag(false);
                break;
            }
            case 1: {
                this.setSeFlag(true);
            }
        }
    }

    public void preLoadAllSe() {
        MFSound.releaseAllSound();
        for (int i = 0; i < this.SE_NAME.length; ++i) {
            MFSound.preloadSound("/se/" + this.SE_NAME[i]);
        }
    }

    static {
        currentBgmIndex = (byte)-1;
    }
}

