/*
 * Decompiled with CFR 0.152.
 */
class Shatter
extends GimmickObject {
    public boolean trigger = false;
    public int posYOriginal = this.posY - 3072;
    public static MFImage image;

    protected Shatter(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        if (image == null) {
            try {
                image = MFImage.createImage("/gimmick/shatter.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.trigger) {
            this.drawInMap(mFGraphics, image, 17);
        }
        this.drawCollisionRect(mFGraphics);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (!this.trigger) {
            this.collisionRect.collisionChk(playerObject.getBodyPositionX(), playerObject.getBodyPositionY());
            this.trigger = true;
            this.posY = this.posYOriginal;
            this.refreshCollisionRect(this.posX, this.posY);
        } else if (n == 2 || n == 3) {
            playerObject.beStop(0, n, this);
        } else {
            playerObject.beStop(0, 2, this);
        }
    }

    public void doWhileNoCollision() {
        if (this.trigger && !this.isInCamera()) {
            this.trigger = false;
            this.posY = this.posYOriginal + 3072;
            this.refreshCollisionRect(this.posX, this.posY);
        }
    }

    public void logic() {
        if (this.trigger) {
            int n = this.posY;
            this.posY += 600;
            if (this.posY >= this.posYOriginal + 3072) {
                this.posY = this.posYOriginal + 3072;
            }
            this.checkWithPlayer(this.posX, n, this.posX, this.posY);
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        if (!this.trigger) {
            this.collisionRect.setRect(n + 512, n2, this.mWidth, this.mHeight);
        } else {
            this.collisionRect.setRect(n - 512, n2, 1024, 3072);
        }
    }

    public void close() {
    }

    public static void releaseAllResource() {
        image = null;
    }
}

