/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class PlayerObject
extends MoveObject {
    public int faceDegree = 0;
    public boolean faceDirection = true;
    public boolean extraAttackFlag = false;
    public int footPointX = 512;
    public int footPointY = 0;
    public byte collisionState;
    public int sYPosition;
    public int sXPosition;
    public int sBlockX;
    public int sBlockY;
    public boolean onGround = false;
    public AnimationDrawer drawer;
    public AnimationDrawer effectDrawer;
    public static final int[][] ANIMATION_ID_HIGH = new int[][]{{0, 0}, {1, 4}, {2, 5}, {3, 6}, {7, 7}, {11, 11}, {24, 24}, {25, 25}, {19, 19}, {12, 12}, {13, 13}, {28, 29}, {14, 14}, {38, 38}, {22, 22}, {26, 26}, {27, 27}, {31, 31}, {15, 15}, {16, 16}, {17, 17}, {41, 41}, {35, 35}, {49, 49}, {50, 50}, {34, 34}, {48, 48}, {39, 39}, {40, 40}, {37, 37}, {14, 14}, {33, 33}, {44, 44}, {45, 45}, {46, 46}, {42, 42}, {43, 43}, {47, 47}, {8, 8}, {9, 9}, {10, 10}, {30, 30}, {20, 20}, {21, 21}};
    public static final boolean[] ANIMATION_LOOP_HIGH = new boolean[]{true, true, true, true, true, false, true, false, true, false, true, true, true, false, true, false, true, true, true, false, true, true, false, false, true, false, false, false, true, true, false, false, true, true, true, false, true, false, false, true, false, false, true, true};
    public static final int[][] ANIMATION_ID_LOW = new int[][]{{0, 0}, {1, 4}, {2, 5}, {3, 6}, {7, 7}, {11, 11}, {24, 24}, {25, 25}, {2, 2}, {12, 12}, {13, 13}, {28, 29}, {14, 14}, {38, 38}, {22, 22}, {26, 26}, {27, 27}, {31, 31}, {15, 15}, {16, 16}, {17, 17}, {41, 41}, {35, 35}, {49, 49}, {50, 50}, {34, 34}, {48, 48}, {39, 39}, {40, 40}, {37, 37}, {14, 14}, {33, 33}, {44, 44}, {45, 45}, {46, 46}, {3, 3}, {3, 3}, {47, 47}, {8, 8}, {9, 9}, {10, 10}, {30, 30}, {20, 20}, {21, 21}};
    public static final boolean[] ANIMATION_LOOP_LOW = new boolean[]{true, true, true, true, true, false, true, false, true, false, true, true, true, false, true, false, true, true, true, false, true, true, false, false, true, false, false, false, true, true, false, false, true, true, true, false, true, false, false, true, false, false, true, true};
    public static final int[][] ANIMATION_ID = ANIMATION_ID_HIGH;
    public static final boolean[] ANIMATION_LOOP = ANIMATION_LOOP_HIGH;
    public static final boolean[] EFFECT_LOOP = new boolean[]{false, true, true};
    public int spinCount = 0;
    public static int MOVE_POWER = 44;
    public static int MOVE_POWER_IN_AIR = MOVE_POWER << 1;
    public static int MAX_VELOCITY = 1280;
    public static int MOVE_POWER_REVERSE = 388;
    public static int MOVE_POWER_REVERSE_BALL = 92;
    public static int FAKE_GRAVITY_ON_WALK = 102;
    public static int FAKE_GRAVITY_ON_BALL = 224;
    public static int JUMP_START_VELOCITY = -1200 - GameObject.GRAVITY;
    public static int JUMP_PROTECT = -GameObject.GRAVITY - GameObject.GRAVITY;
    public static int SPIN_START_SPEED_1 = 1438;
    public static int SPIN_START_SPEED_2 = 2056;
    public static int HURT_POWER_X = 384;
    public static int HURT_POWER_Y = -992;
    public static int JUMP_RUSH_SPEED_PLUS = 480;
    public static int JUMP_REVERSE_POWER = 16;
    public int movePower = MOVE_POWER;
    public int movePowerInAir = MOVE_POWER_IN_AIR;
    public int movePowerReverse = MOVE_POWER_REVERSE;
    public int movePowerReserseBall = MOVE_POWER_REVERSE_BALL;
    public int maxVelocity = MAX_VELOCITY;
    public int animationID;
    public int attackAnimationID;
    public int effectID = -1;
    public int collisionLayer = 0;
    public int checkPositionX;
    public int checkPositionY;
    public int preFocusX;
    public int preFocusY;
    public boolean collisionChkBreak;
    public boolean dashRolling = false;
    public int hurtCount = 0;
    public boolean hurtNoControl = false;
    public boolean jumpRollEnable;
    public int leftCount;
    public int rightCount;
    public boolean visible = true;
    public boolean outOfControl = false;
    public boolean controlObjectLogic = false;
    public boolean footObjectLogic = false;
    public GameObject outOfControlObject = null;
    public Vector attackRectVec = new Vector();
    public CollisionRect jumpAttackRect = new CollisionRect();
    public CollisionRect attractRect = new CollisionRect();
    public CollisionRect aaaAttackRect = new CollisionRect();
    public static AnimationDrawer bariaDrawer;
    public static AnimationDrawer gBariaDrawer;
    public static Animation invincibleAnimation;
    public static AnimationDrawer invincibleDrawer;
    public static int lifeDrawerX;
    public boolean setNoMoving = false;
    public int noMovingPosition;
    public int attackLevel;
    public int attackCount;
    public int currentMarkId;
    public boolean leftStopped = false;
    public boolean rightStopped = false;
    public static final int[] DEGREE_DIVIDE;
    public static final int[] TRANS;
    public static final int FOCUS_MAX_OFFSET;
    public int focusOffsetY;
    public int focusMovingState = 0;
    public int lookCount = 10;
    public boolean xFirst;
    public int moveDistanceX = 0;
    public int moveDistanceY = 0;
    public int actualMoveDistanceX;
    public int actualMoveDistanceY;
    public int mVelocity;
    public int currentPointX;
    public int currentPointY;
    public static final int[] FOOT_OFFSET_X;
    int footOffsetX = 0;
    public boolean justLeaveLand = false;
    public int justLeaveCount = 2;
    public int justLeaveDegree;
    public static CollisionBlock collisionBlockGround;
    public static CollisionBlock collisionBlockGroundTmp;
    public static CollisionBlock collisionBlockSky;
    public GameObject footOnObject;
    public boolean onObjectContinue;
    public boolean checkedObject;
    public static CollisionBlock tmpCurrentBlock;
    public static CollisionBlock tmpBeforeBlock;
    public boolean noVelMinus;
    public boolean sandStanding;
    public boolean firstJump = false;
    public int smallJumpCount;
    public CollisionRect preCollisionRect = new CollisionRect();
    public boolean ignoreFirstTouch = false;
    public boolean slipping = false;
    public int spinKeyCount;
    public boolean waterFalling;
    public AnimationDrawer waterFallDrawer = null;
    public AnimationDrawer waterFlushDrawer = null;
    public int fallTime;
    public Line railLine;
    public boolean railing;
    public boolean railOut;
    public boolean piping;
    public byte pipeState;
    public int pipeDesX;
    public int pipeDesY;
    public int nextVelX;
    public int nextVelY;
    public boolean railFlipping = false;
    public static final int ATTACK_POP_POWER;
    public boolean isDead = false;
    public boolean finishDeadStuff = false;
    public int deadPosX = 0;
    public int deadPosY = 0;
    public boolean noKeyFlag = false;
    public boolean slipFlag;
    public boolean showWaterFlush;
    public boolean onBank;
    public boolean transing = false;
    public boolean isTerminal;
    public int terminalCount;
    public boolean isCelebrate;
    public int moveLimit;
    public static final int[] RANDOM_RING_NUM;
    public static int[][] itemVec;
    public boolean ducting = false;
    public boolean pushOnce = false;
    public boolean squeezeFlag = true;
    public static int lifeNum;
    public static int ringNum;
    public static int invincibleCount;
    public static int speedCount;
    public static int sheildType;
    public static AnimationDrawer uiDrawer;
    public static int scoreNum;
    public static int raceScoreNum;
    public static int timeCount;
    public static boolean timeStopped;
    public static int preScoreNum;
    public static int preLifeNum;
    public static int uiOffsetX;
    public static final int NumberSideX;
    public static AnimationDrawer numDrawer;
    public static final int NUM_PIC_WIDTH;
    public static final int NUM_PIC_HEIGHT;
    public static final int[] NUM_SPACE_ANIMATION;
    public static final int[] NUM_SPACE_FONT;
    public static final int[] NUM_SPACE_IMAGE;
    public static final int[] NUM_SPACE;
    public static final int[] NUM_ANI_ID;
    public static final int BG_NUM;
    public static int itemOffsetX;
    public static int offsetx;
    public static int offsety;
    public static int movespeed;
    public static int clipx;
    public static int clipy;
    public static int clipstartw;
    public static int clipendw;
    public static int cliph;
    public static int clipspeed;
    public static int score1;
    public static int score2;
    public static int totalPlusscore;
    public static boolean IsStarttoCnt;
    public static boolean IsDisplayRaceModeNewRecord;
    public static final int STAGE_PASS_STR_SPACE_FONT;
    public static final int STAGE_PASS_STR_SPACE;
    public static final int NUM_DISTANCE;
    public static int cursor;
    public static int cursorMax;
    public static int cursorIndex;
    public static int PAUSE_FRAME_WIDTH;
    public static final int PAUSE_FRAME_HEIGHT;
    public static final int PAUSE_FRAME_OFFSET_X;
    public static final int PAUSE_FRAME_OFFSET_Y;
    public static final int[] PAUSE_MENU_NORMAL_NOSHOP;
    public static final int[] PAUSE_MENU_NORMAL_SHOP;
    public static int[] PAUSE_MENU_NORMAL_ITEM;
    public static int MAX_ITEM_SHOW_NUM_TEMP;
    public static final int[] PAUSE_MENU_RACE_ITEM;
    public static AnimationDrawer menuBgDrawer6;
    public static AnimationDrawer menuBgDrawer7;
    public static int[] currentPauseMenuItem;

    public void setMeetingBoss(boolean bl) {
        this.setNoMoving = !bl;
        this.noMovingPosition = this.footPointX;
        this.moveDistanceX = 0;
        this.collisionChkBreak = true;
    }

    public PlayerObject() {
        MapManager.setFocusObj(this);
        MapManager.focusQuickLocation();
        this.drawer = new Animation("/animation/sonic_test").getDrawer();
        this.effectDrawer = new Animation("/animation/effect").getDrawer();
        this.animationID = 1;
        this.collisionState = 1;
        this.currentLayer = 1;
        if (bariaDrawer == null) {
            bariaDrawer = new Animation("/animation/baria").getDrawer(0, true, 0);
        }
        if (gBariaDrawer == null) {
            gBariaDrawer = new Animation("/animation/g_baria").getDrawer(0, true, 0);
        }
        if (invincibleAnimation == null) {
            invincibleAnimation = new Animation("/animation/muteki");
        }
        if (invincibleDrawer == null) {
            invincibleDrawer = invincibleAnimation.getDrawer(0, true, 0);
        }
        this.initUIResource();
    }

    public void initUIResource() {
        if (uiDrawer == null) {
            uiDrawer = GlobalResource.statusAnimation.getDrawer();
        }
    }

    public void logic() {
        int n;
        for (n = 0; n < 5; ++n) {
            if (itemVec[n][0] < 0) continue;
            if (itemVec[n][1] > 0) {
                int[] nArray = itemVec[n];
                nArray[1] = nArray[1] - 1;
            }
            if (itemVec[n][1] != 0) continue;
            this.getItem(itemVec[n][0]);
            PlayerObject.itemVec[n][0] = -1;
        }
        this.leftStopped = false;
        this.rightStopped = false;
        if (this.hurtCount > 0) {
            --this.hurtCount;
        }
        if (invincibleCount > 0 && --invincibleCount == 0 && GameState.state == 0 && !GameObject.bossFighting && SoundSystem.currentBgmIndex == 16) {
            if (speedCount > 0) {
                SoundSystem.getInstance().playBgm(StageManager.getFastBgmId(), true);
            } else {
                SoundSystem.getInstance().playBgm(StageManager.getBgmId(), true);
            }
        }
        this.preFocusX = this.getNewPointX(this.footPointX, 0, -768, this.faceDegree) >> 6;
        this.preFocusY = this.getNewPointY(this.footPointY, 0, -768, this.faceDegree) >> 6;
        if (this.setNoMoving) {
            if (this.collisionState == 0) {
                this.footPointX = this.noMovingPosition;
                this.setVelX(0);
                this.setVelY(0);
                this.animationID = 0;
                return;
            }
            if (this.collisionState == 1) {
                this.footPointX = this.noMovingPosition;
                this.velX = 0;
                this.setNoKey();
            }
        }
        if (this.collisionState == 0) {
            this.deadPosX = this.footPointX;
            this.deadPosY = this.footPointY;
        }
        if (this.isDead) {
            this.velY += GameObject.GRAVITY;
            this.footPointX += this.velX;
            this.footPointY += this.velY;
            if (this.footPointY > (MapManager.getCamera().y + MapManager.CAMERA_HEIGHT << 6) + 3072) {
                this.footPointY = (MapManager.getCamera().y + MapManager.CAMERA_HEIGHT << 6) + 3072;
                if (!this.finishDeadStuff) {
                    if (GameObject.stageModeState == 1) {
                        StageManager.setStageRestart();
                    } else if (lifeNum > 0) {
                        --lifeNum;
                        StageManager.setStageRestart();
                    } else {
                        StageManager.setStageGameover();
                    }
                    this.finishDeadStuff = true;
                }
            }
            return;
        }
        this.focusMovingState = 0;
        this.controlObjectLogic = false;
        if (this.outOfControl) {
            if (this.outOfControlObject != null) {
                this.outOfControlObject.logic();
                this.controlObjectLogic = true;
            }
            return;
        }
        if (State.debugFreeMove) {
            this.collisionState = 1;
            if (Key.repeat(Key.gUp)) {
                this.footPointY -= 2048;
            }
            if (Key.repeat(Key.gDown)) {
                this.footPointY += 2048;
            }
            if (Key.repeat(Key.gLeft)) {
                this.footPointX -= 2048;
            }
            if (Key.repeat(Key.gRight)) {
                this.footPointX += 2048;
            }
            return;
        }
        this.ignoreFirstTouch = false;
        if (this.dashRolling) {
            this.dashRollingLogic();
            if (this.dashRolling) {
                this.collisionChk();
                return;
            }
        } else if (this.effectID == 1 || this.effectID == 2) {
            this.effectID = -1;
        }
        if (this.railing) {
            this.setNoKey();
            if (this.railLine == null) {
                this.velY += GameObject.GRAVITY;
                this.checkWithObject(this.footPointX, this.footPointY, this.footPointX + this.velX, this.footPointY + this.velY);
            } else {
                n = this.railLine.sin(GameObject.GRAVITY);
                if (!this.railLine.directRatio()) {
                    n = -n;
                }
                if (n != 0) {
                    Direction direction = this.railLine.getOneDirection();
                    this.totalVelocity += n;
                    this.checkWithObject(this.footPointX, this.footPointY, this.footPointX + direction.getValueX(this.railLine.cos(this.totalVelocity)), this.footPointY + direction.getValueY(this.railLine.sin(this.totalVelocity)));
                } else {
                    this.checkWithObject(this.footPointX, this.footPointY, this.footPointX + (this.totalVelocity < 0 ? -1 : 1) * this.railLine.cos(this.totalVelocity), this.footPointY + (this.totalVelocity < 0 ? -1 : 1) * this.railLine.sin(this.totalVelocity));
                }
            }
            if (this.railOut && this.velY > 0) {
                this.railOut = false;
                this.railing = false;
                this.collisionState = 1;
            }
            return;
        }
        if (this.piping) {
            n = this.footPointX;
            int n2 = this.footPointY;
            switch (this.pipeState) {
                case 0: {
                    if (this.footPointX < this.pipeDesX) {
                        this.footPointX += 250;
                        if (this.footPointX >= this.pipeDesX) {
                            this.footPointX = this.pipeDesX;
                        }
                    } else if (this.footPointX > this.pipeDesX) {
                        this.footPointX -= 250;
                        if (this.footPointX <= this.pipeDesX) {
                            this.footPointX = this.pipeDesX;
                        }
                    }
                    if (this.footPointY < this.pipeDesY) {
                        this.footPointY += 250;
                        if (this.footPointY >= this.pipeDesY) {
                            this.footPointY = this.pipeDesY;
                        }
                    } else if (this.footPointY > this.pipeDesY) {
                        this.footPointY -= 250;
                        if (this.footPointY <= this.pipeDesY) {
                            this.footPointY = this.pipeDesY;
                        }
                    }
                    if (this.footPointX != this.pipeDesX || this.footPointY != this.pipeDesY) break;
                    this.pipeState = 1;
                    this.velX = this.nextVelX;
                    this.velY = this.nextVelY;
                    break;
                }
                case 1: {
                    this.footPointX += this.velX;
                    this.footPointY += this.velY;
                    break;
                }
                case 2: {
                    this.footPointX += this.velX;
                    this.footPointY += this.velY;
                    if (this.velX != 0) {
                        if (this.velX > 0 && this.footPointX > this.pipeDesX) {
                            this.footPointX = this.pipeDesX;
                        } else if (this.velX < 0 && this.footPointX < this.pipeDesX) {
                            this.footPointX = this.pipeDesX;
                        }
                    }
                    if (this.velY != 0) {
                        if (this.velY > 0 && this.footPointY > this.pipeDesY) {
                            this.footPointY = this.pipeDesY;
                        } else if (this.velY < 0 && this.footPointY < this.pipeDesY) {
                            this.footPointY = this.pipeDesY;
                        }
                    }
                    if (this.velX != 0 && this.footPointX != this.pipeDesX && this.nextVelX == 0 || this.velY != 0 && this.footPointY != this.pipeDesY && this.nextVelY == 0) break;
                    this.velX = this.nextVelX;
                    this.velY = this.nextVelY;
                    this.pipeState = 1;
                }
            }
            this.checkWithObject(n, n2, this.footPointX, this.footPointY);
            this.animationID = 4;
            return;
        }
        this.bankLogic();
        if (this.onBank) {
            return;
        }
        if (this.isTerminal) {
            if (this.terminalCount > 0) {
                --this.terminalCount;
            }
            this.noKeyFlag = true;
        }
        if (this.isCelebrate) {
            if (this.faceDirection) {
                if (this.collisionState == 0) {
                    this.setVelX(0);
                }
            } else if (this.collisionState == 0) {
                this.setVelX(0);
            }
            this.noKeyFlag = true;
        }
        if (this.ducting) {
            this.noKeyFlag = true;
            this.attackAnimationID = this.animationID = 4;
            this.attackCount = 0;
            this.attackLevel = 0;
        }
        if (this.noKeyFlag) {
            Key.setKeyFunction(false);
        }
        if (this.hurtNoControl && this.animationID != 12) {
            this.hurtNoControl = false;
        }
        if (speedCount > 0) {
            --speedCount;
            this.movePower = MOVE_POWER << 1;
            this.movePowerInAir = MOVE_POWER_IN_AIR << 1;
            this.movePowerReverse = MOVE_POWER_REVERSE << 1;
            this.movePowerReserseBall = MOVE_POWER_REVERSE_BALL << 1;
            this.maxVelocity = MAX_VELOCITY << 1;
            if (speedCount == 0 && GameState.state == 0) {
                if (GameObject.bossFighting) {
                    if (SoundSystem.currentBgmIndex != 9) {
                        SoundSystem.getInstance().playBgm(9, true);
                    }
                } else if (SoundSystem.currentBgmIndex == StageManager.getFastBgmId()) {
                    if (invincibleCount > 0) {
                        SoundSystem.getInstance().playBgm(16, true);
                    } else {
                        SoundSystem.getInstance().playBgm(StageManager.getBgmId(), true);
                    }
                }
            }
        } else {
            this.movePower = MOVE_POWER;
            this.movePowerInAir = MOVE_POWER_IN_AIR;
            this.movePowerReverse = MOVE_POWER_REVERSE;
            this.movePowerReserseBall = MOVE_POWER_REVERSE_BALL;
            this.maxVelocity = MAX_VELOCITY;
        }
        switch (this.collisionState) {
            case 0: {
                this.inputLogicWalk();
                break;
            }
            case 2: {
                this.inputLogicOnObject();
                break;
            }
            case 1: {
                this.inputLogicJump();
                if (!this.transing) break;
                this.velX = 0;
                this.velY = 0;
                if (!MapManager.isCameraStop()) break;
                this.transing = false;
                break;
            }
            case 3: {
                this.inputLogicSand();
            }
        }
        if (this.noKeyFlag) {
            Key.setKeyFunction(true);
            this.noKeyFlag = false;
        }
        if (this.slipFlag) {
            if (this.collisionState == 0) {
                this.animationID = 30;
            }
            this.slipFlag = false;
        }
        this.calPreCollisionRect();
        this.collisionChk();
        switch (this.collisionState) {
            case 0: {
                this.fallChk();
                if (this.isTerminal) {
                    MapManager.setCameraDownLimit((this.posY >> 6) + 100);
                }
                if (this.isTerminal && this.terminalCount == 0 && this.totalVelocity >= MAX_VELOCITY) {
                    if (this.animationID == 35 && this.drawer.checkEnd()) {
                        this.animationID = 36;
                    }
                    if (this.animationID != 4 && this.animationID != 35 && this.animationID != 36) {
                        this.animationID = 35;
                    }
                }
                if (!this.isCelebrate) break;
                this.animationID = 37;
            }
        }
        if (this.footPointX - 512 < MapManager.actualLeftCameraLimit << 6) {
            this.footPointX = (MapManager.actualLeftCameraLimit << 6) + 512;
            if (this.getVelX() < 0) {
                this.setVelX(0);
            }
        }
        if (MapManager.actualRightCameraLimit != MapManager.getPixelWidth() && this.footPointX + 512 > MapManager.actualRightCameraLimit << 6) {
            this.footPointX = (MapManager.actualRightCameraLimit << 6) - 512;
            if (this.getVelX() > 0) {
                this.setVelX(0);
            }
        }
        if (this.footPointY - 1536 < MapManager.actualUpCameraLimit << 6) {
            this.footPointY = (MapManager.actualUpCameraLimit << 6) + 1536;
            if (this.getVelY() < 0) {
                this.setVelY(0);
            }
        }
        if (!this.isDead && this.footPointY > MapManager.actualDownCameraLimit << 6) {
            this.footPointY = MapManager.actualDownCameraLimit << 6;
            this.setDie();
        }
        if (!this.leftStopped || this.rightStopped) {
            // empty if block
        }
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.visible) {
            this.drawSonic(mFGraphics);
        }
    }

    public void draw2(MFGraphics mFGraphics) {
        this.drawCollisionRect(mFGraphics);
    }

    public void collisionChk() {
        switch (this.collisionState) {
            case 0: {
                CollisionMap.getCollisionInfoWithBlock(this.currentPointX / 512, this.currentPointY / 512, this.currentLayer, collisionBlockGround);
                int n = collisionBlockGround.getDegreeNearby(this.faceDegree);
                this.moveDistanceX = this.totalVelocity * MyAPI.dCos(n) / 100;
                this.moveDistanceY = this.totalVelocity * MyAPI.dSin(n) / 100;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.moveDistanceX = this.velX;
                this.moveDistanceY = this.velY;
            }
        }
        this.collisionChkBreak = false;
        if (!this.justLeaveLand) {
            this.justLeaveCount = 0;
        }
        if (this.justLeaveCount > 0) {
            --this.justLeaveCount;
        }
        if (this.justLeaveCount == 0) {
            this.justLeaveLand = false;
        }
        do {
            switch (this.collisionState) {
                case 0: {
                    this.collisionLogicOnGround();
                    break;
                }
                case 1: 
                case 3: {
                    this.collisionLogicInAir();
                    break;
                }
                case 2: {
                    this.collisionLogicOnObject();
                }
            }
        } while ((this.moveDistanceX != 0 || this.moveDistanceY != 0) && !this.collisionChkBreak);
        this.posX = this.footPointX - 512;
        this.posY = this.footPointY - 1536;
    }

    public void drawSonic(MFGraphics mFGraphics) {
        int n;
        int n2;
        int n3;
        int n4;
        Coordinate coordinate = MapManager.getCamera();
        if (this.hurtCount % 2 == 0) {
            if (this.animationID == 4) {
                n4 = this.getNewPointX(this.footPointX, 0, -512, this.faceDegree);
                n3 = this.getNewPointY(this.footPointY, 0, -512, this.faceDegree);
                n2 = this.getNewPointX(n4, 0, 512, 0);
                n = this.getNewPointY(n3, 0, 512, 0);
                this.drawer.draw(mFGraphics, ANIMATION_ID[this.animationID][0], (n2 >> 6) - coordinate.x, (n >> 6) - coordinate.y, ANIMATION_LOOP[this.animationID], 0);
            } else if (this.animationID == 6 || this.animationID == 7) {
                this.drawer.draw(mFGraphics, ANIMATION_ID[this.animationID][this.getAnimationOffset()], (this.footPointX >> 6) - coordinate.x, (this.footPointY >> 6) - coordinate.y, ANIMATION_LOOP[this.animationID], this.faceDirection ? 0 : 2);
            } else {
                this.drawer.draw(mFGraphics, ANIMATION_ID[this.animationID][this.getAnimationOffset()], (this.footPointX >> 6) - coordinate.x, (this.footPointY >> 6) - coordinate.y, ANIMATION_LOOP[this.animationID], this.getTrans());
            }
        } else {
            this.drawer.moveOn();
        }
        if (this.effectID > -1) {
            this.effectDrawer.draw(mFGraphics, this.effectID, (this.footPointX >> 6) - coordinate.x, (this.footPointY >> 6) - coordinate.y, EFFECT_LOOP[this.effectID], this.getTrans());
            if (this.effectDrawer.checkEnd()) {
                this.effectDrawer.restart();
                this.effectID = -1;
            }
        }
        n4 = this.faceDegree;
        n3 = -960;
        if (this.animationID == 11 && this.getAnimationOffset() == 1) {
            n4 = 0;
            n3 = -1408;
        } else if (this.animationID == 4 || this.animationID == 5 || this.animationID == 6 || this.animationID == 7 || this.animationID == 18 || this.animationID == 19 || this.animationID == 20) {
            n3 = -640;
        } else if (this.animationID == 25 || this.animationID == 26) {
            n3 = 0;
        }
        n2 = this.getNewPointX(this.footPointX, 0, n3, n4);
        n = this.getNewPointY(this.footPointY, 0, n3, n4);
        if (invincibleCount > 0) {
            if (invincibleDrawer != null) {
                this.drawInMap(mFGraphics, invincibleDrawer, n2, n);
            }
            if (GameObject.systemClock % 2L == 0L) {
                Effect.showEffect(invincibleAnimation, 1, (n2 >> 6) + MyRandom.nextInt(-3, 3), (n >> 6) + MyRandom.nextInt(-3, 3), 0);
            }
        } else if (sheildType > 0) {
            if (sheildType == 1) {
                this.drawInMap(mFGraphics, bariaDrawer, n2, n);
            } else if (this.isAttracting()) {
                this.drawInMap(mFGraphics, gBariaDrawer, n2, n);
            }
        }
        this.waterFallDraw(mFGraphics, coordinate);
        this.waterFlushDraw(mFGraphics);
        if (this.drawer.checkEnd()) {
            switch (this.animationID) {
                case 23: {
                    this.animationID = 22;
                    break;
                }
                case 22: {
                    this.animationID = 23;
                    break;
                }
                case 25: {
                    this.animationID = 26;
                    break;
                }
                case 26: {
                    this.animationID = 25;
                    break;
                }
                case 35: 
                case 37: {
                    StageManager.setStagePass();
                }
            }
        }
    }

    public int getAnimationOffset() {
        for (int i = 0; i < DEGREE_DIVIDE.length; ++i) {
            if (this.faceDegree >= DEGREE_DIVIDE[i]) continue;
            return i % 2;
        }
        return 0;
    }

    public int getTransId() {
        int n;
        for (n = 0; n < DEGREE_DIVIDE.length; ++n) {
            if (this.faceDegree >= DEGREE_DIVIDE[n]) continue;
            n %= 8;
            break;
        }
        return (n + 1) / 2 % 4;
    }

    public int getTrans() {
        int n = TRANS[this.getTransId()];
        int n2 = this.getAnimationOffset();
        if (this.faceDirection) {
            return n;
        }
        if (n2 == 0) {
            switch (n) {
                case 0: 
                case 3: 
                case 5: 
                case 6: {
                    n ^= 2;
                }
            }
        } else {
            switch (n) {
                case 0: {
                    n = 4;
                    break;
                }
                case 3: {
                    n = 7;
                    break;
                }
                case 5: {
                    n = 2;
                    break;
                }
                case 6: {
                    n = 1;
                }
            }
        }
        return n;
    }

    public int getFocusX() {
        return this.getNewPointX(this.footPointX, 0, -768, this.faceDegree) >> 6;
    }

    public int getFocusY() {
        if (FOCUS_MAX_OFFSET > 10) {
            if (this.focusMovingState == 0) {
                this.lookCount = 10;
            }
            if (this.lookCount == 0) {
                switch (this.focusMovingState) {
                    case 1: {
                        if (this.focusOffsetY >= FOCUS_MAX_OFFSET) break;
                        this.focusOffsetY += 15;
                        if (this.focusOffsetY <= FOCUS_MAX_OFFSET) break;
                        this.focusOffsetY = FOCUS_MAX_OFFSET;
                        break;
                    }
                    case 2: {
                        if (this.focusOffsetY <= -FOCUS_MAX_OFFSET) break;
                        this.focusOffsetY -= 15;
                        if (this.focusOffsetY >= -FOCUS_MAX_OFFSET) break;
                        this.focusOffsetY = -FOCUS_MAX_OFFSET;
                    }
                }
            } else {
                --this.lookCount;
                if (this.focusOffsetY > 0) {
                    this.focusOffsetY -= 15;
                    if (this.focusOffsetY < 0) {
                        this.focusOffsetY = 0;
                    }
                }
                if (this.focusOffsetY < 0) {
                    this.focusOffsetY += 15;
                    if (this.focusOffsetY > 0) {
                        this.focusOffsetY = 0;
                    }
                }
            }
        }
        return (this.getNewPointY(this.footPointY, 0, -768, this.faceDegree) >> 6) - this.focusOffsetY;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void collisionLogicInAir() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        block64: {
            boolean bl;
            block63: {
                this.onGround = false;
                this.faceDegree = 0;
                n8 = this.moveDistanceX;
                n7 = this.moveDistanceY;
                n6 = (Math.abs(n8) + 512 - 1) / 512;
                this.xFirst = n6 > (n5 = (Math.abs(n7) + 512 - 1) / 512);
                n4 = this.footPointX;
                n3 = this.footPointY;
                n2 = this.footPointX;
                n = this.footPointY;
                bl = false;
                if (n7 > 0) break block63;
                if (n7 >= 0) {
                    if (!this.collisionLogicBody(n8, n7, true)) return;
                    this.moveDistanceX = 0;
                    this.velX = 0;
                    return;
                }
                break block64;
            }
            int n9 = 0;
            while (n9 <= (this.xFirst ? n6 : n5)) {
                int n10;
                int n11;
                int n12;
                int n13;
                int n14;
                block67: {
                    block65: {
                        block66: {
                            if (!this.xFirst) break block65;
                            n14 = n2 + (n8 >= 0 ? 1 : -1) * 512 * n9;
                            n13 = (n * n6 + n7 * n9) / n6;
                            if (n8 <= 0) break block66;
                            if (n14 > n2 + n8) {
                                n14 = n2 + n8;
                                n13 = n + n7;
                            }
                            break block67;
                        }
                        if (n8 < 0) {
                            if (n14 < n2 + n8) {
                                n14 = n2 + n8;
                                n13 = n + n7;
                            }
                            break block67;
                        } else {
                            n14 = n2;
                        }
                        break block67;
                    }
                    n13 = n + (n7 >= 0 ? 1 : -1) * 512 * n9;
                    n14 = (n2 * n5 + n8 * n9) / n5;
                    if (n13 > n + n7) {
                        n14 = n2 + n8;
                        n13 = n + n7;
                    }
                }
                int n15 = this.getNewPointY(n13, 512, -512, this.faceDegree);
                int n16 = this.getNewPointX(n14, 512, -512, this.faceDegree);
                int n17 = this.rightSideCollisionChk(n16, n15);
                if (n17 >= 0) {
                    this.rightStopped = true;
                    n16 = n17;
                    n14 = this.footPointX = this.getNewPointX(n16, -512, 512, this.faceDegree);
                    n2 = this.footPointX;
                    if (n8 > 0) {
                        this.moveDistanceX = 0;
                        n8 = 0;
                        this.velX = 0;
                        this.xFirst = false;
                        this.collisionChkBreak = true;
                        if (this.collisionState == 2 && Key.repeat(Key.gRight)) {
                            this.animationID = 8;
                        }
                    }
                }
                n15 = this.getNewPointY(n13, -512, -512, this.faceDegree);
                n16 = this.getNewPointX(n14, -512, -512, this.faceDegree);
                n17 = this.leftSideCollisionChk(n16, n15);
                if (n17 >= 0) {
                    this.leftStopped = true;
                    n16 = n17;
                    n14 = this.footPointX = this.getNewPointX(n16, 512, 512, this.faceDegree);
                    n2 = this.footPointX;
                    if (n8 < 0) {
                        this.moveDistanceX = 0;
                        n8 = 0;
                        this.velX = 0;
                        this.xFirst = false;
                        this.collisionChkBreak = true;
                        if (this.collisionState == 2 && Key.repeat(Key.gLeft)) {
                            this.animationID = 8;
                        }
                    }
                }
                if ((n15 = this.headCollisionCheck(n14, n13 - 1536)) >= 0) {
                    CollisionBlock collisionBlock = collisionBlockSky;
                    n17 = collisionBlock.getDegreeNearby(this.faceDegree);
                    n12 = 360 - n17;
                    n11 = (this.moveDistanceX * MyAPI.dCos(n12) + this.moveDistanceY * MyAPI.dSin(n12)) / 100;
                    n10 = (this.velX * MyAPI.dCos(n12) + this.velY * MyAPI.dSin(n12)) / 100;
                    int n18 = (this.velX * MyAPI.dSin(n12) + this.velY * MyAPI.dCos(n12)) / 100;
                    int n19 = (this.moveDistanceX * MyAPI.dSin(n12) + this.moveDistanceY * MyAPI.dCos(n12)) / 100;
                    int n20 = Math.abs(this.faceDegree - n17);
                    if (n20 > 180) {
                        n20 = 360 - n20;
                    }
                    if (n18 < 0 && n20 < 50) {
                        n19 = 0;
                        this.footPointY = n13 = n15 + 1536;
                        this.footPointX = n14;
                        this.moveDistanceX = n11 * MyAPI.dCos(n17) / 100;
                        this.moveDistanceY = n11 * MyAPI.dSin(n17) / 100;
                        this.velX = n10 * MyAPI.dCos(n17) / 100;
                        this.velY = n10 * MyAPI.dSin(n17) / 100;
                        this.collisionChkBreak = true;
                        bl = true;
                    }
                }
                if (!this.justLeaveLand) {
                    n15 = 0;
                    for (int i = 0; i < 3; ++i) {
                        switch (i) {
                            case 0: {
                                this.footOffsetX = -384;
                                break;
                            }
                            case 1: {
                                this.footOffsetX = 384;
                                break;
                            }
                            case 2: {
                                this.footOffsetX = 0;
                                break;
                            }
                        }
                        n17 = this.downSideCollisionChk(n14 + this.footOffsetX, n13);
                        if (n17 < 0) continue;
                        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n14 + this.footOffsetX, 512), this.getQuaParam(n17, 512), this.currentLayer, collisionBlockSky);
                        if (collisionBlockSky.getDegreeNearby(this.faceDegree) != 0 && i < 2) continue;
                        this.onGround = true;
                        this.collisionState = 0;
                        n13 = this.footPointY = n17;
                        this.footPointX = n14;
                        this.collisionChkBreak = false;
                        this.moveDistance.x = (n14 >> 6) - (n4 >> 6);
                        this.moveDistance.y = (n13 >> 6) - (n3 >> 6);
                        n4 = n14;
                        n3 = n13;
                        n12 = n2 + n8 - n14;
                        n11 = n + n7 - n13;
                        if (this.collisionState == 2) {
                            this.moveDistanceX = n12;
                            this.moveDistanceY = n11;
                        } else if (this.collisionState != 1 && this.collisionState == 0) {
                            CollisionMap.getCollisionInfoWithBlock((n14 + this.footOffsetX) / 512, n13 / 512, this.currentLayer, collisionBlockSky);
                            this.faceDegree = collisionBlockSky.getDegreeNearby(this.faceDegree);
                            n10 = (n12 * MyAPI.dCos(this.faceDegree) + n11 * MyAPI.dSin(this.faceDegree)) / 100;
                            this.moveDistanceX = n12;
                            this.moveDistanceY = n11;
                            this.moveDistanceX = n10 * MyAPI.dCos(this.faceDegree) / 100;
                            this.moveDistanceY = n10 * MyAPI.dSin(this.faceDegree) / 100;
                            this.collisionState = 0;
                            this.calTotalVelocity();
                            this.land();
                        }
                        n15 = 1;
                        break;
                    }
                    if (n15 != 0) {
                        this.collisionCheckWithGameObject(n14, n13);
                        return;
                    }
                }
                if (n8 > 0) {
                    n15 = this.getNewPointY(n13, 512, -512, this.faceDegree);
                    int n21 = this.getNewPointX(n14, 512, -512, this.faceDegree);
                    n17 = this.rightSideCollisionChk(n21, n15);
                    if (n17 >= 0) {
                        this.rightStopped = true;
                        n21 = n17;
                        n14 = this.footPointX = this.getNewPointX(n21, -512, 512, this.faceDegree);
                        n2 = this.footPointX;
                        this.moveDistanceX = 0;
                        n8 = 0;
                        this.velX = 0;
                        this.xFirst = false;
                        this.collisionChkBreak = true;
                    }
                } else if (n8 < 0) {
                    n15 = this.getNewPointY(n13, -512, -512, this.faceDegree);
                    int n22 = this.getNewPointX(n14, -512, -512, this.faceDegree);
                    n17 = this.leftSideCollisionChk(n22, n15);
                    if (n17 >= 0) {
                        this.leftStopped = true;
                        n22 = n17;
                        n14 = this.footPointX = this.getNewPointX(n22, 512, 512, this.faceDegree);
                        n2 = this.footPointX;
                        this.moveDistanceX = 0;
                        n8 = 0;
                        this.velX = 0;
                        this.xFirst = false;
                        this.collisionChkBreak = true;
                    }
                }
                if (!bl) {
                    this.footPointX = n14;
                    this.footPointY = n13;
                    this.moveDistanceX = n8 - (this.footPointX - n2);
                    this.moveDistanceY = n7 - (this.footPointY - n);
                }
                this.moveDistance.x = (n14 >> 6) - (n4 >> 6);
                this.moveDistance.y = (n13 >> 6) - (n3 >> 6);
                n15 = this.collisionChkBreak ? 1 : 0;
                this.collisionCheckWithGameObject(n14, n13);
                n4 = n14;
                n3 = n13;
                this.collisionChkBreak |= n15;
                if (this.collisionChkBreak) {
                    this.collisionChkBreak = false;
                    this.onGround = true;
                    return;
                }
                ++n9;
            }
            return;
        }
        int n23 = 0;
        while (n23 <= (this.xFirst ? n6 : n5)) {
            int n24;
            int n25;
            int n26;
            block69: {
                block68: {
                    if (!this.xFirst) break block68;
                    n26 = n2 + (n8 >= 0 ? 1 : -1) * 512 * n23;
                    n25 = (n * n6 + n7 * n23) / n6;
                    if (n8 > 0) {
                        if (n26 > n2 + n8) {
                            n26 = n2 + n8;
                            n25 = n + n7;
                        }
                        break block69;
                    } else if (n8 < 0 && n26 < n2 + n8) {
                        n26 = n2 + n8;
                        n25 = n + n7;
                    }
                    break block69;
                }
                n25 = n + (n7 >= 0 ? 1 : -1) * 512 * n23;
                n26 = (n2 * n5 + n8 * n23) / n5;
                if (n25 < n + n7) {
                    n26 = n2 + n8;
                    n25 = n + n7;
                }
            }
            int n27 = this.getNewPointY(n25, 512, -512, this.faceDegree);
            int n28 = this.getNewPointX(n26, 512, -512, this.faceDegree);
            int n29 = this.rightSideCollisionChk(n28, n27);
            if (n29 >= 0) {
                this.rightStopped = true;
                n28 = n29;
                n26 = this.footPointX = this.getNewPointX(n28, -512, 512, this.faceDegree);
                n2 = this.footPointX;
                if (n8 > 0) {
                    this.moveDistanceX = 0;
                    n8 = 0;
                    this.velX = 0;
                    this.xFirst = false;
                    this.collisionChkBreak = true;
                }
            }
            n27 = this.getNewPointY(n25, -512, -512, this.faceDegree);
            n28 = this.getNewPointX(n26, -512, -512, this.faceDegree);
            n29 = this.leftSideCollisionChk(n28, n27);
            if (n29 >= 0) {
                this.leftStopped = true;
                n28 = n29;
                n26 = this.footPointX = this.getNewPointX(n28, 512, 512, this.faceDegree);
                n2 = this.footPointX;
                if (n8 < 0) {
                    this.moveDistanceX = 0;
                    n8 = 0;
                    this.velX = 0;
                    this.xFirst = false;
                    this.collisionChkBreak = true;
                }
            }
            if ((n27 = this.headCollisionCheck(n26, n25 -= 1536)) >= 0) {
                this.velY = 0;
                this.moveDistanceY = 0;
                n25 = n27;
                this.footPointY = n27 + 1536;
                this.footPointX = n26;
                this.collisionCheckWithGameObject(n26, this.footPointY);
                n4 = n26;
                n3 = this.footPointY;
                if (!this.squeezeFlag) return;
                if (this.collisionState != 2) return;
                this.setDie();
                return;
            }
            n25 += 1536;
            if (!this.justLeaveLand) {
                n28 = 0;
                for (n29 = 0; n29 < 3; ++n29) {
                    switch (n29) {
                        case 0: {
                            this.footOffsetX = -384;
                            break;
                        }
                        case 1: {
                            this.footOffsetX = 384;
                            break;
                        }
                        case 2: {
                            this.footOffsetX = 0;
                            break;
                        }
                    }
                    n24 = this.downSideCollisionChk(n26 + this.footOffsetX, n25);
                    if (n24 < 0) continue;
                    CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n26 + this.footOffsetX, 512), this.getQuaParam(n24, 512), this.currentLayer, collisionBlockSky);
                    CollisionBlock collisionBlock = collisionBlockSky;
                    if (collisionBlockSky.getDegreeNearby(this.faceDegree) != 0 && n29 < 2) continue;
                    int n30 = collisionBlock.getDegreeNearby(this.faceDegree);
                    int n31 = 360 - n30;
                    int n32 = (this.velX * MyAPI.dCos(n31) + this.velY * MyAPI.dSin(n31)) / 100;
                    int n33 = (this.velX * MyAPI.dSin(n31) + this.velY * MyAPI.dCos(n31)) / 100;
                    int n34 = Math.abs(this.faceDegree - n30);
                    if (n34 > 180) {
                        n34 = 360 - n34;
                    }
                    if (n33 <= 0 || n34 >= 50) continue;
                    this.onGround = true;
                    this.collisionState = 0;
                    n25 = this.footPointY = n24;
                    this.footPointX = n26;
                    this.collisionChkBreak = false;
                    this.moveDistance.x = (n26 >> 6) - (n4 >> 6);
                    this.moveDistance.y = (n25 >> 6) - (n3 >> 6);
                    n4 = n26;
                    n3 = n25;
                    int n35 = n2 + n8 - n26;
                    int n36 = n + n7 - n25;
                    if (this.collisionState == 2) {
                        this.moveDistanceX = n35;
                        this.moveDistanceY = n36;
                    } else if (this.collisionState != 1 && this.collisionState == 0) {
                        CollisionMap.getCollisionInfoWithBlock((n26 + this.footOffsetX) / 512, n25 / 512, this.currentLayer, collisionBlockSky);
                        this.faceDegree = collisionBlockSky.getDegreeNearby(this.faceDegree);
                        int n37 = (n35 * MyAPI.dCos(this.faceDegree) + n36 * MyAPI.dSin(this.faceDegree)) / 100;
                        this.moveDistanceX = n35;
                        this.moveDistanceY = n36;
                        this.moveDistanceX = n37 * MyAPI.dCos(this.faceDegree) / 100;
                        this.moveDistanceY = n37 * MyAPI.dSin(this.faceDegree) / 100;
                        this.collisionState = 0;
                        this.calTotalVelocity();
                        this.land();
                    }
                    n28 = 1;
                    break;
                }
                if (n28 != 0) {
                    this.collisionCheckWithGameObject(n26, n25);
                    return;
                }
            }
            if (n8 > 0) {
                n28 = this.getNewPointY(n25, 512, -512, this.faceDegree);
                n29 = this.getNewPointX(n26, 512, -512, this.faceDegree);
                n24 = this.rightSideCollisionChk(n29, n28);
                if (n24 >= 0) {
                    this.rightStopped = true;
                    n29 = n24;
                    n26 = this.footPointX = this.getNewPointX(n29, -512, 512, this.faceDegree);
                    n2 = this.footPointX;
                    this.moveDistanceX = 0;
                    n8 = 0;
                    this.velX = 0;
                    this.xFirst = false;
                    this.collisionChkBreak = true;
                }
            } else if (n8 < 0) {
                n28 = this.getNewPointY(n25, -512, -512, this.faceDegree);
                n29 = this.getNewPointX(n26, -512, -512, this.faceDegree);
                n24 = this.leftSideCollisionChk(n29, n28);
                if (n24 >= 0) {
                    this.leftStopped = true;
                    n29 = n24;
                    n26 = this.footPointX = this.getNewPointX(n29, 512, 512, this.faceDegree);
                    n2 = this.footPointX;
                    this.moveDistanceX = 0;
                    n8 = 0;
                    this.velX = 0;
                    this.xFirst = false;
                    this.collisionChkBreak = true;
                }
            }
            this.footPointX = n26;
            this.footPointY = n25;
            this.moveDistanceX = n8 - (this.footPointX - n2);
            this.moveDistanceY = n7 - (this.footPointY - n);
            this.moveDistance.x = (n26 >> 6) - (n4 >> 6);
            this.moveDistance.y = (n25 >> 6) - (n3 >> 6);
            n28 = this.collisionChkBreak ? 1 : 0;
            this.collisionCheckWithGameObject(n26, n25);
            n4 = n26;
            n3 = n25;
            this.collisionChkBreak |= n28;
            if (this.collisionChkBreak) {
                this.collisionChkBreak = false;
                this.onGround = true;
                return;
            }
            ++n23;
        }
    }

    public void collisionLogicOnGround() {
        int n;
        int n2 = this.footPointX;
        int n3 = this.footPointY;
        this.currentPointX = n2;
        this.currentPointY = n3;
        int n4 = this.getQuaParam(this.currentPointX + this.footOffsetX, 512);
        int n5 = this.getQuaParam(this.currentPointY, 512);
        boolean bl = false;
        this.mVelocity = this.totalVelocity;
        CollisionMap.getCollisionInfoWithBlock((this.currentPointX + this.footOffsetX) / 512, this.currentPointY / 512, this.currentLayer, collisionBlockGround);
        int n6 = n = collisionBlockGround.getDegreeNearby(this.faceDegree);
        boolean bl2 = n == 0;
        this.collisionChkBreak = false;
        while (true) {
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            boolean bl3;
            n2 = this.currentPointX;
            n3 = this.currentPointY;
            boolean bl4 = false;
            this.actualMoveDistanceX = 0;
            this.actualMoveDistanceY = 0;
            n = collisionBlockGround.getDegreeNearby(n6);
            boolean bl5 = true;
            int n14 = Math.abs(n6 - n);
            if (n14 > 180) {
                n14 = 360 - n14;
            }
            if (n14 >= 45) {
                this.footPointX = this.currentPointX;
                this.footPointY = this.currentPointY;
                this.justLeaveLand = true;
                this.justLeaveCount = 2;
                int n15 = this.totalVelocity;
                this.velX = n15 * MyAPI.dCos(n6) / 100;
                this.velY = n15 * MyAPI.dSin(n6) / 100;
                this.collisionState = 1;
                this.faceDegree = 0;
                break;
            }
            n6 = n;
            boolean bl6 = bl3 = !(n > 45 && n <= 135 || n > 225 && n <= 315);
            if (bl3) {
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                int n21;
                int n22;
                int n23;
                int n24;
                int n25;
                n13 = collisionBlockGround.getReverseY(this.currentPointX >> 6, collisionBlockGround.getDegreeNearby(this.faceDegree));
                if (this.moveDistanceX == 0) {
                    bl4 = true;
                } else {
                    if (this.moveDistanceX > 0) {
                        if (bl2) {
                            bl2 = false;
                        } else if (this.currentPointX + this.footOffsetX + this.moveDistanceX >> 6 >= this.getBlockLeftSide(n4 + 1, n5) >> 6) {
                            this.currentPointX = this.getBlockLeftSide(++n4, n5) - this.footOffsetX;
                        } else {
                            this.currentPointX += this.moveDistanceX;
                            bl4 = true;
                        }
                    } else if (bl2) {
                        bl2 = false;
                    } else if (this.currentPointX + this.footOffsetX + this.moveDistanceX >> 6 <= this.getBlockRightSide(n4 - 1, n5) >> 6) {
                        this.currentPointX = this.getBlockRightSide(--n4, n5) - this.footOffsetX;
                    } else {
                        this.currentPointX += this.moveDistanceX;
                        bl4 = true;
                    }
                    bl = false;
                    if (this.moveDistanceX > 0) {
                        n12 = this.rightSideMultiPointCollisionChk(this.currentPointX, this.currentPointY, 512, -512, this.faceDegree, -2);
                        if (n12 >= 0) {
                            this.calDivideVelocity(n6);
                            this.velX = 0;
                            this.calTotalVelocity(n6);
                            this.currentPointX = n12;
                            this.moveDistanceX = 0;
                            n4 = this.getQuaParam(this.currentPointX + this.footOffsetX, 512);
                            this.animationID = 8;
                            bl = true;
                        }
                    } else if (this.moveDistanceX < 0 && (n12 = this.leftSideMultiPointCollisionChk(this.currentPointX, this.currentPointY, -512, -512, this.faceDegree, -2)) >= 0) {
                        this.calDivideVelocity(n6);
                        this.velX = 0;
                        this.calTotalVelocity(n6);
                        this.currentPointX = n12;
                        this.moveDistanceX = 0;
                        n4 = this.getQuaParam(this.currentPointX + this.footOffsetX, 512);
                        this.animationID = 8;
                        bl = true;
                    }
                }
                CollisionMap.getCollisionInfoWithBlock(n4, n5, this.currentLayer, collisionBlockGround);
                n12 = this.currentPointX + this.footOffsetX;
                n11 = collisionBlockGround.getCollisionY(n12 >> 6);
                n10 = n5;
                n9 = n5;
                if (n6 == 0 || this.footOffsetX != 0) {
                    for (n8 = 0; n8 < 2; ++n8) {
                        n7 = 0;
                        switch (n8) {
                            case 0: {
                                n7 = -384;
                                break;
                            }
                            case 1: {
                                n7 = 384;
                                break;
                            }
                            case 2: {
                                n7 = 0;
                            }
                        }
                        n25 = this.currentPointX + n7;
                        n24 = this.getQuaParam(n25, 512);
                        CollisionMap.getCollisionInfoWithBlock(n24, n10, this.currentLayer, collisionBlockGroundTmp);
                        n23 = collisionBlockGroundTmp.getCollisionY(n25 >> 6);
                        n22 = collisionBlockGroundTmp.getDegreeNearby(n6);
                        if (n23 != 0 || n8 != 2 && n22 != 0) continue;
                        this.footOffsetX = n7;
                        n4 = n24;
                        n11 = n23;
                        break;
                    }
                }
                n7 = 0;
                n8 = 0;
                while (n11 == 0) {
                    if (n13 != 0) {
                        ++n10;
                    } else {
                        --n10;
                        n7 = 1;
                    }
                    CollisionMap.getCollisionInfoWithBlock(n4, n10, this.currentLayer, collisionBlockGround);
                    n11 = collisionBlockGround.getCollisionY(n12 >> 6);
                    if (n6 == 0 || this.footOffsetX != 0) {
                        for (n25 = 0; n25 < 2; ++n25) {
                            n24 = 0;
                            switch (n25) {
                                case 0: {
                                    n24 = -384;
                                    break;
                                }
                                case 1: {
                                    n24 = 384;
                                    break;
                                }
                                case 2: {
                                    n24 = 0;
                                }
                            }
                            n23 = this.currentPointX + n24;
                            n22 = this.getQuaParam(n23, 512);
                            CollisionMap.getCollisionInfoWithBlock(n22, n10, this.currentLayer, collisionBlockGroundTmp);
                            n21 = collisionBlockGroundTmp.getCollisionY(n23 >> 6);
                            n20 = collisionBlockGroundTmp.getDegreeNearby(n6);
                            if (n21 != 0 || n25 != 2 && n20 != 0) continue;
                            this.footOffsetX = n24;
                            n4 = n22;
                            n11 = n21;
                            break;
                        }
                    }
                    if (++n8 <= 3) continue;
                }
                n25 = Integer.MAX_VALUE;
                if (n6 == 0 || this.footOffsetX != 0) {
                    n24 = 0;
                    n23 = 0;
                    n22 = 0;
                    for (n21 = 0; n21 < 3; ++n21) {
                        n20 = 0;
                        switch (n21) {
                            case 0: {
                                n20 = -384;
                                break;
                            }
                            case 1: {
                                n20 = 384;
                                break;
                            }
                            case 2: {
                                n20 = 0;
                            }
                        }
                        n19 = this.currentPointX + n20;
                        n18 = this.getQuaParam(n19, 512);
                        CollisionMap.getCollisionInfoWithBlock(n18, n10, this.currentLayer, collisionBlockGroundTmp);
                        n17 = collisionBlockGroundTmp.getCollisionY(n19 >> 6);
                        if (n17 != -1) {
                            n = collisionBlockGroundTmp.getDegreeNearby(n6);
                            if (n != 0) {
                                this.footOffsetX = 0;
                                n20 = 0;
                                n19 = this.currentPointX + n20;
                                n4 = this.getQuaParam(n19, 512);
                                CollisionMap.getCollisionInfoWithBlock(n4, n10, this.currentLayer, collisionBlockGround);
                                n11 = collisionBlockGround.getCollisionY(n19 >> 6);
                                n24 = 0;
                                n = collisionBlockGround.getDegreeNearby(n6);
                                break;
                            }
                            n16 = this.getBlockUpSide(n18, n10) + (n17 << 6);
                            if (n16 >= n25) continue;
                            n25 = n16;
                            this.footOffsetX = n20;
                            n4 = n18;
                            n11 = n17;
                            collisionBlockGround.setProperty(collisionBlockGroundTmp);
                            n22 = n21;
                            n23 = 1;
                            continue;
                        }
                        if (n21 != 2) continue;
                        n24 = 1;
                    }
                    if (n24 != 0 && n23 != 0 && this.animationID == 0 && this.totalVelocity == 0 && n == 0) {
                        switch (n22) {
                            case 0: {
                                if (this.faceDirection) {
                                    this.animationID = 43;
                                    break;
                                }
                                this.animationID = 42;
                                break;
                            }
                            case 1: {
                                this.animationID = this.faceDirection ? 42 : 43;
                            }
                        }
                    }
                }
                n8 = 0;
                while (n11 == -1) {
                    if (n13 != 0) {
                        --n10;
                    } else {
                        if (n7 != 0 && collisionBlockGround.getDegreeNearby(n6) != 0) {
                            n11 = 8;
                            break;
                        }
                        ++n10;
                    }
                    CollisionMap.getCollisionInfoWithBlock(n4, n10, this.currentLayer, collisionBlockGround);
                    n11 = collisionBlockGround.getCollisionY(n12 >> 6);
                    if (n11 == 0 && n13 != 0 && collisionBlockGround.getActualY(n12 >> 6) == 8) {
                        n11 = 7;
                    }
                    if (n6 == 0 || this.footOffsetX != 0) {
                        n24 = 0;
                        n23 = 0;
                        n22 = 0;
                        for (n21 = 0; n21 < 3; ++n21) {
                            n20 = 0;
                            switch (n21) {
                                case 0: {
                                    n20 = -384;
                                    break;
                                }
                                case 1: {
                                    n20 = 384;
                                    break;
                                }
                                case 2: {
                                    n20 = 0;
                                }
                            }
                            n19 = this.currentPointX + n20;
                            n18 = this.getQuaParam(n19, 512);
                            CollisionMap.getCollisionInfoWithBlock(n18, n10, this.currentLayer, collisionBlockGroundTmp);
                            n17 = collisionBlockGroundTmp.getCollisionY(n19 >> 6);
                            if (n17 != -1) {
                                n = collisionBlockGroundTmp.getDegreeNearby(n6);
                                if (n != 0) {
                                    this.footOffsetX = 0;
                                    n20 = 0;
                                    n19 = this.currentPointX + n20;
                                    n4 = this.getQuaParam(n19, 512);
                                    CollisionMap.getCollisionInfoWithBlock(n4, n10, this.currentLayer, collisionBlockGround);
                                    n11 = collisionBlockGround.getCollisionY(n19 >> 6);
                                    n24 = 0;
                                    n = collisionBlockGround.getDegreeNearby(n6);
                                    break;
                                }
                                n16 = this.getBlockUpSide(n18, n10) + (n17 << 6);
                                if (n16 >= n25) continue;
                                n25 = n16;
                                this.footOffsetX = n20;
                                n4 = n18;
                                n11 = n17;
                                collisionBlockGround.setProperty(collisionBlockGroundTmp);
                                n22 = n21;
                                n23 = 1;
                                continue;
                            }
                            if (n21 != 2) continue;
                            n24 = 1;
                        }
                        if (n24 != 0 && n23 != 0 && n == 0 && this.animationID == 0 && this.totalVelocity == 0) {
                            switch (n22) {
                                case 0: {
                                    if (this.faceDirection) {
                                        this.animationID = 43;
                                        break;
                                    }
                                    this.animationID = 42;
                                    break;
                                }
                                case 1: {
                                    this.animationID = this.faceDirection ? 42 : 43;
                                }
                            }
                        }
                    }
                    if (++n8 <= 1) continue;
                }
                if (n11 != -1 && this.footOffsetX == 0) {
                    n = collisionBlockGround.getDegreeNearby(n6);
                    n14 = Math.abs(n6 - n);
                    if (n14 > 180) {
                        n14 = 360 - n14;
                    }
                } else {
                    n14 = Math.abs(n6 - n);
                    if (n14 > 180) {
                        n14 = 360 - n14;
                    }
                }
                if (n11 == -1 || n14 > 45 && n9 != n5) {
                    n10 = n13 != 0 ? ++n10 : --n10;
                    CollisionMap.getCollisionInfoWithBlock(n4, n10, this.currentLayer, collisionBlockGround);
                    n11 = collisionBlockGround.getCollisionY(this.currentPointX >> 6);
                    this.actualMoveDistanceX = this.currentPointX - n2;
                    this.actualMoveDistanceY = this.currentPointY - n3;
                    this.moveDistance.x = (this.currentPointX >> 6) - (n2 >> 6);
                    this.moveDistance.y = (this.currentPointY >> 6) - (n3 >> 6);
                    n24 = this.totalVelocity;
                    n23 = n6;
                    if (n6 != 0) {
                        this.justLeaveLand = true;
                        this.justLeaveDegree = n6;
                        this.justLeaveCount = 2;
                    } else if (this.justLeaveLand) {
                        n6 = this.justLeaveDegree;
                        this.justLeaveLand = false;
                    } else if (n != 0 && n14 <= 45) {
                        n23 = n;
                    }
                    this.velX = n24 * MyAPI.dCos(n23) / 100;
                    this.velY = n24 * MyAPI.dSin(n23) / 100;
                    this.footPointX = this.currentPointX;
                    this.footPointY = this.currentPointY;
                    n22 = this.getNewPointX(this.footPointX, 0, -this.collisionRect.getHeight() >> 1, this.faceDegree);
                    n21 = this.getNewPointY(this.footPointY, 0, -this.collisionRect.getHeight() >> 1, this.faceDegree);
                    this.faceDegree = 0;
                    this.footPointX = this.getNewPointX(n22, 0, this.collisionRect.getHeight() >> 1, this.faceDegree);
                    this.footPointY = this.getNewPointY(n21, 0, this.collisionRect.getHeight() >> 1, this.faceDegree);
                    this.faceDegree = 0;
                    this.collisionCheckWithGameObject(this.currentPointX, this.currentPointY);
                    this.moveDistanceX -= this.actualMoveDistanceX;
                    this.moveDistanceY -= this.actualMoveDistanceY;
                    n20 = this.mVelocity;
                    this.mVelocity = (this.moveDistanceX * MyAPI.dCos(n23) + this.moveDistanceY * MyAPI.dSin(n23)) / 100;
                    if (this.mVelocity * n20 < 0) {
                        this.mVelocity = -this.mVelocity;
                    }
                    this.moveDistanceX = this.mVelocity * MyAPI.dCos(n23) / 100;
                    this.moveDistanceY = this.mVelocity * MyAPI.dSin(n23) / 100;
                    this.collisionState = 1;
                    break;
                }
                this.sYPosition = n11;
                this.sXPosition = (this.currentPointX >> 6) % 8;
                this.currentPointY = this.getBlockUpSide(n4, n10) + (n11 << 6);
                this.sBlockX = n4;
                this.sBlockY = n10;
                n5 = n10;
            } else {
                n13 = collisionBlockGround.getReverseX(this.currentPointY >> 6, collisionBlockGround.getDegreeNearby(this.faceDegree));
                if (this.moveDistanceY == 0) {
                    bl4 = true;
                } else if (this.moveDistanceY > 0) {
                    if (this.currentPointY + this.moveDistanceY >> 6 >= this.getBlockUpSide(n4, n5 + 1) >> 6) {
                        this.currentPointY = this.getBlockUpSide(n4, ++n5);
                    } else {
                        this.currentPointY += this.moveDistanceY;
                        bl4 = true;
                    }
                } else if (this.currentPointY + this.moveDistanceY >> 6 <= this.getBlockDownSide(n4, n5 - 1) >> 6) {
                    this.currentPointY = this.getBlockDownSide(n4, --n5);
                } else {
                    this.currentPointY += this.moveDistanceY;
                    bl4 = true;
                }
                CollisionMap.getCollisionInfoWithBlock(n4, n5, this.currentLayer, collisionBlockGround);
                n12 = collisionBlockGround.getCollisionX(this.currentPointY >> 6);
                n11 = n4;
                n10 = 0;
                while (n12 == 0) {
                    n11 = n13 != 0 ? ++n11 : --n11;
                    CollisionMap.getCollisionInfoWithBlock(n11, n5, this.currentLayer, collisionBlockGround);
                    n12 = collisionBlockGround.getCollisionX(this.currentPointY >> 6);
                    if (++n10 <= 3) continue;
                }
                n10 = 0;
                while (n12 == -1) {
                    n11 = n13 != 0 ? --n11 : ++n11;
                    CollisionMap.getCollisionInfoWithBlock(n11, n5, this.currentLayer, collisionBlockGround);
                    n12 = collisionBlockGround.getCollisionX(this.currentPointY >> 6);
                    if (++n10 <= 1) continue;
                }
                if (n12 != -1 && this.footOffsetX == 0 && (n14 = Math.abs(n6 - (n = collisionBlockGround.getDegreeNearby(n6)))) > 180) {
                    n14 = 360 - n14;
                }
                if (n12 == -1 || (n6 == 90 || n6 == 270 || n == 90 || n == 270) && n14 >= 30) {
                    n11 = n13 != 0 ? ++n11 : --n11;
                    CollisionMap.getCollisionInfoWithBlock(n11, n5, this.currentLayer, collisionBlockGround);
                    n12 = collisionBlockGround.getCollisionX(this.currentPointY >> 6);
                    this.actualMoveDistanceX = this.currentPointX - n2;
                    this.actualMoveDistanceY = this.currentPointY - n3;
                    this.moveDistance.x = (this.currentPointX >> 6) - (n2 >> 6);
                    this.moveDistance.y = (this.currentPointY >> 6) - (n3 >> 6);
                    this.footPointX = this.currentPointX;
                    this.footPointY = this.currentPointY;
                    n9 = this.totalVelocity;
                    this.velX = n9 * MyAPI.dCos(this.faceDegree) / 100;
                    this.velY = n9 * MyAPI.dSin(this.faceDegree) / 100;
                    this.collisionCheckWithGameObject(this.currentPointX, this.currentPointY);
                    this.moveDistanceX -= this.actualMoveDistanceX;
                    this.moveDistanceY -= this.actualMoveDistanceY;
                    n8 = this.getNewPointX(this.footPointX, 0, -512, this.faceDegree);
                    n7 = this.getNewPointY(this.footPointY, 0, -512, this.faceDegree);
                    this.faceDegree = 0;
                    this.footPointX = this.getNewPointX(n8, 0, this.collisionRect.getHeight() >> 1, this.faceDegree);
                    this.footPointY = this.getNewPointY(n7, 0, this.collisionRect.getHeight() >> 1, this.faceDegree);
                    this.collisionState = 1;
                    break;
                }
                if (n12 == 0 && n13 != 0 && collisionBlockGround.getActualX(this.currentPointY >> 6) == 8) {
                    n12 = 7;
                }
                this.sXPosition = n12;
                this.sYPosition = (this.currentPointY >> 6) % 8;
                this.currentPointX = this.getBlockLeftSide(n11, n5) + (n12 << 6);
                this.sBlockX = n11;
                this.sBlockY = n5;
                n4 = n11;
            }
            this.actualMoveDistanceX = this.currentPointX - n2;
            this.actualMoveDistanceY = this.currentPointY - n3;
            this.moveDistance.x = (this.currentPointX >> 6) - (n2 >> 6);
            this.moveDistance.y = (this.currentPointY >> 6) - (n3 >> 6);
            this.moveDistanceX -= this.actualMoveDistanceX;
            this.moveDistanceY -= this.actualMoveDistanceY;
            this.moveDistanceX = this.moveDistanceX >> 6 << 6;
            this.moveDistanceY = this.moveDistanceY >> 6 << 6;
            if (bl) {
                this.moveDistanceX = 0;
            }
            n2 = this.currentPointX;
            n3 = this.currentPointY;
            n4 = this.getQuaParam(this.currentPointX + this.footOffsetX, 512);
            n5 = this.getQuaParam(this.currentPointY, 512);
            this.faceDegree = collisionBlockGround.getDegreeNearby(n6);
            this.footPointX = this.currentPointX;
            this.footPointY = this.currentPointY;
            this.collisionCheckWithGameObject(this.currentPointX, this.currentPointY);
            n13 = this.mVelocity;
            this.mVelocity = (this.moveDistanceX * MyAPI.dCos(this.faceDegree) + this.moveDistanceY * MyAPI.dSin(this.faceDegree)) / 100;
            if (this.mVelocity * n13 < 0) {
                this.mVelocity = -this.mVelocity;
            }
            this.moveDistanceX = this.mVelocity * MyAPI.dCos(this.faceDegree) / 100;
            this.moveDistanceY = this.mVelocity * MyAPI.dSin(this.faceDegree) / 100;
            if (bl4) {
                this.moveDistanceX = 0;
                this.moveDistanceY = 0;
            }
            if (bl4 || this.collisionChkBreak) {
                this.faceDegree = collisionBlockGround.getDegreeNearby(n6);
                this.collisionChkBreak = false;
                break;
            }
            bl2 = false;
        }
    }

    public void collisionLogicOnObject() {
        this.onObjectContinue = false;
        this.checkedObject = false;
        this.footObjectLogic = false;
        this.collisionLogicInAir();
        this.moveDistanceX = 0;
        this.moveDistanceY = 0;
        if (!this.checkedObject && this.footOnObject != null && this.footOnObject.onObjectChk(this)) {
            this.footOnObject.doWhileCollisionWrap(this);
            this.onObjectContinue = true;
        }
        if (!this.onObjectContinue) {
            this.footOnObject = null;
            this.calTotalVelocity();
            if (this.collisionState == 2) {
                this.collisionState = 1;
            }
            return;
        }
        if (this.collisionState == 2) {
            this.velY = 0;
            this.moveDistanceY = 0;
        }
    }

    public boolean collisionLogicBody(int n, int n2, boolean bl) {
        block18: {
            int n3;
            int n4;
            block19: {
                int n5;
                if (!bl) break block18;
                n4 = (Math.abs(n) + 512 - 1) / 512;
                if (n <= 0) break block19;
                int n6 = this.getNewPointY(this.footPointY, 512, -512, this.faceDegree);
                int n7 = n5 = this.getNewPointX(this.footPointX, 512, -512, this.faceDegree);
                int n8 = n6;
                int n9 = n5;
                int n10 = n6;
                for (int i = 0; i <= n4; ++i) {
                    int n11 = n5 + 512 * i;
                    int n12 = (n6 * n4 + n2 * i) / n4;
                    if (n11 > n9 + n) {
                        n11 = n9 + n;
                        n12 = n10 + n2;
                    }
                    int n13 = this.rightSideCollisionChk(n11, n12);
                    int n14 = this.rightSideCollisionChk(n11, n12 - 512);
                    if (n13 < 0) {
                        n13 = n14;
                    } else if (n14 >= 0) {
                        n13 = Math.min(n13, n14);
                    }
                    if (n13 >= 0) {
                        this.rightStopped = true;
                        n5 = n13;
                        this.moveDistanceX = 0;
                        this.footPointX = this.getNewPointX(n5, -512, 512, this.faceDegree);
                        return true;
                    }
                    this.moveDistance.x = (n11 >> 6) - (n7 >> 6);
                    this.moveDistance.y = (n12 >> 6) - (n8 >> 6);
                    this.footPointX = this.getNewPointX(n11, -512, 512, this.faceDegree);
                    this.footPointY = this.getNewPointY(n12, -512, 512, this.faceDegree);
                    int n15 = this.headCollisionCheck(n11, n12 - 1536);
                    if (n15 >= 0) {
                        CollisionBlock collisionBlock = collisionBlockSky;
                        int n16 = collisionBlock.getDegreeNearby(this.faceDegree);
                        int n17 = 360 - n16;
                        int n18 = (this.moveDistanceX * MyAPI.dCos(n17) + this.moveDistanceY * MyAPI.dSin(n17)) / 100;
                        int n19 = (this.velX * MyAPI.dCos(n17) + this.velY * MyAPI.dSin(n17)) / 100;
                        int n20 = (this.velX * MyAPI.dSin(n17) + this.velY * MyAPI.dCos(n17)) / 100;
                        int n21 = (this.moveDistanceX * MyAPI.dSin(n17) + this.moveDistanceY * MyAPI.dCos(n17)) / 100;
                        int n22 = Math.abs(this.faceDegree - n16);
                        if (n22 > 180) {
                            n22 = 360 - n22;
                        }
                        if (n21 < 0 && n22 < 50) {
                            n21 = 0;
                            this.footPointY = n12 = n15 + 1536;
                            this.moveDistanceX = n18 * MyAPI.dCos(n16) / 100;
                            this.moveDistanceY = n18 * MyAPI.dSin(n16) / 100;
                            this.velX = n19 * MyAPI.dCos(n16) / 100;
                            this.velY = n19 * MyAPI.dSin(n16) / 100;
                            this.collisionCheckWithGameObject(this.footPointX, this.footPointY);
                            n7 = n11;
                            n8 = n12;
                            return false;
                        }
                    }
                    this.moveDistanceX = n - (n11 - n9);
                    this.moveDistanceY = n2 - (n12 - n10);
                    this.collisionCheckWithGameObject(this.footPointX, this.footPointY);
                    n7 = n11;
                    n8 = n12;
                }
                break block18;
            }
            if (n >= 0) break block18;
            int n23 = this.getNewPointY(this.footPointY, -512, -512, this.faceDegree);
            int n24 = n3 = this.getNewPointX(this.footPointX, -512, -512, this.faceDegree);
            int n25 = n23;
            int n26 = n3;
            int n27 = n23;
            for (int i = 0; i <= n4; ++i) {
                int n28 = n3 - 512 * i;
                int n29 = (n23 * n4 + n2 * i) / n4;
                if (n28 < n26 + n) {
                    n28 = n26 + n;
                    n29 = n27 + n2;
                }
                int n30 = this.leftSideCollisionChk(n28, n29);
                int n31 = this.leftSideCollisionChk(n28, n29 - 512);
                if (n30 < 0) {
                    n30 = n31;
                } else if (n31 >= 0) {
                    n30 = Math.max(n30, n31);
                }
                if (n30 >= 0) {
                    this.leftStopped = true;
                    n3 = n30;
                    this.moveDistanceX = 0;
                    this.footPointX = this.getNewPointX(n3, 512, 512, this.faceDegree);
                    return true;
                }
                this.moveDistance.x = n28 - n24 >> 6;
                this.moveDistance.y = n29 - n25 >> 6;
                this.footPointX = this.getNewPointX(n28, 512, 512, this.faceDegree);
                this.footPointY = this.getNewPointY(n29, 512, 512, this.faceDegree);
                int n32 = this.headCollisionCheck(n28, n29 - 1536);
                if (n32 >= 0) {
                    CollisionBlock collisionBlock = collisionBlockSky;
                    int n33 = collisionBlock.getDegreeNearby(this.faceDegree);
                    int n34 = 360 - n33;
                    int n35 = (this.moveDistanceX * MyAPI.dCos(n34) + this.moveDistanceY * MyAPI.dSin(n34)) / 100;
                    int n36 = (this.velX * MyAPI.dCos(n34) + this.velY * MyAPI.dSin(n34)) / 100;
                    int n37 = (this.velX * MyAPI.dSin(n34) + this.velY * MyAPI.dCos(n34)) / 100;
                    int n38 = (this.moveDistanceX * MyAPI.dSin(n34) + this.moveDistanceY * MyAPI.dCos(n34)) / 100;
                    int n39 = Math.abs(this.faceDegree - n33);
                    if (n39 > 180) {
                        n39 = 360 - n39;
                    }
                    if (n38 < 0 && n39 < 50) {
                        n38 = 0;
                        this.footPointY = n29 = n32 + 1536;
                        this.moveDistanceX = n35 * MyAPI.dCos(n33) / 100;
                        this.moveDistanceY = n35 * MyAPI.dSin(n33) / 100;
                        this.velX = n36 * MyAPI.dCos(n33) / 100;
                        this.velY = n36 * MyAPI.dSin(n33) / 100;
                        this.collisionCheckWithGameObject(this.footPointX, this.footPointY);
                        n24 = n28;
                        n25 = n29;
                        return false;
                    }
                }
                this.moveDistanceX = n - (n28 - n26);
                this.moveDistanceY = n2 - (n29 - n27);
                this.collisionCheckWithGameObject(this.footPointX, this.footPointY);
                n24 = n28;
                n25 = n29;
            }
        }
        return false;
    }

    public void calDivideVelocity() {
        this.calDivideVelocity(this.faceDegree);
    }

    public void calDivideVelocity(int n) {
        this.velX = this.totalVelocity * MyAPI.dCos(n) / 100;
        this.velY = this.totalVelocity * MyAPI.dSin(n) / 100;
    }

    public void calTotalVelocity() {
        this.calTotalVelocity(this.faceDegree);
    }

    public void calTotalVelocity(int n) {
        this.totalVelocity = (this.velX * MyAPI.dCos(n) + this.velY * MyAPI.dSin(n)) / 100;
    }

    public int headCollisionCheck(int n, int n2) {
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    n3 = -384;
                    break;
                }
                case 1: {
                    n3 = 384;
                    break;
                }
                case 2: {
                    n3 = 0;
                }
            }
            int n5 = n2 / 512;
            CollisionMap.getCollisionInfoWithBlock((n + n3) / 512, n5, this.currentLayer, collisionBlockSky);
            int n6 = collisionBlockSky.getCollisionY(n + n3 >> 6);
            if (n6 < 0) continue;
            if (n6 == 0) {
                n6 = 8;
            }
            n4 = n5 * 512 + (n6 << 6);
            int n7 = 0;
            if (PlayerObject.collisionBlockSky.attr) {
                return -1;
            }
            ++n5;
            while (!PlayerObject.collisionBlockSky.attr && n7 < 3) {
                CollisionMap.getCollisionInfoWithBlock((n + n3) / 512, n5, this.currentLayer, collisionBlockSky);
                n6 = collisionBlockSky.getCollisionY(n + n3 >> 6);
                if (n6 < 0) break;
                if (n6 == 0) {
                    n6 = 8;
                }
                n4 = n5 * 512 + (n6 << 6);
                ++n7;
                ++n5;
            }
            CollisionMap.getCollisionInfoWithBlock((n + n3) / 512, --n5, this.currentLayer, collisionBlockSky);
            return n4;
        }
        return -1;
    }

    public int rightSideCollisionChk(int n, int n2) {
        int n3;
        int n4 = 0;
        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512) - 1, this.getQuaParam(n2, 512), this.currentLayer, tmpBeforeBlock);
        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), this.getQuaParam(n2, 512), this.currentLayer, tmpCurrentBlock);
        int n5 = tmpBeforeBlock.getCollisionX(n2 >> 6);
        int n6 = tmpCurrentBlock.getCollisionX(n2 >> 6);
        if ((n5 < 0 || PlayerObject.tmpBeforeBlock.attr) && n6 >= 0) {
            n3 = Math.abs(this.faceDegree - tmpCurrentBlock.getDegreeNearby(this.faceDegree));
            if (n3 > 180) {
                n3 = 360 - n3;
            }
            int n7 = 0;
            int n8 = tmpBeforeBlock.getCollisionY(7);
            int n9 = tmpCurrentBlock.getCollisionY(0);
            n7 = Math.abs(n8 - n9);
            if ((n3 >= 50 || this.faceDegree == 0 && (n8 < 0 || n7 >= 4) && (tmpCurrentBlock.getDegreeNearby(this.faceDegree) == 0 || n3 >= 50) || PlayerObject.tmpBeforeBlock.attr && !PlayerObject.tmpCurrentBlock.attr) && n >= (n4 = this.getBlockLeftSide(this.getQuaParam(n, 512), this.getQuaParam(n2, 512)) + (n6 << 6))) {
                return n4;
            }
        }
        if (tmpBeforeBlock.getActualX(n2 >> 6) == 8 && tmpCurrentBlock.getActualX(n2 >> 6) != 8) {
            return -1;
        }
        if (n6 == 0 && n5 >= 0) {
            n3 = Math.abs(this.faceDegree - tmpBeforeBlock.getDegreeNearby(this.faceDegree));
            if (n3 > 180) {
                n3 = 360 - n3;
            }
            if (n3 >= 50 && n >= (n4 = this.getBlockLeftSide(this.getQuaParam(n, 512) - 1, this.getQuaParam(n2, 512)) + (n5 << 6))) {
                return n4;
            }
        }
        return -1;
    }

    public int leftSideCollisionChk(int n, int n2) {
        int n3;
        int n4 = 0;
        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512) + 1, this.getQuaParam(n2, 512), this.currentLayer, tmpBeforeBlock);
        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), this.getQuaParam(n2, 512), this.currentLayer, tmpCurrentBlock);
        int n5 = tmpBeforeBlock.getCollisionX(n2 >> 6);
        int n6 = tmpCurrentBlock.getCollisionX(n2 >> 6);
        if ((n5 < 0 || PlayerObject.tmpBeforeBlock.attr) && n6 >= 0) {
            n3 = tmpCurrentBlock.getDegreeNearby(this.faceDegree);
            int n7 = Math.abs(this.faceDegree - n3);
            if (n7 > 180) {
                n7 = 360 - n7;
            }
            int n8 = 0;
            int n9 = tmpBeforeBlock.getCollisionY(0);
            int n10 = tmpCurrentBlock.getCollisionY(7);
            n8 = Math.abs(n9 - n10);
            if (n7 >= 50 || this.faceDegree == 0 && (n9 < 0 || n8 >= 4) && n3 == 0 || PlayerObject.tmpBeforeBlock.attr && !PlayerObject.tmpCurrentBlock.attr) {
                if (n6 == 0) {
                    n6 = 7;
                }
                if (n <= (n4 = this.getBlockLeftSide(this.getQuaParam(n, 512), this.getQuaParam(n2, 512)) + (n6 << 6) + 64)) {
                    return n4;
                }
            }
        }
        if (tmpBeforeBlock.getActualX(n2 >> 6) == 8 && tmpCurrentBlock.getActualX(n2 >> 6) != 8) {
            return -1;
        }
        if (n6 == 0 && n5 >= 0) {
            n3 = Math.abs(this.faceDegree - tmpBeforeBlock.getDegreeNearby(this.faceDegree));
            if (n3 > 180) {
                n3 = 360 - n3;
            }
            if (n3 >= 50) {
                if (n5 == 0) {
                    n5 = 7;
                }
                if (n <= (n4 = this.getBlockLeftSide(this.getQuaParam(n, 512) + 1, this.getQuaParam(n2, 512)) + (n5 << 6) + 64)) {
                    return n4;
                }
            }
        }
        return -1;
    }

    public int downSideCollisionChk(int n, int n2) {
        CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), this.getQuaParam(n2, 512), this.currentLayer, tmpCurrentBlock);
        int n3 = tmpCurrentBlock.getCollisionY(n >> 6);
        boolean bl = tmpCurrentBlock.getReverseY(n >> 6, tmpCurrentBlock.getDegreeNearby(this.faceDegree));
        if (n3 >= 0) {
            if (bl && n3 == 0) {
                n3 = 8;
            }
            int n4 = this.getBlockUpSide(this.getQuaParam(n, 512), this.getQuaParam(n2, 512)) + (n3 << 6);
            int n5 = this.getQuaParam(n2, 512);
            if (n2 >= n4 && !bl || n2 <= n4 && bl) {
                while (n3 >= 0) {
                    n4 = this.getBlockUpSide(this.getQuaParam(n, 512), n5) + (n3 << 6);
                    CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), --n5, this.currentLayer, tmpCurrentBlock);
                    n3 = tmpCurrentBlock.getCollisionY(n >> 6);
                }
                CollisionMap.getCollisionInfoWithBlock(this.getQuaParam(n, 512), this.getQuaParam(n4, 512), this.currentLayer, tmpCurrentBlock);
                int n6 = Math.abs(this.faceDegree - tmpCurrentBlock.getDegreeNearby(this.faceDegree));
                if (n6 > 180) {
                    n6 = 360 - n6;
                }
                return n4;
            }
        }
        return -1;
    }

    public int getNewPointX(int n, int n2, int n3, int n4) {
        int n5 = n + n2 * MyAPI.dCos(n4) / 100 - n3 * MyAPI.dSin(n4) / 100;
        return n5;
    }

    public int getNewPointY(int n, int n2, int n3, int n4) {
        int n5 = n + n2 * MyAPI.dSin(n4) / 100 + n3 * MyAPI.dCos(n4) / 100;
        return n5;
    }

    public int rightSideMultiPointCollisionChk(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 > 90 && n5 < 270) {
            n3 = -n3;
        }
        for (int i = 0; i < Math.abs(n6); ++i) {
            int n7 = this.getNewPointY(n2, n3, n4 + i * (8 * n6 / Math.abs(n6) << 6), n5);
            int n8 = this.getNewPointX(n, n3, n4 + i * (8 * n6 / Math.abs(n6) << 6), n5);
            int n9 = this.rightSideCollisionChk(n8, n7);
            if (n9 < 0) continue;
            return this.getNewPointX(n9, -n3, -(n4 + i * (8 * n6 / Math.abs(n6) << 6)), n5);
        }
        return -1;
    }

    public int leftSideMultiPointCollisionChk(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 > 90 && n5 < 270) {
            n3 = -n3;
        }
        for (int i = 0; i < Math.abs(n6); ++i) {
            int n7 = this.getNewPointY(n2, n3, n4 + i * (8 * n6 / Math.abs(n6) << 6), n5);
            int n8 = this.getNewPointX(n, n3, n4 + i * (8 * n6 / Math.abs(n6) << 6), n5);
            int n9 = this.leftSideCollisionChk(n8, n7);
            if (n9 < 0) continue;
            return this.getNewPointX(n9, -n3, -(n4 + i * (8 * n6 / Math.abs(n6) << 6)), n5);
        }
        return -1;
    }

    public void inputLogicWalk() {
        int n;
        int n2;
        this.firstJump = false;
        if (this.slipFlag || this.totalVelocity != 0) {
            int n3 = n2 = this.animationID != 4 ? FAKE_GRAVITY_ON_WALK : FAKE_GRAVITY_ON_BALL;
            if (this.slipFlag) {
                n2 *= 3;
            }
            n = n2 * MyAPI.dSin(this.faceDegree) / 100;
            if (this.slipFlag && Math.abs(n) < 50) {
                int n4 = n = n < 0 ? -50 : 50;
            }
            if (this.animationID == 4) {
                if (this.totalVelocity >= 0) {
                    if (n < 0) {
                        n >>= 2;
                    }
                } else if (n > 0) {
                    n >>= 2;
                }
            }
            this.totalVelocity += n;
        }
        if (this.fallTime == 0 && this.attackLevel == 0) {
            if (Key.repeat(Key.gLeft)) {
                this.faceDirection = false;
                if (this.totalVelocity <= 0) {
                    if (this.animationID != 4) {
                        this.totalVelocity -= this.movePower;
                        if (this.totalVelocity < -this.maxVelocity) {
                            this.totalVelocity += this.movePower;
                            if (this.totalVelocity > -this.maxVelocity) {
                                this.totalVelocity = -this.maxVelocity;
                            }
                        }
                    }
                } else {
                    n2 = this.animationID == 4 ? this.movePowerReserseBall : this.movePowerReverse;
                    this.totalVelocity -= n2;
                    if (this.totalVelocity < 0) {
                        if (this.onBank) {
                            this.totalVelocity = 0;
                            this.onBank = false;
                        } else {
                            this.totalVelocity = 0 - n2 >> 2;
                        }
                    } else {
                        this.faceDirection = true;
                    }
                    if (Math.abs(this.totalVelocity) > 1100 && this.animationID != 4 && this.animationID != 17) {
                        GameObject.soundInstance.playSe(2);
                    }
                }
            } else if (Key.repeat(Key.gRight) || this.isTerminal) {
                this.faceDirection = true;
                if (this.totalVelocity >= 0) {
                    if (this.animationID != 4) {
                        this.totalVelocity += this.movePower;
                        if (this.totalVelocity > this.maxVelocity) {
                            this.totalVelocity -= this.movePower;
                            if (this.totalVelocity < this.maxVelocity) {
                                this.totalVelocity = this.maxVelocity;
                            }
                        }
                    }
                } else {
                    n2 = this.animationID == 4 ? this.movePowerReserseBall : this.movePowerReverse;
                    this.totalVelocity += n2;
                    if (this.totalVelocity > -1) {
                        if (this.onBank) {
                            this.totalVelocity = 0;
                            this.onBank = false;
                        } else {
                            this.totalVelocity = n2 >> 2;
                        }
                    } else {
                        this.faceDirection = false;
                    }
                    if (Math.abs(this.totalVelocity) > 1100 && this.animationID != 4 && this.animationID != 17) {
                        GameObject.soundInstance.playSe(2);
                    }
                }
            }
        }
        if (Math.abs(this.totalVelocity) <= 0) {
            if (this.animationID != 38 && this.animationID != 39 && this.animationID != 40) {
                this.animationID = 0;
            }
        } else if (this.animationID != 4 && this.animationID != 35 && this.animationID != 36) {
            this.animationID = Math.abs(this.totalVelocity) < 160 ? 1 : (Math.abs(this.totalVelocity) < 1040 ? 2 : 3);
        }
        if (this.attackCount > 0) {
            --this.attackCount;
        }
        switch (this.attackAnimationID) {
            case 18: {
                if (this.attackCount == 0) {
                    if (this.attackLevel >= 2) {
                        this.animationID = 19;
                        this.ignoreFirstTouch = true;
                        this.setVelX(this.faceDirection ? 700 : -700);
                    } else {
                        this.attackLevel = 0;
                    }
                } else {
                    this.animationID = 18;
                    this.ignoreFirstTouch = true;
                }
                if (!Key.press(Key.gSelect)) break;
                this.attackLevel = 2;
                break;
            }
            case 19: {
                if (this.drawer.checkEnd()) {
                    if (this.attackLevel >= 3) {
                        this.animationID = 20;
                        this.ignoreFirstTouch = true;
                        this.setVelX(this.faceDirection ? 900 : -900);
                        this.attackCount = 6;
                    } else {
                        this.attackLevel = 0;
                    }
                } else {
                    this.animationID = 19;
                    this.ignoreFirstTouch = true;
                }
                if (!Key.press(Key.gSelect)) break;
                this.attackLevel = 3;
                GameObject.soundInstance.playSe(2);
                break;
            }
            case 20: {
                if (this.attackCount == 0) {
                    this.attackLevel = 0;
                    this.setVelX(0);
                    break;
                }
                this.animationID = 20;
                this.ignoreFirstTouch = true;
                break;
            }
            default: {
                if (this.animationID == 4 || Key.repeat(Key.gDown) || !Key.press(Key.gSelect)) break;
                this.attackLevel = 1;
                this.attackCount = 6;
                this.animationID = 18;
                this.setVelX(this.faceDirection ? 500 : -500);
                this.ignoreFirstTouch = true;
            }
        }
        this.attackAnimationID = this.animationID;
        if (this.attackLevel == 0 && this.animationID != 4 && (!Key.repeat(Key.gLeft) || !Key.repeat(Key.gRight)) && (Key.repeat(Key.gLeft) && this.faceDirection || Key.repeat(Key.gRight) && !this.faceDirection)) {
            this.animationID = 17;
        }
        if (this.slipping) {
            if (this.totalVelocity < 640) {
                this.totalVelocity = 640;
            }
            this.animationID = 11;
            this.faceDirection = true;
        }
        if (this.ducting && Math.abs(this.totalVelocity) < 640) {
            if (this.totalVelocity > 0 && this.pushOnce) {
                this.totalVelocity += 640;
                this.pushOnce = false;
            }
            if (this.totalVelocity < 0 && this.pushOnce) {
                this.totalVelocity += -640;
                this.pushOnce = false;
            }
        }
        if (!(Key.repeat(Key.gLeft) || Key.repeat(Key.gRight) || this.slipping || !Key.repeat(Key.gDown) || this.isTerminal)) {
            if (Math.abs(this.totalVelocity) <= 64 && (this.faceDegree < 45 || this.faceDegree > 315)) {
                this.animationID = 5;
                if (Key.press(Key.gSelect)) {
                    this.dashRolling = true;
                    GameObject.soundInstance.playSe(2);
                }
                if (!this.dashRolling) {
                    this.focusMovingState = 2;
                }
            } else {
                this.animationID = 4;
            }
        }
        if (this.animationID == 0 && (this.faceDegree < 45 || this.faceDegree > 315)) {
            if (Key.press(0x100000)) {
                this.dashRolling = true;
                GameObject.soundInstance.playSe(2);
            } else if (Key.press(0x200000)) {
                this.dashRolling = true;
                GameObject.soundInstance.playSe(2);
                this.spinCount = 12;
                this.spinKeyCount = 20;
            } else if (Key.press(8192)) {
                this.faceDirection = false;
                this.dashRolling = true;
                this.spinKeyCount = 20;
                GameObject.soundInstance.playSe(2);
                this.spinCount = 12;
            } else if (Key.press(32768)) {
                this.faceDirection = true;
                this.dashRolling = true;
                this.spinKeyCount = 20;
                GameObject.soundInstance.playSe(2);
                this.spinCount = 12;
            }
        }
        if (Key.press(Key.gUp | 0x1000000)) {
            if (Key.press(0x1000000)) {
                this.noVelMinus = true;
            }
            this.doJump();
        } else if (Key.repeat(Key.gUp | 0x2000000)) {
            if (this.animationID == 38 && this.drawer.checkEnd()) {
                this.animationID = 39;
            }
            if (this.animationID != 38 && this.animationID != 39 && this.animationID == 0) {
                this.animationID = 38;
            }
            if (this.animationID == 39) {
                this.focusMovingState = 1;
            }
        } else {
            if (this.animationID == 40 && this.drawer.checkEnd()) {
                this.animationID = 0;
            }
            if (this.animationID == 38 || this.animationID == 39) {
                this.animationID = 40;
            }
        }
        if (this.faceDegree >= 90 && this.faceDegree <= 270 && (n2 = Math.abs(FAKE_GRAVITY_ON_WALK * MyAPI.dCos(this.faceDegree) / 100)) >= (n = this.totalVelocity * this.totalVelocity / 4864) && !this.ducting) {
            this.calDivideVelocity();
            int n5 = this.getNewPointX(this.footPointX, 0, -this.collisionRect.getHeight() >> 1, this.faceDegree);
            int n6 = this.getNewPointY(this.footPointY, 0, -this.collisionRect.getHeight() >> 1, this.faceDegree);
            this.faceDegree = 0;
            this.footPointX = this.getNewPointX(n5, 0, this.collisionRect.getHeight() >> 1, this.faceDegree);
            this.footPointY = this.getNewPointY(n6, 0, this.collisionRect.getHeight() >> 1, this.faceDegree);
            this.collisionState = 1;
            return;
        }
        if (this.ducting) {
            return;
        }
        if (!Key.repeat(Key.gLeft | Key.gRight) && !this.isTerminal || this.animationID == 4 || this.slipFlag) {
            int n7 = n2 = this.animationID != 4 ? this.movePower : this.movePower >> 1;
            if (this.totalVelocity > 0) {
                this.totalVelocity -= n2;
                if (this.totalVelocity < 0) {
                    this.onBank = false;
                    this.totalVelocity = 0;
                }
            } else if (this.totalVelocity < 0) {
                this.totalVelocity += n2;
                if (this.totalVelocity > 0) {
                    this.onBank = false;
                    this.totalVelocity = 0;
                }
            }
        }
        if (this.collisionState == 1) {
            this.velY += GameObject.GRAVITY;
        }
    }

    public void inputLogicOnObject() {
        int n;
        this.firstJump = false;
        int n2 = this.movePower;
        int n3 = this.maxVelocity;
        if (Key.repeat(Key.gLeft) || this.isCelebrate && !this.faceDirection) {
            this.faceDirection = false;
            if (this.velX <= 0) {
                if (this.animationID != 4) {
                    this.velX -= n2;
                    if (this.velX < -n3) {
                        this.velX += n2;
                        if (this.velX > -n3) {
                            this.velX = -n3;
                        }
                    }
                }
            } else {
                n = this.animationID == 4 ? this.movePowerReserseBall : this.movePowerReverse;
                this.velX -= n;
                if (this.velX < 0) {
                    this.velX = 0 - n >> 2;
                } else {
                    this.faceDirection = true;
                }
            }
        } else if (Key.repeat(Key.gRight) || this.isCelebrate && this.faceDirection) {
            this.faceDirection = true;
            if (this.velX >= 0) {
                if (this.animationID != 4) {
                    this.velX += n2;
                    if (this.velX > n3) {
                        this.velX -= n2;
                        if (this.velX < n3) {
                            this.velX = n3;
                        }
                    }
                }
            } else {
                n = this.animationID == 4 ? this.movePowerReserseBall : this.movePowerReverse;
                this.velX += n;
                if (this.velX > -1) {
                    this.velX = n >> 2;
                } else {
                    this.faceDirection = false;
                }
            }
        }
        if (Math.abs(this.velX) <= 64) {
            if (this.animationID != 38 && this.animationID != 39 && this.animationID != 40) {
                this.animationID = 0;
            }
        } else if (this.animationID != 4) {
            this.animationID = Math.abs(this.velX) < 160 ? 1 : (Math.abs(this.velX) < 1040 ? 2 : 3);
        }
        if (this.attackCount > 0) {
            --this.attackCount;
        }
        switch (this.attackAnimationID) {
            case 18: {
                if (this.attackCount == 0) {
                    if (this.attackLevel >= 2) {
                        this.animationID = 19;
                        this.setVelX(this.faceDirection ? 700 : -700);
                        this.ignoreFirstTouch = true;
                    } else {
                        this.attackLevel = 0;
                    }
                } else {
                    this.animationID = 18;
                    this.ignoreFirstTouch = true;
                }
                if (!Key.press(Key.gSelect)) break;
                this.attackLevel = 2;
                break;
            }
            case 19: {
                if (this.drawer.checkEnd()) {
                    if (this.attackLevel >= 3) {
                        this.animationID = 20;
                        this.setVelX(this.faceDirection ? 900 : -900);
                        this.attackCount = 6;
                        this.ignoreFirstTouch = true;
                    } else {
                        this.attackLevel = 0;
                    }
                } else {
                    this.animationID = 19;
                    this.ignoreFirstTouch = true;
                }
                if (!Key.press(Key.gSelect)) break;
                this.attackLevel = 3;
                GameObject.soundInstance.playSe(2);
                break;
            }
            case 20: {
                if (this.attackCount == 0) {
                    this.attackLevel = 0;
                    this.setVelX(0);
                    break;
                }
                this.animationID = 20;
                this.ignoreFirstTouch = true;
                break;
            }
            default: {
                if (this.animationID == 4 || Key.repeat(Key.gDown) || !Key.press(Key.gSelect)) break;
                this.attackLevel = 1;
                this.attackCount = 6;
                this.animationID = 18;
                this.setVelX(this.faceDirection ? 500 : -500);
                this.ignoreFirstTouch = true;
            }
        }
        this.attackAnimationID = this.animationID;
        if (Key.repeat(Key.gDown)) {
            if (Math.abs(this.velX) <= 64) {
                this.animationID = 5;
                if (Key.press(Key.gSelect)) {
                    this.dashRolling = true;
                    GameObject.soundInstance.playSe(2);
                }
                if (!this.dashRolling) {
                    this.focusMovingState = 2;
                }
            } else {
                this.animationID = 4;
            }
        }
        if (this.animationID == 0) {
            if (Key.press(0x100000)) {
                this.dashRolling = true;
                GameObject.soundInstance.playSe(2);
            } else if (Key.press(0x200000)) {
                this.dashRolling = true;
                GameObject.soundInstance.playSe(2);
                this.spinCount = 12;
                this.spinKeyCount = 20;
            } else if (Key.press(8192)) {
                this.faceDirection = false;
                this.dashRolling = true;
                this.spinKeyCount = 20;
                GameObject.soundInstance.playSe(2);
                this.spinCount = 12;
            } else if (Key.press(32768)) {
                this.faceDirection = true;
                this.dashRolling = true;
                this.spinKeyCount = 20;
                GameObject.soundInstance.playSe(2);
                this.spinCount = 12;
            }
        }
        if (Key.press(Key.gUp | 0x1000000)) {
            if (Key.press(0x1000000)) {
                this.noVelMinus = true;
            }
            this.doJump();
        } else if (Key.repeat(Key.gUp | 0x2000000)) {
            if (this.animationID == 38 && this.drawer.checkEnd()) {
                this.animationID = 39;
            }
            if (this.animationID != 38 && this.animationID != 39 && this.animationID == 0) {
                this.animationID = 38;
            }
            if (this.animationID == 39) {
                this.focusMovingState = 1;
            }
        } else {
            if (this.animationID == 40 && this.drawer.checkEnd()) {
                this.animationID = 0;
            }
            if (this.animationID == 38 || this.animationID == 39) {
                this.animationID = 40;
            }
        }
        if (!Key.repeat(Key.gLeft | Key.gRight) && !this.isCelebrate) {
            int n4 = n = this.animationID != 4 ? this.movePower : this.movePower >> 1;
            if (this.velX > 0) {
                this.velX -= n;
                if (this.velX < 0) {
                    this.velX = 0;
                }
            } else if (this.velX < 0) {
                this.velX += n;
                if (this.velX > 0) {
                    this.velX = 0;
                }
            }
        }
        this.velY += GameObject.GRAVITY;
    }

    public void inputLogicJump() {
        if (this.animationID == 8) {
            this.doWalkPoseInAir();
        }
        if (!this.hurtNoControl) {
            if (!this.slipping && (Key.repeat(Key.gLeft) || this.isCelebrate && !this.faceDirection)) {
                this.velX -= this.movePowerInAir;
                if (this.velX < -this.maxVelocity) {
                    this.velX = -this.maxVelocity;
                }
                this.faceDirection = false;
            } else if (Key.repeat(Key.gRight) || this.isTerminal || this.isCelebrate && this.faceDirection) {
                this.velX += this.movePowerInAir;
                if (this.velX > this.maxVelocity) {
                    this.velX = this.maxVelocity;
                }
                this.faceDirection = true;
            }
            if (!this.slipping && Key.press(Key.gLeft)) {
                if (!this.jumpRollEnable) {
                    this.leftCount = 10;
                }
                this.rightCount = 0;
            }
            if (Key.press(Key.gRight)) {
                this.leftCount = 0;
                if (!this.jumpRollEnable) {
                    this.rightCount = 10;
                }
            }
        }
        if (this.animationID == 4 && this.firstJump) {
            if (this.leftCount > 0) {
                --this.leftCount;
                if (!Key.repeat(Key.gLeft)) {
                    this.jumpRollEnable = true;
                }
                if (this.jumpRollEnable && Key.repeat(Key.gLeft)) {
                    this.animationID = 15;
                    this.leftCount = 0;
                    this.velY = 0;
                    this.velX -= JUMP_RUSH_SPEED_PLUS;
                    GameObject.soundInstance.playSe(2);
                    this.firstJump = false;
                }
            }
            if (this.rightCount > 0) {
                --this.rightCount;
                if (!Key.repeat(Key.gRight)) {
                    this.jumpRollEnable = true;
                }
                if (this.jumpRollEnable && Key.repeat(Key.gRight)) {
                    this.animationID = 15;
                    this.rightCount = 0;
                    this.velY = 0;
                    this.velX += JUMP_RUSH_SPEED_PLUS;
                    GameObject.soundInstance.playSe(2);
                    this.firstJump = false;
                }
            }
            if (this.firstJump && Key.press(Key.gUp | 0x1000000)) {
                this.effectID = 0;
                this.firstJump = false;
                GameObject.soundInstance.playSe(2);
            }
        }
        if (this.velY >= -759) {
            int n = this.velX / JUMP_REVERSE_POWER;
            if (this.velX > 0) {
                this.velX -= n;
                if (this.velX < 0) {
                    this.velX = 0;
                }
            } else if (this.velX < 0) {
                this.velX -= n;
                if (this.velX > 0) {
                    this.velX = 0;
                }
            }
        }
        if (this.smallJumpCount > 0) {
            --this.smallJumpCount;
            if (!this.noVelMinus && !Key.repeat(Key.gUp)) {
                this.velY += GameObject.GRAVITY >> 1;
                this.velY += GameObject.GRAVITY >> 2;
            }
        }
        this.velY += GameObject.GRAVITY;
        if (this.animationID == 9 && this.drawer.checkEnd()) {
            this.animationID = 10;
        }
        if (this.animationID == 14 && this.velY > 0) {
            this.animationID = 10;
        }
        if (this.drawer.checkEnd()) {
            switch (this.animationID) {
                case 9: {
                    this.animationID = 10;
                    break;
                }
                case 15: {
                    this.animationID = 16;
                }
            }
        }
    }

    public void inputLogicSand() {
        if (this.velY > 0 && !this.sandStanding) {
            this.sandStanding = true;
        }
        if (this.sandStanding) {
            int n;
            int n2 = this.movePower >> 1;
            int n3 = this.maxVelocity >> 1;
            if (Key.repeat(Key.gLeft)) {
                this.faceDirection = false;
                if (this.velX <= 0) {
                    if (this.animationID != 4) {
                        this.velX -= n2;
                        if (this.velX < -n3) {
                            this.velX += n2;
                            if (this.velX > -n3) {
                                this.velX = -n3;
                            }
                        }
                    }
                } else {
                    n = this.animationID == 4 ? this.movePowerReserseBall : this.movePowerReverse;
                    this.velX -= n;
                    if (this.velX < 0) {
                        this.velX = 0 - n >> 2;
                    } else {
                        this.faceDirection = true;
                    }
                }
            } else if (Key.repeat(Key.gRight)) {
                this.faceDirection = true;
                if (this.velX >= 0) {
                    if (this.animationID != 4) {
                        this.velX += n2;
                        if (this.velX > n3) {
                            this.velX -= n2;
                            if (this.velX < n3) {
                                this.velX = n3;
                            }
                        }
                    }
                } else {
                    n = this.animationID == 4 ? this.movePowerReserseBall : this.movePowerReverse;
                    this.velX += n;
                    if (this.velX > -1) {
                        this.velX = n >> 2;
                    } else {
                        this.faceDirection = false;
                    }
                }
            }
            if (Math.abs(this.velX) <= 64) {
                if (this.animationID != 38 && this.animationID != 39 && this.animationID != 40) {
                    this.animationID = 0;
                }
            } else {
                this.animationID = Math.abs(this.velX) < 160 ? 1 : (Math.abs(this.velX) < 1040 ? 2 : 3);
            }
            if (Key.repeat(Key.gDown)) {
                this.animationID = Math.abs(this.velX) <= 64 ? 5 : 4;
            }
            if (!Key.repeat(Key.gLeft | Key.gRight)) {
                int n4 = n = this.animationID != 4 ? n2 : n2 >> 1;
                if (this.velX > 0) {
                    this.velX -= n;
                    if (this.velX < 0) {
                        this.velX = 0;
                    }
                } else if (this.velX < 0) {
                    this.velX += n;
                    if (this.velX > 0) {
                        this.velX = 0;
                    }
                }
            }
            this.velY = 100;
            if (Key.press(Key.gUp | 0x1000000)) {
                this.doJump();
                this.velY -= GameObject.GRAVITY;
                this.sandStanding = false;
            }
        } else {
            this.inputLogicJump();
        }
        this.collisionState = 1;
    }

    public void doJump() {
        int n;
        if (this.slipping) {
            n = 0;
            this.currentLayer = 1;
            n = this.isHeadCollision();
            this.currentLayer = 0;
            if (n != 0) {
                return;
            }
        }
        if (this.collisionState == 0) {
            this.calDivideVelocity();
        }
        this.collisionState = 1;
        this.velY += JUMP_START_VELOCITY * MyAPI.dCos(this.faceDegree) / 100;
        this.velX += JUMP_START_VELOCITY * -MyAPI.dSin(this.faceDegree) / 100;
        this.velY = Math.min(this.velY, JUMP_PROTECT);
        n = this.getNewPointX(this.footPointX, 0, -768, this.faceDegree);
        int n2 = this.getNewPointY(this.footPointY, 0, -768, this.faceDegree);
        this.faceDegree = 0;
        this.footPointX = this.getNewPointX(n, 0, 768, this.faceDegree);
        this.footPointY = this.getNewPointY(n2, 0, 768, this.faceDegree);
        this.animationID = 4;
        this.leftCount = 0;
        this.rightCount = 0;
        this.jumpRollEnable = false;
        if (this.slipping) {
            this.currentLayer = 1;
            this.slipping = false;
        }
        this.firstJump = true;
        GameObject.soundInstance.playSe(2);
        this.smallJumpCount = 4;
        this.onBank = false;
        this.attackAnimationID = 0;
        this.attackCount = 0;
        this.attackLevel = 0;
    }

    public int getCheckPositionX() {
        return this.collisionRect.x0 + this.collisionRect.x1 >> 1;
    }

    public int getCheckPositionY() {
        return this.collisionRect.y0 + this.collisionRect.y1 >> 1;
    }

    public int getFootPositionX() {
        return this.footPointX;
    }

    public int getFootPositionY() {
        return this.footPointY;
    }

    public int getHeadPositionY() {
        return this.getNewPointY(this.footPointY, 0, -1536, this.faceDegree);
    }

    public void setHeadPositionY(int n) {
        this.footPointY = this.getNewPointY(n, 0, 1536, this.faceDegree);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
    }

    public void setCollisionLayer(int n) {
        if (n < 0 || n > 1) {
            return;
        }
        this.currentLayer = n;
    }

    public void land() {
        this.calTotalVelocity();
        this.animationID = Math.abs(this.totalVelocity) == 0 ? 0 : (Math.abs(this.totalVelocity) < 160 ? 1 : (Math.abs(this.totalVelocity) < 1040 ? 2 : 3));
        if (this.ducting) {
            if (this.totalVelocity > 0 && this.totalVelocity < 640 && this.pushOnce) {
                this.totalVelocity += 640;
                this.pushOnce = false;
            }
            if (this.totalVelocity < 0 && this.totalVelocity > -640 && this.pushOnce) {
                this.totalVelocity -= 640;
                this.pushOnce = false;
            }
        }
    }

    public void collisionCheckWithGameObject(int n, int n2) {
        this.collisionChkBreak = false;
        int n3 = this.faceDegree;
        this.refreshCollisionRectWrap();
        this.faceDegree = n3;
        this.attackRectVec.removeAllElements();
        if (this.effectID == 0) {
            this.jumpAttackRect.setRect(n - 960, n2 - 1920 + 256, 1920, 1920);
            this.attackRectVec.addElement(this.jumpAttackRect);
        }
        if (this.isAttracting()) {
            this.attractRect.setRect(n - 4800, n2 - 4800 - 768, 9600, 9600);
        }
        GameObject.collisionChkWithAllGameObject(this);
        this.calPreCollisionRect();
    }

    public int getCurrentHeight() {
        int n = 1536;
        if (this.animationID == 4 || this.animationID == 5 || this.animationID == 6 || this.animationID == 7) {
            n = 1024;
        }
        return n;
    }

    public void calPreCollisionRect() {
        int n = 1536;
        if (this.animationID == 4 || this.animationID == 5 || this.animationID == 6 || this.animationID == 7) {
            n = 1024;
        }
        this.checkPositionX = this.getNewPointX(this.footPointX, 0, -n >> 1, this.faceDegree);
        this.checkPositionY = this.getNewPointY(this.footPointY, 0, -n >> 1, this.faceDegree);
        int n2 = this.checkPositionX - 512;
        int n3 = this.checkPositionY - (n >> 1);
        int n4 = this.checkPositionX + 512;
        int n5 = this.checkPositionY + (n >> 1);
        this.preCollisionRect.setTwoPosition(n2, n3, n4, n5);
    }

    public void moveOnObject(int n, int n2) {
        this.moveOnObject(n, n2, false);
    }

    public void moveOnObject(int n, int n2, boolean bl) {
        this.moveDistanceX = n - this.footPointX;
        this.moveDistanceY = n2 - this.footPointY;
        this.collisionChkBreak = false;
        while (!(this.moveDistanceX == 0 && this.moveDistanceY == 0 || this.collisionChkBreak)) {
            if (!bl) {
                this.collisionLogicInAir();
            }
            switch (this.collisionState) {
                case 0: {
                    this.collisionLogicOnGround();
                    break;
                }
                case 2: {
                    this.collisionLogicInAir();
                    break;
                }
                case 1: {
                    if (!bl) break;
                    this.collisionLogicInAir();
                }
            }
        }
        this.posX = this.footPointX - 512;
        this.posY = this.footPointY - 1536;
    }

    public void prepareForCollision() {
        this.refreshCollisionRectWrap();
    }

    public void beStop(int n, int n2, GameObject gameObject) {
        switch (n2) {
            case 2: 
            case 3: {
                if (n2 == 3) {
                    this.footPointX = gameObject.getCollisionRect().x0 - (this.collisionRect.getWidth() >> 1) + 64;
                    this.footPointX = this.getNewPointX(this.footPointX, 0, this.getCurrentHeight() >> 1, this.faceDegree);
                    if (Key.repeat(Key.gRight) && this.collisionState != 1) {
                        this.animationID = 8;
                    }
                    if (this.getVelX() > 0) {
                        this.setVelX(0);
                        this.moveDistanceX = 0;
                    }
                    this.rightStopped = true;
                } else {
                    this.footPointX = gameObject.getCollisionRect().x1 + (this.collisionRect.getWidth() >> 1);
                    this.footPointX = this.getNewPointX(gameObject.getCollisionRect().x1 + (this.collisionRect.getWidth() >> 1), 0, this.getCurrentHeight() >> 1, this.faceDegree);
                    if (Key.repeat(Key.gLeft) && this.collisionState != 1) {
                        this.animationID = 8;
                    }
                    if (this.getVelX() < 0) {
                        this.setVelX(0);
                        this.moveDistanceX = 0;
                    }
                    this.leftStopped = true;
                }
                switch (this.collisionState) {
                    case 0: {
                        this.currentPointX = this.footPointX;
                        this.actualMoveDistanceX = 0;
                        if (this.moveDistanceX != 0) break;
                        this.moveDistanceY = 0;
                        this.actualMoveDistanceY = 0;
                        break;
                    }
                    case 1: {
                        this.xFirst = false;
                        break;
                    }
                }
                break;
            }
            case 1: {
                if (this.collisionState == 0) {
                    this.calDivideVelocity();
                }
                if (this.collisionState != 2) {
                    this.land();
                }
                this.setVelY(0);
                this.moveDistanceY = 0;
                this.footPointY = gameObject.getCollisionRect().y0;
                if (this.isFootOnObject(gameObject)) {
                    this.checkedObject = true;
                }
                if (this.collisionState != 2 || !this.isFootOnObject(gameObject)) {
                    this.footOnObject = gameObject;
                    this.collisionState = (byte)2;
                    this.collisionChkBreak = true;
                }
                this.onObjectContinue = true;
                break;
            }
            case 0: {
                if (this.moveDistanceY < 0) {
                    this.setVelY(0);
                    this.moveDistanceY = 0;
                }
                this.footPointY = gameObject.getCollisionRect().y1 + this.collisionRect.getHeight();
                if (this.collisionState != 0 && this.collisionState != 2 || this.faceDegree != 0) break;
                this.setDie();
            }
        }
    }

    public boolean isAttackingEnemy() {
        return this.animationID == 18 || this.animationID == 19 || this.animationID == 20 || this.animationID == 4 || this.animationID == 6 || this.animationID == 7 || invincibleCount > 0 || this.attackRectVec.size() > 0;
    }

    public boolean isAttackingItem(boolean bl) {
        if (this.ignoreFirstTouch || bl) {
            return this.isAttackingItem();
        }
        return false;
    }

    public boolean isAttackingItem() {
        return this.animationID == 18 || this.animationID == 19 || this.animationID == 20 || this.animationID == 4 || this.attackRectVec.size() > 0;
    }

    public int getVelX() {
        if (this.collisionState == 0) {
            return this.totalVelocity * MyAPI.dCos(this.faceDegree) / 100;
        }
        return this.velX;
    }

    public int getVelY() {
        if (this.collisionState == 0) {
            return this.totalVelocity * MyAPI.dSin(this.faceDegree) / 100;
        }
        return this.velY;
    }

    public void setVelX(int n) {
        if (this.collisionState == 0) {
            int n2 = this.totalVelocity * MyAPI.dCos(this.faceDegree) / 100;
            int n3 = this.totalVelocity * MyAPI.dSin(this.faceDegree) / 100;
            n2 = n;
            this.totalVelocity = (n2 * MyAPI.dCos(this.faceDegree) + n3 * MyAPI.dSin(this.faceDegree)) / 100;
        } else {
            super.setVelX(n);
        }
    }

    public void setVelY(int n) {
        if (this.collisionState == 0) {
            int n2 = this.totalVelocity * MyAPI.dCos(this.faceDegree) / 100;
            int n3 = this.totalVelocity * MyAPI.dSin(this.faceDegree) / 100;
            n3 = n;
            this.totalVelocity = (n2 * MyAPI.dCos(this.faceDegree) + n3 * MyAPI.dSin(this.faceDegree)) / 100;
        } else {
            super.setVelY(n);
        }
    }

    public void slipStart() {
        this.currentLayer = 0;
        this.slipping = true;
    }

    public void slipEnd() {
        if (this.slipping) {
            this.currentLayer = 1;
            this.slipping = false;
            this.calDivideVelocity();
            this.collisionState = 1;
            this.velY = -1540;
            this.animationID = 9;
            this.collisionChkBreak = true;
            this.moveDistanceX = 0;
            this.moveDistanceY = 0;
        }
    }

    public void beSpring(int n, int n2) {
        if (this.collisionState == 0) {
            this.calDivideVelocity();
        }
        switch (n2) {
            case 3: {
                this.velX = -n;
                this.moveDistanceX = 0;
                break;
            }
            case 2: {
                this.velX = n;
                this.moveDistanceX = 0;
                break;
            }
            case 0: {
                this.velY = n;
                this.moveDistanceY = 0;
                break;
            }
            case 1: {
                this.velY = -n;
                this.moveDistanceY = 0;
            }
        }
        if (this.collisionState == 0) {
            this.calTotalVelocity();
        }
        if (n2 == 1) {
            this.animationID = 9;
            this.collisionState = 1;
            this.collisionChkBreak = true;
            this.drawer.restart();
        }
        GameObject.soundInstance.playSe(2);
    }

    public void bePop(int n, int n2) {
        this.beSpring(n, n2);
        if (n2 == 1) {
            this.animationID = 14;
            this.collisionState = 1;
        }
    }

    public void beHurt() {
        if (GameObject.player.canBeHurt()) {
            this.animationID = 12;
            if (this.collisionState == 2) {
                this.footPointY -= 128;
                this.prepareForCollision();
            }
            if (this.outOfControl && this.outOfControlObject != null && this.outOfControlObject.releaseWhileBeHurt()) {
                this.outOfControl = false;
                this.outOfControlObject = null;
            }
            this.hurtCount = 32;
            this.velX = (this.faceDirection ? -1 : 1) * HURT_POWER_X;
            this.velY = HURT_POWER_Y;
            int n = this.getNewPointX(this.footPointX, 0, -768, this.faceDegree);
            int n2 = this.getNewPointY(this.footPointY, 0, -768, this.faceDegree);
            this.faceDegree = 0;
            this.footPointX = this.getNewPointX(n, 0, 768, this.faceDegree);
            this.footPointY = this.getNewPointY(n2, 0, 768, this.faceDegree);
            this.collisionState = 1;
            this.collisionChkBreak = true;
            this.moveDistanceX = 0;
            this.moveDistanceY = 0;
            this.onObjectContinue = false;
            this.footOnObject = null;
            if (sheildType == 0) {
                if (ringNum > 0) {
                    RingObject.hurtRingExplosion(ringNum, this.getBodyPositionX(), this.getBodyPositionY(), this.currentLayer);
                    ringNum = 0;
                } else {
                    this.setDie();
                }
            } else {
                sheildType = 0;
            }
            this.hurtNoControl = true;
            this.attackAnimationID = 0;
            this.attackCount = 0;
            this.attackLevel = 0;
            this.dashRolling = false;
            if (this.slipping) {
                this.currentLayer = 1;
                this.slipping = false;
            }
        }
    }

    public void beHurtByCage() {
        this.animationID = 12;
        if (this.collisionState == 2) {
            this.footPointY -= 128;
            this.prepareForCollision();
        }
        this.hurtCount = 32;
        this.velX = (this.faceDirection ? -1 : 1) * HURT_POWER_X << 1;
        this.velY = HURT_POWER_Y << 1;
        this.collisionState = 1;
        this.collisionChkBreak = true;
        this.moveDistanceX = 0;
        this.moveDistanceY = 0;
        this.onObjectContinue = false;
        this.footOnObject = null;
        this.hurtNoControl = true;
        this.attackAnimationID = 0;
        this.attackCount = 0;
        this.attackLevel = 0;
        this.dashRolling = false;
        if (this.slipping) {
            this.currentLayer = 1;
            this.slipping = false;
        }
    }

    public boolean canBeHurt() {
        return this.hurtCount <= 0 && invincibleCount <= 0 && !this.isDead && !State.debugInvincible && !State.debugFreeMove;
    }

    public boolean isFootOnObject(GameObject gameObject) {
        if (this.outOfControl) {
            return false;
        }
        if (this.collisionState != 2) {
            return false;
        }
        return this.footOnObject == gameObject;
    }

    public void setFootPositionX(int n) {
        this.footPointX = n;
    }

    public void setFootPositionY(int n) {
        this.footPointY = n;
    }

    public void setBodyPositionX(int n) {
        this.setFootPositionX(n);
    }

    public void setBodyPositionY(int n) {
        this.setFootPositionY(n + 768);
    }

    public int getBodyPositionX() {
        return this.getFootPositionX();
    }

    public int getBodyPositionY() {
        return this.getFootPositionY() - 768;
    }

    public void dashRollingLogic() {
        this.animationID = 6;
        if (this.spinCount > 9) {
            this.animationID = 7;
        } else {
            if (Key.press(Key.gSelect) || Key.repeat(0x20A000) && this.spinKeyCount == 0) {
                this.spinCount = 12;
                this.animationID = 7;
                this.spinKeyCount = 20;
                this.drawer.restart();
                GameObject.soundInstance.playSe(2);
            }
            if (this.spinCount == 0 && this.spinKeyCount > 0) {
                --this.spinKeyCount;
            }
        }
        if (this.spinCount > 0) {
            --this.spinCount;
            this.effectID = 2;
        } else {
            this.effectID = 1;
        }
        switch (this.collisionState) {
            case 0: {
                this.totalVelocity = 0;
                break;
            }
            default: {
                this.velX = 0;
            }
        }
        if (!Key.repeat(Key.gDown | 0x2000 | 0x8000 | 0x100000 | 0x200000)) {
            this.effectID = -1;
            switch (this.collisionState) {
                case 0: {
                    this.totalVelocity = SPIN_START_SPEED_1;
                    if (this.spinCount > 0) {
                        this.totalVelocity = SPIN_START_SPEED_2;
                    }
                    if (this.faceDirection) break;
                    this.totalVelocity = -this.totalVelocity;
                    break;
                }
                default: {
                    this.velX = SPIN_START_SPEED_1;
                    if (this.spinCount > 0) {
                        this.velX = SPIN_START_SPEED_2;
                    }
                    if (this.faceDirection) break;
                    this.velX = -this.velX;
                }
            }
            this.spinCount = 0;
            this.animationID = 4;
            this.dashRolling = false;
            this.ignoreFirstTouch = true;
            GameObject.soundInstance.playSe(2);
        }
        switch (this.collisionState) {
            case 0: {
                break;
            }
            default: {
                this.velY += GameObject.GRAVITY;
            }
        }
    }

    public void beWaterFall() {
        this.waterFalling = true;
        this.velY += GameObject.GRAVITY / 10;
    }

    public void initWaterFall() {
        if (this.waterFallDrawer == null) {
            MFImage mFImage = null;
            if (StageManager.getCurrentZoneId() == 5) {
                mFImage = MFImage.createImage("/animation/water_fall_5.png");
            }
            this.waterFallDrawer = mFImage == null ? new Animation("/animation/water_fall").getDrawer(0, true, 0) : new Animation(mFImage, "/animation/water_fall").getDrawer(0, true, 0);
        }
    }

    public void waterFallDraw(MFGraphics mFGraphics, Coordinate coordinate) {
        if (this.waterFalling) {
            this.drawInMap(mFGraphics, this.waterFallDrawer, this.collisionRect.x0 + this.collisionRect.x1 >> 1, this.collisionRect.y0 - 320);
            this.waterFalling = false;
        }
    }

    public void initWaterFlush() {
        if (this.waterFlushDrawer == null) {
            MFImage mFImage = null;
            if (StageManager.getCurrentZoneId() == 5) {
                mFImage = MFImage.createImage("/animation/water_flush_5.png");
            }
            this.waterFlushDrawer = mFImage == null ? new Animation("/animation/water_flush").getDrawer(0, true, 0) : new Animation(mFImage, "/animation/water_flush").getDrawer(0, true, 0);
        }
    }

    public void waterFlushDraw(MFGraphics mFGraphics) {
        if (this.showWaterFlush) {
            this.initWaterFlush();
            this.drawInMap(mFGraphics, this.waterFlushDrawer, this.footPointX, this.collisionRect.y1);
            this.showWaterFlush = false;
        }
    }

    public boolean beAccelerate(int n) {
        if (this.collisionState == 0) {
            this.totalVelocity = n;
            return true;
        }
        if (this.collisionState == 2) {
            this.velX = n;
            return true;
        }
        return false;
    }

    public boolean isOnGound() {
        return this.collisionState == 0;
    }

    public boolean doPoalMotion(int n, int n2, boolean bl) {
        if (this.collisionState == 0) {
            this.collisionState = 1;
        }
        if (this.collisionState == 1) {
            this.animationID = 13;
            this.faceDirection = !bl;
            this.footPointX = n;
            this.footPointY = n2 + 2048;
            this.velX = 0;
            this.velY = 0;
            return true;
        }
        return false;
    }

    public boolean doPoalMotion2(int n, int n2, boolean bl) {
        if (this.collisionState == 0 && (this.faceDirection && bl && this.totalVelocity >= 300 || !this.faceDirection && !bl && this.totalVelocity <= -300)) {
            this.animationID = 31;
            this.faceDirection = bl;
            this.footPointX = n + (this.faceDirection ? -1 : 1) * 1024;
            this.setNoKey();
            this.totalVelocity = (this.faceDirection ? -1 : 1) * 300;
            this.moveDistanceX = 0;
            return true;
        }
        return false;
    }

    public void doPullMotion(int n, int n2) {
        this.animationID = 24;
        this.footPointX = n;
        this.footPointY = n2 + 2048;
        this.velX = 0;
        this.velY = 0;
        this.footPointX = this.faceDirection ? (this.footPointX -= 256) : (this.footPointX += 256);
    }

    public void doPullBarMotion(int n) {
        this.animationID = 27;
        this.footPointY = n + 2304;
        this.velX = 0;
        this.velY = 0;
    }

    public void doWalkPoseInAir() {
        if (this.collisionState == 1) {
            this.animationID = Math.abs(this.velX) < 160 ? 1 : (Math.abs(this.velX) < 1040 ? 2 : 3);
        }
    }

    public void setAnimationId(int n) {
        this.animationID = n;
    }

    public int getAnimationId() {
        return this.animationID;
    }

    public void refreshCollisionRectWrap() {
        int n = 1536;
        int n2 = 1024;
        int n3 = this.faceDegree;
        int n4 = 0;
        int n5 = 0;
        if (this.animationID == 4 || this.animationID == 5 || this.animationID == 6 || this.animationID == 7 || this.animationID == 18 || this.animationID == 19 || this.animationID == 20) {
            n = 1152;
        }
        if (this.animationID == 11) {
            n5 = this.getAnimationOffset() == 1 ? -960 : -320;
            n3 = 0;
        }
        if (this.animationID == 21) {
            n2 = 1536;
        }
        this.checkPositionX = this.getNewPointX(this.footPointX, 0, -n >> 1, n3) + n4;
        this.checkPositionY = this.getNewPointY(this.footPointY, 0, -n >> 1, n3) + n5;
        int n6 = this.checkPositionX - (n2 >> 1);
        int n7 = this.checkPositionY - (n >> 1);
        int n8 = this.checkPositionX + (n2 >> 1);
        int n9 = this.checkPositionY + (n >> 1);
        this.collisionRect.setTwoPosition(n6, n7, n8, n9);
    }

    public void refreshCollisionRect(int n, int n2) {
    }

    public void fallChk() {
        if (this.fallTime > 0) {
            --this.fallTime;
            return;
        }
        if (this.faceDegree >= 45 && this.faceDegree <= 315 && Math.abs(this.totalVelocity) < 474) {
            if (this.totalVelocity == 0) {
                this.calDivideVelocity();
                this.velY += GameObject.GRAVITY;
                this.calTotalVelocity();
            }
            this.fallTime = 7;
        }
    }

    public void railIn(int n, int n2) {
        this.railLine = null;
        this.velY = 0;
        this.velX = 0;
        this.moveDistanceX = 0;
        this.setFootPositionX(n);
        this.collisionChkBreak = true;
        this.railing = true;
        this.railOut = false;
        this.animationID = 21;
        this.setNoKey();
    }

    public void railOut(int n, int n2) {
        if (this.railing) {
            this.railOut = true;
            this.railLine = null;
            this.velY = -1200;
            this.velX = 0;
            this.setVelX(0);
            this.setFootPositionX(n);
            this.setFootPositionY(n2);
            this.collisionChkBreak = true;
        }
    }

    public void pipeIn(int n, int n2, int n3, int n4) {
        this.piping = true;
        this.pipeState = 0;
        this.pipeDesX = n;
        this.pipeDesY = n2 + 768;
        this.velX = 250;
        this.velY = 250;
        this.nextVelX = (n3 << 6) / 1;
        this.nextVelY = (n4 << 6) / 1;
        this.collisionChkBreak = true;
    }

    public void pipeSet(int n, int n2, int n3, int n4) {
        if (this.piping) {
            this.pipeDesX = n;
            this.pipeDesY = n2 + 768;
            this.nextVelX = (n3 << 6) / 1;
            this.nextVelY = (n4 << 6) / 1;
            this.pipeState = (byte)2;
            if (this.velX > 0 && this.footPointX > this.pipeDesX) {
                this.footPointX = this.pipeDesX;
            }
            if (this.velX < 0 && this.footPointX < this.pipeDesX) {
                this.footPointX = this.pipeDesX;
            }
            if (this.velY > 0 && this.footPointY > this.pipeDesY) {
                this.footPointY = this.pipeDesY;
            }
            if (this.velY < 0 && this.footPointY < this.pipeDesY) {
                this.footPointY = this.pipeDesY;
            }
            this.collisionChkBreak = true;
        } else {
            this.footPointX = n;
            this.footPointY = n2 + 768;
            this.velX = (n3 << 6) / 1;
            this.velY = (n4 << 6) / 1;
            this.pipeState = 1;
            this.piping = true;
            this.collisionChkBreak = true;
            this.moveDistanceX = 0;
            this.moveDistanceY = 0;
        }
    }

    public void pipeOut() {
        if (this.piping) {
            this.piping = false;
            this.collisionState = 1;
        }
    }

    public void setFall(int n, int n2, int n3, int n4) {
        this.railing = true;
        this.setFootPositionX(n);
        this.velX = 0;
        this.velY = 0;
        this.railLine = null;
        this.collisionChkBreak = true;
    }

    public void setRailFlip() {
        this.velX = 0;
        this.velY = -3140;
        this.railLine = null;
        this.collisionChkBreak = true;
        this.railFlipping = true;
    }

    public boolean setRailLine(Line line, int n, int n2, int n3, int n4, GameObject gameObject) {
        if (!gameObject.getCollisionRect().collisionChk(this.footPointX, this.footPointY)) {
            return false;
        }
        if (this.railing && this.velY >= 0) {
            if (this.railLine == null) {
                this.totalVelocity = 0;
            }
            this.railLine = line;
            this.calDivideVelocity();
            if (Math.abs(n4) <= 1) {
                this.velX = n3 << 6;
                this.velY = 0;
                if (this.railFlipping) {
                    this.railFlipping = false;
                    this.setFootPositionY(this.railLine.getY(this.footPointX) + 768);
                } else {
                    this.setFootPositionY(this.railLine.getY(this.footPointX) - 512 + 768);
                }
            } else {
                this.setFootPositionY(this.railLine.getY(this.footPointX) + 768);
            }
            this.calTotalVelocity();
            this.collisionChkBreak = true;
            return true;
        }
        return false;
    }

    public void checkWithObject(int n, int n2, int n3, int n4) {
        int n5 = n3 - n;
        int n6 = n4 - n2;
        if (n5 == 0 && n6 == 0) {
            this.footPointX = n3;
            this.footPointY = n4;
            return;
        }
        boolean bl = Math.abs(n5) >= Math.abs(n6);
        int n7 = bl ? Math.abs(n5) : Math.abs(n6);
        int n8 = n;
        int n9 = n2;
        int n10 = 0;
        while (n10 <= n7 && n10 < n7) {
            if ((n10 += 512) >= n7) {
                n10 = n7;
            }
            int n11 = n + n5 * n10 / n7;
            int n12 = n2 + n6 * n10 / n7;
            GameObject.player.moveDistance.x = (n11 >> 6) - (n8 >> 6);
            GameObject.player.moveDistance.y = (n12 >> 6) - (n9 >> 6);
            this.footPointX = n11;
            this.footPointY = n12;
            this.collisionCheckWithGameObject(n11, n12);
            if (this.collisionChkBreak) break;
            n8 = n11;
            n9 = n12;
        }
    }

    public void cancelFootObject(GameObject gameObject) {
        if (this.collisionState == 2 && this.isFootOnObject(gameObject)) {
            GameObject.player.collisionState = 1;
            GameObject.player.footOnObject = null;
            this.onObjectContinue = false;
        }
    }

    public void cancelFootObject() {
        if (this.collisionState == 2) {
            GameObject.player.footOnObject = null;
            this.onObjectContinue = false;
        }
    }

    public void doAttackPose(GameObject gameObject, int n) {
        if (this.extraAttackFlag) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = -this.getVelY();
                if (n2 > -500) {
                    n2 = -500;
                }
                this.setVelY(n2);
            }
        }
        switch (n) {
            case 1: {
                this.cancelFootObject(this);
                this.collisionState = 1;
                this.animationID = 4;
            }
        }
    }

    public void doBossAttackPose(GameObject gameObject, int n) {
        if (this.collisionState == 1) {
            this.setVelX(-this.velX);
            if (-this.velY < -ATTACK_POP_POWER) {
                this.setVelY(-ATTACK_POP_POWER);
            } else {
                this.setVelY(-this.velY);
            }
        }
    }

    public boolean inRailState() {
        return this.railing || this.railOut;
    }

    public void changeVisible(boolean bl) {
        this.visible = bl;
        if (this.visible) {
            this.railing = false;
        }
    }

    public void setOutOfControl(GameObject gameObject) {
        this.outOfControl = true;
        this.outOfControlObject = gameObject;
        this.piping = false;
    }

    public boolean isControlObject(GameObject gameObject) {
        return this.controlObjectLogic && gameObject == this.outOfControlObject;
    }

    public void setDie() {
        this.velX = 0;
        this.velY = -800;
        this.collisionState = 1;
        MapManager.setFocusObj(null);
        this.isDead = true;
        this.finishDeadStuff = false;
        this.animationID = 41;
        timeStopped = true;
        this.moveDistanceX = 0;
        this.moveDistanceY = 0;
        this.collisionChkBreak = true;
        this.hurtCount = 0;
        this.attackAnimationID = 0;
        this.attackCount = 0;
        this.attackLevel = 0;
        this.dashRolling = false;
        if (this.slipping) {
            this.currentLayer = 1;
            this.slipping = false;
        }
        if (this.effectID == 1 || this.effectID == 2) {
            this.effectID = -1;
        }
    }

    public void setNoKey() {
        this.noKeyFlag = true;
    }

    public void setCollisionState(byte by) {
        if (this.collisionState == 0) {
            this.calDivideVelocity();
        }
        switch (by) {
            case 1: {
                this.faceDegree = 0;
            }
        }
        this.collisionState = by;
    }

    public void setSlip() {
        if (this.collisionState == 0) {
            this.slipFlag = true;
            this.showWaterFlush = true;
            this.animationID = 30;
            this.setNoKey();
        }
    }

    public void beUnseenPop() {
        if (this.collisionState == 0 && Math.abs(this.totalVelocity) > 500) {
            this.beSpring(2200, 1);
            if (this.totalVelocity > 0) {
                this.beSpring(2200, 2);
            } else {
                this.beSpring(2200, 3);
            }
        }
    }

    public void setBank() {
        boolean bl = this.onBank = !this.onBank;
        if (this.onBank && this.collisionState == 0) {
            this.calDivideVelocity();
        }
    }

    public void bankLogic() {
        if (!this.onBank) {
            return;
        }
        this.faceDegree = 0;
        this.inputLogicWalk();
        if (!this.onBank) {
            return;
        }
        this.calDivideVelocity();
        this.velY = 0;
        int n = GameObject.player.getFootPositionX();
        int n2 = GameObject.player.getFootPositionY();
        this.footPointX += this.velX;
        int n3 = this.footPointX;
        int n4 = 3072 * MyAPI.dCos((n3 - 660480) * 5760 / 11264 >> 6) / 100 + 3072;
        n4 = 63488 - n4;
        int n5 = GameObject.player.getVelX();
        if (Math.abs(n5) > 500) {
            GameObject.player.setFootPositionY(Math.max(n4, GameObject.player.getFootPositionY() - Math.abs(n5) * 400 / 500));
        } else {
            GameObject.player.setFootPositionY(Math.min(63488, GameObject.player.getFootPositionY() + 200));
            if (this.footPointY >= 63488) {
                this.onBank = false;
                this.collisionState = 1;
            }
        }
        if (this.animationID != 4) {
            if (this.footPointY < 61184) {
                this.animationID = 34;
            } else if (this.footPointY < 61952) {
                this.animationID = 33;
            } else if (this.footPointY < 62720) {
                this.animationID = 32;
            } else {
                this.doWalkPoseInAir();
            }
        }
        this.checkWithObject(n, n2, this.footPointX, this.footPointY);
    }

    public void setTerminal() {
        this.terminalCount = 10;
        this.isTerminal = true;
        timeStopped = true;
        if (this.collisionState == 0) {
            if (this.animationID == 4) {
                this.land();
            }
            if (this.totalVelocity > MAX_VELOCITY) {
                this.totalVelocity = MAX_VELOCITY;
            }
        }
    }

    public void beTrans(int n, int n2) {
        this.animationID = 4;
        this.collisionState = 1;
        this.transing = true;
        this.setBodyPositionX(n);
        this.setBodyPositionY(n2);
        MapManager.setCameraMoving();
        this.calPreCollisionRect();
    }

    public void setCelebrate() {
        timeStopped = true;
        this.isCelebrate = true;
        MapManager.setCameraLeftLimit(MapManager.getCamera().x);
        MapManager.setCameraRightLimit(MapManager.getCamera().x + MapManager.CAMERA_WIDTH);
        this.moveLimit = this.faceDirection ? this.posX + 3840 : this.posX - 3840;
    }

    public void getPreItem(int n) {
        for (int i = 0; i < 5; ++i) {
            if (itemVec[i][0] != -1) continue;
            PlayerObject.itemVec[i][0] = n;
            PlayerObject.itemVec[i][1] = 20;
            break;
        }
    }

    public void getItem(int n) {
        switch (n) {
            case 0: {
                ++lifeNum;
                break;
            }
            case 1: {
                sheildType = 1;
                break;
            }
            case 2: {
                sheildType = 2;
                break;
            }
            case 3: {
                invincibleCount = 320;
                SoundSystem.getInstance().playBgm(16);
                break;
            }
            case 4: {
                speedCount = 320;
                SoundSystem.getInstance().playBgm(StageManager.getFastBgmId());
                break;
            }
            case 5: {
                this.getRing(RANDOM_RING_NUM[MyRandom.nextInt(RANDOM_RING_NUM.length)]);
                break;
            }
            case 6: {
                this.getRing(5);
                break;
            }
            case 7: {
                this.getRing(10);
            }
        }
    }

    public void getRing(int n) {
        int n2 = ringNum;
        if (GameObject.stageModeState != 1 && n2 / 100 != (ringNum += n) / 100) {
            ++lifeNum;
            SoundSystem.getInstance().playBgmSequence(10, StageManager.getBgmId());
        }
    }

    public boolean isAttracting() {
        return sheildType == 2;
    }

    public void getEnemyScore() {
        scoreNum += 100;
        raceScoreNum += 100;
    }

    public void getBossScore() {
        scoreNum += 1000;
        raceScoreNum += 1000;
    }

    public void getBallHobinScore() {
        scoreNum += 10;
        raceScoreNum += 10;
    }

    public void ductIn() {
        this.ducting = true;
        this.pushOnce = true;
    }

    public void ductOut() {
        this.ducting = false;
        this.pushOnce = false;
    }

    public void setSqueezeEnable(boolean bl) {
        this.squeezeFlag = bl;
    }

    public boolean isHeadCollision() {
        boolean bl = false;
        int n = this.headCollisionCheck(this.footPointX, this.footPointY - 1536);
        if (n >= 0) {
            bl = true;
        }
        return bl;
    }

    public static void setScore(int n) {
        scoreNum = n;
    }

    public static int getScore() {
        return scoreNum;
    }

    public static void resetGameParam() {
        scoreNum = 0;
        lifeNum = 2;
    }

    public static void initStageParam() {
        ringNum = 0;
        invincibleCount = 0;
        speedCount = 0;
        sheildType = 0;
        timeCount = 0;
        timeStopped = false;
        raceScoreNum = 0;
        preScoreNum = scoreNum;
        preLifeNum = lifeNum;
        for (int i = 0; i < 5; ++i) {
            PlayerObject.itemVec[i][0] = -1;
        }
    }

    public static void doPauseLeaveGame() {
        scoreNum = preScoreNum;
        lifeNum = preLifeNum;
    }

    public static void drawGameUI(MFGraphics mFGraphics) {
        uiDrawer.draw(mFGraphics, 90, 0 + uiOffsetX, 0, false, 0);
        PlayerObject.drawNum(mFGraphics, ringNum, MyAPI.ZOOM_OUT_MOVE == 1 ? MyAPI.zoomIn(12 + uiOffsetX, true) : 12 + uiOffsetX, MyAPI.ZOOM_OUT_MOVE == 1 ? MyAPI.zoomIn(15, true) : 15, 0, ringNum == 0 && timeCount / 240 % 2 == 0 ? 3 : 0);
        PlayerObject.drawNum(mFGraphics, GameObject.stageModeState == 1 ? raceScoreNum : scoreNum, MyAPI.ZOOM_OUT_MOVE == 1 ? MyAPI.zoomIn(NumberSideX + uiOffsetX, true) : NumberSideX + uiOffsetX, MyAPI.ZOOM_OUT_MOVE == 1 ? MyAPI.zoomIn(8, true) : 8, 2, 0);
        PlayerObject.timeDraw(mFGraphics, MyAPI.ZOOM_OUT_MOVE == 1 ? MyAPI.zoomIn(NumberSideX + uiOffsetX, true) : NumberSideX + uiOffsetX, MyAPI.ZOOM_OUT_MOVE == 1 ? MyAPI.zoomIn(22, true) : 25);
        if (GameObject.stageModeState != 1) {
            State.drawMenuFontById(mFGraphics, 91, Def.SCREEN_WIDTH - uiOffsetX - 70, 0);
            PlayerObject.drawNum(mFGraphics, lifeNum, Def.SCREEN_WIDTH - 10 - uiOffsetX - 70 + 5, 15, 0, 0);
        }
    }

    public static void drawNum(MFGraphics mFGraphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = 10;
        int n7 = 1;
        int n8 = 0;
        while (true) {
            if (n / n6 == 0) {
                n6 /= 10;
                break;
            }
            ++n7;
            n6 *= 10;
            ++n8;
        }
        PlayerObject.drawNum(mFGraphics, n, n2, n3, n4, n5, n7);
    }

    public static void drawNum(MFGraphics mFGraphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (numDrawer == null) {
            numDrawer = GlobalResource.statusAnimation.getDrawer(0, false, 0);
        }
        int n8 = 1;
        for (n7 = 1; n7 < n6; ++n7) {
            n8 *= 10;
        }
        n7 = 0;
        switch (n4) {
            case 0: {
                n7 = n2 - (NUM_SPACE[n5] * (n6 - 1) >> 1);
                break;
            }
            case 1: {
                n7 = n2;
                break;
            }
            case 2: {
                n7 = n2 - NUM_SPACE[n5] * (n6 - 1);
            }
        }
        if (n6 > 3) {
            n7 += (3 - NUM_SPACE[n5]) * (n6 / 3 + (n6 % 3 == 0 ? -1 : 0));
        }
        int n9 = 0;
        int n10 = 0;
        while (n9 < n6) {
            int n11 = Math.abs(n / n8) % 10;
            n8 /= 10;
            if (n5 == 3 && n11 == 0) {
                numDrawer.setActionId(26);
            } else {
                numDrawer.setActionId(NUM_ANI_ID[n5] + n11);
            }
            if (n6 - n9 != 0 && (n6 - n9) % 3 == 0 && n6 > 3 && n9 != 0) {
                MyAPI.drawBoldString(mFGraphics, ",", n7 + NUM_SPACE[n5] * n10, n3 - 10, 17, 0xFFFFFF, 4656650, 0);
                n7 -= 3;
                ++n10;
            }
            numDrawer.draw(mFGraphics, n7 + NUM_SPACE[n5] * n10, n3);
            ++n9;
            ++n10;
        }
    }

    public static void timeLogic() {
        if (timeStopped) {
            return;
        }
        if ((timeCount += 59) > 599999) {
            timeCount = 599999;
        }
        if ((GlobalResource.timeIsLimit() && timeCount == 599999 || TitleState.state == 7 && timeCount == 599999) && GameObject.player != null) {
            GameObject.player.setDie();
            StageManager.checkPointTime = 0;
        }
    }

    public static int getTimeCount() {
        return timeCount;
    }

    public static void timeDraw(MFGraphics mFGraphics, int n, int n2) {
        int n3 = timeCount / 60000;
        int n4 = timeCount % 60000 / 1000;
        int n5 = timeCount % 60000 % 1000;
        int n6 = 0;
        if (GlobalResource.timeIsLimit() && timeCount > 540000 && timeCount / 240 % 2 == 0) {
            n6 = 3;
        }
        PlayerObject.drawNum(mFGraphics, n5, n + 0, n2, 2, n6, 3);
        mFGraphics.setClip(MyAPI.zoomOut(n - NUM_SPACE[n6] * 3 - (MyAPI.ZOOM_OUT_MOVE == 0 ? 1 : 2) + 0), MyAPI.zoomOut(n2), MyAPI.ZOOM_OUT_MOVE == 0 ? 5 : 10, MyAPI.ZOOM_OUT_MOVE == 0 ? 5 : 12);
        State.drawMenuFontById(mFGraphics, n6 == 3 ? 135 : 47, n - NUM_SPACE[n6] * 3 + 0, n2);
        mFGraphics.setClip(0, 0, 320, 240);
        PlayerObject.drawNum(mFGraphics, n4, n - NUM_SPACE[n6] * 4 + 0, n2, 2, n6, 2);
        State.drawMenuFontById(mFGraphics, n6 == 3 ? 135 : 47, n - NUM_SPACE[n6] * 6 + 0, n2);
        PlayerObject.drawNum(mFGraphics, n3, n - NUM_SPACE[n6] * 7, n2, 2, n6, 1);
    }

    public static void drawRecordTime(MFGraphics mFGraphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n / 60000;
        int n7 = n % 60000 / 1000;
        int n8 = n % 60000 % 1000;
        switch (n5) {
            case 1: {
                n2 += 7 * NUM_SPACE[n4];
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                n2 += 7 * NUM_SPACE[n4] >> 1;
            }
        }
        PlayerObject.drawNum(mFGraphics, n8, n2 + NUM_SPACE[n4] + 0, n3, 2, n4, 3);
        mFGraphics.setClip(n2 - NUM_SPACE[n4] * 2 - (MyAPI.ZOOM_OUT_MOVE == 0 ? 3 : 6) + 0, n3, MyAPI.ZOOM_OUT_MOVE == 0 ? 10 : 20, MyAPI.ZOOM_OUT_MOVE == 0 ? 10 : 20);
        State.drawMenuFontById(mFGraphics, 125, n2 - NUM_SPACE[n4] * 2 + 0, n3);
        mFGraphics.setClip(0, 0, 320, 240);
        PlayerObject.drawNum(mFGraphics, n7, n2 - NUM_SPACE[n4] * 3 + 0, n3, 2, n4, 2);
        State.drawMenuFontById(mFGraphics, 125, n2 - NUM_SPACE[n4] * 5 + 0, n3);
        PlayerObject.drawNum(mFGraphics, n6, n2 - NUM_SPACE[n4] * 6, n3, 2, n4, 1);
    }

    public static void drawRecordTimeTotalYellow(MFGraphics mFGraphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n / 60000;
        int n7 = n % 60000 / 1000;
        int n8 = n % 60000 % 1000;
        switch (n5) {
            case 1: {
                n2 += 7 * NUM_SPACE[n4];
                break;
            }
            case 2: {
                break;
            }
            case 0: {
                n2 += 7 * NUM_SPACE[n4] >> 1;
            }
        }
        PlayerObject.drawNum(mFGraphics, n8, n2 + NUM_SPACE[n4] + 0, n3, 2, n4, 3);
        mFGraphics.setClip(MyAPI.zoomOut(n2 - NUM_SPACE[n4] * 2 - (MyAPI.ZOOM_OUT_MOVE == 0 ? 1 : 2) + 0), MyAPI.zoomOut(n3), MyAPI.ZOOM_OUT_MOVE == 0 ? 5 : 10, MyAPI.ZOOM_OUT_MOVE == 0 ? 5 : 10);
        State.drawMenuFontById(mFGraphics, 47, n2 - NUM_SPACE[n4] * 2 + 0, n3);
        mFGraphics.setClip(0, 0, 320, 240);
        PlayerObject.drawNum(mFGraphics, n7, n2 - NUM_SPACE[n4] * 3 + 0, n3, 2, n4, 2);
        State.drawMenuFontById(mFGraphics, 47, n2 - NUM_SPACE[n4] * 5 + 0, n3);
        PlayerObject.drawNum(mFGraphics, n6, n2 - NUM_SPACE[n4] * 6, n3, 2, n4, 1);
    }

    public static void drawRecordTimeLeft(MFGraphics mFGraphics, int n, int n2, int n3) {
        PlayerObject.drawRecordTimeTotalYellow(mFGraphics, n, n2, n3, 4, 1);
        MyAPI.setBmfColor(0);
    }

    public static void drawStagePassInfoScroll(MFGraphics mFGraphics, int n, int n2, int n3) {
        State.drawBar(mFGraphics, 2, n);
        itemOffsetX += n2;
        itemOffsetX %= n3;
        int n4 = 0;
        while (n4 - itemOffsetX > 0) {
            n4 -= n3;
        }
        int n5 = (Def.SCREEN_WIDTH + n3 - 1) / n3 + 2;
        for (int i = 0; i < n5; ++i) {
            int n6 = n4 + i * n3;
            State.drawMenuFontById(mFGraphics, 62 + StageManager.getStageID() % 2, n6 - itemOffsetX, n);
        }
    }

    public static void initMovingBar() {
        offsetx = Def.SCREEN_WIDTH;
        offsety = (Def.SCREEN_HEIGHT >> 1) + 60;
    }

    public static void drawMovingbar(MFGraphics mFGraphics, int n) {
        State.drawBar(mFGraphics, 2, 0, offsety);
        int n2 = (Def.SCREEN_WIDTH + n - 1) / n + 2;
        for (int i = 0; i < n2; ++i) {
            int n3 = offsetx + 50 + i * n;
            State.drawMenuFontById(mFGraphics, 62 + StageManager.getStageID() % 2, n3, offsety);
        }
    }

    public static boolean isRaceModeNewRecord() {
        return timeCount < StageManager.getTimeModeScore();
    }

    public static boolean movingBar() {
        if (offsetx <= 0) {
            offsetx = 0;
        } else if ((offsetx -= movespeed) == Def.SCREEN_WIDTH - movespeed) {
            if (GameObject.stageModeState == 1 && PlayerObject.isRaceModeNewRecord()) {
                SoundSystem.getInstance().playBgm(7, false);
            } else {
                SoundSystem.getInstance().playBgm(5, false);
            }
        }
        if (offsetx == 0) {
            if (offsety <= (Def.SCREEN_HEIGHT >> 1) - 40) {
                offsety = (Def.SCREEN_HEIGHT >> 1) - 40;
                return true;
            }
            offsety -= movespeed;
            return false;
        }
        return false;
    }

    public static void clipMoveInit(int n, int n2, int n3, int n4, int n5) {
        clipx = n;
        clipy = n2;
        clipstartw = n3;
        clipendw = n4;
        cliph = n5;
    }

    public static boolean clipMoveLogic() {
        if (clipstartw < clipendw) {
            clipstartw += clipspeed;
            return false;
        }
        clipstartw = clipendw;
        return true;
    }

    public static void clipMoveShadow(MFGraphics mFGraphics) {
        MyAPI.setClip(mFGraphics, clipx, 0, clipstartw, Def.SCREEN_HEIGHT);
    }

    public static void calculateScore() {
        score1 = timeCount < 50000 ? 50000 : (timeCount >= 50000 && timeCount < 60000 ? 10000 : (timeCount >= 60000 && timeCount < 90000 ? 5000 : (timeCount >= 90000 && timeCount < 120000 ? 4000 : (timeCount >= 120000 && timeCount < 180000 ? 3000 : (timeCount >= 180000 && timeCount < 240000 ? 2000 : (timeCount >= 240000 && timeCount < 300000 ? 1000 : (timeCount >= 300000 && timeCount < 360000 ? 500 : 0)))))));
        score2 = ringNum * 100;
    }

    public static void stagePassDraw(MFGraphics mFGraphics) {
        switch (GameObject.stageModeState) {
            case 0: {
                if (!PlayerObject.movingBar()) {
                    PlayerObject.drawMovingbar(mFGraphics, STAGE_PASS_STR_SPACE);
                } else {
                    PlayerObject.drawStagePassInfoScroll(mFGraphics, (Def.SCREEN_HEIGHT >> 1) - 40, 10, STAGE_PASS_STR_SPACE);
                    if (!PlayerObject.clipMoveLogic()) {
                        MyAPI.setBmfColor(1);
                        State.drawMenuFontByString(mFGraphics, 64, (Def.SCREEN_WIDTH >> 1) - 48, Def.SCREEN_HEIGHT >> 1);
                        MyAPI.setBmfColor(1);
                        State.drawMenuFontByString(mFGraphics, 65, (Def.SCREEN_WIDTH >> 1) - 48, (Def.SCREEN_HEIGHT >> 1) + SonicDef.MENU_SPACE);
                        PlayerObject.clipMoveShadow(mFGraphics);
                        PlayerObject.drawNum(mFGraphics, score1, (Def.SCREEN_WIDTH >> 1) + NUM_DISTANCE, Def.SCREEN_HEIGHT >> 1, 2, 0);
                        PlayerObject.drawNum(mFGraphics, score2, (Def.SCREEN_WIDTH >> 1) + NUM_DISTANCE, (Def.SCREEN_HEIGHT >> 1) + SonicDef.MENU_SPACE, 2, 0);
                        MyAPI.setClip(mFGraphics, 0, 0, Def.SCREEN_WIDTH, Def.SCREEN_HEIGHT);
                        totalPlusscore = score1 + score2 + scoreNum;
                    }
                }
                if (!PlayerObject.clipMoveLogic()) break;
                MyAPI.setBmfColor(1);
                State.drawMenuFontByString(mFGraphics, 64, (Def.SCREEN_WIDTH >> 1) - 48, Def.SCREEN_HEIGHT >> 1);
                MyAPI.setBmfColor(1);
                State.drawMenuFontByString(mFGraphics, 65, (Def.SCREEN_WIDTH >> 1) - 48, (Def.SCREEN_HEIGHT >> 1) + SonicDef.MENU_SPACE);
                if (GameObject.stageModeState == 1) {
                    raceScoreNum = MyAPI.calNextPosition(raceScoreNum, totalPlusscore, 1, 5);
                } else {
                    scoreNum = MyAPI.calNextPosition(scoreNum, totalPlusscore, 1, 5);
                }
                score1 = MyAPI.calNextPosition(score1, 0, 1, 5);
                score2 = MyAPI.calNextPosition(score2, 0, 1, 5);
                PlayerObject.drawNum(mFGraphics, score1, (Def.SCREEN_WIDTH >> 1) + NUM_DISTANCE, Def.SCREEN_HEIGHT >> 1, 2, 0);
                PlayerObject.drawNum(mFGraphics, score2, (Def.SCREEN_WIDTH >> 1) + NUM_DISTANCE, (Def.SCREEN_HEIGHT >> 1) + SonicDef.MENU_SPACE, 2, 0);
                if (scoreNum != totalPlusscore) break;
                IsStarttoCnt = true;
                break;
            }
            case 1: {
                if (!PlayerObject.movingBar()) {
                    PlayerObject.drawMovingbar(mFGraphics, STAGE_PASS_STR_SPACE);
                    break;
                }
                PlayerObject.drawStagePassInfoScroll(mFGraphics, (Def.SCREEN_HEIGHT >> 1) - 40, 10, STAGE_PASS_STR_SPACE);
                State.drawMenuFontByString(mFGraphics, 66, (Def.SCREEN_WIDTH >> 1) - 64 + 0, Def.SCREEN_HEIGHT >> 1);
                if (PlayerObject.clipMoveLogic()) {
                    IsStarttoCnt = true;
                }
                PlayerObject.clipMoveShadow(mFGraphics);
                PlayerObject.drawRecordTime(mFGraphics, timeCount, (Def.SCREEN_WIDTH >> 1) + 72, Def.SCREEN_HEIGHT >> 1, 2, 2);
                MyAPI.setClip(mFGraphics, 0, 0, Def.SCREEN_WIDTH, Def.SCREEN_HEIGHT);
                if (PlayerObject.isRaceModeNewRecord() && IsStarttoCnt) {
                    IsDisplayRaceModeNewRecord = true;
                }
                if (!IsDisplayRaceModeNewRecord) break;
                MyAPI.setBmfColor(1);
                State.drawMenuFontByString(mFGraphics, 77, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + SonicDef.MENU_SPACE + 10);
                StageManager.setTimeModeScore(timeCount);
            }
        }
    }

    public static void gamepauseInit() {
        cursor = 0;
        cursorIndex = 0;
        Key.touchkeygameboardClose();
    }

    public static void gamepauseDraw(MFGraphics mFGraphics) {
        if (menuBgDrawer6 == null || menuBgDrawer7 == null) {
            menuBgDrawer6 = TitleState.menuBgButton.getDrawer(6, false, 0);
            menuBgDrawer7 = TitleState.menuBgButton.getDrawer(7, false, 0);
        }
        PAUSE_MENU_NORMAL_ITEM = PAUSE_MENU_NORMAL_NOSHOP;
        if (GameObject.stageModeState == 0) {
            GameState.GAMEPAUSE_OFFSETY = 25;
        } else if (GameObject.stageModeState == 1) {
            GameState.GAMEPAUSE_OFFSETY = 0;
        }
        if (GameObject.stageModeState == 0) {
            State.fillMenuRect(mFGraphics, (Def.SCREEN_WIDTH >> 1) + PAUSE_FRAME_OFFSET_X, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY), PAUSE_FRAME_WIDTH, PAUSE_FRAME_HEIGHT - 50 + (GameObject.stageModeState == 0 ? 5 : 25));
        } else {
            State.fillMenuRect(mFGraphics, (Def.SCREEN_WIDTH >> 1) + PAUSE_FRAME_OFFSET_X, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY), PAUSE_FRAME_WIDTH, PAUSE_FRAME_HEIGHT - 10 + (GameObject.stageModeState == 0 ? 10 : 15));
        }
        State.drawMenuFontByString(mFGraphics, 80, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + (Def.MENU_PAUSE_SPACE >> 1) + 8);
        currentPauseMenuItem = GameObject.stageModeState == 0 ? PAUSE_MENU_NORMAL_ITEM : PAUSE_MENU_RACE_ITEM;
        if (currentPauseMenuItem.length > 7) {
            if (cursorIndex > cursor) {
                cursorIndex = cursor;
            } else if (cursorIndex + 7 - 1 < cursor) {
                cursorIndex = cursor - 7 + 1;
            }
        } else {
            cursorIndex = 0;
        }
        if (Key.touchpause1 != null && Key.touchpause1.Isin()) {
            menuBgDrawer7.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 0);
        } else {
            menuBgDrawer6.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 0);
        }
        if (Key.touchpause2 != null && Key.touchpause2.Isin()) {
            menuBgDrawer7.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 1);
        } else {
            menuBgDrawer6.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 1);
        }
        if (Key.touchpause3 != null && Key.touchpause3.Isin()) {
            menuBgDrawer7.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 2);
        } else {
            menuBgDrawer6.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 2);
        }
        if (Key.touchpause4 != null && Key.touchpause4.Isin()) {
            menuBgDrawer7.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 3);
        } else {
            menuBgDrawer6.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 3);
        }
        if (Key.touchpause5 != null && Key.touchpause5.Isin()) {
            menuBgDrawer7.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 4);
        } else {
            menuBgDrawer6.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 4);
        }
        if (GameObject.stageModeState != 0) {
            if (Key.touchpause6 != null && Key.touchpause6.Isin()) {
                menuBgDrawer7.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 5);
            } else {
                menuBgDrawer6.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 5);
            }
        }
        if (GameObject.stageModeState != 0) {
            if (Key.touchpause7 != null && Key.touchpause7.Isin()) {
                menuBgDrawer7.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 6);
            } else {
                menuBgDrawer6.draw(mFGraphics, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * 6);
            }
        }
        MAX_ITEM_SHOW_NUM_TEMP = GameObject.stageModeState == 0 ? 5 : 7;
        for (int i = cursorIndex; i < cursorIndex + MAX_ITEM_SHOW_NUM_TEMP; ++i) {
            State.drawMenuFontByString(mFGraphics, currentPauseMenuItem[i], Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) + (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + 8 + (Def.MENU_PAUSE_SPACE >> 1) + Def.MENU_PAUSE_SPACE + (Def.MENU_PAUSE_SPACE + 7) * (i - cursorIndex));
        }
        if (currentPauseMenuItem.length > 7) {
            if (cursorIndex == 0) {
                State.drawMenuFontById(mFGraphics, 96, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) - (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + Def.MENU_PAUSE_SPACE * 3 / 4);
                GameState.IsSingleUp = false;
                GameState.IsSingleDown = true;
            } else if (cursorIndex == currentPauseMenuItem.length - 7) {
                State.drawMenuFontById(mFGraphics, 95, Def.SCREEN_WIDTH >> 1, (Def.SCREEN_HEIGHT >> 1) - (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + Def.MENU_PAUSE_SPACE * 3 / 4);
                GameState.IsSingleUp = true;
                GameState.IsSingleDown = false;
            } else {
                State.drawMenuFontById(mFGraphics, 95, (Def.SCREEN_WIDTH >> 1) - 23, (Def.SCREEN_HEIGHT >> 1) - (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + Def.MENU_PAUSE_SPACE * 3 / 4);
                State.drawMenuFontById(mFGraphics, 96, (Def.SCREEN_WIDTH >> 1) + 22, (Def.SCREEN_HEIGHT >> 1) - (PAUSE_FRAME_OFFSET_Y + GameState.GAMEPAUSE_OFFSETY) + Def.MENU_PAUSE_SPACE * 3 / 4);
                GameState.IsSingleUp = false;
                GameState.IsSingleDown = false;
            }
        }
        State.drawSoftKey(mFGraphics, true, true);
    }

    public void close() {
        this.waterFallDrawer = null;
        this.waterFlushDrawer = null;
        this.drawer = null;
        this.effectDrawer = null;
    }

    public static void doWhileQuitGame() {
        bariaDrawer = null;
        gBariaDrawer = null;
        invincibleAnimation = null;
        invincibleDrawer = null;
    }

    public static boolean IsInvincibility() {
        return invincibleCount > 0;
    }

    public static boolean IsUnderSheild() {
        return sheildType == 2;
    }

    public static boolean IsSpeedUp() {
        return speedCount > 0;
    }

    static {
        lifeDrawerX = 0;
        DEGREE_DIVIDE = new int[]{44, 75, 105, 136, 224, 255, 285, 316, 360};
        TRANS = new int[]{0, 5, 3, 6};
        FOCUS_MAX_OFFSET = MapManager.CAMERA_HEIGHT >> 2;
        FOOT_OFFSET_X = new int[]{-256, 256};
        collisionBlockGround = new CollisionBlock();
        collisionBlockGroundTmp = new CollisionBlock();
        collisionBlockSky = new CollisionBlock();
        tmpCurrentBlock = new CollisionBlock();
        tmpBeforeBlock = new CollisionBlock();
        ATTACK_POP_POWER = 774 + GameObject.GRAVITY;
        RANDOM_RING_NUM = new int[]{1, 5, 5, 5, 5, 10, 20, 30, 40};
        itemVec = new int[5][2];
        lifeNum = 2;
        timeStopped = false;
        uiOffsetX = 0;
        NumberSideX = (90 - MyAPI.zoomIn(MyAPI.ZOOM_OUT_MOVE == 1 ? 10 : 0)) * 1;
        NUM_PIC_WIDTH = MyAPI.ZOOM_OUT_MOVE == 0 ? 7 : MyAPI.zoomIn(5, true);
        NUM_PIC_HEIGHT = MyAPI.ZOOM_OUT_MOVE == 0 ? 13 : MyAPI.zoomIn(10, true);
        NUM_SPACE_ANIMATION = new int[]{8, 8, 16, 8, 8};
        NUM_SPACE_FONT = new int[]{Def.FONT_WIDTH_NUM, Def.FONT_WIDTH_NUM, Def.FONT_WIDTH_NUM, Def.FONT_WIDTH_NUM, Def.FONT_WIDTH_NUM};
        NUM_SPACE_IMAGE = new int[]{NUM_PIC_WIDTH + 1, NUM_PIC_WIDTH + 1, NUM_PIC_WIDTH + 1, NUM_PIC_WIDTH + 1, NUM_PIC_WIDTH + 1};
        NUM_SPACE = NUM_SPACE_ANIMATION;
        NUM_ANI_ID = new int[]{27, 37, 67, 125, 37};
        BG_NUM = (Def.SCREEN_WIDTH + 100 - 1) / 100;
        movespeed = 20;
        clipspeed = 5;
        score1 = 49700;
        score2 = 12700;
        STAGE_PASS_STR_SPACE_FONT = MyAPI.zoomIn(MFGraphics.stringWidth(0, "\u7d22\u5c3c\u514b\u5b8c\u6210\u884c\u52a81")) + 20;
        STAGE_PASS_STR_SPACE = 256 * 1;
        NUM_DISTANCE = MyAPI.ZOOM_OUT_MOVE == 0 ? 60 : 120;
        cursorMax = 5;
        PAUSE_FRAME_WIDTH = MyAPI.ZOOM_OUT_MOVE == 1 ? Def.FONT_WIDTH * 7 + MyAPI.zoomIn(22) : Def.FONT_WIDTH * 7;
        PAUSE_FRAME_HEIGHT = 5 * (SonicDef.MENU_SPACE + 7) + 20 + 60;
        PAUSE_FRAME_OFFSET_X = -(PAUSE_FRAME_WIDTH += 4) >> 1;
        PAUSE_FRAME_OFFSET_Y = -PAUSE_FRAME_HEIGHT >> 1;
        PAUSE_MENU_NORMAL_NOSHOP = new int[]{12, 5, 6, 81, 8};
        PAUSE_MENU_NORMAL_SHOP = new int[]{12, 81, 52, 5, 6};
        PAUSE_MENU_RACE_ITEM = new int[]{12, 82, 11, 5, 6, 81, 8};
    }
}

