/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;

public class PalettedImage {
    public MFImage image = null;
    public Palette p;
    public byte[] imgData;
    public int paletteOffset;
    public int CRCOffset;
    public int paletteColors;
    public boolean needRebuild;

    public MFImage getImage() {
        if (this.needRebuild) {
            this.rebuild();
        }
        return this.image;
    }

    public static PalettedImage createPalettedImage(byte[] byArray) {
        PalettedImage palettedImage = null;
        palettedImage = new PalettedImage();
        palettedImage.imgData = byArray;
        palettedImage.analyze();
        palettedImage.image = MFImage.createImage(new ByteArrayInputStream(palettedImage.imgData));
        return palettedImage;
    }

    public void analyze() {
        int n = 8;
        int n2 = 0;
        while (this.imgData[n + 4] != 80 || this.imgData[n + 5] != 76 || this.imgData[n + 6] != 84 || this.imgData[n + 7] != 69) {
            n2 = this.readInt(n);
            n += 8 + n2 + 4;
        }
        n2 = this.readInt(n);
        this.paletteColors = n2 / 3;
        this.paletteOffset = n + 8;
        this.CRCOffset = n + 8 + n2;
        this.p = new Palette(this.paletteColors);
        int n3 = 0;
        int n4 = this.paletteOffset;
        while (n3 < this.paletteColors) {
            this.p.setEntry(n3, (this.imgData[n4] & 0xFF) << 16 | (this.imgData[n4 + 1] & 0xFF) << 8 | this.imgData[n4 + 2] & 0xFF);
            ++n3;
            n4 += 3;
        }
    }

    public int readInt(int n) {
        return (this.imgData[n] & 0xFF) << 24 | (this.imgData[n + 1] & 0xFF) << 16 | (this.imgData[n + 2] & 0xFF) << 8 | this.imgData[n + 3] & 0xFF;
    }

    public void CRCChecksum() {
        int n = CRCUtil.checksum(this.imgData, this.paletteOffset - 4, this.paletteColors * 3 + 4);
        this.imgData[this.CRCOffset] = (byte)(n >> 24 & 0xFF);
        this.imgData[this.CRCOffset + 1] = (byte)(n >> 16 & 0xFF);
        this.imgData[this.CRCOffset + 2] = (byte)(n >> 8 & 0xFF);
        this.imgData[this.CRCOffset + 3] = (byte)(n & 0xFF);
    }

    public void rebuild() {
        this.CRCChecksum();
        this.image = null;
        this.image = MFImage.createImage(new ByteArrayInputStream(this.imgData));
        this.imgData = null;
        this.needRebuild = false;
        System.gc();
    }

    public void setPalette(Palette palette) {
        this.p = palette;
        int n = 0;
        int n2 = this.paletteOffset;
        while (n < palette.colors.length) {
            this.imgData[n2] = (byte)(palette.colors[n] >> 16 & 0xFF);
            this.imgData[n2 + 1] = (byte)(palette.colors[n] >> 8 & 0xFF);
            this.imgData[n2 + 2] = (byte)(palette.colors[n] & 0xFF);
            ++n;
            n2 += 3;
        }
        this.needRebuild = true;
    }
}

