/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class MFGraphics {
    public static Font font_small;
    public static Font font_medium;
    public static Font font_large;
    public int font_type;
    public Font currentFont;
    public static int xOff;
    public static int yOff;
    public int clipX;
    public int clipY;
    public int clipWidth;
    public int clipHeight;
    public int transX;
    public int transY;
    protected Graphics g;
    public int graphicsWidth;
    public int graphicsHeight;
    int[] fillRectRGB = new int[100];
    public static final short[] TRANMODIF;
    public static final byte[] TRANMODIF_2;

    protected static final void init() {
        if (font_small == null) {
            font_small = Font.getFont((int)0, (int)0, (int)8);
            font_medium = Font.getFont((int)0, (int)0, (int)0);
            font_large = Font.getFont((int)0, (int)0, (int)16);
        }
    }

    public static final MFGraphics createMFGraphics(Object object, int n, int n2) {
        MFGraphics mFGraphics = new MFGraphics();
        mFGraphics.setGraphics(object, n2, n);
        mFGraphics.disableEffect();
        return mFGraphics;
    }

    public final void setGraphics(Object object) {
        this.g = (Graphics)object;
        this.g.setClip(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    public final void setGraphics(Object object, int n, int n2) {
        this.graphicsWidth = n;
        this.graphicsHeight = n2;
        this.reset();
        this.setGraphics(object);
    }

    public Graphics getGraphics() {
        return this.g;
    }

    public final void reset() {
        this.transX = 0;
        this.transY = 0;
        this.clipX = 0;
        this.clipY = 0;
        this.clipWidth = this.graphicsHeight;
        this.clipHeight = this.graphicsWidth;
        this.currentFont = font_small;
    }

    public final void setClip(int n, int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = n3;
        n2 = n;
        n = 240 - n5 - n4;
        n3 = n4;
        n4 = n6;
        this.clipX = n + this.transX;
        this.clipY = n2 + this.transY;
        int n7 = this.clipX + n3;
        int n8 = this.clipY + n4;
        this.clipX = this.clipX < 0 ? 0 : this.clipX;
        this.clipY = this.clipY < 0 ? 0 : this.clipY;
        n7 = n7 > this.graphicsWidth ? this.graphicsWidth : n7;
        n8 = n8 > this.graphicsHeight ? this.graphicsHeight : n8;
        n7 = n7 < this.clipX ? this.clipX : n7;
        n8 = n8 < this.clipY ? this.clipY : n8;
        this.clipWidth = n7 - this.clipX;
        this.clipHeight = n8 - this.clipY;
        this.g.setClip(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    public final void drawImage(MFImage mFImage, int n, int n2, int n3) {
        this.caculateAnchorOffset(mFImage.getHeight(), mFImage.getWidth(), n3);
        this.drawImageImpl(mFImage, n + xOff, n2 + yOff);
    }

    public final void drawRegion(MFImage mFImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n5 <= 3) {
            this.caculateAnchorOffset(n3, n4, n8);
        } else {
            this.caculateAnchorOffset(n4, n3, n8);
        }
        this.drawRegionImpl(mFImage, n, n2, n3, n4, n5, n6 + xOff, n7 + yOff);
    }

    public final void caculateAnchorOffset(int n, int n2, int n3) {
        xOff = 0;
        yOff = 0;
        if ((n3 & 1) != 0) {
            xOff -= n >> 1;
        } else if ((n3 & 8) != 0) {
            xOff -= n;
        }
        if ((n3 & 2) != 0) {
            yOff -= n2 >> 1;
        } else if ((n3 & 0x20) != 0) {
            yOff -= n2;
        }
    }

    public void drawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.drawRGBImpl(nArray, n, n2, n3 + this.transX, n4 + this.transY, n5, n6, bl);
    }

    public void drawRGBImpl(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n3;
        n3 = 240 - n4 - n6;
        n4 = n7;
        int n8 = n5;
        n5 = n6;
        n6 = n8;
        this.g.drawRGB(nArray, n, n2, n3, n4, n5, n6, bl);
    }

    public void setColor(int n) {
        this.g.setColor(n);
    }

    public void setColor(int n, int n2, int n3) {
        this.g.setColor(n << 16 | n2 << 8 | n3);
    }

    public final void drawLine(int n, int n2, int n3, int n4) {
        int n5 = n;
        n = 240 - n2 - 1;
        n2 = n5;
        n5 = n3;
        n3 = 240 - n4 - 1;
        n4 = n5;
        this.g.drawLine(n + this.transX, n2 + this.transY, n3 + this.transX, n4 + this.transY);
    }

    public final void drawRect(int n, int n2, int n3, int n4) {
        int n5 = n;
        n = 240 - n2 - n4;
        n2 = n5;
        n5 = n3;
        n3 = n4;
        n4 = n5;
        if (n3 < 0 || n4 < 0) {
            return;
        }
        this.g.drawRect(n + this.transX, n2 + this.transY, n3, n4);
    }

    public final void fillRect(int n, int n2, int n3, int n4) {
        int n5 = n;
        n = 240 - n2 - n4;
        n2 = n5;
        n5 = n3;
        n3 = n4;
        n4 = n5;
        this.g.fillRect(n + this.transX, n2 + this.transY, n3, n4);
    }

    public final void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        n = 240 - n2 - n4;
        n2 = n7;
        n7 = n3;
        n3 = n4;
        n4 = n7;
        this.g.fillArc(n + this.transX, n2 + this.transY, n3, n4, n5 -= 90, n6);
    }

    public final void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n;
        n = 240 - n2 - n4;
        n2 = n7;
        n7 = n3;
        n3 = n4;
        n4 = n7;
        n7 = n5;
        n5 = n6;
        n6 = n7;
        this.g.fillRoundRect(n + this.transX, n2 + this.transY, n3, n4, n5, n5);
    }

    public static final Font getFont(int n) {
        switch (n) {
            case 0: {
                return font_small;
            }
            case 1: {
                return font_medium;
            }
            case 2: {
                return font_large;
            }
        }
        return null;
    }

    public final void setFont(int n) {
        this.currentFont = MFGraphics.getFont(n);
        if (this.currentFont != null) {
            this.font_type = n;
            this.g.setFont(this.currentFont);
        }
    }

    public static final int drawStringOffset(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    public final void drawString(String string, int n, int n2, int n3) {
        int n4 = n2;
        n2 = n;
        n = 240 - n4;
        this.caculateAnchorOffset(this.stringWidth(string), this.charHeight(), n3);
        this.g.drawString(string, n + xOff + this.transX, n2 + yOff + MFGraphics.drawStringOffset(this.font_type) + this.transY, 20);
    }

    public static final int charHeight(int n) {
        switch (n) {
            case 0: {
                return 17;
            }
            case 1: {
                return 21;
            }
            case 2: {
                return 24;
            }
        }
        return 0;
    }

    public static final int stringWidth(int n, String string) {
        Font font = MFGraphics.getFont(n);
        return font.stringWidth(string);
    }

    public final int charHeight() {
        return MFGraphics.charHeight(this.font_type);
    }

    public final int stringWidth(String string) {
        return MFGraphics.stringWidth(this.font_type, string);
    }

    public final void disableEffect() {
    }

    public final void drawImageImpl(MFImage mFImage, int n, int n2) {
        int n3 = n2;
        n2 = n;
        n = 240 - n3;
        this.g.drawImage(mFImage.image, n + this.transX, n2 + this.transY, 24);
    }

    public final void drawRegionImpl(MFImage mFImage, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2;
        n2 = n;
        n = mFImage.getWidth() - n8 - n4;
        int n9 = n7;
        n7 = n6;
        n6 = 240 - n9;
        this.g.drawRegion(mFImage.image, n, n2, n4, n3, n5, n6 + this.transX, n7 + this.transY, 24);
    }

    static {
        xOff = 0;
        yOff = 0;
        TRANMODIF = new short[]{0, 90, 8192, 16474, 16384, 16654, 180, 270};
        TRANMODIF_2 = new byte[]{0, 4, 2, 6, 3, 7, 1, 5};
    }
}

