/*
 * Decompiled with CFR 0.152.
 */
class FreeFallPlatform
extends GimmickObject {
    public FreeFallSystem system;
    public static MFImage image = null;

    protected FreeFallPlatform(FreeFallSystem freeFallSystem, int n, int n2) {
        super(0, n, n2, 0, 0, 0, 0);
        this.system = freeFallSystem;
        if (image == null) {
            try {
                image = MFImage.createImage("/gimmick/freefall_platform.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void platformLogic() {
        Coordinate coordinate = this.system.getBarPosition();
        this.checkWithPlayer(this.posX, this.posY, coordinate.x, coordinate.y);
        this.posX = coordinate.x;
        this.posY = coordinate.y;
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.system.moving) {
            this.drawInMap(mFGraphics, image, (int)(GameObject.systemClock / 5L % 2L) * 96, 0, 96, 40, 0, 17);
        } else {
            this.drawInMap(mFGraphics, image, 0, 0, 96, 40, 0, 17);
        }
        this.drawCollisionRect(mFGraphics);
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 3072, n2 + 768, 6144, 1792);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        playerObject.beStop(0, n, this);
    }

    public void close() {
        this.system = null;
    }

    public static void releaseAllResource() {
        image = null;
    }

    public int getPaintLayer() {
        return 0;
    }
}

