/*
 * Decompiled with CFR 0.152.
 */
class Cage
extends GimmickObject
implements MapBehavior {
    public static MFImage cageImage = null;
    public static MFImage cageExplosiveImage = null;
    public CageButton button;
    public MapObject mapObj;
    public int doorPosX;
    public int doorPosX2;
    public int doorPosY;
    public int doorVelocityY;
    public int state;
    public int animalCount;
    public int count;
    public boolean attacking;

    protected Cage(int n, int n2) {
        super(0, n, n2, 0, 0, 0, 0);
        if (cageImage == null) {
            try {
                cageImage = MFImage.createImage("/gimmick/cage.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (cageExplosiveImage == null) {
            try {
                cageExplosiveImage = MFImage.createImage("/gimmick/cage_door.png");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.button = new CageButton(this.posX, this.posY + -3904);
        GameObject.addGameObject(this.button, this.posX, this.posY);
        this.mapObj = new MapObject(this.posX, this.posY, 0, 0, this, 1);
        this.mapObj.setBehavior(this);
        this.state = 0;
        this.attacking = true;
        MapManager.setCameraLeftLimit(MapManager.getCamera().x);
        MapManager.setCameraRightLimit(MapManager.getCamera().x + MapManager.CAMERA_WIDTH);
    }

    public void logic() {
        switch (this.state) {
            case 0: {
                this.mapObj.logic();
                this.checkWithPlayer(this.posX, this.posY, this.mapObj.getPosX(), this.mapObj.getPosY());
                this.posX = this.mapObj.getPosX();
                this.posY = this.mapObj.getPosY();
                if (this.button.used) break;
                this.button.posX = this.posX;
                this.button.posY = this.posY + -3904;
                break;
            }
            case 1: {
                this.attacking = false;
                if (!this.button.used) break;
                this.state = 2;
                this.doorPosX = this.posX;
                this.doorPosX2 = this.posX;
                this.doorPosY = this.posY;
                this.doorVelocityY = -600;
                this.animalCount = 7;
                this.count = 0;
                break;
            }
            case 2: {
                this.doorPosX -= 300;
                this.doorPosX2 += 300;
                this.doorVelocityY += GameObject.GRAVITY;
                this.doorPosY += this.doorVelocityY;
                if (this.count > 0) {
                    --this.count;
                }
                if (this.count != 0 || this.animalCount <= 0) break;
                SmallAnimal.addPatrolAnimal(2, this.posX, this.posY - 640, 1, this.posX - 3200, this.posX + 3200);
                SmallAnimal.addPatrolAnimal(1, this.posX, this.posY - 640, 1, this.posX - 3200, this.posX + 3200);
                this.count = 4;
                --this.animalCount;
            }
        }
    }

    public void draw(MFGraphics mFGraphics) {
        switch (this.state) {
            case 2: {
                this.drawInMap(mFGraphics, cageImage, 72, 0, 72, 72, 0, this.posX, this.posY, 33);
                this.button.drawButton(mFGraphics);
                this.drawInMap(mFGraphics, cageExplosiveImage, this.doorPosX, this.doorPosY, 40);
                this.drawInMap(mFGraphics, cageExplosiveImage, 0, 0, MyAPI.zoomIn(cageExplosiveImage.getHeight()), MyAPI.zoomIn(cageExplosiveImage.getWidth()), 1, this.doorPosX2, this.doorPosY, 36);
                break;
            }
            default: {
                this.drawInMap(mFGraphics, cageImage, 0, 0, 72, 72, 0, this.posX, this.posY, 33);
                this.button.drawButton(mFGraphics);
            }
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        this.collisionRect.setRect(n - 1856, n2 - 3392, 3712, 3392);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.attacking) {
            playerObject.beHurtByCage();
        } else {
            playerObject.beStop(0, n, this);
        }
    }

    public void doWhileTouchGround(int n, int n2) {
        this.state = 1;
        MapManager.setShake(8);
    }

    public void close() {
        this.mapObj = null;
        this.button = null;
    }

    public static void releaseAllResource() {
        cageImage = null;
        cageExplosiveImage = null;
    }

    public boolean hasSideCollision() {
        return false;
    }

    public boolean hasTopCollision() {
        return false;
    }

    public int getPaintLayer() {
        return 0;
    }
}

