/*
 * Decompiled with CFR 0.152.
 */
class Boss5
extends BossObject {
    public int COLLISION_WIDTH = 1024;
    public int COLLISION_HEIGHT = 1664;
    public int BOSS5_WIDTH = 1536;
    public int boomX;
    public int boomY;
    public int limitRightX;
    public int limitLeftX;
    public int alert_state;
    public int ALERT_RANGE = 11520;
    public int fly_top_offset = 5632;
    public int fly_top;
    public int fly_up_speed1 = 704;
    public int fly_move_x_speed1 = -772;
    public int fly_move_y_speed1 = 140;
    public int fly_drip_offset = 2304;
    public int fly_attack_site;
    public int fight_alert_range = 2048;
    public int missile_alert_state;
    public int missile_alert_range = 5120;
    public int talk_cnt = 0;
    public int ready_cnt = 0;
    public int velocity = -768;
    public int horizon_move_speed = 1080;
    public int velX;
    public int velY;
    public static Animation knucklesAni;
    public static Animation BoomAni;
    public static Animation boatAni;
    public static Animation escapefaceAni;
    public AnimationDrawer knuckdrawer;
    public AnimationDrawer boomdrawer;
    public AnimationDrawer boatdrawer;
    public AnimationDrawer escapefacedrawer;
    public int state;
    public int prestate;
    public int horizonAttackReady_cnt;
    public int horizonAttackReady_cnt_max = 16;
    public int AttackStartDirection;
    public boolean IsConner = false;
    public boolean IsPlayerRunaway = false;
    public int defence_cnt = 0;
    public int first_jump_cnt = 0;
    public BossBroken bossbroken;
    public int boom_offset = 640;
    public int KOWaitCnt;
    public int KOWaitCntMax = 10;
    public boolean IsHurt = false;
    public int HP = 8;
    public int[] Viy = new int[]{-1200, -1050, -900, -750, -600};
    public int[] Vix = new int[]{750, -300, -150, 150, 450, -750, 600, 300, -450};
    public int[][] pos;
    public int pieces_drip_cnt;
    public int escape_v = 512;
    public int fly_end;
    public int fly_range = 4096;
    public int WaitCnt;
    public int escape_cnt = 0;
    public int escape_cnt_max = 60;
    public Boss5FlyDefence flydefence;
    public int enemyDirct;
    public static final int SIDE_LEFT;
    public static final int MEET_SONIC_LINE;
    public static final int BEFORE_MEET_LINE;
    public static final int MIDDLE_SCREEN;
    public static final int EGG_SIDE_RIGHT;

    public static void releaseAllResource() {
        knucklesAni = null;
        BoomAni = null;
        boatAni = null;
        escapefaceAni = null;
    }

    protected Boss5(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6, n7);
        this.posX -= this.iLeft * 8;
        this.posY -= this.iTop * 8;
        this.posY -= 960;
        this.posX = 605696;
        this.posY = this.getGroundY(this.posX, this.posY);
        this.limitRightX = 606720;
        this.limitLeftX = SIDE_LEFT + 16 << 6;
        this.fly_top = this.posY - this.fly_top_offset;
        this.refreshCollisionRect(this.posX >> 6, this.posY >> 6);
        if (knucklesAni == null) {
            knucklesAni = new Animation("/animation/boss5");
        }
        this.knuckdrawer = knucklesAni.getDrawer(0, true, 0);
        if (BoomAni == null) {
            BoomAni = new Animation("/animation/boom");
        }
        this.boomdrawer = BoomAni.getDrawer(0, true, 0);
        if (boatAni == null) {
            boatAni = new Animation("/animation/pod_boat");
        }
        this.boatdrawer = boatAni.getDrawer(0, true, 0);
        if (escapefaceAni == null) {
            escapefaceAni = new Animation("/animation/pod_face");
        }
        this.escapefacedrawer = escapefaceAni.getDrawer(2, false, 0);
        this.flydefence = new Boss5FlyDefence(33, n2, n3, 0, 0, 0, 0);
        GameObject.addGameObject(this.flydefence, n2, n3);
    }

    public void doWhileCollision(PlayerObject playerObject, int n) {
        if (this.dead) {
            return;
        }
        if (playerObject == GameObject.player) {
            if (GameObject.player.isAttackingEnemy()) {
                switch (this.state) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: {
                        GameObject.player.beHurt();
                        break;
                    }
                    case 3: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 20: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        break;
                    }
                    case 16: 
                    case 17: 
                    case 18: 
                    case 33: 
                    case 34: 
                    case 35: {
                        this.PlayerHurtBall(playerObject, n);
                        break;
                    }
                    default: {
                        this.enemyDirct = n;
                        this.HurtLogic();
                        break;
                    }
                }
            } else {
                switch (this.state) {
                    case 4: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 19: 
                    case 20: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        break;
                    }
                    default: {
                        GameObject.player.beHurt();
                    }
                }
            }
        }
    }

    public void HurtLogic() {
        if (!this.IsHurt) {
            GameObject.player.doAttackPose(this, this.enemyDirct);
            --this.HP;
            this.velY = -Math.abs(this.velocity);
            this.velX = GameObject.player.getVelX() > 0 ? Math.abs(this.velocity) >> 1 : -Math.abs(this.velocity) >> 1;
            this.hurt_side_cotrol();
            this.IsHurt = true;
            if (this.HP >= 4) {
                this.changeAniState(this.knuckdrawer, 5, false);
                this.state = 13;
                if (this.HP == 4) {
                    SoundSystem.getInstance().playSe(2, false);
                } else {
                    SoundSystem.getInstance().playSe(2, false);
                }
            } else if (this.HP == 0) {
                this.changeAniState(this.knuckdrawer, 39, true);
                this.state = 36;
                SoundSystem.getInstance().playSe(2, false);
            } else {
                this.changeAniState(this.knuckdrawer, 23, false);
                this.state = 30;
                SoundSystem.getInstance().playSe(2, false);
            }
            this.COLLISION_WIDTH = 64;
            this.COLLISION_HEIGHT = 64;
        }
    }

    public void PlayerHurtBall(PlayerObject playerObject, int n) {
        int n2 = Math.abs(GameObject.player.getVelX());
        int n3 = GameObject.player.getAnimationId();
        switch (n) {
            case 3: {
                playerObject.beStop(this.collisionRect.x0, n, this);
                GameObject.player.setVelX(-n2);
                break;
            }
            case 2: {
                playerObject.beStop(this.collisionRect.x1, n, this);
                GameObject.player.setVelX(n2);
                break;
            }
            case 0: {
                playerObject.beStop(this.collisionRect.y1, n, this);
                break;
            }
            case 1: 
            case 4: {
                playerObject.beStop(this.collisionRect.y0, n, this);
            }
        }
        GameObject.player.setAnimationId(n3);
        if (this.defence_cnt < 15) {
            ++this.defence_cnt;
        } else {
            this.IsPlayerRunaway = true;
        }
    }

    public boolean IsNeedforDefence(int n) {
        return n == 0 && GameObject.player.isAttackingEnemy() && GameObject.player.isOnGound();
    }

    public void logic() {
        if (this.dead) {
            return;
        }
        int n = this.posX;
        int n2 = this.posY;
        this.boomX = n;
        this.boomY = n2;
        if (this.boomY + 1024 + this.velY >= this.getGroundY(this.boomX, this.boomY)) {
            this.boomY = this.getGroundY(this.boomX, this.boomY) - 1024;
        }
        switch (this.state) {
            case 0: {
                if (GameObject.player.getFootPositionX() < BEFORE_MEET_LINE) break;
                this.state = 1;
                int n3 = 1143 - MapManager.CAMERA_HEIGHT * 3 / 4;
                MapManager.setCameraUpLimit(n3);
                int n4 = 1143 + MapManager.CAMERA_HEIGHT * 1 / 4;
                MapManager.setCameraDownLimit(n4);
                if (this.IsPlayBossBattleBGM) break;
                GameObject.bossFighting = true;
                if (PlayerObject.speedCount > 0) {
                    SoundSystem.getInstance().playBgm(15, true);
                } else {
                    SoundSystem.getInstance().playBgm(9, true);
                }
                this.IsPlayBossBattleBGM = true;
                break;
            }
            case 1: {
                if (GameObject.player.getFootPositionX() >= MEET_SONIC_LINE) {
                    GameObject.player.setMeetingBoss(false);
                    MapManager.setCameraLeftLimit(SIDE_LEFT);
                    MapManager.setCameraRightLimit(9496);
                } else {
                    int n5 = 0;
                    n5 = MapManager.getCamera().x;
                    MapManager.setCameraLeftLimit(n5);
                }
                if (this.posX >= MapManager.getCamera().x + MapManager.CAMERA_WIDTH - 30 << 6) break;
                this.changeAniState(this.knuckdrawer, 0, false);
                this.COLLISION_WIDTH = 1024;
                this.COLLISION_HEIGHT = 1664;
                this.state = 2;
                break;
            }
            case 2: {
                if (this.knuckdrawer.checkEnd()) {
                    this.changeAniState(this.knuckdrawer, 1, true);
                    this.COLLISION_WIDTH = 1024;
                    this.COLLISION_HEIGHT = 1664;
                }
                if (this.talk_cnt < 30) {
                    ++this.talk_cnt;
                    break;
                }
                this.talk_cnt = 0;
                this.state = 4;
                GameObject.player.setMeetingBoss(true);
                break;
            }
            case 13: {
                this.flydefence.setHurtState(false);
                if (this.knuckdrawer.checkEnd()) {
                    this.changeAniStateNoTrans(this.knuckdrawer, 6, true);
                    this.state = 14;
                    break;
                }
                this.hurt_air_control();
                break;
            }
            case 14: {
                this.flydefence.setHurtState(false);
                if (this.posY + this.velY >= this.getGroundY(this.posX, this.posY)) {
                    this.posY = this.getGroundY(this.posX, this.posY);
                    this.changeAniStateNoTrans(this.knuckdrawer, 7, false);
                    this.state = 15;
                    break;
                }
                this.hurt_air_control();
                break;
            }
            case 15: {
                this.flydefence.setHurtState(false);
                if (!this.knuckdrawer.checkEnd()) break;
                if (this.HP == 4) {
                    this.state = 20;
                    this.prestate = 32;
                    break;
                }
                this.state = 3;
                this.prestate = 15;
                break;
            }
            case 3: {
                this.state = this.randomSetState();
                break;
            }
            case 4: {
                this.alert_state = this.checkPlayerInEnemyAlertRange(this.posX >> 6, this.posY >> 6, this.fight_alert_range * 2);
                if (this.IsNeedforDefence(this.alert_state)) {
                    this.changeAniState(this.knuckdrawer, 13, false);
                    this.COLLISION_WIDTH = 1024;
                    this.COLLISION_HEIGHT = 1024;
                    this.state = 16;
                    this.IsPlayerRunaway = false;
                    this.defence_cnt = 0;
                    break;
                }
                if (this.ready_cnt < 24) {
                    ++this.ready_cnt;
                    break;
                }
                this.ready_cnt = 0;
                this.state = 3;
                this.prestate = 4;
                break;
            }
            case 16: {
                if (!this.knuckdrawer.checkEnd()) break;
                this.changeAniState(this.knuckdrawer, 14, true);
                this.COLLISION_WIDTH = 1024;
                this.COLLISION_HEIGHT = 1024;
                this.state = 17;
                break;
            }
            case 17: {
                if (!this.IsPlayerRunaway && GameObject.player.isAttackingEnemy() && GameObject.player.isOnGound()) break;
                this.changeAniState(this.knuckdrawer, 15, false);
                this.COLLISION_WIDTH = 1024;
                this.COLLISION_HEIGHT = 1024;
                this.state = 18;
                break;
            }
            case 18: {
                if (!this.knuckdrawer.checkEnd()) break;
                this.state = 3;
                this.prestate = 18;
                this.IsPlayerRunaway = false;
                break;
            }
            case 5: {
                if (this.horizonAttackReady_cnt < this.horizonAttackReady_cnt_max) {
                    ++this.horizonAttackReady_cnt;
                    break;
                }
                int n6 = this.IsHurt ? 8 : 3;
                this.changeAniState(this.knuckdrawer, n6, true);
                this.COLLISION_WIDTH = 1536;
                this.COLLISION_HEIGHT = 1536;
                this.horizonAttackReady_cnt = 0;
                this.state = 6;
                break;
            }
            case 6: {
                this.IsHurt = false;
                if (this.AttackStartDirection > 0) {
                    if (this.posX <= this.limitLeftX) {
                        this.posX = this.limitLeftX;
                        this.IsConner = true;
                    } else {
                        this.posX += this.horizon_move_speed;
                    }
                } else if (this.posX >= this.limitRightX) {
                    this.posX = this.limitRightX;
                    this.IsConner = true;
                } else {
                    this.posX += this.horizon_move_speed;
                }
                if (!this.IsConner) break;
                this.horizonAttackReady_cnt = 0;
                this.IsConner = false;
                this.state = 3;
                this.prestate = 6;
                break;
            }
            case 7: {
                if (this.posY <= this.fly_top) {
                    this.posY = this.fly_top;
                    this.changeAniState(this.knuckdrawer, 16, true);
                    this.AttackStartDirection = this.posX - GameObject.player.getFootPositionX();
                    this.COLLISION_WIDTH = 960;
                    this.COLLISION_HEIGHT = 1472;
                    this.state = 8;
                    break;
                }
                this.posY -= this.fly_up_speed1;
                break;
            }
            case 8: {
                this.IsHurt = false;
                if (this.AttackStartDirection > 0) {
                    this.fly_attack_site = GameObject.player.getFootPositionX() - this.fly_drip_offset > this.limitLeftX ? GameObject.player.getFootPositionX() - this.fly_drip_offset : this.limitLeftX;
                    if (this.posX + this.fly_move_x_speed1 <= this.fly_attack_site) {
                        this.posX = this.fly_attack_site;
                        this.changeAniStateNoTrans(this.knuckdrawer, 10, false);
                        this.COLLISION_WIDTH = 1920;
                        this.COLLISION_HEIGHT = 2432;
                        this.state = 9;
                        break;
                    }
                    this.posX += this.fly_move_x_speed1;
                    this.posY += this.fly_move_y_speed1;
                    break;
                }
                this.fly_attack_site = GameObject.player.getFootPositionX() + this.fly_drip_offset < this.limitRightX ? GameObject.player.getFootPositionX() + this.fly_drip_offset : this.limitRightX;
                if (this.posX + this.fly_move_x_speed1 >= this.fly_attack_site) {
                    this.posX = this.fly_attack_site;
                    this.changeAniStateNoTrans(this.knuckdrawer, 10, false);
                    this.COLLISION_WIDTH = 1408;
                    this.COLLISION_HEIGHT = 2432;
                    this.state = 9;
                    break;
                }
                this.posX += this.fly_move_x_speed1;
                this.posY += this.fly_move_y_speed1;
                break;
            }
            case 9: {
                if (!this.knuckdrawer.checkEnd()) break;
                this.changeAniStateNoTrans(this.knuckdrawer, 11, true);
                this.COLLISION_WIDTH = 1536;
                this.COLLISION_HEIGHT = 2432;
                this.state = 10;
                this.velY = 0;
                break;
            }
            case 10: {
                if (this.posY + this.velY >= this.getGroundY(this.posX, this.posY)) {
                    this.posY = this.getGroundY(this.posX, this.posY);
                    this.changeAniStateNoTrans(this.knuckdrawer, 12, false);
                    this.COLLISION_WIDTH = 1408;
                    this.COLLISION_HEIGHT = 1920;
                    this.state = 11;
                    break;
                }
                this.velY += GameObject.GRAVITY;
                this.posY += this.velY;
                break;
            }
            case 11: {
                if (!this.knuckdrawer.checkEnd()) break;
                this.state = 3;
                this.prestate = 11;
                break;
            }
            case 12: {
                if (this.knuckdrawer.checkEnd()) {
                    this.state = 3;
                    this.prestate = 12;
                    break;
                }
                if (this.knuckdrawer.getCurrentFrame() == 3 || this.knuckdrawer.getCurrentFrame() == 4 || this.knuckdrawer.getCurrentFrame() == 5 || this.knuckdrawer.getCurrentFrame() == 6 || this.knuckdrawer.getCurrentFrame() == 11 || this.knuckdrawer.getCurrentFrame() == 12) {
                    this.COLLISION_WIDTH = 3584;
                    this.COLLISION_HEIGHT = 2176;
                    break;
                }
                this.COLLISION_WIDTH = 1536;
                this.COLLISION_HEIGHT = 1920;
                break;
            }
            case 20: {
                this.state = this.randomSetState();
                break;
            }
            case 30: {
                this.flydefence.setHurtState(false);
                if (this.knuckdrawer.checkEnd()) {
                    this.changeAniStateNoTrans(this.knuckdrawer, 24, true);
                    this.state = 31;
                    break;
                }
                this.hurt_air_control();
                break;
            }
            case 31: {
                this.flydefence.setHurtState(false);
                if (this.posY + this.velY >= this.getGroundY(this.posX, this.posY)) {
                    this.posY = this.getGroundY(this.posX, this.posY);
                    this.changeAniStateNoTrans(this.knuckdrawer, 25, false);
                    this.state = 32;
                    break;
                }
                this.hurt_air_control();
                break;
            }
            case 32: {
                this.flydefence.setHurtState(false);
                if (!this.knuckdrawer.checkEnd()) break;
                this.state = 20;
                this.prestate = 32;
                break;
            }
            case 19: {
                this.alert_state = this.checkPlayerInEnemyAlertRange(this.posX >> 6, this.posY >> 6, this.fight_alert_range * 2);
                if (this.IsNeedforDefence(this.alert_state)) {
                    this.changeAniState(this.knuckdrawer, 31, false);
                    this.COLLISION_WIDTH = 1024;
                    this.COLLISION_HEIGHT = 1024;
                    this.state = 33;
                    this.IsPlayerRunaway = false;
                    this.defence_cnt = 0;
                    break;
                }
                if (this.ready_cnt < 24) {
                    ++this.ready_cnt;
                    break;
                }
                this.ready_cnt = 0;
                this.state = 20;
                this.prestate = 19;
                break;
            }
            case 33: {
                if (!this.knuckdrawer.checkEnd()) break;
                this.changeAniState(this.knuckdrawer, 32, true);
                this.COLLISION_WIDTH = 1024;
                this.COLLISION_HEIGHT = 1024;
                this.state = 34;
                break;
            }
            case 34: {
                if (!this.IsPlayerRunaway && GameObject.player.isAttackingEnemy() && GameObject.player.isOnGound()) break;
                this.changeAniState(this.knuckdrawer, 33, false);
                this.COLLISION_WIDTH = 1024;
                this.COLLISION_HEIGHT = 1024;
                this.state = 35;
                break;
            }
            case 35: {
                if (!this.knuckdrawer.checkEnd()) break;
                this.changeAniState(this.knuckdrawer, 19, false);
                this.COLLISION_WIDTH = 1024;
                this.COLLISION_HEIGHT = 1664;
                this.state = 20;
                this.prestate = 35;
                this.IsPlayerRunaway = false;
                break;
            }
            case 28: {
                if (!this.knuckdrawer.checkEnd()) break;
                this.changeAniState(this.knuckdrawer, 37, false);
                this.COLLISION_WIDTH = 1408;
                this.COLLISION_HEIGHT = 2176;
                this.state = 29;
                if (this.posX - GameObject.player.getFootPositionX() > 0) {
                    BulletObject.addBullet(16, this.posX - 1280, this.posY - 1280, -320, 0);
                    break;
                }
                BulletObject.addBullet(16, this.posX + 1280, this.posY - 1280, 320, 0);
                break;
            }
            case 29: {
                this.IsHurt = false;
                if (!this.knuckdrawer.checkEnd()) break;
                this.state = 20;
                this.prestate = 29;
                break;
            }
            case 21: {
                if (this.horizonAttackReady_cnt < this.horizonAttackReady_cnt_max) {
                    ++this.horizonAttackReady_cnt;
                    break;
                }
                int n7 = this.IsHurt ? 26 : 21;
                this.changeAniState(this.knuckdrawer, n7, true);
                this.COLLISION_WIDTH = 1536;
                this.COLLISION_HEIGHT = 1536;
                this.horizonAttackReady_cnt = 0;
                this.state = 22;
                break;
            }
            case 22: {
                this.IsHurt = false;
                if (this.AttackStartDirection > 0) {
                    if (this.posX <= this.limitLeftX) {
                        this.posX = this.limitLeftX;
                        this.IsConner = true;
                    } else {
                        this.posX += this.horizon_move_speed;
                    }
                } else if (this.posX >= this.limitRightX) {
                    this.posX = this.limitRightX;
                    this.IsConner = true;
                } else {
                    this.posX += this.horizon_move_speed;
                }
                if (!this.IsConner) break;
                this.horizonAttackReady_cnt = 0;
                this.IsConner = false;
                this.state = 20;
                this.prestate = 22;
                break;
            }
            case 23: {
                if (this.posY <= this.fly_top) {
                    this.posY = this.fly_top;
                    this.changeAniState(this.knuckdrawer, 34, true);
                    this.AttackStartDirection = this.posX - GameObject.player.getFootPositionX();
                    this.COLLISION_WIDTH = 960;
                    this.COLLISION_HEIGHT = 1472;
                    this.state = 24;
                    break;
                }
                this.posY -= Math.abs(this.velocity);
                break;
            }
            case 24: {
                this.IsHurt = false;
                if (this.AttackStartDirection > 0) {
                    this.fly_attack_site = GameObject.player.getFootPositionX() - this.fly_drip_offset > this.limitLeftX ? GameObject.player.getFootPositionX() - this.fly_drip_offset : this.limitLeftX;
                    if (this.posX + this.fly_move_x_speed1 <= this.fly_attack_site) {
                        this.posX = this.fly_attack_site;
                        this.changeAniStateNoTrans(this.knuckdrawer, 28, false);
                        this.COLLISION_WIDTH = 1920;
                        this.COLLISION_HEIGHT = 2432;
                        this.state = 25;
                        break;
                    }
                    this.posX += this.fly_move_x_speed1;
                    this.posY += this.fly_move_y_speed1;
                    break;
                }
                this.fly_attack_site = GameObject.player.getFootPositionX() + this.fly_drip_offset < this.limitRightX ? GameObject.player.getFootPositionX() + this.fly_drip_offset : this.limitRightX;
                if (this.posX + this.fly_move_x_speed1 >= this.fly_attack_site) {
                    this.posX = this.fly_attack_site;
                    this.changeAniStateNoTrans(this.knuckdrawer, 28, false);
                    this.COLLISION_WIDTH = 1408;
                    this.COLLISION_HEIGHT = 2432;
                    this.state = 25;
                    break;
                }
                this.posX += this.fly_move_x_speed1;
                this.posY += this.fly_move_y_speed1;
                break;
            }
            case 25: {
                if (!this.knuckdrawer.checkEnd()) break;
                this.changeAniStateNoTrans(this.knuckdrawer, 29, true);
                this.COLLISION_WIDTH = 1536;
                this.COLLISION_HEIGHT = 2432;
                this.state = 26;
                this.velY = 0;
                break;
            }
            case 26: {
                if (this.posY + this.velY >= this.getGroundY(this.posX, this.posY)) {
                    this.posY = this.getGroundY(this.posX, this.posY);
                    this.changeAniStateNoTrans(this.knuckdrawer, 30, false);
                    this.COLLISION_WIDTH = 1408;
                    this.COLLISION_HEIGHT = 1920;
                    this.state = 27;
                    break;
                }
                this.velY += GameObject.GRAVITY;
                this.posY += this.velY;
                break;
            }
            case 27: {
                if (!this.knuckdrawer.checkEnd()) break;
                this.state = 20;
                this.prestate = 27;
                break;
            }
            case 36: {
                if (this.posY + this.velY >= this.getGroundY(this.posX, this.posY)) {
                    this.posY = this.getGroundY(this.posX, this.posY);
                    this.changeAniState(this.knuckdrawer, 40, true);
                    this.state = 37;
                    break;
                }
                this.hurt_air_control();
                break;
            }
            case 37: {
                if (this.KOWaitCnt < this.KOWaitCntMax) {
                    ++this.KOWaitCnt;
                    break;
                }
                this.state = 38;
                this.bossbroken = new BossBroken(26, this.posX >> 6, this.posY >> 6, 0, 0, 0, 0);
                GameObject.addGameObject(this.bossbroken, this.posX >> 6, this.posY >> 6);
                this.bossbroken.setTotalCntMax(6);
                this.bossbroken.setJumpTime(9);
                break;
            }
            case 38: {
                this.bossbroken.logicBoom(this.posX, this.posY);
                if (!this.bossbroken.getEndState()) break;
                this.state = 39;
                this.pos = new int[6][4];
                for (int i = 0; i < this.pos.length; ++i) {
                    this.pos[i][0] = this.posX;
                    this.pos[i][1] = this.posY - this.boom_offset;
                    this.pos[i][2] = this.Vix[MyRandom.nextInt(this.Vix.length)];
                    this.pos[i][3] = this.Viy[MyRandom.nextInt(this.Viy.length)];
                }
                break;
            }
            case 39: {
                for (int i = 0; i < this.pos.length; ++i) {
                    int[] nArray = this.pos[i];
                    nArray[0] = nArray[0] + this.pos[i][2];
                    int[] nArray2 = this.pos[i];
                    nArray2[3] = nArray2[3] + (GameObject.GRAVITY >> 1);
                    int[] nArray3 = this.pos[i];
                    nArray3[1] = nArray3[1] + this.pos[i][3];
                    if (this.pos[i][1] < this.posY) continue;
                    ++this.pieces_drip_cnt;
                }
                if (this.pieces_drip_cnt < this.pos.length) break;
                this.posX = 609792;
                this.posY = 69120;
                this.fly_end = this.posX;
                this.escapefacedrawer.setActionId(0);
                this.escapefacedrawer.setLoop(true);
                this.WaitCnt = 0;
                this.state = 40;
                MapManager.setCameraLeftLimit(9360);
                MapManager.setCameraRightLimit(EGG_SIDE_RIGHT);
                GameObject.bossFighting = false;
                GameObject.player.getBossScore();
                SoundSystem.getInstance().playBgm(StageManager.getBgmId(), true);
                break;
            }
            case 40: {
                if (this.posX <= MapManager.getCamera().x + MapManager.CAMERA_WIDTH - 30 << 6 && this.WaitCnt == 0) {
                    this.escapefacedrawer.setActionId(2);
                    this.escapefacedrawer.setLoop(false);
                    this.WaitCnt = 1;
                    int n8 = MapManager.getCamera().x;
                    int n9 = n8 + MapManager.CAMERA_WIDTH;
                    MapManager.setCameraLeftLimit(n8);
                    MapManager.setCameraRightLimit(n9);
                }
                if (this.escapefacedrawer.checkEnd() && this.WaitCnt == 1) {
                    this.escapefacedrawer.setActionId(0);
                    this.boatdrawer.setActionId(1);
                    this.boatdrawer.setLoop(false);
                    this.WaitCnt = 2;
                }
                if (this.WaitCnt == 2 && this.boatdrawer.checkEnd()) {
                    this.escapefacedrawer.setActionId(0);
                    this.escapefacedrawer.setTrans(2);
                    this.escapefacedrawer.setLoop(true);
                    this.boatdrawer.setActionId(1);
                    this.boatdrawer.setTrans(2);
                    this.boatdrawer.setLoop(false);
                    this.WaitCnt = 3;
                }
                if (this.WaitCnt == 3 && this.boatdrawer.checkEnd()) {
                    this.boatdrawer.setActionId(0);
                    this.boatdrawer.setTrans(2);
                    this.boatdrawer.setLoop(true);
                    this.WaitCnt = 4;
                }
                if (this.WaitCnt == 4 || this.WaitCnt == 5) {
                    this.posX += this.escape_v;
                }
                if (this.posX - this.fly_end > this.fly_range && this.WaitCnt == 4) {
                    this.WaitCnt = 5;
                }
                if (this.WaitCnt == 5) {
                    if (this.escape_cnt < this.escape_cnt_max) {
                        ++this.escape_cnt;
                    } else {
                        this.WaitCnt = 6;
                    }
                }
                if (this.WaitCnt == 6) {
                    GameObject.addGameObject(new Cage(MapManager.getCamera().x + (MapManager.CAMERA_WIDTH >> 1) << 6, MapManager.getCamera().y << 6));
                    this.WaitCnt = 7;
                }
                this.checkWithPlayer(n, n2, this.posX, this.posY);
            }
        }
        this.flydefence.logic(this.posX, this.posY, this.AttackStartDirection);
        if (this.state == 8 || this.state == 24) {
            this.flydefence.setCollAvailable(true);
            if (this.flydefence.getHurtState()) {
                this.HurtLogic();
                this.flydefence.setHurtState(false);
            }
        } else {
            this.flydefence.setCollAvailable(false);
        }
        this.refreshCollisionRect(this.posX >> 6, this.posY >> 6);
        this.checkWithPlayer(n, n2, this.posX, this.posY);
    }

    public boolean CanFreshFight() {
        return Math.abs(this.posX - GameObject.player.getFootPositionX()) <= this.fight_alert_range && GameObject.player.isOnGound();
    }

    public int randomSetState() {
        int n = 0;
        int n2 = 0;
        this.missile_alert_state = this.checkPlayerInEnemyAlertRange(this.posX >> 6, this.posY >> 6, this.missile_alert_range);
        switch (this.prestate) {
            case 11: 
            case 12: {
                if (this.CanFreshFight()) {
                    n2 = 12;
                    break;
                }
                n = MyRandom.nextInt(0, 15);
                if (n >= 0 && n < 5) {
                    n2 = 7;
                    break;
                }
                if (n >= 5 && n < 10) {
                    n2 = 4;
                    break;
                }
                if (n < 10) break;
                n2 = 5;
                break;
            }
            case 4: {
                if (this.CanFreshFight()) {
                    n2 = 12;
                    break;
                }
                n = MyRandom.nextInt(0, 100);
                if (n >= 0 && n < 45) {
                    n2 = 7;
                    break;
                }
                if (n >= 45 && n < 55) {
                    n2 = 4;
                    break;
                }
                if (n < 55) break;
                n2 = 5;
                break;
            }
            case 6: {
                if (this.CanFreshFight()) {
                    n2 = 12;
                    break;
                }
                n2 = 4;
                break;
            }
            case 18: {
                if (this.CanFreshFight()) {
                    n2 = 12;
                    break;
                }
                n = MyRandom.nextInt(0, 100);
                if (n >= 0 && n < 25) {
                    n2 = 7;
                    break;
                }
                if (n >= 25 && n < 30) {
                    n2 = 4;
                    break;
                }
                if (n < 30) break;
                n2 = 5;
                break;
            }
            case 15: {
                if (this.CanFreshFight()) {
                    n2 = 12;
                    break;
                }
                n = MyRandom.nextInt(0, 100);
                if (n >= 0 && n < 50) {
                    n2 = 7;
                    break;
                }
                if (n < 50) break;
                n2 = 5;
                break;
            }
            case 27: {
                if (this.missile_alert_state == 0) {
                    n = MyRandom.nextInt(0, 15);
                    if (n >= 0 && n < 5) {
                        n2 = 23;
                        break;
                    }
                    if (n >= 5 && n < 10) {
                        n2 = 19;
                        break;
                    }
                    if (n < 10) break;
                    n2 = 21;
                    break;
                }
                n = MyRandom.nextInt(0, 100);
                if (n >= 0 && n < 15) {
                    n2 = 23;
                    break;
                }
                if (n >= 15 && n < 17) {
                    n2 = 19;
                    break;
                }
                if (n >= 17 && n < 25) {
                    n2 = 21;
                    break;
                }
                if (n < 25) break;
                n2 = 28;
                break;
            }
            case 19: {
                if (this.missile_alert_state == 0) {
                    n = MyRandom.nextInt(0, 100);
                    if (n >= 0 && n < 45) {
                        n2 = 23;
                        break;
                    }
                    if (n >= 45 && n < 55) {
                        n2 = 19;
                        break;
                    }
                    if (n < 55) break;
                    n2 = 21;
                    break;
                }
                n = MyRandom.nextInt(0, 100);
                if (n >= 0 && n < 12) {
                    n2 = 23;
                    break;
                }
                if (n >= 12 && n < 25) {
                    n2 = 21;
                    break;
                }
                if (n < 25) break;
                n2 = 28;
                break;
            }
            case 22: {
                n2 = 19;
                break;
            }
            case 35: {
                if (this.missile_alert_state == 0) {
                    n = MyRandom.nextInt(0, 100);
                    if (n >= 0 && n < 25) {
                        n2 = 23;
                        break;
                    }
                    if (n >= 25 && n < 30) {
                        n2 = 19;
                        break;
                    }
                    if (n < 30) break;
                    n2 = 21;
                    break;
                }
                n = MyRandom.nextInt(0, 100);
                if (n >= 0 && n < 12) {
                    n2 = 23;
                    break;
                }
                if (n >= 12 && n < 25) {
                    n2 = 21;
                    break;
                }
                if (n < 25) break;
                n2 = 28;
                break;
            }
            case 32: {
                if (this.missile_alert_state == 0) {
                    n = MyRandom.nextInt(0, 100);
                    if (n >= 0 && n < 50) {
                        n2 = 23;
                        break;
                    }
                    if (n < 50) break;
                    n2 = 21;
                    break;
                }
                n = MyRandom.nextInt(0, 100);
                if (n >= 0 && n < 25) {
                    n2 = 23;
                    break;
                }
                if (n >= 25 && n < 50) {
                    n2 = 21;
                    break;
                }
                if (n < 50) break;
                n2 = 28;
                break;
            }
            case 29: {
                if (this.missile_alert_state == 0) {
                    n = MyRandom.nextInt(0, 100);
                    if (n >= 0 && n < 45) {
                        n2 = 23;
                        break;
                    }
                    if (n >= 45 && n < 55) {
                        n2 = 19;
                        break;
                    }
                    if (n < 55) break;
                    n2 = 21;
                    break;
                }
                n = MyRandom.nextInt(0, 100);
                if (n >= 0 && n < 10) {
                    n2 = 23;
                    break;
                }
                if (n >= 10 && n < 20) {
                    n2 = 21;
                    break;
                }
                if (n < 20) break;
                n2 = 28;
            }
        }
        if (this.first_jump_cnt < 3) {
            ++this.first_jump_cnt;
            n2 = this.CanFreshFight() ? 12 : 7;
        }
        switch (n2) {
            case 7: {
                int n3 = this.IsHurt ? 8 : 3;
                this.changeAniState(this.knuckdrawer, n3, true);
                this.COLLISION_WIDTH = 1536;
                this.COLLISION_HEIGHT = 1536;
                this.flydefence.setHurtState(false);
                break;
            }
            case 4: {
                int n4 = this.IsHurt ? 2 : 1;
                this.changeAniState(this.knuckdrawer, n4, true);
                this.COLLISION_WIDTH = 1024;
                this.COLLISION_HEIGHT = 1664;
                break;
            }
            case 5: {
                this.AttackStartDirection = this.posX - MIDDLE_SCREEN;
                if (MIDDLE_SCREEN > this.posX) {
                    if (this.horizon_move_speed < 0) {
                        this.horizon_move_speed = -this.horizon_move_speed;
                    }
                } else if (this.horizon_move_speed > 0) {
                    this.horizon_move_speed = -this.horizon_move_speed;
                }
                int n5 = this.IsHurt ? 9 : 4;
                this.changeAniState(this.knuckdrawer, n5, true, this.AttackStartDirection);
                this.COLLISION_WIDTH = 1536;
                this.COLLISION_HEIGHT = 1536;
                break;
            }
            case 12: {
                this.changeAniState(this.knuckdrawer, 18, false);
                this.COLLISION_WIDTH = 1536;
                this.COLLISION_HEIGHT = 1920;
                break;
            }
            case 23: {
                int n6 = this.IsHurt ? 26 : 21;
                this.changeAniState(this.knuckdrawer, n6, true);
                this.COLLISION_WIDTH = 1536;
                this.COLLISION_HEIGHT = 1536;
                this.flydefence.setHurtState(false);
                break;
            }
            case 19: {
                int n7 = this.IsHurt ? 20 : 19;
                this.changeAniState(this.knuckdrawer, n7, true);
                this.COLLISION_WIDTH = 1024;
                this.COLLISION_HEIGHT = 1664;
                break;
            }
            case 21: {
                this.AttackStartDirection = this.posX - MIDDLE_SCREEN;
                if (MIDDLE_SCREEN > this.posX) {
                    if (this.horizon_move_speed < 0) {
                        this.horizon_move_speed = -this.horizon_move_speed;
                    }
                } else if (this.horizon_move_speed > 0) {
                    this.horizon_move_speed = -this.horizon_move_speed;
                }
                int n8 = this.IsHurt ? 27 : 22;
                this.changeAniState(this.knuckdrawer, n8, true, this.AttackStartDirection);
                this.COLLISION_WIDTH = 1536;
                this.COLLISION_HEIGHT = 1536;
                break;
            }
            case 28: {
                int n9 = this.IsHurt ? 38 : 36;
                this.changeAniState(this.knuckdrawer, n9, false);
                this.COLLISION_WIDTH = 1024;
                this.COLLISION_HEIGHT = 1664;
            }
        }
        return n2;
    }

    public void hurt_side_cotrol() {
        this.posX = this.posX + this.velX + this.BOSS5_WIDTH >= MapManager.getCamera().x + MapManager.CAMERA_WIDTH << 6 ? (this.posX += 0) : (this.posX + this.velX - this.BOSS5_WIDTH <= MapManager.getCamera().x << 6 ? (this.posX += 0) : (this.posX += this.velX));
    }

    public void hurt_air_control() {
        this.hurt_side_cotrol();
        this.velY += GameObject.GRAVITY;
        this.posY += this.velY;
    }

    public void draw(MFGraphics mFGraphics) {
        if (this.dead) {
            return;
        }
        if (this.state < 39) {
            this.drawInMap(mFGraphics, this.knuckdrawer, this.posX, this.posY);
        }
        if (this.HP == 4 && this.state >= 13 && this.state <= 15 || this.HP == 0 && this.state >= 36 && this.state <= 37) {
            this.drawInMap(mFGraphics, this.boomdrawer, this.boomX, this.boomY);
        }
        if (this.bossbroken != null) {
            this.bossbroken.draw(mFGraphics);
        }
        if (this.state == 39) {
            for (int i = 0; i < this.pos.length; ++i) {
                this.knuckdrawer.setActionId(41 + i);
                this.drawInMap(mFGraphics, this.knuckdrawer, this.pos[i][0], this.pos[i][1]);
            }
        }
        if (this.state == 40) {
            this.drawInMap(mFGraphics, this.boatdrawer, this.posX, this.posY);
            this.drawInMap(mFGraphics, this.escapefacedrawer, this.posX, this.posY - 1664);
        }
        this.flydefence.draw(mFGraphics);
        this.drawCollisionRect(mFGraphics);
    }

    public void changeAniState(AnimationDrawer animationDrawer, int n, boolean bl) {
        if (GameObject.player.getFootPositionX() > this.posX) {
            animationDrawer.setActionId(n);
            animationDrawer.setTrans(2);
            animationDrawer.setLoop(bl);
            if (this.velocity < 0) {
                this.velocity = -this.velocity;
            }
            if (this.fly_move_x_speed1 < 0) {
                this.fly_move_x_speed1 = -this.fly_move_x_speed1;
            }
        } else {
            animationDrawer.setActionId(n);
            animationDrawer.setTrans(0);
            animationDrawer.setLoop(bl);
            if (this.velocity > 0) {
                this.velocity = -this.velocity;
            }
            if (this.fly_move_x_speed1 > 0) {
                this.fly_move_x_speed1 = -this.fly_move_x_speed1;
            }
        }
    }

    public void changeAniState(AnimationDrawer animationDrawer, int n, boolean bl, int n2) {
        if (n2 < 0) {
            animationDrawer.setActionId(n);
            animationDrawer.setTrans(2);
            animationDrawer.setLoop(bl);
            if (this.velocity < 0) {
                this.velocity = -this.velocity;
            }
            if (this.fly_move_x_speed1 < 0) {
                this.fly_move_x_speed1 = -this.fly_move_x_speed1;
            }
        } else {
            animationDrawer.setActionId(n);
            animationDrawer.setTrans(0);
            animationDrawer.setLoop(bl);
            if (this.velocity > 0) {
                this.velocity = -this.velocity;
            }
            if (this.fly_move_x_speed1 > 0) {
                this.fly_move_x_speed1 = -this.fly_move_x_speed1;
            }
        }
    }

    public void changeAniStateNoTrans(AnimationDrawer animationDrawer, int n, boolean bl) {
        animationDrawer.setActionId(n);
        animationDrawer.setLoop(bl);
        if (GameObject.player.getFootPositionX() > this.posX) {
            if (this.velocity < 0) {
                this.velocity = -this.velocity;
            }
            if (this.fly_move_x_speed1 < 0) {
                this.fly_move_x_speed1 = -this.fly_move_x_speed1;
            }
        } else {
            if (this.velocity > 0) {
                this.velocity = -this.velocity;
            }
            if (this.fly_move_x_speed1 > 0) {
                this.fly_move_x_speed1 = -this.fly_move_x_speed1;
            }
        }
    }

    public void refreshCollisionRect(int n, int n2) {
        if (this.state != 8 && this.state != 24) {
            this.collisionRect.setRect(n - (this.COLLISION_WIDTH >> 1), n2 - this.COLLISION_HEIGHT, this.COLLISION_WIDTH, this.COLLISION_HEIGHT);
        } else if (this.AttackStartDirection > 0) {
            this.collisionRect.setRect(n - 1408, n2 - this.COLLISION_HEIGHT, this.COLLISION_WIDTH, this.COLLISION_HEIGHT);
        } else {
            this.collisionRect.setRect(n + 448, n2 - this.COLLISION_HEIGHT, this.COLLISION_WIDTH, this.COLLISION_HEIGHT);
        }
    }

    public void close() {
        this.knuckdrawer = null;
        this.boomdrawer = null;
        this.boatdrawer = null;
        this.escapefacedrawer = null;
        this.bossbroken = null;
        this.flydefence = null;
    }

    static {
        SIDE_LEFT = 9496 - Def.SCREEN_WIDTH;
        MEET_SONIC_LINE = SIDE_LEFT + 24 << 6;
        BEFORE_MEET_LINE = SIDE_LEFT - 232 << 6;
        MIDDLE_SCREEN = SIDE_LEFT + 9496 >> 1 << 6;
        EGG_SIDE_RIGHT = 9360 + Def.SCREEN_WIDTH;
    }
}

