/*
 * Decompiled with CFR 0.152.
 */
package TW2006.renderer;

import TW2006.renderer.tCamera;
import TW2006.renderer.tEngine;
import TW2006.renderer.tMath;
import TW2006.renderer.tProjVertex3D;
import TW2006.renderer.tTexture;
import TW2006.renderer.tTriangle3D;
import TW2006.renderer.tVertex2D;
import TW2006.renderer.tVertex3D;

public class tRenderScreen {
    protected int startX = 0;
    protected int startY = 0;
    protected int width = 0;
    protected int height = 0;
    protected int iTotalPixels = 0;
    protected tCamera camera = null;
    protected int iRenderClipX = 0;
    protected int iRenderClipY = 0;
    protected int iRenderClipW = 0;
    protected int iRenderClipH = 0;
    private static volatile tProjVertex3D[] m_ClipVert = new tProjVertex3D[]{new tProjVertex3D(), new tProjVertex3D(), new tProjVertex3D(), new tProjVertex3D(), new tProjVertex3D(), new tProjVertex3D()};
    private static volatile tVertex2D[] m_ClipUV = new tVertex2D[]{new tVertex2D(), new tVertex2D(), new tVertex2D(), new tVertex2D(), new tVertex2D(), new tVertex2D()};
    private static volatile tVertex3D m_Vertex = new tVertex3D();

    protected tRenderScreen(boolean bl) {
        this.startX = 0;
        this.startY = 0;
        this.width = tEngine.screenWidth;
        this.height = tEngine.screenHeight;
        this.resetRenderClip();
        this.iTotalPixels = this.width * this.height;
        this.camera = new tCamera();
        this.camera.init(this, bl);
    }

    protected tRenderScreen(int n, int n2, int n3, int n4, boolean bl) {
        this.startX = n;
        this.startY = n2;
        this.width = n3;
        this.height = n4;
        this.setRenderClip(this.startX, this.startY, this.width, this.height);
        this.camera = new tCamera();
        this.camera.init(this, bl);
        this.width = tEngine.screenWidth;
        this.height = tEngine.screenHeight;
        this.iTotalPixels = this.width * this.height;
    }

    protected final void resetRenderClip() {
        this.iRenderClipX = this.startX;
        this.iRenderClipY = this.startY;
        this.iRenderClipW = this.width;
        this.iRenderClipH = this.height;
    }

    protected final void setRenderClip(int n, int n2, int n3, int n4) {
        this.iRenderClipX = n;
        this.iRenderClipY = n2;
        this.iRenderClipW = n3;
        this.iRenderClipH = n4;
    }

    protected final void renderSprite(tTexture tTexture2, int n, int n2, int n3, int n4) {
        int n5 = n3 / 2;
        int n6 = n4 / 2;
        int n7 = n - n5 + this.startX;
        int n8 = n2 - n6 + this.startY;
        int n9 = n7 + n3;
        int n10 = n8 + n4;
        if (n9 < this.iRenderClipX || n7 >= this.iRenderClipW + this.iRenderClipX || n10 < this.iRenderClipY || n8 >= this.iRenderClipH + this.iRenderClipY) {
            return;
        }
        int n11 = tTexture2.width - 1;
        int n12 = tTexture2.height - 1;
        int n13 = 0;
        if (n7 < this.iRenderClipX) {
            if (n9 >= this.iRenderClipX + this.iRenderClipW) {
                n11 = this.iRenderClipW * tTexture2.width / n3 - 1;
                n9 = this.iRenderClipX + this.iRenderClipW - 1;
            } else {
                n11 = (n9 - this.iRenderClipX + 1) * tTexture2.width / n3 - 1;
            }
            n13 += (this.iRenderClipX - n7 - 1) * tTexture2.width / n3;
            n7 = this.iRenderClipX;
        } else if (n9 > this.iRenderClipX + this.iRenderClipW) {
            n11 = (this.iRenderClipX + this.iRenderClipW - n7) * tTexture2.width / n3 - 1;
            n9 = this.iRenderClipX + this.iRenderClipW - 1;
        }
        if (n8 < this.iRenderClipY) {
            if (n10 >= this.iRenderClipY + this.iRenderClipH) {
                n12 = this.iRenderClipH * tTexture2.height / n4 - 1;
                n10 = this.iRenderClipY + this.iRenderClipH;
            } else {
                n12 = (n10 - this.iRenderClipY + 1) * tTexture2.height / n4 - 1;
            }
            n13 += ((this.iRenderClipY - n8 - 1) * tTexture2.height / n4 + 1) * tTexture2.width;
            n8 = this.iRenderClipY;
        } else if (n10 > this.iRenderClipY + this.iRenderClipH) {
            n12 = (this.iRenderClipY + this.iRenderClipH - n8) * tTexture2.height / n4 - 1;
            n10 = this.iRenderClipY + this.iRenderClipH - 1;
        }
        if (n11 <= 0 || n12 <= 0) {
            return;
        }
        n3 = n9 - n7 + 1;
        n4 = n10 - n8 + 1;
        int n14 = n8 * this.width + n7;
        for (int i = 1; i <= n4; ++i) {
            int n15 = n13 + i * n12 / n4 * tTexture2.width;
            for (int j = 1; j <= n3; ++j) {
                int n16 = n15 + j * n11 / n3;
                int n17 = n14 + (i - 1) * this.width + j - 1;
                try {
                    if (n16 >= tTexture2.length || n17 >= this.iTotalPixels) {
                        return;
                    }
                    if (tTexture2.palIdx[n16] == 2) continue;
                    tEngine.screen[n17] = tTexture2.palIdx[n16];
                    continue;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getClass().toString() + exception.getMessage());
                }
            }
        }
    }

    protected final void drawTriangle3D(tTriangle3D tTriangle3D2, tProjVertex3D[] tProjVertex3DArray, tVertex2D[] tVertex2DArray, tTexture tTexture2) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < 3; ++n) {
            n2 = n + 1;
            if (n2 >= 3) {
                n2 = 0;
            }
            bl = tProjVertex3DArray[tTriangle3D2.vertex[n]].v.z >= this.camera.nearClip;
            boolean bl3 = bl2 = tProjVertex3DArray[tTriangle3D2.vertex[n2]].v.z >= this.camera.nearClip;
            if (bl != bl2) {
                int n4 = tProjVertex3DArray[tTriangle3D2.vertex[n2]].v.z - tProjVertex3DArray[tTriangle3D2.vertex[n]].v.z;
                int n5 = this.camera.nearClip - tProjVertex3DArray[tTriangle3D2.vertex[n]].v.z;
                int n6 = tMath.MulFraction(tProjVertex3DArray[tTriangle3D2.vertex[n2]].v.x - tProjVertex3DArray[tTriangle3D2.vertex[n]].v.x, n5, n4);
                int n7 = tMath.MulFraction(tProjVertex3DArray[tTriangle3D2.vertex[n2]].v.y - tProjVertex3DArray[tTriangle3D2.vertex[n]].v.y, n5, n4);
                tRenderScreen.m_Vertex.x = n6 + tProjVertex3DArray[tTriangle3D2.vertex[n]].v.x;
                tRenderScreen.m_Vertex.y = n7 + tProjVertex3DArray[tTriangle3D2.vertex[n]].v.y;
                tRenderScreen.m_Vertex.z = this.camera.nearClip;
                this.camera.projectVertex(m_Vertex, m_ClipVert[n3]);
                if (tVertex2DArray != null) {
                    tRenderScreen.m_ClipUV[n3].x = tMath.MulFraction(tVertex2DArray[tTriangle3D2.uvCoords[n2]].x - tVertex2DArray[tTriangle3D2.uvCoords[n]].x, n5, n4) + tVertex2DArray[tTriangle3D2.uvCoords[n]].x;
                    tRenderScreen.m_ClipUV[n3].y = tMath.MulFraction(tVertex2DArray[tTriangle3D2.uvCoords[n2]].y - tVertex2DArray[tTriangle3D2.uvCoords[n]].y, n5, n4) + tVertex2DArray[tTriangle3D2.uvCoords[n]].y;
                }
                ++n3;
            }
            if (!bl2) continue;
            m_ClipVert[n3].copy(tProjVertex3DArray[tTriangle3D2.vertex[n2]]);
            if (tVertex2DArray != null) {
                m_ClipUV[n3].copy(tVertex2DArray[tTriangle3D2.uvCoords[n2]]);
            }
            ++n3;
        }
        if (n3 < 3) {
            return;
        }
        this.InternalDrawTriangle3D(m_ClipVert, (tVertex2D[])(tVertex2DArray != null ? m_ClipUV : null), tTexture2, 0);
        if (n3 > 3) {
            m_ClipVert[1].copy(m_ClipVert[0]);
            if (tVertex2DArray != null) {
                m_ClipUV[1].copy(m_ClipUV[0]);
                this.InternalDrawTriangle3D(m_ClipVert, m_ClipUV, tTexture2, 1);
            } else {
                this.InternalDrawTriangle3D(m_ClipVert, null, tTexture2, 1);
            }
        }
    }

    public void InternalDrawTriangle3D(tProjVertex3D[] tProjVertex3DArray, tVertex2D[] tVertex2DArray, tTexture tTexture2, int n) {
        int n2;
        int n3 = tProjVertex3DArray[n].s.x + this.startX;
        int n4 = tProjVertex3DArray[n].s.y + this.startY;
        int n5 = tProjVertex3DArray[1 + n].s.x + this.startX;
        int n6 = tProjVertex3DArray[1 + n].s.y + this.startY;
        int n7 = tProjVertex3DArray[2 + n].s.x + this.startX;
        int n8 = tProjVertex3DArray[2 + n].s.y + this.startY;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        if (tTexture2 == null) {
            return;
        }
        if ((n3 - n5) * (n8 - n6) >= (n4 - n6) * (n7 - n5)) {
            return;
        }
        if (tVertex2DArray != null) {
            n9 = tVertex2DArray[n].x * tTexture2.width;
            n12 = tVertex2DArray[n].y * tTexture2.height * -tTexture2.width;
            n10 = tVertex2DArray[n + 1].x * tTexture2.width;
            n13 = tVertex2DArray[n + 1].y * tTexture2.height * -tTexture2.width;
            n11 = tVertex2DArray[n + 2].x * tTexture2.width;
            n14 = tVertex2DArray[n + 2].y * tTexture2.height * -tTexture2.width;
        } else if (this.camera.ortho) {
            n9 = (n3 + this.camera.screenXScroll + this.iRenderClipX) * 256;
            n10 = (n5 + this.camera.screenXScroll + this.iRenderClipX) * 256;
            n11 = (n7 + this.camera.screenXScroll + this.iRenderClipX) * 256;
            n12 = (n4 + this.camera.screenYScroll + this.iRenderClipY) * 256 * -tTexture2.width;
            n13 = (n6 + this.camera.screenYScroll + this.iRenderClipY) * 256 * -tTexture2.width;
            n14 = (n8 + this.camera.screenYScroll + this.iRenderClipY) * 256 * -tTexture2.width;
        } else {
            n9 = n3 * 256;
            n10 = n5 * 256;
            n11 = n7 * 256;
            n12 = tTexture2.height * 256 * 256 / (tProjVertex3DArray[n].v.z >> 5) * -tTexture2.width;
            n13 = tTexture2.height * 256 * 256 / (tProjVertex3DArray[1 + n].v.z >> 5) * -tTexture2.width;
            n14 = tTexture2.height * 256 * 256 / (tProjVertex3DArray[2 + n].v.z >> 5) * -tTexture2.width;
        }
        n21 = tTexture2.width - 1 << 8;
        n22 = (tTexture2.height - 1) * tTexture2.width << 8;
        if (n6 < n4 && n6 <= n8) {
            n2 = n4;
            n4 = n6;
            n6 = n8;
            n8 = n2;
            n2 = n3;
            n3 = n5;
            n5 = n7;
            n7 = n2;
            n2 = n9;
            n9 = n10;
            n10 = n11;
            n11 = n2;
            n2 = n12;
            n12 = n13;
            n13 = n14;
            n14 = n2;
        } else if (n8 < n4 && n8 <= n6) {
            n2 = n4;
            n4 = n8;
            n8 = n6;
            n6 = n2;
            n2 = n3;
            n3 = n7;
            n7 = n5;
            n5 = n2;
            n2 = n9;
            n9 = n11;
            n11 = n10;
            n10 = n2;
            n2 = n12;
            n12 = n14;
            n14 = n13;
            n13 = n2;
        }
        n20 = n6 > n8 ? n6 : n8;
        n19 = n4;
        if (n19 < this.iRenderClipY) {
            n19 = this.iRenderClipY;
        }
        if (n20 > this.iRenderClipY + this.iRenderClipH) {
            n20 = this.iRenderClipY + this.iRenderClipH;
        }
        for (n16 = n19; n16 < n20; ++n16) {
            int n23;
            int n24;
            int n25;
            int n26;
            int n27;
            int n28;
            int n29;
            int n30;
            int n31;
            int n32;
            int n33;
            int n34;
            int n35;
            int n36;
            if (n6 < n8) {
                n36 = n3;
                n35 = n9;
                n34 = n12;
                if (n8 != n4) {
                    n15 = (n7 - n3) * (n16 - n4);
                    n36 += (n15 /= n8 - n4);
                    n17 = (n11 - n9) * (n16 - n4);
                    n35 += (n17 /= n8 - n4);
                    n18 = (n14 - n12) * (n16 - n4);
                    n34 += (n18 /= n8 - n4);
                }
                n33 = n36;
                n32 = n35;
                n31 = n34;
                if (n16 < n6) {
                    n2 = n3;
                    n30 = n9;
                    n29 = n12;
                    if (n6 != n4) {
                        n15 = (n5 - n3) * (n16 - n4);
                        n2 += (n15 /= n6 - n4);
                        n17 = (n10 - n9) * (n16 - n4);
                        n30 += (n17 /= n6 - n4);
                        n18 = (n13 - n12) * (n16 - n4);
                        n29 += (n18 /= n6 - n4);
                    }
                    n28 = n2;
                    n27 = n30;
                    n26 = n29;
                } else {
                    n25 = n5;
                    n24 = n10;
                    n23 = n13;
                    if (n8 != n6) {
                        n15 = (n7 - n5) * (n16 - n6);
                        n25 += (n15 /= n8 - n6);
                        n17 = (n11 - n10) * (n16 - n6);
                        n24 += (n17 /= n8 - n6);
                        n18 = (n14 - n13) * (n16 - n6);
                        n23 += (n18 /= n8 - n6);
                    }
                    n28 = n25;
                    n27 = n24;
                    n26 = n23;
                }
            } else {
                if (n16 < n8) {
                    n36 = n3;
                    n35 = n9;
                    n34 = n12;
                    if (n8 != n4) {
                        n15 = (n7 - n3) * (n16 - n4);
                        n36 += (n15 /= n8 - n4);
                        n17 = (n11 - n9) * (n16 - n4);
                        n35 += (n17 /= n8 - n4);
                        n18 = (n14 - n12) * (n16 - n4);
                        n34 += (n18 /= n8 - n4);
                    }
                    n33 = n36;
                    n32 = n35;
                    n31 = n34;
                } else {
                    n25 = n7;
                    n24 = n11;
                    n23 = n14;
                    if (n6 != n8) {
                        n15 = (n5 - n7) * (n16 - n8);
                        n25 += (n15 /= n6 - n8);
                        n17 = (n10 - n11) * (n16 - n8);
                        n24 += (n17 /= n6 - n8);
                        n18 = (n13 - n14) * (n16 - n8);
                        n23 += (n18 /= n6 - n8);
                    }
                    n33 = n25;
                    n32 = n24;
                    n31 = n23;
                }
                n2 = n3;
                n30 = n9;
                n29 = n12;
                if (n6 != n4) {
                    n15 = (n5 - n3) * (n16 - n4);
                    n2 += (n15 /= n6 - n4);
                    n17 = (n10 - n9) * (n16 - n4);
                    n30 += (n17 /= n6 - n4);
                    n18 = (n13 - n12) * (n16 - n4);
                    n29 += (n18 /= n6 - n4);
                }
                n28 = n2;
                n27 = n30;
                n26 = n29;
            }
            if (n28 <= this.iRenderClipX || n33 >= this.iRenderClipX + this.iRenderClipW || n33 >= n28) continue;
            int n37 = 256;
            int n38 = (n26 - n31) / (n28 - n33);
            n32 += tEngine.m_RandomTable[tEngine.m_RandomIdx & 0x1F];
            tEngine.m_RandomIdx = (short)(tEngine.m_RandomIdx + 1);
            if (n33 < this.iRenderClipX) {
                n32 -= n37 * (n33 - this.iRenderClipX);
                n31 -= n38 * (n33 - this.iRenderClipX);
                n33 = this.iRenderClipX;
            }
            if (n28 > this.iRenderClipX + this.iRenderClipW) {
                n28 = this.iRenderClipX + this.iRenderClipW;
            }
            if (n33 >= n28) continue;
            int n39 = n16 * this.width;
            for (int i = n33; i < n28; ++i) {
                tEngine.screen[n39 + i] = tTexture2.palIdx[(n32 & n21 | n31 & n22) >> 8];
                n32 += n37;
                n31 += n38;
            }
        }
    }

    protected void fillTexture(tTexture tTexture2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (n3 < this.iRenderClipX) {
            n3 = this.iRenderClipX;
        }
        if (n5 >= this.iRenderClipX + this.iRenderClipW) {
            n5 = this.iRenderClipX + this.iRenderClipW - 1;
        }
        if (n4 < this.iRenderClipY) {
            n4 = this.iRenderClipY;
        }
        if (n6 >= this.iRenderClipY + this.iRenderClipH) {
            n6 = this.iRenderClipY + this.iRenderClipH - 1;
        }
        n = (tTexture2.width + (n3 + this.camera.accumScreenXScroll % tTexture2.width)) % tTexture2.width;
        n2 = (tTexture2.height + (n4 + this.camera.accumScreenYScroll % tTexture2.height)) % tTexture2.height;
        int n7 = n4 * this.width;
        int n8 = n4;
        while (n8 <= n6) {
            int n9;
            int n10 = n2 % tTexture2.height;
            int n11 = n10 * tTexture2.width;
            ++n2;
            int n12 = n3;
            if (n > 0) {
                n9 = n5 + 1 - n12;
                if (n9 > tTexture2.width - n) {
                    n9 = tTexture2.width - n;
                }
                System.arraycopy(tTexture2.palIdx, n11 + n, tEngine.screen, n7 + n12, n9);
                n12 += n9;
            }
            while (n12 <= n5) {
                n9 = n5 + 1 - n12;
                if (n9 > tTexture2.width) {
                    n9 = tTexture2.width;
                }
                System.arraycopy(tTexture2.palIdx, n11, tEngine.screen, n7 + n12, n9);
                n12 += n9;
            }
            ++n8;
            n7 += this.width;
        }
    }

    protected final void fillTextureStretchY(tTexture tTexture2, int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (n2 < this.iRenderClipX) {
            n += n2 + this.iRenderClipX;
            n2 = this.iRenderClipX;
        }
        if (n4 >= this.iRenderClipX + this.iRenderClipW) {
            n4 = this.iRenderClipX + this.iRenderClipW - 1;
        }
        if ((n %= tTexture2.width) < 0) {
            n = tTexture2.width + n;
        }
        int n9 = n3 * this.width;
        n7 = n3;
        while (n7 <= n5) {
            if (n7 >= this.iRenderClipY) {
                if (n7 >= this.iRenderClipY + this.iRenderClipH) break;
                n8 = tTexture2.height - 1 - (n7 - n3) * tTexture2.height / (n5 - n3 + 1);
                int n10 = n8 * tTexture2.width;
                n6 = n2;
                int n11 = n4 + 1 - n6;
                if (n11 > tTexture2.width - n) {
                    n11 = tTexture2.width - n;
                }
                System.arraycopy(tTexture2.palIdx, n10 + n, tEngine.screen, n9 + n6, n11);
                n6 += n11;
                while (n6 <= n4) {
                    n11 = n4 + 1 - n6;
                    if (n11 > tTexture2.width) {
                        n11 = tTexture2.width;
                    }
                    System.arraycopy(tTexture2.palIdx, n10, tEngine.screen, n9 + n6, n11);
                    n6 += n11;
                }
            }
            ++n7;
            n9 += this.width;
        }
    }
}

