/*
 * Decompiled with CFR 0.152.
 */
import TW2006.archive.tFileMgr;
import TW2006.renderer.tEngine;
import TW2006.renderer.tObject3D;
import TW2006.renderer.tObject3DInfo;
import TW2006.renderer.tProjVertex3D;
import TW2006.renderer.tRenderer_MIDP_2_0;
import TW2006.renderer.tVertex3D;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Game {
    static final byte GAME_QUICK = 0;
    static final byte GAME_CHALLENGE = 1;
    byte gameType = 0;
    static final int BALLHOLEDIST = 7000;
    GolfMIDlet app;
    int SCREEN_WIDTH;
    int SCREEN_HEIGHT;
    GameUI gameui;
    Golfer golfer;
    Target target;
    static final byte GAME_LONG = 0;
    static final byte GAME_OVER = 1;
    static final byte GAME_PUTT = 2;
    static final byte GAME_CARD = 3;
    GamePutt gputt;
    GameLong glong;
    Scorecard card;
    boolean flagUpdateBG = true;
    boolean flagUpdateGU = true;
    int windDir;
    int windSpeed;
    byte hole = 0;
    byte loaded = (byte)-1;
    byte loaded2 = (byte)-1;
    int shotDist;
    tVertex3D pin;
    tVertex3D tee;
    tObject3DInfo newTerrainInfo = new tObject3DInfo();
    tObject3DInfo oldTerrainInfo = new tObject3DInfo();
    boolean water = false;
    boolean oob = false;
    boolean checkTerrain = true;
    int camAngle = 0;
    int quad = 1;
    Image ball;
    static tObject3D m_CurrHole3dData = null;
    int doReset = -1;
    int camOffset;
    int minix = 0;
    int miniy = 0;
    int miniw = 0;
    int minih = 0;
    int s_challenge_index = 0;
    Player1 player1;
    Player2 player2;
    int pinx = 0;
    int piny = 0;
    boolean resume = false;
    boolean roll = true;
    boolean autoHole = false;
    boolean yards = true;
    boolean tips = true;
    boolean doGimme = false;
    boolean done = false;
    boolean taps = true;
    byte course;
    byte resType;
    byte resArea;
    byte resHole1;
    byte resHole2;
    byte resp1;
    byte resp2;
    int challenge;
    int sub_challenge;
    boolean sinkBall = false;
    boolean noRender = false;
    Clock idleClock = new Clock();
    boolean gameIdle = false;
    static final int IDLE_TIME = 20000;

    public Game(GolfMIDlet golfMIDlet, int n, int n2) {
        this.app = golfMIDlet;
        this.SCREEN_WIDTH = n;
        this.SCREEN_HEIGHT = n2;
        this.ball = golfMIDlet.loadImage("ball2.png");
        this.golfer = new Golfer(this);
        this.gameui = new GameUI(this);
        this.player1 = new Player1(this);
        this.player2 = new Player2();
        this.target = new Target(this);
        this.gputt = new GamePutt(this, this.golfer, this.target);
        this.glong = new GameLong(this, this.golfer, this.target);
        this.card = new Scorecard(this);
        this.hole = golfMIDlet.resumehole1;
        this.course = golfMIDlet.resumecrs;
        this.resp1 = golfMIDlet.resumep1;
        this.resp2 = golfMIDlet.resumep2;
        this.yards = golfMIDlet.yards;
        this.tips = golfMIDlet.tips;
        this.taps = golfMIDlet.taps;
    }

    void init() {
        this.app.canvas.loadin(this.app.gameTxtData[0][0], 1);
        this.done = false;
        this.doGimme = false;
        this.player1.reset();
        switch (this.gameType) {
            case 1: {
                int n = 0;
                int n2 = 0;
                if (this.app.canvas.gamedata.challenges.cinfo[this.challenge][this.sub_challenge].holes[0] == -1) {
                    this.hole = (byte)(this.hole + 1);
                    if (this.hole != 19) break;
                    this.hole = (byte)18;
                    this.done = true;
                    for (int i = 0; i < 18; ++i) {
                        n += this.player1.score[i];
                        n2 += this.player2.score[i];
                    }
                    if (n < n2) {
                        this.app.canvas.gamedata.playerstats.stat[1] = this.app.canvas.gamedata.playerstats.stat[1] + 1;
                        this.app.canvas.gamedata.playerstats.statsToRMS();
                        MenuCanvas cfr_ignored_0 = this.app.canvas.g_menu;
                        this.app.canvas.gotoMenu((byte)5);
                        break;
                    }
                    MenuCanvas cfr_ignored_1 = this.app.canvas.g_menu;
                    this.app.canvas.gotoMenu((byte)6);
                    break;
                }
                if (++this.s_challenge_index < 3) {
                    if (this.app.canvas.gamedata.challenges.cinfo[this.challenge][this.sub_challenge].holes[0] == -2) {
                        this.hole = (byte)(16 + this.s_challenge_index);
                        break;
                    }
                    this.hole = this.app.canvas.gamedata.challenges.cinfo[this.challenge][this.sub_challenge].holes[this.s_challenge_index];
                    break;
                }
                for (int i = 0; i < 18; ++i) {
                    n += this.player1.score[i];
                }
                if (n <= this.app.canvas.gamedata.challenges.cinfo[this.challenge][this.sub_challenge].stroke) {
                    this.app.canvas.gamedata.playerstats.stat[1] = this.app.canvas.gamedata.playerstats.stat[1] + 1;
                    this.app.canvas.gamedata.playerstats.statsToRMS();
                    MenuCanvas cfr_ignored_2 = this.app.canvas.g_menu;
                    this.app.canvas.gotoMenu((byte)5);
                } else {
                    MenuCanvas cfr_ignored_3 = this.app.canvas.g_menu;
                    this.app.canvas.gotoMenu((byte)6);
                }
                this.done = true;
                break;
            }
            default: {
                this.hole = (byte)(this.hole + 1);
                if (this.hole != 19) break;
                this.done = true;
                this.hole = (byte)18;
                MenuCanvas cfr_ignored_4 = this.app.canvas.g_menu;
                this.app.canvas.gotoMenu((byte)0);
            }
        }
        if (!this.done) {
            if (this.loadHoleStageOne()) {
                this.loadHoleStageTwo();
                this.loadHoleStageThree();
                this.loadHoleStageFour();
                this.loadHoleStageFive();
            }
            this.setBallPosition();
            this.checkTerrain = true;
            this.reset(0);
        }
        this.app.canvas.loadStop();
    }

    void init(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, int n, int n2, int n3) {
        this.app.canvas.loadin(this.app.gameTxtData[0][0], 2);
        this.app.stopSound();
        this.glong.cancelClocks();
        this.gputt.cancelClocks();
        this.gputt.setState((byte)0);
        this.doGimme = false;
        this.challenge = n;
        this.sub_challenge = n2;
        this.s_challenge_index = n3;
        this.done = false;
        MenuCanvas cfr_ignored_0 = this.app.canvas.g_menu;
        if (this.app.canvas.g_menu.m_currentMenu != 1) {
            this.app.canvas.g_menu.m_launchMenu = this.app.canvas.g_menu.m_currentMenu;
        }
        this.golfer.loadGraphics(by6, by7);
        this.resType = by;
        this.resArea = by2;
        this.resHole1 = by3;
        this.resHole2 = by4;
        this.resp1 = by6;
        this.resp2 = by7;
        this.gameType = by;
        this.player1.gameArea = by2;
        this.player1.name = this.app.canvas.gamedata.golfers.names[by6];
        this.player1.doneHole = false;
        this.hole = by3;
        this.course = by5;
        if (this.hole == -1) {
            this.hole = 1;
        }
        if (this.hole == -2) {
            this.hole = (byte)16;
        }
        if (this.loadHoleStageOne()) {
            this.loadHoleStageTwo();
            this.loadHoleStageThree();
            this.loadHoleStageFour();
            this.loadHoleStageFive();
        }
        if (!this.resume) {
            for (int i = 0; i < 18; ++i) {
                this.player1.score[i] = 0;
                this.player2.score[i] = 0;
            }
            this.setBallPosition();
        }
        if (this.resume && this.resHole2 == 18 && this.player1.score[0] != 0 && (this.gameType != 1 || this.sub_challenge == 3)) {
            this.resHole1 = 1;
        }
        if (this.resume && this.app.canvas.g_menu.askRestart) {
            this.player1.score[this.hole - 1] = 0;
            this.player2.score[this.hole - 1] = 0;
            this.setBallPosition();
        }
        if (this.player1.score[this.hole - 1] == 0) {
            this.setBallPosition();
        }
        if (this.gameType == 1 && this.app.canvas.gamedata.challenges.cinfo[this.challenge][this.sub_challenge].holes[0] == -1) {
            if (this.app.canvas.gamedata.courses.names[this.app.canvas.gamedata.challenges.courses[this.challenge]].compareTo("Pebble Beach") == 0) {
                if (GolfMIDlet.NETWORK_ON) {
                    tEngine.loadCRS(GolfMIDlet.translateFilename("peb.crs"));
                } else {
                    tEngine.loadCRS(GolfMIDlet.translateFilename("peb2.crs"));
                }
            } else {
                tEngine.loadCRS(GolfMIDlet.translateFilename(this.app.canvas.gamedata.courses.names[this.app.canvas.gamedata.challenges.courses[this.challenge]] + ".crs"));
            }
            this.player2.name = this.app.canvas.gamedata.golfers.names[this.app.canvas.gamedata.challenges.golfers[this.challenge]];
        } else if (!(this.gameType != 1 || tEngine.chgType[this.sub_challenge] != 2 || this.resume && this.player1.score[this.hole - 1] != 0)) {
            if (this.app.canvas.gamedata.courses.names[this.app.canvas.gamedata.challenges.courses[this.challenge]].compareTo("Pebble Beach") == 0) {
                if (GolfMIDlet.NETWORK_ON) {
                    tEngine.loadCRS(GolfMIDlet.translateFilename("peb.crs"));
                } else {
                    tEngine.loadCRS(GolfMIDlet.translateFilename("peb2.crs"));
                }
            } else {
                tEngine.loadCRS(GolfMIDlet.translateFilename(this.app.canvas.gamedata.courses.names[this.app.canvas.gamedata.challenges.courses[this.challenge]] + ".crs"));
            }
            this.player1.score[this.hole - 1] = tEngine.chgInitCond[this.sub_challenge][this.s_challenge_index];
        }
        this.checkTerrain = true;
        if (by == 0) {
            this.reset(-1);
        } else {
            this.reset(0);
        }
        this.resume = false;
        this.idleClock.cancel();
        this.idleClock.start(20000L);
        this.app.canvas.loadStop();
    }

    void setBallPosition() {
        if (this.player1.score[this.hole - 1] == 0) {
            this.player1.ball.worldX = this.tee.x << 12;
            this.player1.ball.worldY = this.tee.y << 12;
            this.player1.ball.worldZ = this.tee.z << 12;
        }
        if (this.gameType == 1 && this.app.canvas.gamedata.challenges.cinfo[this.challenge][this.sub_challenge].ballx[0] != -1) {
            tObject3DInfo tObject3DInfo2 = new tObject3DInfo();
            this.player1.ball.worldX = Mathlib.intToFP(this.app.canvas.gamedata.challenges.cinfo[this.challenge][this.sub_challenge].ballx[this.s_challenge_index]);
            this.player1.ball.worldZ = Mathlib.intToFP(this.app.canvas.gamedata.challenges.cinfo[this.challenge][this.sub_challenge].ballz[this.s_challenge_index]);
            tObject3DInfo2.x = tEngine.C3D_FP16To3DCoords(this.player1.ball.worldX);
            tObject3DInfo2.z = tEngine.C3D_FP16To3DCoords(this.player1.ball.worldZ);
            tEngine.getTerrainInfo(m_CurrHole3dData, tObject3DInfo2);
            this.player1.ball.worldY = tObject3DInfo2.y << 12;
        }
        this.player1.holeDist = Mathlib.FP16Dist(this.player1.ball.worldX, this.player1.ball.worldZ, this.pin.x << 12, this.pin.z << 12);
    }

    void reset(int n) {
        int n2;
        this.camOffset = 0;
        this.sinkBall = false;
        if (this.checkTerrain) {
            this.checkTerrain();
        } else {
            this.checkTerrain = true;
        }
        switch (this.newTerrainInfo.type) {
            case 2: {
                this.player1.gameArea = (byte)2;
                break;
            }
            default: {
                this.player1.gameArea = 0;
            }
        }
        this.player1.holeDist = Mathlib.FP16Dist(this.player1.ball.worldX, this.player1.ball.worldZ, this.pin.x << 12, this.pin.z << 12);
        this.chooseClub();
        this.gameui.setName(this.player1.name);
        this.gameui.setClub(this.player1.ball.club);
        this.gameui.setWind(this.windSpeed, this.windDir);
        this.gameui.setDistance(this.player1.holeDist);
        this.gameui.setHole(this.hole, this.app.canvas.gamedata.courses.par[this.course][this.hole - 1]);
        this.gameui.setShot(this.player1.score[this.hole - 1] + 1);
        this.gameui.setLie(this.player1.lie, this.player1.lieType);
        this.golfer.reset();
        this.player1.ball.reset();
        switch (this.player1.gameArea) {
            case 0: {
                this.glong.reset(n);
                n2 = Game.m_CurrHole3dData.teePos.y;
                Game.m_CurrHole3dData.teePos.y = tEngine.C3D_IntTo3DCoords(100);
                tEngine.scrollDraw2DCamera(m_CurrHole3dData, Game.m_CurrHole3dData.teePos, true, 2);
                Game.m_CurrHole3dData.teePos.y = n2;
                break;
            }
            case 2: {
                if (this.gputt.gameState != 9) {
                    this.gputt.reset();
                    break;
                }
                this.gputt.gameState = 1;
            }
        }
        if (!this.resume && this.gameType == 1 && this.app.canvas.gamedata.challenges.cinfo[this.challenge][this.sub_challenge].holes[0] == -1) {
            n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            byte by = tEngine.chgVicCond1[3];
            byte by2 = tEngine.chgVicCond2[3];
            for (n5 = 0; n5 < this.hole - 1; ++n5) {
                n2 += this.player2.score[n5];
                n3 += this.app.canvas.gamedata.courses.par[this.challenge][n5];
            }
            int n6 = n2 - n3;
            n4 = n6 <= by ? Mathlib.getRandomNum(2) + 1 : (n6 >= by2 ? Mathlib.getRandomNum(2) : Mathlib.getRandomNum(3));
            this.player2.score[this.hole - 1] = (byte)(n4 + this.app.canvas.gamedata.courses.par[this.challenge][this.hole - 1] - 1);
        }
        this.app.canvas.gamedata.trophies.resetIndex();
        this.flagUpdateGU = true;
        this.flagUpdateBG = true;
        this.app.resume = true;
        this.app.saveGame();
    }

    protected boolean loadHoleStageOne() {
        if (m_CurrHole3dData != null && this.hole == this.loaded && this.course == this.loaded2) {
            return false;
        }
        m_CurrHole3dData = null;
        System.gc();
        String string = "";
        String string2 = "";
        switch (this.course) {
            case 0: {
                string = new String("peb");
                break;
            }
            default: {
                string = new String(this.app.canvas.gamedata.courses.names[this.course]);
            }
        }
        if (tFileMgr.fileExist(GolfMIDlet.translateFilename(string + ".crs")) != 0) {
            byte[] byArray;
            Object object;
            try {
                object = tFileMgr.getFileStream(GolfMIDlet.translateFilename(string + ".crs"));
                byArray = new byte[3];
                tFileMgr.readData((InputStream)object, 0, byArray, 0, 3);
                string2 = new String(byArray);
                string2.trim();
                ((InputStream)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                object = new String();
                object = string2 + (this.hole < 10 ? "0" : "") + this.hole + ".bin";
                m_CurrHole3dData = new tObject3D((String)object, true, true);
                byArray = new byte[1000];
                InputStream inputStream = this.getClass().getResourceAsStream(string2 + "-tip" + (this.hole < 10 ? "0" : "") + this.hole + "_" + GolfMIDlet.Countries[GolfMIDlet.CountryIndex] + ".bin");
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                int n = 0;
                try {
                    int n2;
                    while ((n2 = inputStream.read()) != -1) {
                        byArray[n] = (byte)n2;
                        ++n;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    Game.m_CurrHole3dData.tip = dataInputStream.readUTF();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                dataInputStream = null;
                byteArrayInputStream = null;
                inputStreamReader = null;
                inputStream = null;
                byArray = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.loaded = this.hole;
        this.loaded2 = this.course;
        return true;
    }

    protected void loadHoleStageTwo() {
        m_CurrHole3dData.initDataStageOne();
    }

    protected void loadHoleStageThree() {
        m_CurrHole3dData.initDataStageTwo();
    }

    protected void loadHoleStageFour() {
        m_CurrHole3dData.initDataStageThree();
    }

    protected void loadHoleStageFive() {
        this.minix = this.SCREEN_WIDTH * 72 / 100;
        this.miniy = this.SCREEN_HEIGHT * 11 / 100;
        this.miniw = this.SCREEN_WIDTH * 28 / 100;
        this.minih = this.SCREEN_HEIGHT * 78 / 100;
        tEngine.initMiniMap(m_CurrHole3dData, this.minix, this.miniy, this.miniw, this.minih);
        tEngine.draw((byte)3, m_CurrHole3dData, 0);
        tEngine.setNearClip((byte)2, 8);
        tEngine.setOrthographicScale((byte)1, 4000);
        tEngine.setCameraRotation((byte)1, 90, 90);
        tEngine.setNearClip((byte)1, 8);
        this.pin = new tVertex3D();
        this.pin.copy(Game.m_CurrHole3dData.holePos);
        this.tee = new tVertex3D();
        this.tee.copy(Game.m_CurrHole3dData.teePos);
        this.createWind();
    }

    void createWind() {
        this.windDir = Mathlib.getRandomNum(31);
        this.windSpeed = this.gameType == 1 && this.app.canvas.gamedata.challenges.cinfo[this.challenge][this.sub_challenge].holes[0] == -2 ? Mathlib.getRandomNum(5) + 10 : Mathlib.getRandomNum(8) + 1;
    }

    void chooseClub() {
        if (this.player1.gameArea == 2) {
            Ball cfr_ignored_0 = this.player1.ball;
            this.player1.ball.table = 0;
            this.player1.ball.club = (byte)12;
        } else {
            int n;
            if (Mathlib.toInt(this.player1.holeDist) > 100) {
                Ball cfr_ignored_1 = this.player1.ball;
                this.player1.ball.table = 0;
                if (this.newTerrainInfo.type == 4) {
                    n = 11;
                } else {
                    for (n = 12; n > 0; n = (int)((byte)(n - 1))) {
                        Ball cfr_ignored_2 = this.player1.ball;
                        if (Mathlib.toInt(this.player1.holeDist) >= Ball.cdist[n]) {
                            continue;
                        }
                        break;
                    }
                }
            } else {
                Ball cfr_ignored_3 = this.player1.ball;
                this.player1.ball.table = 1;
                if (this.newTerrainInfo.type == 4) {
                    n = 9;
                } else {
                    for (n = 10; n > 0; n = (int)((byte)(n - 1))) {
                        Ball cfr_ignored_4 = this.player1.ball;
                        if (Mathlib.toInt(this.player1.holeDist) >= Ball.cdist2[n]) {
                            continue;
                        }
                        break;
                    }
                }
            }
            this.player1.ball.club = (byte)n;
        }
    }

    void checkTerrain() {
        this.water = false;
        this.oob = false;
        this.oldTerrainInfo.type = this.newTerrainInfo.type;
        this.oldTerrainInfo.y = this.newTerrainInfo.y;
        this.newTerrainInfo.x = tEngine.C3D_FP16To3DCoords(this.player1.ball.worldX);
        this.newTerrainInfo.z = tEngine.C3D_FP16To3DCoords(this.player1.ball.worldZ);
        tEngine.getTerrainInfo(m_CurrHole3dData, this.newTerrainInfo);
        if (this.oldTerrainInfo.y == 0) {
            this.oldTerrainInfo.y = this.newTerrainInfo.y;
        }
        switch (this.newTerrainInfo.type) {
            case 2: {
                this.player1.lieType = (byte)2;
                this.player1.lie = 100;
                break;
            }
            case 1: {
                this.player1.lieType = 1;
                this.player1.lie = Mathlib.getRandomNum(15) + 80;
                break;
            }
            case 0: 
            case 5: {
                this.player1.ball.worldX = this.player1.ball.origXa;
                this.player1.ball.worldY = this.player1.ball.origYa;
                this.player1.ball.worldZ = this.player1.ball.origZa;
                int n = this.hole - 1;
                this.player1.score[n] = (byte)(this.player1.score[n] + 1);
                this.oob = true;
                break;
            }
            case 3: 
            case 9: {
                this.player1.lieType = (byte)3;
                this.player1.lie = Mathlib.getRandomNum(25) + 60;
                break;
            }
            case 4: 
            case 6: {
                this.player1.lieType = (byte)4;
                this.player1.lie = Mathlib.getRandomNum(30) + 40;
                break;
            }
            case 7: {
                this.player1.lieType = (byte)7;
                this.player1.lie = 100;
                break;
            }
            case 8: {
                int n = this.player1.ball.worldX;
                int n2 = this.player1.ball.worldZ;
                int n3 = Mathlib.Div(n - this.player1.ball.origXa, Mathlib.intToFP(20));
                int n4 = Mathlib.Div(n2 - this.player1.ball.origZa, Mathlib.intToFP(20));
                while (this.newTerrainInfo.type == 8) {
                    this.newTerrainInfo.x = tEngine.C3D_FP16To3DCoords(n -= n3);
                    this.newTerrainInfo.z = tEngine.C3D_FP16To3DCoords(n2 -= n4);
                    tEngine.getTerrainInfo(m_CurrHole3dData, this.newTerrainInfo);
                }
                this.newTerrainInfo.x = tEngine.C3D_FP16To3DCoords(n -= n3);
                this.newTerrainInfo.z = tEngine.C3D_FP16To3DCoords(n2 -= n4);
                tEngine.getTerrainInfo(m_CurrHole3dData, this.newTerrainInfo);
                this.player1.ball.worldX = n;
                this.player1.ball.worldY = this.newTerrainInfo.y << 12;
                this.player1.ball.worldZ = n2;
                int n5 = this.hole - 1;
                this.player1.score[n5] = (byte)(this.player1.score[n5] + 1);
                this.checkTerrain();
                this.water = true;
            }
        }
    }

    boolean checkHole() {
        if (this.autoHole) {
            this.player1.ball.worldX = this.pin.x << 12;
            this.player1.ball.worldY = this.pin.y << 12;
            this.player1.ball.worldZ = this.pin.z << 12;
        }
        this.player1.holeDist = Mathlib.FP16Dist(this.player1.ball.worldX, this.player1.ball.worldZ, this.pin.x << 12, this.pin.z << 12);
        if (this.player1.holeDist <= 7000 || this.doGimme || this.sinkBall) {
            this.player1.holeDist = 0;
            this.app.playSound((byte)1);
            if (this.hole != 18) {
                this.app.saveGameNextHole();
            }
            return true;
        }
        if (this.player1.holeDist > 7000 && this.player1.holeDist <= 32768 && this.taps) {
            this.doGimme = true;
        }
        return false;
    }

    public String getResult() {
        int n = this.player1.score[this.hole - 1] - this.app.canvas.gamedata.courses.par[this.course][this.hole - 1];
        if (this.player1.score[this.hole - 1] == 1) {
            return this.app.gameTxtData[1][0];
        }
        if (this.player1.score[this.hole - 1] == 12) {
            return this.app.gameTxtData[1][8];
        }
        switch (n) {
            case -3: {
                return this.app.gameTxtData[1][1];
            }
            case -2: {
                return this.app.gameTxtData[1][2];
            }
            case -1: {
                return this.app.gameTxtData[1][3];
            }
            case 0: {
                return this.app.gameTxtData[1][4];
            }
            case 1: {
                return this.app.gameTxtData[1][5];
            }
            case 2: {
                return this.app.gameTxtData[1][6];
            }
        }
        return this.app.gameTxtData[1][7];
    }

    int hitDist() {
        this.newTerrainInfo.x = tEngine.C3D_FP16To3DCoords(this.player1.ball.worldX);
        this.newTerrainInfo.z = tEngine.C3D_FP16To3DCoords(this.player1.ball.worldZ);
        tEngine.getTerrainInfo(m_CurrHole3dData, this.newTerrainInfo);
        if (this.newTerrainInfo.type == 8) {
            return -1;
        }
        if (this.newTerrainInfo.type == 0) {
            return -2;
        }
        this.shotDist = Mathlib.FP16Dist(this.player1.ball.worldX, this.player1.ball.worldZ, this.player1.ball.origXa, this.player1.ball.origZa);
        return this.shotDist;
    }

    void setScreenLong() {
        if (this.player1.gameArea == 0 || this.player1.gameArea == 1) {
            int n;
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            if (this.player1.gameArea == 0) {
                n8 = this.player1.ball.worldX;
                n9 = this.player1.ball.worldZ;
                n6 = this.pin.x << 12;
                n7 = this.pin.z << 12;
            } else {
                n8 = this.player1.ball.origXa;
                n9 = this.player1.ball.origZa;
                n6 = this.player1.ball.worldX;
                n7 = this.player1.ball.worldZ;
            }
            int n10 = Mathlib.Angle(n8, n9, n6, n7, this.camOffset);
            n3 = 655360;
            n4 = 262144;
            n5 = 4;
            if (this.player1.ball.landCam) {
                n3 = 1400000;
                if (this.player1.ball.terrainInfo.type == 0) {
                    tObject3DInfo tObject3DInfo2 = new tObject3DInfo();
                    tObject3DInfo2 = this.player1.ball.terrainInfo;
                    n2 = this.player1.ball.worldX;
                    n = this.player1.ball.worldZ;
                    int n11 = Mathlib.Div(n2 - this.player1.ball.origXa, Mathlib.intToFP(20));
                    int n12 = Mathlib.Div(n - this.player1.ball.origZa, Mathlib.intToFP(20));
                    while (tObject3DInfo2.type == 8) {
                        tObject3DInfo2.x = tEngine.C3D_FP16To3DCoords(n2 -= n11);
                        tObject3DInfo2.z = tEngine.C3D_FP16To3DCoords(n -= n12);
                        tEngine.getTerrainInfo(m_CurrHole3dData, tObject3DInfo2);
                    }
                    tObject3DInfo2.x = tEngine.C3D_FP16To3DCoords(n2 -= n11);
                    tObject3DInfo2.z = tEngine.C3D_FP16To3DCoords(n -= n12);
                    tEngine.getTerrainInfo(m_CurrHole3dData, tObject3DInfo2);
                    n4 = (tObject3DInfo2.y << 12) + 524288 - this.player1.ball.worldY;
                } else {
                    n4 = (this.player1.ball.terrainInfo.y << 12) + 524288 - this.player1.ball.worldY;
                }
            }
            int n13 = Mathlib.Mul(n3, Mathlib.Cos(n10));
            n2 = Mathlib.Mul(n3, Mathlib.Sin(n10));
            this.camAngle = 0;
            n = Mathlib.Div(Mathlib.Mul(n10, Ball.ONEEIGHTY), 205887);
            if (n8 > n6 && n9 > n7) {
                this.quad = 1;
                this.camAngle = 270 - Mathlib.toInt(n);
            } else if (n8 > n6 && n9 < n7) {
                this.quad = 2;
                n2 = -n2;
                this.camAngle = 270 + Mathlib.toInt(n);
            } else if (n8 <= n6 && n9 <= n7) {
                this.quad = 3;
                n2 = -n2;
                n13 = -n13;
                this.camAngle = 90 - Mathlib.toInt(n);
            } else if (n8 < n6 && n9 > n7) {
                this.quad = 4;
                n13 = -n13;
                this.camAngle = 90 + Mathlib.toInt(n);
            }
            if (!this.player1.ball.landCam) {
                this.target.resetPosition(this.glong.dir);
            }
            tEngine.setCameraPosition((byte)2, tEngine.C3D_FP16To3DCoords(this.player1.ball.worldX + n13), tEngine.C3D_FP16To3DCoords(this.player1.ball.worldY + n4), tEngine.C3D_FP16To3DCoords(this.player1.ball.worldZ + n2));
            tEngine.setCameraRotation((byte)2, this.camAngle, n5);
        } else if (this.player1.gameArea == 2) {
            int n = 0;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            if (this.player1.ball.ballState != 0) {
                n17 = this.player1.ball.origXc;
                n18 = this.player1.ball.origZc;
            } else {
                n17 = this.player1.ball.worldX;
                n18 = this.player1.ball.worldZ;
            }
            n14 = 655360;
            n16 = 4;
            n15 = 262144;
            n = Mathlib.Angle(n17, n18, this.target.worldX, this.target.worldZ, 0);
            int n19 = Mathlib.Mul(n14, Mathlib.Cos(n));
            int n20 = Mathlib.Mul(n14, Mathlib.Sin(n));
            this.camAngle = 0;
            int n21 = Mathlib.Div(Mathlib.Mul(n, Ball.ONEEIGHTY), 205887);
            if (n17 > this.target.worldX && n18 > this.target.worldZ) {
                this.quad = 1;
                this.camAngle = 270 - Mathlib.toInt(n21);
            } else if (n17 > this.target.worldX && n18 < this.target.worldZ) {
                this.quad = 2;
                n20 = -n20;
                this.camAngle = 270 + Mathlib.toInt(n21);
            } else if (n17 <= this.target.worldX && n18 <= this.target.worldZ) {
                this.quad = 3;
                n20 = -n20;
                n19 = -n19;
                this.camAngle = 90 - Mathlib.toInt(n21);
            } else if (n17 < this.target.worldX && n18 > this.target.worldZ) {
                this.quad = 4;
                n19 = -n19;
                this.camAngle = 90 + Mathlib.toInt(n21);
            }
            tEngine.setCameraPosition((byte)2, tEngine.C3D_FP16To3DCoords(n17 + n19), tEngine.C3D_FP16To3DCoords(this.player1.ball.worldY + n15), tEngine.C3D_FP16To3DCoords(n18 + n20));
            tEngine.setCameraRotation((byte)2, this.camAngle, n16);
            tVertex3D tVertex3D2 = new tVertex3D();
            tProjVertex3D tProjVertex3D2 = new tProjVertex3D();
            tVertex3D2.x = tEngine.C3D_FP16To3DCoords(this.pin.x << 12);
            tVertex3D2.y = tEngine.C3D_FP16To3DCoords(this.pin.y << 12);
            tVertex3D2.z = tEngine.C3D_FP16To3DCoords(this.pin.z << 12);
            tEngine.getCameraProjectedInfo((byte)2, tVertex3D2, tProjVertex3D2);
            this.pinx = tProjVertex3D2.s.x;
            this.piny = tProjVertex3D2.s.y;
        }
    }

    void setScreenOver() {
        tVertex3D tVertex3D2 = new tVertex3D();
        if (this.glong.gameState != 2) {
            tVertex3D2.x = tEngine.C3D_FP16To3DCoords(this.player1.ball.worldX);
            tVertex3D2.y = Game.m_CurrHole3dData.maxY + tEngine.C3D_IntTo3DCoords(100);
            tVertex3D2.z = tEngine.C3D_FP16To3DCoords(this.player1.ball.worldZ);
        } else if (this.glong.gameState == 2) {
            tVertex3D2.x = tEngine.C3D_FP16To3DCoords(this.target.worldX);
            tVertex3D2.y = Game.m_CurrHole3dData.maxY + tEngine.C3D_IntTo3DCoords(100);
            tVertex3D2.z = tEngine.C3D_FP16To3DCoords(this.target.worldZ);
        }
        tEngine.setOrthographicScale((byte)1, 4000);
        tEngine.setCameraRotation((byte)1, 90, 90);
        if (this.course == 0) {
            tEngine.scrollDraw2DCamera(m_CurrHole3dData, tVertex3D2, false, 34);
        } else {
            tEngine.scrollDraw2DCamera(m_CurrHole3dData, tVertex3D2, false, 2);
        }
    }

    void setScreenPutt() {
        tVertex3D tVertex3D2 = new tVertex3D();
        tVertex3D tVertex3D3 = new tVertex3D();
        tVertex3D tVertex3D4 = new tVertex3D();
        tProjVertex3D tProjVertex3D2 = new tProjVertex3D();
        int n = Mathlib.Div((this.pin.x << 12) + this.player1.ball.worldX, 131070);
        int n2 = Mathlib.Div((this.pin.z << 12) + this.player1.ball.worldZ, 131072);
        tVertex3D2.x = tEngine.C3D_FP16To3DCoords(this.pin.x << 12);
        tVertex3D2.y = tEngine.C3D_FP16To3DCoords(this.pin.y << 12);
        tVertex3D2.z = tEngine.C3D_FP16To3DCoords(this.pin.z << 12);
        tVertex3D3.x = tEngine.C3D_FP16To3DCoords(this.player1.ball.worldX);
        tVertex3D3.y = tEngine.C3D_FP16To3DCoords(this.player1.ball.worldY);
        tVertex3D3.z = tEngine.C3D_FP16To3DCoords(this.player1.ball.worldZ);
        tEngine.setTwoPointOverheadZoom((byte)1, tEngine.C3D_IntTo3DCoords(10), 1, tVertex3D2, tVertex3D3, tVertex3D4);
        tEngine.setCameraPosition((byte)1, tVertex3D4.x, Game.m_CurrHole3dData.maxY + tEngine.C3D_IntTo3DCoords(10), tVertex3D4.z);
        tEngine.setCameraRotation((byte)1, 90, 90);
        tEngine.getCameraProjectedInfo((byte)1, tVertex3D2, tProjVertex3D2);
        this.pinx = tProjVertex3D2.s.x;
        this.piny = tProjVertex3D2.s.y;
    }

    void render(Graphics graphics) {
        if (this.doReset != -1) {
            this.reset(this.doReset);
            this.doReset = -1;
        }
        this.idleClock.update();
        if (!(this.idleClock.flagStarted || this.glong.keyClock.flagStarted || this.gputt.keyClock.flagStarted)) {
            return;
        }
        switch (this.player1.gameArea) {
            case 0: {
                if (this.flagUpdateBG) {
                    this.setScreenLong();
                    if (Mathlib.toInt(this.player1.holeDist) < 100) {
                        if (this.course == 0) {
                            tEngine.draw((byte)2, m_CurrHole3dData, 63);
                        } else {
                            tEngine.draw((byte)2, m_CurrHole3dData, 31);
                        }
                    } else if (this.course == 0) {
                        tEngine.draw((byte)2, m_CurrHole3dData, 45);
                    } else {
                        tEngine.draw((byte)2, m_CurrHole3dData, 13);
                    }
                    tRenderer_MIDP_2_0.presentBuffer(false);
                    graphics.drawImage(tEngine.drawSurface, 0, 0, 0);
                    this.flagUpdateBG = false;
                    this.flagUpdateGU = true;
                }
                if (this.glong.checkUpdate() || this.flagUpdateGU) {
                    this.flagUpdateGU = false;
                    this.glong.render(graphics);
                }
                if (this.card.active) {
                    return;
                }
                this.gameui.draw(graphics);
                break;
            }
            case 1: {
                if (this.flagUpdateBG) {
                    if (!this.player1.ball.landCam) {
                        this.setScreenOver();
                        if (this.course == 0) {
                            tEngine.draw((byte)1, m_CurrHole3dData, 42);
                        } else {
                            tEngine.draw((byte)1, m_CurrHole3dData, 10);
                        }
                    } else {
                        this.setScreenLong();
                        if (this.course == 0) {
                            tEngine.draw((byte)2, m_CurrHole3dData, 43);
                        } else {
                            tEngine.draw((byte)2, m_CurrHole3dData, 11);
                        }
                    }
                    tRenderer_MIDP_2_0.presentBuffer(false);
                    graphics.drawImage(tEngine.drawSurface, 0, 0, 0);
                    this.flagUpdateBG = false;
                }
                this.glong.render(graphics);
                this.gameui.draw(graphics);
                break;
            }
            case 2: {
                if (this.flagUpdateBG) {
                    if (this.gputt.gameState >= 2) {
                        this.setScreenLong();
                        if (this.course == 0) {
                            tEngine.draw((byte)2, m_CurrHole3dData, 40);
                        } else {
                            tEngine.draw((byte)2, m_CurrHole3dData, 8);
                        }
                    } else {
                        this.setScreenPutt();
                        if (this.course == 0) {
                            tEngine.draw((byte)1, m_CurrHole3dData, 40);
                        } else {
                            tEngine.draw((byte)1, m_CurrHole3dData, 8);
                        }
                    }
                    tRenderer_MIDP_2_0.presentBuffer(false);
                    graphics.drawImage(tEngine.drawSurface, 0, 0, 0);
                    this.flagUpdateBG = false;
                    this.flagUpdateGU = true;
                }
                if (this.gputt.checkUpdate() || this.flagUpdateGU) {
                    this.gputt.render(graphics);
                    this.gameui.draw(graphics);
                }
                this.flagUpdateGU = false;
                break;
            }
            case 3: {
                this.card.render(graphics);
            }
        }
    }

    public void drawEngine(byte by, int n) {
        tEngine.draw(by, m_CurrHole3dData, n);
    }

    boolean keyDown(int n) {
        if (n == -7) {
            if (this.player1.gameArea == 3) {
                return this.card.keyDown(n);
            }
            this.app.canvas.pause();
            return true;
        }
        if (this.player1.gameArea == 0 || this.player1.gameArea == 1) {
            return this.glong.keyDown(n);
        }
        if (this.player1.gameArea == 2) {
            return this.gputt.keyDown(n);
        }
        if (this.player1.gameArea == 3) {
            return this.card.keyDown(n);
        }
        return false;
    }

    boolean keyUp(int n) {
        if (this.player1.gameArea == 0 || this.player1.gameArea == 1) {
            return this.glong.keyUp(n);
        }
        if (this.player1.gameArea == 2) {
            return this.gputt.keyUp(n);
        }
        return false;
    }

    String MtoY(int n) {
        if (this.yards) {
            if (n == 0) {
                return "0 " + this.app.gameTxtData[2][0];
            }
            return String.valueOf(Mathlib.MtoY(n)) + " " + this.app.gameTxtData[2][0];
        }
        if (n == 0) {
            return "0 " + this.app.gameTxtData[2][1];
        }
        return String.valueOf(Mathlib.toInt(n)) + " " + this.app.gameTxtData[2][1];
    }
}

