/*
 * Decompiled with CFR 0.152.
 */
package TW2006.renderer;

import TW2006.archive.tFileMgr;
import TW2006.renderer.tEngine;
import TW2006.renderer.tMaterial3D;
import TW2006.renderer.tMath;
import TW2006.renderer.tObject3DInfo;
import TW2006.renderer.tProjVertex3D;
import TW2006.renderer.tTexture;
import TW2006.renderer.tTreeRenderInfo;
import TW2006.renderer.tTriangle3D;
import TW2006.renderer.tVertex2D;
import TW2006.renderer.tVertex3D;
import java.io.InputStream;
import java.util.Random;

public class tObject3D {
    protected int vertexCount = 0;
    protected tVertex3D[] vertexList = null;
    protected int uvCount = 0;
    protected tVertex2D[] uvList = null;
    protected tMaterial3D firstMaterial = null;
    protected int m_iTreeCount = 0;
    protected tMaterial3D m_TreeMat = null;
    protected static tTexture m_TexGreen = null;
    protected static tTexture m_TexRough = null;
    protected static tTexture m_TexSandtrap = null;
    protected static tTexture m_TexWater = null;
    public tVertex3D teePos = new tVertex3D();
    public tVertex3D holePos = new tVertex3D();
    protected tProjVertex3D[] m_ProjVertexBuf = null;
    protected tTreeRenderInfo[] m_TreeRenderList = null;
    public int minX = 0;
    public int maxX = 0;
    public int minY = 0;
    public int maxY = 0;
    public int minZ = 0;
    public int maxZ = 0;
    public String tip = null;

    public tObject3D(String string, boolean bl, boolean bl2) {
        this.loadBIN(string, bl, bl2);
        this.m_ProjVertexBuf = new tProjVertex3D[this.vertexCount];
        for (int i = 0; i < this.vertexCount; ++i) {
            this.m_ProjVertexBuf[i] = new tProjVertex3D();
        }
    }

    public void loadBIN(String string, boolean bl, boolean bl2) {
        Object var4_4 = null;
        InputStream inputStream = null;
        byte[] byArray = new byte[32];
        try {
            int n;
            inputStream = tFileMgr.getFileStream(string);
            if (-1 == tFileMgr.readData(inputStream, 0, byArray, 0, 8)) {
                throw new RuntimeException("Premature EOF detected on " + string + ". Could not read hole and tee positions");
            }
            this.teePos.x = ((byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 24) >> 16;
            this.teePos.z = ((byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24) >> 16;
            this.holePos.x = ((byArray[4] & 0xFF) << 16 | (byArray[5] & 0xFF) << 24) >> 16;
            this.holePos.z = ((byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24) >> 16;
            int n2 = 0;
            if (-1 == tFileMgr.readData(inputStream, 0, byArray, 0, 2)) {
                throw new RuntimeException("Premature EOF detected on " + string + ". Could not read hole and tee positions");
            }
            n2 = ((byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 24) >> 16;
            byte[] byArray2 = new byte[n2 + 2];
            if (-1 == tFileMgr.readData(inputStream, 0, byArray2, 2, n2)) {
                throw new RuntimeException("Premature EOF detected on " + string + ". Could not read hole and tee positions");
            }
            if (-1 == tFileMgr.readData(inputStream, 0, byArray, 0, 2)) {
                throw new RuntimeException("Premature EOF detected on " + string + ". Could not read vertex count");
            }
            this.vertexCount = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
            this.vertexList = new tVertex3D[this.vertexCount];
            this.minX = Integer.MAX_VALUE;
            this.maxX = Integer.MIN_VALUE;
            this.minY = Integer.MAX_VALUE;
            this.maxY = Integer.MIN_VALUE;
            this.minZ = Integer.MAX_VALUE;
            this.maxZ = Integer.MIN_VALUE;
            for (n = 0; n < this.vertexCount; ++n) {
                if (-1 != tFileMgr.readData(inputStream, 0, byArray, 0, 6)) {
                    this.vertexList[n] = new tVertex3D();
                    this.vertexList[n].x = ((byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 24) >> 16;
                    this.vertexList[n].y = ((byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24) >> 16;
                    this.vertexList[n].z = ((byArray[4] & 0xFF) << 16 | (byArray[5] & 0xFF) << 24) >> 16;
                    if (this.minX > this.vertexList[n].x) {
                        this.minX = this.vertexList[n].x;
                    }
                    if (this.maxX < this.vertexList[n].x) {
                        this.maxX = this.vertexList[n].x;
                    }
                    if (this.minY > this.vertexList[n].y) {
                        this.minY = this.vertexList[n].y;
                    }
                    if (this.maxY < this.vertexList[n].y) {
                        this.maxY = this.vertexList[n].y;
                    }
                    if (this.minZ > this.vertexList[n].z) {
                        this.minZ = this.vertexList[n].z;
                    }
                    if (this.maxZ >= this.vertexList[n].z) continue;
                    this.maxZ = this.vertexList[n].z;
                    continue;
                }
                throw new RuntimeException("Premature EOF detected on " + string + ". Could not read vertices");
            }
            if (-1 != tFileMgr.readData(inputStream, 0, byArray, 0, 2)) {
                this.uvCount = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
                if (this.uvCount > 0) {
                    this.uvList = new tVertex2D[this.uvCount];
                }
            } else {
                throw new RuntimeException("Premature EOF detected on " + string + ". Could not read UV count");
            }
            for (n = 0; n < this.uvCount; ++n) {
                if (-1 == tFileMgr.readData(inputStream, 0, byArray, 0, 4)) {
                    throw new RuntimeException("Premature EOF detected on " + string + ". Could not read UVs");
                }
                this.uvList[n] = new tVertex2D();
                this.uvList[n].x = ((byArray[0] & 0xFF) << 16 | (byArray[1] & 0xFF) << 24) >> 16;
                this.uvList[n].y = ((byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 24) >> 16;
            }
            if (-1 == tFileMgr.readData(inputStream, 0, byArray, 0, 2)) {
                throw new RuntimeException("Premature EOF detected on " + string + ". Could not read material count");
            }
            int n3 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
            for (n = 0; n < n3; ++n) {
                int n4;
                boolean bl3 = false;
                tMaterial3D tMaterial3D2 = null;
                String string2 = null;
                if (-1 != tFileMgr.readData(inputStream, 0, byArray, 0, 32)) {
                    if ((byArray[31] & 1) != 0) {
                        bl3 = true;
                    }
                } else {
                    throw new RuntimeException("Premature EOF detected on " + string + ". Could not read texture filename");
                }
                string2 = new String(byArray);
                int n5 = 0;
                if (-1 == tFileMgr.readData(inputStream, 0, byArray, 0, 2)) {
                    throw new RuntimeException("Premature EOF detected on " + string + ". Could not read tri count for matrial: " + n);
                }
                n5 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
                if (n5 <= 0) continue;
                tMaterial3D2 = this.addMaterial(string2, n5);
                if (tMaterial3D2 == null) {
                    for (n4 = 0; n4 < n5; ++n4) {
                        if (-1 == tFileMgr.readData(inputStream, 0, byArray, 0, bl3 ? 8 : 4)) continue;
                        throw new RuntimeException("Premature EOF detected on " + string + ". Could not read vertex/UV indices for matrial: " + n);
                    }
                    continue;
                }
                tMaterial3D2.triangleList = new tTriangle3D[tMaterial3D2.triangleCount];
                if (bl2 && tMaterial3D2.type == 9) {
                    this.m_TreeMat = tMaterial3D2;
                    this.m_iTreeCount = tMaterial3D2.triangleCount;
                    this.m_TreeRenderList = new tTreeRenderInfo[this.m_iTreeCount];
                    for (n4 = 0; n4 < this.m_iTreeCount; ++n4) {
                        this.m_TreeRenderList[n4] = new tTreeRenderInfo();
                    }
                }
                Random random = new Random(78L);
                for (int i = 0; i < tMaterial3D2.triangleCount; ++i) {
                    if (-1 != tFileMgr.readData(inputStream, 0, byArray, 0, bl3 ? 8 : 4)) {
                        tMaterial3D2.triangleList[i] = new tTriangle3D(bl3);
                        tMaterial3D2.triangleList[i].vertex[0] = (short)(byArray[0] & 0xFF | (byArray[3] & 1) << 8);
                        tMaterial3D2.triangleList[i].vertex[1] = (short)(byArray[1] & 0xFF | (byArray[3] & 2) << 7);
                        tMaterial3D2.triangleList[i].vertex[2] = (short)(byArray[2] & 0xFF | (byArray[3] & 4) << 6);
                        tMaterial3D2.triangleList[i].edgeShared[0] = (byArray[3] & 0x20) != 0;
                        tMaterial3D2.triangleList[i].edgeShared[1] = (byArray[3] & 0x40) != 0;
                        boolean bl4 = tMaterial3D2.triangleList[i].edgeShared[2] = (byArray[3] & 0x80) != 0;
                        if (bl2 && tMaterial3D2.type == 9) {
                            this.m_TreeRenderList[i].worldPos.x = (this.vertexList[tMaterial3D2.triangleList[i].vertex[0]].x + this.vertexList[tMaterial3D2.triangleList[i].vertex[1]].x + this.vertexList[tMaterial3D2.triangleList[i].vertex[2]].x) / 3;
                            this.m_TreeRenderList[i].worldPos.y = (this.vertexList[tMaterial3D2.triangleList[i].vertex[0]].y + this.vertexList[tMaterial3D2.triangleList[i].vertex[1]].y + this.vertexList[tMaterial3D2.triangleList[i].vertex[2]].y) / 3;
                            this.m_TreeRenderList[i].worldPos.z = (this.vertexList[tMaterial3D2.triangleList[i].vertex[0]].z + this.vertexList[tMaterial3D2.triangleList[i].vertex[1]].z + this.vertexList[tMaterial3D2.triangleList[i].vertex[2]].z) / 3;
                            this.m_TreeRenderList[i].type = (byte)(Math.abs(random.nextInt()) % tEngine.m_TreeCount);
                        }
                        if (!bl3) continue;
                        tMaterial3D2.triangleList[i].uvCoords[0] = (short)(byArray[4] & 0xFF | (byArray[7] & 3) << 8);
                        tMaterial3D2.triangleList[i].uvCoords[1] = (short)(byArray[5] & 0xFF | (byArray[7] & 0xC) << 6);
                        tMaterial3D2.triangleList[i].uvCoords[2] = (short)(byArray[6] & 0xFF | (byArray[7] & 0x30) << 4);
                        continue;
                    }
                    throw new RuntimeException("Premature EOF detected on " + string + ". Could not read vertex/UV indices for matrial: " + n);
                }
            }
            byArray = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
            inputStream = null;
            System.gc();
        }
    }

    public final void initDataStageOne() {
        this.computeMaterialNormals();
    }

    public final void initDataStageTwo() {
        this.reorderMaterial();
        this.generateUVCoords();
    }

    public final void initDataStageThree() {
        tObject3DInfo tObject3DInfo2 = new tObject3DInfo();
        tObject3DInfo2.x = this.teePos.x;
        tObject3DInfo2.z = this.teePos.z;
        tEngine.getTerrainInfo(this, tObject3DInfo2);
        this.teePos.y = tObject3DInfo2.y;
        if (tObject3DInfo2.type != 7) {
            System.out.println("<WARNING>: Tee position is not on tee patch");
        }
        tObject3DInfo2.x = this.holePos.x;
        tObject3DInfo2.z = this.holePos.z;
        tEngine.getTerrainInfo(this, tObject3DInfo2);
        this.holePos.y = tObject3DInfo2.y;
        if (tObject3DInfo2.type != 2) {
            System.out.println("<WARNING>: Hole position is not on green patch");
        }
    }

    private final void computeMaterialNormals() {
        tVertex3D tVertex3D2 = new tVertex3D();
        tVertex3D tVertex3D3 = new tVertex3D();
        tVertex3D tVertex3D4 = new tVertex3D();
        tMaterial3D tMaterial3D2 = null;
        try {
            tMaterial3D2 = this.firstMaterial;
            while (tMaterial3D2 != null) {
                for (int i = 0; i < tMaterial3D2.triangleCount; ++i) {
                    tVertex3D2.copy(this.vertexList[tMaterial3D2.triangleList[i].vertex[0]]);
                    tVertex3D3.copy(this.vertexList[tMaterial3D2.triangleList[i].vertex[1]]);
                    tVertex3D4.copy(this.vertexList[tMaterial3D2.triangleList[i].vertex[2]]);
                    tMaterial3D2.triangleList[i].normal.x = (tVertex3D2.z - tVertex3D3.z) * (tVertex3D4.y - tVertex3D3.y) - (tVertex3D2.y - tVertex3D3.y) * (tVertex3D4.z - tVertex3D3.z) >> 4;
                    tMaterial3D2.triangleList[i].normal.y = (tVertex3D2.x - tVertex3D3.x) * (tVertex3D4.z - tVertex3D3.z) - (tVertex3D2.z - tVertex3D3.z) * (tVertex3D4.x - tVertex3D3.x) >> 4;
                    tMaterial3D2.triangleList[i].normal.z = (tVertex3D2.y - tVertex3D3.y) * (tVertex3D4.x - tVertex3D3.x) - (tVertex3D2.x - tVertex3D3.x) * (tVertex3D4.y - tVertex3D3.y) >> 4;
                    int n = tMath.SQRT_Int(tMaterial3D2.triangleList[i].normal.x * tMaterial3D2.triangleList[i].normal.x + tMaterial3D2.triangleList[i].normal.y * tMaterial3D2.triangleList[i].normal.y + tMaterial3D2.triangleList[i].normal.z * tMaterial3D2.triangleList[i].normal.z);
                    if (n > 0) {
                        long l = tMaterial3D2.triangleList[i].normal.x << 8;
                        long l2 = tMaterial3D2.triangleList[i].normal.y << 8;
                        long l3 = tMaterial3D2.triangleList[i].normal.z << 8;
                        tMaterial3D2.triangleList[i].normal.x = (int)(l / (long)n << 8);
                        tMaterial3D2.triangleList[i].normal.y = (int)(l2 / (long)n << 8);
                        tMaterial3D2.triangleList[i].normal.z = (int)(l3 / (long)n << 8);
                        if (tMaterial3D2.triangleList[i].normal.x > 65536) {
                            tMaterial3D2.triangleList[i].normal.x = 4096;
                        } else if (tMaterial3D2.triangleList[i].normal.x < -65536) {
                            tMaterial3D2.triangleList[i].normal.x = -4096;
                        }
                        if (tMaterial3D2.triangleList[i].normal.y > 65536 || tMaterial3D2.triangleList[i].normal.y < -65536) {
                            tMaterial3D2.triangleList[i].normal.y = 65536;
                        }
                        if (tMaterial3D2.triangleList[i].normal.z > 65536) {
                            tMaterial3D2.triangleList[i].normal.z = 4096;
                            continue;
                        }
                        if (tMaterial3D2.triangleList[i].normal.z >= -65536) continue;
                        tMaterial3D2.triangleList[i].normal.z = -4096;
                        continue;
                    }
                    if (tMaterial3D2.triangleList[i].normal.x > 0) {
                        tMaterial3D2.triangleList[i].normal.x = 4096;
                    } else if (tMaterial3D2.triangleList[i].normal.x < 0) {
                        tMaterial3D2.triangleList[i].normal.x = -4096;
                    }
                    tMaterial3D2.triangleList[i].normal.y = 65536;
                    if (tMaterial3D2.triangleList[i].normal.z > 0) {
                        tMaterial3D2.triangleList[i].normal.z = 4096;
                        continue;
                    }
                    if (tMaterial3D2.triangleList[i].normal.z >= 0) continue;
                    tMaterial3D2.triangleList[i].normal.z = -4096;
                }
                tMaterial3D2 = tMaterial3D2.nextMaterial;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("Precomputation of normals encountered exception: " + exception.getMessage());
        }
    }

    private final void generateUVCoords() {
        tTriangle3D tTriangle3D2;
        int n;
        int n2;
        tMaterial3D tMaterial3D2 = null;
        tVertex2D tVertex2D2 = null;
        if (this.uvList != null) {
            return;
        }
        this.uvCount = this.vertexCount;
        this.uvList = new tVertex2D[this.uvCount];
        for (n2 = 0; n2 < this.uvCount; ++n2) {
            this.uvList[n2] = new tVertex2D();
        }
        for (n2 = 0; n2 < this.uvCount; ++n2) {
            tVertex2D2 = this.uvList[n2];
            int n3 = 0;
            tMaterial3D2 = this.firstMaterial;
            while (tMaterial3D2 != null) {
                for (n = 0; n < tMaterial3D2.triangleCount; ++n) {
                    tTriangle3D2 = tMaterial3D2.triangleList[n];
                    if (tTriangle3D2.vertex[0] != n2 && tTriangle3D2.vertex[1] != n2 && tTriangle3D2.vertex[2] != n2) continue;
                    tVertex2D2.y += (-tTriangle3D2.normal.z >> 9) + (tTriangle3D2.normal.x >> 8);
                    ++n3;
                }
                tMaterial3D2 = tMaterial3D2.nextMaterial;
            }
            if (n3 != 0) {
                tVertex2D2.y = 100 - tVertex2D2.y * 3 / n3;
            }
            if (tVertex2D2.y < 8) {
                tVertex2D2.y = 8;
            }
            if (tVertex2D2.y <= 247) continue;
            tVertex2D2.y = 247;
        }
        tMaterial3D2 = this.firstMaterial;
        while (tMaterial3D2 != null) {
            for (n = 0; n < tMaterial3D2.triangleCount; ++n) {
                tTriangle3D2 = tMaterial3D2.triangleList[n];
                tTriangle3D2.uvCoords = tTriangle3D2.vertex;
            }
            tMaterial3D2 = tMaterial3D2.nextMaterial;
        }
    }

    protected tMaterial3D addMaterial(String string, int n) {
        string = string.substring(0, string.lastIndexOf(46));
        byte by = tObject3D.texNameToTerrainType(string = string.concat(".cpi"));
        if (by == 0) {
            return null;
        }
        tMaterial3D tMaterial3D2 = new tMaterial3D();
        tMaterial3D2.triangleCount = n;
        tMaterial3D2.type = by;
        switch (by) {
            case 2: 
            case 7: {
                if (m_TexGreen == null) {
                    m_TexGreen = new tTexture("green.cpi");
                }
                tMaterial3D2.texture = m_TexGreen;
                break;
            }
            case 3: 
            case 9: {
                if (m_TexRough == null) {
                    m_TexRough = new tTexture("rough.cpi");
                }
                tMaterial3D2.texture = m_TexRough;
                break;
            }
            case 4: 
            case 6: {
                if (m_TexSandtrap == null) {
                    m_TexSandtrap = new tTexture("sandtrap.cpi");
                }
                tMaterial3D2.texture = m_TexSandtrap;
                break;
            }
            case 8: {
                tMaterial3D2.texture = tEngine.m_OutOfBoundsWater;
                break;
            }
            default: {
                tMaterial3D2.texture = new tTexture(string);
            }
        }
        if (this.firstMaterial != null) {
            tMaterial3D tMaterial3D3 = this.firstMaterial;
            while (tMaterial3D3.nextMaterial != null) {
                tMaterial3D3 = tMaterial3D3.nextMaterial;
            }
            tMaterial3D3.nextMaterial = tMaterial3D2;
        } else {
            this.firstMaterial = tMaterial3D2;
        }
        return tMaterial3D2;
    }

    private void reorderMaterial() {
        tMaterial3D[] tMaterial3DArray = new tMaterial3D[9];
        tMaterial3D tMaterial3D2 = this.firstMaterial;
        while (tMaterial3D2 != null) {
            switch (tMaterial3D2.type) {
                case 5: {
                    tMaterial3DArray[0] = tMaterial3D2;
                    break;
                }
                case 8: {
                    tMaterial3DArray[1] = tMaterial3D2;
                    break;
                }
                case 3: {
                    tMaterial3DArray[2] = tMaterial3D2;
                    break;
                }
                case 9: {
                    tMaterial3DArray[3] = tMaterial3D2;
                    break;
                }
                case 7: {
                    tMaterial3DArray[4] = tMaterial3D2;
                    break;
                }
                case 6: {
                    tMaterial3DArray[5] = tMaterial3D2;
                    break;
                }
                case 4: {
                    tMaterial3DArray[6] = tMaterial3D2;
                    break;
                }
                case 1: {
                    tMaterial3DArray[7] = tMaterial3D2;
                    break;
                }
                case 2: {
                    tMaterial3DArray[8] = tMaterial3D2;
                }
            }
            tMaterial3D2 = tMaterial3D2.nextMaterial;
        }
        this.firstMaterial = null;
        tMaterial3D2 = null;
        for (int i = 0; i < 9; ++i) {
            if (this.firstMaterial == null && tMaterial3DArray[i] != null) {
                this.firstMaterial = tMaterial3DArray[i];
                tMaterial3D2 = tMaterial3DArray[i];
                continue;
            }
            if (tMaterial3DArray[i] == null) continue;
            tMaterial3D2.nextMaterial = tMaterial3DArray[i];
            tMaterial3D2 = tMaterial3DArray[i];
        }
        tMaterial3D2.nextMaterial = null;
    }

    public static final byte texNameToTerrainType(String string) {
        if (string.compareTo("fairway_a.cpi") == 0) {
            return 1;
        }
        if (string.compareTo("green.cpi") == 0) {
            return 2;
        }
        if (string.compareTo("rough.cpi") == 0) {
            return 3;
        }
        if (string.compareTo("sandtrap.cpi") == 0) {
            return 4;
        }
        if (string.compareTo("cliff.cpi") == 0) {
            return 5;
        }
        if (string.compareTo("desert.cpi") == 0) {
            return 6;
        }
        if (string.compareTo("tee.cpi") == 0) {
            return 7;
        }
        if (string.compareTo("water.cpi") == 0) {
            return 8;
        }
        if (string.compareTo("trees.cpi") == 0) {
            return 9;
        }
        return 0;
    }
}

