/*
 * Decompiled with CFR 0.152.
 */
import TW2006.archive.tFileMgr;
import TW2006.renderer.tEngine;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Golfer {
    Game game;
    int screenX;
    int screenY;
    Image wAnim;
    Image pAnim;
    Image oAnim;
    int swingBack = 7;
    int swingHit = 11;
    int swingLength = 640;
    int puttHit = 12;
    int puttBack = 7;
    byte[] legend = new byte[2];
    int numFrames;
    int totFrames;
    int puttTdFrames;
    int wWidth;
    int wHeight;
    int pWidth;
    int pHeight;
    int oWidth;
    int oHeight;
    int frame;
    int anim;
    boolean update = true;
    boolean redArc = false;
    boolean blueArc = false;

    public Golfer(Game game) {
        this.game = game;
        this.reset();
        try {
            String string = System.getProperty("microedition.platform");
            if (string != null) {
                this.swingLength = string.startsWith("j2me") ? 640 : (string.startsWith("Nokia36") ? 750 : (string.startsWith("Nokia66") ? 750 : 1000));
            }
            string = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void reset() {
        this.frame = 0;
        this.update = true;
    }

    public void setFrames() {
        this.puttTdFrames = 16;
        this.totFrames = 16;
        this.numFrames = 16;
    }

    public void tweakHitFrames() {
        switch (this.frame) {
            case 0: {
                this.frame = 11;
                this.numFrames = 12;
                break;
            }
            case 1: {
                this.frame = 11;
                this.numFrames = 13;
                break;
            }
            case 2: {
                this.frame = 10;
                this.numFrames = 13;
                break;
            }
            case 3: {
                this.frame = 10;
                this.numFrames = 14;
                break;
            }
            case 4: {
                this.frame = 9;
                this.numFrames = 14;
                break;
            }
            case 5: {
                this.frame = 9;
                this.numFrames = 15;
                break;
            }
            case 6: {
                this.frame = 8;
                this.numFrames = 15;
            }
        }
    }

    public void tweakPuttFrames() {
        switch (this.frame) {
            case 0: {
                this.frame = 11;
                this.numFrames = 13;
                break;
            }
            case 1: {
                this.frame = 11;
                this.numFrames = 13;
                break;
            }
            case 2: {
                this.frame = 11;
                this.numFrames = 14;
                break;
            }
            case 3: {
                this.frame = 11;
                this.numFrames = 14;
                break;
            }
            case 4: {
                this.frame = 10;
                this.numFrames = 15;
                break;
            }
            case 5: {
                this.frame = 9;
                this.numFrames = 15;
                break;
            }
            case 6: {
                this.frame = 8;
                this.numFrames = 16;
                break;
            }
            case 7: {
                this.frame = 8;
                this.numFrames = 16;
            }
        }
    }

    public void setAnim(int n, int n2, int n3) {
        this.anim = n;
        this.screenX = n2;
        this.screenY = n3;
        switch (this.anim) {
            case -3: {
                this.screenX = this.game.SCREEN_WIDTH / 2 - this.pWidth / 2 + 4;
                this.screenY = this.game.SCREEN_HEIGHT - 33;
                break;
            }
            case -1: {
                this.screenX = this.game.player1.ball.screenX;
                this.screenY = this.game.player1.ball.screenY;
            }
        }
    }

    public void loadGraphics(byte by, byte by2) {
        String string = "";
        byte[] byArray = null;
        this.legend[0] = by;
        this.legend[1] = by2;
        this.setFrames();
        tEngine.loadGRS(this.game.app.canvas.gamedata.golfers.names[by].replace(' ', '_').toLowerCase() + ".grs");
        string = tEngine.prefixAnim;
        byArray = tFileMgr.getFileByteArray(string + "_driv.png");
        try {
            this.wAnim = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.wWidth = this.wAnim.getWidth() / this.numFrames;
        this.wHeight = this.wAnim.getHeight();
        byArray = tFileMgr.getFileByteArray(string + "_putt.png");
        try {
            this.pAnim = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.pWidth = this.pAnim.getWidth() / this.numFrames;
        this.pHeight = this.pAnim.getHeight();
        byArray = tFileMgr.getFileByteArray(string + "_putt_td.png");
        try {
            this.oAnim = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.oWidth = this.oAnim.getWidth() / this.puttTdFrames;
        this.oHeight = this.oAnim.getHeight();
        byArray = null;
        System.gc();
    }

    void updateScreen() {
        if (this.game.player1.gameArea == 0) {
            this.setAnim(-1, 0, 0);
        } else {
            GamePutt cfr_ignored_0 = this.game.gputt;
            if (this.game.gputt.gameState >= 2) {
                this.setAnim(-3, 0, 0);
            } else {
                int n;
                int n2 = Mathlib.toInt(Mathlib.Div(Mathlib.Mul(Ball.ONEEIGHTY, Mathlib.Angle(this.game.player1.ball.worldX, this.game.player1.ball.worldZ, this.game.target.worldX, this.game.target.worldZ, 0)), 205887));
                if (this.game.player1.ball.worldX >= this.game.target.worldX && this.game.player1.ball.worldZ >= this.game.target.worldZ) {
                    n2 = 270 - n2;
                } else if (this.game.player1.ball.worldX >= this.game.target.worldX && this.game.player1.ball.worldZ <= this.game.target.worldZ) {
                    n2 = 270 + n2;
                } else if (this.game.player1.ball.worldX <= this.game.target.worldX && this.game.player1.ball.worldZ <= this.game.target.worldZ) {
                    n2 = 90 - n2;
                } else if (this.game.player1.ball.worldX <= this.game.target.worldX && this.game.player1.ball.worldZ >= this.game.target.worldZ) {
                    n2 = 90 + n2;
                }
                for (n = Mathlib.toInt(Mathlib.Div(Mathlib.intToFP(n2 - 11), 1474560)) - 11 - 8; n < 0; n += this.totFrames) {
                }
                this.setAnim(n, this.game.player1.ball.screenX, this.game.player1.ball.screenY);
            }
        }
        this.update = false;
    }

    public void drawBG(Graphics graphics, Image image) {
        if (this.game.player1.gameArea == 0) {
            if (this.anim == -1) {
                graphics.setClip(this.screenX - this.wWidth + 4, this.screenY - this.wHeight + 4, this.wWidth, this.wHeight);
                graphics.drawImage(image, 0, 0, 20);
            }
        } else if (this.game.player1.gameArea == 2) {
            if (this.anim == -3) {
                graphics.setClip(this.screenX - this.pWidth / 2, this.screenY - this.pHeight, this.pWidth, this.pHeight);
                graphics.drawImage(image, 0, 0, 20);
            } else {
                graphics.setClip(this.screenX - this.oWidth / 2, this.screenY - this.oHeight / 2, this.oWidth, this.oHeight);
                graphics.drawImage(image, 0, 0, 20);
            }
        }
        graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
    }

    public void draw(Graphics graphics) {
        if (this.update) {
            this.updateScreen();
        }
        if (this.anim == -1) {
            if (this.game.player1.gameArea == 0) {
                graphics.setClip(this.screenX - this.wWidth + 4, this.screenY - this.wHeight + 4, this.wWidth, this.wHeight);
                graphics.drawImage(this.wAnim, this.screenX - this.wWidth * this.frame - this.wWidth + 4, this.screenY + 4, 36);
                if (this.frame != 0 && this.game.glong.gameState != 6 && (this.redArc || this.blueArc)) {
                    if (this.blueArc) {
                        graphics.setColor(0xFF0000);
                    } else if (this.redArc) {
                        graphics.setColor(255);
                    }
                    graphics.setClip(89 - this.frame * 12, 174 - this.frame * 17, 107, 107);
                    graphics.drawArc(this.screenX - this.wWidth * 3 / 4, this.screenY - this.wHeight - 20, this.wWidth * 2, this.wHeight + 25, 160, 90);
                }
            }
        }
        if (this.anim == -3) {
            graphics.setClip(this.screenX - this.pWidth / 2, this.screenY - this.pHeight, this.pWidth, this.pHeight);
            graphics.drawImage(this.pAnim, this.screenX - this.pWidth * this.frame - this.pWidth / 2, this.screenY, 36);
        }
        if (this.anim > -1) {
            graphics.setClip(this.screenX - this.oWidth / 2, this.screenY - this.oHeight / 2, this.oWidth, this.oHeight);
            graphics.drawImage(this.oAnim, this.screenX - this.oWidth * this.anim - this.oWidth / 2, this.screenY - this.oHeight / 2, 20);
        }
        graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
    }
}

