/*
 * Decompiled with CFR 0.152.
 */
import TW2006.renderer.tEngine;
import TW2006.renderer.tProjVertex3D;
import TW2006.renderer.tVertex3D;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameLong {
    static final byte STATE_TUTORIAL = -1;
    static final byte STATE_INIT = 0;
    static final byte STATE_READY = 1;
    static final byte STATE_AIM = 2;
    static final byte STATE_BACKSWING = 3;
    static final byte STATE_SWINGPAUSE = 4;
    static final byte STATE_FORESWING = 5;
    static final byte STATE_RESET = 6;
    static final byte STATE_FEEDBACK = 7;
    int gameState = 0;
    long backSwingStart;
    long backSwingTime;
    long backSwing;
    long backSwingStop;
    int ANIM_TIME1 = 70;
    int ANIM_TIME2 = 50;
    int ANIM_TIME3 = 70;
    int BALL_TIME = 10;
    int KEY_TIME = 30;
    int keyDown;
    int power;
    int skew;
    int dir;
    int fdist;
    Game game;
    Target target;
    Golfer golfer;
    Clock ballClock;
    Clock animClock;
    Clock keyClock;
    Clock delayClock1;
    Clock delayClock2;
    boolean hardReset = false;
    boolean clipInfo = false;
    boolean init = false;
    String feedback1 = new String();
    Image hoverFlag;
    Clock hoverClock;
    byte HOVER_UP = 0;
    byte HOVER_DOWN = 1;
    byte hoverDir = this.HOVER_UP;
    byte hoverOffset = 0;
    int hoverx;
    int hovery;
    int tipscroll;

    public GameLong(Game game, Golfer golfer, Target target) {
        this.game = game;
        this.golfer = golfer;
        this.target = target;
        this.ballClock = new Clock();
        this.animClock = new Clock();
        this.keyClock = new Clock();
        this.delayClock1 = new Clock();
        this.delayClock2 = new Clock();
        this.hoverClock = new Clock();
    }

    void loadGraphics() {
        this.hoverFlag = this.game.app.loadImage("flagpointer.png");
    }

    void reset(int n) {
        this.ballClock.cancel();
        this.animClock.cancel();
        this.backSwingTime = 0L;
        this.backSwingStop = 0L;
        this.backSwing = 0L;
        this.power = 0;
        this.skew = 0;
        this.dir = 0;
        this.tipscroll = 0;
        this.init = false;
        if (n == 0 && this.game.tips) {
            this.setState(0);
        } else if (n == 0 && !this.game.tips) {
            this.setState(1);
        } else {
            this.setState(n);
        }
    }

    void resetAnim() {
        this.ballClock.cancel();
        this.animClock.cancel();
        this.backSwingTime = 0L;
        this.backSwingStop = 0L;
        this.backSwing = 0L;
        this.power = 0;
        this.skew = 0;
        this.hardReset = false;
        this.setState(1);
    }

    boolean checkUpdate() {
        if (this.keyClock.flagStarted) {
            return true;
        }
        if (this.ballClock.flagStarted) {
            return true;
        }
        if (this.delayClock1.flagStarted) {
            return true;
        }
        if (this.delayClock2.flagStarted) {
            return true;
        }
        if (this.animClock.flagStarted) {
            return true;
        }
        return this.hoverClock.flagStarted;
    }

    void cancelClocks() {
        this.keyClock.cancel();
        this.ballClock.cancel();
        this.delayClock1.cancel();
        this.delayClock2.cancel();
        this.animClock.cancel();
        this.hoverClock.cancel();
    }

    void onTimer() {
        if (this.keyClock.update()) {
            this.keyClock.start(this.KEY_TIME);
            switch (this.keyDown) {
                case -3: {
                    if (--this.dir >= -20) break;
                    this.game.camOffset = this.game.quad == 2 || this.game.quad == 4 ? (this.game.camOffset += this.dir) : (this.game.camOffset -= this.dir);
                    this.dir = 0;
                    if (this.game.camOffset < -100) {
                        this.game.camOffset += 360;
                    }
                    if (this.game.camOffset > 320) {
                        this.game.camOffset -= 360;
                    }
                    if (this.game.player1.gameArea != 0) break;
                    this.game.flagUpdateBG = true;
                    break;
                }
                case -4: {
                    if (++this.dir <= 20) break;
                    this.game.camOffset = this.game.quad == 2 || this.game.quad == 4 ? (this.game.camOffset += this.dir) : (this.game.camOffset -= this.dir);
                    this.dir = 0;
                    if (this.game.camOffset < -100) {
                        this.game.camOffset += 360;
                    }
                    if (this.game.camOffset > 320) {
                        this.game.camOffset -= 360;
                    }
                    if (this.game.player1.gameArea != 0) break;
                    this.game.flagUpdateBG = true;
                    break;
                }
                case -1: {
                    if (this.gameState != 2) break;
                    this.target.swingDist += 2;
                    Ball cfr_ignored_0 = this.game.player1.ball;
                    if (this.game.player1.ball.table == 0) {
                        Ball cfr_ignored_1 = this.game.player1.ball;
                        Ball cfr_ignored_2 = this.game.player1.ball;
                        if (this.target.swingDist <= Ball.cdist[0] - Ball.cdist[this.target.club]) break;
                        Ball cfr_ignored_3 = this.game.player1.ball;
                        Ball cfr_ignored_4 = this.game.player1.ball;
                        this.target.swingDist = Ball.cdist[0] - Ball.cdist[this.target.club];
                        break;
                    }
                    Ball cfr_ignored_5 = this.game.player1.ball;
                    Ball cfr_ignored_6 = this.game.player1.ball;
                    if (this.target.swingDist <= Ball.cdist2[0] - Ball.cdist2[this.target.club]) break;
                    Ball cfr_ignored_7 = this.game.player1.ball;
                    Ball cfr_ignored_8 = this.game.player1.ball;
                    this.target.swingDist = Ball.cdist2[0] - Ball.cdist2[this.target.club];
                    break;
                }
                case -2: {
                    if (this.gameState != 2) break;
                    this.target.swingDist -= 2;
                    Ball cfr_ignored_9 = this.game.player1.ball;
                    if (this.game.player1.ball.table == 0) {
                        Ball cfr_ignored_10 = this.game.player1.ball;
                        if (this.target.swingDist >= 0 - Ball.cdist[this.target.club]) break;
                        Ball cfr_ignored_11 = this.game.player1.ball;
                        this.target.swingDist = 0 - Ball.cdist[this.target.club];
                        break;
                    }
                    Ball cfr_ignored_12 = this.game.player1.ball;
                    if (this.target.swingDist >= 0 - Ball.cdist2[this.target.club]) break;
                    Ball cfr_ignored_13 = this.game.player1.ball;
                    this.target.swingDist = 0 - Ball.cdist2[this.target.club];
                }
            }
            this.target.resetPosition(this.dir);
        }
        if (this.ballClock.update()) {
            long l = System.currentTimeMillis();
            if (this.game.player1.ball.moveBall(l)) {
                this.ballClock.start(this.BALL_TIME);
            } else {
                this.setState(7);
            }
        }
        if (this.animClock.update()) {
            switch (this.gameState) {
                case 6: {
                    if (this.golfer.frame > 0) {
                        --this.golfer.frame;
                    }
                    this.animClock.start(this.ANIM_TIME3);
                    if (this.golfer.frame != 0) break;
                    this.resetAnim();
                    break;
                }
                case 3: {
                    if (this.golfer.frame < this.golfer.swingBack) {
                        ++this.golfer.frame;
                        if (this.golfer.frame == this.golfer.swingBack) {
                            this.backSwingStop = System.currentTimeMillis();
                        }
                    }
                    if ((long)this.golfer.swingLength + this.backSwingStart + 400L < System.currentTimeMillis()) {
                        this.setState(6);
                        this.hardReset = true;
                        break;
                    }
                    this.animClock.start(this.ANIM_TIME1);
                    break;
                }
                case 4: {
                    this.animClock.start(this.ANIM_TIME1);
                    if (this.backSwingTime + 400L >= System.currentTimeMillis()) break;
                    this.setState(6);
                    break;
                }
                case 5: {
                    if (this.golfer.frame < this.golfer.numFrames - 1) {
                        this.animClock.start(this.ANIM_TIME2);
                        if (this.golfer.frame == this.golfer.swingHit) {
                            this.ballClock.start(this.BALL_TIME);
                        }
                        ++this.golfer.frame;
                        break;
                    }
                    this.game.player1.gameArea = 1;
                    this.game.flagUpdateBG = true;
                }
            }
        }
        if (this.delayClock1.update()) {
            if (this.init) {
                this.delayClock2.start(750L);
            } else {
                this.game.doReset = 1;
            }
        }
        if (this.delayClock2.update()) {
            this.game.card.init(0);
        }
        if (this.hoverClock.update()) {
            if (this.hoverDir == this.HOVER_UP) {
                this.hoverOffset = (byte)(this.hoverOffset + 1);
                if (this.hoverOffset == 5) {
                    this.hoverDir = this.HOVER_DOWN;
                }
            } else {
                this.hoverOffset = (byte)(this.hoverOffset - 1);
                if (this.hoverOffset == 0) {
                    this.hoverDir = this.HOVER_UP;
                }
            }
            this.hoverClock.start(100L);
        }
    }

    void setState(int n) {
        this.gameState = n;
        this.game.flagUpdateGU = true;
        switch (this.gameState) {
            case -1: {
                this.clipInfo = true;
                this.game.gameui.leftsoft = "";
                break;
            }
            case 0: {
                this.clipInfo = true;
                this.game.gameui.leftsoft = "";
                if (this.game.tips) break;
                this.setState(1);
                break;
            }
            case 1: {
                this.game.gameui.leftsoft = this.game.app.gameTxtData[3][0];
                this.hoverClock.start(100L);
                break;
            }
            case 2: {
                this.target.club = this.game.player1.ball.club;
                this.game.gameui.leftsoft = this.game.app.gameTxtData[3][1];
                this.game.player1.gameArea = 1;
                this.target.swingDist = 0;
                this.target.resetPosition(this.dir);
                this.game.flagUpdateBG = true;
                break;
            }
            case 3: {
                this.hoverClock.cancel();
                this.clipInfo = true;
                this.backSwingStart = System.currentTimeMillis();
                break;
            }
            case 5: {
                this.golfer.blueArc = false;
                this.golfer.redArc = false;
                this.golfer.tweakHitFrames();
                if (this.gameState != 5) break;
                this.power = 65536 - Mathlib.Abs(Mathlib.Div(Mathlib.Div(Mathlib.intToFP((int)(this.backSwing + (long)this.golfer.swingLength)), 65535), Mathlib.intToFP(this.golfer.swingLength)));
                if (this.power < 100) {
                    ++this.power;
                }
                int n2 = this.game.hole - 1;
                this.game.player1.score[n2] = (byte)(this.game.player1.score[n2] + 1);
                this.game.player1.ball.calcHit(this.power, this.skew, this.dir);
                GolfMIDlet cfr_ignored_0 = this.game.app;
                this.game.app.playSound((byte)0);
                break;
            }
            case 4: {
                this.backSwingTime = System.currentTimeMillis();
                this.backSwing += this.backSwingStart - this.backSwingTime;
                if (this.golfer.frame < 2) {
                    this.setState(6);
                    break;
                }
                if (this.backSwing >= (long)(-this.golfer.swingLength * 2)) break;
                this.hardReset = true;
                this.setState(6);
                break;
            }
            case 6: {
                this.animClock.start(this.ANIM_TIME3);
                if (this.golfer.blueArc) {
                    this.golfer.blueArc = false;
                    this.dir += 8;
                }
                if (!this.golfer.redArc) break;
                this.golfer.redArc = false;
                this.dir -= 8;
                break;
            }
            case 7: {
                this.game.checkTerrain();
                this.game.checkTerrain = false;
                this.fdist = this.game.hitDist();
                if (this.game.checkHole()) {
                    if (this.game.gameType != 1) {
                        this.genResult();
                    } else {
                        this.feedback1 = "";
                    }
                    this.init = true;
                    this.game.app.canvas.gamedata.trophies.checkHoleTrophies();
                    if (this.game.hole == this.game.resHole2) {
                        if (this.game.resHole1 == 1 && this.game.resHole2 == 18) {
                            this.game.app.canvas.gamedata.trophies.checkRoundTrophies();
                        }
                        if (this.game.gameType == 1) {
                            int n3 = 0;
                            int n4 = 0;
                            for (int i = 0; i < 18; ++i) {
                                n4 += this.game.player1.score[i];
                                n3 += this.game.player2.score[i];
                            }
                            if (n4 < n3) {
                                this.game.app.canvas.gamedata.trophies.legends[this.game.challenge] = true;
                                this.game.app.canvas.gamedata.trophies.checkLegendTrophies();
                            }
                        }
                    }
                    if (this.game.gameType != 1) {
                        this.game.app.canvas.gamedata.playerstats.stat[0] = this.game.app.canvas.gamedata.playerstats.stat[0] + 1;
                    }
                } else if (this.game.player1.score[this.game.hole - 1] > 11) {
                    if (this.game.gameType != 1) {
                        this.genResult();
                    } else {
                        this.feedback1 = "";
                    }
                    if (this.game.gameType != 1) {
                        this.game.app.canvas.gamedata.playerstats.stat[0] = this.game.app.canvas.gamedata.playerstats.stat[0] + 1;
                    }
                    this.init = true;
                } else {
                    if (this.game.gameType != 1) {
                        this.genFeedback();
                    } else {
                        this.feedback1 = "";
                    }
                    this.game.app.canvas.gamedata.trophies.checkLongShotTrophies();
                    if (this.game.oldTerrainInfo.type == 7 && this.game.gameType != 1) {
                        this.game.app.canvas.gamedata.playerstats.checkLongShot(this.fdist);
                    }
                    this.init = false;
                }
                this.delayClock1.start(2000L);
            }
        }
    }

    public void render(Graphics graphics) {
        if (this.game.card.active) {
            return;
        }
        switch (this.gameState) {
            case -1: {
                MenuCanvas cfr_ignored_0 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.setFont(0);
                MenuCanvas cfr_ignored_1 = this.game.app.canvas.g_menu;
                MenuCanvas cfr_ignored_2 = this.game.app.canvas.g_menu;
                graphics.setClip(this.game.SCREEN_WIDTH / 2 - MenuCanvas.m_font.dialogTop.getWidth() / 2, 70, MenuCanvas.m_font.dialogTop.getWidth(), 65);
                graphics.drawImage(tEngine.drawSurface, 0, 0, 0);
                graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
                MenuCanvas cfr_ignored_3 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.drawText(this.game.app.gameTxtData[4][0], graphics, -1, 75, 145, false, false, false, true);
                break;
            }
            case 0: {
                MenuCanvas cfr_ignored_4 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.setFont(0);
                MenuCanvas cfr_ignored_5 = this.game.app.canvas.g_menu;
                MenuCanvas cfr_ignored_6 = this.game.app.canvas.g_menu;
                graphics.setClip(this.game.SCREEN_WIDTH / 2 - MenuCanvas.m_font.dialogTop.getWidth() / 2, 70, MenuCanvas.m_font.dialogTop.getWidth(), 85);
                graphics.drawImage(tEngine.drawSurface, 0, 0, 0);
                graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
                MenuCanvas cfr_ignored_7 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.m_maxlines = 8;
                MenuCanvas cfr_ignored_8 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.m_scroll = this.tipscroll;
                MenuCanvas cfr_ignored_9 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.drawText(Game.m_CurrHole3dData.tip, graphics, -1, 75, 145, false, false, false, true);
                MenuCanvas cfr_ignored_10 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.m_scroll = 0;
                break;
            }
            case 7: {
                if (this.clipInfo) {
                    graphics.setClip(this.game.SCREEN_WIDTH / 2 - 30, 35, 60, 20);
                    graphics.drawImage(tEngine.drawSurface, 0, 0, 0);
                    graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
                    this.clipInfo = false;
                }
                this.game.player1.ball.drawBG(graphics, tEngine.drawSurface);
                MenuCanvas cfr_ignored_11 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.setFont(0);
                if (!this.game.oob) {
                    MenuCanvas cfr_ignored_12 = this.game.app.canvas.g_menu;
                    MenuCanvas.m_font.drawText(this.game.MtoY(this.fdist), graphics, -1, 40, 172, false, false, false, false);
                }
                MenuCanvas cfr_ignored_13 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.drawText(this.feedback1, graphics, -1, 50, 172, false, false, false, false);
                this.game.app.canvas.gamedata.trophies.drawTrophy(graphics);
                if (this.init) break;
                this.game.player1.ball.draw(graphics);
                break;
            }
            case 1: {
                if (this.clipInfo) {
                    graphics.setClip(0, 65, this.game.SCREEN_WIDTH, 100);
                    graphics.drawImage(tEngine.drawSurface, 0, 0, 0);
                    graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
                    this.clipInfo = false;
                }
                this.target.drawBG(graphics, tEngine.drawSurface);
                this.game.player1.ball.drawBG(graphics, tEngine.drawSurface);
                this.golfer.drawBG(graphics, tEngine.drawSurface);
                if (Mathlib.toInt(this.game.player1.holeDist) > 100) {
                    this.drawHoverFlag(graphics);
                }
                this.game.player1.ball.draw(graphics);
                this.golfer.draw(graphics);
                this.target.draw(graphics);
                break;
            }
            case 2: {
                this.target.drawBG(graphics, tEngine.drawSurface);
                this.target.draw(graphics);
                break;
            }
            case 3: {
                if (this.clipInfo) {
                    this.game.target.drawBG(graphics, tEngine.drawSurface);
                    MenuCanvas cfr_ignored_14 = this.game.app.canvas.g_menu;
                    MenuCanvas cfr_ignored_15 = this.game.app.canvas.g_menu;
                    graphics.setClip(this.game.SCREEN_WIDTH - MenuCanvas.m_font.dialogTop.getWidth() / 2, 80, MenuCanvas.m_font.dialogTop.getWidth(), 90);
                    graphics.drawImage(tEngine.drawSurface, 0, 0, 0);
                    graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
                    graphics.setClip(this.hoverx - this.hoverFlag.getWidth() / 2, this.hovery - this.hoverFlag.getHeight() - 5, this.hoverx + this.hoverFlag.getWidth() / 2, this.hovery + 10);
                    graphics.drawImage(tEngine.drawSurface, 0, 0, 0);
                    graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
                    this.clipInfo = false;
                }
            }
            default: {
                if (this.game.player1.gameArea == 0) {
                    this.game.player1.ball.drawBG(graphics, tEngine.drawSurface);
                    this.golfer.drawBG(graphics, tEngine.drawSurface);
                } else {
                    this.game.player1.ball.drawBG(graphics, tEngine.drawSurface);
                }
                this.game.player1.ball.draw(graphics);
                if (this.game.player1.gameArea == 0) {
                    this.golfer.draw(graphics);
                }
                if (this.gameState != 5) break;
                Ball cfr_ignored_16 = this.game.player1.ball;
                if (this.game.player1.ball.ballState == 0) break;
                MenuCanvas cfr_ignored_17 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.setFont(0);
                MenuCanvas cfr_ignored_18 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.drawText(String.valueOf(Mathlib.toInt(this.power * 100)) + " %", graphics, -1, 40, false, false, false);
                this.clipInfo = true;
            }
        }
        this.onTimer();
    }

    void drawHoverFlag(Graphics graphics) {
        tVertex3D tVertex3D2 = new tVertex3D();
        tProjVertex3D tProjVertex3D2 = new tProjVertex3D();
        tVertex3D2.x = tEngine.C3D_FP16To3DCoords(this.game.pin.x << 12);
        tVertex3D2.y = tEngine.C3D_FP16To3DCoords((this.game.pin.y << 12) + Mathlib.intToFP(10));
        tVertex3D2.z = tEngine.C3D_FP16To3DCoords(this.game.pin.z << 12);
        tEngine.getCameraProjectedInfo((byte)2, tVertex3D2, tProjVertex3D2);
        this.hoverx = tProjVertex3D2.s.x;
        this.hovery = tProjVertex3D2.s.y;
        graphics.setClip(this.hoverx - this.hoverFlag.getWidth() / 2, this.hovery - this.hoverFlag.getHeight() - 5, this.hoverx + this.hoverFlag.getWidth() / 2, this.hovery + 10);
        graphics.drawImage(tEngine.drawSurface, 0, 0, 0);
        graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
        graphics.drawImage(this.hoverFlag, this.hoverx, this.hovery - this.hoverOffset, 33);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean keyDown(int n) {
        if (this.keyClock.flagStarted) {
            this.keyUp(this.keyDown);
        }
        switch (this.gameState) {
            case -1: {
                switch (n) {
                    case -5: {
                        this.setState(0);
                        return true;
                    }
                }
                return true;
            }
            case 0: {
                switch (n) {
                    case -5: {
                        this.setState(1);
                        return true;
                    }
                    case -1: {
                        MenuCanvas cfr_ignored_0 = this.game.app.canvas.g_menu;
                        MenuCanvas.m_font.setFont(0);
                        MenuCanvas cfr_ignored_1 = this.game.app.canvas.g_menu;
                        MenuCanvas cfr_ignored_2 = this.game.app.canvas.g_menu;
                        MenuCanvas.m_font.lines = MenuCanvas.m_font.breakupText(Game.m_CurrHole3dData.tip, 145);
                        MenuCanvas cfr_ignored_3 = this.game.app.canvas.g_menu;
                        MenuCanvas.m_font.m_scroll = this.tipscroll;
                        MenuCanvas cfr_ignored_4 = this.game.app.canvas.g_menu;
                        MenuCanvas.m_font.scrollUp();
                        this.game.flagUpdateGU = true;
                        MenuCanvas cfr_ignored_5 = this.game.app.canvas.g_menu;
                        this.tipscroll = MenuCanvas.m_font.m_scroll;
                        MenuCanvas cfr_ignored_6 = this.game.app.canvas.g_menu;
                        MenuCanvas.m_font.m_scroll = 0;
                        return true;
                    }
                    case -2: {
                        MenuCanvas cfr_ignored_7 = this.game.app.canvas.g_menu;
                        MenuCanvas.m_font.setFont(0);
                        MenuCanvas cfr_ignored_8 = this.game.app.canvas.g_menu;
                        MenuCanvas cfr_ignored_9 = this.game.app.canvas.g_menu;
                        MenuCanvas.m_font.lines = MenuCanvas.m_font.breakupText(Game.m_CurrHole3dData.tip, 145);
                        MenuCanvas cfr_ignored_10 = this.game.app.canvas.g_menu;
                        MenuCanvas.m_font.m_scroll = this.tipscroll;
                        MenuCanvas cfr_ignored_11 = this.game.app.canvas.g_menu;
                        MenuCanvas.m_font.scrollDown();
                        this.game.flagUpdateGU = true;
                        MenuCanvas cfr_ignored_12 = this.game.app.canvas.g_menu;
                        this.tipscroll = MenuCanvas.m_font.m_scroll;
                        MenuCanvas cfr_ignored_13 = this.game.app.canvas.g_menu;
                        MenuCanvas.m_font.m_scroll = 0;
                        return true;
                    }
                }
                return true;
            }
            case 1: {
                switch (n) {
                    case 42: {
                        this.game.gameui.setClub(this.game.player1.ball.incClub());
                        this.target.resetPosition(this.dir);
                        this.golfer.updateScreen();
                        this.game.flagUpdateGU = true;
                        return true;
                    }
                    case 35: {
                        this.game.gameui.setClub(this.game.player1.ball.decClub());
                        this.target.resetPosition(this.dir);
                        this.golfer.updateScreen();
                        this.game.flagUpdateGU = true;
                        return true;
                    }
                    case -4: 
                    case -3: {
                        this.keyDown = n;
                        this.keyClock.start(this.KEY_TIME);
                        return true;
                    }
                    case 55: {
                        this.golfer.blueArc = true;
                        this.dir += -8;
                        this.skew = 18;
                        this.setState(3);
                        this.animClock.start(this.ANIM_TIME1);
                        return true;
                    }
                    case -5: 
                    case -2: {
                        this.setState(3);
                        this.animClock.start(this.ANIM_TIME1);
                        return true;
                    }
                    case 57: {
                        this.golfer.redArc = true;
                        this.dir += 8;
                        this.skew = -18;
                        this.setState(3);
                        this.animClock.start(this.ANIM_TIME1);
                        return true;
                    }
                    case -6: {
                        this.setState(2);
                    }
                }
                return true;
            }
            case 2: {
                switch (n) {
                    case -6: 
                    case -5: {
                        this.game.player1.gameArea = 0;
                        this.game.flagUpdateBG = true;
                        this.setState(1);
                        return true;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: {
                        this.keyDown = n;
                        this.keyClock.start(this.KEY_TIME);
                        return true;
                    }
                    case 42: {
                        this.game.gameui.setClub(this.game.player1.ball.incClub());
                        this.target.auto();
                        this.target.club = this.game.player1.ball.club;
                        this.target.swingDist = 0;
                        this.target.resetPosition(this.dir);
                        this.game.flagUpdateBG = true;
                        return true;
                    }
                    case 35: {
                        this.game.gameui.setClub(this.game.player1.ball.decClub());
                        this.target.auto();
                        this.target.club = this.game.player1.ball.club;
                        this.target.swingDist = 0;
                        this.target.resetPosition(this.dir);
                        this.game.flagUpdateBG = true;
                    }
                }
                return true;
            }
            case 4: {
                switch (n) {
                    case -2: {
                        this.setState(3);
                        return true;
                    }
                    case -5: 
                    case -1: 
                    case 49: 
                    case 51: {
                        this.setState(5);
                    }
                }
                return true;
            }
            case 6: {
                switch (n) {
                    case -2: {
                        if (this.hardReset) return true;
                        this.setState(3);
                    }
                }
            }
        }
        return true;
    }

    boolean keyUp(int n) {
        switch (this.gameState) {
            case 2: {
                switch (n) {
                    case -4: 
                    case -3: 
                    case -2: 
                    case -1: {
                        this.keyClock.cancel();
                        this.target.resetPosition(this.dir);
                        this.game.flagUpdateGU = true;
                    }
                }
                break;
            }
            case 1: {
                switch (n) {
                    case -4: 
                    case -3: {
                        this.keyClock.cancel();
                        this.target.resetPosition(this.dir);
                    }
                }
                break;
            }
            case 3: {
                switch (n) {
                    case -5: 
                    case -2: 
                    case 55: 
                    case 57: {
                        this.animClock.start(this.ANIM_TIME1);
                        this.setState(4);
                    }
                }
            }
        }
        return true;
    }

    public void genResult() {
        this.feedback1 = new String(this.game.getResult());
    }

    public void genFeedback() {
        this.feedback1 = "";
        int n = Mathlib.toInt(this.power * 100);
        if (n > 74 && this.game.oldTerrainInfo.type == 7) {
            this.feedback1 = this.game.app.gameTxtData[5][0];
        }
        if (n > 74 && this.game.oldTerrainInfo.type != 7) {
            this.feedback1 = this.game.app.gameTxtData[5][1];
        }
        if (n > 89 && this.game.oldTerrainInfo.type == 7) {
            this.feedback1 = this.game.app.gameTxtData[5][2];
        }
        if (n > 89 && this.game.oldTerrainInfo.type != 7) {
            this.feedback1 = this.game.app.gameTxtData[5][3];
        }
        if (n > 99 && this.game.oldTerrainInfo.type == 7) {
            this.feedback1 = this.game.app.gameTxtData[5][4];
        }
        if (n > 99 && this.game.oldTerrainInfo.type != 7) {
            this.feedback1 = this.game.app.gameTxtData[5][5];
        }
        if (this.game.player1.score[this.game.hole - 1] == 2 && this.game.newTerrainInfo.type == 1) {
            this.feedback1 = this.game.app.gameTxtData[5][6];
        }
        if (!(this.game.player1.score[this.game.hole - 1] >= this.game.app.canvas.gamedata.courses.par[this.game.app.canvas.g_game.course][this.game.hole - 1] || this.game.newTerrainInfo.type != 1 && this.game.newTerrainInfo.type != 2 || this.game.oldTerrainInfo.type != 3 && this.game.oldTerrainInfo.type != 4)) {
            this.feedback1 = this.game.app.gameTxtData[5][9];
        }
        if (this.game.player1.score[this.game.hole - 1] == 3 && this.game.newTerrainInfo.type == 1 && this.game.app.canvas.gamedata.courses.par[this.game.app.canvas.g_game.course][this.game.hole - 1] == 5 && this.game.oldTerrainInfo.type != 1) {
            this.feedback1 = this.game.app.gameTxtData[5][7];
        } else if (this.game.player1.score[this.game.hole - 1] == 3 && this.game.newTerrainInfo.type == 1 && this.game.app.canvas.gamedata.courses.par[this.game.app.canvas.g_game.course][this.game.hole - 1] == 5 && this.game.oldTerrainInfo.type == 1 && Mathlib.toInt(this.fdist) < 150) {
            this.feedback1 = this.game.app.gameTxtData[5][8];
        }
        if (this.game.newTerrainInfo.type == 4 && this.game.player1.lie < 60) {
            this.feedback1 = this.game.app.gameTxtData[5][10];
        } else if (this.game.newTerrainInfo.type == 4 && this.game.player1.lie > 60) {
            this.feedback1 = this.game.app.gameTxtData[5][11];
        }
        if (this.game.newTerrainInfo.type == 3 && this.game.player1.lie < 70) {
            this.feedback1 = this.game.app.gameTxtData[5][12];
        } else if (this.game.newTerrainInfo.type == 3 && this.game.player1.lie > 70) {
            this.feedback1 = this.game.app.gameTxtData[5][13];
        }
        if (this.game.newTerrainInfo.type == 2 && this.game.player1.score[this.game.hole - 1] < this.game.app.canvas.gamedata.courses.par[this.game.app.canvas.g_game.course][this.game.hole - 1]) {
            this.feedback1 = this.game.app.gameTxtData[5][14];
        }
        if (this.game.newTerrainInfo.type == 2 && this.game.player1.score[this.game.hole - 1] == 2) {
            this.feedback1 = this.game.app.gameTxtData[5][15];
        }
        if (this.game.oldTerrainInfo.type != 2 && this.game.player1.ball.club > 8 && this.fdist <= 60000) {
            this.feedback1 = this.game.app.gameTxtData[5][16];
        }
        if (this.game.water) {
            this.feedback1 = this.game.app.gameTxtData[5][17];
        }
        if (this.game.oob) {
            this.feedback1 = this.game.app.gameTxtData[5][18];
        }
        if (this.game.newTerrainInfo.type == 9) {
            this.feedback1 = this.game.app.gameTxtData[5][19];
        }
    }
}

