/*
 * Decompiled with CFR 0.152.
 */
import TW2006.renderer.tEngine;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;

public class GameData {
    static final byte PLAYMODES = 4;
    static final byte HOLES = 18;
    static final String shippedCourseName = "Pebble Beach";
    static final String shippedCourseInitials = "peb";
    GolfMIDlet app;
    Golfers golfers;
    Courses courses;
    Challenges challenges;
    Trophies trophies;
    PlayerStats playerstats;

    public GameData(GolfMIDlet golfMIDlet) {
        this.app = golfMIDlet;
        this.golfers = new Golfers();
        this.courses = new Courses();
        this.trophies = new Trophies(this.app);
        this.playerstats = new PlayerStats(this.app);
        this.challenges = new Challenges(this.courses);
    }

    class Trophies {
        GolfMIDlet app;
        boolean[] obtained;
        boolean[] legends;
        String[] names;
        String[] descriptions;
        boolean pinseeker = false;
        boolean[] drawIndex = new boolean[16];
        static final char NEXT_LINE = '\n';

        public Trophies(GolfMIDlet golfMIDlet) {
            this.app = golfMIDlet;
            this.obtained = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
            this.legends = new boolean[]{false, false, false, false, false};
            try {
                int n;
                int n2 = 0;
                byte[] byArray = null;
                RecordStore recordStore = RecordStore.openRecordStore((String)"TWTrophy", (boolean)false);
                byArray = recordStore.getRecord(1);
                for (n = 0; n < 16; ++n) {
                    this.obtained[n] = byArray[n] == 1;
                    this.drawIndex[n] = false;
                }
                while (n2 < 5) {
                    this.legends[n2] = byArray[n2 + n] == 1;
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void drawTrophy(Graphics graphics) {
            boolean bl = false;
            String string = this.app.gameTxtData[9][9];
            for (int i = 0; i < 16; ++i) {
                if (!this.drawIndex[i]) continue;
                string = string + "\n" + this.app.menuMiscTxtData[22][i + 1];
                bl = true;
            }
            if (bl) {
                MenuCanvas cfr_ignored_0 = this.app.canvas.g_menu;
                MenuCanvas.m_font.drawText(string, graphics, -1, 120, 170, false, false, false, false);
            }
        }

        void resetIndex() {
            for (int i = 0; i < 16; ++i) {
                this.drawIndex[i] = false;
            }
        }

        public void trophiesToRMS() {
            int n = 21;
            byte[] byArray = new byte[n];
            try {
                int n2 = 0;
                RecordStore recordStore = RecordStore.openRecordStore((String)"TWTrophy", (boolean)true);
                for (int i = 0; i < 16; ++i) {
                    byArray[i] = this.obtained[i] ? (byte)1 : 0;
                }
                while (n2 < 5) {
                    byArray[i + n2] = this.legends[n2] ? (byte)1 : 0;
                    ++n2;
                }
                try {
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                }
                catch (Exception exception) {
                    try {
                        recordStore.addRecord(byArray, 0, byArray.length);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void obtained(int n) {
            this.obtained[n] = true;
            this.drawIndex[n] = true;
            this.trophiesToRMS();
        }

        public void checkPuttShotTrophies() {
            if (!this.obtained[2] && this.app.canvas.g_game.gameui.num > 45) {
                this.obtained(2);
            }
        }

        public void checkLongShotTrophies() {
            if (!this.obtained[1] && this.pinseeker) {
                this.obtained(1);
            }
            if (!this.obtained[3] && Mathlib.toInt(this.app.canvas.g_game.shotDist) > 273 && this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] == 1) {
                this.obtained(3);
            }
            if (!this.obtained[4] && this.app.canvas.g_game.newTerrainInfo.type == 2 && this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] == 1 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 1] == 4) {
                this.obtained(4);
            }
        }

        public void checkHoleTrophies() {
            if (!this.obtained[5] && Mathlib.toInt(this.app.canvas.g_game.shotDist) < 54 && Mathlib.toInt(this.app.canvas.g_game.shotDist) > 27 && this.app.canvas.g_game.glong.init && this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] != 1) {
                this.obtained(5);
            }
            if (!this.obtained[0] && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 1] - this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] == 2 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 1] != 3) {
                this.obtained(0);
            }
            if (!this.obtained[10] && this.app.canvas.g_game.hole > 1 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 1] - this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] == 2 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 2] - this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 2] == 2 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 1] != 3 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 2] != 3) {
                this.obtained(10);
            }
            if (!this.obtained[8] && this.app.canvas.g_game.hole > 4 && this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] != 0 && this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 2] != 0 && this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 3] != 0 && this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 4] != 0 && this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 5] != 0 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 1] - this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] >= 1 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 2] - this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 2] >= 1 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 3] - this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 3] >= 1 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 4] - this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 4] >= 1 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 5] - this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 5] >= 1) {
                this.obtained(8);
            }
            if (!this.obtained[9] && this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] != 1 && this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 1] - this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] == 3) {
                this.obtained(9);
            }
            if (!this.obtained[11] && this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] == 1) {
                this.obtained(11);
            }
        }

        public void checkRoundTrophies() {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < 18; ++i) {
                if (this.app.canvas.g_game.player1.score[i] == 1) {
                    ++n5;
                }
                if (this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][i] - this.app.canvas.g_game.player1.score[i] == 1) {
                    ++n4;
                }
                if (this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][i] - this.app.canvas.g_game.player1.score[i] == 2) {
                    ++n2;
                }
                if (this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][i] - this.app.canvas.g_game.player1.score[i] == 3) {
                    ++n;
                }
                if (this.app.canvas.g_game.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][i] - this.app.canvas.g_game.player1.score[i] == -1) {
                    ++n3;
                }
                n6 += this.app.canvas.g_game.player1.score[i];
            }
            if (!this.obtained[6] && n3 == 0) {
                this.obtained(6);
            }
            if (!this.obtained[12] && n4 + n2 + n >= 10) {
                this.obtained(12);
            }
            if (!this.obtained[7] && n6 < 60) {
                this.obtained(7);
            }
            if (!this.obtained[13] && n2 >= 4) {
                this.obtained(13);
            }
            if (!this.obtained[14] && n5 >= 2) {
                this.obtained(14);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void checkLegendTrophies() {
            block4: {
                block3: {
                    block2: {
                        if (!GolfMIDlet.NETWORK_ON || this.obtained[15] || !this.legends[0] || !this.legends[1] || !this.legends[2] || !this.legends[3]) break block2;
                        if (this.legends[4]) break block3;
                    }
                    if (GolfMIDlet.NETWORK_ON || this.obtained[15] || !this.legends[0]) break block4;
                }
                this.obtained(15);
                return;
            }
            this.trophiesToRMS();
        }
    }

    class PlayerStats {
        GolfMIDlet app;
        static final byte HOLES_PLAYED = 0;
        static final byte CHALLENGES_WON = 1;
        static final byte BEST_ROUND = 2;
        static final byte HOLES_IN_ONE = 3;
        static final byte BIRDIES = 4;
        static final byte EAGLES = 5;
        static final byte DBL_EAGLES = 6;
        static final byte LONGEST_PUTT = 7;
        static final byte LONGEST_DRIVE = 8;
        int[] stat;
        int num_stats = 9;

        public PlayerStats(GolfMIDlet golfMIDlet) {
            this.app = golfMIDlet;
            this.stat = new int[this.num_stats];
            for (int i = 0; i < this.num_stats; ++i) {
                this.stat[i] = 0;
            }
            this.statsFromRMS();
        }

        public void statsFromRMS() {
            int n = 0;
            try {
                byte[] byArray = null;
                RecordStore recordStore = RecordStore.openRecordStore((String)"TWStats", (boolean)false);
                byArray = recordStore.getRecord(1);
                for (int i = 0; i < this.num_stats; ++i) {
                    int n2 = 0;
                    int n3 = 24;
                    for (int j = 0; j < 4; ++j) {
                        n2 = byArray[n++] & 0xFF;
                        int n4 = i;
                        this.stat[n4] = this.stat[n4] + (n2 <<= n3);
                        n3 -= 8;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void statsToRMS() {
            int n = 0;
            byte[] byArray = new byte[this.num_stats * 4];
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)"TWStats", (boolean)true);
                for (int i = 0; i < this.num_stats; ++i) {
                    int n2 = 24;
                    for (int j = 0; j < 4; ++j) {
                        byArray[n++] = (byte)(this.stat[i] >> n2 & 0xFF);
                        n2 -= 8;
                    }
                }
                try {
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                }
                catch (Exception exception) {
                    try {
                        recordStore.addRecord(byArray, 0, byArray.length);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void checkBestScore(int n) {
            if (n < this.stat[2]) {
                this.stat[2] = n;
                this.statsToRMS();
            }
        }

        public void checkLongShot(int n) {
            if (Mathlib.toInt(n) > this.stat[8]) {
                this.stat[8] = Mathlib.toInt(n);
                this.statsToRMS();
            }
        }

        public void checkLongPutt(int n) {
            if (Mathlib.toInt(n) > this.stat[7]) {
                this.stat[7] = Mathlib.toInt(n);
                this.statsToRMS();
            }
        }

        public void checkScores() {
            if (this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] != 0) {
                if (this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] == 1) {
                    this.stat[3] = this.stat[3] + 1;
                } else if (this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] - this.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 1] == -1) {
                    this.stat[4] = this.stat[4] + 1;
                } else if (this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] - this.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 1] == -2) {
                    this.stat[5] = this.stat[5] + 1;
                } else if (this.app.canvas.g_game.player1.score[this.app.canvas.g_game.hole - 1] - this.app.canvas.gamedata.courses.par[this.app.canvas.g_game.course][this.app.canvas.g_game.hole - 1] == -3) {
                    this.stat[6] = this.stat[6] + 1;
                }
            }
            this.statsToRMS();
        }
    }

    class Courses {
        static final int PEBBLE = 0;
        static final int BAY = 1;
        static final int SHERWOOD = 2;
        static final int SAWGRASS = 3;
        static final int SCOTTSDALE = 4;
        int num_courses = 5;
        String[] names = new String[]{"Pebble Beach Golf Links", "Bay Hill Club", "Sherwood Country Club", "TPC at Sawgrass", "TPC at Scottsdale"};
        int[][] dists;
        byte[][] par;

        public Courses() {
            this.loadCourses();
        }

        public void loadCourses() {
            int n;
            this.par = new byte[this.num_courses][18];
            this.dists = new int[this.num_courses][18];
            for (n = 0; n < this.num_courses; ++n) {
                tEngine.loadCRS(GolfMIDlet.translateFilename(this.names[n] + ".crs"));
                for (int i = 0; i < 18; ++i) {
                    this.par[n][i] = tEngine.par[i];
                    this.dists[n][i] = tEngine.dist[i];
                }
            }
            GolfMIDlet cfr_ignored_0 = GameData.this.app;
            if (GolfMIDlet.NETWORK_ON) {
                tEngine.loadCRS(GolfMIDlet.translateFilename("peb.crs"));
            } else {
                tEngine.loadCRS(GolfMIDlet.translateFilename("peb2.crs"));
            }
            for (n = 0; n < 18; ++n) {
                this.par[0][n] = tEngine.par[n];
                this.dists[0][n] = tEngine.dist[n];
            }
        }
    }

    class Golfers {
        static final int WOODS = 0;
        static final int PALMER = 1;
        static final int NICKLAUS = 2;
        static final int DALY = 3;
        static final int SINGH = 4;
        String[] names = new String[]{"Tiger Woods", "Arnold Palmer", "Jack Nicklaus", "John Daly", "Vijay Singh"};
        int num_golfers = 5;
    }

    class Challenges {
        int[] courses;
        int[] golfers;
        int num_challenges = 5;
        int num_sub_challenges = 4;
        boolean[] chalNull;
        String[][] descrips;
        CInfo[][] cinfo;
        Courses course;

        public Challenges(Courses courses) {
            this.course = courses;
            this.courses = new int[]{0, 1, 2, 3, 4};
            this.golfers = new int[]{3, 4, 1, 0, 2};
            this.chalNull = new boolean[this.num_challenges];
            this.cinfo = new CInfo[this.num_challenges][this.num_sub_challenges];
            this.reloadChallenges();
        }

        public void reloadChallenges() {
            int n;
            for (n = 0; n < this.num_challenges; ++n) {
                for (int i = 0; i < 4; ++i) {
                    this.cinfo[n][i] = new CInfo();
                    this.cinfo[n][i].holes = new byte[3];
                    this.cinfo[n][i].ballx = new int[3];
                    this.cinfo[n][i].ballz = new int[3];
                }
            }
            this.descrips = new String[this.num_challenges][4];
            GolfMIDlet cfr_ignored_0 = GameData.this.app;
            if (GolfMIDlet.NETWORK_ON) {
                tEngine.loadCRS(GolfMIDlet.translateFilename("peb.crs"));
            } else {
                tEngine.loadCRS(GolfMIDlet.translateFilename("peb2.crs"));
            }
            this.chalNull[0] = false;
            this.loadChallengesInfo(0);
            for (n = 1; n < this.num_challenges; ++n) {
                tEngine.loadCRS(GolfMIDlet.translateFilename(this.course.names[this.courses[n]] + ".crs"));
                if (tEngine.chgType[0] == 0) {
                    this.chalNull[n] = true;
                    continue;
                }
                this.loadChallengesInfo(n);
                this.chalNull[n] = false;
            }
        }

        public void loadChallengesInfo(int n) {
            for (int i = 0; i < 4; ++i) {
                switch (tEngine.chgType[i]) {
                    case 1: {
                        int n2;
                        for (n2 = 0; n2 < 3; ++n2) {
                            this.cinfo[n][i].holes[n2] = tEngine.chgHoles[i][n2];
                            this.cinfo[n][i].ballx[n2] = -1;
                            this.cinfo[n][i].ballz[n2] = -1;
                        }
                        break;
                    }
                    case 2: {
                        int n2;
                        for (n2 = 0; n2 < 3; ++n2) {
                            this.cinfo[n][i].holes[n2] = tEngine.chgHoles[i][n2];
                            this.cinfo[n][i].ballx[n2] = tEngine.chgBallX[i][n2];
                            this.cinfo[n][i].ballz[n2] = tEngine.chgBallZ[i][n2];
                        }
                        break;
                    }
                    case 3: {
                        int n2;
                        for (n2 = 0; n2 < 3; ++n2) {
                            this.cinfo[n][i].ballx[n2] = -1;
                            this.cinfo[n][i].ballz[n2] = -1;
                        }
                        this.cinfo[n][i].holes[0] = -2;
                        break;
                    }
                    case 4: {
                        int n2;
                        for (n2 = 0; n2 < 3; ++n2) {
                            this.cinfo[n][i].ballx[n2] = -1;
                            this.cinfo[n][i].ballz[n2] = -1;
                        }
                        this.cinfo[n][i].holes[0] = -1;
                    }
                }
                this.cinfo[n][i].stroke = tEngine.chgVicCond1[i];
                this.descrips[n][i] = tEngine.chgText[i];
            }
        }

        class CInfo {
            byte[] holes;
            int[] ballx;
            int[] ballz;
            int stroke;

            CInfo() {
            }
        }
    }
}

