/*
 * Decompiled with CFR 0.152.
 */
import TW2006.renderer.tEngine;
import TW2006.renderer.tObject3DInfo;
import javax.microedition.lcdui.Graphics;

public class GamePutt {
    static final byte STATE_INIT = 0;
    static final byte STATE_MOVECURSOR = 1;
    static final byte STATE_READY = 2;
    static final byte STATE_BACKSWING = 3;
    static final byte STATE_SWINGPAUSE = 4;
    static final byte STATE_FORESWING = 5;
    static final byte STATE_RESET = 6;
    static final byte STATE_CAMDELAY = 8;
    static final byte STATE_DONE = 9;
    byte gameState = 0;
    Game game;
    Target target;
    Golfer golfer;
    Clock ballClock;
    Clock keyClock;
    Clock delayClock1;
    Clock delayClock2;
    Clock animClock;
    Clock camClock;
    int BALL_TIME = 55;
    int ANIM_TIME = 80;
    int KEY_TIME = 35;
    int keyDown;
    int dir;
    int dist;
    int leftright = 0;
    int longshort = 0;
    String result;
    String feedback;
    int tempHoleDist;
    int endAnim;
    long backSwingTime;
    long backSwingStop;
    long backSwingStart;
    long backSwingLength = 1000L;

    public GamePutt(Game game, Golfer golfer, Target target) {
        this.game = game;
        this.golfer = golfer;
        this.target = target;
        this.ballClock = new Clock();
        this.animClock = new Clock();
        this.keyClock = new Clock();
        this.delayClock1 = new Clock();
        this.delayClock2 = new Clock();
        this.camClock = new Clock();
    }

    public void reset() {
        this.dir = 0;
        this.ballClock.cancel();
        this.animClock.cancel();
        this.backSwingStop = 0L;
        this.backSwingTime = 0L;
        if (this.game.player1.ball.worldX > this.game.pin.x << 12 && this.game.player1.ball.worldZ > this.game.pin.z << 12) {
            this.game.quad = 1;
        } else if (this.game.player1.ball.worldX > this.game.pin.x << 12 && this.game.player1.ball.worldZ < this.game.pin.z << 12) {
            this.game.quad = 2;
        } else if (this.game.player1.ball.worldX < this.game.pin.x << 12 && this.game.player1.ball.worldZ < this.game.pin.z << 12) {
            this.game.quad = 3;
        } else if (this.game.player1.ball.worldX < this.game.pin.x << 12 && this.game.player1.ball.worldZ > this.game.pin.z << 12) {
            this.game.quad = 4;
        }
        this.target.resetHole();
        this.caddyTip();
        if (!this.game.doGimme) {
            this.setState((byte)1);
        } else {
            this.setState((byte)3);
            this.animClock.start(this.ANIM_TIME);
        }
    }

    public void resetAnim() {
        this.ballClock.cancel();
        this.animClock.cancel();
        this.backSwingStop = 0L;
        this.backSwingTime = 0L;
        this.setState((byte)2);
    }

    public void cancelClocks() {
        this.ballClock.cancel();
        this.keyClock.cancel();
        this.delayClock1.cancel();
        this.delayClock2.cancel();
        this.animClock.cancel();
        this.camClock.cancel();
    }

    public void posDetails() {
        int n = this.game.player1.ball.worldX - this.game.target.worldX;
        int n2 = this.game.player1.ball.worldZ - this.game.target.worldZ;
        this.dist = Mathlib.Mul(n, n) + Mathlib.Mul(n2, n2);
        if (this.dist != 0) {
            this.dist = Mathlib.Sqrt(this.dist);
        }
        this.game.flagUpdateGU = true;
    }

    public void caddyTip() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl = false;
        int n6 = 1000000;
        int n7 = 100000;
        int n8 = 0;
        int n9 = 0;
        int n10 = this.game.player1.ball.worldX;
        int n11 = this.game.player1.ball.worldY;
        int n12 = this.game.player1.ball.worldZ;
        int n13 = this.game.target.worldX;
        int n14 = this.game.target.worldZ;
        int n15 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        do {
            int n16;
            n10 = this.game.player1.ball.worldX;
            n11 = this.game.player1.ball.worldY;
            n12 = this.game.player1.ball.worldZ;
            n5 = Mathlib.Abs(Mathlib.FP16toFP12(Mathlib.Abs(n10) - Mathlib.Abs(n13)));
            n4 = Mathlib.Abs(Mathlib.FP16toFP12(Mathlib.Abs(n12) - Mathlib.Abs(n14)));
            n3 = Mathlib.FP12toFP16(Mathlib.Sqrt12(Mathlib.Mul12(n5, n5) + Mathlib.Mul12(n4, n4)));
            n5 = n10 - n13;
            n4 = n12 - n14;
            Ball cfr_ignored_0 = this.game.player1.ball;
            Ball cfr_ignored_1 = this.game.player1.ball;
            n2 = Mathlib.Sqrt(Mathlib.Div(Mathlib.Mul(n3, Ball.TWO), 19000));
            Ball cfr_ignored_2 = this.game.player1.ball;
            n = Mathlib.Mul(n2, 19000);
            int n17 = -Mathlib.Mul(n, Mathlib.Div(n5, n3));
            int n18 = -Mathlib.Mul(n, Mathlib.Div(n4, n3));
            Ball cfr_ignored_3 = this.game.player1.ball;
            int n19 = Mathlib.Mul(19000, Mathlib.Div(n5, n3));
            Ball cfr_ignored_4 = this.game.player1.ball;
            int n20 = Mathlib.Mul(19000, Mathlib.Div(n4, n3));
            int n21 = n10;
            int n22 = n12;
            n8 = 0;
            n9 = 0;
            tObject3DInfo tObject3DInfo2 = new tObject3DInfo();
            for (int i = 0; i < n2; i += 8000) {
                tObject3DInfo2.x = tEngine.C3D_FP16To3DCoords(n10);
                tObject3DInfo2.z = tEngine.C3D_FP16To3DCoords(n12);
                tEngine.getTerrainInfo(Game.m_CurrHole3dData, tObject3DInfo2);
                if (this.game.player1.holeDist > 40000) {
                    n8 += Mathlib.Sin(Mathlib.Div(Mathlib.Mul(tObject3DInfo2.normal.x * 11, 205887), Ball.ONEEIGHTY));
                    n9 += Mathlib.Sin(Mathlib.Div(Mathlib.Mul(tObject3DInfo2.normal.z * 11, 205887), Ball.ONEEIGHTY));
                } else {
                    n8 += Mathlib.Sin(Mathlib.Div(Mathlib.Mul(tObject3DInfo2.normal.x, 205887), Ball.ONEEIGHTY));
                    n9 += Mathlib.Sin(Mathlib.Div(Mathlib.Mul(tObject3DInfo2.normal.z, 205887), Ball.ONEEIGHTY));
                }
                n12 = n22 + n9 + Mathlib.Mul(Mathlib.Mul(Mathlib.Mul(i, i), n20), 32768) + Mathlib.Mul(n18, i);
                n10 = n21 + n8 + Mathlib.Mul(Mathlib.Mul(Mathlib.Mul(i, i), n19), 32768) + Mathlib.Mul(n17, i);
            }
            n7 = Mathlib.FP16Dist(n10, n12, this.game.pin.x << 12, this.game.pin.z << 12);
            if (n7 < 7000) break;
            int n23 = Mathlib.Abs(Mathlib.Abs(n10) - Mathlib.Abs(this.game.pin.x << 12));
            if (n23 > (n16 = Mathlib.Abs(Mathlib.Abs(n12) - Mathlib.Abs(this.game.pin.z << 12)))) {
                if (n10 < this.game.pin.x << 12) {
                    n13 += Mathlib.Div(n23, Ball.TWO);
                    continue;
                }
                n13 -= Mathlib.Div(n23, Ball.TWO);
                continue;
            }
            if (n12 < this.game.pin.z << 12) {
                n14 += Mathlib.Div(n16, Ball.TWO);
                continue;
            }
            n14 -= Mathlib.Div(n16, Ball.TWO);
        } while (++n15 < 20);
        n5 = Mathlib.FPDist(this.game.player1.ball.worldX, this.game.player1.ball.worldZ, n13, n14);
        n4 = Mathlib.FPDist(this.game.player1.ball.worldX, this.game.player1.ball.worldZ, this.game.pin.x << 12, this.game.pin.z << 12);
        n3 = Mathlib.Div(Mathlib.Mul(Ball.ONEEIGHTY, Mathlib.ArcSin(Mathlib.Div(Mathlib.Abs(this.game.player1.ball.worldZ - n14), n5))), 205887);
        n2 = Mathlib.intToFP(90) - Mathlib.Div(Mathlib.Mul(Ball.ONEEIGHTY, Mathlib.ArcSin(Mathlib.Div(Mathlib.Abs(this.game.player1.ball.worldZ - (this.game.pin.z << 12)), n4))), 205887);
        n = Mathlib.intToFP(90) - n3 - n2;
        n = Mathlib.Div(Mathlib.Mul(n, 205887), Ball.ONEEIGHTY);
        this.leftright = Mathlib.Mul(n5, Mathlib.Sin(n));
        this.longshort = -Mathlib.Mul(n5, Mathlib.Cos(n)) + n4;
        if (this.game.quad == 1 || this.game.quad == 3) {
            this.leftright = -this.leftright;
        }
        this.longshort -= 10000;
        if (this.leftright > 0x140000) {
            this.leftright = 0x140000;
        }
        if (this.longshort > 0x140000) {
            this.longshort = 0x140000;
        }
        this.game.gameui.setRightLeft(this.leftright);
        this.game.gameui.setShortLong(this.longshort);
    }

    public void setState(byte by) {
        byte by2 = this.gameState;
        this.gameState = by;
        this.game.flagUpdateGU = true;
        switch (this.gameState) {
            case 1: {
                this.game.gameui.leftsoft = this.game.app.gameTxtData[3][1];
                this.golfer.update = true;
                this.game.flagUpdateBG = true;
                this.game.player1.ball.oldScreenX = 0;
                break;
            }
            case 2: {
                this.game.gameui.leftsoft = this.game.app.gameTxtData[3][0];
                this.golfer.updateScreen();
                if (by2 != 6) {
                    this.game.flagUpdateBG = true;
                }
                this.game.player1.ball.oldScreenX = 0;
                break;
            }
            case 3: {
                this.backSwingStart = System.currentTimeMillis();
                break;
            }
            case 4: {
                this.backSwingTime = System.currentTimeMillis();
                if (this.golfer.frame >= 2) break;
                this.setState((byte)6);
                break;
            }
            case 5: {
                int n = this.game.hole - 1;
                this.game.player1.score[n] = (byte)(this.game.player1.score[n] + 1);
                this.golfer.tweakPuttFrames();
                break;
            }
            case 8: {
                this.camClock.start(1500L);
                break;
            }
            case 6: {
                this.animClock.start(this.ANIM_TIME);
                break;
            }
            case 9: {
                this.game.gameui.setRightLeft(0);
                this.game.gameui.setShortLong(0);
                this.result = new String(this.game.getResult());
                this.feedback = this.game.gameType != 1 ? new String(this.genFeedback()) : "";
                this.game.app.canvas.gamedata.trophies.checkPuttShotTrophies();
                if (this.game.gameType != 1) {
                    this.game.app.canvas.gamedata.playerstats.checkLongPutt(this.tempHoleDist);
                }
                GameLong cfr_ignored_0 = this.game.glong;
                this.game.glong.setState(0);
                this.delayClock1.start(2000L);
            }
        }
    }

    boolean checkUpdate() {
        if (this.keyClock.flagStarted) {
            return true;
        }
        if (this.ballClock.flagStarted) {
            return true;
        }
        if (this.animClock.flagStarted) {
            return true;
        }
        if (this.camClock.flagStarted) {
            return true;
        }
        if (this.delayClock1.flagStarted) {
            return true;
        }
        return this.delayClock2.flagStarted;
    }

    public void onTimer() {
        if (this.ballClock.update()) {
            long l = System.currentTimeMillis();
            if (this.game.player1.ball.rollBall(l)) {
                this.ballClock.start(this.BALL_TIME);
            } else {
                this.tempHoleDist = this.game.player1.holeDist;
                if (this.game.checkHole() || this.game.player1.score[this.game.hole - 1] > 11) {
                    this.game.app.canvas.gamedata.trophies.checkHoleTrophies();
                    if (this.game.hole == this.game.resHole2) {
                        if (this.game.resHole1 == 1 && this.game.resHole2 == 18) {
                            if (this.game.gameType != 1) {
                                this.game.app.canvas.gamedata.trophies.checkRoundTrophies();
                            }
                        }
                        if (this.game.gameType == 1) {
                            int n = 0;
                            int n2 = 0;
                            for (int i = 0; i < 18; ++i) {
                                n2 += this.game.player1.score[i];
                                n += this.game.player2.score[i];
                            }
                            if (n2 < n) {
                                this.game.app.canvas.gamedata.trophies.legends[this.game.challenge] = true;
                                this.game.app.canvas.gamedata.trophies.checkLegendTrophies();
                            }
                        }
                    }
                    if (this.game.gameType != 1) {
                        this.game.app.canvas.gamedata.playerstats.stat[0] = this.game.app.canvas.gamedata.playerstats.stat[0] + 1;
                    }
                    this.setState((byte)9);
                } else {
                    this.setState((byte)8);
                }
            }
        }
        if (this.animClock.update()) {
            switch (this.gameState) {
                case 6: {
                    if (this.golfer.frame > 0) {
                        --this.golfer.frame;
                    }
                    this.animClock.start(this.ANIM_TIME);
                    if (this.golfer.frame != 0) break;
                    this.resetAnim();
                    break;
                }
                case 4: {
                    this.animClock.start(this.ANIM_TIME);
                    if (this.backSwingTime + 400L >= System.currentTimeMillis()) break;
                    this.setState((byte)6);
                    break;
                }
                case 3: {
                    if (this.golfer.frame < this.golfer.puttBack) {
                        ++this.golfer.frame;
                        if (this.golfer.frame == this.golfer.puttBack) {
                            this.backSwingStop = System.currentTimeMillis();
                            if (this.game.doGimme) {
                                this.setState((byte)5);
                            }
                        }
                    }
                    if (this.backSwingLength + this.backSwingStart + 400L < System.currentTimeMillis()) {
                        this.setState((byte)6);
                    }
                    this.animClock.start(this.ANIM_TIME);
                    break;
                }
                case 5: {
                    if (this.golfer.frame < this.golfer.numFrames - 1) {
                        ++this.golfer.frame;
                    }
                    if (this.golfer.frame == this.golfer.puttHit) {
                        this.ballClock.start(this.BALL_TIME);
                        GolfMIDlet cfr_ignored_0 = this.game.app;
                        this.game.app.playSound((byte)2);
                    }
                    this.animClock.start(this.ANIM_TIME);
                }
            }
        }
        if (this.keyClock.update()) {
            this.keyClock.start(this.KEY_TIME);
            switch (this.keyDown) {
                case -3: {
                    this.dir = this.target.targd > 750000 ? --this.dir : (this.target.targd > 500000 ? (this.dir -= 2) : (this.target.targd > 250000 ? (this.dir -= 3) : (this.dir -= 4)));
                    if (this.game.quad == 1 || this.game.quad == 3) {
                        if (this.dir >= -320) break;
                        this.dir += 360;
                        break;
                    }
                    if (this.dir >= -100) break;
                    this.dir += 360;
                    break;
                }
                case -1: {
                    if (this.game.yards) {
                        this.target.puttDist += 1966;
                        if (this.target.puttDist <= 0x320000 - this.game.player1.holeDist) break;
                        this.target.puttDist = 0x320000 - this.game.player1.holeDist;
                        break;
                    }
                    this.target.puttDist += 6554;
                    if (this.target.puttDist <= 0x320000 - this.game.player1.holeDist) break;
                    this.target.puttDist = 0x320000 - this.game.player1.holeDist;
                    break;
                }
                case -2: {
                    if (this.game.yards) {
                        this.target.puttDist -= 1966;
                        if (this.target.puttDist >= 0 - this.game.player1.holeDist + 1966) break;
                        this.target.puttDist = 0 - this.game.player1.holeDist + 1966;
                        break;
                    }
                    this.target.puttDist -= 6554;
                    if (this.target.puttDist >= 0 - this.game.player1.holeDist + 6554) break;
                    this.target.puttDist = 0 - this.game.player1.holeDist + 6554;
                    break;
                }
                case -4: {
                    this.dir = this.target.targd > 750000 ? ++this.dir : (this.target.targd > 500000 ? (this.dir += 2) : (this.target.targd > 250000 ? (this.dir += 3) : (this.dir += 4)));
                    if (this.game.quad == 1 || this.game.quad == 3) {
                        if (this.dir <= 100) break;
                        this.dir -= 360;
                        break;
                    }
                    if (this.dir <= 320) break;
                    this.dir -= 360;
                }
            }
            this.target.resetPosition(this.dir);
            this.golfer.updateScreen();
        }
        if (this.delayClock1.update()) {
            this.delayClock2.start(750L);
        }
        if (this.delayClock2.update()) {
            this.setState((byte)0);
            this.game.card.init(0);
        }
        if (this.camClock.update()) {
            this.game.doReset = 1;
            this.game.flagUpdateGU = true;
        }
    }

    public void render(Graphics graphics) {
        if (this.game.card.active) {
            return;
        }
        graphics.setColor(-16777216);
        if (this.gameState == 2 && this.game.doGimme) {
            this.setState((byte)3);
            this.animClock.start(this.ANIM_TIME);
        }
        switch (this.gameState) {
            case 1: {
                this.game.player1.ball.drawBG(graphics, tEngine.drawSurface);
                this.golfer.drawBG(graphics, tEngine.drawSurface);
                this.target.drawBG(graphics, tEngine.drawSurface);
                graphics.fillRoundRect(this.game.pinx - 3, this.game.piny - 3, 6, 6, 90, 90);
                this.game.player1.ball.draw(graphics);
                this.golfer.draw(graphics);
                this.target.draw(graphics);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.game.player1.ball.drawBG(graphics, tEngine.drawSurface);
                this.golfer.drawBG(graphics, tEngine.drawSurface);
                this.game.player1.ball.draw(graphics);
                this.golfer.draw(graphics);
                if (!this.game.doGimme) break;
                MenuCanvas cfr_ignored_0 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.setFont(0);
                MenuCanvas cfr_ignored_1 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.drawText(this.game.app.gameTxtData[8][12], graphics, -1, 45, 176, false, false, false, false);
                break;
            }
            case 8: {
                this.game.player1.ball.drawBG(graphics, tEngine.drawSurface);
                this.golfer.drawBG(graphics, tEngine.drawSurface);
                this.game.player1.ball.draw(graphics);
                this.golfer.draw(graphics);
                break;
            }
            case 9: {
                this.game.player1.ball.drawBG(graphics, tEngine.drawSurface);
                this.golfer.drawBG(graphics, tEngine.drawSurface);
                MenuCanvas cfr_ignored_2 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.setFont(0);
                this.golfer.draw(graphics);
                MenuCanvas cfr_ignored_3 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.setFont(0);
                MenuCanvas cfr_ignored_4 = this.game.app.canvas.g_menu;
                MenuCanvas.m_font.drawText(this.result + "\n" + this.feedback, graphics, -1, 55, 176, false, false, false, false);
                this.game.app.canvas.gamedata.trophies.drawTrophy(graphics);
            }
        }
        this.onTimer();
    }

    boolean keyDown(int n) {
        if (this.keyClock.flagStarted) {
            this.keyUp(this.keyDown);
        }
        if (!this.game.doGimme) {
            switch (this.gameState) {
                case 1: {
                    switch (n) {
                        case -6: 
                        case -5: {
                            this.setState((byte)2);
                            break;
                        }
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: {
                            this.keyDown = n;
                            this.keyClock.start(this.KEY_TIME);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (n) {
                        case -6: {
                            this.setState((byte)1);
                            break;
                        }
                        case -5: 
                        case -2: {
                            this.setState((byte)3);
                            this.animClock.start(this.ANIM_TIME);
                        }
                    }
                    break;
                }
                case 4: {
                    switch (n) {
                        case -5: 
                        case -1: {
                            this.setState((byte)5);
                        }
                    }
                }
            }
        }
        return true;
    }

    boolean keyUp(int n) {
        if (!this.game.doGimme) {
            switch (this.gameState) {
                case 1: {
                    switch (n) {
                        case -4: 
                        case -3: 
                        case -2: 
                        case -1: {
                            this.keyClock.cancel();
                            this.target.resetPosition(this.dir);
                            this.golfer.updateScreen();
                            this.game.flagUpdateGU = true;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (n) {
                        case -5: 
                        case -2: {
                            this.setState((byte)4);
                        }
                    }
                }
            }
        }
        return true;
    }

    public String genFeedback() {
        if (this.game.player1.score[this.game.hole - 1] == 12) {
            return "";
        }
        if (this.game.gameui.num > 60) {
            return this.game.app.gameTxtData[6][0];
        }
        if (this.game.gameui.num > 40) {
            return this.game.app.gameTxtData[6][1];
        }
        if (this.game.gameui.num > 20) {
            return this.game.app.gameTxtData[6][2];
        }
        if (this.game.gameui.num > 10) {
            return this.game.app.gameTxtData[6][3];
        }
        return "";
    }
}

