/*
 * Decompiled with CFR 0.152.
 */
import TW2006.renderer.tEngine;
import TW2006.renderer.tObject3DInfo;
import TW2006.renderer.tProjVertex3D;
import TW2006.renderer.tVertex3D;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Ball {
    static final int TWO = Mathlib.intToFP(2);
    static final int ONEEIGHTY = Mathlib.intToFP(180);
    static final int GRAVITY = 682253;
    static final int SHOT_REDUC = 68812;
    static final int ONEHALF = 32768;
    static final int COS45 = Mathlib.Cos(Mathlib.FP16toRad(Mathlib.intToFP(45)));
    static final int NORMFACTOR = 11;
    static final int GREENDECEL = 19000;
    static final int FAIRDECEL = 100000;
    static final int ROUGHDECEL = 140000;
    static final int[] cloft = new int[]{11, 15, 18, 21, 24, 27, 31, 35, 39, 43, 48, 53, 0};
    static final int[] cdist = new int[]{275, 247, 192, 182, 173, 164, 156, 149, 139, 132, 124, 98, 0};
    static final int[] cloft2 = new int[]{18, 21, 24, 27, 31, 35, 39, 43, 48, 53, 0};
    static final int[] cdist2 = new int[]{151, 138, 124, 110, 97, 83, 69, 55, 42, 28, 0};
    static final byte FULL = 0;
    static final byte APPR = 1;
    byte table = 0;
    byte club = 0;
    int screenX;
    int screenY;
    int shadowX;
    int shadowY;
    int shadow;
    int oldScreenX;
    int oldScreenY;
    int oldShadowX;
    int oldShadowY;
    int worldX;
    int worldY;
    int worldZ;
    int rollDist = 0;
    private int windCount = 0;
    int t;
    int vx;
    int vy;
    int vz;
    int ax;
    int bx;
    int az;
    int bz;
    int dir;
    int xwind;
    int zwind;
    int windOffsetx;
    int windOffsetz;
    int disti;
    int askew;
    static final byte BALL_IDLE = 0;
    static final byte BALL_AIR = 1;
    static final byte BALL_BOUNCE = 2;
    static final byte BALL_ROLL = 3;
    byte ballState = 0;
    static final byte BALL_DIST0 = -1;
    static final byte BALL_DIST1 = 0;
    static final byte BALL_DIST2 = 1;
    byte ballType = (byte)-1;
    long startTime;
    long bstartTime;
    long millis;
    Game game;
    int endDist = 0;
    int origXa;
    int origYa;
    int origZa;
    int origXb;
    int origYb;
    int origZb;
    int origXc;
    int origYc;
    int origZc;
    int puttX;
    int puttZ;
    int pChangeX;
    int pChangeZ;
    tVertex3D normal;
    tObject3DInfo terrainInfo = new tObject3DInfo();
    boolean landCam = false;
    boolean puttCam = false;
    boolean puttCamDone = false;
    boolean viewChange = false;
    int changeTS = 0;
    int rights = 0;
    int lefts = 0;
    int ups = 0;
    int downs = 0;
    long oldTime = 0L;
    long pausedTime;

    public Ball(Game game) {
        this.game = game;
        this.oldScreenX = 0;
        this.oldScreenY = 0;
        this.oldShadowX = 0;
        this.oldShadowY = 0;
    }

    public void reset() {
        this.origXa = this.worldX;
        this.origZa = this.worldZ;
        this.origYa = this.worldY;
        this.origXb = this.worldX;
        this.origZb = this.worldZ;
        this.origYb = this.worldY;
        this.origXc = this.worldX;
        this.origZc = this.worldZ;
        this.origYc = this.worldY;
        this.puttZ = 0;
        this.puttX = 0;
        this.oldScreenX = 0;
        this.windCount = 0;
        this.ballType = (byte)-1;
        this.ballState = 0;
        this.windOffsetx = 0;
        this.windOffsetz = 0;
        this.landCam = false;
        this.pausedTime = 0L;
        this.oldTime = 0L;
        this.viewChange = false;
        this.changeTS = 0;
        this.pChangeZ = 0;
        this.pChangeX = 0;
    }

    public int incClub() {
        if (this.table == 0 && (this.club = (byte)(this.club + 1)) > 11) {
            this.club = 0;
        }
        if (this.table == 1 && (this.club = (byte)(this.club + 1)) > 9) {
            this.club = 0;
        }
        return this.club;
    }

    public int decClub() {
        if (this.table == 0 && (this.club = (byte)(this.club - 1)) < 0) {
            this.club = (byte)11;
        }
        if (this.table == 1 && (this.club = (byte)(this.club - 1)) < 0) {
            this.club = (byte)9;
        }
        return this.club;
    }

    public void calcWind(int n) {
        if (n < this.windCount) {
            return;
        }
        int n2 = Mathlib.Div(Mathlib.intToFP(this.game.windSpeed), 655360);
        int n3 = Mathlib.intToFP(-150);
        int n4 = Mathlib.FP16toRad(Mathlib.Mul(Mathlib.Div(Mathlib.intToFP(this.game.windDir), Mathlib.intToFP(32)), ONEEIGHTY * 2));
        this.xwind = -Mathlib.Mul(Mathlib.Mul(n2, Mathlib.Cos(n4)), Mathlib.Div(this.worldY - (this.terrainInfo.y << 12), n3));
        this.zwind = Mathlib.Mul(Mathlib.Mul(n2, Mathlib.Sin(n4)), Mathlib.Div(this.worldY - (this.terrainInfo.y << 12), n3));
        this.windOffsetx += this.xwind;
        this.windOffsetz += this.zwind;
        this.windCount += 20000;
    }

    public void calcHit(int n, int n2, int n3) {
        int n4 = 0;
        if (this.table == 0) {
            n4 = Mathlib.FP16toRad(Mathlib.intToFP(cloft[this.club]));
        } else if (this.table == 1) {
            n4 = Mathlib.FP16toRad(Mathlib.intToFP(cloft2[this.club]));
        }
        int n5 = 102943 - n4;
        this.askew = Mathlib.Mul(Mathlib.Mul(Mathlib.intToFP(n2), 205887), 364);
        if (this.table == 0) {
            this.disti = Mathlib.Mul(Mathlib.Mul(Mathlib.intToFP(cdist[this.club]), Mathlib.Div(Mathlib.intToFP(this.game.player1.lie), 6881200)), n);
        } else if (this.table == 1) {
            this.disti = Mathlib.Mul(Mathlib.Mul(Mathlib.intToFP(cdist2[this.club]), Mathlib.Div(Mathlib.intToFP(this.game.player1.lie), 6881200)), n);
        }
        this.dir = Mathlib.FP16toRad(Mathlib.intToFP(this.game.camAngle + n3));
        int n6 = Mathlib.Sqrt(Mathlib.Div(Mathlib.Mul(this.disti, 682253), Mathlib.Sin(Mathlib.Mul(n4, TWO))));
        this.vz = Mathlib.Mul(Mathlib.Mul(n6, Mathlib.Cos(n4)), Mathlib.Cos(this.dir));
        this.vx = Mathlib.Mul(Mathlib.Mul(n6, Mathlib.Cos(n4)), Mathlib.Sin(this.dir));
        if (this.askew != 0) {
            if (this.game.quad == 2) {
                this.askew = -this.askew;
            }
            this.bx = Mathlib.Div(Mathlib.Sqrt(Mathlib.Abs(Mathlib.Mul(this.vx, Mathlib.Sin(this.askew)))), 131072);
            this.bz = Mathlib.Div(Mathlib.Sqrt(Mathlib.Abs(Mathlib.Mul(this.vz, Mathlib.Sin(this.askew)))), 131072);
            switch (this.game.quad) {
                case 1: {
                    this.bx = -this.bx;
                    this.bz = -this.bz;
                    break;
                }
                case 2: {
                    this.bx = -this.bx;
                    break;
                }
                case 4: {
                    this.bz = -this.bz;
                }
            }
        }
        this.vy = Mathlib.Mul(n6, Mathlib.Sin(n4));
        this.t = Mathlib.Div(this.disti, Mathlib.Mul(n6, Mathlib.Cos(n4)));
        this.vz = Mathlib.Mul(this.vz, 97000);
        this.az = -Mathlib.Div(this.vz, Mathlib.Mul(98304, this.t));
        this.vx = Mathlib.Mul(this.vx, 97000);
        this.ax = -Mathlib.Div(this.vx, Mathlib.Mul(98304, this.t));
    }

    public boolean moveBall(long l) {
        if (this.ballState == 0) {
            this.startTime = System.currentTimeMillis();
            this.millis = Mathlib.toInt(Mathlib.Mul(this.t, Mathlib.intToFP(1000)));
            this.ballState = (byte)(this.ballState + 1);
            l -= this.startTime;
            this.origXa = this.worldX;
            this.origYa = this.worldY;
            this.origZa = this.worldZ;
            this.terrainInfo.x = tEngine.C3D_FP16To3DCoords(this.worldX);
            this.terrainInfo.z = tEngine.C3D_FP16To3DCoords(this.worldZ);
            tEngine.getTerrainInfo(Game.m_CurrHole3dData, this.terrainInfo);
        } else if (this.ballState == 1) {
            l -= this.startTime;
        }
        if (this.ballState == 1) {
            int n = Mathlib.Div(Mathlib.intToFP((int)(l - this.pausedTime)), Mathlib.intToFP(1000));
            this.calcWind(n);
            this.worldZ = this.origZa + Mathlib.Mul(this.vz + this.windOffsetz, n) + Mathlib.Mul(Mathlib.Mul(Mathlib.Mul(n, n), this.az), 32768) - Mathlib.Mul(Mathlib.Mul(Mathlib.Mul(n, n), this.bz), 32768);
            this.worldX = this.origXa + Mathlib.Mul(this.vx + this.windOffsetx, n) + Mathlib.Mul(Mathlib.Mul(Mathlib.Mul(n, n), this.ax), 32768) - Mathlib.Mul(Mathlib.Mul(Mathlib.Mul(n, n), this.bx), 32768);
            this.worldY = this.origYa + Mathlib.Mul(Mathlib.Mul(this.vy, n) - Mathlib.Div(Mathlib.Mul(682253, Mathlib.Mul(n, n)), TWO), Mathlib.intToFP(2));
            int n2 = Mathlib.FP16Dist(this.game.player1.ball.worldX, this.game.player1.ball.worldZ, this.game.pin.x << 12, this.game.pin.z << 12);
            if (n > this.t / 2) {
                if (this.checkTerrain()) {
                    if (this.terrainInfo.type == 4 || this.terrainInfo.type == 8 || this.terrainInfo.type == 0) {
                        this.worldY = this.terrainInfo.y << 12;
                        this.ballState = 0;
                        return false;
                    }
                    this.calcBounce();
                    this.ballState = (byte)2;
                }
                if (n2 <= 20000 && this.worldY - (this.terrainInfo.y << 12) < Mathlib.intToFP(3) && this.worldY - (this.terrainInfo.y << 12) > 0) {
                    this.game.app.canvas.gamedata.trophies.pinseeker = true;
                }
            }
            return true;
        }
        if (this.ballState == 2) {
            if (this.bounceBall(l - this.pausedTime)) {
                return true;
            }
            this.calcShotRoll();
            this.ballState = (byte)3;
            return true;
        }
        if (this.ballState == 3) {
            if (this.rollShotBall(l - this.pausedTime)) {
                return true;
            }
            this.ballState = 0;
            return false;
        }
        return true;
    }

    public void calcShotRoll() {
        int n = 0;
        this.pausedTime = 0L;
        this.origXc = this.worldX;
        this.origYc = this.worldY;
        this.origZc = this.worldZ;
        this.bstartTime = System.currentTimeMillis();
        int n2 = Mathlib.Angle(this.origXc, this.origZc, this.origXb, this.origZb, 0);
        int n3 = Mathlib.FP16Dist(this.worldX, this.worldZ, this.origXa, this.origZa);
        int n4 = this.origXc;
        int n5 = this.origZc;
        if (this.origXb > n4 && this.origZb > n5) {
            n4 -= Mathlib.Mul(Mathlib.Div(n3, 0x1E0000), Mathlib.Cos(n2));
            n5 -= Mathlib.Mul(Mathlib.Div(n3, 0x1E0000), Mathlib.Sin(n2));
        } else if (this.origXb > n4 && this.origZb < n5) {
            n4 -= Mathlib.Mul(Mathlib.Div(n3, 0x1E0000), Mathlib.Cos(n2));
            n5 += Mathlib.Mul(Mathlib.Div(n3, 0x1E0000), Mathlib.Sin(n2));
        } else if (this.origXb <= n4 && this.origZb <= n5) {
            n4 += Mathlib.Mul(Mathlib.Div(n3, 0x1E0000), Mathlib.Cos(n2));
            n5 += Mathlib.Mul(Mathlib.Div(n3, 0x1E0000), Mathlib.Sin(n2));
        } else if (this.origXb < n4 && this.origZb > n5) {
            n4 += Mathlib.Mul(Mathlib.Div(n3, 0x1E0000), Mathlib.Cos(n2));
            n5 -= Mathlib.Mul(Mathlib.Div(n3, 0x1E0000), Mathlib.Sin(n2));
        }
        this.rollDist = Mathlib.FP16Dist(this.worldX, this.worldZ, n4, n5);
        int n6 = this.worldX - n4;
        int n7 = this.worldZ - n5;
        this.terrainInfo.x = tEngine.C3D_FP16To3DCoords(this.worldX);
        this.terrainInfo.z = tEngine.C3D_FP16To3DCoords(this.worldZ);
        tEngine.getTerrainInfo(Game.m_CurrHole3dData, this.terrainInfo);
        switch (this.terrainInfo.type) {
            case 3: 
            case 4: 
            case 6: {
                n = 140000;
                break;
            }
            default: {
                n = 100000;
            }
        }
        this.t = Mathlib.Sqrt(Mathlib.Div(Mathlib.Mul(this.rollDist, TWO), n));
        int n8 = Mathlib.Mul(this.t, n);
        this.vx = -Mathlib.Mul(n8, Mathlib.Div(n6, this.rollDist));
        this.vz = -Mathlib.Mul(n8, Mathlib.Div(n7, this.rollDist));
        this.ax = Mathlib.Mul(n, Mathlib.Div(n6, this.rollDist));
        this.az = Mathlib.Mul(n, Mathlib.Div(n7, this.rollDist));
    }

    public boolean rollShotBall(long l) {
        int n = Mathlib.Div(Mathlib.intToFP((int)(l - this.bstartTime)), Mathlib.intToFP(1000));
        this.terrainInfo.x = tEngine.C3D_FP16To3DCoords(this.worldX);
        this.terrainInfo.z = tEngine.C3D_FP16To3DCoords(this.worldZ);
        tEngine.getTerrainInfo(Game.m_CurrHole3dData, this.terrainInfo);
        this.puttX = this.terrainInfo.normal.x != 0 ? (this.puttX += Mathlib.Sin(Mathlib.Div(Mathlib.Mul(this.terrainInfo.normal.x, 205887), ONEEIGHTY))) : (this.puttX += Mathlib.Sin(0));
        this.puttZ = this.terrainInfo.normal.z != 0 ? (this.puttZ += Mathlib.Sin(Mathlib.Div(Mathlib.Mul(this.terrainInfo.normal.z, 205887), ONEEIGHTY))) : (this.puttZ += Mathlib.Sin(0));
        this.worldX = this.origXc + this.puttX + Mathlib.Mul(Mathlib.Mul(Mathlib.Mul(n, n), this.ax), 32768) + Mathlib.Mul(this.vx, n);
        this.worldZ = this.origZc + this.puttZ + Mathlib.Mul(Mathlib.Mul(Mathlib.Mul(n, n), this.az), 32768) + Mathlib.Mul(this.vz, n);
        this.worldY = this.terrainInfo.y << 12;
        int n2 = Mathlib.FP16Dist(this.worldX, this.worldZ, this.origXc, this.origZc);
        if (n2 > this.rollDist - 30000 || n > this.t || this.terrainInfo.type == 5 || this.terrainInfo.type == 8 || this.terrainInfo.type == 0) {
            this.ballState = 0;
            return false;
        }
        return true;
    }

    public boolean checkTerrain() {
        this.terrainInfo.x = tEngine.C3D_FP16To3DCoords(this.worldX);
        this.terrainInfo.z = tEngine.C3D_FP16To3DCoords(this.worldZ);
        tEngine.getTerrainInfo(Game.m_CurrHole3dData, this.terrainInfo);
        if (!this.landCam && this.worldY < (this.terrainInfo.y << 12) + 983025) {
            this.landCam = true;
        }
        if (this.worldY < this.terrainInfo.y << 12) {
            this.normal = this.terrainInfo.normal;
            this.worldY = this.terrainInfo.y << 12;
            return true;
        }
        return false;
    }

    public void calcBounce() {
        int n = 0;
        this.pausedTime = 0L;
        if (this.table == 0) {
            n = Mathlib.FP16toRad(Mathlib.intToFP(cloft[this.club]));
        } else if (this.table == 1) {
            n = Mathlib.FP16toRad(Mathlib.intToFP(cloft2[this.club]));
        }
        this.disti = Mathlib.Div(this.disti, Mathlib.intToFP(40));
        this.origXb = this.worldX;
        this.origYb = this.worldY;
        this.origZb = this.worldZ;
        int n2 = Mathlib.Sqrt(Mathlib.Div(Mathlib.Mul(this.disti, 682253), Mathlib.Sin(Mathlib.Mul(n, TWO))));
        this.vz = Mathlib.Mul(Mathlib.Mul(n2, Mathlib.Cos(n)), Mathlib.Cos(this.dir)) - Mathlib.Cos(Mathlib.Div(Mathlib.Mul(this.normal.z, 205887), ONEEIGHTY)) - Mathlib.Abs(Mathlib.Mul(n2, Mathlib.Sin(Mathlib.Div(this.askew, TWO))));
        this.vx = Mathlib.Mul(Mathlib.Mul(n2, Mathlib.Cos(n)), Mathlib.Sin(this.dir)) - Mathlib.Cos(Mathlib.Div(Mathlib.Mul(this.normal.x, 205887), ONEEIGHTY)) - Mathlib.Abs(Mathlib.Mul(n2, Mathlib.Sin(Mathlib.Div(this.askew, TWO))));
        this.vy = Mathlib.Mul(n2, Mathlib.Sin(n)) - Mathlib.Mul(n2, Mathlib.Sin(Mathlib.Div(Mathlib.Mul(this.normal.y >> 8, 205887), ONEEIGHTY)));
        this.bstartTime = System.currentTimeMillis();
    }

    public boolean bounceBall(long l) {
        long l2 = l - this.bstartTime;
        long l3 = l - this.startTime;
        int n = Mathlib.Div(Mathlib.intToFP((int)l2), Mathlib.intToFP(1000));
        int n2 = Mathlib.Div(Mathlib.intToFP((int)l3), Mathlib.intToFP(1000));
        this.worldZ = this.origZb + Mathlib.Mul(this.vz + this.windOffsetz, n);
        this.worldX = this.origXb + Mathlib.Mul(this.vx + this.windOffsetx, n);
        this.worldY = this.origYb + Mathlib.Mul(Mathlib.Mul(this.vy, n) - Mathlib.Div(Mathlib.Mul(682253, Mathlib.Mul(n, n)), TWO), Mathlib.intToFP(2));
        return !this.checkTerrain();
    }

    public void calcRoll() {
        int n = Mathlib.FP16Dist(this.worldX, this.worldZ, this.game.target.worldX, this.game.target.worldZ);
        int n2 = this.worldX - this.game.target.worldX;
        int n3 = this.worldZ - this.game.target.worldZ;
        this.t = Mathlib.Sqrt(Mathlib.Div(Mathlib.Mul(n, TWO), 19000));
        int n4 = Mathlib.Mul(this.t, 19000);
        this.vx = -Mathlib.Mul(n4, Mathlib.Div(n2, n));
        this.vz = -Mathlib.Mul(n4, Mathlib.Div(n3, n));
        this.ax = Mathlib.Mul(19000, Mathlib.Div(n2, n));
        this.az = Mathlib.Mul(19000, Mathlib.Div(n3, n));
    }

    public boolean rollBall(long l) {
        int n = 0;
        int n2 = 0;
        l -= this.pausedTime;
        switch (this.ballState) {
            case 0: {
                this.calcRoll();
                this.ballState = (byte)3;
                this.origXc = this.worldX;
                this.origYc = this.worldY;
                this.origZc = this.worldZ;
                this.bstartTime = System.currentTimeMillis();
                break;
            }
            case 3: {
                int n3 = 8000;
                if (this.viewChange) {
                    this.changeTS -= Mathlib.Div(Mathlib.intToFP((int)(l - this.bstartTime)), Mathlib.intToFP(1000));
                }
                n = Mathlib.Div(Mathlib.intToFP((int)(l - this.bstartTime)), Mathlib.intToFP(1000)) + this.changeTS;
                if (!this.viewChange && this.oldTime != 0L) {
                    n2 = Mathlib.Div(Mathlib.intToFP((int)(this.oldTime - this.bstartTime)), Mathlib.intToFP(1000));
                }
                this.terrainInfo.x = tEngine.C3D_FP16To3DCoords(this.worldX);
                this.terrainInfo.z = tEngine.C3D_FP16To3DCoords(this.worldZ);
                tEngine.getTerrainInfo(Game.m_CurrHole3dData, this.terrainInfo);
                if (this.game.player1.holeDist > 65536) {
                    if (this.terrainInfo.normal.x != 0) {
                        this.puttX += Mathlib.Sin(Mathlib.Div(Mathlib.Mul(this.terrainInfo.normal.x * 11, 205887), ONEEIGHTY));
                    }
                    if (this.terrainInfo.normal.z != 0) {
                        this.puttZ += Mathlib.Sin(Mathlib.Div(Mathlib.Mul(this.terrainInfo.normal.z * 11, 205887), ONEEIGHTY));
                    }
                } else {
                    if (this.terrainInfo.normal.x != 0) {
                        this.puttX += Mathlib.Sin(Mathlib.Div(Mathlib.Mul(this.terrainInfo.normal.x, 205887), ONEEIGHTY));
                    }
                    if (this.terrainInfo.normal.z != 0) {
                        this.puttZ += Mathlib.Sin(Mathlib.Div(Mathlib.Mul(this.terrainInfo.normal.z, 205887), ONEEIGHTY));
                    }
                }
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                if (!this.viewChange) {
                    n4 = Mathlib.Abs(this.pChangeX);
                    n5 = Mathlib.Abs(this.pChangeZ);
                    this.pChangeX = Mathlib.Mul(Mathlib.Mul(Mathlib.Mul(n, n), this.ax), 32768) + Mathlib.Mul(this.vx, n);
                    this.pChangeZ = Mathlib.Mul(Mathlib.Mul(Mathlib.Mul(n, n), this.az), 32768) + Mathlib.Mul(this.vz, n);
                    n6 = Mathlib.Abs(this.pChangeX) - n4 + (Mathlib.Abs(this.pChangeZ) - n5);
                    n7 = Mathlib.Div(n6, n3);
                }
                if (n6 < 0) {
                    this.ballState = 0;
                    return false;
                }
                this.worldX = this.origXc + this.puttX + this.pChangeX;
                this.worldZ = this.origZc + this.puttZ + this.pChangeZ;
                this.worldY = this.terrainInfo.y << 12;
                int n8 = Mathlib.FP16Dist(this.worldX, this.worldZ, this.origXc, this.origZc);
                int n9 = Mathlib.FP16Dist(this.origXc, this.origZc, this.game.pin.x << 12, this.game.pin.z << 12);
                int n10 = Mathlib.FP16Dist(this.worldX, this.worldZ, this.game.pin.x << 12, this.game.pin.z << 12);
                if (n10 < 7000 && n7 < 40000) {
                    this.ballState = 0;
                    return false;
                }
                if (this.viewChange) {
                    this.viewChange = false;
                }
                this.oldTime = l;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void updateScreen() {
        block39: {
            block38: {
                var1_1 = new tVertex3D();
                var2_2 = new tProjVertex3D();
                var1_1.x = tEngine.C3D_FP16To3DCoords(this.worldX);
                var1_1.y = tEngine.C3D_FP16To3DCoords(this.worldY);
                var1_1.z = tEngine.C3D_FP16To3DCoords(this.worldZ);
                if (this.landCam) ** GOTO lbl-1000
                if (this.game.player1.gameArea == 0) ** GOTO lbl-1000
                if (this.game.player1.gameArea == 2) {
                    this.game.gputt;
                    ** if (this.game.gputt.gameState < 2) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 3 sources

                {
                    tEngine.getCameraProjectedInfo((byte)2, var1_1, var2_2);
                    ** GOTO lbl19
                }
lbl-1000:
                // 2 sources

                {
                    tEngine.getCameraProjectedInfo((byte)1, var1_1, var2_2);
                }
lbl19:
                // 2 sources

                if (this.game.player1.gameArea == 2) {
                    if (this.oldScreenX == 0) {
                        this.screenX = var2_2.s.x;
                    } else if (var2_2.s.x < this.screenX) {
                        ++this.rights;
                        this.lefts = 0;
                    } else if (var2_2.s.x > this.screenX) {
                        this.rights = 0;
                        ++this.lefts;
                    }
                    if (this.lefts > 4 || this.rights > 4) {
                        this.screenX = var2_2.s.x;
                    }
                    if (this.oldScreenY == 0) {
                        this.screenY = var2_2.s.y;
                    } else if (var2_2.s.y < this.screenY) {
                        ++this.ups;
                        this.downs = 0;
                    } else if (var2_2.s.y > this.screenY) {
                        this.ups = 0;
                        ++this.downs;
                    }
                    if (this.ups > 4 || this.downs > 4) {
                        this.screenY = var2_2.s.y;
                    }
                } else {
                    this.screenX = var2_2.s.x;
                }
                this.screenY = var2_2.s.y;
                var1_1.x = tEngine.C3D_FP16To3DCoords(this.worldX);
                var1_1.y = tEngine.C3D_FP16To3DCoords(this.worldY);
                var1_1.z = tEngine.C3D_FP16To3DCoords(this.worldZ);
                if (this.game.player1.gameArea == 0) break block38;
                if (this.game.player1.gameArea != 1) break block39;
            }
            this.terrainInfo.x = tEngine.C3D_FP16To3DCoords(this.worldX);
            this.terrainInfo.z = tEngine.C3D_FP16To3DCoords(this.worldZ);
            tEngine.getTerrainInfo(Game.m_CurrHole3dData, this.terrainInfo);
            this.shadow = this.terrainInfo.y << 12;
            if (this.landCam) ** GOTO lbl-1000
            if (this.game.player1.gameArea == 0) lbl-1000:
            // 2 sources

            {
                var1_1.y = tEngine.C3D_FP16To3DCoords(this.shadow);
                tEngine.getCameraProjectedInfo((byte)2, var1_1, var2_2);
            } else if (this.game.player1.gameArea == 1) {
                var1_1.z = tEngine.C3D_FP16To3DCoords(this.worldZ - this.worldY + this.shadow);
                tEngine.getCameraProjectedInfo((byte)1, var1_1, var2_2);
            }
            this.shadowX = var2_2.s.x;
            this.shadowY = var2_2.s.y;
        }
        if (this.game.player1.gameArea == 0) {
            if (this.worldX - this.origXa != 0 || this.worldZ - this.origZa != 0) {
                if (this.ballState == 0) {
                    this.ballType = (byte)-1;
                } else {
                    var3_3 = Mathlib.toInt(Mathlib.FP16Dist(this.worldX, this.worldZ, this.origXa, this.origZa));
                    if (var3_3 < 1) {
                        this.ballType = (byte)-1;
                    } else if (var3_3 > 1 && var3_3 < 60) {
                        this.ballType = 0;
                    } else if (var3_3 > 60) {
                        this.ballType = 1;
                    }
                }
            } else {
                this.ballType = (byte)-1;
            }
        } else if (this.game.player1.gameArea == 1) {
            var3_4 = Mathlib.toInt(this.worldY) - Mathlib.toInt(this.origYa);
            if (var3_4 < 8) {
                this.ballType = 1;
            }
            if (var3_4 > 8 && var3_4 < 20) {
                this.ballType = 0;
            } else if (var3_4 > 20) {
                this.ballType = (byte)-1;
            }
        } else {
            this.ballType = 0;
        }
        if (this.landCam) {
            this.ballType = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void drawBG(Graphics graphics, Image image) {
        block5: {
            block4: {
                if (this.game.player1.gameArea == 0) break block4;
                if (this.game.player1.gameArea != 1) break block5;
            }
            graphics.setClip(this.oldScreenX - this.game.ball.getWidth() / 3 / 2, this.oldScreenY - this.game.ball.getHeight() - 1, this.game.ball.getWidth() / 3, this.game.ball.getHeight() + 3);
            graphics.drawImage(image, 0, 0, 20);
            graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
            graphics.setClip(this.oldShadowX, this.oldShadowY, 8, 8);
            graphics.drawImage(image, 0, 0, 20);
            graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
            return;
        }
        if (this.game.player1.gameArea != 2) return;
        if (!this.puttCamDone) {
            graphics.setClip(this.oldScreenX - this.game.ball.getWidth() / 6, this.oldScreenY - this.game.ball.getHeight() / 2, this.game.ball.getWidth() / 3, this.game.ball.getHeight());
            graphics.drawImage(image, 0, 0, 20);
        }
        graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
    }

    public void draw(Graphics graphics) {
        this.updateScreen();
        graphics.setColor(0);
        if (this.game.player1.gameArea == 0) {
            if (this.ballState != 0) {
                graphics.fillRoundRect(this.shadowX, this.shadowY, -this.ballType + 2, -this.ballType + 2, 45, 45);
            }
            graphics.setClip(this.screenX - this.game.ball.getWidth() / 3 / 2, this.screenY - this.game.ball.getHeight() + this.ballType + 1, this.game.ball.getWidth() / 3, this.game.ball.getHeight());
            graphics.drawImage(this.game.ball, this.screenX - this.game.ball.getWidth() / 3 * this.ballType, this.screenY + this.ballType + 1, 33);
            graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
        } else if (this.game.player1.gameArea == 2) {
            if (!this.puttCamDone) {
                graphics.setClip(this.screenX - this.game.ball.getWidth() / 3 / 2, this.screenY - this.game.ball.getHeight() / 2, this.game.ball.getWidth() / 3, this.game.ball.getHeight());
                graphics.drawImage(this.game.ball, this.screenX, this.screenY + this.game.ball.getHeight() / 2, 33);
            }
            graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
        } else {
            graphics.fillRoundRect(this.shadowX, this.shadowY, -this.ballType + 2, -this.ballType + 2, 45, 45);
            graphics.setClip(this.screenX - this.game.ball.getWidth() / 3 / 2, this.screenY - this.game.ball.getHeight() / 2, this.game.ball.getWidth() / 3, this.game.ball.getHeight());
            graphics.drawImage(this.game.ball, this.screenX - this.game.ball.getWidth() / 3 * this.ballType, this.screenY + this.game.ball.getHeight() / 2, 33);
            graphics.setClip(0, 0, this.game.SCREEN_WIDTH, this.game.SCREEN_HEIGHT);
            if (this.ballState == 1 && !this.landCam) {
                this.game.flagUpdateBG = true;
            }
        }
        this.oldScreenX = this.screenX;
        this.oldScreenY = this.screenY;
        this.oldShadowX = this.shadowX;
        this.oldShadowY = this.shadowY;
    }
}

