/*
 * Decompiled with CFR 0.152.
 */
package TW2006.renderer;

import TW2006.archive.tFileMgr;
import TW2006.renderer.tMaterial3D;
import TW2006.renderer.tMath;
import TW2006.renderer.tObject3D;
import TW2006.renderer.tObject3DInfo;
import TW2006.renderer.tProjVertex3D;
import TW2006.renderer.tRenderScreen;
import TW2006.renderer.tRenderer_MIDP_2_0;
import TW2006.renderer.tSortTechniques;
import TW2006.renderer.tTexture;
import TW2006.renderer.tVertex3D;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class tEngine
extends tRenderer_MIDP_2_0 {
    protected static int screenWidth = 0;
    protected static int screenHeight = 0;
    protected static volatile byte[] screen = null;
    protected static Graphics m_RenderContext = null;
    public static Image drawSurface = null;
    public static final byte RENDERF_TREE = 1;
    public static final byte RENDERF_FLAG = 2;
    public static final byte RENDERF_MAP = 4;
    public static final byte RENDERF_SCENE = 8;
    public static final byte RENDERF_TREEFIRST = 16;
    public static final byte RENDERF_WATER_BG = 32;
    public static final byte TERRAIN_TYPE_NULL = 0;
    public static final byte TERRAIN_TYPE_FAIRWAY = 1;
    public static final byte TERRAIN_TYPE_GREEN = 2;
    public static final byte TERRAIN_TYPE_ROUGH = 3;
    public static final byte TERRAIN_TYPE_SANDTRAP = 4;
    public static final byte TERRAIN_TYPE_CLIFF = 5;
    public static final byte TERRAIN_TYPE_DESERT = 6;
    public static final byte TERRAIN_TYPE_TEE = 7;
    public static final byte TERRAIN_TYPE_WATER = 8;
    public static final byte TERRAIN_TYPE_TREES = 9;
    public static final byte CAM_TYPE_2D = 1;
    public static final byte CAM_TYPE_3D = 2;
    public static final byte CAM_TYPE_MAP = 3;
    private static tRenderScreen m_3dRenderScreen = null;
    private static tRenderScreen m_2dRenderScreen = null;
    private static tRenderScreen m_MapRenderScreen = null;
    private static tTexture m_Flag = null;
    private static tTexture m_Flag2d = null;
    private static tTexture m_OutOfBounds = null;
    protected static tTexture m_OutOfBoundsWater = null;
    private static tTexture m_Background = null;
    private static tTexture[] m_Trees = null;
    private static tTexture m_HoleCloseup = null;
    private static int m_HoleScrHeight = 0;
    protected static int m_TreeCount = 0;
    private static int m_iTreeClipDist = tEngine.C3D_IntTo3DCoords(17) * 256;
    protected static short[] m_RandomTable = new short[32];
    protected static short m_RandomIdx = 0;
    public static byte[] par = new byte[18];
    public static short[] dist = new short[18];
    public static String prefixHole = null;
    public static String prefixAnim = null;
    public static String golferName = null;
    public static byte[] chgType = new byte[]{0, 0, 0, 0};
    public static byte[][] chgHoles = new byte[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
    public static int[][] chgBallX = new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
    public static int[][] chgBallZ = new int[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
    public static byte[][] chgInitCond = new byte[][]{{0, 0, 0}, {0, 0, 0}, {0, 0, 0}, {0, 0, 0}};
    public static byte[] chgVicCond1 = new byte[]{0, 0, 0, 0};
    public static byte[] chgVicCond2 = new byte[]{0, 0, 0, 0};
    public static String[] chgText = new String[]{null, null, null, null};

    public static void initStageOne(int n, int n2, int n3) {
        screenWidth = n;
        screenHeight = n2;
        if (screen == null) {
            screen = new byte[screenWidth * screenHeight];
        }
        tRenderer_MIDP_2_0.initDeviceSpecifics();
        m_TreeCount = n3;
    }

    public static void initStageTwo() {
        m_2dRenderScreen = new tRenderScreen(true);
        m_3dRenderScreen = new tRenderScreen(false);
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            n = tMath.RAND(n) / 3;
            tEngine.m_RandomTable[i] = (short)n;
        }
    }

    public static void initStageThree() {
        if (m_TreeCount > 0) {
            m_Trees = new tTexture[m_TreeCount];
            for (int i = 0; i < m_TreeCount; ++i) {
                tEngine.m_Trees[i] = new tTexture("tree" + Integer.toString(i + 1) + ".cpi");
            }
        }
    }

    public static void initStageFour() {
        m_Flag = new tTexture("flag3d.cpi");
        m_Flag2d = new tTexture("tdflag.cpi");
        m_Background = new tTexture("sky.cpi");
    }

    public static void initStageFive() {
        m_OutOfBounds = new tTexture("outofbounds.cpi");
        m_OutOfBoundsWater = new tTexture("water.cpi");
        m_HoleCloseup = new tTexture("holeclose.cpi");
    }

    public static final void initMiniMap(tObject3D tObject3D2, int n, int n2, int n3, int n4) {
        if (m_MapRenderScreen != null) {
            m_MapRenderScreen = null;
        }
        System.gc();
        m_MapRenderScreen = new tRenderScreen(n, n2, n3, n4, true);
        tVertex3D tVertex3D2 = new tVertex3D();
        tVertex3D tVertex3D3 = new tVertex3D();
        tVertex3D tVertex3D4 = new tVertex3D();
        tVertex3D2.x = tObject3D2.minX;
        tVertex3D2.z = tObject3D2.minZ;
        tVertex3D3.x = tObject3D2.maxX + (tObject3D2.maxX - tObject3D2.minX) * (tEngine.m_Flag2d.height / 2) / tEngine.m_MapRenderScreen.iRenderClipH;
        tVertex3D3.z = tObject3D2.maxZ;
        tEngine.setTwoPointOverheadZoom((byte)3, tObject3D2.maxZ - tObject3D2.minZ, 1, tVertex3D2, tVertex3D3, tVertex3D4);
        tEngine.setCameraPosition((byte)3, tVertex3D4.x, tObject3D2.maxY + tEngine.C3D_IntTo3DCoords(10), tVertex3D4.z);
        tEngine.setCameraRotation((byte)3, 90, 90);
    }

    public static final void setHoleScrHeight(int n) {
        m_HoleScrHeight = n;
    }

    public static final void draw(byte by, tObject3D tObject3D2, int n) {
        int n2 = 0;
        tMaterial3D tMaterial3D2 = null;
        switch (by) {
            case 2: {
                if ((n & 8) != 0) {
                    int n3;
                    n2 = tEngine.m_3dRenderScreen.camera.getHorizonY();
                    m_3dRenderScreen.fillTextureStretchY(m_Background, tEngine.m_3dRenderScreen.camera.headingDeg * 3, 0, 0, tEngine.m_3dRenderScreen.width - 1, n2 - 1);
                    if ((n & 0x20) != 0) {
                        m_3dRenderScreen.fillTexture(m_OutOfBoundsWater, 0, 0, 0, n2, tEngine.m_3dRenderScreen.width - 1, tEngine.m_3dRenderScreen.height - 1);
                    } else {
                        m_3dRenderScreen.fillTexture(m_OutOfBounds, 0, 0, 0, n2, tEngine.m_3dRenderScreen.width - 1, tEngine.m_3dRenderScreen.height - 1);
                    }
                    for (n3 = 0; n3 < tObject3D2.vertexCount; ++n3) {
                        tEngine.m_3dRenderScreen.camera.transformVertex(tObject3D2.vertexList[n3], tObject3D2.m_ProjVertexBuf[n3].v);
                        tEngine.m_3dRenderScreen.camera.projectVertex(tObject3D2.m_ProjVertexBuf[n3].v, tObject3D2.m_ProjVertexBuf[n3]);
                    }
                    tMaterial3D2 = tObject3D2.firstMaterial;
                    while (tMaterial3D2 != null) {
                        for (n3 = 0; n3 < tMaterial3D2.triangleCount; ++n3) {
                            m_3dRenderScreen.drawTriangle3D(tMaterial3D2.triangleList[n3], tObject3D2.m_ProjVertexBuf, tObject3D2.uvList, tMaterial3D2.texture);
                        }
                        tMaterial3D2 = tMaterial3D2.nextMaterial;
                    }
                }
                tProjVertex3D tProjVertex3D2 = new tProjVertex3D();
                tProjVertex3D tProjVertex3D3 = new tProjVertex3D();
                int n4 = 0;
                int n5 = 0;
                if ((n & 0x10) != 0) {
                    int n6;
                    int n7;
                    if (tObject3D2.m_TreeMat != null && (n & 1) != 0) {
                        n7 = tEngine.m_3dRenderScreen.camera.nearClip;
                        tEngine.m_3dRenderScreen.camera.nearClip = m_iTreeClipDist;
                        tVertex3D tVertex3D2 = new tVertex3D();
                        for (n6 = 0; n6 < tObject3D2.m_TreeMat.triangleCount; ++n6) {
                            tEngine.m_3dRenderScreen.camera.transformVertex(tObject3D2.m_TreeRenderList[n6].worldPos, tProjVertex3D2.v);
                            if (!tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D2.v, tProjVertex3D2)) {
                                tObject3D2.m_TreeRenderList[n6].iDepthZ = -1;
                                continue;
                            }
                            n4 = tProjVertex3D2.s.y;
                            tObject3D2.m_TreeRenderList[n6].worldPos.y -= 200;
                            tEngine.m_3dRenderScreen.camera.transformVertex(tObject3D2.m_TreeRenderList[n6].worldPos, tProjVertex3D2.v);
                            tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D2.v, tProjVertex3D2);
                            tObject3D2.m_TreeRenderList[n6].worldPos.y += 200;
                            n4 = tProjVertex3D2.s.y - n4;
                            n5 = n4 * tEngine.m_Trees[tObject3D2.m_TreeRenderList[n6].type].width / tEngine.m_Trees[tObject3D2.m_TreeRenderList[n6].type].height;
                            if (n5 < 1) {
                                n5 = 1;
                            }
                            tObject3D2.m_TreeRenderList[n6].iDepthZ = tProjVertex3D2.v.z;
                            tObject3D2.m_TreeRenderList[n6].iWidth = n5;
                            tObject3D2.m_TreeRenderList[n6].iHeight = n4;
                            tObject3D2.m_TreeRenderList[n6].iSrcX = tProjVertex3D2.s.x;
                            tObject3D2.m_TreeRenderList[n6].iSrcY = tProjVertex3D2.s.y - n4 - (tObject3D2.m_TreeRenderList[n6].iHeight >> 1);
                        }
                        tSortTechniques.quickSort(tObject3D2.m_TreeRenderList, 0, tObject3D2.m_TreeMat.triangleCount - 1);
                        for (n6 = tObject3D2.m_TreeMat.triangleCount - 1; n6 >= 0; --n6) {
                            if (tObject3D2.m_TreeRenderList[n6].iDepthZ == -1) continue;
                            m_3dRenderScreen.renderSprite(m_Trees[tObject3D2.m_TreeRenderList[n6].type], tObject3D2.m_TreeRenderList[n6].iSrcX, tObject3D2.m_TreeRenderList[n6].iSrcY, tObject3D2.m_TreeRenderList[n6].iWidth, tObject3D2.m_TreeRenderList[n6].iHeight);
                        }
                        tEngine.m_3dRenderScreen.camera.nearClip = n7;
                    }
                    tEngine.m_3dRenderScreen.camera.transformVertex(tObject3D2.holePos, tProjVertex3D2.v);
                    if (tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D2.v, tProjVertex3D2)) {
                        if (m_HoleScrHeight == 0) {
                            tProjVertex3D3.v.copy(tObject3D2.holePos);
                            tProjVertex3D3.v.y += 2;
                            tEngine.m_3dRenderScreen.camera.transformVertex(tProjVertex3D3.v, tProjVertex3D3.v);
                            if (tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D3.v, tProjVertex3D3)) {
                                n4 = tProjVertex3D2.s.y - tProjVertex3D3.s.y;
                            }
                        } else {
                            n4 = m_HoleScrHeight;
                            m_HoleScrHeight = 0;
                        }
                        if (n4 > 0) {
                            n5 = n4 * tEngine.m_HoleCloseup.width / tEngine.m_HoleCloseup.height;
                            m_3dRenderScreen.renderSprite(m_HoleCloseup, tProjVertex3D2.s.x, tProjVertex3D2.s.y - (n4 >> 1) - 1, n5, n4);
                        }
                    }
                    if ((n & 2) != 0) {
                        tEngine.m_3dRenderScreen.camera.transformVertex(tObject3D2.holePos, tProjVertex3D2.v);
                        if (tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D2.v, tProjVertex3D2)) {
                            tProjVertex3D3.v.copy(tObject3D2.holePos);
                            tProjVertex3D3.v.y += tEngine.C3D_IntTo3DCoords(4);
                            tEngine.m_3dRenderScreen.camera.transformVertex(tProjVertex3D3.v, tProjVertex3D3.v);
                            if (tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D3.v, tProjVertex3D3) && (n4 = tProjVertex3D2.s.y - tProjVertex3D3.s.y) > 0) {
                                n5 = n4 * tEngine.m_Flag.width / tEngine.m_Flag.height;
                                m_3dRenderScreen.renderSprite(m_Flag, tProjVertex3D2.s.x + n5 / 2 - 1, tProjVertex3D2.s.y - n4 / 2 - 1, n5, n4);
                                --tProjVertex3D2.s.x;
                                --tProjVertex3D2.s.y;
                                if (tProjVertex3D3.s.x > tEngine.m_3dRenderScreen.iRenderClipX && tProjVertex3D3.s.x < tEngine.m_3dRenderScreen.iRenderClipX + tEngine.m_3dRenderScreen.iRenderClipW) {
                                    n7 = (tEngine.m_Flag.height - 1 << 16) / n4;
                                    int n8 = 0;
                                    n6 = tProjVertex3D3.s.y;
                                    int n9 = tProjVertex3D2.s.y;
                                    if (tProjVertex3D3.s.y < tEngine.m_3dRenderScreen.iRenderClipY) {
                                        n8 = (tEngine.m_3dRenderScreen.iRenderClipY - tProjVertex3D3.s.y) * n7;
                                        n6 = tEngine.m_3dRenderScreen.iRenderClipY;
                                    }
                                    if (tProjVertex3D2.s.y >= tEngine.m_3dRenderScreen.iRenderClipY + tEngine.m_3dRenderScreen.iRenderClipH) {
                                        n9 = tEngine.m_3dRenderScreen.iRenderClipY + tEngine.m_3dRenderScreen.iRenderClipH - 1;
                                    }
                                    for (int i = n6; i <= n9; ++i) {
                                        tEngine.screen[tEngine.screenWidth * i + tProjVertex3D2.s.x] = tEngine.m_Flag.palIdx[(n8 >> 16) * tEngine.m_Flag.width];
                                        n8 += n7;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    int n10;
                    int n11;
                    tEngine.m_3dRenderScreen.camera.transformVertex(tObject3D2.holePos, tProjVertex3D2.v);
                    if (tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D2.v, tProjVertex3D2)) {
                        if (m_HoleScrHeight == 0) {
                            tProjVertex3D3.v.copy(tObject3D2.holePos);
                            tProjVertex3D3.v.y += 2;
                            tEngine.m_3dRenderScreen.camera.transformVertex(tProjVertex3D3.v, tProjVertex3D3.v);
                            if (tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D3.v, tProjVertex3D3)) {
                                n4 = tProjVertex3D2.s.y - tProjVertex3D3.s.y;
                            }
                        } else {
                            n4 = m_HoleScrHeight;
                            m_HoleScrHeight = 0;
                        }
                        if (n4 > 0) {
                            n5 = n4 * tEngine.m_HoleCloseup.width / tEngine.m_HoleCloseup.height;
                            m_3dRenderScreen.renderSprite(m_HoleCloseup, tProjVertex3D2.s.x, tProjVertex3D2.s.y - (n4 >> 1) - 1, n5, n4);
                        }
                    }
                    if ((n & 2) != 0) {
                        tEngine.m_3dRenderScreen.camera.transformVertex(tObject3D2.holePos, tProjVertex3D2.v);
                        if (tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D2.v, tProjVertex3D2)) {
                            tProjVertex3D3.v.copy(tObject3D2.holePos);
                            tProjVertex3D3.v.y += tEngine.C3D_IntTo3DCoords(4);
                            tEngine.m_3dRenderScreen.camera.transformVertex(tProjVertex3D3.v, tProjVertex3D3.v);
                            if (tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D3.v, tProjVertex3D3) && (n4 = tProjVertex3D2.s.y - tProjVertex3D3.s.y) > 0) {
                                n5 = n4 * tEngine.m_Flag.width / tEngine.m_Flag.height;
                                m_3dRenderScreen.renderSprite(m_Flag, tProjVertex3D2.s.x + n5 / 2 - 1, tProjVertex3D2.s.y - n4 / 2 - 1, n5, n4);
                                --tProjVertex3D2.s.x;
                                --tProjVertex3D2.s.y;
                                if (tProjVertex3D3.s.x > tEngine.m_3dRenderScreen.iRenderClipX && tProjVertex3D3.s.x < tEngine.m_3dRenderScreen.iRenderClipX + tEngine.m_3dRenderScreen.iRenderClipW) {
                                    n11 = (tEngine.m_Flag.height - 1 << 16) / n4;
                                    int n12 = 0;
                                    n10 = tProjVertex3D3.s.y;
                                    int n13 = tProjVertex3D2.s.y;
                                    if (tProjVertex3D3.s.y < tEngine.m_3dRenderScreen.iRenderClipY) {
                                        n12 = (tEngine.m_3dRenderScreen.iRenderClipY - tProjVertex3D3.s.y) * n11;
                                        n10 = tEngine.m_3dRenderScreen.iRenderClipY;
                                    }
                                    if (tProjVertex3D2.s.y >= tEngine.m_3dRenderScreen.iRenderClipY + tEngine.m_3dRenderScreen.iRenderClipH) {
                                        n13 = tEngine.m_3dRenderScreen.iRenderClipY + tEngine.m_3dRenderScreen.iRenderClipH - 1;
                                    }
                                    for (int i = n10; i <= n13; ++i) {
                                        tEngine.screen[tEngine.screenWidth * i + tProjVertex3D2.s.x] = tEngine.m_Flag.palIdx[(n12 >> 16) * tEngine.m_Flag.width];
                                        n12 += n11;
                                    }
                                }
                            }
                        }
                    }
                    if (tObject3D2.m_TreeMat != null && (n & 1) != 0) {
                        n11 = tEngine.m_3dRenderScreen.camera.nearClip;
                        tEngine.m_3dRenderScreen.camera.nearClip = m_iTreeClipDist;
                        tVertex3D tVertex3D3 = new tVertex3D();
                        for (n10 = 0; n10 < tObject3D2.m_TreeMat.triangleCount; ++n10) {
                            tEngine.m_3dRenderScreen.camera.transformVertex(tObject3D2.m_TreeRenderList[n10].worldPos, tProjVertex3D2.v);
                            if (!tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D2.v, tProjVertex3D2)) {
                                tObject3D2.m_TreeRenderList[n10].iDepthZ = -1;
                                continue;
                            }
                            n4 = tProjVertex3D2.s.y;
                            tObject3D2.m_TreeRenderList[n10].worldPos.y -= 200;
                            tEngine.m_3dRenderScreen.camera.transformVertex(tObject3D2.m_TreeRenderList[n10].worldPos, tProjVertex3D2.v);
                            tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D2.v, tProjVertex3D2);
                            tObject3D2.m_TreeRenderList[n10].worldPos.y += 200;
                            n4 = tProjVertex3D2.s.y - n4;
                            n5 = n4 * tEngine.m_Trees[tObject3D2.m_TreeRenderList[n10].type].width / tEngine.m_Trees[tObject3D2.m_TreeRenderList[n10].type].height;
                            if (n5 < 1) {
                                n5 = 1;
                            }
                            tObject3D2.m_TreeRenderList[n10].iDepthZ = tProjVertex3D2.v.z;
                            tObject3D2.m_TreeRenderList[n10].iWidth = n5;
                            tObject3D2.m_TreeRenderList[n10].iHeight = n4;
                            tObject3D2.m_TreeRenderList[n10].iSrcX = tProjVertex3D2.s.x;
                            tObject3D2.m_TreeRenderList[n10].iSrcY = tProjVertex3D2.s.y - n4 - (tObject3D2.m_TreeRenderList[n10].iHeight >> 1);
                        }
                        tSortTechniques.quickSort(tObject3D2.m_TreeRenderList, 0, tObject3D2.m_TreeMat.triangleCount - 1);
                        for (n10 = tObject3D2.m_TreeMat.triangleCount - 1; n10 >= 0; --n10) {
                            if (tObject3D2.m_TreeRenderList[n10].iDepthZ == -1) continue;
                            m_3dRenderScreen.renderSprite(m_Trees[tObject3D2.m_TreeRenderList[n10].type], tObject3D2.m_TreeRenderList[n10].iSrcX, tObject3D2.m_TreeRenderList[n10].iSrcY, tObject3D2.m_TreeRenderList[n10].iWidth, tObject3D2.m_TreeRenderList[n10].iHeight);
                        }
                        tEngine.m_3dRenderScreen.camera.nearClip = n11;
                    }
                }
                if ((n & 4) == 0) break;
                tEngine.draw((byte)3, tObject3D2, 0);
                break;
            }
            case 1: {
                if ((n & 8) != 0) {
                    int n14;
                    if ((n & 0x20) != 0) {
                        m_2dRenderScreen.fillTexture(m_OutOfBoundsWater, 0, 0, tEngine.m_2dRenderScreen.iRenderClipX, tEngine.m_2dRenderScreen.iRenderClipY, tEngine.m_2dRenderScreen.iRenderClipX + tEngine.m_2dRenderScreen.iRenderClipW - 1, tEngine.m_2dRenderScreen.iRenderClipY + tEngine.m_2dRenderScreen.iRenderClipH - 1);
                    } else {
                        m_2dRenderScreen.fillTexture(m_OutOfBounds, 0, 0, tEngine.m_2dRenderScreen.iRenderClipX, tEngine.m_2dRenderScreen.iRenderClipY, tEngine.m_2dRenderScreen.iRenderClipX + tEngine.m_2dRenderScreen.iRenderClipW - 1, tEngine.m_2dRenderScreen.iRenderClipY + tEngine.m_2dRenderScreen.iRenderClipH - 1);
                    }
                    for (n14 = 0; n14 < tObject3D2.vertexCount; ++n14) {
                        tEngine.m_2dRenderScreen.camera.transformVertex(tObject3D2.vertexList[n14], tObject3D2.m_ProjVertexBuf[n14].v);
                        tEngine.m_2dRenderScreen.camera.projectVertex(tObject3D2.m_ProjVertexBuf[n14].v, tObject3D2.m_ProjVertexBuf[n14]);
                    }
                    tMaterial3D2 = tObject3D2.firstMaterial;
                    while (tMaterial3D2 != null) {
                        for (n14 = 0; n14 < tMaterial3D2.triangleCount; ++n14) {
                            m_2dRenderScreen.drawTriangle3D(tMaterial3D2.triangleList[n14], tObject3D2.m_ProjVertexBuf, tObject3D2.uvList, tMaterial3D2.texture);
                        }
                        tMaterial3D2 = tMaterial3D2.nextMaterial;
                    }
                }
                if ((n & 2) != 0) {
                    tProjVertex3D tProjVertex3D4 = new tProjVertex3D();
                    tEngine.m_2dRenderScreen.camera.transformVertex(tObject3D2.holePos, tProjVertex3D4.v);
                    tEngine.m_2dRenderScreen.camera.projectVertex(tProjVertex3D4.v, tProjVertex3D4);
                    m_2dRenderScreen.renderSprite(m_Flag2d, tProjVertex3D4.s.x + tEngine.m_Flag2d.width / 2 - 2, tProjVertex3D4.s.y - tEngine.m_Flag2d.height / 2, tEngine.m_Flag2d.width, tEngine.m_Flag2d.height);
                }
                m_2dRenderScreen.resetRenderClip();
                if ((n & 4) == 0) break;
                tEngine.draw((byte)3, tObject3D2, 0);
                break;
            }
            case 3: {
                int n15;
                for (n15 = 0; n15 < tObject3D2.vertexCount; ++n15) {
                    tEngine.m_MapRenderScreen.camera.transformVertex(tObject3D2.vertexList[n15], tObject3D2.m_ProjVertexBuf[n15].v);
                    tEngine.m_MapRenderScreen.camera.projectVertex(tObject3D2.m_ProjVertexBuf[n15].v, tObject3D2.m_ProjVertexBuf[n15]);
                }
                tMaterial3D2 = tObject3D2.firstMaterial;
                while (tMaterial3D2 != null) {
                    for (n15 = 0; n15 < tMaterial3D2.triangleCount; ++n15) {
                        m_MapRenderScreen.drawTriangle3D(tMaterial3D2.triangleList[n15], tObject3D2.m_ProjVertexBuf, tObject3D2.uvList, tMaterial3D2.texture);
                    }
                    tMaterial3D2 = tMaterial3D2.nextMaterial;
                }
                tProjVertex3D tProjVertex3D5 = new tProjVertex3D();
                tEngine.m_MapRenderScreen.camera.transformVertex(tObject3D2.holePos, tProjVertex3D5.v);
                tEngine.m_MapRenderScreen.camera.projectVertex(tProjVertex3D5.v, tProjVertex3D5);
                m_MapRenderScreen.renderSprite(m_Flag2d, tProjVertex3D5.s.x + tEngine.m_Flag2d.width / 2 - 2, tProjVertex3D5.s.y - tEngine.m_Flag2d.height / 2, tEngine.m_Flag2d.width, tEngine.m_Flag2d.height);
            }
        }
    }

    public static final void setTwoPointOverheadZoom(byte by, int n, int n2, tVertex3D tVertex3D2, tVertex3D tVertex3D3, tVertex3D tVertex3D4) {
        tRenderScreen tRenderScreen2 = null;
        if (by == 1) {
            tRenderScreen2 = m_2dRenderScreen;
        } else if (by == 3) {
            tRenderScreen2 = m_MapRenderScreen;
        } else {
            return;
        }
        tVertex3D4.x = tVertex3D3.x + tVertex3D2.x >> 1;
        tVertex3D4.y = tVertex3D3.y + tVertex3D2.y >> 1;
        tVertex3D4.z = tVertex3D3.z + tVertex3D2.z >> 1;
        int n3 = (tVertex3D3.x - tVertex3D2.x) * (tVertex3D3.x - tVertex3D2.x) + (tVertex3D3.z - tVertex3D2.z) * (tVertex3D3.z - tVertex3D2.z);
        tRenderScreen2.camera.orthoScale = n + tMath.SQRT_Int(n3) * n2;
    }

    public static final void setOrthographicScale(byte by, int n) {
        switch (by) {
            case 2: {
                if (!tEngine.m_3dRenderScreen.camera.ortho) break;
                tEngine.m_3dRenderScreen.camera.orthoScale = n;
                break;
            }
            case 1: {
                if (!tEngine.m_2dRenderScreen.camera.ortho) break;
                tEngine.m_2dRenderScreen.camera.orthoScale = n;
                break;
            }
            case 3: {
                if (!tEngine.m_MapRenderScreen.camera.ortho) break;
                tEngine.m_MapRenderScreen.camera.orthoScale = n;
            }
        }
    }

    public static final void scrollDraw2DCamera(tObject3D tObject3D2, tVertex3D tVertex3D2, boolean bl, int n) {
        int n2;
        int n3;
        int n4;
        tEngine.m_2dRenderScreen.camera.setPosition(tVertex3D2.x, tVertex3D2.y, tVertex3D2.z);
        int n5 = tEngine.m_2dRenderScreen.camera.screenXScroll - tEngine.m_2dRenderScreen.camera.prevScreenXScroll;
        int n6 = tEngine.m_2dRenderScreen.camera.screenYScroll - tEngine.m_2dRenderScreen.camera.prevScreenYScroll;
        tEngine.m_2dRenderScreen.camera.prevScreenXScroll = tEngine.m_2dRenderScreen.camera.screenXScroll;
        tEngine.m_2dRenderScreen.camera.prevScreenYScroll = tEngine.m_2dRenderScreen.camera.screenYScroll;
        if (n6 == 0 && n5 == 0) {
            return;
        }
        if (bl || n5 >= tEngine.m_2dRenderScreen.iRenderClipW || n5 <= -tEngine.m_2dRenderScreen.iRenderClipW || n6 >= tEngine.m_2dRenderScreen.iRenderClipH || n6 <= -tEngine.m_2dRenderScreen.iRenderClipH) {
            tEngine.draw((byte)1, tObject3D2, n);
            return;
        }
        tEngine.m_2dRenderScreen.camera.accumScreenXScroll += n5;
        tEngine.m_2dRenderScreen.camera.accumScreenYScroll += n6;
        if (n6 > 0) {
            n4 = tEngine.m_2dRenderScreen.width * n6;
            n3 = tEngine.m_2dRenderScreen.iTotalPixels - n4;
            for (n2 = 0; n2 < n3; ++n2) {
                tEngine.screen[n2] = screen[n2 + n4];
            }
        } else if (n6 < 0) {
            n4 = tEngine.m_2dRenderScreen.width * -n6;
            n3 = tEngine.m_2dRenderScreen.iTotalPixels - n4;
            for (n2 = tEngine.m_2dRenderScreen.iTotalPixels - 1; n2 >= n4; --n2) {
                tEngine.screen[n2] = screen[n2 - n4];
            }
        }
        if (n5 > 0) {
            for (n4 = 0; n4 < tEngine.m_2dRenderScreen.height; ++n4) {
                n3 = n4 * tEngine.m_2dRenderScreen.width;
                for (n2 = 0; n2 < tEngine.m_2dRenderScreen.width - n5; ++n2) {
                    tEngine.screen[n3 + n2] = screen[n3 + n2 + n5];
                }
            }
        } else if (n5 < 0) {
            for (n4 = 0; n4 < tEngine.m_2dRenderScreen.height; ++n4) {
                n3 = n4 * tEngine.m_2dRenderScreen.width;
                for (n2 = tEngine.m_2dRenderScreen.width - 1; n2 >= -n5; --n2) {
                    tEngine.screen[n3 + n2] = screen[n3 + n2 + n5];
                }
            }
        }
        if (n5 > 0) {
            m_2dRenderScreen.setRenderClip(tEngine.m_2dRenderScreen.width - n5, 0, n5, tEngine.m_2dRenderScreen.height);
            tEngine.draw((byte)1, tObject3D2, n);
        } else if (n5 < 0) {
            m_2dRenderScreen.setRenderClip(0, 0, -n5, tEngine.m_2dRenderScreen.height);
            tEngine.draw((byte)1, tObject3D2, n);
        }
        if (n6 > 0) {
            m_2dRenderScreen.setRenderClip(0, tEngine.m_2dRenderScreen.height - n6, tEngine.m_2dRenderScreen.width, n6);
            tEngine.draw((byte)1, tObject3D2, n);
        } else if (n6 < 0) {
            m_2dRenderScreen.setRenderClip(0, 0, tEngine.m_2dRenderScreen.width, -n6);
            tEngine.draw((byte)1, tObject3D2, n);
        }
    }

    public static final int C3D_IntTo3DCoords(int n) {
        return n << 4;
    }

    public static final int C3D_FP8To3DCoords(int n) {
        return n >> 4;
    }

    public static final int C3D_FP16To3DCoords(int n) {
        return n >> 12;
    }

    public static final int C3D_3DCoordsToInt(int n) {
        return n >> 4;
    }

    public static final int C3D_3DCoordsToFP8(int n) {
        return n << 4;
    }

    public static final int C3D_3DCoordsToFP16(int n) {
        return n << 12;
    }

    public static final void setNearClip(byte by, int n) {
        switch (by) {
            case 1: {
                tEngine.m_2dRenderScreen.camera.setNearClip(n * 256);
                break;
            }
            case 2: {
                tEngine.m_3dRenderScreen.camera.setNearClip(n * 256);
                break;
            }
            case 3: {
                tEngine.m_MapRenderScreen.camera.setNearClip(n * 256);
            }
        }
    }

    public static final void setTreeNearClip(int n) {
        m_iTreeClipDist = n * 256;
    }

    public static final void setCameraPosition(byte by, int n, int n2, int n3) {
        switch (by) {
            case 1: {
                tEngine.m_2dRenderScreen.camera.setPosition(n, n2, n3);
                break;
            }
            case 2: {
                tEngine.m_3dRenderScreen.camera.setPosition(n, n2, n3);
                break;
            }
            case 3: {
                tEngine.m_MapRenderScreen.camera.setPosition(n, n2, n3);
            }
        }
    }

    public static final void setCameraRotation(byte by, int n, int n2) {
        switch (by) {
            case 1: {
                tEngine.m_2dRenderScreen.camera.setRotation(n, n2);
                break;
            }
            case 2: {
                tEngine.m_3dRenderScreen.camera.setRotation(n, n2);
                break;
            }
            case 3: {
                tEngine.m_MapRenderScreen.camera.setRotation(n, n2);
            }
        }
    }

    public static final void getCameraProjectedInfo(byte by, tVertex3D tVertex3D2, tProjVertex3D tProjVertex3D2) {
        switch (by) {
            case 1: {
                tEngine.m_2dRenderScreen.camera.transformVertex(tVertex3D2, tProjVertex3D2.v);
                tEngine.m_2dRenderScreen.camera.projectVertex(tProjVertex3D2.v, tProjVertex3D2);
                break;
            }
            case 2: {
                tEngine.m_3dRenderScreen.camera.transformVertex(tVertex3D2, tProjVertex3D2.v);
                tEngine.m_3dRenderScreen.camera.projectVertex(tProjVertex3D2.v, tProjVertex3D2);
                break;
            }
            case 3: {
                tEngine.m_MapRenderScreen.camera.transformVertex(tVertex3D2, tProjVertex3D2.v);
                tEngine.m_MapRenderScreen.camera.projectVertex(tProjVertex3D2.v, tProjVertex3D2);
            }
        }
    }

    public static final void getTerrainInfo(tObject3D tObject3D2, tObject3DInfo tObject3DInfo2) {
        tObject3DInfo2.type = 0;
        tMaterial3D tMaterial3D2 = tObject3D2.firstMaterial;
        while (tMaterial3D2 != null) {
            for (int i = 0; i < tMaterial3D2.triangleCount; ++i) {
                if (tMaterial3D2.triangleList[i].normal.y <= 0 || (tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[0]].x - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[2]].x) * (tObject3DInfo2.z - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[2]].z) > (tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[0]].z - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[2]].z) * (tObject3DInfo2.x - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[2]].x) || (tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[1]].x - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[0]].x) * (tObject3DInfo2.z - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[0]].z) > (tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[1]].z - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[0]].z) * (tObject3DInfo2.x - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[0]].x) || (tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[2]].x - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[1]].x) * (tObject3DInfo2.z - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[1]].z) > (tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[2]].z - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[1]].z) * (tObject3DInfo2.x - tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[1]].x)) continue;
                tObject3DInfo2.y = (tMaterial3D2.triangleList[i].normal.x >> 6) * (tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[0]].x - tObject3DInfo2.x) + (tMaterial3D2.triangleList[i].normal.y >> 6) * tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[0]].y + (tMaterial3D2.triangleList[i].normal.z >> 6) * (tObject3D2.vertexList[tMaterial3D2.triangleList[i].vertex[0]].z - tObject3DInfo2.z);
                tObject3DInfo2.y /= tMaterial3D2.triangleList[i].normal.y >> 6;
                tObject3DInfo2.normal.copy(tMaterial3D2.triangleList[i].normal);
                tObject3DInfo2.type = tMaterial3D2.type;
                return;
            }
            tMaterial3D2 = tMaterial3D2.nextMaterial;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean loadCRS(String string) {
        int n;
        InputStream inputStream = tFileMgr.getFileStream(string);
        if (inputStream == null) {
            return false;
        }
        try {
            int n2;
            byte[] byArray = new byte[3];
            tFileMgr.readData(inputStream, 0, byArray, 0, 3);
            prefixHole = new String(byArray);
            tFileMgr.readData(inputStream, 0, byArray, 0, 1);
            n = byArray[0] + 1;
            byte[] byArray2 = new byte[n];
            if (-1 == tFileMgr.readData(inputStream, 0, byArray2, 0, n)) {
                boolean bl = false;
                return bl;
            }
            golferName = new String(byArray2);
            for (n2 = 0; n2 < 18; ++n2) {
                tEngine.par[n2] = (byte)inputStream.read();
            }
            for (n2 = 0; n2 < 18; ++n2) {
                tFileMgr.readData(inputStream, 0, byArray, 0, 2);
                tEngine.dist[n2] = (short)((byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
            }
            for (n2 = 0; n2 < 4; ++n2) {
                DataInputStream dataInputStream;
                ByteArrayInputStream byteArrayInputStream;
                tFileMgr.readData(inputStream, 0, byArray, 0, 1);
                tEngine.chgType[n2] = byArray[0];
                switch (chgType[n2]) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        for (int i = 0; i < 3; ++i) {
                            tFileMgr.readData(inputStream, 0, byArray, 0, 2);
                            tEngine.chgBallX[n2][i] = ((byArray[1] & 0xFF) << 24 | (byArray[0] & 0xFF) << 16) >> 16;
                            tFileMgr.readData(inputStream, 0, byArray, 0, 2);
                            tEngine.chgBallZ[n2][i] = ((byArray[1] & 0xFF) << 24 | (byArray[0] & 0xFF) << 16) >> 16;
                        }
                        tFileMgr.readData(inputStream, 0, byArray, 0, 3);
                        tEngine.chgHoles[n2][0] = byArray[0];
                        tEngine.chgHoles[n2][1] = byArray[1];
                        tEngine.chgHoles[n2][2] = byArray[2];
                        tFileMgr.readData(inputStream, 0, byArray, 0, 1);
                        tEngine.chgVicCond1[n2] = byArray[0];
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < 3; ++i) {
                            tFileMgr.readData(inputStream, 0, byArray, 0, 2);
                            tEngine.chgBallX[n2][i] = ((byArray[1] & 0xFF) << 24 | (byArray[0] & 0xFF) << 16) >> 16;
                            tFileMgr.readData(inputStream, 0, byArray, 0, 2);
                            tEngine.chgBallZ[n2][i] = ((byArray[1] & 0xFF) << 24 | (byArray[0] & 0xFF) << 16) >> 16;
                        }
                        tFileMgr.readData(inputStream, 0, byArray, 0, 3);
                        tEngine.chgHoles[n2][0] = byArray[0];
                        tEngine.chgHoles[n2][1] = byArray[1];
                        tEngine.chgHoles[n2][2] = byArray[2];
                        tFileMgr.readData(inputStream, 0, byArray, 0, 3);
                        tEngine.chgInitCond[n2][0] = byArray[0];
                        tEngine.chgInitCond[n2][1] = byArray[1];
                        tEngine.chgInitCond[n2][2] = byArray[2];
                        tFileMgr.readData(inputStream, 0, byArray, 0, 1);
                        tEngine.chgVicCond1[n2] = byArray[0];
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < 3; ++i) {
                            tEngine.chgBallX[n2][i] = 0;
                            tEngine.chgBallZ[n2][i] = 0;
                        }
                        tFileMgr.readData(inputStream, 0, byArray, 0, 3);
                        tEngine.chgHoles[n2][0] = byArray[0];
                        tEngine.chgHoles[n2][1] = byArray[1];
                        tEngine.chgHoles[n2][2] = byArray[2];
                        tFileMgr.readData(inputStream, 0, byArray, 0, 1);
                        tEngine.chgVicCond1[n2] = byArray[0];
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < 3; ++i) {
                            tEngine.chgBallX[n2][i] = 0;
                            tEngine.chgBallZ[n2][i] = 0;
                        }
                        tEngine.chgHoles[n2][0] = 0;
                        tEngine.chgHoles[n2][1] = 0;
                        tEngine.chgHoles[n2][2] = 0;
                        tFileMgr.readData(inputStream, 0, byArray, 0, 2);
                        tEngine.chgVicCond1[n2] = byArray[0];
                        tEngine.chgVicCond2[n2] = byArray[1];
                        break;
                    }
                    default: {
                        boolean bl = false;
                        return bl;
                    }
                }
                tFileMgr.readData(inputStream, 0, byArray, 0, 2);
                n = (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
                byte[] byArray3 = new byte[n + 2];
                byArray3[0] = (byte)((byArray[1] & 0xFF) << 8);
                byArray3[1] = (byte)(byArray[0] & 0xFF);
                if (-1 != tFileMgr.readData(inputStream, 0, byArray3, 2, n)) {
                    byteArrayInputStream = new ByteArrayInputStream(byArray3);
                    dataInputStream = new DataInputStream(byteArrayInputStream);
                    try {
                        tEngine.chgText[n2] = dataInputStream.readUTF();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                } else {
                    boolean bl = false;
                    return bl;
                }
                dataInputStream = null;
                byteArrayInputStream = null;
                byArray3 = null;
            }
        }
        catch (Exception exception) {
            n = 0;
            return n != 0;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                inputStream = null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean loadGRS(String string) {
        int n;
        InputStream inputStream = tFileMgr.getFileStream(string);
        if (inputStream == null) {
            return false;
        }
        try {
            byte[] byArray = new byte[3];
            tFileMgr.readData(inputStream, 0, byArray, 0, 1);
            n = byArray[0] + 1;
            byte[] byArray2 = new byte[n];
            if (-1 == tFileMgr.readData(inputStream, 0, byArray2, 0, n)) {
                boolean bl = false;
                return bl;
            }
            golferName = new String(byArray2);
            tFileMgr.readData(inputStream, 0, byArray, 0, 2);
            prefixAnim = new String(byArray, 0, 2);
        }
        catch (Exception exception) {
            n = 0;
            return n != 0;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
                inputStream = null;
            }
        }
        return true;
    }
}

