/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import ca.jamdat.flight.SoundManager;
import ca.jamdat.flight.SoundPlayer;
import ca.jamdat.flight.VibrationManager;
import com.ea.sdk.ResourceLoader;
import com.ea.sdk.SDKImpl;
import com.ea.sdk.SoundInfo;
import java.util.Vector;

public class SDKSoundManager {
    public static final int IMMEDIATE_PLAYBACK = 0;
    public static final int IGNORE_PLAYBACK = 1;
    public static final int LOOP_FOREVER = -1;
    public ResourceLoader loader;
    public SoundPlayer mSoundPlayer = SoundManager.Get().GetChannelSoundPlayer(0);
    public Vector mPlayer = new Vector();
    public boolean mSoundEnabled = true;
    public int mType = 0;
    public int mCurrentSoundID = -1;

    public static SDKSoundManager getManager() {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        if (sDKImpl.mSoundManager == null) {
            sDKImpl.mSoundManager = new SDKSoundManager();
        }
        return sDKImpl.mSoundManager;
    }

    public void setLoader(ResourceLoader resourceLoader) {
        this.loader = resourceLoader;
    }

    public void loadSound(int n) {
        if (this.getSoundIndex(n) != -1) {
            return;
        }
        byte[] byArray = this.loader.loadResource(n);
        SoundInfo soundInfo = new SoundInfo(byArray, n);
        this.mPlayer.addElement(soundInfo);
    }

    public void unloadSound(int n) {
        int n2 = this.getSoundIndex(n);
        if (n2 != -1) {
            SoundInfo soundInfo = (SoundInfo)this.mPlayer.elementAt(n2);
            this.mPlayer.removeElementAt(n2);
            soundInfo = null;
        }
    }

    public boolean isVibrationSupported() {
        return true;
    }

    public boolean isVibrationDurationSupported() {
        return true;
    }

    public boolean isSoundEnabled() {
        return this.mSoundEnabled;
    }

    public void setSoundEnabled(boolean bl) {
        this.mSoundEnabled = bl;
        if (!bl) {
            this.stopSounds();
        }
    }

    public int getSoundVolume() {
        return this.mSoundPlayer.GetVolume() * 100 / 255;
    }

    public void setSoundVolume(int n) {
        this.mSoundPlayer.SetVolume((short)(255 * n / 100));
    }

    public void setCurrentLoop(int n) {
        this.setIsLooping(n != 0 && n != 1);
    }

    public void setIsLooping(boolean bl) {
        this.mSoundPlayer.SetLooping(bl);
    }

    public void setPlaybackType(int n) {
        this.mType = n;
    }

    public void playSound(int n) {
        if (!this.mSoundEnabled) {
            return;
        }
        if (this.mType != 1 || !this.mSoundPlayer.IsPlaying()) {
            this.stopSounds();
            this.loadSound(n);
            this.startSound(n);
        }
    }

    public void stopSound(int n) {
        if (this.mCurrentSoundID == n) {
            this.mSoundPlayer.Stop();
        }
    }

    public void stopSounds() {
        if (this.mCurrentSoundID == -1) {
            return;
        }
        this.stopSound(this.mCurrentSoundID);
    }

    public void vibrate(int n) {
        if (this.isVibrationSupported()) {
            if (n == 0) {
                if (!this.isVibrationDurationSupported()) {
                    return;
                }
                VibrationManager.Get().Stop();
            } else {
                VibrationManager.Get().Start(n);
            }
        }
    }

    public void unloadCachedSound(int n) {
    }

    public void destruct() {
    }

    public void startSound(int n) {
        if (n != this.mCurrentSoundID) {
            int n2 = this.getSoundIndex(n);
            SoundInfo soundInfo = (SoundInfo)this.mPlayer.elementAt(n2);
            this.mSoundPlayer.SetSound(soundInfo.mSound);
            this.mCurrentSoundID = n;
        }
        this.mSoundPlayer.Play();
    }

    public int getSoundIndex(int n) {
        for (int i = 0; i < this.mPlayer.size(); ++i) {
            SoundInfo soundInfo = (SoundInfo)this.mPlayer.elementAt(i);
            if (soundInfo.mSoundID != n) continue;
            return i;
        }
        return -1;
    }

    public static SDKSoundManager[] InstArraySDKSoundManager(int n) {
        SDKSoundManager[] sDKSoundManagerArray = new SDKSoundManager[n];
        for (int i = 0; i < n; ++i) {
            sDKSoundManagerArray[i] = new SDKSoundManager();
        }
        return sDKSoundManagerArray;
    }

    public static SDKSoundManager[][] InstArraySDKSoundManager(int n, int n2) {
        SDKSoundManager[][] sDKSoundManagerArray = new SDKSoundManager[n][];
        for (int i = 0; i < n; ++i) {
            sDKSoundManagerArray[i] = new SDKSoundManager[n2];
            for (int j = 0; j < n2; ++j) {
                sDKSoundManagerArray[i][j] = new SDKSoundManager();
            }
        }
        return sDKSoundManagerArray;
    }

    public static SDKSoundManager[][][] InstArraySDKSoundManager(int n, int n2, int n3) {
        SDKSoundManager[][][] sDKSoundManagerArray = new SDKSoundManager[n][][];
        for (int i = 0; i < n; ++i) {
            sDKSoundManagerArray[i] = new SDKSoundManager[n2][];
            for (int j = 0; j < n2; ++j) {
                sDKSoundManagerArray[i][j] = new SDKSoundManager[n3];
                for (int k = 0; k < n3; ++k) {
                    sDKSoundManagerArray[i][j][k] = new SDKSoundManager();
                }
            }
        }
        return sDKSoundManagerArray;
    }
}

