/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import ca.jamdat.flight.FlBrowser;
import com.ea.sdk.SDKConfig;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKKeys;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKMoreGames16;
import com.ea.sdk.SDKMoreGames16Override;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import javax.microedition.lcdui.Font;

public class SDKMoreGames
implements SDKKeys {
    private SDKMoreGames16 SDKMoreGames16Obj;
    public static final int NORMAL_FONT = 0;
    public static final int UNSELECTED_BUTTON_FONT = 1;
    public static final int SELECTED_BUTTON_FONT = 2;
    public static final int SOFTKEY_FONT = 3;
    public static final int TITLE_FONT = 4;
    public static final int FONT_COUNT = 5;
    public static final String CONTEXT_MAIN_MENU = "mnu";
    public static final String CONTEXT_END_GAME = "end";
    public static final String CONTEXT_HALF_TIME = "hlf";
    private static final byte BINARY_FORMAT_MARKER = 0;
    private static final byte IMPL_OFF = 0;
    private static final byte IMPL_STATIC = 1;
    private static final byte IMPL_WAP = 2;
    private static final byte IMPL_WAPSTATIC = 3;
    private static final String STR_GENERIC_ID = "LOG";
    private static final int GENERIC_INDEX = -1;
    private static final int INVALID_INDEX = -2;
    private static final String STR_MG_PRODUCTS = "MG_PRODUCTS";
    private static final String STR_MG_IMPL = "MG_Impl";
    private static final String STR_MG_BUYURI = "MG_BUYURI_";
    private static final String STR_MG_CATURI = "MG_CATURI_";
    private static final String STR_IMPL_OFF = "off";
    private static final String STR_IMPL_STATIC = "static";
    private static final String STR_IMPL_WAP = "wap";
    private static final String STR_IMPL_WAP_STATIC = "wapstatic";
    private static final int STATE_MAIN = 0;
    private static final int STATE_CONFIRM = 1;
    private static final int STATE_STATIC = 2;
    private static final int BUTTON_BUY = 0;
    private static final int BUTTON_MORE = 1;
    private static final int BUTTON_NONE = 2;
    private static final char SEPARATOR = ',';
    private static final byte SPACE_V_SOFTKEY_PADDING = 0;
    private static final byte SPACE_V_ABOVE_SOFTKEYS = 2;
    private static final byte SPACE_V_BETWEEN_BUTTONS = 2;
    private static final byte SPACE_V_ABOVE_BUTTONS = 2;
    private static final byte SPACE_V_BUTTON_TOP_PADDING = 2;
    private static final byte SPACE_V_BUTTON_BOTTOM_PADDING = 3;
    private static final byte SPACE_V_BELOW_HEADER = 1;
    private static final byte SPACE_V_TITLE_PADDING = 1;
    private static final byte ANIM_MAX = SDKConfig.getMoreGamesArrowAnimMax();
    private static final byte SPACE_ARROW_SIZE = SDKConfig.getMoreGamesArrowSize();
    private static final byte SPACE_H_ARROW_SPACING = 1;
    private static final byte SPACE_H_ARROW_AREA = (byte)(0 + SPACE_ARROW_SIZE + ANIM_MAX);
    private static final byte SPACE_H_STATIC_PADDING = 10;
    private static final byte SPACE_H_BUTTON_DECORATION_SPACING = 3;
    private static final byte SPACE_H_BUTTON_PADDING = 6;
    private static final byte SPACE_H_TEXT = 2;
    private static final int COLOR_BACKGROUND = -1;
    private static final int COLOR_HEADER_BG = -16757361;
    private static final int COLOR_BLUE = -16757361;
    private static final int COLOR_LIGHTBLUE = -9462329;
    private static final int COLOR_BLACK = -16777216;
    private static final int STRING_COUNT = 11;
    private static final int STRING_STATIC = 0;
    private static final int STRING_GENERIC = 1;
    private static final int STRING_GENERIC_BTN = 2;
    private static final int STRING_GENERIC_NAME = 3;
    private static final int STRING_CONFIRM = 4;
    private static final int STRING_SELECT = 5;
    private static final int STRING_BACK = 6;
    private static final int STRING_YES = 7;
    private static final int STRING_NO = 8;
    private static final int STRING_TITLE = 9;
    private static final int STRING_BUY = 10;
    private static final boolean WAP_SUPPORTED = true;
    private static final String CLASS_NAME = "SDKMoreGames";
    private static final byte CHEAT_STATE_NO_CHEAT = -1;
    private static final byte CHEAT_STATE_OFF = 0;
    private static final byte CHEAT_STATE_STATIC = 1;
    private static final byte CHEAT_STATE_WAP = 2;
    private static final byte CHEAT_STATE_WAPSTATIC = 3;
    private static final byte CHEAT_STATE_ABSENT = 2;
    private static final byte CHEAT_TYPE_IMPLEMENTATION = 0;
    private static final byte CHEAT_TYPE_CATURI = 1;
    private static final byte CHEAT_TYPE_BUYURI = 2;
    private static final byte CHEAT_TYPE_PRODUCT_COUNT = 3;
    private static final byte CHEAT_TYPE_PRODUCT_ORDER = 4;
    private static final byte CHEATS_COUNT = 5;
    private static final byte[] cheatsStatus = new byte[5];
    private static boolean cheatsEnabled;
    private static final int CHEAT_STATE_CODE = 0;
    private static final int CHEAT_STATE_VALUE = 1;
    private static final short CHEAT_SEQ_PRODUCTS_NO = -26472;
    private static final short CHEAT_SEQ_PRODUCTS_ORDER = -26461;
    private static final short CHEAT_SEQ_IMPL = -26475;
    private static final short CHEAT_SEQ_CATURI = -26473;
    private static final short CHEAT_SEQ_BUYURI = -26476;
    private short keySequence;
    private int currentCheatState = 0;
    private int currentCheat = -1;
    private static final byte POINTER_MIN_SIZE = 40;
    private int keyState;
    private boolean drawSoftKeys = true;
    private SDKString lskText;
    private SDKString rskText;
    private SDKMIDlet sdkMidlet;
    private Object[] fonts;
    private boolean active;
    SDKImage currentImage;
    private int currentIndex;
    private int currentGameID;
    private String currentURI;
    private int currentButton = 0;
    private boolean buyButtonEnabled = true;
    private boolean catButtonEnabled = true;
    private String[] productIDs;
    private short[] productNames;
    private short[] productCategories;
    private short[] productTags;
    private int[] gameOrder;
    private String[] buyUris;
    private String[] catUris;
    private int mode = 0;
    private int state = 0;
    private boolean drawHeader;
    private short[] staticWrap;
    private short[] confirmWrap;
    private short[] tagWrap;
    private SDKString currentTag;
    private SDKString currentName;
    private SDKString currentCtg;
    private int headerSize;
    private int buttonWidth;
    private int anim = ANIM_MAX;
    private int layoutImageY;
    private int layoutArrowY;
    private int layoutTagY;
    private int layoutBuyButtonY;
    private int layoutCatButtonY;
    private int layoutSoftkeySize;
    private short[] stringIDs = new short[11];
    private SDKString[] strings = new SDKString[11];
    private int screenHeight = -1;
    private int screenWidth = -1;
    public static final byte RESULT_OK = 0;
    public static final byte RESULT_REFRESH_MENU = 1;
    private int initialColor;

    public SDKMoreGames(int n, int n2) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            if (SDKConfig.getDebugEnabled() && (n <= 0 || n2 <= 0)) {
                SDKUtils.debugLog("SDKMoreGames::constructor was called with zero or negative screen size. Aborting...", 4);
            }
            this.screenWidth = n;
            this.screenHeight = n2;
            if (SDKConfig.getMoreGamesCheatsEnabled()) {
                for (int i = 0; i < cheatsStatus.length; ++i) {
                    SDKMoreGames.cheatsStatus[i] = -1;
                }
            }
        } else {
            this.SDKMoreGames16Obj = new SDKMoreGames16Override(this, n, n2);
        }
    }

    public SDKImage getImage(String string) {
        return null;
    }

    public final void setScreenSize(int n, int n2) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            if (SDKConfig.getDebugEnabled() && (n <= 0 || n2 <= 0)) {
                SDKUtils.debugLog("SDKMoreGamessetScreenSize:: was called with zero or negative screen size. Aborting...", 4);
            }
            boolean bl = n != this.screenWidth || n2 != this.screenHeight;
            this.screenWidth = n;
            this.screenHeight = n2;
            if (this.active && bl) {
                this.doLayout();
            }
        } else {
            this.SDKMoreGames16Obj.setScreenSize(n, n2);
        }
    }

    public void reset() {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            if (SDKConfig.getDebugEnabled()) {
                if (this.productNames == null || this.productCategories == null || this.productTags == null) {
                    SDKUtils.debugLog("SDKMoreGamesreset:: was called before seting the product data. Aborting...", 4);
                }
                if (!this.isAvailable()) {
                    SDKUtils.debugLog("SDKMoreGamesreset:: was called even though MoreGames is unavailable. Aborting...", 4);
                }
                if (this.fonts == null) {
                    SDKUtils.debugLog("SDKMoreGamesreset:: was called before the fonts were set. Aborting...", 4);
                }
            }
            if (this.gameOrder == null || SDKConfig.getMoreGamesCheatsEnabled() && cheatsEnabled) {
                this.initialize();
            }
            for (int i = 0; i < this.strings.length; ++i) {
                this.strings[i] = SDKUtils.getString(this.stringIDs[i], null);
            }
            this.currentIndex = 0;
            this.active = true;
            this.state = 0;
            this.selectGame(0);
            SDKUtils.setFont(this.fonts[0]);
            this.staticWrap = SDKUtils.wrapString(this.strings[0], null, this.screenWidth - 10, (short)124);
            this.confirmWrap = SDKUtils.wrapString(this.strings[4], null, this.screenWidth - 10, (short)124);
        }
    }

    public void reset(String string) {
        if (!SDKConfig.getSDKMoreGamesVersionIs15()) {
            this.SDKMoreGames16Obj.reset(string);
        }
    }

    public final void update() {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            switch (this.state) {
                case 0: {
                    if ((this.keyState & 0x804) != 0 && this.gameOrder.length > 0) {
                        --this.currentIndex;
                        if (this.currentIndex < 0) {
                            this.currentIndex = this.gameOrder.length - 1;
                        }
                        this.currentGameID = this.gameOrder[this.currentIndex];
                        this.selectGame(this.currentIndex);
                        break;
                    }
                    if ((this.keyState & 0x2008) != 0 && this.gameOrder.length > 0) {
                        ++this.currentIndex;
                        this.currentIndex %= this.gameOrder.length;
                        this.currentGameID = this.gameOrder[this.currentIndex];
                        this.selectGame(this.currentIndex);
                        break;
                    }
                    if (((this.keyState & 0x201) != 0 || (this.keyState & 0x8002) != 0) && this.gameOrder.length > 0 && this.buyButtonEnabled && this.catButtonEnabled) {
                        if (this.currentButton == 1) {
                            this.currentButton = 0;
                            break;
                        }
                        this.currentButton = 1;
                        break;
                    }
                    if ((this.keyState & 0x80040) != 0) {
                        this.active = false;
                        break;
                    }
                    if ((this.keyState & 0x1030) == 0) break;
                    if (this.currentButton == 0) {
                        this.currentURI = this.buyUris[this.currentIndex];
                        this.confirmBrowserLaunch();
                        break;
                    }
                    if (this.currentButton != 1) break;
                    if (this.mode == 1 || this.mode == 3 && (this.catUris[this.currentIndex] == null || this.catUris[this.currentIndex].compareTo("") == 0)) {
                        this.setLeftSoftkeyText(null);
                        this.setRightSoftkeyText(this.strings[6]);
                        this.state = 2;
                        break;
                    }
                    this.currentURI = this.catUris[this.currentIndex];
                    this.confirmBrowserLaunch();
                    break;
                }
                case 1: {
                    if ((this.keyState & 0x80040) != 0) {
                        this.setLeftSoftkeyText(this.strings[5]);
                        this.setRightSoftkeyText(this.strings[6]);
                        this.state = 0;
                        break;
                    }
                    if ((this.keyState & 0x20) == 0) break;
                    this.applicationWillExit();
                    this.platformRequestImpl(this.currentURI);
                    break;
                }
                case 2: {
                    if ((this.keyState & 0x80040) == 0) break;
                    this.setLeftSoftkeyText(this.strings[5]);
                    this.setRightSoftkeyText(this.strings[6]);
                    this.state = 0;
                }
            }
            this.keyState = 0;
        } else {
            this.SDKMoreGames16Obj.update();
        }
    }

    public final boolean isActive() {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            return this.active;
        }
        return this.SDKMoreGames16Obj.isActive();
    }

    public final void paint(SDKGraphics sDKGraphics) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            this.drawBackground(sDKGraphics);
            switch (this.state) {
                case 0: {
                    --this.anim;
                    if (this.anim < 0) {
                        this.anim = ANIM_MAX;
                    }
                    if (this.drawHeader) {
                        sDKGraphics.setColor(-16757361);
                        SDKUtils.setFont(this.fonts[4]);
                        sDKGraphics.fillRect(0, 0, this.screenWidth, this.headerSize);
                        sDKGraphics.setColor(this.initialColor);
                        SDKUtils.drawString(this.strings[9], this.screenWidth >> 1, 1, 17);
                    }
                    if (this.currentImage != null) {
                        sDKGraphics.drawImage(this.currentImage, this.screenWidth >> 1, this.layoutImageY, 17);
                        if (this.gameOrder.length > 1) {
                            this.drawLeftArrow(sDKGraphics, (this.screenWidth - this.currentImage.getWidth() >> 2) - (SPACE_ARROW_SIZE >> 1), this.layoutArrowY);
                            this.drawRightArrow(sDKGraphics, this.screenWidth - (this.screenWidth - this.currentImage.getWidth() >> 2) + (SPACE_ARROW_SIZE >> 1), this.layoutArrowY);
                        }
                        SDKUtils.setFont(this.fonts[0]);
                        SDKUtils.drawWrappedString(this.currentTag, this.tagWrap, 1, this.tagWrap[0], this.screenWidth >> 1, this.layoutTagY, 17);
                    } else {
                        SDKUtils.setFont(this.fonts[0]);
                        SDKUtils.drawString(this.currentName, this.screenWidth >> 1, this.layoutImageY, 17);
                        SDKUtils.drawWrappedString(this.currentTag, this.tagWrap, 1, this.tagWrap[0], this.screenWidth >> 1, this.layoutTagY, 17);
                        if (this.gameOrder.length > 1) {
                            this.drawLeftArrow(sDKGraphics, 1, this.layoutArrowY);
                            this.drawRightArrow(sDKGraphics, this.screenWidth - 1, this.layoutArrowY);
                        }
                    }
                    if (this.buyButtonEnabled) {
                        this.draw3DButton(sDKGraphics, this.layoutBuyButtonY, this.buttonWidth, this.strings[10], this.currentButton == 0);
                    }
                    if (!this.catButtonEnabled) break;
                    this.draw3DButton(sDKGraphics, this.layoutCatButtonY, this.buttonWidth, this.currentCtg, this.currentButton == 1);
                    break;
                }
                case 2: {
                    SDKUtils.setFont(this.fonts[0]);
                    SDKUtils.drawWrappedString(this.strings[0], this.staticWrap, 1, this.staticWrap[0], this.screenWidth >> 1, this.screenHeight - this.layoutSoftkeySize >> 1, 3);
                    break;
                }
                case 1: {
                    SDKUtils.setFont(this.fonts[0]);
                    SDKUtils.drawWrappedString(this.strings[4], this.confirmWrap, 1, this.confirmWrap[0], this.screenWidth >> 1, this.screenHeight - this.layoutSoftkeySize >> 1, 3);
                }
            }
            if (this.drawSoftKeys) {
                SDKUtils.setFont(this.fonts[3]);
                if (this.lskText != null) {
                    SDKUtils.drawString(this.lskText, 2, this.screenHeight + SDKUtils.getLeadingSpacing() - 2, 36);
                }
                if (this.rskText != null) {
                    SDKUtils.drawString(this.rskText, this.screenWidth - 2, this.screenHeight + SDKUtils.getLeadingSpacing() - 2, 40);
                }
            }
        } else {
            this.SDKMoreGames16Obj.paint(sDKGraphics);
        }
    }

    public final void setFonts(Object[] objectArray) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            if (SDKConfig.getDebugEnabled()) {
                if (objectArray != null) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (objectArray[i] == null) {
                            SDKUtils.debugLog("SDKMoreGamessetFonts:: invalid parameter. The fonts must NOT be null.", 4);
                            continue;
                        }
                        if (objectArray[i] instanceof Object[] && (SDKConfig.getBitmapFontSupport() || SDKConfig.getRectangleFontSupport()) || objectArray[i] instanceof Font && SDKConfig.getSystemFontSupport()) continue;
                        SDKUtils.debugLog("SDKMoreGamessetFonts:: invalid parameter. One of the objects in the fonts array (index " + i + ") does not appear to be a font", 3);
                    }
                } else {
                    SDKUtils.debugLog("SDKMoreGamessetFonts:: invalid parameter. The font array is NULL.", 4);
                }
            }
            this.fonts = objectArray;
        } else {
            this.SDKMoreGames16Obj.setFonts(objectArray);
        }
    }

    public byte processKey(int n) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            if (SDKConfig.getMoreGamesCheatsEnabled()) {
                if (this.active) {
                    this.keyState |= this.translateCode(n);
                } else {
                    byte by = this.getKeyNumber(n);
                    if (by == -1) {
                        this.keySequence = 0;
                        this.currentCheatState = 0;
                    } else if (this.currentCheatState == 0) {
                        this.keySequence = (short)(this.keySequence << 4);
                        this.keySequence = (short)(this.keySequence | by + 1);
                        if (this.keySequence == -26472) {
                            this.currentCheat = 3;
                            this.currentCheatState = 1;
                        } else {
                            if (this.keySequence == -26461) {
                                SDKMoreGames.cheatsStatus[4] = 1;
                                cheatsEnabled = true;
                                this.keySequence = 0;
                                if (SDKConfig.getDebugEnabled()) {
                                    SDKUtils.debugLog("SDKMoreGamesprocessKey::Activated cheat type=4", 1);
                                }
                                return 1;
                            }
                            if (this.keySequence == -26475) {
                                this.currentCheat = 0;
                                this.currentCheatState = 1;
                            } else if (this.keySequence == -26473) {
                                this.currentCheat = 1;
                                this.currentCheatState = 1;
                            } else if (this.keySequence == -26476) {
                                this.currentCheat = 2;
                                this.currentCheatState = 1;
                            }
                        }
                    } else if (this.currentCheatState == 1) {
                        boolean bl = false;
                        if (this.currentCheat == 0) {
                            bl = by < 0 || by > 3;
                        } else if (this.currentCheat == 2 || this.currentCheat == 1) {
                            boolean bl2 = bl = by < 0 || by > 2;
                        }
                        if (!bl) {
                            SDKMoreGames.cheatsStatus[this.currentCheat] = by;
                            cheatsEnabled = true;
                            if (SDKConfig.getDebugEnabled()) {
                                SDKUtils.debugLog("SDKMoreGamesprocessKey::Activated cheat type=" + this.currentCheat + ", value=" + by, 1);
                            }
                        }
                        this.currentCheatState = 0;
                        this.keySequence = 0;
                        return 1;
                    }
                }
                return 0;
            }
            if (this.active) {
                this.keyState |= this.translateCode(n);
            }
            return 0;
        }
        return this.SDKMoreGames16Obj.processKey(n);
    }

    public final void setProductData(byte[] byArray) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            int n;
            int n2;
            int n3;
            if (SDKConfig.getDebugEnabled() && byArray[0] != 0) {
                SDKUtils.debugLog("SDKMoreGamessetProductData::Binary format version for the moregames data is incorrect. expected=0, actual=" + byArray[0], 4);
            }
            int n4 = 1;
            int n5 = byArray[n4++];
            this.productIDs = new String[n5];
            this.productNames = new short[n5];
            this.productCategories = new short[n5];
            this.productTags = new short[n5];
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = byArray[n4++];
                this.productIDs[n3] = new String(byArray, n4, n2);
                n4 += n2;
            }
            n3 = n5 << 1;
            n2 = n5 << 2;
            for (n = 0; n < n5; ++n) {
                this.productNames[n] = SDKUtils.bytesToShort(byArray, n4);
                this.productCategories[n] = SDKUtils.bytesToShort(byArray, n4 + n3);
                this.productTags[n] = SDKUtils.bytesToShort(byArray, n4 + n2);
                n4 += 2;
            }
            n4 += n2;
            for (n = 0; n < this.strings.length; ++n) {
                this.stringIDs[n] = SDKUtils.bytesToShort(byArray, n4);
                n4 += 2;
            }
        } else {
            this.SDKMoreGames16Obj.setProductData(byArray);
        }
    }

    public final void setDrawSoftKeys(boolean bl) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            this.drawSoftKeys = bl;
        } else {
            this.SDKMoreGames16Obj.setDrawSoftKeys(bl);
        }
    }

    public boolean isAvailable() {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            if (this.gameOrder == null || SDKConfig.getMoreGamesCheatsEnabled() && cheatsEnabled) {
                this.initialize();
            }
            return this.mode != 0;
        }
        return this.SDKMoreGames16Obj.isAvailable();
    }

    protected void drawBackground(SDKGraphics sDKGraphics) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            sDKGraphics.setClip(0, 0, this.screenWidth, this.screenHeight);
            sDKGraphics.setColor(-1);
            sDKGraphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        } else {
            this.SDKMoreGames16Obj.drawBackground(sDKGraphics);
        }
    }

    protected void applicationWillExit() {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            // empty if block
        }
    }

    protected void setLeftSoftkeyText(SDKString sDKString) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            this.lskText = sDKString;
        } else {
            this.SDKMoreGames16Obj.setLSKText(sDKString);
        }
    }

    protected void setRightSoftkeyText(SDKString sDKString) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            this.rskText = sDKString;
        } else {
            this.SDKMoreGames16Obj.setRSKText(sDKString);
        }
    }

    protected void platformRequestImpl(String string) {
        SDKUtils.platformRequest(string);
    }

    private void confirmBrowserLaunch() {
        if (FlBrowser.GetInstance().LaunchURIWillExit(false)) {
            this.setLeftSoftkeyText(this.strings[7]);
            this.setRightSoftkeyText(this.strings[8]);
            this.state = 1;
        } else {
            this.platformRequestImpl(this.currentURI);
        }
    }

    private void doLayout() {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            int n;
            this.buttonWidth = (this.screenWidth << 2) / 5;
            int n2 = this.screenHeight;
            this.layoutSoftkeySize = 0;
            if (this.drawSoftKeys) {
                SDKUtils.setFont(this.fonts[3]);
                this.layoutSoftkeySize = SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() + 0 + 0;
                n2 -= this.layoutSoftkeySize;
            }
            n2 -= 2;
            if (this.catButtonEnabled) {
                n2 -= 5;
                if (this.currentButton == 1) {
                    SDKUtils.setFont(this.fonts[2]);
                } else {
                    SDKUtils.setFont(this.fonts[1]);
                }
                this.layoutCatButtonY = n2 -= SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
                n = SDKUtils.getStringSize(this.currentCtg) + 6 + SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() + 6;
                if (n > this.buttonWidth) {
                    this.buttonWidth = n;
                }
            }
            if (this.buyButtonEnabled) {
                n2 -= 5;
                if (this.currentButton == 0) {
                    SDKUtils.setFont(this.fonts[2]);
                } else {
                    SDKUtils.setFont(this.fonts[1]);
                }
                this.layoutBuyButtonY = n2 -= SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
                n = SDKUtils.getStringSize(this.strings[10]) + 6 + SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() + 6;
                if (n > this.buttonWidth) {
                    this.buttonWidth = n;
                }
            }
            if (this.catButtonEnabled && this.buyButtonEnabled) {
                this.layoutBuyButtonY = n2 -= 2;
            }
            n2 -= 2;
            if (this.currentImage != null) {
                SDKUtils.setFont(this.fonts[0]);
                this.tagWrap = SDKUtils.wrapString(this.currentTag, null, this.screenWidth - 2, (short)124);
                this.layoutTagY = n2 -= this.tagWrap[0] * SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
                this.layoutImageY = n2 -= this.currentImage.getHeight();
                this.layoutArrowY = this.layoutImageY + (this.currentImage.getHeight() >> 1);
            } else {
                SDKUtils.setFont(this.fonts[0]);
                this.tagWrap = SDKUtils.wrapString(this.currentTag, null, this.screenWidth - (SPACE_H_ARROW_AREA >> 1), (short)124);
                this.layoutTagY = n2 -= this.tagWrap[0] * SDKUtils.getLineSize();
                this.layoutImageY = n2 -= SDKUtils.getLineSize();
                this.layoutArrowY = this.layoutImageY + (SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() >> 1);
            }
            SDKUtils.setFont(this.fonts[4]);
            this.headerSize = SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() + 1 + 1;
            if (--n2 >= this.headerSize) {
                this.drawHeader = true;
                n2 -= this.headerSize;
            } else {
                this.drawHeader = false;
            }
            if (n2 <= 0) {
                n2 = 0;
            } else {
                n = n2 * 3 / 10;
                int n3 = n2 >> 2;
                int n4 = n2 >> 2;
                this.layoutImageY -= n2 - n;
                this.layoutArrowY -= n2 - n;
                this.layoutTagY -= n2 - n - n3;
                this.layoutBuyButtonY -= n2 - n - n3 - n4;
                this.layoutCatButtonY -= n2 - n - n3 - n4;
            }
        }
    }

    private void initialize() {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            int n;
            int n2;
            String string;
            this.sdkMidlet = SDKMIDlet.getInstance();
            if (SDKConfig.getDebugEnabled() && this.sdkMidlet == null) {
                SDKUtils.debugLog("SDKMoreGamesinitialize::called before the sdkMidlet is set. Aborting...", 4);
            }
            if ((string = this.getAppPropertyWrap(STR_MG_IMPL)) == null) {
                this.mode = 0;
                return;
            }
            String string2 = string.toLowerCase();
            if (string2.equals(STR_IMPL_STATIC)) {
                this.mode = 1;
            } else {
                if (string2.equals(STR_IMPL_WAP_STATIC)) {
                    // empty if block
                }
                if (string2.equals(STR_IMPL_WAP)) {
                    this.mode = 2;
                } else if (string2.equals(STR_IMPL_WAP_STATIC)) {
                    this.mode = 3;
                } else {
                    this.mode = 0;
                    return;
                }
            }
            String string3 = this.getAppPropertyWrap(STR_MG_PRODUCTS);
            if (string3 == null || string3.length() == 0) {
                if (SDKConfig.getDebugEnabled()) {
                    SDKUtils.debugLog("SDKMoreGamesinitialize::MG_PRODUCTS property in the JAD file is not set or could not be read. More Games will be disabled.", 3);
                }
                this.mode = 0;
                return;
            }
            int n3 = 0;
            int n4 = -1;
            do {
                n2 = string3.indexOf(44, n4 + 1);
                String string4 = null;
                string4 = n2 == -1 ? string3.substring(n4 + 1) : string3.substring(n4 + 1, n2);
                n4 = n2;
                if (string4.equals(STR_GENERIC_ID)) {
                    ++n3;
                    continue;
                }
                boolean bl = false;
                for (n = 0; n < this.productIDs.length; ++n) {
                    if (!this.productIDs[n].equals(string4)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                ++n3;
            } while (n2 != -1);
            if (n3 == 0) {
                if (SDKConfig.getDebugEnabled()) {
                    SDKUtils.debugLog("SDKMoreGamesinitialize::Found no valid advertised items in the JAD (MG_PRODUCTS property). More Games will be disabled.", 3);
                }
                this.mode = 0;
            }
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog("SDKMoreGamesinitialize::Found " + n3 + " advertised items", 1);
            }
            this.gameOrder = new int[n3];
            this.buyUris = new String[n3];
            this.catUris = new String[n3];
            n4 = -1;
            for (n2 = 0; n2 < this.gameOrder.length; ++n2) {
                int n5 = string3.indexOf(44, n4 + 1);
                String string5 = null;
                string5 = n5 == -1 ? string3.substring(n4 + 1) : string3.substring(n4 + 1, n5);
                n4 = n5;
                if (string5.equals(STR_GENERIC_ID)) {
                    this.gameOrder[n2] = -1;
                    this.buyUris[n2] = null;
                    this.catUris[n2] = this.getAppPropertyWrap("MG_CATURI_LOG");
                    if (this.catUris[n2] != null) {
                        this.catUris[n2] = this.catUris[n2].trim();
                    }
                    if (!SDKConfig.getDebugEnabled()) continue;
                    SDKUtils.debugLog("SDKMoreGamesinitialize::Found Generic Category. CATURI=" + this.catUris[n2], 1);
                    continue;
                }
                this.gameOrder[n2] = -2;
                this.buyUris[n2] = null;
                this.catUris[n2] = null;
                for (n = 0; n < this.productIDs.length; ++n) {
                    if (!this.productIDs[n].equals(string5)) continue;
                    this.gameOrder[n2] = n;
                    this.buyUris[n2] = this.getAppPropertyWrap(STR_MG_BUYURI + string5);
                    this.catUris[n2] = this.getAppPropertyWrap(STR_MG_CATURI + string5);
                    if (this.buyUris[n2] != null) {
                        this.buyUris[n2] = this.buyUris[n2].trim();
                    }
                    if (this.catUris[n2] != null) {
                        this.catUris[n2] = this.catUris[n2].trim();
                    }
                    if (!SDKConfig.getDebugEnabled()) break;
                    SDKUtils.debugLog("SDKMoreGamesinitialize::Found Game " + string5 + ". CATURI=" + this.catUris[n2] + " BUYURI=" + this.buyUris[n2], 1);
                    break;
                }
                if (this.gameOrder[n2] != -2) continue;
                if (SDKConfig.getDebugEnabled()) {
                    SDKUtils.debugLog("SDKMoreGamesinitialize::Game '" + string5 + "' mentioned in the JAD (MG_PRODUCTS property) does not exist. Ignoring...", 3);
                }
                --n2;
            }
        } else {
            this.SDKMoreGames16Obj.initialize();
        }
    }

    private String getAppPropertyWrap(String string) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            if (SDKConfig.getMoreGamesCheatsEnabled()) {
                if (cheatsEnabled) {
                    if (string.startsWith(STR_MG_CATURI) ? cheatsStatus[1] == 2 : string.startsWith(STR_MG_BUYURI) && cheatsStatus[2] == 2) {
                        return null;
                    }
                    if (string.equals(STR_MG_IMPL)) {
                        switch (cheatsStatus[0]) {
                            case 0: {
                                return STR_IMPL_OFF;
                            }
                            case 1: {
                                return STR_IMPL_STATIC;
                            }
                            case 2: {
                                return STR_IMPL_WAP;
                            }
                            case 3: {
                                return STR_IMPL_WAP_STATIC;
                            }
                        }
                    }
                    if (string.equals(STR_MG_PRODUCTS)) {
                        int n;
                        String string2 = SDKMIDlet.getAppProp(string);
                        if (string2 == null) {
                            return null;
                        }
                        if (cheatsStatus[3] == 0) {
                            return "";
                        }
                        string2 = string2.trim();
                        if (cheatsStatus[3] != -1) {
                            n = -1;
                            for (int i = 0; i < cheatsStatus[3] && (n = string2.indexOf(44, n + 1)) != -1; ++i) {
                            }
                            if (n != -1) {
                                string2 = string2.substring(0, n);
                            }
                        }
                        if (cheatsStatus[4] != -1) {
                            n = string2.indexOf(44, 0);
                            if (n == -1) {
                                return string2;
                            }
                            string2 = string2.substring(n + 1) + ',' + string2.substring(0, n);
                        }
                        return string2;
                    }
                }
                return SDKMIDlet.getAppProp(string);
            }
            return SDKMIDlet.getAppProp(string);
        }
        return this.SDKMoreGames16Obj.getAppPropertyWrap(string);
    }

    private byte getKeyNumber(int n) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            for (int i = 0; i < 10; ++i) {
                if ((n & 128 << i) == 0) continue;
                return (byte)i;
            }
            return -1;
        }
        return this.SDKMoreGames16Obj.getKeyNumber(n);
    }

    private int translateCode(int n) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            return n;
        }
        return this.SDKMoreGames16Obj.translateCode(n);
    }

    private void selectGame(int n) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            this.currentGameID = this.gameOrder[n];
            if (this.currentGameID != -1) {
                this.currentImage = this.getImage(this.productIDs[this.currentGameID]);
                this.currentTag = SDKUtils.getString(this.productTags[this.currentGameID], null);
                this.currentCtg = SDKUtils.getString(this.productCategories[this.currentGameID], null);
                this.currentName = SDKUtils.getString(this.productNames[this.currentGameID], null);
                switch (this.mode) {
                    case 1: {
                        this.buyButtonEnabled = false;
                        this.catButtonEnabled = true;
                        this.currentButton = 1;
                        break;
                    }
                    case 2: {
                        this.buyButtonEnabled = this.buyUris[n] != null && this.buyUris[n].compareTo("") != 0;
                        boolean bl = this.catButtonEnabled = this.catUris[n] != null && this.catUris[n].compareTo("") != 0;
                        if (this.buyButtonEnabled) {
                            this.currentButton = 0;
                            break;
                        }
                        if (this.catButtonEnabled) {
                            this.currentButton = 1;
                            break;
                        }
                        this.currentButton = 2;
                        break;
                    }
                    case 3: {
                        this.catButtonEnabled = true;
                        if (this.buyUris[n] != null && this.buyUris[n].compareTo("") != 0) {
                            this.buyButtonEnabled = true;
                            this.currentButton = 0;
                            break;
                        }
                        this.buyButtonEnabled = false;
                        this.currentButton = 1;
                    }
                }
            } else {
                this.currentImage = this.getImage(STR_GENERIC_ID);
                this.currentTag = this.strings[1];
                this.currentCtg = this.strings[2];
                this.currentName = this.strings[3];
                this.buyButtonEnabled = false;
                if (this.mode == 2 && (this.catUris[n] == null || this.catUris[n].compareTo("") == 0)) {
                    this.catButtonEnabled = false;
                    this.currentButton = 2;
                } else {
                    this.catButtonEnabled = true;
                    this.currentButton = 1;
                }
            }
            if (this.currentButton != 2) {
                this.setLeftSoftkeyText(this.strings[5]);
            } else {
                this.setLeftSoftkeyText(null);
            }
            this.setRightSoftkeyText(this.strings[6]);
            this.doLayout();
        } else {
            this.SDKMoreGames16Obj.selectGame(n);
        }
    }

    private void drawLeftArrow(SDKGraphics sDKGraphics, int n, int n2) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            n += this.anim >> 1;
            sDKGraphics.setColor(-16757361);
            for (int i = 0; i <= SPACE_ARROW_SIZE; ++i) {
                sDKGraphics.drawLine(n + i, n2 - i, n + i, n2 + i);
            }
            sDKGraphics.setColor(-9462329);
            sDKGraphics.drawLine(n, n2, n + SPACE_ARROW_SIZE, n2 - SPACE_ARROW_SIZE);
            sDKGraphics.drawLine(n, n2, n + SPACE_ARROW_SIZE, n2 + SPACE_ARROW_SIZE);
            sDKGraphics.drawLine(n + SPACE_ARROW_SIZE, n2 - SPACE_ARROW_SIZE, n + SPACE_ARROW_SIZE, n2 + SPACE_ARROW_SIZE);
            sDKGraphics.setColor(this.initialColor);
        } else {
            this.SDKMoreGames16Obj.drawLeftArrow(sDKGraphics, n, n2);
        }
    }

    private void drawRightArrow(SDKGraphics sDKGraphics, int n, int n2) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            n -= this.anim >> 1;
            sDKGraphics.setColor(-16757361);
            for (int i = 0; i <= SPACE_ARROW_SIZE; ++i) {
                sDKGraphics.drawLine(n - i, n2 - i, n - i, n2 + i);
            }
            sDKGraphics.setColor(-9462329);
            sDKGraphics.drawLine(n, n2, n - SPACE_ARROW_SIZE, n2 - SPACE_ARROW_SIZE);
            sDKGraphics.drawLine(n, n2, n - SPACE_ARROW_SIZE, n2 + SPACE_ARROW_SIZE);
            sDKGraphics.drawLine(n - SPACE_ARROW_SIZE, n2 - SPACE_ARROW_SIZE, n - SPACE_ARROW_SIZE, n2 + SPACE_ARROW_SIZE);
            sDKGraphics.setColor(this.initialColor);
        } else {
            this.SDKMoreGames16Obj.drawRightArrow(sDKGraphics, n, n2);
        }
    }

    private void draw3DButton(SDKGraphics sDKGraphics, int n, int n2, SDKString sDKString, boolean bl) {
        if (SDKConfig.getSDKMoreGamesVersionIs15()) {
            boolean bl2 = false;
            if (bl) {
                SDKUtils.setFont(this.fonts[2]);
                if (this.fonts[2] == this.fonts[1]) {
                    bl2 = true;
                }
            } else {
                SDKUtils.setFont(this.fonts[1]);
            }
            int n3 = SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
            int n4 = n3 + 3 + 2;
            int n5 = this.screenWidth - n2 >> 1;
            sDKGraphics.setColor(-16777216);
            sDKGraphics.fillRect(n5, n, n2, n4);
            sDKGraphics.setColor(-16757361);
            sDKGraphics.fillRect(n5, n, n2 - 1, n4 - 1);
            sDKGraphics.setColor(-9462329);
            sDKGraphics.drawLine(n5 + 1, n + 1, n5 + n2 - 2, n + 1);
            sDKGraphics.drawLine(n5 + 1, n + 1, n5 + 1, n + n4 - 3);
            if (bl2) {
                sDKGraphics.setColor(-1);
                int n6 = n5 + (n3 >> 1) + 3;
                int n7 = n + (n4 >> 1);
                int n8 = (n3 >> 1) - 1;
                for (int i = 0; i <= n8; ++i) {
                    sDKGraphics.drawLine(n6 - i, n7 - i, n6 - i, n7 + i);
                }
            }
            sDKGraphics.setColor(this.initialColor);
            SDKUtils.drawString(sDKString, this.screenWidth >> 1, n + 2, 17);
        } else {
            this.SDKMoreGames16Obj.draw3DButton(sDKGraphics, n, n2, sDKString, bl);
        }
    }

    public final void pointerReleased(int n, int n2) {
        if (!SDKConfig.getSDKMoreGamesVersionIs15()) {
            this.SDKMoreGames16Obj.pointerReleased(n, n2);
        }
    }

    public final void pointerPressed(int n, int n2) {
        if (!SDKConfig.getSDKMoreGamesVersionIs15()) {
            this.SDKMoreGames16Obj.pointerPressed(n, n2);
        }
    }

    public final void pointerDragged(int n, int n2) {
        if (!SDKConfig.getSDKMoreGamesVersionIs15()) {
            this.SDKMoreGames16Obj.pointerDragged(n, n2);
        }
    }
}

