/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import ca.jamdat.flight.Color888;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.FlDrawPropertyUtil;
import ca.jamdat.flight.FlRect;
import com.ea.sdk.SDKImage;

public class SDKGraphics {
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_ROT90 = 5;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int BASELINE = 64;
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public DisplayContext pd;
    public boolean mIsOwningDC;
    public Color888 mCurColor;

    public void destruct() {
        this.mCurColor = null;
        if (this.mIsOwningDC) {
            this.pd = null;
        }
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.pd.NativeDrawArc(n, n2, n3, n4, n5, n6);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        this.pd.NativeDrawLine(n5, n6, n7, n8);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        this.pd.NativeDrawRect(n5, n6, ++n7, ++n8);
    }

    public void drawRegion(SDKImage sDKImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n6;
        int n10 = n7;
        this.pd.NativeDrawRegion(sDKImage.mBitmap.getImage(), n, n2, n3, n4, FlDrawPropertyUtil.MIDPTransformToTransform(n5), n9, n10, n8);
    }

    public void drawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n3;
        int n8 = n4;
        int n9 = n6;
        int n10 = n5;
        int n11 = n2;
        this.pd.NativeDrawRGB(nArray, n, n7, n8, n10, n9, n11, bl);
    }

    public void drawRGB(Object object, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.drawRGB((int[])object, n, n2, n3, n4, n5, n6, bl);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.pd.NativeDrawRoundRect(n, n2, ++n3, ++n4, n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.pd.NativeFillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        this.pd.NativeFillRect(n5, n6, n7, n8);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.pd.NativeFillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void fillTriangle(int n, int n2, int n3, int n4, int n5, int n6) {
        this.pd.NativeFillTriangle(n, n2, n3, n4, n5, n6);
    }

    public int getClipHeight() {
        return this.pd.NativeGetClipHeight();
    }

    public int getClipWidth() {
        return this.pd.NativeGetClipWidth();
    }

    public int getClipX() {
        return this.pd.NativeGetClipX();
    }

    public int getClipY() {
        return this.pd.NativeGetClipY();
    }

    public int getColor() {
        return this.pd.NativeGetARGB();
    }

    public int getTranslatedX() {
        return this.pd.NativeGetTranslatedX();
    }

    public int getTranslatedY() {
        return this.pd.NativeGetTranslatedY();
    }

    public void setClip(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        this.pd.NativeSetClip(n5, n6, n7, n8);
    }

    public void setColor(int n) {
        this.pd.NativeSetARGB(n);
    }

    public void translate(int n, int n2) {
        this.pd.NativeTranslate(n, n2);
    }

    public void drawImage(SDKImage sDKImage, int n, int n2, int n3) {
        this.drawRegion(sDKImage, 0, 0, sDKImage.getWidth(), sDKImage.getHeight(), 0, n, n2, n3);
    }

    public SDKGraphics(SDKImage sDKImage) {
        this.mIsOwningDC = true;
        this.mCurColor = new Color888();
        this.pd = DisplayContext.CreateContext(sDKImage.mBitmap);
        FlRect flRect = new FlRect(this.pd.GetScreenRect());
        this.pd.SetAbsoluteClippingRect((short)0, (short)0, flRect.GetWidth(), flRect.GetHeight());
    }

    public SDKGraphics() {
        this.mCurColor = new Color888();
    }

    public void init(DisplayContext displayContext) {
        if (this.mIsOwningDC) {
            this.pd = null;
            this.mIsOwningDC = false;
        }
        this.pd = displayContext;
    }

    public int transformTransform(int n) {
        switch (n) {
            case 0: {
                n = 5;
                break;
            }
            case 3: {
                n = 6;
                break;
            }
            case 2: {
                n = 7;
                break;
            }
            case 1: {
                n = 4;
                break;
            }
            case 5: {
                n = 3;
                break;
            }
            case 7: {
                n = 1;
                break;
            }
            case 4: {
                n = 2;
                break;
            }
            case 6: {
                n = 0;
            }
        }
        return n;
    }

    public void toscreen() {
        this.pd.EndScene();
        this.pd.BeginScene();
    }

    public static SDKGraphics[] InstArraySDKGraphics(int n) {
        SDKGraphics[] sDKGraphicsArray = new SDKGraphics[n];
        for (int i = 0; i < n; ++i) {
            sDKGraphicsArray[i] = new SDKGraphics();
        }
        return sDKGraphicsArray;
    }

    public static SDKGraphics[][] InstArraySDKGraphics(int n, int n2) {
        SDKGraphics[][] sDKGraphicsArray = new SDKGraphics[n][];
        for (int i = 0; i < n; ++i) {
            sDKGraphicsArray[i] = new SDKGraphics[n2];
            for (int j = 0; j < n2; ++j) {
                sDKGraphicsArray[i][j] = new SDKGraphics();
            }
        }
        return sDKGraphicsArray;
    }

    public static SDKGraphics[][][] InstArraySDKGraphics(int n, int n2, int n3) {
        SDKGraphics[][][] sDKGraphicsArray = new SDKGraphics[n][][];
        for (int i = 0; i < n; ++i) {
            sDKGraphicsArray[i] = new SDKGraphics[n2][];
            for (int j = 0; j < n2; ++j) {
                sDKGraphicsArray[i][j] = new SDKGraphics[n3];
                for (int k = 0; k < n3; ++k) {
                    sDKGraphicsArray[i][j][k] = new SDKGraphics();
                }
            }
        }
        return sDKGraphicsArray;
    }
}

