/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlKeyManager;
import ca.jamdat.flight.SpecConstants;
import com.ea.sdk.GameApp;
import com.ea.sdk.SDKGame;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKKeys;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import com.ea.sdk.VpadDesigner;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;

public class SDKCanvas
extends Canvas
implements SDKKeys {
    public static final byte INPUT_MODE_NORMAL = 0;
    public static final byte INPUT_MODE_KEYBOARD = 1;
    public int mKeyState;
    public int mFrameKeysPressed;
    public int mFrameKeysRepeated;
    public int mFrameKeyReleased;
    public int mKeysDisabledNbFrames;
    public SDKGraphics mSdkGraphics = SDKUtils.createGraphics();
    public byte mInputMode;

    public static SDKCanvas getInstance() {
        return GameApp.Get().mSDKCanvas;
    }

    public void setInputMode(byte by) {
        this.mInputMode = by;
        FlKeyManager.GetInstance().SetGameKeyAltMode(by == 0);
    }

    public static boolean isKeyPressed(int n) {
        return (SDKCanvas.getInstance().mKeyState & n) != 0;
    }

    public static boolean isNewKeyPressed(int n) {
        return (SDKCanvas.getInstance().mFrameKeysPressed & n) != 0;
    }

    public static boolean isNewKeyPressedOrRepeated(int n) {
        return SDKCanvas.isNewKeyPressed(n) || (SDKCanvas.getInstance().mFrameKeysRepeated & n) != 0;
    }

    public static boolean isNewKeyReleased(int n) {
        return (SDKCanvas.getInstance().mFrameKeyReleased & n) != 0;
    }

    public static void disableInput(int n) {
        SDKCanvas sDKCanvas = SDKCanvas.getInstance();
        sDKCanvas.mKeysDisabledNbFrames = n;
        sDKCanvas.mKeyState = 0;
        sDKCanvas.mFrameKeysPressed = 0;
        sDKCanvas.mFrameKeysRepeated = 0;
        sDKCanvas.mFrameKeyReleased = 0;
    }

    public long getAppTime() {
        return FlApplication.GetRealTime() - GameApp.Get().mLostTime;
    }

    public int getWidth() {
        DisplayManager.GetInstance();
        return DisplayManager.GetVideoMode().GetWidth();
    }

    public int getHeight() {
        DisplayManager.GetInstance();
        int n = DisplayManager.GetVideoMode().GetHeight();
        return n;
    }

    public SDKGame getGame() {
        return GameApp.Get().mSDKGame;
    }

    public void vpadInit(int n, int n2, boolean bl, int n3) {
    }

    public void vpadSetHeight(int n) {
    }

    public int vpadGetHeight() {
        return -1;
    }

    public void drawBackground(SDKGraphics sDKGraphics) {
    }

    public void drawButton(SDKGraphics sDKGraphics, int n, boolean bl) {
    }

    public void vpadSetDesigner(VpadDesigner vpadDesigner) {
    }

    public VpadDesigner vpadGetDesigner() {
        return null;
    }

    public void simulateKeyPressed(int n) {
        if (n != 0 && (n & n - 1) == 0) {
            this.keyEvt(n, true);
        }
    }

    public void simulateKeyReleased(int n) {
        if (n != 0 && (n & n - 1) == 0) {
            this.keyEvt(n, false);
        }
    }

    public void keyPressed(int n) {
        this.FlightKeyEvt(FlKeyManager.ConstToFlightKey(n), true);
    }

    public void keyReleased(int n) {
        this.FlightKeyEvt(FlKeyManager.ConstToFlightKey(n), false);
    }

    public void keyRepeated(int n) {
    }

    public int getOsWidth() {
        return DisplayManager.GetMainDisplayContext().GetScreenRect().GetWidth();
    }

    public int getOsHeight() {
        short s = DisplayManager.GetMainDisplayContext().GetScreenRect().GetHeight();
        return s;
    }

    public void setCommands(SDKString sDKString, SDKString sDKString2) {
    }

    public SDKCanvas() {
        FlKeyManager flKeyManager = FlKeyManager.GetInstance();
        this.setInputMode((byte)0);
    }

    public void destruct() {
        this.mSdkGraphics = null;
    }

    public void ResetFrameKeyStates() {
        if (this.mKeysDisabledNbFrames > 0) {
            --this.mKeysDisabledNbFrames;
        }
        this.mFrameKeysPressed = 0;
        this.mFrameKeysRepeated = 0;
        this.mFrameKeyReleased = 0;
    }

    public void paint(DisplayContext displayContext) {
        this.mSdkGraphics.init(displayContext);
        GameApp.Get().mSDKGame.draw(this.mSdkGraphics);
    }

    public void paint(Graphics graphics) {
    }

    public void FlightKeyEvt(int n, boolean bl) {
        if (this.mKeysDisabledNbFrames > 0) {
            return;
        }
        int n2 = this.FlightKeyToSDKKey(n);
        if (n2 == 0) {
            int n3 = FlKeyManager.FlightKeyToAscii(n);
            if (n3 != 0) {
                long l = this.getAppTime();
                SDKGame sDKGame = GameApp.Get().mSDKGame;
                if (bl) {
                    sDKGame.appLetterPressed(n3, l);
                } else {
                    sDKGame.appLetterReleased(n3, l);
                }
            }
        } else {
            this.keyEvt(n2, bl);
        }
    }

    public void FlightPointerPressed(int n, int n2) {
    }

    public void FlightPointerReleased(int n, int n2) {
    }

    public void FlightPointerDragged(int n, int n2) {
    }

    public int FlightKeyToSDKKey(int n) {
        if (this.mInputMode == 0) {
            int n2 = FlKeyManager.FlightKeyToLower(n);
            if (n2 == SpecConstants.GetSdkKeyLskFlightKey0()) {
                return 32;
            }
            if (n2 == SpecConstants.GetSdkKeyRskFlightKey0()) {
                return 64;
            }
        }
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 8;
            }
            case 7: {
                return 16;
            }
            case 8: {
                return 0x100000;
            }
            case 9: {
                return 524288;
            }
            case 10: {
                return 0x800000;
            }
            case 11: {
                return 0x200000;
            }
            case 12: {
                return 0x400000;
            }
            case 13: {
                return 32;
            }
            case 14: {
                return 64;
            }
            case 15: {
                return 262144;
            }
            case 16: {
                return 131072;
            }
            case 17: {
                return 128;
            }
            case 18: {
                return 256;
            }
            case 19: {
                return 512;
            }
            case 20: {
                return 1024;
            }
            case 21: {
                return 2048;
            }
            case 22: {
                return 4096;
            }
            case 23: {
                return 8192;
            }
            case 24: {
                return 16384;
            }
            case 25: {
                return 32768;
            }
            case 26: {
                return 65536;
            }
        }
        return 0;
    }

    public void vpadDraw(SDKGraphics sDKGraphics) {
    }

    public void vpadResetPressedKey() {
    }

    public void keyEvt(int n, boolean bl) {
        long l = this.getAppTime();
        SDKGame sDKGame = GameApp.Get().mSDKGame;
        if (bl) {
            this.mFrameKeysPressed |= n;
            this.mKeyState |= n;
            sDKGame.appKeyPressed(n, l);
        } else {
            this.mFrameKeyReleased |= n;
            this.mKeyState &= ~n;
            sDKGame.appKeyReleased(n, l);
        }
    }

    public static SDKCanvas[] InstArraySDKCanvas(int n) {
        SDKCanvas[] sDKCanvasArray = new SDKCanvas[n];
        for (int i = 0; i < n; ++i) {
            sDKCanvasArray[i] = new SDKCanvas();
        }
        return sDKCanvasArray;
    }

    public static SDKCanvas[][] InstArraySDKCanvas(int n, int n2) {
        SDKCanvas[][] sDKCanvasArray = new SDKCanvas[n][];
        for (int i = 0; i < n; ++i) {
            sDKCanvasArray[i] = new SDKCanvas[n2];
            for (int j = 0; j < n2; ++j) {
                sDKCanvasArray[i][j] = new SDKCanvas();
            }
        }
        return sDKCanvasArray;
    }

    public static SDKCanvas[][][] InstArraySDKCanvas(int n, int n2, int n3) {
        SDKCanvas[][][] sDKCanvasArray = new SDKCanvas[n][][];
        for (int i = 0; i < n; ++i) {
            sDKCanvasArray[i] = new SDKCanvas[n2][];
            for (int j = 0; j < n2; ++j) {
                sDKCanvasArray[i][j] = new SDKCanvas[n3];
                for (int k = 0; k < n3; ++k) {
                    sDKCanvasArray[i][j][k] = new SDKCanvas();
                }
            }
        }
        return sDKCanvasArray;
    }
}

