/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.Entity2;
import com.ea.game.GameArray;
import com.ea.game.GameConstants;
import com.ea.game.GameImpl;
import com.ea.game.IStringConstants;
import com.ea.game.Level;
import com.ea.game.MenuClass;
import com.ea.game.Shot;
import com.ea.game.XSprite;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKUtils;
import java.io.IOException;

public class Entity
implements Constants,
IStringConstants,
GameConstants {
    public static short _global_uid = 0;
    int _type;
    int _id;
    int _level_id;
    int _flags;
    int _collisionFlag;
    int _pos_x;
    int _pos_y;
    int _z_order;
    long _timer;
    long _seektimer;
    byte[] _bdata;
    short[] _sdata;
    int[] _idata;
    int _lastFrameIdRect;
    int[] _bbox = new int[4];
    byte _nState;
    static byte _nStateCopy;
    byte _nNextState;
    boolean _homingtail = false;
    byte _projectileType;
    int _health;
    int _nContShootTimer;
    boolean _bHitByRailgun;
    boolean _bHitByPunch;
    int _prevState;
    boolean _bHitByAxe;
    static int _bulletX;
    static int _bulletY;
    boolean _bEffectedByGas;
    int _nHatIndex = -1;
    static int _shootPower;
    static int _targetSelectPosX;
    static int _targetSelectPosY;
    static boolean _targetShowCursor;
    static Entity _targetWorm;
    static Entity _targetEntity;
    static Entity _tutorialAnim;
    static int _airstrikeProjectylesFired;
    static int _airstrikeDirection;
    static int _nCommands;
    static long _timeout;
    static int _damage_fall_taken;
    static int _start_fall_pos_y;
    static int _sheepOutOfPlayfield;
    static boolean _bOutOfPos;
    int _count_LS_frame = 0;
    static boolean _wasHealthIncreased;
    static final int _PAUSE_TIME = 8000;
    static final int CAM_PAN_DISTANCE;
    static final int MAX_NO_ARMAGEDDON = 26;
    static final int MAX_CAM_PAN;
    static final int MAX_NO_ARMAGEDDON_PER_FRAME;
    static int _currentArmageddonNumber;
    int _traveledDist = 0;
    int _sprite;
    int _crt_anim;
    int _crt_aframe;
    int _crt_aframe_time;
    static byte DummiesCount;
    static boolean ArmageddonInUse;
    boolean _isArmageddonBlast = true;
    static boolean _isANaplamStrike;
    static boolean _bunkeronehit;
    static boolean _bDisablePauseMenu;
    int ArmageddonNumber = 1;
    int timer = 50;
    int _screenStart = 192;
    int _screenEnd = 960;
    static boolean _changingWind;
    static int preWindSpeed;
    static boolean _bTeleportDone;
    static int AI_WAIT_TIMER;
    static long AI_WAIT_SHOOT;
    static boolean isSinking;
    static int deadTarget;
    static int noMovement;
    static int jumpCounter;
    static boolean stopMovement;
    static boolean shouldShoot;
    static boolean useLight;
    static int nextRandomWorm;
    static int[] rememberDamageCausedByHumans;
    static int presentFaction;
    static int presentGuestFaction;
    static byte presentWeaponToUse;
    static int wormChking;
    static int target;
    static int pShotCtr;
    static int wormPrevPosX;
    static int wormPrevPosY;
    static boolean mineplaced;
    static int StartPosX;
    static int StartPosY;
    static int returnWalkVal;
    static int blowTorchTarget;
    static long mineTimer;
    int _noPlaceFoundCounter = 0;
    int worm_TravelDistance = 0;
    Shot _pShot;
    static int _directionFound;
    static byte _currentWeaponType;
    int _nPrevWeaponSelected;
    static int VENGEFUL_LOW_DIS;
    static int LOW_DIS;
    static int HIGH_DIS;
    static int MAX_JUMP_CTR;
    static int SHOTGUN_MIN_FIRE_DIS;
    static int MINIMUM_FIRE_DIS;
    static int STUCK_HIGH;
    static int STUCK_LOW;
    static int MINE_RETREAT_DIS;
    static int DYNAMITE_RETREAT_DIS;
    static int IS_WALKABLE;
    static int visibleRadius;
    static int LEFT_COUNTER;
    static int RIGHT_COUNTER;
    static int ARRAY_OFFSET;
    static int B_TOTAL_WORMS;
    static int B_WORM_ID;
    static int B_HAS_HUMAN;
    static int B_IS_WALKABLE;
    static int B_SENSOR_HAS_WORM;
    static int S_SENSOR_MINE;
    static int B_COLLISION_DIR;
    static int I_IS_HUMAN;
    static int I_POS_X;
    static int I_POS_Y;
    static int I_WORM_ID;
    static int[] aiWormPath;
    static int startForLeftPath;
    static int[] nearWormArray;
    static int wormArrayCnt;
    static int[] wormSelectionArray;
    static int[] wormMovementArray;
    static int[] wormWeaponSelection;
    static int precision;
    static int turnCounter;
    static int meleeCtr;
    static int _nCrtMovePos;
    static int _nMoveCommand;
    static int _nPathDestX;
    static int _nPathDestY;
    static int _nMoveStartX;
    static int _nMoveStartY;
    static int _nMoveDestX;
    static int _nMoveDestY;
    static int _nMoveResultOffset;
    static int _nMoveRetryPosX;
    static int _nMoveRetryPosY;
    static int _nMoveRetries;
    static int _nPathSearchesThisTurn;
    static boolean _bFinalDestReached;
    static int _nJumpFrq;
    static int _nJumpCnt;
    static boolean _bJumped;
    static final int MOVE_PATH_X_IDX = 0;
    static final int MOVE_PATH_Y_IDX = 1;
    static final int MOVE_PATH_OFFSET_IDX = 2;
    static final int MOVE_PATH_IDX_NO = 3;
    int _velX;
    int _velY;
    int _newX;
    int _newY;
    int _mass;
    int _landDrag;
    int _xBounce;
    int _yBounce;
    public static final int MAX_PETROL_FIRE = 15;
    public static final int MIN_PETROL_FIRE = -15;
    public static final int PETROL_FIRE_STEP = 10;
    public static final int MIN_AIRSTRIKE_PARTICLES = -5;
    public static final int MAX_AIRSTRIKE_PARTICLES = 5;
    public static final int AIRSTRIKE_PARTICLE_STEP = 5;
    boolean isRocketTailAnimOn = true;
    int _blastBunkerBuster = 0;
    boolean _bSimpleRebound;
    int _timerFire = 0;
    int LifeTimeSpent = 0;
    int countParticles = 0;

    public Entity(int n) {
        this.Reset();
        this._id = n;
    }

    Entity(int n, int n2, int n3, byte[] byArray, short[] sArray) {
        this.Init(n, n2, n3, byArray, sArray);
    }

    public void Reset() {
        this._type = 0;
        this._flags = 0;
        this._collisionFlag = 0;
        this._pos_x = 0;
        this._pos_y = 0;
        this._z_order = 1;
        this._timer = 0L;
        this._idata = null;
        this._sdata = null;
        this._bdata = null;
        this._sprite = 0;
        this._crt_anim = -1;
        this._crt_aframe = 0;
        this._crt_aframe_time = 0;
        this._lastFrameIdRect = -1;
        this._bSimpleRebound = true;
    }

    public void Init(int n, int n2, int n3, byte[] byArray, short[] sArray) {
        this.Reset();
        this._type = (byte)n;
        this._pos_x = n2;
        this._pos_y = n3;
        this.Init();
    }

    public void Init() {
        this.InitPhysics();
        switch (this._type) {
            case 11: {
                this._sprite = 2;
                this._crt_anim = -1;
                this._bdata = new byte[3];
                this._idata = new int[3];
                this._bdata[0] = GameImpl._pCrtWorm._bdata[5];
                this._crt_aframe = this._bdata[0] == 1 ? 82 + GameImpl._nGameTimer % 3 : 79 + GameImpl._nGameTimer % 3;
                this._velX = this._bdata[0] * 327680 / 3;
                this._velY = 0;
                this._projectileType = (byte)9;
                GameImpl._bSheepJumped = true;
                this.UpdateBoundingBox();
                this._timer = GameImpl.canvas.getAppTime() - Level._timeDiff;
                break;
            }
            case 20: {
                this._sprite = 2;
                this._crt_anim = -1;
                this._bdata = new byte[3];
                this._idata = new int[3];
                this._idata[2] = 65536;
                this._bdata[0] = GameImpl._pCrtWorm._bdata[5];
                this._projectileType = (byte)9;
                this.UpdateBoundingBox();
                this._timer = GameImpl.canvas.getAppTime() - Level._timeDiff;
                break;
            }
            case 23: {
                this._sprite = 2;
                this._crt_anim = -1;
                this._bdata = new byte[2];
                this._idata = new int[3];
                this._bdata[0] = GameImpl._pCrtWorm._bdata[5];
                this._projectileType = (byte)9;
                GameImpl._bSheepJumped = false;
                this.UpdateBoundingBox();
                GameImpl._smokeGenerator = Level.SpawnParticleGenerator((short)this._id, (byte)2, (byte)1, (byte)1);
                if (GameImpl._smokeGenerator != null) {
                    GameImpl._smokeGenerator._bdata[3] = 1;
                    GameImpl._smokeGenerator.SetSprite(3);
                    GameImpl._smokeGenerator.SetCrtAnim(8);
                }
                this._timer = GameImpl.canvas.getAppTime() - Level._timeDiff;
                break;
            }
            case 24: {
                this._sprite = 2;
                this._crt_anim = -1;
                this._bdata = new byte[3];
                this._idata = new int[3];
                this._bdata[0] = GameImpl._pCrtWorm._bdata[5];
                this._velX = this._bdata[0] * 327680 / 3;
                this._velY = 0;
                this._projectileType = (byte)9;
                GameImpl._bSheepJumped = true;
                this.UpdateBoundingBox();
                this._timer = GameImpl.canvas.getAppTime();
                break;
            }
            case 26: {
                this._sprite = 5;
                this._bdata = new byte[3];
                this._idata = new int[3];
                this._bdata[0] = GameImpl._pCrtWorm._bdata[5];
                this._velX = this._bdata[0] * 0x120000 / 2;
                this._velY = 0;
                this._projectileType = (byte)31;
                GameImpl._bSheepJumped = true;
                this.UpdateBoundingBox();
                this._timer = GameImpl.canvas.getAppTime();
                break;
            }
            case 15: {
                this._sprite = 2;
                this._crt_anim = -1;
                this._sdata = new short[1];
                this._crt_aframe = 109 + GameImpl._nGameTimer % 3;
                this._velX = 0;
                this._velY = 0;
                this._projectileType = (byte)24;
                this.UpdateBoundingBox();
                this._timer = GameImpl.canvas.getAppTime();
                this._sdata[0] = 0;
                break;
            }
            case 1: {
                this._bdata = new byte[23];
                this._sdata = new short[1];
                this._idata = new int[10];
                this.Worm_Init();
                if (this._bdata[3] != 0) break;
                Level.CheckPositionTriggers(this, this._pos_x, this._pos_y);
                break;
            }
            case 19: {
                this._flags |= 0x20;
                this._bdata = new byte[23];
                this._idata = new int[10];
                this.SetSprite(1);
                return;
            }
            case 5: {
                this._bdata = new byte[2];
                this._flags |= 0x40;
                break;
            }
            case 2: {
                this._bdata = new byte[1];
                this._sdata = new short[1];
                if (this._projectileType == 14) {
                    this._sprite = 5;
                    GameImpl._railgunProjectyle = this;
                    GameImpl._railgun_x1 = this._pos_x;
                    GameImpl._railgun_y1 = this._pos_y;
                } else {
                    this._sprite = this._projectileType == 22 ? 3 : 2;
                    int n = this.GetProjectyleFrame(this._velX, this._velY);
                    if (n != -1 && (this._velX >> 16 != 0 || this._velY >> 16 != 0)) {
                        this._crt_aframe = n;
                    }
                    GameImpl._railgunProjectyle = null;
                    GameImpl._railgunStartFrames = 0;
                }
                this._sdata[0] = 0;
                this._timer = GameImpl.canvas.getAppTime();
                if (this._projectileType != 5) break;
                this._seektimer = GameImpl.canvas.getAppTime();
                break;
            }
            case 12: {
                this._health = 1;
                this._flags |= 0x20;
                this._sprite = 12;
                this.SetCrtAnim(0);
                this._flags &= 0xFFFFFFBF;
                break;
            }
            case 28: {
                this._flags &= 0xFFFFFFDF;
                break;
            }
            case 27: {
                this._yBounce = 0;
                this._xBounce = 0;
                this._health = 100;
                this.SetSprite(3);
                this.SetCrtAnim(12);
                Level.SetCameraState(3);
                this._flags &= 0xFFFFFFBF;
                this._flags |= 0x20;
                this.LifeTimeSpent = 49;
                this._collisionFlag = 163;
                break;
            }
            case 13: {
                this.Mine_Init();
                break;
            }
            case 14: {
                this._health = 1;
                this._flags |= 0x20;
                this._sprite = 6;
                break;
            }
            case 10: {
                this._bdata = new byte[1];
                this._idata = new int[1];
                this._timer = 0L;
                break;
            }
            case 16: {
                this._bdata = new byte[19];
                break;
            }
            case 17: {
                this._bdata = new byte[4];
                this._sdata = new short[1];
                break;
            }
            case 9: {
                this._velX = 0;
                this._velY = 0;
                this._idata = new int[2];
                this._z_order = this.GetEntityZOrder(this._type);
            }
        }
        this._z_order = this.GetEntityZOrder(this._type);
        this.UpdateBoundingBox();
    }

    void UpdateBoundingBox() {
        switch (this._type) {
            case 1: 
            case 19: {
                this._bbox[0] = -6;
                this._bbox[2] = 6;
                this._bbox[1] = -20;
                this._bbox[3] = -4;
                break;
            }
            case 11: 
            case 24: {
                this._bbox[0] = -3;
                this._bbox[2] = 3;
                this._bbox[1] = -20;
                this._bbox[3] = -4;
                break;
            }
            case 15: {
                this._bbox[0] = -4;
                this._bbox[2] = 4;
                this._bbox[1] = -4;
                this._bbox[3] = 4;
                break;
            }
            case 2: {
                if (this._projectileType == 21) {
                    this._bbox[0] = -16;
                    this._bbox[2] = 4;
                    this._bbox[1] = -64;
                    this._bbox[3] = 4;
                    break;
                }
                this._bbox[0] = -4;
                this._bbox[2] = 4;
                this._bbox[1] = -4;
                this._bbox[3] = 4;
                break;
            }
            case 26: {
                this._bbox[0] = -1;
                this._bbox[2] = 1;
                this._bbox[1] = -1;
                this._bbox[3] = 1;
                break;
            }
            case 28: {
                this._bbox[3] = 0;
                this._bbox[1] = 0;
                this._bbox[2] = 0;
                this._bbox[0] = 0;
                break;
            }
            case 27: {
                this._bbox[0] = -1;
                this._bbox[2] = 1;
                this._bbox[1] = -1;
                this._bbox[3] = 1;
                break;
            }
            case 12: {
                this._bbox[0] = -8;
                this._bbox[2] = 4;
                this._bbox[1] = -16;
                this._bbox[3] = -6;
                break;
            }
            case 9: {
                this._bbox[0] = -6;
                this._bbox[2] = 6;
                this._bbox[1] = -6;
                this._bbox[3] = 6;
                break;
            }
            default: {
                XSprite xSprite = GameImpl._sprites[this._sprite];
                int n = 0;
                n = this._crt_anim >= 0 ? xSprite.GetAnimFrameId(this._crt_anim, this._crt_aframe) : this._crt_aframe;
                if (n == this._lastFrameIdRect || n == -1) {
                    return;
                }
                this._lastFrameIdRect = n;
                xSprite.RectFrame(n, 0, 0, this._flags);
                for (int i = 0; i < 4; ++i) {
                    this._bbox[i] = GameImpl._rect[i];
                }
                if (this._type != 9) break;
                this._bbox[0] = this._bbox[0] + 2;
                this._bbox[2] = this._bbox[2] - 4;
                this._bbox[1] = this._bbox[1] + 2;
                this._bbox[3] = this._bbox[3] - 4;
            }
        }
    }

    public String toString() {
        switch (this._type) {
            case 19: {
                return "NPC " + this._id;
            }
            case 1: {
                return "Worm " + this._id;
            }
            case 12: {
                return "Barrel " + this._id;
            }
        }
        return "";
    }

    public void Free() {
        this._sdata = null;
        this._bdata = null;
        this._idata = null;
        this._bbox = null;
    }

    public void Load(SDKInputStream sDKInputStream, int n) throws IOException {
        this._level_id = sDKInputStream.readShort();
        switch (n) {
            case 1: {
                int n2 = sDKInputStream.read() & 0xFF;
                if (n2 == 0) {
                    this._flags |= 0x18;
                }
                this._bdata[11] = (byte)(sDKInputStream.read() & 0xFF);
                byte by = (byte)(sDKInputStream.read() & 0xFF);
                int n3 = sDKInputStream.read() & 0xFF;
                int n4 = sDKInputStream.readShort() + Level._extraPixelsWidth;
                int n5 = sDKInputStream.readShort() + Level._extraPixelsHeightTop;
                if (n2 == 0) {
                    this._pos_x = n4 << 16;
                    this._pos_y = (Level._sea_level << 16) + 0x600000;
                } else {
                    n5 = this.PlaceObjectOnGround(n4, n5, false);
                    this.SetPosition(n4 << 16, n5 << 16);
                }
                this._bdata[3] = by;
                byte by2 = this._bdata[3];
                GameImpl._nTeamWormCount[by2] = GameImpl._nTeamWormCount[by2] + 1;
                if (n3 == 1) {
                    this.SetWormDirection(1);
                } else {
                    this.SetWormDirection(-1);
                }
                if (this._bdata[3] != 0) {
                    this._bdata[12] = 0;
                    this.InitAIWormData();
                } else {
                    this._bdata[12] = 1;
                }
                this._health = this._bdata[11];
                this._type = n;
                break;
            }
            case 19: {
                int n6 = sDKInputStream.read() & 0xFF;
                this._bdata[1] = (byte)(sDKInputStream.read() & 0xFF);
                this.SetSprite(1);
                if (n6 == 0) {
                    this._flags |= 0x18;
                } else {
                    this.SetCrtAnim(this._bdata[1]);
                    this._flags &= 0xFFFFFFBF;
                }
                this._bdata[11] = (byte)(sDKInputStream.read() & 0xFF);
                int n7 = sDKInputStream.read() & 0xFF;
                if (n7 == 1) {
                    this._flags |= 1;
                }
                byte by = (byte)(sDKInputStream.read() & 0xFF);
                int n8 = sDKInputStream.readShort() + Level._extraPixelsWidth;
                int n9 = sDKInputStream.readShort() + Level._extraPixelsHeightTop;
                n9 = this.PlaceObjectOnGround(n8, n9, false);
                this.SetPosition(n8 << 16, n9 << 16);
                this.UpdateBoundingBox();
                this._health = this._bdata[11];
                this._type = n;
                this._bdata[3] = by;
                byte by3 = this._bdata[3];
                GameImpl._nTeamWormCount[by3] = GameImpl._nTeamWormCount[by3] + 1;
                break;
            }
            case 12: {
                ++Level._nOilBarrelsEntities;
                if (Level._nFirstBarrelIndex == -1) {
                    Level._nFirstBarrelIndex = this._id;
                }
            }
            case 13: {
                this._type = sDKInputStream.read() & 0xFF;
                int n10 = sDKInputStream.readShort() + Level._extraPixelsWidth;
                int n11 = sDKInputStream.readShort() + Level._extraPixelsHeightTop;
                this._type = n;
                this.UpdateBoundingBox();
                n11 = this.PlaceObjectOnGround(n10, n11, false);
                this.SetPosition(n10 << 16, n11 << 16);
                if (n == 13) {
                    if (Level._nFirstMineIndex == -1) {
                        Level._nFirstMineIndex = this._id;
                    }
                    ++Level._nMineEntities;
                    break;
                }
                if (n != 12) break;
                Level.AddObjectLevelCollisions(this, (byte)1);
                break;
            }
            case 14: {
                this._health = (byte)sDKInputStream.read();
                int n12 = sDKInputStream.readShort() + Level._extraPixelsWidth;
                int n13 = sDKInputStream.readShort() + Level._extraPixelsHeightTop;
                this.UpdateBoundingBox();
                this.SetPosition(n12 << 16, n13 << 16);
                break;
            }
            case 16: {
                this.LoadIsland(sDKInputStream);
                break;
            }
            case 5: {
                int n14 = sDKInputStream.read() & 0xFF;
                if (n14 == 0) {
                    this._flags |= 0x18;
                }
                int n15 = sDKInputStream.read() & 0xFF;
                this.SetSprite(5);
                this.SetCrtAnim(n15);
                this._flags &= 0xFFFFFFBF;
                this._pos_x = sDKInputStream.readShort() + Level._extraPixelsWidth << 16;
                this._pos_y = sDKInputStream.readShort() + Level._extraPixelsHeightTop << 16;
                break;
            }
        }
        this._z_order = this.GetEntityZOrder(this._type);
    }

    protected static short GetGlobalUID() {
        _global_uid = (short)(_global_uid + 1 & 0xFFF);
        return _global_uid;
    }

    public boolean SetPosition(int n, int n2) {
        if (this._type == 1) {
            return this.Worm_ChangePos(n, n2);
        }
        this._pos_x = n;
        this._pos_y = n2;
        return true;
    }

    public void SetSprite(int n) {
        if (n >= 54 || n < 0) {
            return;
        }
        this._sprite = n;
    }

    public int PlaceObjectOnGround(int n, int n2, boolean bl) {
        int n3 = 0;
        if (bl) {
            switch (this._type) {
                case 1: {
                    while (this.Worm_Collided(n << 16, n2 + n3 << 16) && n2 + n3 > 24) {
                        --n3;
                    }
                    break;
                }
                default: {
                    while (!Level.IsEmptySpaceUnder(n, n2 + n3) && n2 + n3 > 0) {
                        --n3;
                    }
                    break block0;
                }
            }
            return n2 + n3;
        }
        switch (this._type) {
            case 1: {
                while (!this.Worm_Collided(n << 16, n2 + n3 << 16) && n2 + n3 < Level._nLandMaxHeight) {
                    ++n3;
                }
                break;
            }
            default: {
                while (Level.IsEmptySpaceUnder(n, n2 + n3) && n2 + n3 < Level._nLandMaxHeight) {
                    ++n3;
                }
                break block3;
            }
        }
        return n2 + n3 - 1;
    }

    int GetEntityZOrder(int n) {
        switch (n) {
            case 15: {
                return 6;
            }
            case 1: {
                if (this._nState == 14 || this._nState == 17) {
                    return 6;
                }
                return 2;
            }
            case 5: {
                if (this.isTutorialArrowAnim()) {
                    return 1;
                }
                return 5;
            }
            case 2: {
                return 5;
            }
            case 13: 
            case 27: {
                return 4;
            }
            case 4: 
            case 8: {
                return 6;
            }
        }
        return 1;
    }

    boolean isTutorialArrowAnim() {
        return this._sprite == 5 && (this._crt_anim >= 1 && this._crt_anim <= 12 || this._crt_anim == 16 || this._crt_anim == 17);
    }

    void Update() {
        if (this._type == 0 || (this._flags & 8) != 0) {
            return;
        }
        if (this._type != 16) {
            this.UpdatePhysics();
        }
        if (this != GameImpl._pCrtWorm && this._type == 1) {
            XSprite.SetHat(this._nHatIndex);
        }
        this.UpdateCrtAnim();
        if (this._type == 1) {
            XSprite.SetHat(-1);
        }
        switch (this._type) {
            case 11: {
                this.UpdateSheep();
                break;
            }
            case 23: {
                this.UpdateGasPump();
                break;
            }
            case 24: {
                this.UpdateBOL();
                break;
            }
            case 26: {
                this.UpdateDragonBall();
                break;
            }
            case 20: {
                this.UpdateSheepControls();
                if (GameImpl.isKeyPressed(0x3001010) && GameImpl._nGameTimer - GameImpl._sheepReleaseTime > 6) {
                    this.Explode(this._pos_x >> 16, this._pos_y >> 16, 9);
                    return;
                }
                if (this._pos_x >> 16 < 10 || this._pos_x >> 16 > Level._nLandMaxWidth - 10 || this._pos_y >> 16 > Level._sea_level || this._pos_y >> 16 < 10) {
                    this.Explode(this._pos_x >> 16, this._pos_y >> 16, 9);
                    break;
                }
                if (GameImpl.canvas.getAppTime() - (this._timer + Level._timeDiff) < (long)GameImpl.SUPER_SHEEP_EXPLODE_TIME) break;
                this.Explode(this._pos_x >> 16, this._pos_y >> 16, 9);
                return;
            }
            case 15: {
                this._sdata[0] = (short)(this._sdata[0] + 1);
                if (this._pos_x < 0 || this._pos_x >> 16 > Level._nLandMaxWidth || this._pos_y >> 16 > Level._sea_level) {
                    this.EndShooting(false);
                    break;
                }
                if (this._sdata[0] >= GameImpl._nFusedTimer * 20) {
                    this.Explode(this._pos_x >> 16, this._pos_y >> 16, 24);
                    return;
                }
                this._crt_aframe = 109 + GameImpl._nGameTimer % 3;
                break;
            }
            case 1: {
                this.Worm_Update();
                break;
            }
            case 19: {
                this.UpdateNPCAnt();
                break;
            }
            case 5: {
                if ((this._flags & 0x40) == 0 || !this.IsCrtAnimEnded()) break;
                Level.DisableEntity(this._id);
                break;
            }
            case 2: {
                this.UpdateEntityProjectyle();
                break;
            }
            case 6: {
                this.UpdateWindParticles();
                break;
            }
            case 28: {
                this.UpdateArmageddonEmitter();
                break;
            }
            case 25: {
                this.UpdateLightiningStrikeClouds();
                break;
            }
            case 9: {
                if (this._pos_x < 0 || this._pos_x >> 16 >= Level._nLandMaxWidth || this._pos_y >> 16 > Level._sea_level) {
                    Level.DisableEntity(this._id);
                    break;
                }
                if (this._crt_anim != 3 && this._crt_anim != 2) break;
                this._velX = 0;
                if (!this.IsCrtAnimEnded()) break;
                this.SetCrtAnim(this._crt_anim);
                this._flags &= 0xFFFFFFBF;
                break;
            }
            case 10: {
                this._pos_y -= 196608;
                ++this._timer;
                if (this._timer <= 50L && this._pos_y >= 0) break;
                Level.DisableEntity(this._id);
                break;
            }
            case 12: {
                if (this._health > 0) break;
                this.Explode(this._pos_x >> 16, this._pos_y >> 16, 28);
                Level.DisableEntity(this._id);
                break;
            }
            case 27: {
                this.Explode(this._pos_x >> 16, this._pos_y >> 16, 34);
                if (this._pos_y >> 16 <= Level._sea_level) break;
                Level.DisableEntity(this._id);
                break;
            }
            case 13: {
                this.Mine_Update();
                break;
            }
            case 17: {
                this.UpdateParticleGenerator();
                break;
            }
            case 30: {
                this.updatGasparticles();
            }
            case 18: {
                this.UpdateParticle();
            }
        }
    }

    void FireProjectyle(int n, int n2, int n3, int n4, byte by, boolean bl) {
        Entity entity = Level.SpawnEntity(2);
        entity._projectileType = by;
        entity._velX = n3;
        entity._velY = n4;
        entity.Init(2, n, n2, null, null);
        if (bl) {
            Level.DoFollowEntity(entity._id);
        }
        if (by == 5) {
        }
    }

    void HandleHit(int n, int n2) {
        switch (this._type) {
            case 9: {
                this._health = 0;
                Level.DisableEntity(this._id);
                break;
            }
            case 1: {
                if ((this._flags & 0x18) != 0 || this.Worm_IsDyingOrDead()) break;
                this.Worm_HandleHit(n, n2);
                if (GameImpl._nActiveWormID == -1) break;
                if (Entity2.AreOpposingTeams(this._bdata[3], Level._entities[GameImpl._nActiveWormID]._bdata[3])) {
                    GameImpl._bHitEnemy = true;
                    break;
                }
                if (GameImpl._pCrtWorm == null || this == GameImpl._pCrtWorm) break;
                GameImpl._bHitFriend = true;
                break;
            }
            case 19: {
                if ((this._flags & 0x18) != 0) {
                    return;
                }
                this.SetSprite(1);
                this._crt_anim = -1;
                this.SetCrtAnim(this._bdata[1]);
                this.UpdateBoundingBox();
                this._health = 0;
                this._flags |= 0x40;
                return;
            }
            case 12: {
                this._health -= n2;
                if (this._health > 0) break;
                this._health = 0;
                break;
            }
            case 13: 
            case 27: {
                break;
            }
            case 14: {
                this._health = 0;
                Level.DisableEntity(this._id);
            }
        }
    }

    void TakeDamage(Entity entity) {
        if (entity == null) {
            return;
        }
        switch (this._type) {
            default: 
        }
    }

    int ShouldBeFollowed() {
        if (this._type == 27 && !this.Worm_Collided(this._pos_x, this._pos_y + 65536)) {
            return this._id;
        }
        if (this._type == 28) {
            Level.DoFollowEntity(this._id);
            return 5;
        }
        if (this._type == 1 && GameImpl._bRetreating && GameImpl._nActiveWormID == this._id && (this._nState == 7 || this._nState == 11 || this._nState == 25 || this._nState == 2 || this._nState == 12 || this._nState == 23 || this._nState == 10)) {
            return 1;
        }
        if (this._type == 11 || this._type == 20 || this._type == 2 && this._projectileType != 22 || this._type == 23 || this._type == 24 || this._type == 26 || this._type == 15) {
            return 2;
        }
        if (this._type == 1 && (this._nState == 7 || this._nState == 11 || this._nState == 12 || this._nState == 20 || this._nState == 13 || this._nState == 14 || this._nState == 10)) {
            return 3;
        }
        if (this._type == 13 && (this._nState == 2 || this._nState == 1 || Math.abs(this._velX) > 0 || Math.abs(this._velY) > 0)) {
            return 4;
        }
        if (GameImpl._pendingWorm != -1 && GameImpl._pendingWorm == this._id && Level._entities[GameImpl._pendingWorm]._type == 1 && Level._entities[GameImpl._pendingWorm]._idata[9] > 0) {
            return 6;
        }
        return 200;
    }

    boolean isNearPlayerWorm() {
        for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
            Entity entity;
            if (Level._entities_usage[i] != 1 || (entity = Level._entities[i]) == null || entity._type != 1 || entity.Worm_IsDyingOrDead() || entity._bdata[3] != 0 || 10 <= Math.abs(entity._pos_x - this._pos_x) >> 16) continue;
            return true;
        }
        return false;
    }

    void UpdateSheepControls() {
        if (GameImpl._pCrtWorm._bdata[12] == 0) {
            if (this.isNearPlayerWorm()) {
                this.Explode(this._pos_x >> 16, this._pos_y >> 16, 9);
            }
        } else if (this._type == 11 && GameImpl._nGameTimer - GameImpl._sheepReleaseTime > 6 && GameImpl.isKeyPressed(0x3001010)) {
            if (this._bdata[2] == 0) {
                this.Explode(this._pos_x >> 16, this._pos_y >> 16, 9);
                return;
            }
            if (this._bdata[2] == 1) {
                Entity entity = Level.SpawnEntity(20);
                int n = this._pos_x;
                int n2 = this._pos_y - 0x180000;
                GameImpl._bDisableUpdateWormControls = true;
                entity.Init(20, n, n2, null, null);
                Level.DoFollowEntity(entity._id);
                entity._bdata[2] = 1;
                Level.DisableEntity(this._id);
                GameImpl._sheepEntity = entity;
                GameImpl._bRetreating = false;
                GameImpl._sheepReleaseTime = GameImpl._nGameTimer;
                return;
            }
        }
        if (this._type != 20 || this._bdata[2] != 1) {
            return;
        }
        if (GameImpl.isKeyPressed(0x3001010) && GameImpl._nGameTimer - GameImpl._sheepReleaseTime > 6) {
            this._bdata[2] = 2;
            this._velX = 0;
            this._velY = 0;
            this._crt_aframe = 79;
            Level.ClearParticleGenerators();
            GameImpl._sheepReleaseTime = GameImpl._nGameTimer;
            return;
        }
        boolean bl = GameImpl.isKeyPressed(2565);
        boolean bl2 = GameImpl.isKeyPressed(40970);
        if (this._pos_y > 0) {
            _bOutOfPos = false;
        }
        if (this._pos_y < 0 && !_bOutOfPos) {
            _sheepOutOfPlayfield = GameImpl._nGameTimer;
            _bOutOfPos = true;
        }
        if (this._pos_y < 0 && GameImpl._nGameTimer - _sheepOutOfPlayfield > 24) {
            _bOutOfPos = false;
            this.EndShooting(false);
            return;
        }
        if (this._bdata[0] == 1) {
            if (bl) {
                this._idata[2] = this._idata[2] + 3640;
            }
            if (bl2) {
                this._idata[2] = this._idata[2] - 3640;
            }
            if (this._idata[2] > 65536) {
                this._bdata[0] = -1;
                this._idata[2] = 131072 - this._idata[2];
            } else if (this._idata[2] < 0) {
                this._bdata[0] = -1;
                this._idata[2] = -this._idata[2];
            }
        } else if (this._bdata[0] == -1) {
            if (bl) {
                this._idata[2] = this._idata[2] - 3640;
            }
            if (bl2) {
                this._idata[2] = this._idata[2] + 3640;
            }
            if (this._idata[2] > 65536) {
                this._bdata[0] = 1;
                this._idata[2] = 131072 - this._idata[2];
            } else if (this._idata[2] < 0) {
                this._bdata[0] = 1;
                this._idata[2] = -this._idata[2];
            }
        }
        int n = this._idata[2] * 180 >> 16;
        int n3 = GameImpl.Sin(n);
        int n4 = GameImpl.Cos(n);
        this._velX = this._bdata[0] * (int)(393216L * (long)n3 >> 16);
        this._velY = (int)(393216L * (long)n4 >> 16);
        int n5 = this._idata[2] * 4 / 65536;
        int n6 = 147 + (4 - n5) * 2 + GameImpl._nGameTimer % 2;
        this._flags = this._bdata[0] == 1 ? (this._flags |= 1) : (this._flags &= 0xFFFFFFFE);
        this._crt_aframe = n6;
    }

    void UpdateWindParticles() {
        int n = this._pos_x + this._velX;
        int n2 = this._pos_y + this._velY;
        if (n >> 16 < 0 || n >> 16 > Level._nLandMaxWidth || n2 >> 16 > Level._sea_level) {
            if (GameImpl.random(1 + (Math.abs(GameImpl._windSpeedX) * 10 >> 16)) <= 2) {
                n = GameImpl.random(Level._nLandMaxWidth << 16);
                n2 = 0;
            } else {
                n = GameImpl._windSpeedX >= 0 ? 0 : Level._nLandMaxWidth << 16;
                n2 = GameImpl.random(Level._sea_level << 16);
            }
        }
        this.SetPosition(n, n2);
    }

    void UpdateLightiningStrikeClouds() {
        GameImpl._bForceMinimap = false;
        if (Level._nCamY > 0 && (this._pos_x < 0 || this._pos_x > Level._nLandMaxWidth << 16)) {
            Level.DisableEntity(this._id);
            return;
        }
        ++GameImpl._shootCounter;
        ++this._count_LS_frame;
        this._pos_x = Entity._targetWorm._pos_x;
        if (this._count_LS_frame >= 20) {
            if (GameImpl._isFiringRange) {
                Level.DoFollowEntity(Entity._targetWorm._id);
                _targetWorm.SetCrtAnim(46);
                if (this._count_LS_frame >= 50) {
                    this._count_LS_frame = 0;
                    Level.DisableEntity(this._id);
                    GameImpl._pCrtWorm.SelectWeapon((byte)0);
                    GameImpl.SetGamePlayState(5);
                    GameImpl.updateUsedWeaponUtilCount(24);
                }
                return;
            }
            if (_targetWorm.Worm_IsDyingOrDead()) {
                Entity._targetWorm._health = 1;
                _wasHealthIncreased = true;
                Level.DoFollowEntity(Entity._targetWorm._id);
                Entity._targetWorm._type = 1;
                _targetWorm.SetSprite(1);
                Entity._targetWorm._nState = 1;
                Entity._targetWorm._z_order = 2;
                Entity._targetWorm._bHitByAxe = false;
                _targetWorm.SetHats(GameImpl._chosen_hats[Entity._targetWorm._bdata[3]]);
                Entity._targetWorm._bEffectedByGas = false;
                _targetWorm.SetCrtAnim(46);
                if (this._count_LS_frame >= 50) {
                    this._count_LS_frame = 0;
                    if (Entity._targetWorm._bdata[3] == 0 && GameImpl._pCrtWorm._bdata[3] == 0 && GameImpl._nGameControls != 50 && GameImpl._nGameControls != 53) {
                        ++GameImpl._worms_resurrect_total;
                    }
                    Entity._targetWorm._health = GameImpl._nGameMode == 3 || (MenuClass.currentLevel - GameImpl._currfaction) % 5 == 0 && GameImpl._nLevelType == 1 ? 100 : 30;
                    _targetWorm.Worm_SetState((byte)0);
                    byte by = Entity._targetWorm._bdata[3];
                    GameImpl._nTeamWormCount[by] = GameImpl._nTeamWormCount[by] + 1;
                    GameImpl._pCrtWorm.Worm_SetState((byte)0);
                    this.EndShooting(true);
                    GameImpl.SetGamePlayState(5);
                }
            } else {
                Level.DoFollowEntity(Entity._targetWorm._id);
                Entity._targetWorm._type = 1;
                _targetWorm.SetSprite(1);
                Entity._targetWorm._nState = 1;
                Entity._targetWorm._z_order = 2;
                Entity._targetWorm._bEffectedByGas = false;
                Entity._targetWorm._bHitByAxe = false;
                _targetWorm.SetHats(GameImpl._chosen_hats[Entity._targetWorm._bdata[3]]);
                _targetWorm.SetCrtAnim(46);
                if (this._count_LS_frame >= 50) {
                    if (_wasHealthIncreased) {
                        if (Entity._targetWorm._bdata[3] == 0 && GameImpl._pCrtWorm._bdata[3] == 0 && GameImpl._nGameControls != 50 && GameImpl._nGameControls != 53) {
                            ++GameImpl._worms_resurrect_total;
                        }
                        byte by = Entity._targetWorm._bdata[3];
                        GameImpl._nTeamWormCount[by] = GameImpl._nTeamWormCount[by] + 1;
                    }
                    this._count_LS_frame = 0;
                    if (GameImpl._nGameMode == 3 || (MenuClass.currentLevel - GameImpl._currfaction) % 5 == 0 && GameImpl._nLevelType == 1) {
                        Entity._targetWorm._health += 100;
                    } else if (_wasHealthIncreased) {
                        _wasHealthIncreased = false;
                        Entity._targetWorm._health += 29;
                    } else {
                        Entity._targetWorm._health += 30;
                    }
                    _targetWorm.Worm_SetState((byte)0);
                    GameImpl._pCrtWorm.Worm_SetState((byte)0);
                    this.EndShooting(true);
                    GameImpl.SetGamePlayState(5);
                }
            }
        } else {
            Level.DoFollowEntity(this._id);
        }
        if (this._pos_x < 0 || this._count_LS_frame > 50) {
            Level.DisableEntity(this._id);
        }
    }

    void UpdateArmageddonEmitter() {
        int n = (this._pos_x >> 16) / CAM_PAN_DISTANCE + 1;
        if (Level._nCamY > 0 && this._pos_x > Level._nLandMaxWidth << 16) {
            Level.DisableEntity(this._id);
            GameImpl._bForceMinimap = true;
            ArmageddonInUse = false;
            _currentArmageddonNumber = 0;
            GameImpl.SetGamePlayState(5);
            return;
        }
        if (GameImpl._nGameTimer % 30 == 0) {
            this.DropArmageddon();
        }
        Level.DoFollowEntity(this._id);
        GameImpl._bForceMinimap = false;
        if (_currentArmageddonNumber >= MAX_NO_ARMAGEDDON_PER_FRAME * n) {
            this._pos_x += CAM_PAN_DISTANCE << 16;
            this._timer = GameImpl.canvas.getAppTime();
        }
    }

    void UpdateSheep() {
        if (this._pos_x < 0 || this._pos_x >> 16 > Level._nLandMaxWidth || this._pos_y >> 16 > Level._sea_level || this._pos_y >> 16 < 0) {
            this.Explode(this._pos_x >> 16, this._pos_y >> 16, 9);
            return;
        }
        int n = 5000;
        if (this._bdata[2] == 1) {
            n = GameImpl.SUPER_SHEEP_EXPLODE_TIME;
        }
        if (GameImpl.canvas.getAppTime() - (this._timer + Level._timeDiff) >= (long)n) {
            this.Explode(this._pos_x >> 16, this._pos_y >> 16, 9);
            return;
        }
        int n2 = this._velX;
        int n3 = this.Sheep_Walk(n2, this._pos_x, this._pos_y);
        if (n3 == 1) {
            int n4 = GameImpl.random(5);
            if (!GameImpl._bSheepJumped && n4 == 0) {
                GameImpl._bSheepJumped = true;
                this._velY = -327680;
                this._velX = this._bdata[0] * 327680 / 3;
            } else {
                GameImpl._bSheepJumped = false;
                if (this._velX > 0 && this._velX != 327680) {
                    this._velX = 327680;
                } else if (this._velX < 0 && Math.abs(this._velX) != 327680) {
                    this._velX = -327680;
                }
            }
            this.SetPosition(this._idata[0], this._idata[1]);
        } else if (n3 == -1) {
            if (!GameImpl._bSheepJumped) {
                GameImpl._bSheepJumped = true;
                this._velY = -327680 - (GameImpl.random(-5) << 16);
                this._velX = this._bdata[0] * 327680 / 2;
            }
            this.SetPosition(this._idata[0], this._idata[1]);
        } else {
            this._velY = -327680;
            this._bdata[0] = -this._bdata[0];
            this._velX = -this._velX;
        }
        this._crt_aframe = this._bdata[0] == 1 ? 82 + GameImpl._nGameTimer % 3 : 79 + GameImpl._nGameTimer % 3;
        this.UpdateSheepControls();
    }

    void UpdateBOL() {
        Level.InflictCollateralDamage(19, 13, this._pos_x, this._pos_y);
        if (GameImpl._sheepExpCounter >= 6) {
            GameImpl._sheepExpCounter = 0;
            this.Explode(this._pos_x >> 16, this._pos_y >> 16, 33);
            this.EndShooting(false);
            return;
        }
        if (this._pos_x < 0 || this._pos_x >> 16 > Level._nLandMaxWidth || this._pos_y >> 16 > Level._sea_level) {
            GameImpl._sheepExpCounter = 0;
            this.EndShooting(false);
            return;
        }
        int n = this._velX;
        int n2 = this.Sheep_Walk(n, this._pos_x, this._pos_y);
        if (n2 == 1) {
            int n3 = GameImpl.random(5);
            if (!GameImpl._bSheepJumped && n3 == 0) {
                GameImpl._bSheepJumped = true;
                this._velY = -131072;
                this._velX = this._bdata[0] * 131072 / 3;
            } else {
                GameImpl._bSheepJumped = false;
                if (this._velX > 0 && this._velX != 131072) {
                    this._velX = 131072;
                } else if (this._velX < 0 && Math.abs(this._velX) != 131072) {
                    this._velX = -131072;
                }
            }
            this.SetPosition(this._idata[0], this._idata[1]);
        } else if (n2 == -1) {
            if (!GameImpl._bSheepJumped) {
                GameImpl._bSheepJumped = true;
                this._velY = -131072 - (GameImpl.random(-2) << 16);
                this._velX = this._bdata[0] * 131072 / 2;
            }
            this.SetPosition(this._idata[0], this._idata[1]);
        } else {
            ++GameImpl._sheepExpCounter;
            this.Explode(this._pos_x >> 16, this._pos_y >> 16, 33);
            this._pos_x += this._bdata[0] == 1 ? -1966080 : 0x1E0000;
            this._velY = -131072;
        }
        if (this.CheckMineCollisionsWithWorms()) {
            this.Explode(this._pos_x >> 16, this._pos_y >> 16, 33);
            this._pos_x += this._bdata[0] == 1 ? -1966080 : 0x1E0000;
            this._velY = 0;
            ++GameImpl._sheepExpCounter;
            this._velY = -131072;
        }
        this._crt_aframe = 182 + GameImpl._nGameTimer % 4;
        this._flags = this._bdata[0] == 1 ? (this._flags |= 1) : (this._flags &= 0xFFFFFFFE);
    }

    void UpdateDragonBall() {
        ++this._traveledDist;
        this._crt_aframe = this._bdata[0] == 1 ? 54 : 55;
        this._pos_x += this._velX;
        if (this._traveledDist <= 6 && (this.CheckDragonBallCollisionsWithWorms() || this._traveledDist >= 6 || this.Worm_Collided(this._pos_x, this._pos_y))) {
            this.Explode(this._pos_x >> 16, this._pos_y >> 16, 31);
            this._traveledDist = 0;
            this.EndShooting(false);
            Level.DisableEntity(this._id);
            return;
        }
        if (this._pos_x < 0 || this._pos_x >> 16 > Level._nLandMaxWidth || this._pos_y >> 16 > Level._sea_level) {
            this._traveledDist = 0;
            this.EndShooting(false);
            Level.DisableEntity(this._id);
            return;
        }
    }

    void UpdateGasPump() {
        int n = GameConstants.SCREEN_WIDTH > 176 ? 6000 : 5000;
        int n2 = n;
        if (GameImpl.canvas.getAppTime() - (this._timer + Level._timeDiff) >= (long)n2 || this._pos_x < 0 || this._pos_x >> 16 > Level._nLandMaxWidth || this._pos_y >> 16 > Level._sea_level) {
            GameImpl._sheepExpCounter = 200;
            this.ClearAllParticles();
            this.countParticles = 0;
            Level.DisableEntity(this._id);
            if (GameImpl._smokeGenerator != null) {
                Level.DisableEntity(GameImpl._smokeGenerator._id);
            }
            this.EndShooting(false);
            GameImpl._sheepEntity = null;
            return;
        }
        if (this._pos_x < 0 || this._pos_x >> 16 > Level._nLandMaxWidth || this._pos_y >> 16 > Level._sea_level) {
            GameImpl._sheepExpCounter = 200;
            this.EndShooting(false);
            this.ClearAllParticles();
            return;
        }
        this._pos_x += this._velX;
        this._pos_y += this._velY;
        this.updatGasparticles();
    }

    void UpdateNPCAnt() {
        if (this._health == 0 && this.IsCrtAnimEnded()) {
            Level.CheckTriggers((short)61, this, false);
            Level.DisableEntity(this._id);
            --Level._nNPCAntEntities;
            Level.CheckTriggers((short)64, this, false);
            return;
        }
        if (this._bdata[0] == 1) {
            if (this._crt_anim == this._bdata[1]) {
                this.SetSprite(1);
                this.SetCrtAnim(69);
                this._flags |= 0x40;
            } else if (this._crt_anim == 69 && this.IsCrtAnimEnded()) {
                this.SetSprite(1);
                this._crt_anim = -1;
                this.SetCrtAnim(this._bdata[1]);
                this._bdata[0] = 0;
                this._pos_x = this._idata[0];
                this._pos_y = this._idata[1];
                this.SetSprite(1);
                this.SetCrtAnim(69);
                this._flags = 64;
            }
        } else if (this._crt_anim == 69 && this.IsCrtAnimEnded()) {
            this.SetSprite(1);
            this.SetCrtAnim(this._bdata[1]);
            this._flags &= 0xFFFFFFBF;
        }
    }

    void UpdateEntityProjectyle() {
        if (this._pos_x < 0 || this._pos_x >> 16 > Level._nLandMaxWidth || this._pos_y >> 16 > Level._nLandMaxHeight || this._pos_y >> 16 < 0 && this._projectileType == 14) {
            this.EndShooting(false);
            if (GameImpl._isFiringRange) {
                Level._cameraState = 3;
                Level._followEntityPointer = GameImpl._nActiveWormID;
            }
            return;
        }
        if (this._projectileType == 22) {
            if (this._pos_y >> 16 > Level._sea_level && this._velY != 131072) {
                this._velX = 0;
                this._velY = 131072;
                return;
            }
        } else if (this._pos_y >> 16 > Level._sea_level) {
            this._velX = 0;
            this._velY = 131072;
            return;
        }
        this._sdata[0] = (short)(this._sdata[0] + 1);
        int n = this.GetProjectyleFrame(this._velX, this._velY);
        if (n != -1 && (this._velX >> 16 != 0 || this._velY >> 16 != 0)) {
            this._crt_aframe = n;
        }
        this.UpdateBoundingBox();
        if (this._projectileType == 31 || this._projectileType == 1 || this._projectileType == 6 || this._projectileType == 17 || this._projectileType == 15) {
            if (this._sdata[0] >= GameImpl._nFusedTimer * 20) {
                if (this._projectileType == 15 && this._velX == 0 && this._velY == 0) {
                    if (GameImpl._holyTimer == 0) {
                        GameImpl.PlaySound(8);
                    }
                    if (++GameImpl._holyTimer > 50) {
                        GameImpl._holyTimer = 0;
                        this.EndShooting(true);
                        this.Explode(this._pos_x >> 16, this._pos_y >> 16, this._projectileType);
                    }
                } else if (this._projectileType != 15) {
                    this.EndShooting(true);
                    this.Explode(this._pos_x >> 16, this._pos_y >> 16, this._projectileType);
                }
            }
        } else if (this._projectileType == 13) {
            if (this.isRocketTailAnimOn) {
                this.CreateRocketTailAnim();
            } else {
                this.CreateBunkerBusterDrillAnim(0, 0);
                this.CreateBunkerBusterDrillAnim(-327680, -131072);
                this.CreateBunkerBusterDrillAnim(327680, -131072);
            }
        } else if (this._projectileType == 0 || this._projectileType == 4 || this._projectileType == 22 || this._projectileType == 32) {
            this.CreateRocketTailAnim();
        } else if (this._projectileType == 5 && this._homingtail && this.isRocketTailAnimOn) {
            this.CreateRocketTailAnim();
        }
    }

    void Draw(SDKGraphics sDKGraphics) {
        int n = GameImpl.SV_X + (this._pos_x >> 16) - Level._nCamX;
        int n2 = GameImpl.SV_Y + (this._pos_y >> 16) - Level._nCamY;
        int n3 = n;
        int n4 = n2;
        if (this._type == 0 || (this._flags & 0x10) != 0) {
            return;
        }
        SDKUtils.setGraphics(sDKGraphics);
        XSprite.SetGraphics(sDKGraphics);
        XSprite xSprite = GameImpl._sprites[this._sprite];
        int n5 = this._flags & 7;
        switch (this._type) {
            case 23: 
            case 28: {
                return;
            }
            case 200: {
                this._sprite = 12;
                xSprite = GameImpl._sprites[this._sprite];
                if (this._bdata[IS_WALKABLE] == -1) {
                    sDKGraphics.setColor(1048575);
                } else {
                    sDKGraphics.setColor(0xFF0000);
                }
                if (this._sdata[0] <= 0) break;
                sDKGraphics.setColor(1044495);
                break;
            }
            case 4: {
                xSprite.DrawFrame(4, n3, n4, n5);
                break;
            }
            case 7: {
                break;
            }
            case 1: {
                this.Worm_Draw(sDKGraphics);
                break;
            }
            case 19: {
                this.NPC_Draw(sDKGraphics);
                break;
            }
            case 10: {
                if (GameImpl._isFiringRange || GameImpl.IsTutorial()) break;
                SDKUtils.setFont(GameImpl._fontWormSmall);
                switch (this._bdata[0]) {
                    case 0: {
                        GameImpl._stringMutable.setLength(0);
                        GameImpl._stringMutable.append("+ ");
                        if (GameImpl._nGameMode == 3 || (MenuClass.currentLevel - GameImpl._currfaction) % 5 == 0 && GameImpl._nLevelType == 1) {
                            GameImpl._stringMutable.append(1);
                        } else {
                            GameImpl._stringMutable.append(25);
                        }
                        GameImpl._stringMutable.append(" ");
                        GameImpl._stringMutable.append(SDKUtils.getString(212, GameImpl._string));
                        GameImpl.DrawString(GameImpl._stringMutable, n, n2 - 34, 17);
                        break;
                    }
                    case 1: {
                        GameImpl._stringMutable.setLength(0);
                        GameImpl._stringMutable.append("- ");
                        GameImpl._stringMutable.append(this._idata[0]);
                        GameImpl._stringMutable.append(" ");
                        GameImpl._stringMutable.append(SDKUtils.getString(212, GameImpl._string));
                        GameImpl.DrawString(GameImpl._stringMutable, n, n2 - 34, 17);
                        break;
                    }
                    case 2: {
                        if (this._idata[0] >= 36 || this._idata[0] < 0) break;
                        GameImpl._stringMutable.setLength(0);
                        GameImpl._stringMutable.append("+ 1X|");
                        GameImpl._stringMutable.append(GameImpl.GetWeaponName(this._idata[0]));
                        GameImpl.DrawWrappedString(GameImpl._stringMutable, n, n2, 100, 1);
                        GameImpl._sprites[10].DrawFrame(this._idata[0], n + 0, n2 + -15, 0);
                    }
                }
                break;
            }
            case 11: 
            case 20: {
                xSprite.DrawFrame(this._crt_aframe, n3, n4, n5);
                break;
            }
            case 24: {
                xSprite.DrawFrame(this._crt_aframe, n3, n4, n5);
                break;
            }
            case 26: {
                xSprite.DrawFrame(this._crt_aframe, n3, n4, n5);
                break;
            }
            case 15: {
                xSprite.DrawFrame(this._crt_aframe, n3, n4, n5);
                break;
            }
            case 14: {
                xSprite.DrawFrame(4, n3, n4, n5);
                break;
            }
            case 16: {
                break;
            }
            case 2: 
            case 25: {
                if (this._projectileType == 22 && this._velX > 0) {
                    n5 = 1;
                }
            }
            default: {
                if (this._crt_anim >= 0) {
                    xSprite.DrawAnimFrame(this._crt_anim, this._crt_aframe, n3, n4, n5);
                    break;
                }
                xSprite.DrawFrame(this._crt_aframe, n3, n4, n5);
            }
        }
    }

    int GetProjectyleFrame(int n, int n2) {
        if (this._projectileType == 14 || this._projectileType == 9 || this._projectileType == 24) {
            return 30;
        }
        if (this._projectileType == 4) {
            this._flags = _airstrikeDirection == 1 ? (this._flags |= 1) : (this._flags &= 0xFFFFFFFE);
            return 56;
        }
        int n3 = GameImpl.Atan2(n >> 16, n2 >> 16);
        int n4 = 11;
        int n5 = (180 - Math.abs(n3)) / (180 / n4 + 1);
        int n6 = GameImpl.Distance(n >> 16, n2 >> 16);
        if (n6 == 0 && n2 >> 16 != 0) {
            return -1;
        }
        switch (this._projectileType) {
            case 13: {
                n5 = 158;
                break;
            }
            case 21: {
                n5 = 181;
                break;
            }
            case 0: 
            case 4: {
                n5 += 45;
                if (n3 > -1) {
                    this._flags |= 1;
                    break;
                }
                this._flags &= 0xFFFFFFFE;
                break;
            }
            case 22: {
                n5 = 70 + GameImpl._nGameTimer % 3;
                break;
            }
            case 5: {
                n5 = this._projectileType == 5 && GameImpl.canvas.getAppTime() - this._timer < 1000L ? 34 + GameImpl._nGameTimer % 8 : (n5 += 34);
                if (n3 > -1) {
                    this._flags |= 1;
                    break;
                }
                this._flags &= 0xFFFFFFFE;
                break;
            }
            case 1: {
                n5 += 22;
                break;
            }
            case 11: {
                n5 += 159;
                break;
            }
            case 6: {
                n5 += 124;
                break;
            }
            case 17: {
                n5 += 85;
                break;
            }
            case 18: {
                n5 += 187;
                break;
            }
            case 7: {
                n5 = 123;
                break;
            }
            case 15: {
                n5 += 96;
            }
        }
        return n5;
    }

    public void SetCrtAnim(int n) {
        if (n == this._crt_anim && (this._flags & 0x80) == 0) {
            return;
        }
        this._crt_anim = n;
        this._crt_aframe = 0;
        XSprite xSprite = GameImpl._sprites[this._sprite];
        this._crt_aframe_time = xSprite.GetAnimFrameTime(this._crt_anim, this._crt_aframe);
        this._flags &= 0xFFFFFF7F;
        this.UpdateBoundingBox();
    }

    private void UpdateCrtAnim() {
        if (this._crt_anim < 0) {
            return;
        }
        if (this._crt_aframe_time == 0 || (this._flags & 0xC0) == 192) {
            this.UpdateBoundingBox();
            return;
        }
        this._flags &= 0xFFFFFF7F;
        --this._crt_aframe_time;
        if (this._crt_aframe_time <= 0) {
            XSprite xSprite = GameImpl._sprites[this._sprite];
            ++this._crt_aframe;
            if (this._crt_aframe >= xSprite.GetAnimLength(this._crt_anim)) {
                if ((this._flags & 0x40) != 0) {
                    --this._crt_aframe;
                    this._flags |= 0x80;
                } else {
                    this._crt_aframe = 0;
                }
            }
            this.UpdateBoundingBox();
            this._crt_aframe_time = xSprite.GetAnimFrameTime(this._crt_anim, this._crt_aframe);
        }
    }

    public boolean IsCrtAnimEnded() {
        if (this._crt_anim < 0) {
            return true;
        }
        return this._crt_aframe_time == 0 || (this._flags & 0x80) != 0;
    }

    void DropArmageddon() {
        int n = GameConstants.SCREEN_WIDTH - 50;
        int n2 = 20;
        int n3 = 0;
        int n4 = Level._nCamX - GameConstants.SCREEN_WIDTH + Level.IRandom(n, n2) << 16;
        int n5 = Level._nCamY + n3 << 16;
        int n6 = (Level.IRandom() % 4 == 0 ? 1 : -1) * 196608;
        Entity entity = Level.SpawnEntity(2);
        entity._projectileType = (byte)22;
        entity._velX = n6;
        entity._velY = 0x140000;
        entity.Init(2, n4, n5, null, null);
        ++_currentArmageddonNumber;
    }

    void Worm_ShootArmageddon() {
        Entity entity = Level.SpawnEntity(28);
        entity._pos_x = 0;
        entity._pos_y = 0x1900000;
        entity._flags &= 0xFFFFFFDF;
        GameImpl._bForceMinimap = false;
        Level.DoFollowEntity(entity._id);
        this.UseCurrentWeaponOnce();
    }

    void Worm_Init() {
        this._sprite = 1;
        this._nState = 0;
        this._bdata[5] = -1;
        this._idata[5] = 32768;
        this._health = GameImpl._nGameMode == 3 ? 100 : 100;
        this._bHitByAxe = false;
        this._bEffectedByGas = false;
        if (!GameImpl._isFiringRange) {
            this.SetWormTeam(-1);
        } else {
            this.SetWormTeam(1);
        }
        this.SetCrtAnim(7);
        this.UpdateBoundingBox();
        this._bdata[18] = 0;
        _damage_fall_taken = 0;
        this._bSimpleRebound = false;
        this._bdata[15] = -1;
        this._nHatIndex = this._bdata[3] == 0 ? 0 : 1;
    }

    void InitAIWormData() {
    }

    void Worm_SetAIState(byte by) {
        this.Worm_SetAIState(by, (byte)-1);
    }

    void Worm_SetAIState(byte by, byte by2) {
        if (this._id < Level._nFirstWormIndex || this._id > Level._nFirstWormIndex + Level._nWormsEntities) {
            return;
        }
        this._bdata[0] = by;
        this._bdata[1] = by2;
        switch (this._bdata[0]) {
            case 51: {
                AI_WAIT_SHOOT = GameImpl.canvas.getAppTime();
                GameImpl._pCrtWorm._bdata[0] = 51;
                break;
            }
            case 50: {
                AI_WAIT_TIMER = GameImpl.randomIncludelowHigh(42500, 43500);
                break;
            }
            case 40: {
                this.Worm_SetState((byte)4);
                break;
            }
            case 36: {
                this.InitializeAITurn();
                if (GameImpl._pCrtWorm._bdata[3] == 1) {
                    Entity2.SelectEnemyPlayerWorm(presentFaction);
                } else {
                    Entity2.SelectEnemyPlayerWorm(presentGuestFaction);
                }
                this._pShot = null;
                break;
            }
            case 41: {
                this.Worm_SetState((byte)27);
                this._bdata[15] = 34;
                this._timer = GameImpl.canvas.getAppTime();
                break;
            }
            case 43: {
                this._bdata[15] = 14;
                this.Worm_Shoot(14);
                _targetShowCursor = false;
                break;
            }
            case 42: {
                _bFinalDestReached = false;
                _nCrtMovePos = 0;
                _nMoveCommand = 0;
                _nMoveRetries = 0;
            }
        }
    }

    void Worm_SetState(byte by) {
        this.Worm_SetState(by, (byte)-1);
    }

    void Worm_SetState(byte by, byte by2) {
        if (this._type != 1) {
            return;
        }
        if (this._nState == by || this._nState == 15) {
            return;
        }
        if (this._id < Level._nFirstWormIndex || this._id > Level._nFirstWormIndex + Level._nWormsEntities) {
            return;
        }
        this._nNextState = by2;
        byte by3 = this._nState;
        switch (by3) {
            case 17: {
                this._z_order = 2;
                break;
            }
            case 10: {
                this._bSimpleRebound = false;
                break;
            }
            case 12: {
                this._yBounce = 43690;
                this._xBounce = 43690;
                break;
            }
            case 24: {
                this.HandleRetreatTimer();
                this.UseCurrentWeaponOnce();
                Level.StartTimer();
            }
        }
        this._nState = by;
        this._bdata[2] = 0;
        switch (this._nState) {
            case 1: {
                if (GameImpl._isFiringRange) {
                    switch (this._prevState) {
                        case 23: {
                            GameImpl.updateUsedWeaponUtilCount(8);
                        }
                    }
                }
                this.ResetSpeed();
                if (GameImpl._nGamePlayState != 14) {
                    this.Worm_SetCrtAnim(7);
                }
                if (this != GameImpl._pCrtWorm && !this._bHitByAxe) {
                    this._bdata[4] = 0;
                    this._sdata[0] = (short)GameImpl.random(40, 280);
                    break;
                }
                this.SetWormWeaponAnimation();
                break;
            }
            case 27: {
                this.Worm_SetCrtAnim(49);
                break;
            }
            case 34: {
                this.Worm_SetCrtAnim(80);
                break;
            }
            case 28: {
                ++GameImpl._shootCounter;
                this.UseCurrentWeaponOnce();
                this.Worm_SetCrtAnim(81);
                this._timer = GameImpl.canvas.getAppTime();
                break;
            }
            case 2: {
                if (!Level._fixCamera) break;
                Level.DoFollowEntity(GameImpl._nActiveWormID);
                break;
            }
            case 7: {
                this._bdata[8] = 0;
                if (this.Worm_IsBigFall()) {
                    this.Worm_SetCrtAnim(23);
                    _start_fall_pos_y = this._pos_y;
                    _damage_fall_taken = 0;
                    if (!this.Worm_IsHugeFall()) break;
                    this._bdata[8] = 1;
                    break;
                }
                this.Worm_SetCrtAnim(21);
                break;
            }
            case 25: {
                this._prevState = 25;
                break;
            }
            case 23: {
                this._prevState = 23;
                this.Worm_SetCrtAnim(45);
                this._velY = 0;
                if (GameImpl._teamsWeapons[this._bdata[3]][8] != -1 && GameImpl._teamsWeapons[this._bdata[3]][8] != 0) {
                    int[] nArray = GameImpl._teamsWeapons[this._bdata[3]];
                    nArray[8] = nArray[8] - 1;
                    GameImpl.UseCrateWeapon(this, 8);
                }
                this._bdata[14] = 0;
                break;
            }
            case 8: {
                if (this._crt_anim == 24) {
                    if (Math.abs(this._pos_y - _start_fall_pos_y) > Constants.MIN_FALL_DAMAGE_DIST) {
                        int n = this._pos_y - _start_fall_pos_y;
                        if (n > Constants.MAX_FALL_DAMAGE_DIST) {
                            n = Constants.MAX_FALL_DAMAGE_DIST;
                        }
                        if ((_damage_fall_taken = (int)(((long)(n * 30) << 16) / (long)Constants.MAX_FALL_DAMAGE_DIST) >> 16) <= 0) {
                            _damage_fall_taken = 1;
                        }
                        if (_damage_fall_taken > 30) {
                            _damage_fall_taken = 30;
                        }
                    } else {
                        _damage_fall_taken = 0;
                    }
                    if (this._bdata[8] == 1) {
                        this.Worm_SetCrtAnim(38);
                        break;
                    }
                    this.Worm_SetCrtAnim(25);
                    break;
                }
                this.Worm_SetCrtAnim(22);
                break;
            }
            case 9: {
                if (Level._fixCamera) {
                    Level.DoFollowEntity(GameImpl._nActiveWormID);
                }
                this._idata[2] = this._pos_y;
                if (this._bdata[7] == 0) {
                    this.Worm_SetCrtAnim(3);
                } else {
                    this.Worm_SetCrtAnim(10);
                }
                GameImpl.PlaySound(0);
                break;
            }
            case 10: {
                this._bSimpleRebound = true;
                break;
            }
            case 11: {
                this.Worm_SetCrtAnim(12);
                break;
            }
            case 12: {
                this._yBounce = 21845;
                this._xBounce = 13107;
                this.Worm_SetCrtAnim(1);
                this._idata[2] = this._pos_y;
                break;
            }
            case 13: {
                this._bSimpleRebound = true;
                if (GameImpl._pCrtWorm != null && GameImpl._pCrtWorm._bdata[12] == 1) {
                    if (this._bdata[3] == 0) {
                        if (!Entity2.AreOpposingTeams(GameImpl._pCrtWorm._bdata[3], this._bdata[3]) && !GameImpl.isAPass_N_Play()) {
                            ++GameImpl._worms_friendlyKilled_total;
                        }
                    } else if (!GameImpl.isAPass_N_Play()) {
                        ++GameImpl._worms_killed_AI_total;
                    }
                }
                if (GameImpl._pCrtWorm._bdata[15] != 24) {
                    GameImpl._eventMessageDisplayed = true;
                    if (this._bdata[12] == 1) {
                        GameImpl._msgWormIsHuman = true;
                        GameImpl._msgType = 1;
                    } else {
                        GameImpl._msgWormIsHuman = false;
                        GameImpl._msgType = 1;
                    }
                }
                this.Worm_SetCrtAnim(9);
                break;
            }
            case 14: {
                isSinking = true;
                if (!GameImpl._eventMessageDisplayed) {
                    GameImpl._eventMessageDisplayed = true;
                    if (this._bdata[12] == 1) {
                        GameImpl._msgWormIsHuman = true;
                        GameImpl._msgType = 1;
                    } else {
                        GameImpl._msgWormIsHuman = false;
                        GameImpl._msgType = 0;
                    }
                }
                this._bSimpleRebound = true;
                if (GameImpl._pCrtWorm != null && GameImpl._pCrtWorm._bdata[12] == 1) {
                    if (this._bdata[3] == 0) {
                        if (!Entity2.AreOpposingTeams(GameImpl._pCrtWorm._bdata[3], this._bdata[3]) && !GameImpl.isAPass_N_Play()) {
                            ++GameImpl._worms_friendlyKilled_total;
                        }
                    } else if (!GameImpl.isAPass_N_Play()) {
                        ++GameImpl._worms_killed_AI_total;
                    }
                }
                this.Worm_SetCrtAnim(26);
                this._z_order = 6;
                this.ResetSpeed();
                this._velY = 131072;
                break;
            }
            case 15: {
                try {
                    this._bSimpleRebound = true;
                    this._sprite = 7;
                    this._flags &= 0xFFFFFFBF;
                    this.SetCrtAnim(GameImpl._chosen_tomb[this._bdata[3]]);
                    this._z_order = 2;
                    this.Explode(this._pos_x >> 16, this._pos_y >> 16, 29);
                    this._bHitByAxe = false;
                    this._bEffectedByGas = false;
                    this._idata[9] = 0;
                    Level.CheckTriggers((short)61, this, false);
                    byte by4 = this._bdata[3];
                    GameImpl._nTeamWormCount[by4] = GameImpl._nTeamWormCount[by4] - 1;
                }
                catch (Exception exception) {}
                break;
            }
            case 16: {
                this._bdata[10] = 1;
                break;
            }
            case 33: {
                _targetShowCursor = false;
                this.Worm_AddConcreteDonkey();
                break;
            }
            case 32: {
                this.Worm_AddBunkerBuster();
                break;
            }
            case 3: {
                if (GameImpl._shootCounter >= this.GetCurrentWeaponNoRounds()) {
                    this.Worm_SetState((byte)0);
                    break;
                }
                this._bdata[9] = 0;
                _shootPower = 0;
                if (this._bdata[5] == 1) {
                    this._flags |= 1;
                }
                if (this._bdata[15] == 34 && this._bdata[12] == 1) {
                    this.Worm_SetState((byte)27);
                }
                if (this._bdata[15] != 35 || this._bdata[12] != 1) break;
                this.Worm_SetState((byte)34);
                break;
            }
            case 5: {
                int n = 0;
                n = GameImpl._pCrtWorm._bdata[15] == 12 ? 2 : 8;
                this._nContShootTimer = (n + 1) * 5 - 1;
            }
            case 4: {
                if (this._bdata[15] != 33) {
                    GameImpl.SetSoftKeys(385, -1);
                }
                _shootPower = 327680;
                this._bdata[9] = 0;
                if (GameImpl._shootCounter < this.GetCurrentWeaponNoRounds()) break;
                this.Worm_SetState((byte)0);
                break;
            }
            case 17: {
                this.Worm_SetCrtAnim(7);
                this._z_order = 6;
                GameImpl.SetGamePlayState(3);
                break;
            }
            case 19: {
                ++GameImpl._shootCounter;
                this.UseCurrentWeaponOnce();
                this.Worm_SetCrtAnim(43);
                break;
            }
            case 35: {
                if (!this.IsCrtAnimEnded()) break;
                this.Worm_SetCrtAnim(7);
                this.Worm_SetState((byte)1);
                break;
            }
            case 20: {
                if (GameImpl._pCrtWorm != null) {
                    this.SetWormDirection(GameImpl._pCrtWorm._bdata[5]);
                }
                this.Worm_SetCrtAnim(14);
                this._velX = this._bdata[5] * 786432;
                this._velY = 0;
                this._bdata[13] = 1;
                break;
            }
            case 18: {
                ++GameImpl._shootCounter;
                this.UseCurrentWeaponOnce();
                this.Worm_SetCrtAnim(19);
                break;
            }
            case 21: {
                this.Worm_SetCrtAnim(60);
                break;
            }
            case 22: {
                this.Worm_SetCrtAnim(64);
                break;
            }
            case 24: {
                ++GameImpl._shootCounter;
                this._timer = GameImpl.canvas.getAppTime();
                break;
            }
            case 26: {
                if (!GameImpl.IsTutorial()) {
                    _bDisablePauseMenu = true;
                }
                this.SetCrtAnim(GameImpl._chosen_dance[this._bdata[3]]);
                this._flags &= 0xFFFFFFBF;
                break;
            }
            case 29: {
                Level.HideTimer();
                GameImpl.SetSoftKeys(385, -1);
                this.Worm_SetCrtAnim(41);
                if (_targetEntity != null) {
                    Level.DisableEntity(Entity._targetEntity._id);
                    _targetEntity = null;
                }
                if (GameImpl._pCrtWorm._bdata[12] == 0) {
                    _targetSelectPosX = Level._entities[Entity.target]._pos_x;
                    _targetSelectPosY = Level._entities[Entity.target]._pos_y;
                    _targetWorm = Level._entities[target];
                }
                _targetEntity = Level.SpawnEntity(4);
                _targetEntity.Init(4, _targetSelectPosX << 16, _targetSelectPosY << 16, null, null);
                _targetEntity.SetSprite(6);
                _targetShowCursor = false;
                Entity entity = Level.SpawnEntity(25);
                entity._pos_x = _targetSelectPosX;
                entity._flags |= 1;
                entity.SetSprite(5);
                entity.SetCrtAnim(24);
                int n = GameConstants.SCREEN_HEIGHT > 220 ? 200 : 120;
                entity._pos_y = Entity._targetWorm._pos_y - (n << 16);
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                this.Worm_SetCrtAnim(46);
                this._flags &= 0xFFFFFFBF;
            }
        }
    }

    void NPC_Draw(SDKGraphics sDKGraphics) {
        int n = GameImpl.SV_X + (this._pos_x >> 16) - Level._nCamX;
        int n2 = GameImpl.SV_Y + (this._pos_y >> 16) - Level._nCamY + 0;
        int n3 = this._flags & 7;
        GameImpl._sprites[this._sprite].DrawAnimFrame(this._crt_anim, this._crt_aframe, n, n2, n3);
    }

    void Worm_Draw(SDKGraphics sDKGraphics) {
        int n = GameImpl.SV_X + (this._pos_x >> 16) - Level._nCamX;
        int n2 = GameImpl.SV_Y + (this._pos_y >> 16) - Level._nCamY + 0;
        int n3 = n;
        int n4 = n2;
        int n5 = this._flags & 7;
        XSprite xSprite = GameImpl._sprites[this._sprite];
        if (this._crt_anim < 0) {
            return;
        }
        if (!GameImpl._isFiringRange) {
            if (this != GameImpl._pCrtWorm && this._type == 1 || this._nState == 26) {
                XSprite.SetHat(this._nHatIndex);
            }
        } else if (this._id != GameImpl._pCrtWorm._id) {
            XSprite.SetHat(0);
        }
        XSprite._nWormWeaponIndex = -1;
        if (this._type == 1) {
            XSprite._nWormWeaponIndex = this._bdata[15];
        }
        xSprite.DrawAnimFrame(this._crt_anim, this._crt_aframe, n3, n4, n5);
        if (this._bdata[15] == 23 && this._nState == 1 && this._nState == 3 && this._nState == 4) {
            GameImpl._sprites[2].DrawFrame(232, n3, n4, n5);
        }
        block0 : switch (this._nState) {
            case 1: 
            case 3: 
            case 39: {
                if (this._bdata[15] == 26) {
                    if (this._idata[5] > 32768) {
                        GameImpl._sprites[1].DrawFrame(337, n3, n4, n5);
                    } else if (this._idata[5] > 16384) {
                        GameImpl._sprites[1].DrawFrame(338, n3, n4, n5);
                    } else {
                        GameImpl._sprites[1].DrawFrame(339, n3, n4, n5);
                    }
                }
                if (!(GameImpl._nGamePlayState == 9 && this._id != GameImpl._pendingWorm && !GameImpl._bDrawLife || GameImpl.GetGameState() == 4 || GameImpl.IsTutorial() || GameImpl._bShowEnemyPresentation && Level._entities[Level._followEntityPointer] == this)) {
                    if (GameImpl._nGameMode == 4) {
                        this.Worm_DrawAboveHead(1000, n, n2 - 34, false);
                    } else if (GameImpl._nGameMode == 3) {
                        this.Worm_DrawAboveHead(this._health / 100, n, n2 - 34, false);
                    } else {
                        this.Worm_DrawAboveHead(this._health, n, n2 - 34, false);
                    }
                }
                switch (this._bdata[15]) {
                    case 14: {
                        if (!_targetShowCursor) break block0;
                        int n6 = _airstrikeDirection == -1 ? 1 : 0;
                        int n7 = 0;
                        if (this.Worm_Collided(Level._nCursorPosX << 16, Level._nCursorPosY << 16)) {
                            n7 = 4;
                        }
                        GameImpl._sprites[6].DrawFrame(n7, Level._nCursorPosX - Level._nCamX, Level._nCursorPosY - Level._nCamY, n6);
                        break block0;
                    }
                    case 17: 
                    case 28: {
                        if (!_targetShowCursor) break block0;
                        int n8 = _airstrikeDirection == -1 ? 1 : 0;
                        int n9 = 0;
                        GameImpl._sprites[6].DrawFrame(n9, Level._nCursorPosX - Level._nCamX, Level._nCursorPosY - Level._nCamY, n8);
                        break block0;
                    }
                    case 5: 
                    case 11: {
                        if (!_targetShowCursor) break block0;
                        int n10 = _airstrikeDirection == -1 ? 2 : 1;
                        GameImpl._sprites[6].DrawFrame(n10, Level._nCursorPosX - Level._nCamX, Level._nCursorPosY - Level._nCamY, 0);
                        break block0;
                    }
                    case 9: {
                        break block0;
                    }
                    case 6: {
                        if (_targetShowCursor) {
                            int n11 = _airstrikeDirection == -1 ? 1 : 0;
                            GameImpl._sprites[6].DrawFrame(0, Level._nCursorPosX - Level._nCamX, Level._nCursorPosY - Level._nCamY, n11);
                            break block0;
                        }
                        if (this._nState != 3 && this._nState != 39) break block0;
                        this.Worm_TargetAndPower(n, n2);
                        break block0;
                    }
                    case 24: {
                        break block0;
                    }
                    case 102: {
                        if (!_targetShowCursor) break block0;
                        GameImpl._sprites[6].DrawFrame(4, (_targetSelectPosX >> 16) - Level._nCamX, (_targetSelectPosY >> 16) - Level._nCamY, 0);
                        break block0;
                    }
                    case 20: {
                        if (SDKCanvas.isKeyPressed(10252)) break block0;
                        this.Worm_SetCrtAnim(70);
                        break block0;
                    }
                    case 27: {
                        if (SDKCanvas.isKeyPressed(10252)) break block0;
                        this.Worm_SetCrtAnim(88);
                        break block0;
                    }
                    case 32: {
                        if (SDKCanvas.isKeyPressed(10252)) break;
                        this.Worm_SetCrtAnim(72);
                    }
                }
                if (this._nState != 3 && this._nState != 39 && this._nState != 5) break;
                this.Worm_TargetAndPower(n, n2);
                break;
            }
            case 17: {
                this.Worm_DrawBinocular(sDKGraphics);
                break;
            }
            case 4: 
            case 5: {
                switch (this._bdata[15]) {
                    case -1: 
                    case 5: 
                    case 8: 
                    case 11: 
                    case 14: 
                    case 17: 
                    case 24: 
                    case 28: 
                    case 29: 
                    case 102: {
                        break block0;
                    }
                }
                this.Worm_TargetAndPower(n, n2);
                break;
            }
            case 25: {
                this.Worm_DrawAboveHead(this._idata[7] >> 16, n3, n4 - 40, true);
            }
        }
        if (this._nState == 3 && !SDKCanvas.isKeyPressed(10252)) {
            switch (this._bdata[15]) {
                case 10: {
                    GameImpl._sprites[1].DrawFrame(341, n3, n4, n5);
                    break;
                }
                case 22: {
                    GameImpl._sprites[1].DrawFrame(340, n3, n4, n5);
                }
            }
        }
        if (this._type == 1) {
            XSprite.SetHat(-1);
        }
        if (GameImpl._isFiringRange) {
            return;
        }
        if (((!GameImpl._bShowEnemyPresentation || Level._entities[Level._followEntityPointer] != this) && this._type == 1 && this._bdata[19] == 1 || this._type == 1 && this._bdata[21] > 0) && (GameImpl._tips_drawn_flag & 1) == 0) {
            GameImpl._sprites[9].DrawAnimFrame(10, GameImpl._nGameTimer % 5, n, n2 - 65, 0);
            if (GameImpl._nLevelType != 1 || this._bdata[21] <= 0) {
                // empty if block
            }
        }
    }

    void Worm_Update() {
        if (ArmageddonInUse) {
            return;
        }
        if (this._pos_y >= (Level._sea_level << 16) + 0x180000) {
            this.Worm_SetState((byte)14);
        } else if ((this._flags & 0x400) != 0 && this._nState != 18 && this._nState != 20) {
            if (!this.Worm_Collided(this._pos_x, this._pos_y + 65536) && this._nState != 11 && this._nState != 25 && this._bdata[15] != 32) {
                if (this._bdata[14] == 0) {
                    this.Worm_SetState((byte)7);
                } else {
                    this.Worm_SetState((byte)23);
                }
            }
            this._flags &= 0xFFFFFBFF;
        }
        if (!_changingWind) {
            this.UpdateCurrentWorm();
            this.ProcessWormCommands();
        }
        byte by = this._nState;
        if (GameImpl._nGamePlayState == 2 && this._bdata[21] > 0) {
            this._bdata[21] = (byte)(this._bdata[21] - 1);
        }
        block0 : switch (this._nState) {
            case 27: {
                if ((_nCommands & 0x10) == 0) break;
                GameImpl.updateUsedWeaponUtilCount(34);
                GameImpl._bRetreating = false;
                ++GameImpl._shootCounter;
                GameImpl.SetGamePlayState(5);
                this._bdata[15] = -1;
                this.Worm_SetState((byte)0);
                break;
            }
            case 34: {
                if (this._crt_anim == 47 && this.IsCrtAnimEnded()) {
                    for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
                        Entity entity = Level._entities[i];
                        if (entity == null || (entity._flags & 0x18) != 0 || entity._bdata[3] != this._bdata[3]) continue;
                        Level.DisableEntity(entity._id);
                    }
                    GameImpl.SetGamePlayState(5);
                    return;
                }
                if (GameImpl._isFiringRange) {
                    this.Worm_SetCrtAnim(80);
                    if ((_nCommands & 0x10) == 0) break;
                    GameImpl.updateUsedWeaponUtilCount(35);
                    this._bdata[15] = -1;
                    this.Worm_SetState((byte)0);
                    GameImpl.SetGamePlayState(5);
                    break;
                }
                if ((_nCommands & 0x10) == 0) break;
                GameImpl._nTeamWormCount[GameImpl._pCrtWorm._bdata[3]] = 0;
                ++GameImpl._shootCounter;
                for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
                    Entity entity = Level._entities[i];
                    if ((entity._flags & 0x18) != 0 || entity._bdata[3] != this._bdata[3]) continue;
                    entity.Worm_SetState((byte)34);
                    entity.Worm_SetCrtAnim(47);
                }
                break;
            }
            case 0: {
                _bunkeronehit = false;
                if (this.Worm_Collided(this._pos_x, this._pos_y + 65536) || (this._flags & 0x8000) != 0) {
                    this.Worm_SetState((byte)1);
                    break;
                }
                this.Worm_SetState((byte)7);
                break;
            }
            case 5: {
                this.Update_ContShooting();
                break;
            }
            case 4: 
            case 40: {
                this.Update_Shooting();
                break;
            }
            case 1: {
                this.Worm_UpdateStanding();
                break;
            }
            case 2: {
                if ((_nCommands & 1) != 0 || (_nCommands & 2) != 0) {
                    this.Worm_SetCrtAnim(8);
                    break;
                }
                this.Worm_SetState((byte)0);
                break;
            }
            case 7: {
                if (this.Worm_Collided(this._pos_x, this._pos_y + 65536) || (this._flags & 0x8000) != 0) {
                    this.Worm_SetState((byte)8);
                    break;
                }
                if (this._crt_anim != 23 || !this.IsCrtAnimEnded()) break;
                this.SetCrtAnim(24);
                break;
            }
            case 23: {
                this._velX += (int)((long)GameImpl._windSpeedX * 13107L >> 16);
                if (this.IsCrtAnimEnded() && this._crt_anim == 45) {
                    this.Worm_SetCrtAnim(44);
                    this._flags &= 0xFFFFFFBF;
                }
                if (!this.Worm_Collided(this._pos_x, this._pos_y + 65536) && (this._flags & 0x8000) == 0) break;
                this.Worm_SetState((byte)8);
                GameImpl.SetSoftKeys(385, 386);
                break;
            }
            case 8: {
                if (!this.IsCrtAnimEnded()) break;
                switch (this._crt_anim) {
                    case 25: 
                    case 38: {
                        if (_damage_fall_taken != 0) {
                            this.Worm_HandleHit(26, _damage_fall_taken);
                            this._bdata[18] = 1;
                            this.SetCrtAnim(20);
                            GameImpl.ShowTip(2);
                            break block0;
                        }
                        this.SetCrtAnim(22);
                        break block0;
                    }
                }
                this.Worm_SetState((byte)1);
                break;
            }
            case 3: 
            case 39: {
                if (GameImpl._bRetreating && (this._flags & 0x8000) == 0 || this._bdata[15] == 26 || this._bdata[15] == 20 || this._bdata[15] == 21 || this._bdata[15] == 9 || this._bdata[15] == 15 || this._bdata[15] == 8 || this._bdata[15] == 32 || this._bdata[15] == 2 || this._bdata[15] == 27) break;
                this.SetWormAimAnimation();
                break;
            }
            case 16: {
                this.Worm_UpdateTeleport();
                break;
            }
            case 13: {
                if (!this.IsCrtAnimEnded()) break;
                this.Worm_SetState((byte)15);
                GameImpl.ShowTip(16);
                break;
            }
            case 15: {
                break;
            }
            case 9: {
                if (!this.IsCrtAnimEnded()) break;
                if (this._bdata[7] == 1) {
                    this.Worm_SetCrtAnim(11);
                    this._velX = -this._bdata[5] * (int)(589824L * (long)GameImpl.Cos(85) >> 16);
                    this._velY -= (int)(589824L * (long)GameImpl.Sin(85) >> 16);
                } else {
                    this.Worm_SetCrtAnim(4);
                    this._velX = this._bdata[5] * (int)(393216L * (long)GameImpl.Cos(65) >> 16);
                    this._velY -= (int)(393216L * (long)GameImpl.Sin(65) >> 16);
                }
                this.Worm_SetState((byte)10);
                break;
            }
            case 10: {
                if (this._bdata[2] == 0) break;
                switch (this._crt_anim) {
                    case 4: 
                    case 11: {
                        if (this._pos_y > this._idata[2]) {
                            if (this._bdata[14] == 0) {
                                this.Worm_SetState((byte)7);
                                break;
                            }
                            this.Worm_SetState((byte)23);
                            break;
                        }
                        if (!this.Worm_Collided(this._pos_x, this._pos_y + 65536)) break;
                        this.Worm_SetState((byte)8);
                    }
                }
                break;
            }
            case 11: {
                int n = GameImpl.Atan2(this._velX >> 16, this._velY >> 16);
                int n2 = 7;
                int n3 = (180 - Math.abs(n)) / (180 / n2 + 1);
                int n4 = GameImpl.Distance(this._velX >> 16, this._velY >> 16);
                if (n4 == 0 && this._velY >> 16 != 0) break;
                this.SetCrtAnim(12 + n3);
                if (n > -1) {
                    this.SetWormDirection(1);
                    break;
                }
                this.SetWormDirection(-1);
                break;
            }
            case 12: {
                if (Math.abs(this._pos_y - this._idata[2]) > 0x1E0000) {
                    this.Worm_SetState((byte)11);
                }
                if (this._velX != 0 || this._velY != 0) break;
                this.Worm_SetState((byte)0);
                break;
            }
            case 17: {
                if (GameImpl._nGamePlayState == 2) {
                    GameImpl._pCrtWorm.Worm_SetState((byte)1);
                }
                GameImpl.updateUsedWeaponUtilCount(33);
                if (!GameImpl.IsTutorial() || GameImpl._bBinocularTutorialOnce || Level._nCursorPosX - 192 <= 8 || Level._nCursorPosX - 192 >= 208 || Level._nCursorPosY - 192 <= 53 || Level._nCursorPosY - 192 >= 153) break;
                GameImpl.SetGamePlayState(5);
                GameImpl._pCrtWorm.Worm_SetState((byte)0);
                int n = -1;
                GameImpl.SetMessage(337, -1, 0, n);
                GameImpl.SetCloseup(5);
                Level._isBinocularDisbaled = true;
                GameImpl._bBinocularTutorialOnce = true;
                break;
            }
            case 20: {
                if (this._velX >> 16 != 0) break;
                this.Worm_SetState((byte)0);
                break;
            }
            case 35: {
                if (!this.IsCrtAnimEnded()) break;
                this.Worm_SetCrtAnim(7);
                this.Worm_SetState((byte)1);
                break;
            }
            case 19: {
                int n = GameImpl._sprites[this._sprite].GetAnimFrameId(this._crt_anim, this._crt_aframe);
                if (n == 143) {
                    this.HandleRetreatTimer(9);
                    this.ShootSpartanPunch(this._bdata[15], (this._pos_x >> 16) + this._bdata[5] * 2, this._pos_y >> 16);
                }
                if (!this.IsCrtAnimEnded()) break;
                this.Worm_SetState((byte)1);
                break;
            }
            case 18: {
                if (this._crt_aframe == 10) {
                    this._velX = 0;
                    this._velY = -((int)(393216L * (long)GameImpl.Sin(90) >> 16));
                }
                if (this._crt_aframe < 10 || this._velY < 0) break;
                this.Worm_SetState((byte)7);
                this.HandleRetreatTimer();
                break;
            }
            case 28: {
                if (this._crt_aframe == 7) {
                    this.Worm_Shoot(27);
                }
                if (this._crt_aframe < 7) break;
                this.Worm_SetState((byte)1);
                this.HandleRetreatTimer();
                break;
            }
            case 24: {
                if (this._bdata[15] == 26) {
                    this.Worm_UpdateDrilling();
                    break;
                }
                if (this._bdata[15] == 20) {
                    this.Worm_UpdatePneumaticDrill();
                    break;
                }
                if (this._bdata[15] != 32) break;
                this.Worm_UpdateKamikaze();
                break;
            }
            case 26: {
                if (!GameImpl.IsTutorial()) {
                    _bDisablePauseMenu = true;
                }
                this.SetCrtAnim(GameImpl._chosen_dance[this._bdata[3]]);
                this._flags &= 0xFFFFFFBF;
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                Level.StartRetreatTimer();
                Level._currentRetreatTime = 1000L;
                this.Worm_SetState((byte)0);
                GameImpl._pCrtWorm.Worm_SetState((byte)3);
                GameImpl.EndCrtTurnNow();
                break;
            }
            case 21: 
            case 22: {
                if (!this.IsCrtAnimEnded()) break;
                this.Worm_Shoot(this._bdata[15]);
                this.Worm_SetState((byte)1);
                break;
            }
            case 25: {
                GameImpl._bForceMinimap = false;
                this.Worm_UpdateJetpacking();
            }
        }
        if (this._health <= 0 && this._nState != 15 && !GameImpl._isFiringRange && !GameImpl.IsTutorial()) {
            this.Worm_SetState((byte)13);
        }
        if (this._nState == by) {
            this._bdata[2] = (byte)(this._bdata[2] + 1);
        }
    }

    void Update_ContShooting() {
        if (GameImpl._bRetreating) {
            return;
        }
        this.SetWormAimAnimation();
        if (this._nContShootTimer <= 0) {
            if (this._bdata[15] != -1 && GameImpl._teamsWeapons[this._bdata[3]][this._bdata[15]] != -1 && (GameImpl._shootCounter == 0 || Level._isRealTime)) {
                this.UseCurrentWeaponOnce();
            }
            ++GameImpl._shootCounter;
            this.Worm_SetState((byte)1);
            this.HandleRetreatTimer();
            return;
        }
        if (this._nContShootTimer % 5 == 0) {
            this._bdata[9] = 0;
            this.Worm_Shoot(this._bdata[15]);
        }
        --this._nContShootTimer;
    }

    void Update_Shooting() {
        if (GameImpl._bRetreating) {
            return;
        }
        if (this._bdata[9] == 0) {
            switch (this._bdata[15]) {
                case 0: 
                case 1: 
                case 6: 
                case 7: 
                case 13: 
                case 19: 
                case 25: {
                    boolean bl;
                    boolean bl2 = bl = (_nCommands & 0x20) != 0;
                    if (!bl) {
                        _shootPower += 327680;
                    }
                    if (_shootPower >> 16 < 100 && !bl) break;
                    GameImpl.StopSounds();
                    this.Worm_Shoot(this._bdata[15]);
                    this.Worm_SetState((byte)0);
                    break;
                }
                case 4: 
                case 5: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 22: 
                case 23: 
                case 24: 
                case 28: 
                case 31: 
                case 102: {
                    if (this._bdata[2] != 0) break;
                    this.Worm_Shoot(this._bdata[15]);
                    if (this._bdata[15] == 14 && this._nState != 43 && this._nState != 16) {
                        this.Worm_SetState((byte)3);
                        GameImpl._nGamePlayState = 3;
                        Level.SetCameraState(2);
                        _targetShowCursor = true;
                        return;
                    }
                    if (this._bdata[15] == 17 && this._nState != 32) {
                        this.Worm_SetState((byte)3);
                        GameImpl._nGamePlayState = 3;
                        Level.SetCameraState(3);
                        this.isRocketTailAnimOn = true;
                        return;
                    }
                    if (this._bdata[15] == 28 && this._nState != 33) {
                        this.Worm_SetState((byte)3);
                        GameImpl._nGamePlayState = 3;
                        Level.SetCameraState(3);
                        _targetShowCursor = true;
                        return;
                    }
                    if (this._bdata[12] == 1 && this._nState != 16) {
                        if (GameImpl._shootCounter >= this.GetCurrentWeaponNoRounds()) {
                            this.Worm_SetState((byte)1);
                        } else {
                            this.Worm_SetState((byte)3);
                        }
                    }
                    if (this._bdata[15] != 5 && this._bdata[15] != 11 && this._bdata[15] != 24 && this._bdata[15] != 102 && this._bdata[15] != 10 && this._bdata[15] != 16 && this._bdata[15] != 22 && this._bdata[15] != 14 && this._bdata[15] != 17) break;
                    this._bdata[15] = -1;
                    break;
                }
                case 21: {
                    this.Worm_SetState((byte)21);
                    break;
                }
                case 15: {
                    this.Worm_SetState((byte)22);
                    break;
                }
                case 9: {
                    this.Worm_SetState((byte)19);
                    break;
                }
                case 3: {
                    this.Worm_SetState((byte)18);
                    break;
                }
                case 27: {
                    this.Worm_SetState((byte)28);
                    break;
                }
                case 20: 
                case 26: 
                case 32: {
                    Level.HideTimer();
                    this.Worm_SetState((byte)24);
                    break;
                }
                case 2: {
                    this.Worm_SetState((byte)25);
                    this._idata[7] = 0x640000;
                    this.UseCurrentWeaponOnce();
                }
            }
        }
        if (this._bdata[9] == 1) {
            if (this._bdata[20] == 0) {
                switch (this._bdata[15]) {
                    case 12: {
                        if (GameImpl._shootCounter < this.GetCurrentWeaponNoRounds()) {
                            if (this._bdata[12] == 1) {
                                this.Worm_SetState((byte)3);
                                break;
                            }
                            this.Worm_SetState((byte)1);
                            break;
                        }
                        this.Worm_SetState((byte)1);
                    }
                }
            }
            this._bdata[20] = (byte)(this._bdata[20] - 1);
        }
    }

    void EndShooting(boolean bl) {
        Level.DisableEntity(this._id);
        if (_targetEntity != null) {
            if (GameImpl._pCrtWorm != null) {
                GameImpl._pCrtWorm._bdata[15] = -1;
            }
            Level.DisableEntity(Entity._targetEntity._id);
            _targetEntity = null;
        }
        if (this._projectileType == 14) {
            GameImpl._railgunProjectyle = null;
            GameImpl._railgunStartFrames = 0;
            this.Worm_SetState((byte)1);
        }
        if (this._projectileType == 5) {
            this._homingtail = false;
        }
        if (this._type == 11 || this._type == 20 || this._type == 24 || this._type == 26) {
            GameImpl._sheepEntity = null;
            GameImpl._DragonballEntity = null;
            GameImpl._bDisableUpdateWormControls = false;
            if (GameImpl._bRetreating) {
                GameImpl._bRetreating = false;
            }
        }
        if (this._type == 23 && GameImpl._bRetreating) {
            GameImpl._bRetreating = false;
        }
        if (GameImpl._pCrtWorm != null && !this.IsWormMoving()) {
            GameImpl._pCrtWorm.Worm_SetState((byte)1);
        }
        if (GameImpl.GetGameState() == 18 || GameImpl.GetGameState() == 19) {
            return;
        }
        GameImpl._nShootEndFrames = bl ? 0 : 2;
        Level.SetCameraState(4);
    }

    void InitAddDummy() {
        _targetShowCursor = true;
        this._idata[3] = this._pos_x >> 16;
        this._idata[4] = this._pos_y >> 16;
        GameImpl.SetGamePlayState(3);
        Level.SetCameraState(1);
    }

    int FindDisabledWorm() {
        for (int i = 0; i < 6; ++i) {
            if ((Level._entities[Level._nFirstWormIndex + i]._flags & 0x18) != 24 && (Level._entities[Level._nFirstWormIndex + i]._flags & 0x10) != 16) continue;
            return Level._entities[Level._nFirstWormIndex + i]._id;
        }
        return -1;
    }

    void AddDummy() {
        if (!this.Worm_Collided(Level._nCursorPosX << 16, Level._nCursorPosY << 16) && DummiesCount <= 5) {
            int n = 0;
            n = this.FindDisabledWorm();
            if (n != -1) {
                DummiesCount = (byte)(DummiesCount + 1);
                Level._entities[n]._pos_x = Level._nCursorPosX << 16;
                Level._entities[n]._pos_y = Level._nCursorPosY << 16;
                Level._entities[n].SetPosition(Level._nCursorPosX << 16, Level._nCursorPosY << 16);
                Level._entities[n]._flags &= 0xFFFFFFEF;
                Level._entities[n]._flags &= 0xFFFFFFE7;
                Level._entities[n]._velX = 0;
                Level._entities[n]._velY = 0;
                Level._entities[n].Worm_SetState((byte)7);
            }
        }
    }

    void ProcessWormCommands() {
        boolean bl;
        if (this._id != GameImpl._nActiveWormID) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        if (this._bdata[12] == 1 && GameImpl._nGamePlayState == 3) {
            bl2 = true;
        } else if (this == Level.GetEntitySafe(Level._followEntityPointer) && GameImpl._nGamePlayState == 2 || GameImpl._nGamePlayState == 5 && Level._isRealTime) {
            this._bdata[9] = 0;
            bl3 = true;
        }
        if (!(bl2 != bl3 || GameImpl._bRetreating && this._bdata[12] == 1)) {
            this.ResetCommands();
            return;
        }
        if (_nCommands == 0) {
            if (this._nState == 2) {
                this.Worm_SetState((byte)0);
            } else if (this._nState == 1 || this._nState == 3) {
                ++GameImpl._wormIdleFrames;
            }
            return;
        }
        this._bdata[21] = 0;
        GameImpl._wormIdleFrames = 0;
        boolean bl4 = (_nCommands & 1) != 0;
        boolean bl5 = (_nCommands & 2) != 0;
        boolean bl6 = (_nCommands & 0x40) != 0;
        boolean bl7 = (_nCommands & 0x80) != 0;
        boolean bl8 = (_nCommands & 4) != 0;
        boolean bl9 = bl = (_nCommands & 8) != 0;
        if (GameImpl._nGameMode == 1 && GameImpl._nLevelType == 2) {
            if (bl4 || bl5) {
                this.SetWormDirection(bl4 ? -1 : 1);
                bl4 = false;
                bl5 = false;
            }
            bl8 = false;
            bl = false;
        }
        if (bl4 && bl5 || bl8 && bl || bl6 && bl7) {
            return;
        }
        if (!GameImpl._bRetreating && (_nCommands & 0x10) != 0 && this._bdata[15] != 8 && this._bdata[15] != 34 && this._nState != 27 && this._nState != 34) {
            this.ResetCommands();
            if (this._bdata[15] == 29) {
                ArmageddonInUse = true;
                this.Worm_SetState((byte)0);
                this.Worm_ShootArmageddon();
                return;
            }
            if (GameImpl.IsPowerWeapon(this._bdata[15])) {
                GameImpl.StopSounds();
                GameImpl.PlaySound(4);
            }
            if (this._bdata[15] == 30) {
                this.Worm_SetState((byte)5);
            } else {
                this.Worm_SetState((byte)4);
            }
            return;
        }
        if (bl6 || bl7) {
            if (!(this._bdata[15] == 6 && this._bdata[15] == 29 || _targetShowCursor)) {
                switch (this._nState) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 24: {
                        if (GameImpl._bRetreating || !GameImpl.IsAimedWeapon(this._bdata[15])) break;
                        if (this._bdata[15] == 26) {
                            if (bl6 && this._idata[5] < 49152 && GameImpl._nGameTimer - this._idata[8] > 8) {
                                this._idata[5] = this._idata[5] + 16384;
                                this._idata[8] = GameImpl._nGameTimer;
                            }
                            if (!bl7 || this._idata[5] <= 16384 || GameImpl._nGameTimer - this._idata[8] <= 8) break;
                            this._idata[5] = this._idata[5] - 16384;
                            this._idata[8] = GameImpl._nGameTimer;
                            break;
                        }
                        if (this._bdata[15] == 32) {
                            if (bl6 && this._idata[5] <= 49152 && GameImpl._nGameTimer - this._idata[8] > 8) {
                                this._idata[5] = this._idata[5] + 16384;
                                this._idata[8] = GameImpl._nGameTimer;
                            }
                            if (!bl7 || this._idata[5] < 16384 || GameImpl._nGameTimer - this._idata[8] <= 8) break;
                            this._idata[5] = this._idata[5] - 16384;
                            this._idata[8] = GameImpl._nGameTimer;
                            break;
                        }
                        if (this._bdata[15] == 20) {
                            this._idata[5] = 0;
                            this._idata[8] = GameImpl._nGameTimer;
                            break;
                        }
                        if (bl6 && this._idata[5] < 65536) {
                            if (this._idata[5] < 49152 && this._bdata[15] == 21) {
                                this._idata[5] = this._idata[5] + 1092;
                            }
                            if (this._bdata[15] != 21) {
                                this._idata[5] = this._idata[5] + 1092;
                            }
                        }
                        if (bl7 && this._idata[5] > 0) {
                            if (this._idata[5] > 32768 && this._bdata[15] == 21) {
                                this._idata[5] = this._idata[5] - 1092;
                            }
                            if (this._bdata[15] != 21) {
                                this._idata[5] = this._idata[5] - 1092;
                            }
                        }
                        if (this._idata[5] > 65536) {
                            this._idata[5] = 65536;
                        }
                        if (this._idata[5] >= 0) break;
                        this._idata[5] = 0;
                    }
                }
            }
        } else if (bl8 || bl) {
            if (this._bdata[5] == 1 && bl8 || this._bdata[5] == -1 && bl) {
                this._bdata[7] = 1;
            } else if (this._bdata[5] == 1 && bl || this._bdata[5] == -1 && bl8) {
                this._bdata[7] = 0;
            }
            this.Worm_SetState((byte)9);
            _nCommands &= 0xFFFFFFFE;
            _nCommands &= 0xFFFFFFFD;
        } else if (bl4 || bl5) {
            _nCommands &= 0xFFFFFFFB;
            _nCommands &= 0xFFFFFFF7;
            switch (this._nState) {
                case 1: 
                case 2: 
                case 3: {
                    byte by = this._bdata[5];
                    this.SetWormDirection(bl4 ? -1 : 1);
                    if (by != this._bdata[5]) {
                        if (GameImpl.IsTutorial() && _tutorialAnim != null && Entity._tutorialAnim._bdata[1] != -1) {
                            if (this._bdata[5] == 1) {
                                _tutorialAnim.SetCrtAnim(Entity._tutorialAnim._bdata[1]);
                            } else {
                                _tutorialAnim.SetCrtAnim(Entity._tutorialAnim._bdata[0]);
                            }
                        }
                        return;
                    }
                    this.Worm_UpdateMovement();
                    break;
                }
                case 27: 
                case 34: {
                    this.Worm_UpdateMovement();
                    break;
                }
                case 23: {
                    if (bl4) {
                        this._velX -= 16384;
                        this._bdata[5] = -1;
                        this._flags &= 0xFFFFFFFE;
                        if (this._velX >= -262144) break;
                        this._velX = -262144;
                        break;
                    }
                    if (!bl5) break;
                    this._bdata[5] = 1;
                    this._flags |= 1;
                    this._velX += 16384;
                    if (this._velX <= 262144) break;
                    this._velX = 262144;
                }
            }
        }
        GameImpl._wormIdleFrames = 0;
    }

    void UpdateAIBlowTrouch(byte by, int n) {
        if (by == -1) {
            _nCommands = 1;
        }
        if (by == 1) {
            _nCommands = 2;
        }
        this.SelectWeapon((byte)26);
        Level.HideTimer();
        this.Worm_SetState((byte)24);
        this._idata[5] = n;
        this._bdata[0] = 48;
        this.Worm_Update();
    }

    void UpdateMyAIWorm() {
        switch (this._bdata[0]) {
            case 51: {
                if (GameImpl.canvas.getAppTime() - AI_WAIT_SHOOT <= 1800L) break;
                shouldShoot = true;
                GameImpl._pCrtWorm._bdata[0] = 46;
                break;
            }
            case 50: {
                GameImpl._pCrtWorm.Worm_SetCrtAnim(54);
                if (Level._turnTimeLeft >= (long)AI_WAIT_TIMER) break;
                this.Worm_SetAIState((byte)36);
                break;
            }
            case 44: {
                if (this.Worm_IsDyingOrDead()) {
                    return;
                }
                if (presentWeaponToUse == 4) {
                    this.MakeAIWalkForMine();
                    break;
                }
                if (presentWeaponToUse == 31) {
                    this.MakeAIWalkForDynamite();
                    break;
                }
                this.MakeAIWalk();
                break;
            }
            case 10: {
                break;
            }
            case 8: {
                break;
            }
            case 11: {
                break;
            }
            case 7: {
                break;
            }
            case 45: {
                if (GameImpl._pCrtWorm._nState != 9 && GameImpl._pCrtWorm._nState != 10) {
                    this.Worm_SetState((byte)9);
                    GameImpl._pCrtWorm._bdata[0] = 9;
                    GameImpl._pCrtWorm._nState = (byte)9;
                }
                if (GameImpl._pCrtWorm._nState != 8) break;
                GameImpl._pCrtWorm._bdata[0] = 44;
                break;
            }
            case 46: {
                int n = -1;
                switch (presentWeaponToUse) {
                    case 24: {
                        n = 0;
                        useLight = false;
                        this.Worm_SetState((byte)29);
                        this._bdata[0] = 0;
                        stopMovement = true;
                        break;
                    }
                    case 32: {
                        n = 0;
                        this.ShootKamikazi(target);
                        this._bdata[0] = 0;
                        stopMovement = true;
                        break;
                    }
                    case 12: {
                        n = 0;
                        this.setShotGun(target);
                        if (!shouldShoot) {
                            this.Worm_SetAIState((byte)51);
                        } else {
                            this.shootShotGun(target);
                        }
                        stopMovement = true;
                        break;
                    }
                    case 30: {
                        n = 0;
                        this.setAIUzi(target);
                        if (!shouldShoot) {
                            this.Worm_SetAIState((byte)51);
                        } else {
                            this.shootUzi(target);
                        }
                        stopMovement = true;
                        break;
                    }
                    case 5: 
                    case 11: 
                    case 17: {
                        n = 0;
                        _targetShowCursor = false;
                        this.PlaceAirStrikeWeapons(target, presentWeaponToUse);
                        this._bdata[0] = 0;
                        stopMovement = true;
                        break;
                    }
                    case 18: {
                        n = 0;
                        this.setRailGun(target);
                        if (!shouldShoot) {
                            this.Worm_SetAIState((byte)51);
                        } else {
                            this.shootRailGun(target);
                        }
                        stopMovement = true;
                    }
                }
                if (n == 0) break;
                this.AnalyzeWeapon(presentWeaponToUse);
                this._bdata[0] = 38;
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                this.UpdateAIWorm();
                stopMovement = Entity2.doAiHasToMoveFor(GameImpl._pCrtWorm._bdata[15]);
                break;
            }
            case 49: {
                int n = Entity2.getShortestPossibleWorm(this._id);
                int n2 = Level._entities[n]._pos_x;
                int n3 = Level._entities[n]._pos_y;
                this.Worm_Teleport(n2, n3);
                break;
            }
            case 47: {
                byte by = 0;
                int n = Entity2.getShortestPossibleWorm(this._id);
                int n4 = Level._entities[n]._pos_x;
                int n5 = Level._entities[n]._pos_y;
                by = n4 > this._pos_x ? (byte)1 : -1;
                this._idata[5] = n5 < this._pos_y ? (Math.abs((n5 >> 16) - (this._pos_y >> 16)) < 40 ? 32768 : 49152) : (Math.abs((n5 >> 16) - (this._pos_y >> 16)) < 40 ? 32768 : 16384);
                this.SetWormDirection(by);
                this.UpdateAIBlowTrouch(by, this._idata[5]);
            }
        }
        switch (this._nState) {
            case 27: {
                if (GameImpl.canvas.getAppTime() - this._timer < 2500L) break;
                GameImpl._bRetreating = false;
                ++GameImpl._shootCounter;
                GameImpl.SetGamePlayState(5);
                this.Worm_SetState((byte)0);
                break;
            }
            case 0: {
                if (this.Worm_Collided(this._pos_x, this._pos_y + 65536) || (this._flags & 0x8000) != 0) {
                    this.Worm_SetState((byte)1);
                    break;
                }
                this.Worm_SetState((byte)7);
                break;
            }
            case 8: {
                if (Constants.power_array[presentWeaponToUse] == 1) {
                    GameImpl._pCrtWorm._bdata[0] = 44;
                    break;
                }
                if (GameImpl._pCrtWorm._bdata[15] == 14) {
                    GameImpl._pCrtWorm._bdata[0] = 0;
                    break;
                }
                if (Constants.power_array[presentWeaponToUse] == 2 || Constants.power_array[presentWeaponToUse] == 3 || GameImpl._pCrtWorm._bdata[15] == 0) {
                    GameImpl._pCrtWorm._bdata[0] = 46;
                    break;
                }
                return;
            }
        }
    }

    boolean barreljumpcheck(int n, int n2) {
        for (int i = Level._nFirstBarrelIndex; i < Level._nOilBarrelsEntities + Level._nFirstBarrelIndex - 1; ++i) {
            Entity entity = Level._entities[i];
            if (!this.CollideWith(entity, n, n2)) continue;
            return true;
        }
        return false;
    }

    void MakeAIWalkForDynamite() {
        int n;
        int n2;
        int n3;
        ++GameImpl._shootCounter;
        if (jumpCounter >= MAX_JUMP_CTR) {
            stopMovement = true;
            _nCommands = 0;
            _nMoveCommand = 0;
            if (!mineplaced) {
                this.Worm_SetAIState((byte)41);
            } else {
                this.Worm_SetAIState((byte)0);
            }
            if (!mineplaced) {
                return;
            }
        }
        if (GameImpl._pCrtWorm._pos_x == wormPrevPosX && GameImpl._pCrtWorm._pos_y == wormPrevPosY) {
            if (!mineplaced) {
                _nCommands = 0;
                _nMoveCommand = 0;
                this.Worm_SetAIState((byte)41);
                return;
            }
            _nCommands = 0;
            _nMoveCommand = 0;
            this.Worm_SetAIState((byte)0);
            stopMovement = true;
        }
        int n4 = GameImpl._pCrtWorm._pos_x - Level._entities[Entity.target]._pos_x;
        int n5 = GameImpl._pCrtWorm._pos_y - Level._entities[Entity.target]._pos_y;
        int n6 = (int)Math.sqrt((n4 >>= 16) * n4 + (n5 >>= 16) * n5);
        if (!mineplaced && n6 < 25) {
            this._bdata[15] = 31;
            n3 = this.GetWormCenterY();
            n2 = this._pos_x;
            n = n3;
            int n7 = 0;
            int n8 = 0;
            Entity entity = Level.SpawnEntity(15);
            ++GameImpl._shootCounter;
            int n9 = this._bdata[5] * 786432;
            int n10 = n2 + n7 + n9 >> 16;
            int n11 = n + n8 >> 16;
            entity.Init(15, n10 << 16, n11 << 16, null, null);
            GameImpl._pCrtWorm._bdata[9] = 1;
            mineplaced = true;
            StartPosX = GameImpl._pCrtWorm._pos_x;
            StartPosY = GameImpl._pCrtWorm._pos_y;
            mineTimer = GameImpl.canvas.getAppTime();
            if (_nCommands == 1) {
                _nCommands = 0;
                _nMoveCommand = 1;
                _nCommands |= 2;
                GameImpl._pCrtWorm._bdata[5] = 1;
                this.SetWormDirection(1);
            } else {
                _nCommands = 0;
                _nMoveCommand = -1;
                _nCommands |= 1;
                GameImpl._pCrtWorm._bdata[5] = -1;
                this.SetWormDirection(-1);
            }
        }
        if (!mineplaced) {
            if (_nCommands == 1 && (Level.GetLandscapeCollision((GameImpl._pCrtWorm._pos_x >> 16) - 10, (GameImpl._pCrtWorm._pos_y >> 16) - 10) != 0 || this.barreljumpcheck(GameImpl._pCrtWorm._pos_x - 655360, GameImpl._pCrtWorm._pos_y - 655360)) && Entity2.jumpcheck(GameImpl._pCrtWorm._pos_x, GameImpl._pCrtWorm._pos_y)) {
                this.SetWormDirection(1);
                GameImpl._pCrtWorm._bdata[5] = 1;
                GameImpl._pCrtWorm._bdata[7] = 1;
                this._bdata[0] = 45;
                GameImpl._pCrtWorm._nState = (byte)45;
                ++jumpCounter;
                return;
            }
            if (_nCommands == 2 && (Level.GetLandscapeCollision((GameImpl._pCrtWorm._pos_x >> 16) + 10, (GameImpl._pCrtWorm._pos_y >> 16) - 10) != 0 || this.barreljumpcheck(GameImpl._pCrtWorm._pos_x + 655360, GameImpl._pCrtWorm._pos_y - 655360)) && Entity2.jumpcheck(GameImpl._pCrtWorm._pos_x, GameImpl._pCrtWorm._pos_y)) {
                this._bdata[0] = 45;
                this.SetWormDirection(-1);
                GameImpl._pCrtWorm._bdata[5] = -1;
                GameImpl._pCrtWorm._bdata[7] = 1;
                GameImpl._pCrtWorm._nState = (byte)45;
                ++jumpCounter;
                return;
            }
        } else {
            n3 = GameImpl._pCrtWorm._pos_x - StartPosX;
            n2 = GameImpl._pCrtWorm._pos_y - StartPosY;
            if ((n = (int)Math.sqrt((n3 >>= 16) * n3 + (n2 >>= 16) * n2)) > DYNAMITE_RETREAT_DIS) {
                this.HandleRetreatTimer();
                this._bdata[15] = -1;
                _nCommands = 0;
                _nMoveCommand = 0;
                GameImpl._pCrtWorm._bdata[0] = 0;
                if (GameImpl.canvas.getAppTime() - mineTimer > 5000L) {
                    GameImpl.EndCrtTurnNow();
                    stopMovement = true;
                }
                return;
            }
            if (_nCommands == 1 && (Level.GetLandscapeCollision((GameImpl._pCrtWorm._pos_x >> 16) - 10, (GameImpl._pCrtWorm._pos_y >> 16) - 10) != 0 || this.barreljumpcheck(GameImpl._pCrtWorm._pos_x - 655360, GameImpl._pCrtWorm._pos_y - 655360)) && Entity2.jumpcheck(GameImpl._pCrtWorm._pos_x, GameImpl._pCrtWorm._pos_y)) {
                this.SetWormDirection(1);
                GameImpl._pCrtWorm._bdata[5] = 1;
                GameImpl._pCrtWorm._bdata[7] = 1;
                this._bdata[0] = 45;
                GameImpl._pCrtWorm._nState = (byte)45;
                ++jumpCounter;
                return;
            }
            if (_nCommands == 2 && (Level.GetLandscapeCollision((GameImpl._pCrtWorm._pos_x >> 16) + 10, (GameImpl._pCrtWorm._pos_y >> 16) - 10) != 0 || this.barreljumpcheck(GameImpl._pCrtWorm._pos_x + 655360, GameImpl._pCrtWorm._pos_y - 655360)) && Entity2.jumpcheck(GameImpl._pCrtWorm._pos_x, GameImpl._pCrtWorm._pos_y)) {
                this._bdata[0] = 45;
                this.SetWormDirection(-1);
                GameImpl._pCrtWorm._bdata[5] = -1;
                GameImpl._pCrtWorm._bdata[7] = 1;
                GameImpl._pCrtWorm._nState = (byte)45;
                ++jumpCounter;
                return;
            }
        }
        wormPrevPosX = GameImpl._pCrtWorm._pos_x;
        wormPrevPosY = GameImpl._pCrtWorm._pos_y;
        this.Worm_SetCrtAnim(8);
        this.Worm_UpdateMovement();
    }

    void MakeAIWalkForMine() {
        int n;
        int n2;
        int n3;
        ++GameImpl._shootCounter;
        if (jumpCounter >= MAX_JUMP_CTR) {
            stopMovement = true;
            _nCommands = 0;
            _nMoveCommand = 0;
            if (!mineplaced) {
                this.Worm_SetAIState((byte)41);
            } else {
                this.Worm_SetAIState((byte)0);
            }
            if (!mineplaced) {
                return;
            }
        }
        if (GameImpl._pCrtWorm._pos_x == wormPrevPosX && GameImpl._pCrtWorm._pos_y == wormPrevPosY) {
            if (!mineplaced) {
                _nCommands = 0;
                _nMoveCommand = 0;
                this.Worm_SetAIState((byte)41);
                return;
            }
            _nCommands = 0;
            _nMoveCommand = 0;
            this.Worm_SetAIState((byte)0);
            stopMovement = true;
        }
        int n4 = GameImpl._pCrtWorm._pos_x - Level._entities[Entity.target]._pos_x;
        int n5 = GameImpl._pCrtWorm._pos_y - Level._entities[Entity.target]._pos_y;
        int n6 = (int)Math.sqrt((n4 >>= 16) * n4 + (n5 >>= 16) * n5);
        if (!mineplaced && n6 < 15) {
            this._bdata[15] = 4;
            n3 = this.GetWormCenterY();
            n2 = this._pos_x;
            n = n3;
            int n7 = 0;
            int n8 = 0;
            Entity entity = Level.SpawnEntity(13);
            ++GameImpl._shootCounter;
            int n9 = this._bdata[5] * 786432;
            int n10 = n2 + n7 + n9 >> 16;
            int n11 = n + n8 >> 16;
            entity.Init(13, n10 << 16, n11 << 16, null, null);
            entity._velX = 0;
            entity._velY = 0;
            entity._yBounce = 16384;
            entity._timer = GameImpl.canvas.getAppTime();
            entity._bdata[0] = 1;
            entity.Mine_SetState((byte)3);
            GameImpl._pCrtWorm._bdata[9] = 1;
            mineplaced = true;
            StartPosX = GameImpl._pCrtWorm._pos_x;
            StartPosY = GameImpl._pCrtWorm._pos_y;
            mineTimer = GameImpl.canvas.getAppTime();
            if (_nCommands == 1) {
                _nCommands = 0;
                _nMoveCommand = 1;
                _nCommands |= 2;
                GameImpl._pCrtWorm._bdata[5] = 1;
                this.SetWormDirection(1);
            } else {
                _nCommands = 0;
                _nMoveCommand = -1;
                _nCommands |= 1;
                GameImpl._pCrtWorm._bdata[5] = -1;
                this.SetWormDirection(-1);
            }
        }
        if (!mineplaced) {
            if (_nCommands == 1 && (Level.GetLandscapeCollision((GameImpl._pCrtWorm._pos_x >> 16) - 10, (GameImpl._pCrtWorm._pos_y >> 16) - 10) != 0 || this.barreljumpcheck(GameImpl._pCrtWorm._pos_x - 655360, GameImpl._pCrtWorm._pos_y - 655360)) && Entity2.jumpcheck(GameImpl._pCrtWorm._pos_x, GameImpl._pCrtWorm._pos_y)) {
                this.SetWormDirection(1);
                GameImpl._pCrtWorm._bdata[5] = 1;
                GameImpl._pCrtWorm._bdata[7] = 1;
                this._bdata[0] = 45;
                GameImpl._pCrtWorm._nState = (byte)45;
                ++jumpCounter;
                return;
            }
            if (_nCommands == 2 && (Level.GetLandscapeCollision((GameImpl._pCrtWorm._pos_x >> 16) + 10, (GameImpl._pCrtWorm._pos_y >> 16) - 10) != 0 || this.barreljumpcheck(GameImpl._pCrtWorm._pos_x + 655360, GameImpl._pCrtWorm._pos_y - 655360)) && Entity2.jumpcheck(GameImpl._pCrtWorm._pos_x, GameImpl._pCrtWorm._pos_y)) {
                this._bdata[0] = 45;
                this.SetWormDirection(-1);
                GameImpl._pCrtWorm._bdata[5] = -1;
                GameImpl._pCrtWorm._bdata[7] = 1;
                GameImpl._pCrtWorm._nState = (byte)45;
                ++jumpCounter;
                return;
            }
        } else {
            n3 = GameImpl._pCrtWorm._pos_x - StartPosX;
            n2 = GameImpl._pCrtWorm._pos_y - StartPosY;
            if ((n = (int)Math.sqrt((n3 >>= 16) * n3 + (n2 >>= 16) * n2)) > MINE_RETREAT_DIS) {
                this.HandleRetreatTimer();
                this._bdata[15] = -1;
                _nCommands = 0;
                _nMoveCommand = 0;
                if (GameImpl.canvas.getAppTime() - mineTimer > 9000L) {
                    GameImpl.EndCrtTurnNow();
                    GameImpl._pCrtWorm._bdata[0] = 0;
                    stopMovement = true;
                }
                return;
            }
            if (_nCommands == 1 && (Level.GetLandscapeCollision((GameImpl._pCrtWorm._pos_x >> 16) - 10, (GameImpl._pCrtWorm._pos_y >> 16) - 10) != 0 || this.barreljumpcheck(GameImpl._pCrtWorm._pos_x - 655360, GameImpl._pCrtWorm._pos_y - 655360)) && Entity2.jumpcheck(GameImpl._pCrtWorm._pos_x, GameImpl._pCrtWorm._pos_y)) {
                this.SetWormDirection(1);
                GameImpl._pCrtWorm._bdata[5] = 1;
                GameImpl._pCrtWorm._bdata[7] = 1;
                this._bdata[0] = 45;
                GameImpl._pCrtWorm._nState = (byte)45;
                ++jumpCounter;
                return;
            }
            if (_nCommands == 2 && (Level.GetLandscapeCollision((GameImpl._pCrtWorm._pos_x >> 16) + 10, (GameImpl._pCrtWorm._pos_y >> 16) - 10) != 0 || this.barreljumpcheck(GameImpl._pCrtWorm._pos_x + 655360, GameImpl._pCrtWorm._pos_y - 655360)) && Entity2.jumpcheck(GameImpl._pCrtWorm._pos_x, GameImpl._pCrtWorm._pos_y)) {
                this._bdata[0] = 45;
                this.SetWormDirection(-1);
                GameImpl._pCrtWorm._bdata[5] = -1;
                GameImpl._pCrtWorm._bdata[7] = 1;
                GameImpl._pCrtWorm._nState = (byte)45;
                ++jumpCounter;
                return;
            }
        }
        wormPrevPosX = GameImpl._pCrtWorm._pos_x;
        wormPrevPosY = GameImpl._pCrtWorm._pos_y;
        this.Worm_SetCrtAnim(8);
        this.Worm_UpdateMovement();
    }

    void MakeAIWalk() {
        if (stopMovement) {
            return;
        }
        if (jumpCounter >= MAX_JUMP_CTR) {
            stopMovement = true;
            _nCommands = 0;
            _nMoveCommand = 0;
            this.Worm_SetAIState((byte)41);
            return;
        }
        if (Level._followEntityPointer != GameImpl._nActiveWormID) {
            return;
        }
        if (aiWormPath[0] == -1 || aiWormPath[0] == 0) {
            return;
        }
        int n = GameImpl._pCrtWorm._pos_x - Level._entities[Entity.target]._pos_x;
        int n2 = GameImpl._pCrtWorm._pos_y - Level._entities[Entity.target]._pos_y;
        if (Math.abs(n >>= 16) < STUCK_LOW && Math.abs(n2 >>= 16) > STUCK_HIGH) {
            presentWeaponToUse = 1;
            GameImpl._pCrtWorm._bdata[15] = 1;
            _nCommands = 0;
            _nMoveCommand = 0;
            this._bdata[0] = 46;
            return;
        }
        if (n > 0) {
            _nMoveCommand = -1;
            _nCommands |= 1;
            GameImpl._pCrtWorm._bdata[5] = -1;
        } else {
            _nMoveCommand = 1;
            _nCommands |= 2;
            GameImpl._pCrtWorm._bdata[5] = 1;
        }
        int n3 = (int)Math.sqrt(n * n + n2 * n2);
        if (GameImpl._pCrtWorm._bdata[15] == 12 || GameImpl._pCrtWorm._bdata[15] == 30 || GameImpl._pCrtWorm._bdata[15] == 27) {
            if (n3 < SHOTGUN_MIN_FIRE_DIS) {
                _nCommands = 0;
                _nMoveCommand = 0;
                this._bdata[0] = 46;
                stopMovement = true;
                this.Worm_SetState((byte)0);
                jumpCounter = 0;
                return;
            }
        } else if (n3 < MINIMUM_FIRE_DIS) {
            _nCommands = 0;
            _nMoveCommand = 0;
            this._bdata[0] = 46;
            stopMovement = true;
            this.Worm_SetState((byte)0);
            jumpCounter = 0;
            return;
        }
        if (_nCommands == 1 && (Level.GetLandscapeCollision((GameImpl._pCrtWorm._pos_x >> 16) - 12, (GameImpl._pCrtWorm._pos_y >> 16) - 12) != 0 || this.barreljumpcheck(GameImpl._pCrtWorm._pos_x - 786432, GameImpl._pCrtWorm._pos_y - 65536)) && Entity2.jumpcheck(GameImpl._pCrtWorm._pos_x, GameImpl._pCrtWorm._pos_y)) {
            _nCommands = 0;
            this.SetWormDirection(1);
            GameImpl._pCrtWorm._bdata[5] = 1;
            GameImpl._pCrtWorm._bdata[7] = 1;
            this._bdata[0] = 45;
            GameImpl._pCrtWorm._nState = (byte)45;
            ++jumpCounter;
            return;
        }
        if (_nCommands == 2 && (Level.GetLandscapeCollision((GameImpl._pCrtWorm._pos_x >> 16) + 12, (GameImpl._pCrtWorm._pos_y >> 16) - 12) != 0 || this.barreljumpcheck(GameImpl._pCrtWorm._pos_x + 786432, GameImpl._pCrtWorm._pos_y - 786432)) && Entity2.jumpcheck(GameImpl._pCrtWorm._pos_x, GameImpl._pCrtWorm._pos_y)) {
            _nCommands = 0;
            this._bdata[0] = 45;
            this.SetWormDirection(-1);
            GameImpl._pCrtWorm._bdata[5] = -1;
            GameImpl._pCrtWorm._bdata[7] = 1;
            GameImpl._pCrtWorm._nState = (byte)45;
            ++jumpCounter;
            return;
        }
        if (GameImpl._pCrtWorm._pos_x == wormPrevPosX && GameImpl._pCrtWorm._pos_y == wormPrevPosY && ++noMovement >= 3) {
            _nCommands = 0;
            _nMoveCommand = 0;
            this.Worm_SetAIState((byte)41);
            return;
        }
        wormPrevPosX = GameImpl._pCrtWorm._pos_x;
        wormPrevPosY = GameImpl._pCrtWorm._pos_y;
        if (n > 0) {
            _nMoveCommand = -1;
            _nCommands |= 1;
            GameImpl._pCrtWorm._bdata[5] = -1;
        } else {
            _nMoveCommand = 1;
            _nCommands |= 2;
            GameImpl._pCrtWorm._bdata[5] = 1;
        }
        this.Worm_SetCrtAnim(8);
        this.Worm_UpdateMovement();
    }

    void UpdateCurrentWorm() {
        if (this == GameImpl._pCrtWorm && this._id == GameImpl._nActiveWormID && this._bdata[12] == 0) {
            this.UpdateMyAIWorm();
        }
    }

    void ResetCommands() {
        _nCommands = 0;
    }

    void UpdateInputCommands() {
        if (GameImpl._bDisableUpdateWormControls) {
            return;
        }
        _nCommands = GameImpl.isKeyPressed(2052) ? (_nCommands |= 1) : (_nCommands &= 0xFFFFFFFE);
        _nCommands = GameImpl.isKeyPressed(8200) ? (_nCommands |= 2) : (_nCommands &= 0xFFFFFFFD);
        if (GameImpl.isKeyPressed(513)) {
            _nCommands |= 0x40;
        }
        if (GameImpl.isKeyPressed(32770)) {
            _nCommands |= 0x80;
        }
        if (SDKCanvas.isNewKeyPressed(256) && this._nState != 23 && this._nState != 25 && !SDKCanvas.isNewKeyPressed(65536)) {
            _nCommands |= 4;
        }
        if (SDKCanvas.isNewKeyPressed(1024) && this._nState != 23 && this._nState != 25 && !SDKCanvas.isNewKeyPressed(65536)) {
            _nCommands |= 8;
        }
        if (GameImpl.isKeyPressed(0x3001010) && !GameImpl._bRetreating && this._bdata[15] != -1 && GameImpl._nGamePlayState == 2) {
            _nCommands = GameImpl._sTopMessageText != null && !GameImpl._triggered_top_message ? (_nCommands |= 0x200) : (this._nState == 24 || this._nState == 25 ? (_nCommands |= 0x20) : (_nCommands |= 0x10));
        }
        if (SDKCanvas.isNewKeyPressed(128) && this._bdata[9] == 0 && this._nState == 3 && GameImpl.IsFusedWeapon(this._bdata[15]) && Level._followEntityPointer == GameImpl._nActiveWormID && this._bdata[15] != 31) {
            ++GameImpl._nFusedTimer;
            if (GameImpl._pCrtWorm != null) {
                GameImpl._pCrtWorm._bdata[22] = 40;
            }
            if (GameImpl._nFusedTimer > 5) {
                GameImpl._nFusedTimer = 1;
            }
        }
    }

    void Worm_UpdateMovement() {
        int n = 131072 * this._bdata[5];
        int n2 = 0;
        if (this._nState == 24 && this._idata[5] >= 32768) {
            n <<= 1;
        }
        if ((n2 = this._nState == 24 && this._bdata[15] == 20 ? this.Worm_Walk(0, this._pos_x, this._pos_y) : this.Worm_Walk(n, this._pos_x, this._pos_y)) == -1) {
            if (this._nState == 24) {
                this.Worm_SetState((byte)0);
                return;
            }
            if (this._bdata[14] == 0) {
                this.Worm_SetState((byte)7);
            } else {
                this.Worm_SetState((byte)23);
            }
        }
        if (n2 == 1) {
            if (this._nState != 2 && this._nState != 24) {
                this.Worm_SetState((byte)2);
            }
            this.CheckWormCratesCollisions();
            GameImpl.PlaySound(2);
        } else if (this._nState == 2 || this._nState == 3) {
            this.Worm_SetState((byte)0);
        }
        this.Worm_ChangePos(this._idata[0], this._idata[1]);
    }

    int Worm_Walk(int n, int n2, int n3) {
        this._idata[0] = n2;
        this._idata[1] = n3;
        int n4 = this._idata[0] + n;
        int n5 = this._idata[1];
        int n6 = 65536;
        if (this.Worm_Collided(n4, n5)) {
            for (int i = 0; i < 4; ++i) {
                if (this.Worm_Collided(n4, n5 -= n6)) continue;
                this._idata[0] = n4;
                this._idata[1] = n5;
                if (i > 0) {
                    this._bdata[6] = 1;
                }
                return 1;
            }
            return 0;
        }
        for (int i = 0; i < 8; ++i) {
            if (this.Worm_Collided(n4, n5 + n6)) {
                this._idata[0] = n4;
                this._idata[1] = n5;
                this._bdata[6] = i > 0 && !this.Worm_Collided(n4 + n, n5 + (n6 << 1)) ? -1 : 0;
                return 1;
            }
            n5 += n6;
        }
        this._idata[0] = n4;
        return -1;
    }

    int Sheep_Walk(int n, int n2, int n3) {
        this._idata[0] = n2;
        this._idata[1] = n3;
        int n4 = this._idata[0] + n;
        int n5 = this._idata[1];
        int n6 = 65536;
        if (this.Worm_Collided(n4, n5)) {
            for (int i = 0; i < 4; ++i) {
                if (this.Worm_Collided(n4, n5 -= n6)) continue;
                this._idata[0] = n4;
                this._idata[1] = n5;
                if (i > 0) {
                    this._bdata[1] = 1;
                }
                return 1;
            }
            return 0;
        }
        for (int i = 0; i < 8; ++i) {
            if (this.Worm_Collided(n4, n5 + n6)) {
                this._idata[0] = n4;
                this._idata[1] = n5;
                this._bdata[1] = i > 0 && !this.Worm_Collided(n4 + n, n5 + (n6 << 1)) ? -1 : 0;
                return 1;
            }
            n5 += n6;
        }
        this._idata[0] = n4;
        return -1;
    }

    boolean Worm_Collided(int n, int n2) {
        return this.CollideWith(Level._entLevel, n, n2);
    }

    boolean Worm_CheckCollisionWith(int n, int n2) {
        return n > this._pos_x - 753664 && n < this._pos_x + 753664 && n2 <= this._pos_y && n2 >= this._pos_y - 0x180000;
    }

    boolean Worm_IsBigFall() {
        return 0 == Level.LineTest(this._pos_x, this._pos_y, this._pos_x, this._pos_y + Constants.WORM_BIG_FALL_MIN_DISTANCE - 65536, false, 0);
    }

    boolean Worm_IsHugeFall() {
        return 0 == Level.LineTest(this._pos_x, this._pos_y + Constants.WORM_BIG_FALL_MIN_DISTANCE, this._pos_x, this._pos_y + Constants.WORM_HUGE_FALL_MIN_DISTANCE, false, 0);
    }

    boolean Worm_ChangePos(int n, int n2) {
        if (n2 >= Level._nLandMaxHeight << 16) {
            this.DisableWormExitingLevel();
            return true;
        }
        if (n2 >= (Level._sea_level << 16) + 0x180000) {
            if ((this._flags & 0x8000) != 0) {
                Level.DisableEntity(this._id);
                return true;
            }
            this.Worm_SetState((byte)14);
        }
        if (n <= 0 || n >= Level._nLandMaxWidth << 16) {
            this.DisableWormExitingLevel();
            return true;
        }
        if (this.Worm_Collided(n, n2)) {
            if (this._nState != 12 && this._nState != 11) {
                this.ResetSpeed();
            }
            if (this.Worm_IsDyingOrDead()) {
                this.Worm_SetState((byte)15);
            }
            return false;
        }
        int n3 = this._pos_x;
        int n4 = this._pos_y;
        this._pos_x = n;
        this._pos_y = n2;
        if (this._bdata[3] == 0) {
            Level.CheckPositionTriggers(this, n3, n4);
        }
        if (_tutorialAnim != null && this == GameImpl._pCrtWorm) {
            Entity._tutorialAnim._pos_x = this._pos_x;
            Entity._tutorialAnim._pos_y = this._pos_y;
        }
        return true;
    }

    boolean Worm_Teleport(int n, int n2) {
        if (this.Worm_Collided(n, n2)) {
            return false;
        }
        this._idata[3] = n;
        this._idata[4] = n2;
        GameImpl.SetGamePlayState(2);
        Level.SetCameraState(3);
        _timeout = GameImpl.canvas.getAppTime();
        this.UseCurrentWeaponOnce();
        this.Worm_SetState((byte)16);
        return true;
    }

    void LaunchAirstrikeMissile(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n * 30;
        int n8 = 0;
        int n9 = -60;
        n5 = (int)(524288L * (long)n2 >> 16);
        if (_airstrikeDirection == 1) {
            n8 = _targetSelectPosX + n6 - n7;
            n4 = -((int)(524288L * (long)n3 >> 16));
        } else if (_airstrikeDirection == -1) {
            n8 = _targetSelectPosX - n6 + n7;
            n4 = (int)(524288L * (long)n3 >> 16);
        }
        if (_airstrikeDirection == 1) {
            while (n8 > Level._nLandMaxWidth) {
                n9 += n5 >> 16;
                n8 += n4 >> 16;
            }
        } else {
            while (n8 < 0) {
                n9 += n5 >> 16;
                n8 += n4 >> 16;
            }
        }
        this.FireProjectyle(n8 << 16, n9 << 16, n4, n5, (byte)4, false);
    }

    void Worm_Shoot(int n) {
        if (this._bdata[9] == 1) {
            return;
        }
        this._bdata[20] = 10;
        this._bdata[9] = 1;
        GameImpl._bHitEnemy = false;
        GameImpl._bHitFriend = false;
        int n2 = this._idata[5] * 180 >> 16;
        if (n == 30) {
            n2 += GameImpl.random(-20, 20);
        }
        int n3 = GameImpl.GetBulletMaxSpeed(n);
        if (GameImpl.IsPowerWeapon(n)) {
            n3 = (int)((long)n3 * (long)_shootPower >> 16) / 100;
        }
        int n4 = GameImpl.Sin(n2);
        int n5 = GameImpl.Cos(n2);
        int n6 = Entity2.GetShootProjectileOffset(n);
        int n7 = this._bdata[5] * (int)((long)n6 * (long)n4 >> 16);
        int n8 = (int)((long)n6 * (long)n5 >> 16);
        int n9 = this._bdata[5] * (int)((long)n3 * (long)n4 >> 16);
        int n10 = (int)((long)n3 * (long)n5 >> 16);
        int n11 = this.GetWormCenterY();
        int n12 = this._pos_x + n7;
        int n13 = n11 + n8;
        switch (n) {
            case 14: {
                if (this.Worm_Teleport(_targetSelectPosX << 16, _targetSelectPosY << 16)) {
                    _targetEntity = Level.SpawnEntity(4);
                    if (GameImpl._pCrtWorm._bdata[12] != 1) break;
                    _targetShowCursor = false;
                    _targetEntity.Init(4, _targetSelectPosX << 16, _targetSelectPosY << 16, null, null);
                    _targetEntity.SetSprite(6);
                    break;
                }
                if (GameImpl._pCrtWorm._bdata[12] == 1) break;
                this.Worm_SetAIState((byte)41);
                break;
            }
            case 10: {
                GameImpl._sheepReleaseTime = GameImpl._nGameTimer;
                Entity entity = Level.SpawnEntity(11);
                int n14 = n12 + n9 >> 16;
                int n15 = n13 + n10 >> 16;
                entity.Init(11, n14 << 16, n15 << 16, null, null);
                Level.HideTimer();
                Level.DoFollowEntity(entity._id);
                entity._bdata[2] = 0;
                GameImpl._sheepEntity = entity;
                GameImpl.updateUsedWeaponUtilCount(10);
                break;
            }
            case 16: {
                GameImpl._sheepReleaseTime = GameImpl._nGameTimer;
                Entity entity = Level.SpawnEntity(11);
                int n14 = n12 + n9 >> 16;
                int n15 = n13 + n10 >> 16;
                entity.Init(11, n14 << 16, n15 << 16, null, null);
                Level.HideTimer();
                Level.DoFollowEntity(entity._id);
                entity._bdata[2] = 1;
                GameImpl._sheepEntity = entity;
                GameImpl.updateUsedWeaponUtilCount(16);
                break;
            }
            case 23: {
                GameImpl._sheepReleaseTime = GameImpl._nGameTimer;
                Entity entity = Level.SpawnEntity(23);
                if (entity == null) break;
                int n14 = n12 + n9 >> 16;
                int n15 = n13 + n10 >> 16;
                _targetSelectPosX = this._pos_x;
                _targetSelectPosY = this._pos_y;
                entity.Init(23, (n14 << 16) + this._bdata[5] * 20, n15 << 16, null, null);
                entity._velX = n9;
                entity._velY = n10;
                Level.HideTimer();
                Level.DoFollowEntity(entity._id);
                GameImpl._sheepEntity = entity;
                this.countParticles = 0;
                break;
            }
            case 22: {
                GameImpl._sheepReleaseTime = GameImpl._nGameTimer;
                GameImpl._sheepExpCounter = 0;
                Entity entity = Level.SpawnEntity(24);
                int n14 = n12 + n9 >> 16;
                int n15 = n13 + n10 >> 16;
                entity.Init(24, n14 + this._bdata[5] * 20 << 16, n15 << 16, null, null);
                Level.PauseTimer();
                Level.DoFollowEntity(entity._id);
                entity._bdata[2] = 0;
                GameImpl._sheepEntity = entity;
                GameImpl.updateUsedWeaponUtilCount(22);
                break;
            }
            case 27: {
                Entity entity;
                GameImpl._sheepReleaseTime = GameImpl._nGameTimer;
                GameImpl._DragonballEntity = entity = Level.SpawnEntity(26);
                int n14 = n12 + (this._bdata[0] == 1 ? -n9 : n9) >> 16;
                int n15 = n13 + n10 >> 16;
                entity.Init(26, n14 << 16, n15 << 16, null, null);
                Level.PauseTimer();
                Level.DoFollowEntity(entity._id);
                entity._bdata[2] = 0;
                break;
            }
            case 31: {
                Entity entity = Level.SpawnEntity(15);
                int n14 = this._bdata[5] * 786432;
                int n15 = n12 + n9 + n14 >> 16;
                int n16 = n13 + n10 >> 16;
                entity.Init(15, n15 << 16, n16 << 16, null, null);
                break;
            }
            case 4: {
                Entity entity = Level.SpawnEntity(13);
                int n14 = this._bdata[5] * 786432;
                int n15 = n12 + n9 + n14 >> 16;
                int n16 = n13 + n10 >> 16;
                entity.Init(13, n15 << 16, n16 << 16, null, null);
                entity._velX = 0;
                entity._velY = 0;
                entity._yBounce = 16384;
                entity.Mine_Init();
                entity._timer = GameImpl.canvas.getAppTime();
                entity._bdata[0] = 1;
                entity.Mine_SetState((byte)3);
                GameImpl.updateUsedWeaponUtilCount(4);
                break;
            }
            case 0: {
                Entity entity = Level.SpawnEntity(5);
                entity.Init(5, n12, n13, null, null);
                entity.SetSprite(3);
                entity.SetCrtAnim(5);
                this.FireProjectyle(n12, n13, n9, n10, (byte)0, true);
                break;
            }
            case 13: {
                this.FireProjectyle(n12, n13, n9, n10, (byte)11, true);
                break;
            }
            case 1: {
                this.FireProjectyle(n12, n13, n9, n10, (byte)1, true);
                break;
            }
            case 7: {
                this.FireProjectyle(n12, n13, n9, n10, (byte)6, true);
                break;
            }
            case 25: {
                this.FireProjectyle(n12, n13, n9, n10, (byte)17, true);
                break;
            }
            case 19: {
                this.FireProjectyle(n12, n13, n9, n10, (byte)15, true);
                break;
            }
            case 6: {
                Entity entity = Level.SpawnEntity(5);
                entity.Init(5, n12, n13, null, null);
                entity.SetSprite(3);
                entity.SetCrtAnim(5);
                this.FireProjectyle(n12, n13, n9, n10, (byte)5, true);
                GameImpl.updateUsedWeaponUtilCount(6);
                break;
            }
            case 18: {
                this.FireProjectyle(n12, n13, n9, n10, (byte)14, true);
                GameImpl._railgunAngle = n2;
                GameImpl._railgun_x1 = n12;
                GameImpl._railgun_y1 = n13;
                GameImpl._railgun_dx = n9;
                GameImpl._railgun_dy = n10;
                break;
            }
            case 12: 
            case 30: {
                this.ShootBullet(n, n2, n12, n13, n9, n10);
                break;
            }
            case 5: 
            case 11: {
                if (n == 5) {
                    GameImpl.updateUsedWeaponUtilCount(5);
                    _isANaplamStrike = false;
                } else {
                    GameImpl.updateUsedWeaponUtilCount(11);
                    _isANaplamStrike = true;
                }
                Level.HideTimer();
                if (_targetEntity != null) {
                    Level.DisableEntity(Entity._targetEntity._id);
                    _targetEntity = null;
                }
                _targetEntity = Level.SpawnEntity(4);
                _targetEntity.Init(4, _targetSelectPosX << 16, _targetSelectPosY << 16, null, null);
                _targetEntity.SetSprite(6);
                _targetShowCursor = true;
                int n17 = GameImpl.Sin(45);
                int n14 = GameImpl.Cos(45);
                int n15 = 76;
                int n16 = _targetSelectPosY - -60;
                n16 = (n16 * (int)(((long)n17 << 16) / (long)n14) >> 16) + n15;
                boolean bl = true;
                int n18 = 150;
                if (n == 11) {
                    n16 -= n18;
                }
                while (_airstrikeProjectylesFired < 5) {
                    if (3 != _airstrikeProjectylesFired) {
                        this.LaunchAirstrikeMissile(_airstrikeProjectylesFired, n14, n17, n9, n10, n16);
                    }
                    ++_airstrikeProjectylesFired;
                }
                this.LaunchAirstrikeMissile(3, n14, n17, n9, n10, n16);
                break;
            }
            case 102: {
                break;
            }
            case 28: {
                this._idata[3] = _targetSelectPosX << 16;
                this._idata[4] = _targetSelectPosY << 16;
                GameImpl.SetGamePlayState(2);
                Level.SetCameraState(3);
                _timeout = GameImpl.canvas.getAppTime();
                _targetShowCursor = false;
                this.Worm_SetState((byte)33);
                GameImpl.updateUsedWeaponUtilCount(28);
                break;
            }
            case 17: {
                if (_bunkeronehit) break;
                this._idata[3] = _targetSelectPosX << 16;
                this._idata[4] = _targetSelectPosY << 16;
                GameImpl.SetGamePlayState(2);
                Level.SetCameraState(3);
                _timeout = GameImpl.canvas.getAppTime();
                _targetEntity = Level.SpawnEntity(4);
                _targetEntity.Init(4, _targetSelectPosX << 16, _targetSelectPosY << 16, null, null);
                _targetEntity.SetSprite(6);
                _targetShowCursor = false;
                _bunkeronehit = true;
                GameImpl.updateUsedWeaponUtilCount(17);
                this.Worm_SetState((byte)32);
                break;
            }
            case 9: {
                this.ShootSpartanPunch(n, (this._pos_x >> 16) + this._bdata[5] * 2, this._pos_y >> 16);
                break;
            }
            case 21: {
                this.ShootBaseballBat(n, n2, n12 + this._bdata[5] * 4, n13);
                break;
            }
            case 15: {
                this.Explode((n12 >> 16) + this._bdata[5] * 4, n13 >> 16, 12);
            }
        }
        if (n != 30) {
            this.HandleRetreatTimer();
        }
        if (this._bdata[3] != -1 && this._bdata[15] != -1 && n != 30 && n != 14 && n != 12 && GameImpl._teamsWeapons[this._bdata[3]][this._bdata[15]] != -1 && (GameImpl._shootCounter == 0 || Level._isRealTime)) {
            this.UseCurrentWeaponOnce();
        }
        if (n != 30 && n != 14 && !GameImpl._isFiringRange) {
            ++GameImpl._shootCounter;
        }
        if (this._bdata[15] != -1 && GameImpl._teamsWeapons[this._bdata[3]][this._bdata[15]] == 0) {
            for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Entity entity = Level._entities[i];
                if (entity != null && entity._type == 1 && !entity.Worm_IsDyingOrDead() && entity._bdata[3] == this._bdata[3] && entity._bdata[15] == this._bdata[15]) {
                    entity._bdata[15] = -1;
                }
                entity = null;
            }
            this._bdata[15] = -1;
        }
    }

    void ShootBullet(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (n5 == 0 && n6 == 0) {
            return;
        }
        Entity entity = Level.SpawnEntity(5);
        entity.Init(5, _bulletX + Level._nCamX << 16, _bulletY + Level._nCamY << 16, null, null);
        entity.SetSprite(3);
        entity.SetCrtAnim(5);
        int n8 = n7 = GameImpl.GetBulletMaxSpeed(n);
        block0: while (true) {
            n8 += n7;
            int n9 = (n3 += n5) >> 16;
            int n10 = (n4 += n6) >> 16;
            if (n9 < 0 || n9 > Level._nLandMaxWidth || n10 < 0 || n10 > Level._sea_level) {
                return;
            }
            if (Level.RectCollideWithLandCenter(n9, n10, 2, 2, false)) {
                this.ExplodeGuns(n, n9, n10);
                return;
            }
            int n11 = Level._nFirstWormIndex;
            while (true) {
                int n12;
                int n13;
                int n14;
                int n15;
                Entity entity2;
                if (n11 >= Level._nFirstWormIndex + Level._nWormsEntities) continue block0;
                if (Level._entities_usage[n11] == 1 && (entity2 = Level._entities[n11]) != this && entity2._type == 1 && !entity2.Worm_IsDyingOrDead() && GameImpl.IntersectsRectCircle(n15 = (entity2._pos_x >> 16) + entity2._bbox[0], n14 = (entity2._pos_y >> 16) + entity2._bbox[1], n13 = entity2._bbox[2] - entity2._bbox[0], n12 = entity2._bbox[3] - entity2._bbox[1], n9, n10, 3)) {
                    this.ExplodeGuns(n, n9, n10);
                    return;
                }
                ++n11;
            }
            break;
        }
    }

    void ShootSpartanPunch(int n, int n2, int n3) {
        Entity entity = null;
        int n4 = n2;
        int n5 = 14;
        int n6 = n3 - 25;
        int n7 = 25;
        if (this._bdata[5] == -1) {
            n4 = n2 - 14;
        }
        for (int i = 0; i < Level._nMaxUsedEntities; ++i) {
            if (Level._entities_usage[i] != 1 || (entity = Level._entities[i]) == this || entity._type != 1 && entity._type != 12 && entity._type != 13 && entity._type != 9 || !GameImpl.IntersectsRectRect(n4, n6, n5, n7, (entity._pos_x >> 16) + entity._bbox[0], (entity._pos_y >> 16) + entity._bbox[1], entity._bbox[2] - entity._bbox[0], entity._bbox[3] - entity._bbox[1])) continue;
            entity.HandleHit(8, GameArray._kProjectilesInfo[8][0]);
        }
        entity = null;
    }

    void ShootBaseballBat(int n, int n2, int n3, int n4) {
        this.Explode(n3 >> 16, n4 >> 16, 16);
    }

    void Worm_SetCrtAnim(int n) {
        if (this._crt_anim != n) {
            this.SetCrtAnim(n);
            switch (n) {
                case 1: 
                case 4: 
                case 8: 
                case 12: 
                case 20: 
                case 21: 
                case 24: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 39: 
                case 49: 
                case 66: 
                case 70: 
                case 71: 
                case 80: 
                case 81: 
                case 85: 
                case 86: 
                case 87: {
                    this._flags &= 0xFFFFFFBF;
                    break;
                }
                default: {
                    this._flags |= 0x40;
                }
            }
        }
    }

    void Worm_DrawAboveHead(int n, int n2, int n3, boolean bl) {
        if (GameImpl.IsTutorial()) {
            return;
        }
        GameImpl._stringMutable.setLength(0);
        if (n == 1000) {
            GameImpl._stringMutable.append(Constants.INFINITE_CHARACTER);
        } else {
            GameImpl._stringMutable.append(n);
        }
        if (bl) {
            if (n <= 20) {
                GameImpl.DrawString(GameImpl._stringMutable, n2, n3, 33, GameImpl._fontWormRed);
            } else {
                GameImpl.DrawString(GameImpl._stringMutable, n2, n3, 33, GameImpl._fontWormDarkBlue);
            }
        } else if (!GameImpl._isFiringRange) {
            GameImpl.DrawString(GameImpl._stringMutable, n2, n3, 33, this.Worm_GetFont());
        }
    }

    void Worm_DrawString(int n, int n2, int n3) {
        GameImpl.DrawString(n, n2, n3 - 50, 33, this.Worm_GetFont());
    }

    void Worm_DrawBinocular(SDKGraphics sDKGraphics) {
        GameImpl._sprites[8].DrawFrame(0, GameConstants.SCREEN_WIDTH / 2, GameConstants.SCREEN_HEIGHT / 2, 0);
    }

    void Worm_HandleHit(int n, int n2) {
        if (GameImpl.GetGameState() == 18 || GameImpl.GetGameState() == 19) {
            return;
        }
        if (GameImpl._pCrtWorm._bdata[12] == 1 && this._bdata[12] == 1) {
            GameImpl._hasFriendlyDamageOccured = true;
        }
        if (!GameImpl._eventMessageDisplayed && !Entity2.AreOpposingTeams(this._bdata[3], GameImpl._pCrtWorm._bdata[3]) && GameImpl._currfaction != -1) {
            GameImpl._eventMessageDisplayed = true;
            if (GameImpl._pCrtWorm._id == this._id || GameImpl._pCrtWorm._bdata[15] == 24) {
                GameImpl._eventMessageDisplayed = false;
            } else if (GameImpl._pCrtWorm._bdata[12] == 1 && this._bdata[12] == 1) {
                GameImpl._msgWormIsHuman = true;
                GameImpl._msgType = (byte)2;
            } else {
                GameImpl._msgWormIsHuman = false;
                GameImpl._msgType = (byte)2;
            }
        }
        if (!(this._id != GameImpl._pCrtWorm._id || GameImpl._bRetreating || this._bdata[15] != 30 && this._bdata[15] != 12 || GameImpl._shootCounter > GameImpl._pCrtWorm.GetCurrentWeaponNoRounds() - 1)) {
            this.UseCurrentWeaponOnce();
            Level.ResumeTimer();
        }
        if (n == 12) {
            n2 = this._health / 2;
            if (GameImpl._nGameMode == 3) {
                n2 = 1;
            }
            if (n2 == 0) {
                n2 = 1;
            }
            this.Worm_SetCrtAnim(38);
            this.Worm_SetState((byte)35);
        }
        if (n == 8) {
            if (this._nState == 20) {
                n2 = 0;
            } else {
                this.Worm_SetState((byte)20);
            }
        }
        if (GameImpl._nGameMode == 4) {
            n2 = 0;
        }
        this._idata[9] = this._idata[9] + n2;
        if (GameImpl._pCrtWorm == null || GameImpl._pCrtWorm._bdata[12] != 1 || Entity2.AreOpposingTeams(this._bdata[3], GameImpl._pCrtWorm._bdata[3])) {
            // empty if block
        }
        if (GameImpl._pCrtWorm._id == this._id && !Level._isRealTime) {
            GameImpl._shootCounter = this.GetCurrentWeaponNoRounds();
            GameImpl._bDontRetreat = true;
            if (!GameImpl._bRetreating) {
                GameImpl.SetGamePlayState(5);
                Level.HideTimer();
            }
        }
    }

    void Worm_TargetAndPower(int n, int n2) {
        if (this._bdata[9] == 1 && GameImpl.IsPowerWeapon(this._bdata[15])) {
            return;
        }
        int n3 = this._idata[5] * 180 >> 16;
        int n4 = GameImpl.Sin(n3);
        int n5 = GameImpl.Cos(n3);
        int n6 = this._bdata[5] * (int)(0x4B0000L * (long)n4 >> 16) >> 16;
        int n7 = (int)(0x4B0000L * (long)n5 >> 16) >> 16;
        int n8 = 0;
        int n9 = 0;
        if (this._bdata[9] == 0 && (this._nState == 4 || this._nState == 40)) {
            int n10 = 15;
            n9 = ((_shootPower >> 16) + n10 - 1) / n10;
            for (int i = 0; i < n9; ++i) {
                GameImpl._sprites[3].RectFrame(47 + i, 0, 0, 0);
                int n11 = GameImpl._rect[2] - GameImpl._rect[0];
                int n12 = this._bdata[5] * (int)((long)(983040 + n8) * (long)n4 >> 16) >> 16;
                int n13 = (int)((long)(983040 + n8) * (long)n5 >> 16) >> 16;
                GameImpl._sprites[3].DrawFrame(47 + i, n + n12, n2 - 12 + n13, 0);
                n8 += 3 * n11 << 16 >> 2;
            }
        }
        if (GameImpl.IsAimedWeapon(this._bdata[15]) && this._bdata[15] != 23) {
            GameImpl._sprites[6].DrawAnimFrame(0, GameImpl._nGameTimer / 5 % 4, n + n6, n2 - 12 + n7, 0);
        }
    }

    void RemoveHats() {
        this._nHatIndex = -1;
    }

    void SetHats(int n) {
        if (n >= 10) {
            n = 9;
        }
        this._nHatIndex = n;
    }

    int GetCurrentWeaponNoRounds() {
        if (Level._isRealTime) {
            return 10000;
        }
        switch (this._bdata[15]) {
            case 12: {
                return 2;
            }
        }
        return 1;
    }

    boolean SelectWeapon(byte by) {
        this._bdata[14] = 0;
        byte by2 = this._bdata[15];
        this._nState = 0;
        GameImpl._shootCounter = 0;
        if (GameImpl.IsFusedWeapon(by)) {
            GameImpl._nFusedTimer = 3;
        }
        if (_targetEntity != null) {
            Level.DisableEntity(Entity._targetEntity._id);
            _targetEntity = null;
        }
        if (GameImpl._teamsWeapons[this._bdata[3]][by] != 0) {
            this._bdata[15] = by;
            if ((this._nState == 17 || this._nState == 27) && by != 24) {
                this._nState = 1;
            }
            switch (this._bdata[15]) {
                case 19: {
                    GameImpl._nFusedTimer = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 11: {
                    _targetSelectPosX = this._pos_x >> 16;
                    _targetSelectPosY = this._pos_y >> 16;
                    _airstrikeProjectylesFired = 0;
                    _targetShowCursor = true;
                    GameImpl.SetGamePlayState(3);
                    break;
                }
                case 34: {
                    this.Worm_SetState((byte)27);
                    break;
                }
                case 35: {
                    this.Worm_SetState((byte)34);
                    break;
                }
                case 24: {
                    if (_targetEntity != null) {
                        Level.DisableEntity(Entity._targetEntity._id);
                        _targetEntity = null;
                    }
                    _targetShowCursor = true;
                    this.Worm_SetState((byte)3);
                    GameImpl.SetGamePlayState(13);
                    break;
                }
                case 33: {
                    this._bdata[15] = by2;
                    this.Worm_SetState((byte)17);
                    break;
                }
                case 14: 
                case 17: {
                    if (GameImpl._pCrtWorm._bdata[12] == 1) {
                        _targetShowCursor = true;
                    }
                    GameImpl.SetGamePlayState(3);
                    Level.SetCameraState(1);
                    break;
                }
                case 21: {
                    this._idata[5] = 32768;
                    break;
                }
                case 28: {
                    _targetShowCursor = true;
                    this._bSimpleRebound = true;
                    this._idata[3] = this._pos_x >> 16;
                    this._idata[4] = this._pos_y >> 16;
                    GameImpl.SetGamePlayState(3);
                    Level.SetCameraState(1);
                    break;
                }
                case 26: {
                    this._idata[5] = 32768;
                    break;
                }
                case 32: {
                    this._idata[5] = 32768;
                    this.Worm_SetCrtAnim(72);
                    break;
                }
                case 20: {
                    this._idata[5] = 32768;
                    this.Worm_SetCrtAnim(70);
                    break;
                }
                case 2: {
                    this._bdata[16] = 0;
                    break;
                }
                case 0: 
                case 1: 
                case 7: 
                case 13: 
                case 25: {
                    _targetShowCursor = false;
                    break;
                }
                case 8: {
                    this._bdata[14] = 1;
                    break;
                }
                default: {
                    _targetShowCursor = false;
                }
            }
            if (!GameImpl.IsAimedWeapon(this._bdata[15])) {
                this._idata[5] = 32768;
            }
            if (by == 33) {
                Level.CheckTriggers((short)63, this, true);
            } else {
                Level.CheckTriggers((short)63, this, false);
            }
            GameImpl._bDrawWeapon = true;
            GameImpl._bShowPowerBar = true;
            GameImpl._drawWeaponTimer = GameImpl.canvas.getAppTime();
            GameImpl.SetCloseup(-1);
            this.SetWormWeaponAnimation();
            return true;
        }
        return false;
    }

    void SetWormWeaponAnimation() {
        if (SDKCanvas.isKeyPressed(10252)) {
            return;
        }
        if (this._bdata[15] == 21) {
            if (GameImpl._shootCounter < this.GetCurrentWeaponNoRounds()) {
                this.Worm_SetCrtAnim(59);
            }
        } else if (this._bdata[15] == 15) {
            if (GameImpl._shootCounter < this.GetCurrentWeaponNoRounds()) {
                this.Worm_SetCrtAnim(63);
            }
        } else if (this._bdata[15] == 9 && GameImpl._shootCounter < this.GetCurrentWeaponNoRounds()) {
            this.Worm_SetCrtAnim(42);
        }
    }

    boolean SelectJetPackWeapon(byte by) {
        if (!GameImpl.IsWeaponSelectableInJetPack(by)) {
            return false;
        }
        switch (by) {
            case 0: 
            case 1: 
            case 7: 
            case 13: 
            case 19: 
            case 25: {
                this._idata[5] = 32768;
                _shootPower = 327680;
            }
        }
        return true;
    }

    boolean Worm_IsDyingOrDead() {
        if ((this._flags & 0x18) == 24) {
            return true;
        }
        switch (this._nState) {
            case 13: 
            case 14: 
            case 15: {
                return true;
            }
        }
        return false;
    }

    boolean IsOnScreen() {
        int n = GameImpl.SV_X + (this._pos_x >> 16) - Level._nCamX;
        int n2 = GameImpl.SV_Y + (this._pos_y >> 16) - Level._nCamY;
        return n > 0 && n < GameImpl.SV_W && n2 > 0 && n2 < GameImpl.SV_H;
    }

    int GetWormCenterX() {
        return this._pos_x;
    }

    int GetWormCenterY() {
        return this._pos_y - 786432;
    }

    void Worm_CollideWith(Entity entity, int n) {
        boolean bl = true;
        if (entity._type == 9 && this == GameImpl._pCrtWorm && this._nState != 12 && this._nState != 6 && this._nState != 11) {
            bl = false;
        }
        if (bl) {
            switch (this._nState) {
                case 7: 
                case 10: 
                case 23: {
                    if (n == 2) {
                        this.ResetSpeed();
                        return;
                    }
                    if (n == 3) {
                        if (!this.SetPosition(this._pos_x, this._pos_y + 65536)) {
                            this.Worm_SetState((byte)8);
                            this.ResetSpeed();
                            return;
                        }
                        this.SetPosition(this._pos_x, this._pos_y);
                        break;
                    }
                    if (this._velY <= -65536) break;
                    if (!this.SetPosition(this._pos_x, this._pos_y + 65536)) {
                        this.Worm_SetState((byte)8);
                        return;
                    }
                    this.SetPosition(this._pos_x, this._pos_y);
                    break;
                }
            }
            if (!entity.TransferEnergy(this, n)) {
                this.Rebound(entity, n);
            }
        }
        if ((this._nState == 11 || this._nState == 6 || this._nState == 12) && n != 2) {
            this.Worm_SetState((byte)12);
        }
        if (entity._type == 9 && this == GameImpl._pCrtWorm && this._nState != 12 && this._nState != 6 && !this.Worm_IsDyingOrDead()) {
            GameImpl.StopSounds();
            if (entity._idata[0] < 0) {
                this._health += 25;
                if (GameImpl._pCrtWorm._bEffectedByGas) {
                    GameImpl._pCrtWorm._bEffectedByGas = false;
                    GameImpl._pCrtWorm._bHitByAxe = false;
                }
                Entity entity2 = Level.SpawnText((byte)0, this._pos_x >> 16, this._pos_y >> 16);
            } else if (entity._idata[0] < 36) {
                if (GameImpl._teamsWeapons[this._bdata[3]][entity._idata[0]] != -1) {
                    int[] nArray = GameImpl._teamsWeapons[this._bdata[3]];
                    int n2 = entity._idata[0];
                    nArray[n2] = nArray[n2] + 1;
                }
                if (this._bdata[12] == 1 && GameImpl._nLevelType == 1) {
                    int n3 = entity._idata[0];
                    GameImpl._unlocked_crate_weapons[n3] = GameImpl._unlocked_crate_weapons[n3] + 1;
                }
                Entity entity3 = Level.SpawnText((byte)2, this._pos_x >> 16, this._pos_y >> 16);
                entity3._idata[0] = entity._idata[0];
                entity3._z_order = 6;
                if (this._bdata[12] == 1 && !GameImpl.isAPass_N_Play()) {
                    ++GameImpl._crates_collected;
                }
            } else {
                return;
            }
            Level.DisableEntity(entity._id);
        }
    }

    boolean IsWormMoving() {
        return this._velX != 0 && this._velY != 0;
    }

    void SetWormDirection(int n) {
        this._bdata[5] = (byte)n;
        this._flags = this._bdata[5] == 1 ? (this._flags |= 1) : (this._flags &= 0xFFFFFFFE);
    }

    void HandleRetreatTimer() {
        this.HandleRetreatTimer(this._bdata[15]);
    }

    void HandleRetreatTimer(int n) {
        if (Level._isRealTime) {
            GameImpl.SetGamePlayState(5);
            return;
        }
        switch (n) {
            case 11: 
            case 32: {
                GameImpl.SetGamePlayState(5);
                break;
            }
            case 1: 
            case 7: 
            case 13: 
            case 19: 
            case 25: {
                Level.StartRetreatTimer();
                Level._currentRetreatTime = GameImpl._nFusedTimer * 1000;
                break;
            }
            case 31: {
                Level.StartRetreatTimer();
                break;
            }
            case 10: {
                Level.StartRetreatTimer();
                Level._currentRetreatTime = 5000L;
                break;
            }
            case 22: {
                Level.StartRetreatTimer();
                Level._currentRetreatTime = 5000L;
                break;
            }
            case 27: {
                Level.StartRetreatTimer();
                Level._currentRetreatTime = 5000L;
                break;
            }
            case 16: {
                Level.StartRetreatTimer();
                GameImpl.SUPER_SHEEP_EXPLODE_TIME = (int)Level._turnTimeLeft;
                Level._currentRetreatTime = GameImpl.SUPER_SHEEP_EXPLODE_TIME;
                break;
            }
            case 23: {
                Level.StartRetreatTimer();
                Level._currentRetreatTime = 5000L;
                break;
            }
            case 12: {
                if (GameImpl._shootCounter < this.GetCurrentWeaponNoRounds() - 1 || GameImpl._bDontRetreat) break;
                this.UseCurrentWeaponOnce();
                Level.StartRetreatTimer();
                Level._currentRetreatTime = 6000L;
                break;
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 15: 
            case 18: 
            case 21: 
            case 30: 
            case 102: {
                Level.StartRetreatTimer();
                Level._currentRetreatTime = 6000L;
                break;
            }
            case 20: 
            case 26: {
                Level.StartRetreatTimer();
                Level._currentRetreatTime = 6000L;
                break;
            }
            case 14: 
            case 17: 
            case 28: {
                return;
            }
        }
        GameImpl.SetGamePlayState(5);
    }

    int GetRandomIdleAnimation() {
        return GameImpl.random(51, 56);
    }

    Object Worm_GetFont() {
        switch (this._bdata[3]) {
            case 0: {
                return GameImpl._fontWormGreen;
            }
            case 1: {
                return GameImpl._fontWormRed;
            }
            case 2: {
                return GameImpl._fontWormDarkBlue;
            }
        }
        return GameImpl._fontWormGreen;
    }

    void SetWormAimAnimation() {
        int n = 27 + (11 * this._idata[5] >> 16);
        if (n > 37) {
            n = 37;
        }
        this.Worm_SetCrtAnim(n);
    }

    void CheckWormCratesCollisions() {
        for (int i = 0; i < Level._nMaxUsedEntities; ++i) {
            if (Level._entities_usage[i] != 1 || Level._entities[i]._type != 9 || !this.CollideWith(Level._entities[i], this._pos_x, this._pos_y)) continue;
            this.CollideWith(Level._entities[i], 0);
        }
    }

    void UseCurrentWeaponOnce() {
        if (this._bdata[15] != -1 && GameImpl._teamsWeapons[this._bdata[3]][this._bdata[15]] != -1) {
            int[] nArray = GameImpl._teamsWeapons[this._bdata[3]];
            byte by = this._bdata[15];
            nArray[by] = nArray[by] - 1;
            GameImpl.UseCrateWeapon(this, this._bdata[15]);
        }
        if (this._bdata[15] != -1 && GameImpl._teamsWeapons[this._bdata[3]][this._bdata[15]] == 0) {
            byte by = this._bdata[15];
            for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
                if (Level._entities_usage[i] != 1) continue;
                Entity entity = Level._entities[i];
                if (entity != null && entity._type == 1 && !entity.Worm_IsDyingOrDead() && entity._bdata[3] == this._bdata[3] && entity._bdata[15] == by) {
                    entity._bdata[15] = -1;
                }
                entity = null;
            }
        }
    }

    void HighlightWorm() {
        if (!GameImpl._isFiringRange) {
            this._bdata[19] = 1;
        }
    }

    void SetWormTeam(int n) {
        this._bdata[3] = n == -1 ? (byte)(this._id % 2) : (byte)n;
        this._bdata[12] = 1;
        if (this._bdata[3] != 0 && GameImpl._nGameControls == 0) {
            this._bdata[12] = 0;
            this.InitAIWormData();
        }
    }

    void PlaceWormRandomly() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        while (!bl) {
            n = Level.IRandom(192, 1152);
            n2 = Level.IRandom(192, 576);
            this._pos_x = n << 16;
            this._pos_y = n2 << 16;
            if (this.Worm_Collided(n << 16, n2 << 16)) {
                if ((n2 = this.PlaceObjectOnGround(n, n2, true)) > 24 && n2 < Level._sea_level) {
                    n3 = 0;
                    bl = true;
                }
            } else if ((n2 = this.PlaceObjectOnGround(n, n2, false)) < Level._sea_level) {
                n3 = 0;
                bl = true;
            }
            if (n3++ <= 100) continue;
            MenuClass.RestartLevel();
            return;
        }
        this.SetPosition(n << 16, n2 << 16);
    }

    boolean isTombStone() {
        return this._sprite == 7;
    }

    void DisableWormExitingLevel() {
        if (GameImpl._isFiringRange) {
            if (this._id == GameImpl._pCrtWorm._id) {
                this.PlaceWormRandomly();
                this._idata[0] = this._pos_x;
                this._idata[1] = this._pos_y;
                this.Worm_ChangePos(this._idata[0], this._idata[1]);
                this.Worm_SetState((byte)7);
                return;
            }
            DummiesCount = (byte)(DummiesCount - 1);
        }
        this.worm_TravelDistance = 0;
        if ((this._flags & 0x18) == 0) {
            if ((this._flags & 0x8000) != 0 || this._nState == 15) {
                this._pos_y = (Level._sea_level << 16) + 0x600000;
                Level.DisableEntity(this._id);
                if (GameImpl._pCrtWorm != null && !this.isTombStone() && GameImpl._pCrtWorm._bdata[12] == 1) {
                    if (this._bdata[3] == 0) {
                        if (!Entity2.AreOpposingTeams(GameImpl._pCrtWorm._bdata[3], this._bdata[3]) && !GameImpl.isAPass_N_Play()) {
                            ++GameImpl._worms_friendlyKilled_total;
                        }
                    } else if (!GameImpl.isAPass_N_Play()) {
                        ++GameImpl._worms_killed_AI_total;
                    }
                }
                return;
            }
            if (!GameImpl._eventMessageDisplayed) {
                GameImpl._eventMessageDisplayed = true;
                if (this._bdata[12] == 1) {
                    GameImpl._msgWormIsHuman = false;
                    GameImpl._msgType = 1;
                } else {
                    GameImpl._msgWormIsHuman = false;
                    GameImpl._msgType = 1;
                }
            }
            GameImpl.ShowTip(16);
            if (GameImpl._pCrtWorm != null && this._id == GameImpl._pCrtWorm._id) {
                GameImpl._bRetreating = false;
                GameImpl.SetGamePlayState(5);
            }
            Level.CheckTriggers((short)61, this, false);
            byte by = this._bdata[3];
            GameImpl._nTeamWormCount[by] = GameImpl._nTeamWormCount[by] - 1;
            this._pos_y = (Level._sea_level << 16) + 0x600000;
            Level.DisableEntity(this._id);
        }
    }

    void Worm_UpdateStanding() {
        if (this != GameImpl._pCrtWorm) {
            if (this._crt_anim == 7) {
                if (this._bdata[4] > this._sdata[0]) {
                    for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
                        if (Level._entities_usage[i] == 1 && Level._entities[i]._bHitByAxe && Level._entities[i]._type == 1) {
                            if (!Level._entities[i]._bEffectedByGas || GameImpl._pCrtWorm._id == Level._entities[i]._id) continue;
                            Level._entities[i].Worm_SetCrtAnim(82);
                            continue;
                        }
                        if (Level._entities[i]._bHitByAxe) continue;
                        int n = this.GetRandomIdleAnimation();
                        this.Worm_SetCrtAnim(n);
                    }
                }
            } else if (this.IsCrtAnimEnded()) {
                this.Worm_SetCrtAnim(7);
                this._bdata[4] = 0;
                this._sdata[0] = (short)GameImpl.random(40, 140);
            }
            this._bdata[4] = (byte)(this._bdata[4] + 1);
            return;
        }
        if (this._bdata[18] == 1 && !Level._isRealTime) {
            this.Worm_SetCrtAnim(7);
            this._bdata[18] = 0;
            GameImpl._bRetreating = false;
            GameImpl.SetGamePlayState(5);
        } else if (this == GameImpl._pCrtWorm && !GameImpl._bRetreating && GameImpl._shootCounter < this.GetCurrentWeaponNoRounds() && this._bdata[15] != -1) {
            this.Worm_SetState((byte)3);
        }
    }

    void Worm_AddBunkerBuster() {
        GameImpl._windSpeedX = 0;
        this.FireProjectyle(this._idata[3], 0, -100, 1, (byte)13, true);
        GameImpl.SetGamePlayState(5);
        Level.SetCameraState(3);
    }

    void Worm_AddConcreteDonkey() {
        this.FireProjectyle(this._idata[3], 0, -50, 1, (byte)21, true);
        Level.SetCameraState(3);
        _targetShowCursor = false;
        GameImpl.SetGamePlayState(5);
        GameImpl.PlaySound(5);
    }

    void Worm_UpdateTeleport() {
        if (this._bdata[10] == 1) {
            if (Level._camAtDestination) {
                this.Worm_SetCrtAnim(47);
                this._bdata[10] = 0;
            }
        } else if (this.IsCrtAnimEnded()) {
            long l = GameImpl.canvas.getAppTime() - _timeout;
            switch (this._crt_anim) {
                case 47: {
                    if (l > 3500L) {
                        this.SetCrtAnim(48);
                        _timeout = GameImpl.canvas.getAppTime();
                    }
                    if (l <= 2500L) break;
                    this.Worm_ChangePos(this._idata[3], this._idata[4]);
                    break;
                }
                case 48: {
                    if (!Level._isRealTime) {
                        ++GameImpl._shootCounter;
                        this.Worm_SetState((byte)0);
                        this._bdata[18] = 1;
                        Level.DisableEntity(Entity._targetEntity._id);
                        GameImpl.SetGamePlayState(5);
                        break;
                    }
                    _bTeleportDone = true;
                    GameImpl.updateUsedWeaponUtilCount(14);
                    Level.DisableEntity(Entity._targetEntity._id);
                    this.Worm_SetState((byte)0);
                }
            }
        }
    }

    void Worm_UpdateKamikaze() {
        this._idata[0] = this._pos_x;
        this._idata[1] = this._pos_y;
        if (this.worm_TravelDistance < 20) {
            int n = this._idata[5] * 180 >> 16;
            this._idata[0] = this._idata[0] + this.worm_TravelDistance * this._bdata[5] * GameImpl.Sin(n);
            this._idata[1] = this._idata[1] + this.worm_TravelDistance * GameImpl.Cos(n);
            this.Worm_ChangePos(this._idata[0], this._idata[1]);
            ++this.worm_TravelDistance;
            Level.GenerateWhole(this.GetWormCenterX() >> 16, this.GetWormCenterY() >> 16, 20);
            Level.InflictCollateralDamage(2, 20, this._pos_x, this._pos_y);
            this.CreateKamikazeTailAnim(n);
        }
        if (this.worm_TravelDistance >= 20) {
            this.worm_TravelDistance = 0;
            GameImpl.PlaySound(1);
            this.CreateExplodeAnim(this._pos_x >> 16, this._pos_y >> 16, 20, 24);
            GameImpl._pCrtWorm.Worm_SetState((byte)0);
            this._pos_y = Level._nLandMaxHeight << 16;
            if (!GameImpl._isFiringRange) {
                Level.DisableEntity(this._id);
                if (GameImpl._pCrtWorm._bdata[12] == 1 && this._bdata[3] == 0 && !Entity2.AreOpposingTeams(GameImpl._pCrtWorm._bdata[3], this._bdata[3]) && !GameImpl.isAPass_N_Play()) {
                    ++GameImpl._worms_friendlyKilled_total;
                }
            } else {
                this.PlaceWormRandomly();
            }
            this._idata[0] = this._pos_x;
            this._idata[1] = this._pos_y;
            this.HandleRetreatTimer();
            Level.InflictCollateralDamage(29, 30, this._pos_x, this._pos_y);
        }
        if (this._idata[5] > 49152) {
            this.Worm_SetCrtAnim(79);
        } else if (this._idata[5] < 16384) {
            this.Worm_SetCrtAnim(78);
        } else if (this._idata[5] >= 49152) {
            this.Worm_SetCrtAnim(76);
        } else if (this._idata[5] <= 16384) {
            this.Worm_SetCrtAnim(77);
        } else {
            this.Worm_SetCrtAnim(75);
        }
    }

    void Worm_UpdateDrilling() {
        int n;
        if (GameImpl.canvas.getAppTime() - this._timer >= 3000L || (_nCommands & 0x20) != 0) {
            ++GameImpl._shootCounter;
            this.Worm_SetState((byte)0);
            this.HandleRetreatTimer();
            return;
        }
        _nCommands = this._bdata[5] == 1 ? (_nCommands |= 2) : (_nCommands |= 1);
        if (this._idata[5] > 32768) {
            this.Worm_SetCrtAnim(85);
        } else if (this._idata[5] < 32768) {
            this.Worm_SetCrtAnim(87);
        } else {
            this.Worm_SetCrtAnim(86);
        }
        int n2 = -4;
        int n3 = 22;
        if (this._idata[5] > 32768) {
            n = this._bdata[5] == 1 ? 11 : -11;
            n2 -= (int)((long)((int)(((long)GameImpl.Sin(n3) << 16) / (long)GameImpl.Cos(n3))) * (long)(Math.abs(n) << 16) >> 16) >> 16;
        } else if (this._idata[5] < 32768) {
            n = this._bdata[5] == 1 ? 11 : -11;
            n2 += (int)((long)((int)(((long)GameImpl.Sin(n3) << 16) / (long)GameImpl.Cos(n3))) * (long)(Math.abs(n) << 16) >> 16) >> 16;
        } else {
            n = this._bdata[5] == 1 ? 23 : -23;
        }
        int n4 = (this.GetWormCenterX() >> 16) + n / 2;
        int n5 = (this.GetWormCenterY() >> 16) + n2;
        Level.GenerateWhole(this.GetWormCenterX() >> 16, n5, 12);
        Level.GenerateWhole(n4, n5, 12);
        if (n2 == -4) {
            Level.GenerateWhole(n4 + n / 2, n5, 12);
        }
        Level.InflictCollateralDamage(19, 13, n4 << 16, n5 << 16);
        this.Worm_UpdateMovement();
    }

    void Worm_UpdatePneumaticDrill() {
        GameImpl.Vibrate(80);
        if (GameImpl.canvas.getAppTime() - this._timer >= 5000L || (_nCommands & 0x20) != 0) {
            ++GameImpl._shootCounter;
            this.Worm_SetState((byte)0);
            this.HandleRetreatTimer();
            return;
        }
        this._idata[5] = 0;
        this.Worm_SetCrtAnim(71);
        int n = -4;
        int n2 = 22;
        int n3 = this._bdata[5] == 1 ? 11 : -11;
        int n4 = this.GetWormCenterX() >> 16;
        int n5 = (this.GetWormCenterY() >> 16) + (n += (int)((long)((int)(((long)GameImpl.Sin(n2) << 16) / (long)GameImpl.Cos(n2))) * (long)(Math.abs(n3) << 16) >> 16) >> 16);
        Level.GenerateWhole(this.GetWormCenterX() >> 16, n5, 12);
        Level.GenerateWhole(n4, n5, 12);
        if (n == -4) {
            Level.GenerateWhole(n4, n5, 12);
        }
        Level.InflictCollateralDamage(19, 13, n4 << 16, n5 << 16);
        this.Worm_UpdateMovement();
    }

    void Worm_UpdateJetpacking() {
        if (this._idata[7] <= 0) {
            this.Worm_SetState((byte)0);
            this._bdata[15] = -1;
            GameImpl.SetSoftKeys(385, 386);
            return;
        }
        this._bdata[16] = 0;
        if (this._pos_y < 0x460000) {
            this._velX = 0;
            this._velY = 0;
            this._pos_y = 0x460000;
            this._bdata[16] = 0;
        }
        if (this._pos_x < 0x320000) {
            this._velX = 0;
            this._velY = 0;
            this._pos_x = 0x320000;
            this._bdata[16] = 0;
        }
        if (this._pos_x > Level._nLandMaxWidth - 50 << 16) {
            this._velX = 0;
            this._velY = 0;
            this._pos_x = Level._nLandMaxWidth - 50 << 16;
            this._bdata[16] = 0;
        }
        if ((_nCommands & 0x40) != 0) {
            this.Force(0, -65536);
            this._bdata[16] = 1;
        }
        if ((_nCommands & 1) != 0) {
            this.Force(-16384, 0);
            this._bdata[16] = 1;
            this.SetWormDirection(-1);
        } else if ((_nCommands & 2) != 0) {
            this.Force(16384, 0);
            this._bdata[16] = 1;
            this.SetWormDirection(1);
        }
        if ((_nCommands & 0x20) != 0 || GameImpl.isKeyPressed(0x3001010) || GameImpl.isKeyPressed(0x2000000) || GameImpl.isKeyPressed(0x1000000)) {
            GameImpl.updateUsedWeaponUtilCount(2);
            this.Worm_SetState((byte)0);
            this._bdata[15] = -1;
            GameImpl.SetSoftKeys(385, 386);
        }
        this.Worm_SetCrtAnim(39);
        if (this._bdata[16] == 1) {
            if (!this.Worm_Collided(this._pos_x, this._pos_y + 65536)) {
                this._idata[7] = this._idata[7] - 32768;
            }
            if (this._idata[7] < 0) {
                this._velX = 0;
                this._velY = 0;
                this._idata[7] = 0;
            }
        } else {
            this.Worm_SetCrtAnim(66);
        }
        this.CreateRocketTailAnim();
    }

    void UpdateAIWorm() {
        if (GameImpl._nGamePlayState != 2) {
            return;
        }
        switch (this._bdata[0]) {
            case 38: {
                if (this._pShot == null || this._pShot._nShotType == -1) {
                    if (pShotCtr == 0) {
                        presentWeaponToUse = 0;
                        ++pShotCtr;
                        GameImpl._pCrtWorm._bdata[0] = 46;
                        return;
                    }
                    this.TryMyTeleporting();
                    return;
                }
                this._bdata[15] = this._pShot._nShotWeapon;
                if (GameImpl.IsFusedWeapon(this._bdata[15])) {
                    GameImpl._nFusedTimer = 3;
                    if (GameImpl._pCrtWorm != null) {
                        GameImpl._pCrtWorm._bdata[22] = 40;
                    }
                }
                this._nPrevWeaponSelected = this._bdata[15];
                if (this._pShot._nShotWeapon == 15) {
                    this._idata[5] = this._pShot._nShotAngle;
                }
                this.Worm_SetAIState((byte)39);
                break;
            }
            case 43: {
                _targetShowCursor = false;
                break;
            }
            case 41: {
                if (GameImpl.canvas.getAppTime() - this._timer < 2500L) break;
                GameImpl._bRetreating = false;
                ++GameImpl._shootCounter;
                GameImpl.SetGamePlayState(5);
                this.Worm_SetState((byte)0);
                break;
            }
            case 39: {
                this.SetWormDirection(this._pShot._nShotDirection);
                if (Math.abs(this._pShot._nShotAngle - this._idata[5]) < 1092) {
                    this._idata[5] = this._pShot._nShotAngle;
                    this.Worm_SetAIState((byte)40);
                    if (this._bdata[15] != 30) break;
                    this.Worm_SetState((byte)5);
                    break;
                }
                if (this._idata[5] < this._pShot._nShotAngle) {
                    this._idata[5] = this._idata[5] + 1092;
                    break;
                }
                if (this._idata[5] <= this._pShot._nShotAngle) break;
                this._idata[5] = this._idata[5] - 1092;
                break;
            }
            case 40: {
                this.UpdateAIShoot();
            }
        }
    }

    void UpdateAIShoot() {
        if (_shootPower >> 16 >= this._pShot._nShotPower >> 16) {
            _nCommands |= 0x20;
            _shootPower = this._pShot._nShotPower;
        }
    }

    boolean TryMyTeleporting() {
        int n = GameImpl.randomIncludelowHigh(480, 960);
        while (Level.LineTest(n << 16, 0x400000, n << 16, 0x2400000, false, 0) == 0) {
            n = GameImpl.randomIncludelowHigh(450, 1000);
        }
        _targetSelectPosX = Level.detX;
        _targetSelectPosY = Level.detY - 0x140000;
        _targetSelectPosX >>= 16;
        _targetSelectPosY >>= 16;
        this.Worm_SetAIState((byte)43);
        return true;
    }

    boolean TryTeleporting(int n) {
        Entity entity;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        if (Level._entities_usage[n] == 1 && (entity = Level._entities[n]) != null && entity._type == 1 && !entity.Worm_IsDyingOrDead() && entity._bdata[3] == 0) {
            n2 = 0;
            bl = false;
            do {
                _targetSelectPosX = n2 == 0 ? entity._pos_x + 327680 : entity._pos_x - 327680;
                _targetSelectPosY = entity._pos_y - GameImpl.random(655360, 0x280000);
                bl = !this.Worm_Collided(_targetSelectPosX << 16, _targetSelectPosY << 16);
                n3 = this.PlaceObjectOnGround(_targetSelectPosX >> 16, _targetSelectPosY >> 16, false);
                if (n3 < Level._sea_level) continue;
                bl = false;
            } while (++n2 < 2 && !bl);
            if (n2 < 5) {
                _targetSelectPosX >>= 16;
                _targetSelectPosY >>= 16;
                this.Worm_SetAIState((byte)43);
                return true;
            }
        }
        if (_targetSelectPosX == 0 && _targetSelectPosY == 0) {
            _targetSelectPosX = Level._entities[n]._pos_x >> 16;
            _targetSelectPosY = (Level._entities[n]._pos_y >> 16) + 16;
            this.Worm_SetAIState((byte)43);
            return true;
        }
        entity = null;
        return false;
    }

    boolean TryTeleporting() {
        Entity entity;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
            if (Level._entities_usage[i] != 1 || (entity = Level._entities[i]) == null || entity._type != 1 || entity.Worm_IsDyingOrDead() || entity._bdata[3] != 0) continue;
            n = 0;
            bl = false;
            do {
                bl = !this.Worm_Collided((_targetSelectPosX = entity._pos_x + GameImpl.random(-1966080, 0x1E0000)) << 16, (_targetSelectPosY = entity._pos_y - GameImpl.random(655360, 0x280000)) << 16);
                n2 = this.PlaceObjectOnGround(_targetSelectPosX >> 16, _targetSelectPosY >> 16, false);
                if (n2 < Level._sea_level) continue;
                bl = false;
            } while (++n < 5 && !bl);
            if (n >= 5) continue;
            _targetSelectPosX >>= 16;
            _targetSelectPosY >>= 16;
            this.Worm_SetAIState((byte)43);
            return true;
        }
        entity = null;
        return false;
    }

    boolean TryShootingRangedWeapon(int n, int n2) {
        Entity entity;
        boolean bl = false;
        bl = n2 != 28 && n2 != 17;
        if (Level._entities_usage[n] == 1 && (entity = Level._entities[n]) != null && entity._type == 1 && !entity.Worm_IsDyingOrDead() && entity._bdata[3] == 0) {
            _targetSelectPosX = entity._pos_x;
            _targetSelectPosY = entity._pos_y;
            if (n2 == 5 || n2 == 11) {
                if (Level.LineTest(_targetSelectPosX, _targetSelectPosY - 30, _targetSelectPosX + 200, 0, false, 0) != 0) {
                    _airstrikeDirection = 1;
                    bl = true;
                } else if (Level.LineTest(_targetSelectPosX, _targetSelectPosY - 30, _targetSelectPosX - 200, 0, false, 0) != 0) {
                    _airstrikeDirection = -1;
                    bl = true;
                } else {
                    _airstrikeDirection = -1;
                    bl = true;
                }
                _targetSelectPosX >>= 16;
                _targetSelectPosY >>= 16;
                if (bl) {
                    switch (n2) {
                        case 5: {
                            this._bdata[15] = 5;
                            this.Worm_Shoot(5);
                            _targetShowCursor = false;
                            break;
                        }
                        case 11: {
                            this._bdata[15] = 11;
                            this.Worm_Shoot(11);
                        }
                    }
                }
            }
            if (n2 == 28 || n2 == 17) {
                _targetSelectPosX = entity._pos_x >> 16;
                _targetSelectPosY = entity._pos_y >> 16;
                switch (n2) {
                    case 28: {
                        this._bdata[15] = 28;
                        this.Worm_Shoot(28);
                        break;
                    }
                    case 17: {
                        this._bdata[15] = 17;
                        this.Worm_Shoot(17);
                        Level.DisableEntity(Entity._targetEntity._id);
                        _targetEntity = null;
                        _targetShowCursor = false;
                    }
                }
            }
        }
        entity = null;
        return false;
    }

    void setRailGun(int n) {
        int n2 = (Level._entities[n]._pos_x >> 16) - (GameImpl._pCrtWorm._pos_x >> 16);
        int n3 = (Level._entities[n]._pos_y >> 16) - (GameImpl._pCrtWorm._pos_y >> 16);
        GameImpl._pCrtWorm._bdata[5] = Level._entities[n]._pos_x > GameImpl._pCrtWorm._pos_x ? 1 : -1;
        int n4 = GameImpl.Atan2(Math.abs(n3), Math.abs(n2));
        if (n2 < 0 && n3 < 0) {
            n4 = 90 + n4;
        }
        if (n2 < 0 && n3 >= 0) {
            n4 = 90 - n4;
        }
        if (n2 >= 0 && n3 < 0) {
            n4 = 90 + n4;
        }
        if (n2 >= 0 && n3 >= 0) {
            n4 = 90 - n4;
        }
        if (n4 < 0) {
            n4 *= -1;
        }
        this.SetWormDirection(GameImpl._pCrtWorm._bdata[5]);
        GameImpl._pCrtWorm._idata[5] = (n4 << 16) / 180;
    }

    void shootRailGun(int n) {
        this.Worm_Shoot(18);
        this._bdata[0] = 0;
    }

    void setShotGun(int n) {
        GameImpl._pCrtWorm._bdata[15] = 12;
        int n2 = (Level._entities[n]._pos_x >> 16) - (GameImpl._pCrtWorm._pos_x >> 16);
        int n3 = (Level._entities[n]._pos_y >> 16) - (GameImpl._pCrtWorm._pos_y >> 16);
        GameImpl._pCrtWorm._bdata[5] = Level._entities[n]._pos_x > GameImpl._pCrtWorm._pos_x ? 1 : -1;
        int n4 = GameImpl.Atan2(Math.abs(n3), Math.abs(n2));
        if (n2 < 0 && n3 < 0) {
            n4 = 90 + n4;
        }
        if (n2 < 0 && n3 >= 0) {
            n4 = 90 - n4;
        }
        if (n2 >= 0 && n3 < 0) {
            n4 = 90 + n4;
        }
        if (n2 >= 0 && n3 >= 0) {
            n4 = 90 - n4;
        }
        if (n4 < 0) {
            n4 *= -1;
        }
        this.SetWormDirection(GameImpl._pCrtWorm._bdata[5]);
        GameImpl._pCrtWorm._idata[5] = (n4 << 16) / 180;
    }

    void shootShotGun(int n) {
        this.Worm_Shoot(12);
        this.Worm_SetAIState((byte)40);
        this.Worm_SetState((byte)5);
        this._bdata[0] = 0;
    }

    void setAIUzi(int n) {
        GameImpl._pCrtWorm._bdata[15] = 30;
        int n2 = (Level._entities[n]._pos_x >> 16) - (GameImpl._pCrtWorm._pos_x >> 16);
        int n3 = (Level._entities[n]._pos_y >> 16) - (GameImpl._pCrtWorm._pos_y >> 16);
        GameImpl._pCrtWorm._bdata[5] = Level._entities[n]._pos_x > GameImpl._pCrtWorm._pos_x ? 1 : -1;
        int n4 = GameImpl.Atan2(Math.abs(n3), Math.abs(n2));
        if (n2 < 0 && n3 < 0) {
            n4 = 90 + n4;
        }
        if (n2 < 0 && n3 >= 0) {
            n4 = 90 - n4;
        }
        if (n2 >= 0 && n3 < 0) {
            n4 = 90 + n4;
        }
        if (n2 >= 0 && n3 >= 0) {
            n4 = 90 - n4;
        }
        if (n4 < 0) {
            n4 *= -1;
        }
        this.SetWormDirection(GameImpl._pCrtWorm._bdata[5]);
        GameImpl._pCrtWorm._idata[5] = (n4 << 16) / 180;
    }

    void shootUzi(int n) {
        this.Worm_Shoot(30);
        this.Worm_SetAIState((byte)40);
        this.Worm_SetState((byte)5);
        this._bdata[0] = 0;
    }

    void ShootKamikazi(int n) {
        int n2 = Level._entities[n]._pos_x - GameImpl._pCrtWorm._pos_x >> 16;
        int n3 = Level._entities[n]._pos_y - GameImpl._pCrtWorm._pos_y >> 16;
        GameImpl._pCrtWorm._bdata[5] = Level._entities[n]._pos_x > GameImpl._pCrtWorm._pos_x ? 1 : -1;
        int n4 = GameImpl.Atan2(n3 += GameImpl._pCrtWorm.GetWormCenterY() >> 16, n2);
        if (n4 < 0) {
            n4 *= -1;
        }
        this.SetWormDirection(GameImpl._pCrtWorm._bdata[5]);
        GameImpl._pCrtWorm._bdata[15] = 32;
        this.SelectWeapon((byte)32);
        GameImpl._pCrtWorm._idata[5] = (n4 << 16) / 180;
        GameImpl._pCrtWorm._idata[8] = GameImpl._nGameTimer;
        this.Worm_SetState((byte)24);
    }

    void ShootGasPump(int n, int n2) {
        GameImpl._pCrtWorm._bdata[5] = Level._entities[n]._pos_x > GameImpl._pCrtWorm._pos_x ? 1 : -1;
        this.Worm_Shoot(n2);
    }

    void PlaceAirStrikeWeapons(int n, int n2) {
        _airstrikeProjectylesFired = 0;
        this.TryShootingRangedWeapon(n, n2);
    }

    boolean TryShootingRangedWeapon() {
        Entity entity;
        boolean bl = false;
        for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
            if (Level._entities_usage[i] != 1 || (entity = Level._entities[i]) == null || entity._type != 1 || entity.Worm_IsDyingOrDead() || entity._bdata[3] != 0) continue;
            _targetSelectPosX = entity._pos_x;
            _targetSelectPosY = entity._pos_y;
            if (Level.LineTest(_targetSelectPosX, _targetSelectPosY - 20, _targetSelectPosX, 0, false, 0) != 0) {
                if (Level.LineTest(_targetSelectPosX, _targetSelectPosY - 30, _targetSelectPosX + 200, 0, false, 0) != 0) {
                    _airstrikeDirection = 1;
                    bl = true;
                } else if (Level.LineTest(_targetSelectPosX, _targetSelectPosY - 30, _targetSelectPosX - 200, 0, false, 0) != 0) {
                    _airstrikeDirection = -1;
                    bl = true;
                }
                _targetSelectPosX >>= 16;
                _targetSelectPosY >>= 16;
                if (bl) {
                    switch (GameImpl.random(1, 2)) {
                        case 1: {
                            this._bdata[15] = 5;
                            this.Worm_Shoot(5);
                            _targetShowCursor = false;
                            break;
                        }
                        case 2: {
                            this._bdata[15] = 11;
                            this.Worm_Shoot(11);
                        }
                    }
                } else {
                    switch (GameImpl.random(1, 2)) {
                        case 1: {
                            this._bdata[15] = 28;
                            this.Worm_Shoot(28);
                            break;
                        }
                        case 2: {
                            this._bdata[15] = 17;
                            this.Worm_Shoot(17);
                        }
                    }
                }
                return true;
            }
            switch (GameImpl.random(1, 2)) {
                case 1: {
                    this._bdata[15] = 28;
                    this.Worm_Shoot(28);
                    break;
                }
                case 2: {
                    this._bdata[15] = 17;
                    this.Worm_Shoot(17);
                }
            }
            return true;
        }
        entity = null;
        return false;
    }

    void AnalyzeWeapon(byte by) {
        if (this._nPrevWeaponSelected != -1 && this._nPrevWeaponSelected != by) {
            return;
        }
        switch (by) {
            case 0: 
            case 1: 
            case 7: 
            case 13: 
            case 19: 
            case 25: {
                int n = 13107;
                int n2 = 196608;
                int n3 = 13107;
                if (by == 1 || by == 7 || by == 25 || by == 19) {
                    n = 196608;
                    n2 = 196608;
                }
                this.AnalyzeAIProjectile(by, n, n2, n3, target);
                break;
            }
            case 5: 
            case 11: 
            case 17: {
                this.PlaceAirStrikeWeapons(target, presentWeaponToUse);
                break;
            }
            case 23: 
            case 27: {
                this.ShootGasPump(target, presentWeaponToUse);
                break;
            }
            case 3: 
            case 9: 
            case 15: 
            case 21: {
                this.AnalyzeAICombat(by);
            }
        }
        if (this._pShot == null || this._pShot._nShotBadDamage > 3 * this._pShot._nShotGoodDamage / 4) {
            // empty if block
        }
    }

    void AnalyzeAIProjectile(byte by, int n, int n2, int n3, int n4) {
        int n5 = Entity2.GetWeaponProjectyleType(by);
        int n6 = GameArray._kProjectilesInfo[n5][0];
        int n7 = GameArray._kProjectilesInfo[n5][1];
        int n8 = GameArray._kProjectilesInfo[n5][3];
        boolean bl = GameArray._kProjectilesInfo[n5][6] == 1;
        int n9 = (int)((long)GameImpl._windSpeedX * (long)GameArray._kProjectilesInfo[n5][5] >> 16);
        int n10 = (int)(32768L * (long)GameArray._kProjectilesInfo[n5][4] >> 16);
        int n11 = (int)((long)this._mass * (long)n10 >> 16);
        Shot shot = this._pShot;
        Shot shot2 = null;
        boolean bl2 = false;
        int n12 = this.GetWormCenterX();
        int n13 = this.GetWormCenterY();
        Entity entity = null;
        if (Level._entities_usage[n4] == 1 && (entity = Level._entities[n4]) != null && entity._type == 1 && Entity2.AreOpposingTeams(entity._bdata[3], this._bdata[3]) && !entity.Worm_IsDyingOrDead()) {
            int n14 = GameImpl._pCrtWorm._id > 4 && GameImpl._pCrtWorm._id < 9 ? entity._pos_x + (GameImpl._team1AccuracyRandom << 16) : entity._pos_x + (GameImpl._team2AccuracyRandom << 16);
            int n15 = entity.GetWormCenterY();
            n12 = GameImpl._pCrtWorm._pos_x;
            n13 = GameImpl._pCrtWorm._pos_y - 786432;
            for (int i = n; i <= n2; i += n3) {
                shot2 = this.PredictProjectile(by, n12, n13, n14, n15, n9, n11, i * 20 >> 16, n8, n6, n7, bl);
                if (shot2 == null) continue;
                if (!bl2 || shot.CompareTo(shot2) < 0) {
                    bl2 = true;
                    shot = null;
                    shot = shot2;
                    continue;
                }
                shot2 = null;
            }
        }
        if (shot != null) {
            this._pShot = shot;
        }
        if (this._pShot != shot2) {
            shot2 = null;
        }
        entity = null;
    }

    void AnalyzeAICombat(byte by) {
        int n = Entity2.GetWeaponProjectyleType(by);
        int n2 = GameArray._kProjectilesInfo[n][0];
        int n3 = GameArray._kProjectilesInfo[n][1];
        Shot shot = null;
        Shot shot2 = this._pShot;
        if (GameImpl._pCrtWorm._bdata[12] == 0 && presentWeaponToUse == 21) {
            int n4 = Level._entities[Entity.target]._pos_x;
            int n5 = -1;
            int n6 = GameImpl._pCrtWorm._pos_x;
            int n7 = GameImpl._pCrtWorm._pos_y;
            if (n6 > n4) {
                this.SetWormDirection(-1);
                n5 = -1;
            } else {
                this.SetWormDirection(1);
                n5 = 1;
            }
            this._pShot = this.PredictCombat(by, n6, n7, n5, n2, n3);
            if (this._pShot == null) {
                if (++meleeCtr == 3) {
                    this.Worm_SetAIState((byte)41);
                    return;
                }
                presentWeaponToUse = (byte)3;
                _nCommands = GameImpl._pCrtWorm._pos_x > Level._entities[Entity.target]._pos_x ? 1 : 2;
                GameImpl._pCrtWorm._bdata[0] = 44;
                return;
            }
            return;
        }
        for (int i = 0; i < 1; ++i) {
            int n8 = GameImpl._pCrtWorm._pos_x;
            int n9 = GameImpl._pCrtWorm._pos_y;
            for (int j = -1; j <= 1; j += 2) {
                shot = this.PredictCombat(by, n8, n9, j, n2, n3);
                if (shot == null && j <= 1) continue;
                if (shot2 == null || shot2.CompareTo(shot) < 0) {
                    shot2 = null;
                    shot2 = shot;
                    continue;
                }
                shot = null;
            }
        }
        if (shot2 != null) {
            this._pShot = shot2;
        }
        if (this._pShot != shot) {
            shot = null;
        }
    }

    Shot PredictCombat(byte by, int n, int n2, int n3, int n4, int n5) {
        Shot shot = new Shot();
        shot._nShotWeapon = by;
        shot._nShotGoodDamage = 0;
        shot._nShotBadDamage = 0;
        shot._nShotType = 3;
        shot._nShotStartX = n;
        shot._nShotStartY = n2;
        shot._nShotDirection = n3;
        shot._nShotMinDamage = n4;
        shot._nShotMaxDamage = n5;
        this.CalculateCombatDamage(shot, true);
        if (shot._nShotGoodDamage <= 0) {
            shot = null;
        }
        return shot;
    }

    Shot PredictProjectile(byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
        int n11 = n7 * (n7 + 1) / 2;
        int n12 = (n3 - n - n5 * n11) / n7;
        int n13 = (n4 - n2 - n6 * n11) / n7;
        Shot shot = new Shot();
        shot._nShotDX = n12;
        shot._nShotDY = n13;
        this.AdjustProjectileVector(by, shot);
        int n14 = shot._nShotPower;
        int n15 = shot._nShotAngle * 180 >> 16;
        int n16 = GameImpl.Sin(n15);
        int n17 = GameImpl.Cos(n15);
        int n18 = Entity2.GetShootProjectileOffset(by);
        int n19 = shot._nShotDirection * (int)((long)n18 * (long)n16 >> 16);
        int n20 = (int)((long)n18 * (long)n17 >> 16);
        int n21 = n + n19;
        int n22 = n2 + n20;
        int n23 = shot._nShotDX;
        int n24 = shot._nShotDY;
        int n25 = 4;
        if (by == 1 || by == 7 || by == 19) {
            n25 = 16;
        }
        int n26 = 0;
        int n27 = 0;
        boolean bl2 = false;
        int[] nArray = new int[]{n21, n22};
        for (n11 = 0; n11 <= n7 && !bl2; ++n11) {
            bl2 = this.LineTest(n25, nArray, nArray[0] + n23, nArray[1] + n24);
            n26 = nArray[0] >> 16;
            n27 = nArray[1] >> 16;
            n23 += n5;
            n24 += n6;
        }
        nArray = null;
        if (n11 <= 0 || !bl2 && !bl || bl2 && bl && n11 < n7 - 2) {
            shot = null;
            return null;
        }
        shot._nShotWeapon = by;
        shot._nShotGoodDamage = 0;
        shot._nShotBadDamage = 0;
        shot._nShotType = 0;
        shot._nShotStartX = n;
        shot._nShotStartY = n2;
        shot._nShotTargetX = n3;
        shot._nShotTargetY = n4;
        shot._nShotPX = n26 << 16;
        shot._nShotPY = n27 << 16;
        shot._nShotPower = n14;
        shot._nShotRadius = n8 << 16;
        shot._nShotMinDamage = n9;
        shot._nShotMaxDamage = n10;
        this.CalculateDamage(shot, false);
        return shot;
    }

    Shot PredictBullet(byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        int n9 = 0;
        int n10 = n3 - n;
        int n11 = n4 - n2;
        Shot shot = new Shot();
        shot._nShotDX = n10;
        shot._nShotDY = n11;
        this.AdjustBulletVector(by, shot);
        GameImpl._vector[0] = n10;
        GameImpl._vector[1] = n11;
        int n12 = GameImpl.Normalize(GameImpl._vector);
        n10 = GameImpl._vector[0];
        n11 = GameImpl._vector[1];
        int n13 = 0x3C00000;
        if (n12 > n13) {
            shot = null;
            return null;
        }
        int n14 = n;
        int n15 = n2;
        int n16 = shot._nShotAngle * 180 >> 16;
        int n17 = GameImpl.GetBulletMaxSpeed(by);
        int n18 = GameImpl.Sin(n16);
        int n19 = GameImpl.Cos(n16);
        n10 = shot._nShotDirection * (int)((long)n17 * (long)n18 >> 16);
        n11 = (int)((long)n17 * (long)n19 >> 16);
        shot._nShotDX = n10;
        shot._nShotDY = n11;
        int n20 = 0;
        for (n20 = 0; n20 <= n13 && !Level.RectCollideWithLandCenter(n8 = n14 >> 16, n9 = n15 >> 16, 2, 2, false); n20 += 65536) {
            n14 += n10;
            n15 += n11;
        }
        if (n20 <= 0) {
            shot = null;
            return null;
        }
        shot._nShotWeapon = by;
        shot._nShotGoodDamage = 0;
        shot._nShotBadDamage = 0;
        shot._nShotType = 1;
        shot._nShotStartX = n;
        shot._nShotStartY = n2;
        shot._nShotTargetX = n3;
        shot._nShotTargetY = n4;
        shot._nShotPX = n8 << 16;
        shot._nShotPY = n9 << 16;
        shot._nShotRadius = GameArray._kProjectilesInfo[Entity2.GetWeaponProjectyleType(by)][3] << 16;
        shot._nShotMinDamage = n6;
        shot._nShotMaxDamage = n7;
        this.CalculateDamage(shot, false);
        return shot;
    }

    boolean LineTest(int n, int[] nArray, int n2, int n3) {
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = (Math.abs(n2 - nArray[0]) + Math.abs(n3 - nArray[1]) >> 16) / 6 + 1;
        for (int i = 0; i <= n6; ++i) {
            nArray[0] = (n2 - n4) * i / n6 + n4;
            nArray[1] = (n3 - n5) * i / n6 + n5;
            int n7 = nArray[0] >> 16;
            int n8 = nArray[1] >> 16;
            if (!Level.RectCollideWithLandCenter(n7, n8, n / 2, n / 2, true)) continue;
            return true;
        }
        return false;
    }

    void AdjustProjectileVector(int n, Shot shot) {
        int n2;
        int n3 = shot._nShotDX;
        int n4 = shot._nShotDY;
        GameImpl._vector[0] = n3;
        GameImpl._vector[1] = n4;
        int n5 = GameImpl.Normalize(GameImpl._vector);
        int n6 = GameImpl.PrecisionA2tan(GameImpl._vector[0], -GameImpl._vector[1]);
        if (n6 >= 32768) {
            n6 = n6 - 32768 << 1;
            n2 = -1;
        } else {
            n6 = 32768 - n6 << 1;
            n2 = 1;
        }
        int n7 = n6 * 180 >> 16;
        int n8 = GameImpl.GetBulletMaxSpeed(n);
        int n9 = (int)(((long)(n5 * 100) << 16) / (long)n8);
        n3 = n2 * GameImpl.Sin(n7);
        n4 = GameImpl.Cos(n7);
        shot._nShotDirection = n2;
        shot._nShotAngle = n6;
        shot._nShotPower = n9;
        shot._nShotDX = (int)((long)n3 * (long)n5 >> 16);
        shot._nShotDY = (int)((long)n4 * (long)n5 >> 16);
    }

    void AdjustBulletVector(int n, Shot shot) {
        GameImpl._vector[0] = shot._nShotDX;
        GameImpl._vector[1] = shot._nShotDY;
        GameImpl.Normalize(GameImpl._vector);
        int n2 = GameImpl.PrecisionA2tan(GameImpl._vector[0], -GameImpl._vector[1]);
        int n3 = 1;
        if (n2 >= 32768) {
            n2 = n2 - 32768 << 1;
            n3 = -1;
        } else {
            n2 = 32768 - n2 << 1;
            n3 = 1;
        }
        shot._nShotAngle = n2;
        shot._nShotDirection = n3;
    }

    int PowerQuant(int n) {
        int n2 = 327680;
        n = (int)(((long)n << 16) / (long)n2) >> 16;
        n = (int)((long)(n << 16) * (long)n2 >> 16);
        return n;
    }

    int AngleQuant(int n) {
        return n;
    }

    void CalculateCombatDamage(Shot shot, boolean bl) {
        int n;
        int n2;
        int n3 = shot._nShotStartX >> 16;
        int n4 = shot._nShotStartY >> 16;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        switch (shot._nShotWeapon) {
            case 3: {
                n2 = -((int)(393216L * (long)GameImpl.Sin(90) >> 16));
                n = (int)((long)n2 * (long)(n2 + 65536) >> 16) / 2;
                n4 = shot._nShotStartY - n >> 16;
                n5 = shot._nShotDirection * GameArray._kProjectilesInfo[2][3];
                n6 = n >> 16;
                break;
            }
            case 9: {
                n3 = (shot._nShotStartX >> 16) + shot._nShotDirection * 2;
                n4 = (shot._nShotStartY >> 16) - 25;
                if (shot._nShotDirection == -1) {
                    n3 -= 14;
                }
                n5 = 14;
                n6 = 25;
                break;
            }
            case 15: {
                n3 = (shot._nShotStartX >> 16) + shot._nShotDirection * 4;
                if (shot._nShotDirection == -1) {
                    n3 -= GameArray._kProjectilesInfo[12][3];
                }
                n5 = GameArray._kProjectilesInfo[12][3];
                n6 = GameArray._kProjectilesInfo[12][3];
                shot._nShotAngle = 32768;
                break;
            }
            case 21: {
                n3 = (shot._nShotStartX >> 16) + shot._nShotDirection * 4;
                if (shot._nShotDirection == -1) {
                    n3 -= GameArray._kProjectilesInfo[16][3];
                }
                n5 = GameArray._kProjectilesInfo[16][3];
                n6 = GameArray._kProjectilesInfo[16][3];
                shot._nShotAngle = 36044;
            }
        }
        if (n5 < 0) {
            n3 += n5;
            n5 = -n5;
        }
        n2 = shot._nShotMaxDamage;
        n = 0;
        int n8 = 0;
        Entity entity = null;
        boolean bl2 = false;
        for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
            if (Level._entities_usage[i] != 1 || (entity = Level._entities[i]) == null || entity._type != 1 || entity.Worm_IsDyingOrDead() || bl && entity == this) continue;
            bl2 = false;
            if (shot._nShotWeapon == 21 || shot._nShotWeapon == 15) {
                GameImpl._vector[0] = entity._pos_x - shot._nShotStartX;
                GameImpl._vector[1] = entity.GetWormCenterY() - shot._nShotStartY;
                n7 = GameImpl.Normalize(GameImpl._vector);
                if (n7 >> 16 < n5) {
                    bl2 = true;
                }
            } else if (GameImpl.IntersectsRectRect(n3, n4, n5, n6, (entity._pos_x >> 16) + entity._bbox[0], (entity._pos_y >> 16) + entity._bbox[1], entity._bbox[2] - entity._bbox[0], entity._bbox[3] - entity._bbox[1])) {
                bl2 = true;
            }
            if (!bl2) continue;
            if (!Entity2.AreOpposingTeams(this._bdata[3], entity._bdata[3])) {
                n += 5 * n2;
                continue;
            }
            n8 += n2;
        }
        shot._nShotGoodDamage = n8;
        shot._nShotBadDamage = n;
    }

    void CalculateDamage(Shot shot, boolean bl) {
        int n = shot._nShotPX;
        int n2 = shot._nShotPY;
        int n3 = 0;
        int n4 = 0;
        if (shot._nShotRadius == 0) {
            return;
        }
        Entity entity = null;
        int n5 = shot._nShotMinDamage;
        int n6 = shot._nShotMaxDamage;
        int n7 = 0;
        for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            entity = Level._entities[i];
            if (entity._type != 1 || bl && this == entity) continue;
            int n8 = entity._pos_x;
            int n9 = entity._pos_y;
            GameImpl._vector[0] = n8 - n;
            GameImpl._vector[1] = n9 - n2;
            int n10 = GameImpl.Normalize(GameImpl._vector);
            if (n10 > shot._nShotRadius || (n7 = (n5 << 16) + (int)((long)(n6 - n5 << 16) * (long)((int)(((long)shot._nShotRadius - (long)n10 << 16) / (long)shot._nShotRadius)) >> 16)) >> 16 <= 0) continue;
            int n11 = 0x640000 - Math.abs((Level._sea_level << 16) - n9);
            n11 = GameImpl.Clamp(n11 / 100, 0, 131072) + 65536;
            n7 = (int)(((long)n7 << 16) / (long)n11);
            int n12 = 0;
            if (!Entity2.AreOpposingTeams(this._bdata[3], entity._bdata[3])) {
                n12 += 2;
            }
            if (n12 == 0) {
                if (entity._bdata[12] == 1) {
                    n7 *= 2;
                }
                n3 += n7;
                continue;
            }
            n4 += n7 * (n12 + 1);
        }
        entity = null;
        shot._nShotGoodDamage = n3;
        shot._nShotBadDamage = n4;
    }

    void InitializeAITurn() {
        this._nPrevWeaponSelected = -1;
        _nPathSearchesThisTurn = 0;
    }

    void UpdatePhysics() {
        switch (this._type) {
            case 28: {
                return;
            }
            case 2: {
                int[] nArray;
                Entity entity;
                if (this._pos_y >> 16 > Level._sea_level) {
                    this.SetPosition(this._pos_x, this._pos_y + this._velY);
                    this._z_order = 6;
                    return;
                }
                if (this._projectileType == 14) {
                    if (GameImpl._railgunStartFrames < 12) {
                        GameImpl._railgunFrame = 0 + GameImpl._railgunStartFrames / 4;
                        ++GameImpl._railgunStartFrames;
                        return;
                    }
                    this.CreateRailgunHoles();
                }
                this.ApplyGravity();
                this.ApplyWind();
                if (this._projectileType == 5 && GameImpl.canvas.getAppTime() - this._timer >= 1000L) {
                    this._homingtail = true;
                    long l = 327680L;
                    long l2 = 327680L;
                    if (GameImpl.canvas.getAppTime() - this._seektimer >= 5000L) {
                        this._homingtail = false;
                        l = 0L;
                        l2 = 0L;
                    }
                    int n = GameImpl.PrecisionLength(this._pos_x - (_targetSelectPosX << 16), this._pos_y - (_targetSelectPosY << 16));
                    l = l * (long)((_targetSelectPosX << 16) - this._pos_x) / (long)n;
                    l2 = l2 * (long)((_targetSelectPosY << 16) - this._pos_y) / (long)n;
                    this._velX = (int)((long)this._velX + l);
                    this._velY = (int)((long)this._velY + l2);
                    int n2 = GameImpl.GetBulletMaxSpeed(6);
                    int n3 = this._velX;
                    int n4 = this._velY;
                    if (Math.abs(n3) > n2) {
                        this._velX = Math.abs(this._velX) / this._velX * n2;
                        this._velY = (int)(((long)((int)((long)this._velX * (long)this._velY >> 16)) << 16) / (long)n3);
                    } else if (Math.abs(n4) > n2) {
                        this._velY = Math.abs(this._velY) / this._velY * n2;
                        this._velX = (int)(((long)((int)((long)this._velY * (long)this._velX >> 16)) << 16) / (long)n4);
                    }
                }
                if ((entity = this.Projectile(nArray = new int[1])) != null) {
                    if (this._projectileType == 13 && entity._type != 7) {
                        this._blastBunkerBuster = 50;
                    }
                    if (this._projectileType == 21) {
                        if (entity.TransferEnergy(this, 3)) break;
                        _targetShowCursor = false;
                        this.Explode(this._pos_x >> 16, this._pos_y >> 16, 21);
                        this.Force(0, -131072);
                        this.Rebound(entity, 3);
                        break;
                    }
                    if (this._projectileType == 14) {
                        if (entity._type == 1 || entity._type == 12) {
                            if (this._projectileType == 14) {
                                entity._bHitByRailgun = true;
                            }
                            this.CollideWith(entity, nArray[0]);
                        } else {
                            this.SetPosition(this._pos_x + this._velX, this._pos_y + this._velY);
                        }
                    } else {
                        this.CollideWith(entity, nArray[0]);
                    }
                }
                nArray = null;
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 20: 
            case 24: 
            case 26: 
            case 27: {
                this.ApplyGravity();
                int[] nArray = new int[1];
                Entity entity = this.Projectile(nArray);
                if (entity != null && entity._projectileType != 14) {
                    this.CollideWith(entity, nArray[0]);
                }
                nArray = null;
                break;
            }
            case 1: {
                if (this._nState == 14) {
                    this.Worm_ChangePos(this._pos_x, this._pos_y + this._velY);
                    break;
                }
                if (this._nState == 18 && this._crt_aframe >= 10 || this._nState == 20) {
                    int n = 2;
                    if (this._nState == 20) {
                        n = 8;
                    }
                    this.Explode(this._pos_x >> 16, (this._pos_y >> 16) - 15, n);
                }
                if (this._nState != 7 && this._nState != 11 && this._nState != 25 && this._nState != 12 && this._nState != 23 && this._nState != 10 && this._nState != 18 && this._nState != 20 && this._nState != 15) break;
                this.ApplyGravity();
                int[] nArray = new int[1];
                Entity entity = this.Projectile(nArray);
                if (this._nState != 18 && entity != null) {
                    this.CollideWith(entity, nArray[0]);
                }
                nArray = null;
                break;
            }
            case 12: {
                this.ApplyGravity();
            }
        }
    }

    Entity Projectile(int[] nArray) {
        int n = 0;
        Entity entity = null;
        int n2 = this._pos_x;
        int n3 = this._pos_y;
        int n4 = this._velX;
        int n5 = this._velY;
        int n6 = n4;
        int n7 = n5;
        int n8 = n2 + n6;
        int n9 = n3 + n7;
        int n10 = n2;
        int n11 = n3;
        int n12 = n8;
        int n13 = n9;
        if ((n10 & 0xFFFF0000) == (n12 & 0xFFFF0000) && (n11 & 0xFFFF0000) == (n13 & 0xFFFF0000)) {
            this.SetPosition(n8, n9);
            return null;
        }
        int n14 = 0;
        int n15 = n10;
        int n16 = n11;
        if (Math.abs(n12 - n10) >= Math.abs(n13 - n11)) {
            n6 = n10 < n12 ? 65536 : -65536;
            int n17 = Math.abs(n12 - n10);
            int n18 = n11;
            while (n10 != n12) {
                entity = this.VerifyCollision(n10 = Math.abs(n12 - n10) >= 65536 ? n10 + n6 & 0xFFFF0000 : n12, n18);
                if (entity != null) {
                    n2 = n15;
                    n3 = n16;
                    if (n6 < 0) {
                        n = 0;
                        n2 &= 0xFFFF0000;
                    } else {
                        n = 1;
                        n2 = (n2 & 0xFFFF0000) + 65536 - 1;
                    }
                    this.SetPosition(n2, n3);
                    nArray[0] = n;
                    return entity;
                }
                n15 = n10;
                n14 = (int)(((long)n17 - (long)Math.abs(n12 - n10) << 16) / (long)n17);
                n18 = (int)((long)(n13 - n11) * (long)n14 >> 16) + n11;
                if ((n18 & 0xFFFF0000) != (n16 & 0xFFFF0000) && (entity = this.VerifyCollision(n10, n18)) != null) {
                    n2 = n15;
                    n3 = n16;
                    if (n13 < n11) {
                        n = 2;
                        n3 &= 0xFFFF0000;
                    } else {
                        n = 3;
                        n3 = (n3 & 0xFFFF0000) + 65536 - 1;
                    }
                    this.SetPosition(n2, n3);
                    nArray[0] = n;
                    return entity;
                }
                n16 = n18;
            }
        } else {
            n7 = n11 < n13 ? 65536 : -65536;
            int n19 = Math.abs(n13 - n11);
            int n20 = n10;
            while (n11 != n13) {
                entity = this.VerifyCollision(n20, n11 = Math.abs(n13 - n11) >= 65536 ? n11 + n7 & 0xFFFF0000 : n13);
                if (entity != null) {
                    n2 = n15;
                    n3 = n16;
                    if (n7 < 0) {
                        n = 2;
                        n3 &= 0xFFFF0000;
                    } else {
                        n = 3;
                        n3 = (n3 & 0xFFFF0000) + 65536 - 1;
                    }
                    this.SetPosition(n2, n3);
                    nArray[0] = n;
                    return entity;
                }
                n16 = n11;
                n14 = (int)(((long)n19 - (long)Math.abs(n13 - n11) << 16) / (long)n19);
                n20 = (int)((long)(n12 - n10) * (long)n14 >> 16) + n10;
                if ((n20 & 0xFFFF0000) != (n15 & 0xFFFF0000) && (entity = this.VerifyCollision(n20, n11)) != null) {
                    n2 = n15;
                    n3 = n16;
                    if (n12 < n10) {
                        n = 0;
                        n2 &= 0xFFFF0000;
                    } else {
                        n = 1;
                        n2 = (n2 & 0xFFFF0000) + 65536 - 1;
                    }
                    this.SetPosition(n2, n3);
                    nArray[0] = n;
                    return entity;
                }
                n15 = n20;
            }
        }
        this.SetPosition(n8, n9);
        return null;
    }

    Entity VerifyCollision(int n, int n2) {
        Entity entity = null;
        for (int i = 0; i < Level._nMaxUsedEntities; ++i) {
            if (Level._entities_usage[i] != 1) continue;
            entity = Level._entities[i];
            if (this._type == 2 && this._projectileType == 4 && _isANaplamStrike) {
                if (_targetSelectPosY - (n2 >> 16) > 150 && !this.CollideWith(entity, n, n2 + 0x960000)) continue;
                return entity;
            }
            if (entity == this || !this.CollideWith(entity, n, n2)) continue;
            return entity;
        }
        entity = null;
        return null;
    }

    boolean CollideWith(Entity entity, int n, int n2) {
        if ((this._flags & 0x20) == 0 || entity == null || (entity._flags & 0x20) == 0 || (this._collisionFlag & this.GetCollisionFlag(entity)) == 0) {
            return false;
        }
        if (this._type == 1 && this._nState == 20) {
            return false;
        }
        if (GameImpl._pCrtWorm != null && GameImpl._pCrtWorm == entity && this._type == 2 && this._sdata[0] < 1) {
            return false;
        }
        int n3 = (n >> 16) + this._bbox[0];
        int n4 = (n2 >> 16) + this._bbox[1];
        int n5 = this._bbox[2] - this._bbox[0];
        int n6 = this._bbox[3] - this._bbox[1];
        if (entity._type == 7) {
            boolean bl = false;
            if (this._type == 2 && this._projectileType == 14) {
                bl = true;
            }
            return Level.RectCollideWithLand(n3, n4, n5, n6, bl);
        }
        if (this._type == 2 && this._projectileType == 14 && (entity._type == 1 || entity._type == 12) && entity._bHitByRailgun) {
            return false;
        }
        int n7 = (entity._pos_x >> 16) + entity._bbox[0];
        int n8 = (entity._pos_y >> 16) + entity._bbox[1];
        int n9 = entity._bbox[2] - entity._bbox[0];
        int n10 = entity._bbox[3] - entity._bbox[1];
        return GameImpl.IntersectsRectRect(n7, n8, n9, n10, n3, n4, n5, n6);
    }

    void CollideWith(Entity entity, int n) {
        if (this._type == 2 && this._projectileType != 13) {
            this.isRocketTailAnimOn = true;
        }
        block0 : switch (this._type) {
            case 1: {
                this.Worm_CollideWith(entity, n);
                break;
            }
            case 2: {
                switch (this._projectileType) {
                    case 11: {
                        this.EndShooting(true);
                        this.UpdateCollided(this._pos_x, this._pos_y);
                        break;
                    }
                    case 1: 
                    case 6: 
                    case 15: 
                    case 17: {
                        if (entity.TransferEnergy(this, n)) break block0;
                        this.Rebound(entity, n);
                        break;
                    }
                    case 4: {
                        if (_isANaplamStrike) {
                            this.EndShooting(true);
                        }
                        if (entity._type == 2 && entity._projectileType == 4) {
                            return;
                        }
                    }
                    default: {
                        this.UpdateCollided(this._pos_x, this._pos_y);
                        break;
                    }
                }
                break;
            }
            case 11: {
                break;
            }
            case 26: {
                break;
            }
            case 20: {
                this.UpdateCollided(this._pos_x, this._pos_y);
                break;
            }
            case 23: {
                break;
            }
            default: {
                if (entity.TransferEnergy(this, n)) break;
                this.Rebound(entity, n);
            }
        }
    }

    boolean TransferEnergy(Entity entity, int n) {
        switch (this._type) {
            case 1: {
                return false;
            }
            case 7: {
                return entity._type == 11 || entity._type == 23 || entity._type == 24 || entity._type == 26;
            }
            case 28: {
                return false;
            }
            case 27: {
                return true;
            }
            case 9: 
            case 12: 
            case 13: {
                return false;
            }
            case 11: 
            case 15: 
            case 23: {
                return true;
            }
        }
        return this.TransferDefaultEnergy(entity, n);
    }

    boolean TransferDefaultEnergy(Entity entity, int n) {
        int n2;
        int n3;
        Entity entity2 = entity;
        Entity entity3 = this;
        switch (n) {
            case 0: 
            case 1: {
                int n4 = (int)((long)entity2._velX * (long)entity2._mass >> 16);
                int n5 = (int)((long)entity3._velX * (long)entity3._mass >> 16);
                entity2._velY = (int)((long)entity2._velY * (long)entity2._landDrag >> 16);
                if (Math.abs(entity2._velY) < 39321) {
                    entity2._velY = 0;
                }
                if ((n4 > 0 ? 1 : -1) == (n5 > 0 ? 1 : -1) && Math.abs(entity2._velX) <= Math.abs(entity3._velX)) {
                    return true;
                }
                n3 = Math.abs(n4 - n5) >= 39321 ? (int)((long)(n4 - n5) * 32768L >> 16) : n4 - n5;
                n2 = 0;
                break;
            }
            case 2: 
            case 3: {
                int n6 = (int)((long)entity2._velY * (long)entity2._mass >> 16);
                int n7 = (int)((long)entity3._velY * (long)entity3._mass >> 16);
                entity2._velX = (int)((long)entity2._velX * (long)entity2._landDrag >> 16);
                if (Math.abs(entity2._velX) < 39321) {
                    entity2._velX = 0;
                }
                if ((n6 > 0 ? 1 : -1) == (n7 > 0 ? 1 : -1) && Math.abs(entity2._velY) <= Math.abs(entity3._velY)) {
                    return true;
                }
                n2 = Math.abs(n6 - n7) >= 39321 ? (int)((long)(n6 - n7) * 32768L >> 16) : n6 - n7;
                n3 = 0;
                break;
            }
            default: {
                n2 = 0;
                n3 = 0;
            }
        }
        entity3.Force(n3, n2);
        entity2.Force(-n3, -n2);
        if (Math.abs(entity2._velX) + Math.abs(entity2._velY) < 39321) {
            entity2.ResetSpeed();
        }
        if (Math.abs(entity3._velX) + Math.abs(entity3._velY) < 39321) {
            entity3.ResetSpeed();
        }
        return true;
    }

    void Rebound(Entity entity, int n) {
        if (this._bSimpleRebound) {
            this.SimpleRebound(entity, n);
        } else {
            this.ComplexRebound(entity, n);
        }
        if (Math.abs(this._velX) + Math.abs(this._velY) < 39321) {
            this.ResetSpeed();
        }
        if (Math.abs(entity._velX) + Math.abs(entity._velY) < 39321) {
            entity.ResetSpeed();
        }
    }

    void SimpleRebound(Entity entity, int n) {
        switch (n) {
            case 0: 
            case 1: {
                this._velX = -((int)((long)this._velX * (long)this._xBounce >> 16));
                this._velY = (int)((long)this._velY * (long)this._landDrag >> 16);
                break;
            }
            case 2: 
            case 3: {
                this._velX = (int)((long)this._velX * (long)this._landDrag >> 16);
                this._velY = -((int)((long)this._velY * (long)this._yBounce >> 16));
            }
        }
    }

    void ComplexRebound(Entity entity, int n) {
        int n2 = 65536;
        switch (n) {
            case 0: 
            case 1: {
                int n3;
                int n4 = n3 = this._velX < 0 ? -65536 : 65536;
                if (this.SetPosition(this._pos_x + n3, this._pos_y - n2)) {
                    this._velX = (int)((long)this._velX * (long)(this._landDrag * 30 / 32) >> 16);
                    break;
                }
                if (this.SetPosition(this._pos_x + n3, this._pos_y + n2)) {
                    this._velX = (int)((long)this._velX * (long)(this._landDrag * 30 / 32) >> 16);
                    break;
                }
                this._velX = -((int)((long)this._velX * (long)this._xBounce >> 16));
                this._velY = (int)((long)this._velY * (long)this._landDrag >> 16);
                break;
            }
            case 2: 
            case 3: {
                this._velX = (int)((long)this._velX * (long)this._landDrag >> 16);
                this._velY = -((int)((long)this._velY * (long)this._yBounce >> 16));
            }
        }
        if (Math.abs(this._velX) + Math.abs(this._velY) < 39321) {
            this.ResetSpeed();
        }
        if (Math.abs(entity._velX) + Math.abs(entity._velY) < 39321) {
            entity.ResetSpeed();
        }
    }

    void InitPhysics() {
        this._mass = 65536;
        this._landDrag = 32768;
        this._xBounce = 43690;
        this._yBounce = 43690;
        switch (this._type) {
            case 2: {
                this._mass = 65536;
                this._flags |= 0x20;
                switch (this._projectileType) {
                    case 14: {
                        this._collisionFlag = 162;
                        break;
                    }
                    case 30: {
                        this._collisionFlag = 226;
                        break;
                    }
                    case 15: {
                        this._xBounce = 39321;
                        this._yBounce = 39321;
                        this._mass = 65536;
                        this._collisionFlag |= 0x1A3;
                        break;
                    }
                    case 21: {
                        this._mass = 131072;
                        this._xBounce = 0;
                        this._yBounce = 0;
                        this._bSimpleRebound = false;
                        this._collisionFlag |= 0x1A3;
                        break;
                    }
                    case 17: 
                    case 18: {
                        this._collisionFlag = 419;
                        break;
                    }
                    default: {
                        this._collisionFlag = 419;
                    }
                }
                this._collisionFlag |= 0x100;
                break;
            }
            case 1: {
                this._mass = 65536;
                this._flags |= 0x20;
                this._landDrag = 52428;
                this._collisionFlag |= 0x81;
                break;
            }
            case 11: {
                this._mass = 65536;
                this._flags |= 0x20;
                this._xBounce = 65536;
                this._yBounce = 49152;
                this._landDrag = 0;
                this._collisionFlag |= 0x23;
                break;
            }
            case 20: {
                this._mass = 65536;
                this._flags |= 0x20;
                this._collisionFlag |= 0x1A3;
                break;
            }
            case 23: {
                this._mass = 65536;
                this._flags |= 0x20;
                this._xBounce = 65536;
                this._yBounce = 32768;
                this._landDrag = 0;
                this._collisionFlag |= 2;
                break;
            }
            case 24: {
                this._mass = 65536;
                this._flags |= 0x20;
                this._xBounce = 39321;
                this._yBounce = 65536;
                this._landDrag = 0;
                this._collisionFlag |= 1;
                break;
            }
            case 26: {
                this._mass = 65536;
                this._flags |= 0x20;
                this._xBounce = 39321;
                this._yBounce = 65536;
                this._landDrag = 0;
                this._collisionFlag |= 1;
                break;
            }
            case 15: {
                this._yBounce = 16384;
                this._flags |= 0x20;
                this._collisionFlag |= 3;
                break;
            }
            case 7: {
                this._flags |= 0x38;
                this._collisionFlag |= 0x2FE;
                break;
            }
            case 9: {
                this._yBounce = 16384;
                this._flags |= 0x20;
                this._collisionFlag = 1;
                break;
            }
            case 12: {
                this._collisionFlag = 3;
                break;
            }
            case 28: {
                this._collisionFlag = 0;
            }
            case 27: {
                this._collisionFlag |= 0xA9;
                break;
            }
            case 13: {
                this._collisionFlag |= 1;
                break;
            }
            case 14: {
                this._flags |= 0x20;
            }
        }
    }

    void Force(int n, int n2) {
        this._velX += (int)(((long)n << 16) / (long)this._mass);
        this._velY += (int)(((long)n2 << 16) / (long)this._mass);
    }

    boolean ApplyGravity() {
        int n = 65536;
        if (this._type == 1 && this._nState == 23) {
            n = 6553;
        }
        if (this._type == 2) {
            n = GameArray._kProjectilesInfo[this._projectileType][4];
        }
        int n2 = (int)(32768L * (long)n >> 16);
        if ((n2 = (int)((long)this._mass * (long)n2 >> 16)) == 0) {
            return false;
        }
        if (this._type == 1 && this._nState == 20) {
            this._velX -= (this._velX > 0 ? 1 : -1) * n2;
        } else if (this._type == 27) {
            this._velY = (int)(32768L * (long)n >> 16) * 10;
            this._velX = 0;
            if (!this.Worm_Collided(this._pos_x, this._pos_y + 65536)) {
                this._velX = GameImpl._windSpeedX;
                this._pos_x += this._velX;
            } else {
                this._velX = 0;
            }
        } else {
            this._velY += n2;
        }
        return true;
    }

    void ApplyWind() {
        if (this._type == 2 && this._projectileType != 5) {
            this._velX += (int)((long)GameArray._kProjectilesInfo[this._projectileType][5] * (long)GameImpl._windSpeedX >> 16);
        }
    }

    void UpdateCollided(int n, int n2) {
        if (this._type == 2 || this._type == 20) {
            this.Explode(n >> 16, n2 >> 16, this._projectileType);
        } else {
            this.ResetSpeed();
        }
    }

    void Explode(int n, int n2, int n3) {
        if (GameImpl._pCrtWorm != null && GameImpl._pCrtWorm._bdata[9] == 1 && Level._isRealTime) {
            GameImpl._pCrtWorm._bdata[9] = 0;
        }
        int n4 = GameArray._kProjectilesInfo[n3][2];
        int n5 = GameArray._kProjectilesInfo[n3][3];
        boolean bl = false;
        int n6 = -1;
        switch (n3) {
            case 4: {
                bl = true;
                if (_isANaplamStrike) {
                    this.CreateExplodeAnim(n, n2, n4, 0);
                    this.CreateFireAnim(n, n2, n4);
                    for (int i = -5; i <= 5; i += 5) {
                        Entity entity = Level.SpawnEntity(27);
                        if (entity == null) continue;
                        entity.Init(27, n + i << 16, n2 << 16, null, null);
                        entity.LifeTimeSpent = 49;
                    }
                    if (_targetEntity != null) {
                        Level.DisableEntity(Entity._targetEntity._id);
                        _targetEntity = null;
                    }
                    GameImpl.Vibrate(128);
                    return;
                }
                n6 = 128;
            }
            case 5: {
                if (_targetEntity != null) {
                    Level.DisableEntity(Entity._targetEntity._id);
                    _targetEntity = null;
                }
            }
            case 0: {
                this.EndShooting(true);
                this.CreateExplodeAnim(n, n2, n4, 0);
                bl = true;
                n6 = 80;
                Level.StartCameraShake(n3);
                break;
            }
            case 31: {
                n6 = 32;
                Entity entity = Level.SpawnEntity(5);
                entity.Init(5, n << 16, n2 << 16, null, null);
                entity.SetSprite(5);
                entity.SetCrtAnim(23);
                Level.InflictCollateralDamage(n3, 25, n << 16, n2 << 16);
                Level.DisableEntity(this._id);
                return;
            }
            case 22: {
                this.EndShooting(true);
                n6 = 32;
                this.CreateExplodeAnim(n, n2, n4, 22);
                bl = true;
                break;
            }
            case 21: {
                ++GameImpl._shootCounter;
                this.CreateExplodeAnim(this._pos_x >> 16, this._pos_y >> 16, 35, 21);
                GameImpl.StopSounds();
                GameImpl.PlaySound(1);
                Level.GenerateWhole(n, n2, 35);
                this._yBounce = 52428;
                n6 = 80;
                break;
            }
            case 13: {
                ++GameImpl._shootCounter;
                this.isRocketTailAnimOn = false;
                if (this._blastBunkerBuster > 30) {
                    this._velY = 131072;
                    this._blastBunkerBuster = 0;
                    this.EndShooting(true);
                    this.CreateExplodeAnim(n, n2, 30, 13);
                    Level.GenerateWhole(n, n2, 30);
                    GameImpl.StopSounds();
                    GameImpl.PlaySound(1);
                } else {
                    ++this._blastBunkerBuster;
                    Level.GenerateWhole(n, n2, 10);
                    GameImpl.Vibrate(80);
                }
                Level.InflictCollateralDamage(n3, n5, n << 16, n2 << 16);
                return;
            }
            case 9: {
                this.EndShooting(true);
                if (GameImpl._pCrtWorm._bdata[15] != 23) {
                    this.CreateExplodeAnim(n, n2, n4, 9);
                    bl = true;
                    n6 = 80;
                }
                GameImpl._sheepEntity = null;
                Level.PauseTimer();
                Level.StartCameraShake(n3);
                break;
            }
            case 24: {
                this._flags |= 0x40;
                this.EndShooting(true);
                this.CreateExplodeAnim(n, n2, n4, 24);
                bl = true;
                n6 = 128;
                break;
            }
            case 29: {
                this.CreateExplodeAnim(n, n2, n4, 29);
                bl = true;
                break;
            }
            case 14: {
                Level.InflictCollateralDamage(n3, n5, n << 16, n2 << 16);
                return;
            }
            case 11: {
                this.CreateExplodeAnim(n, n2, n4, 11);
                Level.GenerateWhole(n, n2, n4);
                this.CreateFireAnim(n, n2, n4);
                bl = true;
                n6 = 80;
                for (int i = -15; i < 15; i += 10) {
                    int n7 = 0;
                    Entity entity = Level.SpawnEntity(27);
                    if (entity == null) continue;
                    entity.Init(27, n + i << 16, n2 + n7 << 16, null, null);
                }
                Level.StartCameraShake(n3);
                break;
            }
            case 1: {
                this.CreateExplodeAnim(n, n2, n4, 1);
                bl = true;
                Level.StartCameraShake(n3);
                n6 = 80;
                break;
            }
            case 7: {
                Level.DisableEntity(this._id);
                this.CreateExplodeAnim(n, n2, n4, 7);
                bl = true;
                n6 = 32;
                break;
            }
            case 6: {
                this.CreateExplodeAnim(n, n2, n4, 6);
                bl = true;
                this.SpawnMiniProjectiles((byte)7, n, n2, 131072, 196608, 5);
                Level.StartCameraShake(n3);
                n6 = 128;
                break;
            }
            case 17: 
            case 18: {
                this.CreateExplodeAnim(n, n2, n4, 17);
                bl = true;
                if (n3 == 17) {
                    this.SpawnMiniProjectiles((byte)18, n, n2, 262144, 393216, 5);
                    Level.StartCameraShake(n3);
                    n6 = 128;
                    break;
                }
                n6 = 32;
                Level.DisableEntity(this._id);
                break;
            }
            case 15: {
                bl = true;
                this.ClearAllParticles();
                this.CreateExplodeAnim(n, n2, n4, 15);
                n6 = 80;
                Level.StartCameraShake(n3);
                break;
            }
            case 10: {
                GameImpl._nShootEndFrames = 0;
                if (GameImpl._shootCounter < GameImpl._pCrtWorm.GetCurrentWeaponNoRounds() - 1) {
                    Level.PauseTimer();
                }
                this.CreateExplodeAnim(n, n2, n4, 10);
                Level.StartCameraShake(n3);
                break;
            }
            case 25: {
                this.CreateExplodeAnim(n, n2, n4, 25);
                Level.StartCameraShake(n3);
                break;
            }
            case 28: {
                this.CreateExplodeAnim(n, n2, n4, 28);
                bl = true;
                break;
            }
            case 34: {
                ++this._timerFire;
                if (this._timerFire >= 250) {
                    Level.GenerateWhole(n, n2, 5);
                    this._timerFire = 0;
                    ++this.LifeTimeSpent;
                }
                if (this.CheckMineCollisionsWithWorms()) {
                    this._timerFire += 5;
                }
                if (this.LifeTimeSpent >= 50) {
                    Level.DisableEntity(this._id);
                }
                Level.InflictCollateralDamage(23, 10, n << 16, n2 << 16);
                return;
            }
            case 3: {
                this.CreateExplodeAnim(n, n2, n4, 3);
                bl = true;
                n6 = 80;
                break;
            }
            case 33: {
                this.CreateExplodeAnim(n, n2, n4, 33);
                bl = true;
                n6 = 80;
                break;
            }
            case 20: 
            case 23: {
                n6 = 128;
                this.CreateExplodeAnim(n, n2, n4, 20);
                bl = true;
            }
        }
        Level.GenerateWhole(n, n2, n4);
        if (bl) {
            GameImpl.StopSounds();
            GameImpl.PlaySound(1);
        }
        if (n6 != -1) {
            GameImpl.Vibrate(n6);
        }
        if (n3 != 27) {
            if (n3 == 2 || n3 == 16) {
                n += this._bdata[5] * GameArray._kProjectilesInfo[n3][3] / 2;
            }
            Level.InflictCollateralDamage(n3, n5, n << 16, n2 << 16);
        }
    }

    void ExplodeGuns(int n, int n2, int n3) {
        int n4 = 0;
        if (n == 12) {
            n4 = 10;
        } else if (n == 30) {
            n4 = 23;
        }
        this.Explode(n2, n3, n4);
    }

    void ResetSpeed() {
        this._velX = 0;
        this._velY = 0;
    }

    void CreateRocketTailAnim() {
    }

    void CreateKamikazeTailAnim(int n) {
    }

    void CreateBunkerBusterDrillAnim(int n, int n2) {
    }

    void CreateExplodeAnim(int n, int n2, int n3, int n4) {
        Entity entity = null;
        switch (n4) {
            case 10: 
            case 20: 
            case 23: 
            case 25: {
                entity = Level.SpawnEntity(5);
                entity.Init(5, n << 16, n2 << 16, null, null);
                entity.SetSprite(3);
                entity.SetCrtAnim(5);
                entity._z_order = 6;
                break;
            }
            default: {
                entity = Level.SpawnEntity(5);
                entity.Init(5, n << 16, n2 << 16, null, null);
                entity.SetSprite(3);
                entity.SetCrtAnim(0);
                entity._z_order = 6;
            }
        }
    }

    void CreateFireAnim(int n, int n2, int n3) {
        Entity entity = Level.SpawnEntity(5);
        entity.Init(5, n << 16, n2 << 16, null, null);
        entity.SetSprite(3);
        entity.SetCrtAnim(12);
    }

    void CreateRailgunHoles() {
        int n = GameImpl.Atan2(this._velX >> 16, this._velY >> 16);
        if (n < 0) {
            n = 360 - Math.abs(n);
        }
        int n2 = GameImpl.Distance(this._velX >> 16, this._velY >> 16);
        int n3 = n2 / 3;
        int n4 = this._pos_x;
        int n5 = this._pos_y;
        int n6 = 3 * GameImpl.Sin(n);
        int n7 = 3 * GameImpl.Cos(n);
        for (int i = 0; i < n3; ++i) {
            if (Level.GetLandscapeCollision(n4 >> 16, n5 >> 16) != 0) {
                Level.GenerateWhole(n4 >> 16, n5 >> 16, GameArray._kProjectilesInfo[14][2]);
            }
            n4 += n6;
            n5 += n7;
        }
    }

    int GetCollisionFlag(Entity entity) {
        switch (entity._type) {
            case 7: {
                return 1;
            }
            case 2: {
                return 4;
            }
            case 11: 
            case 20: 
            case 23: 
            case 24: 
            case 26: {
                return 8;
            }
            case 15: {
                return 16;
            }
            case 12: {
                return 32;
            }
            case 1: {
                if (entity._nState != 15) {
                    return 2;
                }
                return 512;
            }
            case 13: 
            case 27: {
                return 64;
            }
            case 9: {
                return 128;
            }
            case 14: {
                return 256;
            }
        }
        return 0;
    }

    void SpawnMiniProjectiles(byte by, int n, int n2, int n3, int n4, int n5) {
        for (int i = 0; i < n5; ++i) {
            int n6 = i < n5 / 2 ? -1 : 1;
            int n7 = n6 * GameImpl.random(131072, 262144);
            int n8 = -GameImpl.random(196608, 393216);
            Entity entity = Level.SpawnEntity(2);
            entity._projectileType = by;
            entity.Init(2, n << 16, n2 << 16, null, null);
            entity._velX = n7;
            entity._velY = n8;
        }
    }

    void Mine_Init() {
        this._flags |= 0x20;
        this._sprite = 12;
        this._crt_anim = -1;
        this._crt_aframe = 3;
        this._flags &= 0xFFFFFFBF;
        this._bdata = new byte[1];
        this._bdata[0] = 0;
        this._nState = 0;
    }

    void Mine_SetState(byte by) {
        if (this._nState == by) {
            return;
        }
        this._nState = by;
    }

    void Mine_Update() {
        switch (this._nState) {
            case 0: {
                if (!this.CheckMineCollisionsWithWorms()) break;
                this.Mine_SetState((byte)1);
                break;
            }
            case 2: {
                long l = 0L;
                if (GameImpl.canvas.getAppTime() - (this._timer + l) < 2000L) break;
                this.Explode(this._pos_x >> 16, this._pos_y >> 16, 3);
                Level.DisableEntity(this._id);
                break;
            }
            case 1: {
                int n = 0;
                if (this._bdata[0] == 1) {
                    n = 2000;
                }
                this._timer = GameImpl.canvas.getAppTime() + (long)n;
                this.SetCrtAnim(1);
                this.Mine_SetState((byte)2);
                break;
            }
            case 3: {
                if (GameImpl.canvas.getAppTime() - this._timer < 2000L) break;
                this.Mine_SetState((byte)0);
            }
        }
        if (this._pos_x < 0 || this._pos_x >> 16 > Level._nLandMaxWidth || this._pos_y >> 16 > Level._sea_level) {
            Level.DisableEntity(this._id);
        }
    }

    boolean CheckDragonBallCollisionsWithWorms() {
        for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
            if (Level._entities_usage[i] != 1 || Level._entities[i]._type != 1 || Level._entities[i].Worm_IsDyingOrDead() || Level._entities[i]._id == GameImpl._pCrtWorm._id) continue;
            Entity entity = Level._entities[i];
            int n = (this._pos_x >> 16) + this._bbox[0];
            int n2 = (this._pos_y >> 16) + this._bbox[1];
            int n3 = this._bbox[2] - this._bbox[0];
            int n4 = this._bbox[3] - this._bbox[1];
            int n5 = (entity._pos_x >> 16) + entity._bbox[0];
            int n6 = (entity._pos_y >> 16) + entity._bbox[1];
            int n7 = entity._bbox[2] - entity._bbox[0];
            int n8 = entity._bbox[3] - entity._bbox[1];
            if (!GameImpl.IntersectsRectRect(n - 15, n2 - 15, n3 + 30, n4 + 30, n5, n6, n7, n8)) continue;
            return true;
        }
        return false;
    }

    boolean CheckMineCollisionsWithWorms() {
        for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
            if (Level._entities_usage[i] != 1 || Level._entities[i]._type != 1 || Level._entities[i].Worm_IsDyingOrDead()) continue;
            Entity entity = Level._entities[i];
            int n = (this._pos_x >> 16) + this._bbox[0];
            int n2 = (this._pos_y >> 16) + this._bbox[1];
            int n3 = this._bbox[2] - this._bbox[0];
            int n4 = this._bbox[3] - this._bbox[1];
            int n5 = (entity._pos_x >> 16) + entity._bbox[0];
            int n6 = (entity._pos_y >> 16) + entity._bbox[1];
            int n7 = entity._bbox[2] - entity._bbox[0];
            int n8 = entity._bbox[3] - entity._bbox[1];
            if (!GameImpl.IntersectsRectRect(n - 15, n2 - 15, n3 + 30, n4 + 30, n5, n6, n7, n8)) continue;
            return true;
        }
        return false;
    }

    void LoadIsland(SDKInputStream sDKInputStream) throws IOException {
        int n = GameImpl._islandsNo++;
        this._bdata[17] = (byte)n;
        GameImpl._campaignData[n][0] = (byte)(sDKInputStream.read() & 0xFF);
        GameImpl._campaignData[n][1] = (byte)(sDKInputStream.read() & 0xFF);
        GameImpl._campaignData[n][2] = (byte)(sDKInputStream.read() & 0xFF);
        GameImpl._campaignData[n][3] = (byte)(sDKInputStream.read() & 0xFF);
        GameImpl._campaignData[n][4] = (byte)sDKInputStream.read();
        GameImpl._campaignData[n][5] = (byte)(sDKInputStream.read() & 0xFF);
        GameImpl._campaignData[n][6] = (byte)sDKInputStream.read();
        GameImpl._campaignData[n][7] = (byte)sDKInputStream.read();
        GameImpl._campaignData[n][8] = (byte)sDKInputStream.read();
        GameImpl._campaignData[n][9] = (byte)sDKInputStream.read();
        GameImpl._campaignData[n][10] = (byte)(sDKInputStream.read() & 0xFF);
        GameImpl._campaignData[n][11] = GameImpl._campaignData[n][10];
        GameImpl._campaignData[n][12] = (byte)(sDKInputStream.read() & 0xFF);
        GameImpl._campaignData[n][13] = (byte)(sDKInputStream.read() & 0xFF);
        GameImpl._campaignData[n][14] = (byte)(sDKInputStream.read() & 0xFF);
        GameImpl._campaignData[n][15] = (byte)sDKInputStream.read();
        GameImpl._campaignData[n][16] = (byte)sDKInputStream.read();
    }

    void LoadCampaignWorm(SDKInputStream sDKInputStream) throws IOException {
    }

    void LoadCampaignDot(SDKInputStream sDKInputStream) throws IOException {
    }

    void LoadCampaignWave(SDKInputStream sDKInputStream) throws IOException {
    }

    void GenerateParticle(byte by) {
        Entity entity = Level.SpawnEntity(18);
        if (entity == null) {
            return;
        }
        entity.SetSprite(5);
        Entity entity2 = Level._entities[this._sdata[0]];
        entity._pos_x = entity2._pos_x;
        entity._pos_y = entity2._pos_y;
        entity._flags |= 0x40;
        switch (by) {
            case 0: {
                entity.SetCrtAnim(14);
                entity._velX = GameImpl.random(65536);
                long l = 0x100000000L - (long)entity._velX * (long)entity._velX;
                entity._velY = (int)GameImpl.Sqrt(l);
                entity._velX *= GameImpl.random(2) * 2 - 1;
                entity._velY *= GameImpl.random(2) * 2 - 1;
                entity._z_order = 0;
                break;
            }
            case 1: {
                entity.SetCrtAnim(15);
                entity._pos_y -= GameImpl.random(0x140000);
                entity._pos_x += GameImpl.random(0x140000) * (GameImpl.random(2) * 2 - 1);
                entity._velX = 0;
                entity._velY = -65536;
                break;
            }
            case 2: {
                entity._type = 30;
                entity.SetSprite(3);
                entity.SetCrtAnim(8);
                entity._velX = GameImpl.random(65536);
                long l = 0x100000000L - (long)entity._velX * (long)entity._velX;
                entity._velY = (int)GameImpl.Sqrt(l);
                entity._velX *= GameImpl.random(4) * 2 - 1;
                entity._velY *= GameImpl.random(4) * 2 - 1;
                entity._z_order = 5;
            }
        }
    }

    void UpdateParticleGenerator() {
        ++this._timer;
        if (this._timer % (long)this._bdata[2] != 0L) {
            return;
        }
        Entity entity = Level._entities[this._sdata[0]];
        if ((this._bdata[1] > 0 || this._bdata[3] == 1) && (entity._flags & 0x18) == 0) {
            this._bdata[1] = (byte)(this._bdata[1] - 1);
            this.GenerateParticle(this._bdata[0]);
            if (GameImpl._pCrtWorm._bdata[15] == 23) {
                ++this.countParticles;
            }
        }
        if (this._bdata[3] == 0 && this._bdata[1] == 0) {
            Level.DisableEntity(this._id);
        }
    }

    void UpdateParticle() {
        if (this.IsCrtAnimEnded()) {
            Level.DisableEntity(this._id);
        }
        this._pos_x += this._velX;
        this._pos_y += this._velY;
        if (this._crt_anim == 15) {
            this._velY -= 65536;
        }
    }

    void updatGasparticles() {
        int n = (this._pos_x >> 16) + this._bbox[0];
        int n2 = (this._pos_y >> 16) + this._bbox[1];
        int n3 = this._bbox[2] - this._bbox[0];
        int n4 = this._bbox[3] - this._bbox[1];
        Entity entity = null;
        for (int i = Level._nFirstWormIndex; i < Level._nFirstWormIndex + Level._nWormsEntities; ++i) {
            if (Level._entities_usage[i] != 1 || (entity = Level._entities[i]) == null || entity._type != 1 || entity.Worm_IsDyingOrDead() || entity._id == GameImpl._pCrtWorm._id || entity == this || entity._bEffectedByGas || !GameImpl.IntersectsRectRect(n, n2, n3, n4, (entity._pos_x >> 16) + entity._bbox[0], (entity._pos_y >> 16) + entity._bbox[1], entity._bbox[2] - entity._bbox[0], entity._bbox[3] - entity._bbox[1])) continue;
            entity._bHitByAxe = true;
            entity._bEffectedByGas = true;
            entity._idata[9] = 5;
            entity.Worm_SetCrtAnim(82);
            GameImpl._pendingWorm = entity._id;
        }
        if (this._pos_x < 0 || this._pos_x >> 16 > Level._nLandMaxWidth || this._pos_y >> 16 > Level._nLandMaxHeight || this._pos_y >> 16 < 0) {
            Level.DisableEntity(this._id);
        }
    }

    void ClearAllParticles() {
        for (int i = 0; i < 250; ++i) {
            if (Level._entities[i]._type != 18) continue;
            Level.DisableEntity(Level._entities[i]._id);
        }
    }

    static {
        _bulletX = 0;
        _bulletY = 0;
        _airstrikeDirection = 1;
        _sheepOutOfPlayfield = 0;
        _bOutOfPos = false;
        _wasHealthIncreased = false;
        CAM_PAN_DISTANCE = GameConstants.SCREEN_WIDTH;
        MAX_CAM_PAN = 1344 / CAM_PAN_DISTANCE + 1;
        MAX_NO_ARMAGEDDON_PER_FRAME = 26 / MAX_CAM_PAN;
        _currentArmageddonNumber = 0;
        DummiesCount = 0;
        ArmageddonInUse = false;
        _isANaplamStrike = false;
        _bunkeronehit = false;
        _bDisablePauseMenu = false;
        _changingWind = false;
        preWindSpeed = 0;
        _bTeleportDone = false;
        AI_WAIT_TIMER = 2000;
        AI_WAIT_SHOOT = 2000L;
        isSinking = false;
        deadTarget = -1;
        noMovement = 0;
        jumpCounter = 0;
        stopMovement = false;
        shouldShoot = false;
        useLight = true;
        nextRandomWorm = 0;
        rememberDamageCausedByHumans = new int[4];
        presentFaction = 0;
        presentGuestFaction = 0;
        presentWeaponToUse = 0;
        wormChking = -1;
        target = -1;
        pShotCtr = 0;
        wormPrevPosX = 0;
        wormPrevPosY = 0;
        mineplaced = false;
        StartPosX = -1;
        StartPosY = -1;
        returnWalkVal = 0;
        blowTorchTarget = 0;
        mineTimer = 0L;
        _directionFound = 0;
        _currentWeaponType = 1;
        VENGEFUL_LOW_DIS = 100;
        LOW_DIS = 160;
        HIGH_DIS = 330;
        MAX_JUMP_CTR = 7;
        SHOTGUN_MIN_FIRE_DIS = 40;
        MINIMUM_FIRE_DIS = 13;
        STUCK_HIGH = 18;
        STUCK_LOW = 13;
        MINE_RETREAT_DIS = 50;
        DYNAMITE_RETREAT_DIS = 90;
        IS_WALKABLE = 3;
        visibleRadius = 100;
        LEFT_COUNTER = 0;
        RIGHT_COUNTER = 1;
        ARRAY_OFFSET = 5;
        B_TOTAL_WORMS = 0;
        B_WORM_ID = 1;
        B_HAS_HUMAN = 2;
        B_IS_WALKABLE = 3;
        B_SENSOR_HAS_WORM = 4;
        S_SENSOR_MINE = 0;
        B_COLLISION_DIR = 5;
        I_IS_HUMAN = 0;
        I_POS_X = 1;
        I_POS_Y = 2;
        I_WORM_ID = 3;
        aiWormPath = new int[40];
        startForLeftPath = 0;
        nearWormArray = new int[16];
        wormArrayCnt = 0;
        precision = 16;
        turnCounter = 7;
        meleeCtr = 0;
    }
}

