/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FMat44T_F32;
import ca.jamdat.flight.FQuaternionT_F32;
import ca.jamdat.flight.FVec3T_F32;

public class RigidTransform {
    public FVec3T_F32 translation;
    public FQuaternionT_F32 rotation;
    public byte fixedPointPos;

    public static RigidTransform Cast(Object object, RigidTransform rigidTransform) {
        return (RigidTransform)object;
    }

    public RigidTransform(int n) {
        this.translation = new FVec3T_F32();
        this.rotation = new FQuaternionT_F32();
        this.fixedPointPos = (byte)n;
    }

    public RigidTransform(FVec3T_F32 fVec3T_F32, FQuaternionT_F32 fQuaternionT_F32, int n) {
        this.translation = new FVec3T_F32(fVec3T_F32);
        this.rotation = new FQuaternionT_F32(fQuaternionT_F32);
        this.fixedPointPos = (byte)n;
    }

    public void Init(FVec3T_F32 fVec3T_F32, FQuaternionT_F32 fQuaternionT_F32, int n) {
        this.translation.Assign(fVec3T_F32);
        this.rotation.Assign(fQuaternionT_F32);
        this.fixedPointPos = (byte)n;
    }

    public FVec3T_F32 Transform(FVec3T_F32 fVec3T_F32) {
        return this.rotation.Conjugate(fVec3T_F32.x, fVec3T_F32.y, fVec3T_F32.z, this.fixedPointPos).Add(this.translation);
    }

    public void Transform(FVec3T_F32 fVec3T_F32, FVec3T_F32 fVec3T_F322) {
        fVec3T_F32.Assign(this.rotation.Conjugate(fVec3T_F322.x, fVec3T_F322.y, fVec3T_F322.z, this.fixedPointPos).Add(this.translation));
    }

    public RigidTransform Compose(RigidTransform rigidTransform) {
        return new RigidTransform(this.translation.Add(this.rotation.Conjugate(rigidTransform.translation.x, rigidTransform.translation.y, rigidTransform.translation.z, this.fixedPointPos)), this.rotation.Mul(rigidTransform.rotation), this.fixedPointPos);
    }

    public RigidTransform Inverse() {
        FQuaternionT_F32 fQuaternionT_F32 = new FQuaternionT_F32(this.rotation.GetInverseForNormalized());
        return new RigidTransform(fQuaternionT_F32.Conjugate(this.translation.Neg().x, this.translation.Neg().y, this.translation.Neg().z, this.fixedPointPos), fQuaternionT_F32, this.fixedPointPos);
    }

    public void Inverse(RigidTransform rigidTransform, FQuaternionT_F32 fQuaternionT_F32) {
        this.rotation.GetInverseForNormalized(fQuaternionT_F32);
        rigidTransform.Init(fQuaternionT_F32.Conjugate(this.translation.Neg().x, this.translation.Neg().y, this.translation.Neg().z, this.fixedPointPos), fQuaternionT_F32, this.fixedPointPos);
    }

    public FMat44T_F32 InverseMatrix() {
        return this.Inverse().Matrix();
    }

    public void InverseMatrix(FMat44T_F32 fMat44T_F32, FMat44T_F32 fMat44T_F322, FMat44T_F32 fMat44T_F323, FQuaternionT_F32 fQuaternionT_F32, RigidTransform rigidTransform) {
        this.Inverse(rigidTransform, fQuaternionT_F32);
        rigidTransform.Matrix(fMat44T_F32, fMat44T_F322, fMat44T_F323);
    }

    public FMat44T_F32 Matrix() {
        FMat44T_F32 fMat44T_F32 = new FMat44T_F32(this.fixedPointPos);
        fMat44T_F32.SetTranslation(this.translation, this.fixedPointPos);
        return fMat44T_F32.Mul(this.rotation.ToMatrix(this.fixedPointPos), this.fixedPointPos);
    }

    public void Matrix(FMat44T_F32 fMat44T_F32, FMat44T_F32 fMat44T_F322, FMat44T_F32 fMat44T_F323) {
        fMat44T_F322.SetTranslation(this.translation, this.fixedPointPos);
        this.rotation.ToMatrix(fMat44T_F323, this.fixedPointPos);
        fMat44T_F322.Mul(fMat44T_F32, fMat44T_F323, this.fixedPointPos);
    }

    public boolean Equals(RigidTransform rigidTransform) {
        return this.translation.Equals(rigidTransform.translation) && this.rotation.Equals(rigidTransform.rotation);
    }

    public RigidTransform Assign(RigidTransform rigidTransform) {
        this.translation.Assign(rigidTransform.translation);
        this.rotation.Assign(rigidTransform.rotation);
        return this;
    }

    public static RigidTransform I(int n) {
        return new RigidTransform(FVec3T_F32.Zero(n), FQuaternionT_F32.I(), n);
    }

    public RigidTransform() {
        this(16);
    }

    public static RigidTransform[] InstArrayRigidTransform(int n) {
        RigidTransform[] rigidTransformArray = new RigidTransform[n];
        for (int i = 0; i < n; ++i) {
            rigidTransformArray[i] = new RigidTransform();
        }
        return rigidTransformArray;
    }

    public static RigidTransform[][] InstArrayRigidTransform(int n, int n2) {
        RigidTransform[][] rigidTransformArray = new RigidTransform[n][];
        for (int i = 0; i < n; ++i) {
            rigidTransformArray[i] = new RigidTransform[n2];
            for (int j = 0; j < n2; ++j) {
                rigidTransformArray[i][j] = new RigidTransform();
            }
        }
        return rigidTransformArray;
    }

    public static RigidTransform[][][] InstArrayRigidTransform(int n, int n2, int n3) {
        RigidTransform[][][] rigidTransformArray = new RigidTransform[n][][];
        for (int i = 0; i < n; ++i) {
            rigidTransformArray[i] = new RigidTransform[n2][];
            for (int j = 0; j < n2; ++j) {
                rigidTransformArray[i][j] = new RigidTransform[n3];
                for (int k = 0; k < n3; ++k) {
                    rigidTransformArray[i][j][k] = new RigidTransform();
                }
            }
        }
        return rigidTransformArray;
    }
}

