/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Blob;
import ca.jamdat.flight.SoundManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class MMAPISoundImp {
    public static final byte setMediaTimeDefective = 0;
    public static final byte deallocateDefective = 1;
    public Blob mDataBlob;
    Player mPlayer;
    public String mSoundFormat = new String();

    public MMAPISoundImp() {
        this.mDataBlob = new Blob();
    }

    public void destruct() {
        this.mDataBlob = null;
    }

    public void SetSoundFormat(String string) {
        this.mSoundFormat = string;
    }

    public String GetSoundFormat() {
        return this.mSoundFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Prefetch() {
        if (this.mPlayer == null && !this.CreatePlayer()) {
            return;
        }
        SoundManager soundManager = SoundManager.Get();
        boolean bl = true;
        int n = -1;
        boolean bl2 = false;
        while (!bl2) {
            try {
                SoundManager soundManager2 = soundManager;
                synchronized (soundManager2) {
                    if (this.mPlayer.getState() == 300 || (n = soundManager.mImplementor.DeallocateOldestPrefetchedSound(bl, this.mSoundFormat)) == -1) {
                        bl2 = true;
                    } else {
                        this.mPlayer.prefetch();
                        soundManager.mImplementor.RegisterAsPrefetchedSound(this, n);
                    }
                }
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Deallocate() {
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                SoundManager.Get().mImplementor.UnRegisterAsPrefetchedSound(this);
                this.mPlayer.deallocate();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Close() {
        if (this.mPlayer == null) {
            return;
        }
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            SoundManager.Get().mImplementor.UnRegisterAsPrefetchedSound(this);
            try {
                this.mPlayer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mPlayer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int GetPlayerState() {
        int n = 0;
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            if (this.mPlayer != null) {
                n = this.mPlayer.getState();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ResetSoundPlayer() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            this.Close();
            this.CreatePlayer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean CreatePlayer() {
        try {
            SoundManager soundManager = SoundManager.Get();
            synchronized (soundManager) {
                this.mPlayer = Manager.createPlayer((InputStream)new ByteArrayInputStream(this.mDataBlob.GetData()), (String)this.mSoundFormat);
                this.mPlayer.realize();
            }
        }
        catch (Throwable throwable) {
            if (this.mPlayer != null) {
                this.mPlayer.close();
            }
            this.mPlayer = null;
        }
        return this.mPlayer != null;
    }

    public void SetDataBlob(Blob blob) {
        this.mDataBlob = blob;
    }

    public Blob GetDataBlob() {
        return this.mDataBlob;
    }

    public boolean EvaluateSoundFormatSpec(byte by) {
        if (by == 1) {
            if (this.GetSoundFormat().equals("audio/x-wav")) {
                // empty if block
            }
            if (this.GetSoundFormat().equals("audio/midi")) {
                // empty if block
            }
            if (this.GetSoundFormat().equals("audio/amr")) {
                // empty if block
            }
            return true;
        }
        if (by == 0) {
            if (this.GetSoundFormat().equals("audio/x-wav")) {
                // empty if block
            }
            if (this.GetSoundFormat().equals("audio/midi")) {
                // empty if block
            }
            if (this.GetSoundFormat().equals("audio/amr")) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public Player GetPlayer() {
        return this.mPlayer;
    }

    public static MMAPISoundImp[] InstArrayMMAPISoundImp(int n) {
        MMAPISoundImp[] mMAPISoundImpArray = new MMAPISoundImp[n];
        for (int i = 0; i < n; ++i) {
            mMAPISoundImpArray[i] = new MMAPISoundImp();
        }
        return mMAPISoundImpArray;
    }

    public static MMAPISoundImp[][] InstArrayMMAPISoundImp(int n, int n2) {
        MMAPISoundImp[][] mMAPISoundImpArray = new MMAPISoundImp[n][];
        for (int i = 0; i < n; ++i) {
            mMAPISoundImpArray[i] = new MMAPISoundImp[n2];
            for (int j = 0; j < n2; ++j) {
                mMAPISoundImpArray[i][j] = new MMAPISoundImp();
            }
        }
        return mMAPISoundImpArray;
    }

    public static MMAPISoundImp[][][] InstArrayMMAPISoundImp(int n, int n2, int n3) {
        MMAPISoundImp[][][] mMAPISoundImpArray = new MMAPISoundImp[n][][];
        for (int i = 0; i < n; ++i) {
            mMAPISoundImpArray[i] = new MMAPISoundImp[n2][];
            for (int j = 0; j < n2; ++j) {
                mMAPISoundImpArray[i][j] = new MMAPISoundImp[n3];
                for (int k = 0; k < n3; ++k) {
                    mMAPISoundImpArray[i][j][k] = new MMAPISoundImp();
                }
            }
        }
        return mMAPISoundImpArray;
    }
}

