/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Color888;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Memory;
import ca.jamdat.flight.Palette;
import ca.jamdat.flight.StringUtils;
import javax.microedition.lcdui.Image;

public class FlBitmapImplementor
extends FlBitmap {
    public static final byte typeNumber = 0;
    public static final byte typeID = 0;
    public static final boolean supportsDynamicSerialization = true;
    public Image mImage;
    static final String PNG_HEADER = "\u8950\u4e47\u0d0a\u1a0a\u0000\r\u4948\u4452";
    static final int PNG_HEADER_SIZE = 16;
    static final int PNG_HEADER_DATA = 17;
    static final String PNG_PLTE = "\u504c\u5445";
    static final int PNG_PLTE_SIZE = 4;
    static final String PNG_TRNS = "\u7452\u4e53";
    static final int PNG_TRNS_SIZE = 4;
    static final int PNG_IDATSIZE_SIZE = 4;
    static final String PNG_IDAT = "\u4944\u4154";
    static final int PNG_IDAT_SIZE = 4;
    static final String PNG_IEND = "\u0000\u4945\u4e44\uae42\u6082";
    static final int PNG_IEND_SIZE = 10;
    static final int PNG_EMBEDDED_DATA_SIZE = 30;
    static final int PNG_BYTECOUNT_OVERHEAD = 4;
    static final int PNG_CRC_OVERHEAD = 4;
    static final int PNG_CHUNK_OVERHEAD = 12;
    static final int PNG_HEADER_SIZE_IN_PACKAGE = 21;
    static final int PNG_PALETTE_SIZE_PER_COLOR = 3;
    static final int PNG_PALETTE_FOOTER_SIZE = 4;
    static final int PNG_PALETTE_POSITION_IN_PNG = 33;

    public static FlBitmapImplementor Cast(Object object, FlBitmapImplementor flBitmapImplementor) {
        return (FlBitmapImplementor)object;
    }

    public byte GetTypeID() {
        return 0;
    }

    public static Class AsClass() {
        return null;
    }

    public FlBitmapImplementor() {
    }

    public FlBitmapImplementor(FlString flString) {
        String string = new String(StringUtils.CreateJavaString(flString));
        if (string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            this.mImage = Image.createImage((String)string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mImage != null) {
            this.mDataWidth = (short)this.mImage.getWidth();
            this.mDataHeight = (short)this.mImage.getHeight();
        }
    }

    public void destruct() {
    }

    public void SetSize(short s, short s2) {
    }

    public int GetPixelFormat() {
        int n = 51456;
        return n;
    }

    public void Clone(FlBitmap flBitmap) {
        short s = flBitmap.GetWidth();
        short s2 = flBitmap.GetHeight();
        this.mImage = Image.createImage((Image)flBitmap.getImage());
        this.CloneAttributes(flBitmap);
    }

    public void Duplicate(FlBitmap flBitmap) {
    }

    public Palette GetPalette() {
        return null;
    }

    public void SetPalette(Palette palette) {
    }

    public void GetRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.mImage.getRGB(nArray, n2, n3, n4, n5, n6, n7);
    }

    public void CreateEmptyImage(short s, short s2) {
        this.mImage = Image.createImage((int)s, (int)s2);
        this.mDataWidth = s;
        this.mDataHeight = s2;
    }

    public void CreateImageFromPNGData(byte[] byArray, int n, int n2) {
        this.mImage = Image.createImage((byte[])byArray, (int)n, (int)n2);
        this.mDataWidth = (short)this.mImage.getWidth();
        this.mDataHeight = (short)this.mImage.getHeight();
    }

    public void CreateImageFromDepalettizedRawData(int[] nArray, int n, short s, short s2, Color888 color888, boolean bl) {
        this.mImage = Image.createRGBImage((int[])nArray, (int)s, (int)s2, (boolean)bl);
        this.mDataWidth = s;
        this.mDataHeight = s2;
    }

    public void CreateAlphaImageFromRawData(int[] nArray, short s, short s2, int n, Color888 color888) {
        int n2 = s * s2;
        int[] nArray2 = new int[n2];
        for (int i = 0; i < n2; ++i) {
            if (nArray[i] == 0) continue;
            nArray2[i] = ((nArray[i] & 0xFF000000) >>> 24) * (n & 0xFF) / 255 << 24 | nArray[i] & 0xFFFFFF;
        }
        this.CreateImageFromDepalettizedRawData(nArray2, 51456, s, s2, color888, true);
    }

    public void CreateImageFromRawData(byte[] byArray, byte[] byArray2, short s, short s2) {
        this.CreateImageFromRawData(byArray, byArray2, s, s2, -1);
    }

    public void CreateImageFromRawData(byte[] byArray, byte[] byArray2, short s, short s2, int n) {
        boolean bl = n != -1;
        int n2 = s * s2;
        int[] nArray = new int[n2];
        int n3 = n2;
        while (--n3 >= 0) {
            int n4 = byArray[n3] & 0xFF;
            if (n4 == n) {
                nArray[n3] = 0;
                continue;
            }
            nArray[n3] = 0xFF000000 | ((byArray2[n4 *= 3] & 0xFF) << 16 | (byArray2[n4 + 1] & 0xFF) << 8 | byArray2[n4 + 2] & 0xFF);
        }
        this.CreateImageFromDepalettizedRawData(nArray, 51456, s, s2, null, bl);
    }

    public void CreateImageFromRawData(byte[] byArray, byte[] byArray2, short s, short s2, Color888 color888) {
        int n = -1;
        int n2 = byArray2.length / 3;
        for (int i = 0; i < n2; ++i) {
            if ((byArray2[i * 3] & 0xFF) != color888.GetRed() || (byArray2[i * 3 + 1] & 0xFF) != color888.GetGreen() || (byArray2[i * 3 + 2] & 0xFF) != color888.GetBlue()) continue;
            n = i;
            break;
        }
        this.CreateImageFromRawData(byArray, byArray2, s, s2, n);
    }

    public byte[] CreatePNGBuffer(byte[] byArray, byte[] byArray2, short s, short n, int n2) {
        int n3;
        int n4;
        byte[] byArray3 = null;
        int n5 = (251 + (s * n + n)) / 252;
        int n6 = 75 + byArray2.length + s * n + n + 5 * n5;
        int n7 = byArray2.length / 3;
        if (n2 != -1) {
            n6 += 12 + n7;
        }
        byArray3 = new byte[n6];
        int n8 = 0;
        n8 = StringUtils.StringToBytes(PNG_HEADER, byArray3, 0);
        byArray3[11] = 13;
        int n9 = 12;
        n8 = Memory.WriteIntToByteArray(s, byArray3, n8);
        n8 = Memory.WriteIntToByteArray(n, byArray3, n8);
        byArray3[n8++] = 8;
        byArray3[n8++] = 3;
        int n10 = (int)Memory.CalculateCRC(byArray3, n9, (n8 += 3) - n9);
        n8 = Memory.WriteIntToByteArray(n10, byArray3, n8);
        n9 = n8 = Memory.WriteIntToByteArray(byArray2.length, byArray3, n8);
        n8 = StringUtils.StringToBytes(PNG_PLTE, byArray3, n8);
        System.arraycopy(byArray2, 0, byArray3, n8, byArray2.length);
        n10 = (int)Memory.CalculateCRC(byArray3, n9, (n8 += byArray2.length) - n9);
        n8 = Memory.WriteIntToByteArray(n10, byArray3, n8);
        if (n2 != -1) {
            n9 = n8 = Memory.WriteIntToByteArray(n7, byArray3, n8);
            n8 = StringUtils.StringToBytes(PNG_TRNS, byArray3, n8);
            for (n4 = 0; n4 < n7; ++n4) {
                byArray3[n8 + n4] = -1;
            }
            byArray3[n8 + n2] = 0;
            n10 = (int)Memory.CalculateCRC(byArray3, n9, (n8 += n7) - n9);
            n8 = Memory.WriteIntToByteArray(n10, byArray3, n8);
        }
        n4 = s * n + 2 + 4 + n + 5 * n5;
        n9 = n8 = Memory.WriteIntToByteArray(n4, byArray3, n8);
        n8 = StringUtils.StringToBytes(PNG_IDAT, byArray3, n8);
        byArray3[n8++] = 24;
        byArray3[n8++] = 25;
        int n11 = 0;
        byte[] byArray4 = new byte[(s + 1) * n];
        for (n3 = 0; n3 < n; ++n3) {
            byArray4[n11++] = 0;
            System.arraycopy(byArray, n3 * s, byArray4, n11, s);
            n11 += s;
        }
        int n12 = n11;
        int n13 = 252;
        byte by = 0;
        n11 = 0;
        while (n12 - n11 > 0) {
            if (n12 - n11 <= 252) {
                by = 1;
                n13 = n12 - n11;
            }
            byArray3[n8++] = by;
            byArray3[n8++] = (byte)n13;
            byArray3[n8++] = 0;
            byArray3[n8++] = (byte)(255 - n13);
            byArray3[n8++] = -1;
            System.arraycopy(byArray4, n11, byArray3, n8, n13);
            n8 += n13;
            n11 += n13;
        }
        int n14 = 1;
        int n15 = 0;
        for (n3 = 0; n3 < byArray4.length; ++n3) {
            n14 += byArray4[n3] & 0xFF;
            n15 += (n14 %= 65521);
            n15 %= 65521;
        }
        byArray3[n8++] = (byte)((n15 & 0xFF00) >> 8);
        byArray3[n8++] = (byte)(n15 & 0xFF);
        byArray3[n8++] = (byte)((n14 & 0xFF00) >> 8);
        byArray3[n8++] = (byte)(n14 & 0xFF);
        n10 = (int)Memory.CalculateCRC(byArray3, n9, n8 - n9);
        n8 = Memory.WriteIntToByteArray(n10, byArray3, n8);
        n8 += 2;
        n8 = StringUtils.StringToBytes(PNG_IEND, byArray3, n8);
        return byArray3;
    }

    public void CloneAttributes(FlBitmap flBitmap) {
        this.mDataWidth = flBitmap.GetDataWidth();
        this.mDataHeight = flBitmap.GetDataHeight();
    }

    public Image getImage() {
        return this.mImage;
    }

    public void CreateImageForRepalettization(FlBitmap flBitmap, Palette palette) {
        this.CreateImage(flBitmap.mData, palette.GetData());
        this.mData = null;
    }

    public void ReallocateData(short s, short s2) {
        if (this.mDataWidth == s && this.mDataHeight == s2) {
            return;
        }
        this.mData = null;
        this.mDataWidth = s;
        this.mDataHeight = s2;
        this.mData = new byte[s2 * (short)this.GetBytesPerLine()];
    }

    public void CreateImage(byte[] byArray, byte[] byArray2) {
        if (byArray2 != null) {
            int n = byArray2.length - 4;
            byArray[33] = 0;
            byArray[34] = 0;
            byArray[35] = (byte)(n >>> 8);
            byArray[36] = (byte)(n & 0xFF);
            StringUtils.StringToBytes(PNG_PLTE, byArray, 37);
            System.arraycopy(byArray2, 0, byArray, 41, byArray2.length);
        }
        Image image = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
        this.mDataWidth = (short)image.getWidth();
        this.mDataHeight = (short)image.getHeight();
        this.mImage = image;
    }

    public static FlBitmapImplementor[] InstArrayFlBitmapImplementor(int n) {
        FlBitmapImplementor[] flBitmapImplementorArray = new FlBitmapImplementor[n];
        for (int i = 0; i < n; ++i) {
            flBitmapImplementorArray[i] = new FlBitmapImplementor();
        }
        return flBitmapImplementorArray;
    }

    public static FlBitmapImplementor[][] InstArrayFlBitmapImplementor(int n, int n2) {
        FlBitmapImplementor[][] flBitmapImplementorArray = new FlBitmapImplementor[n][];
        for (int i = 0; i < n; ++i) {
            flBitmapImplementorArray[i] = new FlBitmapImplementor[n2];
            for (int j = 0; j < n2; ++j) {
                flBitmapImplementorArray[i][j] = new FlBitmapImplementor();
            }
        }
        return flBitmapImplementorArray;
    }

    public static FlBitmapImplementor[][][] InstArrayFlBitmapImplementor(int n, int n2, int n3) {
        FlBitmapImplementor[][][] flBitmapImplementorArray = new FlBitmapImplementor[n][][];
        for (int i = 0; i < n; ++i) {
            flBitmapImplementorArray[i] = new FlBitmapImplementor[n2][];
            for (int j = 0; j < n2; ++j) {
                flBitmapImplementorArray[i][j] = new FlBitmapImplementor[n3];
                for (int k = 0; k < n3; ++k) {
                    flBitmapImplementorArray[i][j][k] = new FlBitmapImplementor();
                }
            }
        }
        return flBitmapImplementorArray;
    }
}

