/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.F32;
import ca.jamdat.flight.FMat44T_F32;
import ca.jamdat.flight.FVec3T_F32;
import ca.jamdat.flight.ForceInline;

public class FQuaternionT_F32 {
    public static final byte QUATERNION_FP = 28;
    public static FQuaternionT_F32[] mPool = FQuaternionT_F32.InstArrayFQuaternionT_F32(50);
    public static int mPoolIndex = -1;
    public F32 s;
    public F32 v_x;
    public F32 v_y;
    public F32 v_z;

    public FQuaternionT_F32() {
        this.s = new F32();
        this.v_x = new F32();
        this.v_y = new F32();
        this.v_z = new F32();
    }

    public FQuaternionT_F32(F32 f32, FVec3T_F32 fVec3T_F32, int n) {
        this.s = new F32(f32);
        this.v_x = new F32(fVec3T_F32.x);
        this.v_y = new F32(fVec3T_F32.y);
        this.v_z = new F32(fVec3T_F32.z);
        this.DestructiveNormalize(n);
    }

    public FQuaternionT_F32(FQuaternionT_F32 fQuaternionT_F32) {
        this.s = new F32(fQuaternionT_F32.s);
        this.v_x = new F32(fQuaternionT_F32.v_x);
        this.v_y = new F32(fQuaternionT_F32.v_y);
        this.v_z = new F32(fQuaternionT_F32.v_z);
    }

    public FQuaternionT_F32(FVec3T_F32 fVec3T_F32, F32 f32, int n) {
        this.s = new F32();
        this.v_x = new F32();
        this.v_y = new F32();
        this.v_z = new F32();
        this.Init(fVec3T_F32, f32, n);
    }

    public void Init(FVec3T_F32 fVec3T_F32, F32 f32, int n) {
        int n2 = 28 - n;
        F32 f322 = new F32(f32.DivPower2(1));
        F32 f323 = new F32(f322.Sin(n));
        F32 f324 = new F32(f322.Cos(n));
        this.s = f324.IncreasePrecision(n2);
        this.v_x = fVec3T_F32.x;
        this.v_y = fVec3T_F32.y;
        this.v_z = fVec3T_F32.z;
        this.v_x = this.v_x.Mul(f323, n);
        this.v_y = this.v_y.Mul(f323, n);
        this.v_z = this.v_z.Mul(f323, n);
        this.v_x = this.v_x.IncreasePrecision(n2);
        this.v_y = this.v_y.IncreasePrecision(n2);
        this.v_z = this.v_z.IncreasePrecision(n2);
    }

    public FQuaternionT_F32(FVec3T_F32 fVec3T_F32, int n) {
        this.s = new F32();
        this.v_x = new F32();
        this.v_y = new F32();
        this.v_z = new F32();
        F32 f32 = new F32(fVec3T_F32.LengthHP(n));
        if (f32.LessThan(F32.Epsilon(n))) {
            this.s = F32.One(28);
            this.v_x = F32.Zero(28);
            this.v_y = F32.Zero(28);
            this.v_z = F32.Zero(28);
        } else {
            int n2 = 28 - n;
            F32 f322 = new F32(f32.DivPower2(1));
            F32 f323 = new F32(f322.Sin(n));
            F32 f324 = new F32(f322.Cos(n));
            this.s = f324.IncreasePrecision(n2);
            this.v_x = fVec3T_F32.x;
            this.v_y = fVec3T_F32.y;
            this.v_z = fVec3T_F32.z;
            this.v_x = this.v_x.Div(f32, n);
            this.v_y = this.v_y.Div(f32, n);
            this.v_z = this.v_z.Div(f32, n);
            this.v_x = this.v_x.Mul(f323, n);
            this.v_y = this.v_y.Mul(f323, n);
            this.v_z = this.v_z.Mul(f323, n);
            this.v_x = this.v_x.IncreasePrecision(n2);
            this.v_y = this.v_y.IncreasePrecision(n2);
            this.v_z = this.v_z.IncreasePrecision(n2);
        }
    }

    public static FQuaternionT_F32 GetRotationBetweenNormalizedVectors(FVec3T_F32 fVec3T_F32, FVec3T_F32 fVec3T_F322, FQuaternionT_F32 fQuaternionT_F32, int n) {
        FQuaternionT_F32 fQuaternionT_F322 = FQuaternionT_F32.Get();
        if (FQuaternionT_F32.GetRotationBetweenNormalizedVectors(fQuaternionT_F322, fVec3T_F32, fVec3T_F322, n)) {
            return fQuaternionT_F322;
        }
        return fQuaternionT_F32;
    }

    public static FQuaternionT_F32 GetRotationBetweenNormalizedVectors(FVec3T_F32 fVec3T_F32, FVec3T_F32 fVec3T_F322, int n) {
        FQuaternionT_F32 fQuaternionT_F32 = FQuaternionT_F32.Get();
        FQuaternionT_F32.GetRotationBetweenNormalizedVectors(fQuaternionT_F32, fVec3T_F32, fVec3T_F322, n);
        return fQuaternionT_F32;
    }

    public static boolean GetRotationBetweenNormalizedVectors(FQuaternionT_F32 fQuaternionT_F32, FVec3T_F32 fVec3T_F32, FVec3T_F32 fVec3T_F322, int n) {
        int n2 = 28 - n;
        FVec3T_F32 fVec3T_F323 = new FVec3T_F32(fVec3T_F32.IncreasePrecision(n2));
        FVec3T_F32 fVec3T_F324 = new FVec3T_F32(fVec3T_F322.IncreasePrecision(n2));
        fVec3T_F323.DestructiveNormalizeHP(28);
        fVec3T_F324.DestructiveNormalizeHP(28);
        F32 f32 = new F32(fVec3T_F323.Dot(fVec3T_F324, 28));
        F32 f322 = new F32();
        f322 = f32.GreaterThan(F32.One(28)) ? F32.One(28) : (f32.LessThan(F32.One(28).Neg()) ? F32.Zero(28) : F32.Half(28).Mul(F32.One(28).Add(f32), 28).Sqrt(28));
        if (f322.LessThan(F32.Epsilon(28))) {
            fQuaternionT_F32.Init(fVec3T_F32.GetAPerpendicularUnitVector(n), F32.Pi(n), n);
            return false;
        }
        fQuaternionT_F32.s = f322;
        fQuaternionT_F32.v_x = fVec3T_F323.y.Mul(fVec3T_F324.z, 28).Sub(fVec3T_F323.z.Mul(fVec3T_F324.y, 28));
        fQuaternionT_F32.v_y = fVec3T_F323.z.Mul(fVec3T_F324.x, 28).Sub(fVec3T_F323.x.Mul(fVec3T_F324.z, 28));
        fQuaternionT_F32.v_z = fVec3T_F323.x.Mul(fVec3T_F324.y, 28).Sub(fVec3T_F323.y.Mul(fVec3T_F324.x, 28));
        F32 f323 = new F32(f322.MulPower2(1));
        fQuaternionT_F32.v_x = fQuaternionT_F32.v_x.Div(f323, 28);
        fQuaternionT_F32.v_y = fQuaternionT_F32.v_y.Div(f323, 28);
        fQuaternionT_F32.v_z = fQuaternionT_F32.v_z.Div(f323, 28);
        return true;
    }

    public FQuaternionT_F32 Mul(FQuaternionT_F32 fQuaternionT_F32) {
        FQuaternionT_F32 fQuaternionT_F322 = FQuaternionT_F32.Get();
        this.Mul(fQuaternionT_F322, fQuaternionT_F32);
        return fQuaternionT_F322;
    }

    public void Mul(FQuaternionT_F32 fQuaternionT_F32, FQuaternionT_F32 fQuaternionT_F322) {
        F32 f32 = new F32(fQuaternionT_F322.s);
        F32 f322 = new F32(fQuaternionT_F322.v_x);
        F32 f323 = new F32(fQuaternionT_F322.v_y);
        F32 f324 = new F32(fQuaternionT_F322.v_z);
        F32 f325 = new F32(this.v_x.Mul(f322, 28).Add(this.v_y.Mul(f323, 28)).Add(this.v_z.Mul(f324, 28)));
        fQuaternionT_F32.s = this.s.Mul(f32, 28).Sub(f325);
        fQuaternionT_F32.v_x = this.s.Mul(f322, 28).Add(this.v_x.Mul(f32, 28)).Add(this.v_y.Mul(f324, 28)).Sub(this.v_z.Mul(f323, 28));
        fQuaternionT_F32.v_y = this.s.Mul(f323, 28).Add(this.v_y.Mul(f32, 28)).Sub(this.v_x.Mul(f324, 28)).Add(this.v_z.Mul(f322, 28));
        fQuaternionT_F32.v_z = this.s.Mul(f324, 28).Add(this.v_z.Mul(f32, 28)).Add(this.v_x.Mul(f323, 28)).Sub(this.v_y.Mul(f322, 28));
        fQuaternionT_F32.DestructiveNormalize();
    }

    public FQuaternionT_F32 MulAssign(FQuaternionT_F32 fQuaternionT_F32) {
        F32 f32 = new F32(fQuaternionT_F32.s);
        F32 f322 = new F32(fQuaternionT_F32.v_x);
        F32 f323 = new F32(fQuaternionT_F32.v_y);
        F32 f324 = new F32(fQuaternionT_F32.v_z);
        F32 f325 = new F32(this.v_x.Mul(f322, 28).Add(this.v_y.Mul(f323, 28)).Add(this.v_z.Mul(f324, 28)));
        F32 f326 = new F32(this.s.Mul(f32, 28).Sub(f325));
        F32 f327 = new F32(this.s.Mul(f322, 28).Add(this.v_x.Mul(f32, 28)).Add(this.v_y.Mul(f324, 28)).Sub(this.v_z.Mul(f323, 28)));
        F32 f328 = new F32(this.s.Mul(f323, 28).Add(this.v_y.Mul(f32, 28)).Sub(this.v_x.Mul(f324, 28)).Add(this.v_z.Mul(f322, 28)));
        F32 f329 = new F32(this.s.Mul(f324, 28).Add(this.v_z.Mul(f32, 28)).Add(this.v_x.Mul(f323, 28)).Sub(this.v_y.Mul(f322, 28)));
        this.s = f326;
        this.v_x = f327;
        this.v_y = f328;
        this.v_z = f329;
        this.DestructiveNormalize();
        return this;
    }

    public FQuaternionT_F32 Assign(FQuaternionT_F32 fQuaternionT_F32) {
        ForceInline.v();
        this.s = fQuaternionT_F32.s;
        this.v_x = fQuaternionT_F32.v_x;
        this.v_y = fQuaternionT_F32.v_y;
        this.v_z = fQuaternionT_F32.v_z;
        return this;
    }

    public void Assign(F32 f32, F32 f322, F32 f323, F32 f324) {
        ForceInline.v();
        this.s = f32;
        this.v_x = f322;
        this.v_y = f323;
        this.v_z = f324;
    }

    public boolean Equals(FQuaternionT_F32 fQuaternionT_F32) {
        ForceInline.v();
        return this.s.Equals(fQuaternionT_F32.s) && this.v_x.Equals(fQuaternionT_F32.v_x) && this.v_y.Equals(fQuaternionT_F32.v_y) && this.v_z.Equals(fQuaternionT_F32.v_z);
    }

    public F32 GetS() {
        return this.s;
    }

    public F32 GetVx() {
        return this.v_x;
    }

    public F32 GetVy() {
        return this.v_y;
    }

    public F32 GetVz() {
        return this.v_z;
    }

    public FQuaternionT_F32 ConvertRotationFromMaxToFlight() {
        FQuaternionT_F32 fQuaternionT_F32 = new FQuaternionT_F32();
        FQuaternionT_F32 fQuaternionT_F322 = new FQuaternionT_F32(this.GetS(), new FVec3T_F32(this.GetVx(), this.GetVy(), this.GetVz()), 28);
        FQuaternionT_F32 fQuaternionT_F323 = new FQuaternionT_F32(FVec3T_F32.UnitI(16), F32.PiOver2(16).Neg(), 16);
        fQuaternionT_F32.Assign(fQuaternionT_F323.Mul(fQuaternionT_F322).Mul(fQuaternionT_F323.GetInverseForNormalized()));
        return fQuaternionT_F32;
    }

    public FVec3T_F32 Conjugate(FVec3T_F32 fVec3T_F32, int n) {
        ForceInline.v();
        return this.Conjugate(fVec3T_F32.x, fVec3T_F32.y, fVec3T_F32.z, n);
    }

    public void Conjugate(FVec3T_F32 fVec3T_F32, FVec3T_F32 fVec3T_F322, int n) {
        ForceInline.v();
        this.Conjugate(fVec3T_F32, fVec3T_F322.x, fVec3T_F322.y, fVec3T_F322.z, n);
    }

    public FVec3T_F32 Conjugate(F32 f32, F32 f322, F32 f323, int n) {
        FVec3T_F32 fVec3T_F32 = FVec3T_F32.Get();
        this.Conjugate(fVec3T_F32, f32, f322, f323, n);
        return fVec3T_F32;
    }

    public void Conjugate(FVec3T_F32 fVec3T_F32, F32 f32, F32 f322, F32 f323, int n) {
        int n2 = 28 - n;
        F32 f324 = new F32(this.s.DecreasePrecision(n2));
        F32 f325 = new F32(f32);
        F32 f326 = new F32(f322);
        F32 f327 = new F32(f323);
        F32 f328 = new F32(this.v_x.DecreasePrecision(n2));
        F32 f329 = new F32(this.v_y.DecreasePrecision(n2));
        F32 f3210 = new F32(this.v_z.DecreasePrecision(n2));
        F32 f3211 = new F32(f328.Mul(f325, n).Add(f329.Mul(f326, n)).Add(f3210.Mul(f327, n)));
        f3211 = f3211.Neg();
        F32 f3212 = new F32(f324.Mul(f325, n).Add(f329.Mul(f327, n)).Sub(f3210.Mul(f326, n)));
        F32 f3213 = new F32(f324.Mul(f326, n).Sub(f328.Mul(f327, n)).Add(f3210.Mul(f325, n)));
        F32 f3214 = new F32(f324.Mul(f327, n).Add(f328.Mul(f326, n)).Sub(f329.Mul(f325, n)));
        fVec3T_F32.x = f3212.Mul(f324, n).Sub(f3211.Mul(f328, n)).Sub(f3213.Mul(f3210, n)).Add(f3214.Mul(f329, n));
        fVec3T_F32.y = f3213.Mul(f324, n).Sub(f3211.Mul(f329, n)).Add(f3212.Mul(f3210, n)).Sub(f3214.Mul(f328, n));
        fVec3T_F32.z = f3214.Mul(f324, n).Sub(f3211.Mul(f3210, n)).Sub(f3212.Mul(f329, n)).Add(f3213.Mul(f328, n));
    }

    public FVec3T_F32 ConjugateUnitI(int n) {
        ForceInline.v();
        return this.ConjugateUnit(this.v_x.Neg(), this.s, this.v_z, this.v_y.Neg(), n);
    }

    public FVec3T_F32 ConjugateUnitJ(int n) {
        ForceInline.v();
        return this.ConjugateUnit(this.v_y.Neg(), this.v_z.Neg(), this.s, this.v_x, n);
    }

    public FVec3T_F32 ConjugateUnitK(int n) {
        ForceInline.v();
        return this.ConjugateUnit(this.v_z.Neg(), this.v_y, this.v_x.Neg(), this.s, n);
    }

    public void ConjugateUnitI(FVec3T_F32 fVec3T_F32, int n) {
        ForceInline.v();
        this.ConjugateUnit(this.v_x.Neg(), this.s, this.v_z, this.v_y.Neg(), fVec3T_F32, n);
    }

    public void ConjugateUnitJ(FVec3T_F32 fVec3T_F32, int n) {
        ForceInline.v();
        this.ConjugateUnit(this.v_y.Neg(), this.v_z.Neg(), this.s, this.v_x, fVec3T_F32, n);
    }

    public void ConjugateUnitK(FVec3T_F32 fVec3T_F32, int n) {
        ForceInline.v();
        this.ConjugateUnit(this.v_z.Neg(), this.v_y, this.v_x.Neg(), this.s, fVec3T_F32, n);
    }

    public FQuaternionT_F32 DestructiveInverseForNormalized() {
        this.v_x = this.v_x.Neg();
        this.v_y = this.v_y.Neg();
        this.v_z = this.v_z.Neg();
        return this;
    }

    public FQuaternionT_F32 GetInverseForNormalized() {
        FQuaternionT_F32 fQuaternionT_F32 = FQuaternionT_F32.Get();
        this.GetInverseForNormalized(fQuaternionT_F32);
        return fQuaternionT_F32;
    }

    public void GetInverseForNormalized(FQuaternionT_F32 fQuaternionT_F32) {
        fQuaternionT_F32.s = this.s;
        fQuaternionT_F32.v_x = this.v_x.Neg();
        fQuaternionT_F32.v_y = this.v_y.Neg();
        fQuaternionT_F32.v_z = this.v_z.Neg();
    }

    public FQuaternionT_F32 DestructiveInverse() {
        F32 f32 = new F32(this.v_x.Square(28).Add(this.v_y.Square(28)).Add(this.v_z.Square(28)));
        F32 f322 = new F32(this.s.Square(28).Add(f32));
        F32 f323 = new F32(f322.Inverse(28));
        this.s = this.s.Mul(f323, 28);
        this.v_x = this.v_x.Mul(f323.Neg(), 28);
        this.v_y = this.v_y.Mul(f323.Neg(), 28);
        this.v_z = this.v_z.Mul(f323.Neg(), 28);
        return this;
    }

    public FQuaternionT_F32 GetInverse() {
        FQuaternionT_F32 fQuaternionT_F32 = FQuaternionT_F32.Get();
        F32 f32 = new F32(this.v_x.Square(28).Add(this.v_y.Square(28)).Add(this.v_z.Square(28)));
        F32 f322 = new F32(this.s.Square(28).Add(f32));
        F32 f323 = new F32(f322.Inverse(28));
        fQuaternionT_F32.s = this.s.Mul(f323, 28);
        fQuaternionT_F32.v_x = this.v_x.Mul(f323.Neg(), 28);
        fQuaternionT_F32.v_y = this.v_y.Mul(f323.Neg(), 28);
        fQuaternionT_F32.v_z = this.v_z.Mul(f323.Neg(), 28);
        return fQuaternionT_F32;
    }

    public FQuaternionT_F32 DestructiveNormalize() {
        ForceInline.v();
        F32 f32 = new F32(this.v_x.Square(28).Add(this.v_y.Square(28)).Add(this.v_z.Square(28)));
        F32 f322 = new F32(this.s.Square(28).Add(f32).Sqrt(28));
        F32 f323 = new F32(f322.Inverse(28));
        this.s = this.s.Mul(f323, 28);
        this.v_x = this.v_x.Mul(f323, 28);
        this.v_y = this.v_y.Mul(f323, 28);
        this.v_z = this.v_z.Mul(f323, 28);
        return this;
    }

    public FQuaternionT_F32 GetNormalized() {
        FQuaternionT_F32 fQuaternionT_F32 = FQuaternionT_F32.Get(this);
        fQuaternionT_F32.DestructiveNormalize();
        return fQuaternionT_F32;
    }

    public void SetIdentity() {
        ForceInline.v();
        this.s = F32.One(28);
        this.v_x = F32.Zero(28);
        this.v_y = F32.Zero(28);
        this.v_z = F32.Zero(28);
    }

    public F32 GetNormalizedAxisAndRotationAngle(FVec3T_F32 fVec3T_F32, int n) {
        int n2 = 28 - n;
        F32 f32 = new F32(this.v_x.DecreasePrecision(n2));
        F32 f322 = new F32(this.v_y.DecreasePrecision(n2));
        F32 f323 = new F32(this.v_z.DecreasePrecision(n2));
        F32 f324 = new F32(this.s.ArcCos(28));
        F32 f325 = new F32(f324.MulPower2(1));
        F32 f326 = new F32(f324.Sin(28).DecreasePrecision(n2));
        if (f326.LessOrEqual(F32.Epsilon(n))) {
            fVec3T_F32.x = F32.Zero(n);
            fVec3T_F32.y = F32.Zero(n);
            fVec3T_F32.z = F32.Zero(n);
            return F32.Zero(n);
        }
        fVec3T_F32.x = f32.Div(f326, n);
        fVec3T_F32.y = f322.Div(f326, n);
        fVec3T_F32.z = f323.Div(f326, n);
        return f325.DecreasePrecision(n2);
    }

    public F32 GetNormalizedAxisAndSmallestRotationAngle(FVec3T_F32 fVec3T_F32, int n) {
        int n2 = 28 - n;
        F32 f32 = new F32(this.v_x.DecreasePrecision(n2));
        F32 f322 = new F32(this.v_y.DecreasePrecision(n2));
        F32 f323 = new F32(this.v_z.DecreasePrecision(n2));
        F32 f324 = new F32();
        F32 f325 = new F32();
        if (this.s.GreaterOrEqual(F32.Zero(28))) {
            f325 = this.s.ArcCos(28);
            f324 = f325.MulPower2(1);
            F32 f326 = new F32(f325.Sin(28).DecreasePrecision(n2));
            if (f326.LessOrEqual(F32.Epsilon(n))) {
                fVec3T_F32.x = F32.Zero(n);
                fVec3T_F32.y = F32.Zero(n);
                fVec3T_F32.z = F32.Zero(n);
                return F32.Zero(n);
            }
            fVec3T_F32.x = f32.Div(f326, n);
            fVec3T_F32.y = f322.Div(f326, n);
            fVec3T_F32.z = f323.Div(f326, n);
        } else {
            f325 = this.s.Neg().ArcCos(28);
            f324 = f325.MulPower2(1);
            F32 f327 = new F32(f325.Sin(28).DecreasePrecision(n2));
            if (f327.LessOrEqual(F32.Epsilon(28))) {
                fVec3T_F32.x = F32.Zero(n);
                fVec3T_F32.y = F32.Zero(n);
                fVec3T_F32.z = F32.Zero(n);
                return F32.Zero(n);
            }
            fVec3T_F32.x = f32.Div(f327.Neg(), n);
            fVec3T_F32.y = f322.Div(f327.Neg(), n);
            fVec3T_F32.z = f323.Div(f327.Neg(), n);
        }
        return f324.DecreasePrecision(n2);
    }

    public FMat44T_F32 ToMatrix(int n) {
        FMat44T_F32 fMat44T_F32 = FMat44T_F32.Get();
        this.ToMatrix(fMat44T_F32, n);
        return fMat44T_F32;
    }

    public void ToMatrix(FMat44T_F32 fMat44T_F32, int n) {
        int n2 = 28 - n;
        F32 f32 = new F32(this.s.DecreasePrecision(n2));
        F32 f322 = new F32(this.v_x.DecreasePrecision(n2));
        F32 f323 = new F32(this.v_y.DecreasePrecision(n2));
        F32 f324 = new F32(this.v_z.DecreasePrecision(n2));
        F32 f325 = new F32(f322.MulPower2(1));
        F32 f326 = new F32(f325.Mul(f322, n));
        F32 f327 = new F32(f325.Mul(f323, n));
        F32 f328 = new F32(f325.Mul(f324, n));
        F32 f329 = new F32(f325.Mul(f32, n));
        F32 f3210 = new F32(f323.MulPower2(1));
        F32 f3211 = new F32(f3210.Mul(f323, n));
        F32 f3212 = new F32(f3210.Mul(f324, n));
        F32 f3213 = new F32(f3210.Mul(f32, n));
        F32 f3214 = new F32(f324.MulPower2(1));
        F32 f3215 = new F32(f3214.Mul(f324, n));
        F32 f3216 = new F32(f3214.Mul(f32, n));
        F32 f3217 = new F32(F32.One(n).Sub(f326));
        fMat44T_F32.m11 = F32.One(n).Sub(f3211).Sub(f3215);
        fMat44T_F32.m12 = f327.Sub(f3216);
        fMat44T_F32.m13 = f328.Add(f3213);
        fMat44T_F32.m14 = F32.Zero(n);
        fMat44T_F32.m21 = f327.Add(f3216);
        fMat44T_F32.m22 = f3217.Sub(f3215);
        fMat44T_F32.m23 = f3212.Sub(f329);
        fMat44T_F32.m24 = F32.Zero(n);
        fMat44T_F32.m31 = f328.Sub(f3213);
        fMat44T_F32.m32 = f3212.Add(f329);
        fMat44T_F32.m33 = f3217.Sub(f3211);
        fMat44T_F32.m34 = F32.Zero(n);
        fMat44T_F32.m41 = F32.Zero(n);
        fMat44T_F32.m42 = F32.Zero(n);
        fMat44T_F32.m43 = F32.Zero(n);
        fMat44T_F32.m44 = F32.One(n);
    }

    public static FQuaternionT_F32 I() {
        FQuaternionT_F32 fQuaternionT_F32 = FQuaternionT_F32.Get();
        fQuaternionT_F32.s = F32.One(28);
        fQuaternionT_F32.v_x = F32.Zero(28);
        fQuaternionT_F32.v_y = F32.Zero(28);
        fQuaternionT_F32.v_z = F32.Zero(28);
        return fQuaternionT_F32;
    }

    public static FQuaternionT_F32 Interpolate(FQuaternionT_F32 fQuaternionT_F32, FQuaternionT_F32 fQuaternionT_F322, F32 f32, int n) {
        FVec3T_F32 fVec3T_F32 = new FVec3T_F32();
        FQuaternionT_F32 fQuaternionT_F323 = new FQuaternionT_F32(fQuaternionT_F32.GetInverseForNormalized().Mul(fQuaternionT_F322));
        F32 f322 = new F32(fQuaternionT_F323.GetNormalizedAxisAndSmallestRotationAngle(fVec3T_F32, n));
        F32 f323 = new F32(f322.Mul(f32, n));
        return fQuaternionT_F32.Mul(new FQuaternionT_F32(fVec3T_F32, f323, n));
    }

    public F32 GetScalarPart(int n) {
        ForceInline.v();
        return this.s.DecreasePrecision(28 - n);
    }

    public FVec3T_F32 GetVectorPart(int n) {
        int n2 = 28 - n;
        FVec3T_F32 fVec3T_F32 = FVec3T_F32.Get(this.v_x.DecreasePrecision(n2), this.v_y.DecreasePrecision(n2), this.v_z.DecreasePrecision(n2));
        return fVec3T_F32;
    }

    public void SimulateEuler(FVec3T_F32 fVec3T_F32, int n) {
        F32 f32;
        F32 f322;
        F32 f323;
        ForceInline.v();
        F32 f324 = new F32();
        F32 f325 = new F32();
        F32 f326 = new F32();
        F32 f327 = new F32();
        F32 f328 = new F32(fVec3T_F32.LengthHP(n));
        if (f328.LessThan(F32.Epsilon(n))) {
            f324 = F32.One(28);
            f325 = F32.Zero(28);
            f326 = F32.Zero(28);
            f327 = F32.Zero(28);
        } else {
            int n2 = 28 - n;
            f323 = new F32(f328.DivPower2(1));
            f322 = new F32(f323.Sin(n));
            f32 = new F32(f323.Cos(n));
            f324 = f32.IncreasePrecision(n2);
            f325 = fVec3T_F32.x;
            f326 = fVec3T_F32.y;
            f327 = fVec3T_F32.z;
            f325 = f325.Div(f328, n);
            f326 = f326.Div(f328, n);
            f327 = f327.Div(f328, n);
            f325 = f325.Mul(f322, n);
            f326 = f326.Mul(f322, n);
            f327 = f327.Mul(f322, n);
            f325 = f325.IncreasePrecision(n2);
            f326 = f326.IncreasePrecision(n2);
            f327 = f327.IncreasePrecision(n2);
        }
        F32 f329 = new F32(f325.Mul(this.v_x, 28).Add(f326.Mul(this.v_y, 28)).Add(f327.Mul(this.v_z, 28)));
        f323 = new F32(f324.Mul(this.s, 28).Sub(f329));
        f322 = new F32(f324.Mul(this.v_x, 28).Add(f325.Mul(this.s, 28)).Add(f326.Mul(this.v_z, 28)).Sub(f327.Mul(this.v_y, 28)));
        f32 = new F32(f324.Mul(this.v_y, 28).Add(f326.Mul(this.s, 28)).Sub(f325.Mul(this.v_z, 28)).Add(f327.Mul(this.v_x, 28)));
        F32 f3210 = new F32(f324.Mul(this.v_z, 28).Add(f327.Mul(this.s, 28)).Add(f325.Mul(this.v_y, 28)).Sub(f326.Mul(this.v_x, 28)));
        this.s = f323;
        this.v_x = f322;
        this.v_y = f32;
        this.v_z = f3210;
        this.DestructiveNormalize();
    }

    public static FQuaternionT_F32 Get() {
        if (mPoolIndex >= 0) {
            FQuaternionT_F32 fQuaternionT_F32 = mPool[mPoolIndex--];
            return fQuaternionT_F32;
        }
        return new FQuaternionT_F32();
    }

    public static FQuaternionT_F32 Get(FQuaternionT_F32 fQuaternionT_F32) {
        if (mPoolIndex >= 0) {
            FQuaternionT_F32 fQuaternionT_F322 = mPool[mPoolIndex--];
            fQuaternionT_F322.Assign(fQuaternionT_F32);
            return fQuaternionT_F322;
        }
        return new FQuaternionT_F32(fQuaternionT_F32);
    }

    public static FQuaternionT_F32 Get(F32 f32, FVec3T_F32 fVec3T_F32) {
        if (mPoolIndex >= 0) {
            FQuaternionT_F32 fQuaternionT_F32 = mPool[mPoolIndex--];
            fQuaternionT_F32.s = f32;
            fQuaternionT_F32.v_x = fVec3T_F32.x;
            fQuaternionT_F32.v_y = fVec3T_F32.y;
            fQuaternionT_F32.v_z = fVec3T_F32.z;
            return fQuaternionT_F32;
        }
        return new FQuaternionT_F32(f32, fVec3T_F32);
    }

    public static FQuaternionT_F32 Get(FVec3T_F32 fVec3T_F32, int n) {
        if (mPoolIndex >= 0) {
            FQuaternionT_F32 fQuaternionT_F32 = mPool[mPoolIndex--];
            F32 f32 = new F32(fVec3T_F32.LengthHP(n));
            if (f32.LessThan(F32.Epsilon(n))) {
                fQuaternionT_F32.s = F32.One(28);
                fQuaternionT_F32.v_x = F32.Zero(28);
                fQuaternionT_F32.v_y = F32.Zero(28);
                fQuaternionT_F32.v_z = F32.Zero(28);
            } else {
                int n2 = 28 - n;
                F32 f322 = new F32(f32.DivPower2(1));
                F32 f323 = new F32(f322.Sin(n));
                F32 f324 = new F32(f322.Cos(n));
                fQuaternionT_F32.s = f324.IncreasePrecision(n2);
                fQuaternionT_F32.v_x = fVec3T_F32.x;
                fQuaternionT_F32.v_y = fVec3T_F32.y;
                fQuaternionT_F32.v_z = fVec3T_F32.z;
                fQuaternionT_F32.v_x = fQuaternionT_F32.v_x.Div(f32, n);
                fQuaternionT_F32.v_y = fQuaternionT_F32.v_y.Div(f32, n);
                fQuaternionT_F32.v_z = fQuaternionT_F32.v_z.Div(f32, n);
                fQuaternionT_F32.v_x = fQuaternionT_F32.v_x.Mul(f323, n);
                fQuaternionT_F32.v_y = fQuaternionT_F32.v_y.Mul(f323, n);
                fQuaternionT_F32.v_z = fQuaternionT_F32.v_z.Mul(f323, n);
                fQuaternionT_F32.v_x = fQuaternionT_F32.v_x.IncreasePrecision(n2);
                fQuaternionT_F32.v_y = fQuaternionT_F32.v_y.IncreasePrecision(n2);
                fQuaternionT_F32.v_z = fQuaternionT_F32.v_z.IncreasePrecision(n2);
            }
            return fQuaternionT_F32;
        }
        return new FQuaternionT_F32(fVec3T_F32, n);
    }

    public FQuaternionT_F32(F32 f32, FVec3T_F32 fVec3T_F32) {
        this.s = new F32(f32);
        this.v_x = new F32(fVec3T_F32.x);
        this.v_y = new F32(fVec3T_F32.y);
        this.v_z = new F32(fVec3T_F32.z);
    }

    public FQuaternionT_F32 DestructiveNormalize(int n) {
        int n2 = 28 - n;
        F32 f32 = new F32(this.v_x.Square(n).Add(this.v_y.Square(n)).Add(this.v_z.Square(n)));
        F32 f322 = new F32(this.s.Square(n).Add(f32).Sqrt(n));
        F32 f323 = new F32(f322.Inverse(n));
        this.s = this.s.Mul(f323, n).IncreasePrecision(n2);
        this.v_x = this.v_x.Mul(f323, n);
        this.v_y = this.v_y.Mul(f323, n);
        this.v_z = this.v_z.Mul(f323, n);
        this.v_x = this.v_x.IncreasePrecision(n2);
        this.v_y = this.v_y.IncreasePrecision(n2);
        this.v_z = this.v_z.IncreasePrecision(n2);
        return this;
    }

    public void Mul(FVec3T_F32 fVec3T_F32, int n, FQuaternionT_F32 fQuaternionT_F32) {
        int n2 = 28 - n;
        F32 f32 = new F32(this.s.DecreasePrecision(n2));
        F32 f322 = new F32(fVec3T_F32.x);
        F32 f323 = new F32(fVec3T_F32.y);
        F32 f324 = new F32(fVec3T_F32.z);
        F32 f325 = new F32(this.v_x.DecreasePrecision(n2));
        F32 f326 = new F32(this.v_y.DecreasePrecision(n2));
        F32 f327 = new F32(this.v_z.DecreasePrecision(n2));
        fQuaternionT_F32.s = f325.Mul(f322, n).Add(f326.Mul(f323, n)).Add(f327.Mul(f324, n));
        fQuaternionT_F32.s = fQuaternionT_F32.s.Neg();
        fQuaternionT_F32.v_x = f32.Mul(f322, n).Add(f326.Mul(f324, n)).Sub(f327.Mul(f323, n));
        fQuaternionT_F32.v_y = f32.Mul(f323, n).Sub(f325.Mul(f324, n)).Add(f327.Mul(f322, n));
        fQuaternionT_F32.v_z = f32.Mul(f324, n).Add(f325.Mul(f323, n)).Sub(f326.Mul(f322, n));
    }

    public FVec3T_F32 ConjugateUnit(F32 f32, F32 f322, F32 f323, F32 f324, int n) {
        FVec3T_F32 fVec3T_F32 = FVec3T_F32.Get(f322.Mul(this.s, 28).Sub(f32.Mul(this.v_x, 28)).Sub(f323.Mul(this.v_z, 28)).Add(f324.Mul(this.v_y, 28)), f323.Mul(this.s, 28).Sub(f32.Mul(this.v_y, 28)).Add(f322.Mul(this.v_z, 28)).Sub(f324.Mul(this.v_x, 28)), f324.Mul(this.s, 28).Sub(f32.Mul(this.v_z, 28)).Sub(f322.Mul(this.v_y, 28)).Add(f323.Mul(this.v_x, 28)));
        int n2 = 28 - n;
        fVec3T_F32.x = fVec3T_F32.x.DecreasePrecision(n2);
        fVec3T_F32.y = fVec3T_F32.y.DecreasePrecision(n2);
        fVec3T_F32.z = fVec3T_F32.z.DecreasePrecision(n2);
        return fVec3T_F32;
    }

    public void ConjugateUnit(F32 f32, F32 f322, F32 f323, F32 f324, FVec3T_F32 fVec3T_F32, int n) {
        fVec3T_F32.x = f322.Mul(this.s, 28).Sub(f32.Mul(this.v_x, 28)).Sub(f323.Mul(this.v_z, 28)).Add(f324.Mul(this.v_y, 28));
        fVec3T_F32.y = f323.Mul(this.s, 28).Sub(f32.Mul(this.v_y, 28)).Add(f322.Mul(this.v_z, 28)).Sub(f324.Mul(this.v_x, 28));
        fVec3T_F32.z = f324.Mul(this.s, 28).Sub(f32.Mul(this.v_z, 28)).Sub(f322.Mul(this.v_y, 28)).Add(f323.Mul(this.v_x, 28));
        int n2 = 28 - n;
        fVec3T_F32.x = fVec3T_F32.x.DecreasePrecision(n2);
        fVec3T_F32.y = fVec3T_F32.y.DecreasePrecision(n2);
        fVec3T_F32.z = fVec3T_F32.z.DecreasePrecision(n2);
    }

    public static FQuaternionT_F32[] InstArrayFQuaternionT_F32(int n) {
        FQuaternionT_F32[] fQuaternionT_F32Array = new FQuaternionT_F32[n];
        for (int i = 0; i < n; ++i) {
            fQuaternionT_F32Array[i] = new FQuaternionT_F32();
        }
        return fQuaternionT_F32Array;
    }

    public static FQuaternionT_F32[][] InstArrayFQuaternionT_F32(int n, int n2) {
        FQuaternionT_F32[][] fQuaternionT_F32Array = new FQuaternionT_F32[n][];
        for (int i = 0; i < n; ++i) {
            fQuaternionT_F32Array[i] = new FQuaternionT_F32[n2];
            for (int j = 0; j < n2; ++j) {
                fQuaternionT_F32Array[i][j] = new FQuaternionT_F32();
            }
        }
        return fQuaternionT_F32Array;
    }

    public static FQuaternionT_F32[][][] InstArrayFQuaternionT_F32(int n, int n2, int n3) {
        FQuaternionT_F32[][][] fQuaternionT_F32Array = new FQuaternionT_F32[n][][];
        for (int i = 0; i < n; ++i) {
            fQuaternionT_F32Array[i] = new FQuaternionT_F32[n2][];
            for (int j = 0; j < n2; ++j) {
                fQuaternionT_F32Array[i][j] = new FQuaternionT_F32[n3];
                for (int k = 0; k < n3; ++k) {
                    fQuaternionT_F32Array[i][j][k] = new FQuaternionT_F32();
                }
            }
        }
        return fQuaternionT_F32Array;
    }
}

