/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

public class BlVector {
    public Object[] mObjects = null;
    public int mCapacity;
    public int mSize;
    public int mIncrement;

    public BlVector() {
        this.mCapacity = 5;
        this.mIncrement = 1;
        this.mObjects = this.AllocateArray(this.mCapacity);
    }

    public BlVector(int n, int n2) {
        this.mCapacity = n;
        this.mIncrement = n2;
        if (this.mCapacity > 0 && this.mIncrement >= 0) {
            this.mObjects = this.AllocateArray(n);
        }
    }

    public void destruct() {
        this.mObjects = null;
    }

    public int GetCapacity() {
        return this.mCapacity;
    }

    public int GetSize() {
        return this.mSize;
    }

    public boolean IsEmpty() {
        return this.mSize == 0;
    }

    public boolean IsFull() {
        return this.mIncrement == 0 && this.mSize == this.mCapacity;
    }

    public Object GetAt(int n) {
        if (n >= 0 && n < this.mSize) {
            return this.mObjects[n];
        }
        return null;
    }

    public Object SetAt(int n, Object object) {
        Object object2 = null;
        if (n >= 0 && n < this.mSize) {
            object2 = this.mObjects[n];
            this.mObjects[n] = object;
        }
        return object2;
    }

    public void InsertAt(int n, Object object) {
        if (n >= 0 && n <= this.mSize) {
            if (this.mSize == this.mCapacity && this.mIncrement > 0) {
                this.IncreaseCapacity();
            }
            if (!this.IsFull()) {
                if (!this.IsEmpty()) {
                    for (int i = this.mSize; i > n; --i) {
                        this.mObjects[i] = this.mObjects[i - 1];
                    }
                }
                this.mObjects[n] = object;
                ++this.mSize;
            }
        }
    }

    public void Append(Object object) {
        this.InsertAt(this.mSize, object);
    }

    public void Append(BlVector blVector) {
        int n = blVector.GetSize();
        for (int i = 0; i < n; ++i) {
            this.Append(blVector.GetAt(i));
        }
    }

    public Object RemoveAt(int n) {
        Object object = null;
        if (n >= 0 && n < this.mSize) {
            object = this.mObjects[n];
            for (int i = n; i < this.mSize - 1; ++i) {
                this.mObjects[i] = this.mObjects[i + 1];
            }
            --this.mSize;
            this.mObjects[this.mSize] = null;
        }
        return object;
    }

    public void Remove(Object object) {
        int n = this.Find(object, 0);
        if (n >= 0) {
            this.RemoveAt(n);
        }
    }

    public void RemoveRange(int n, int n2) {
        if (n >= 0 && n < this.mSize) {
            while (n2 > 0 && !this.IsEmpty()) {
                this.RemoveAt(n);
                --n2;
            }
        }
    }

    public void RemoveAll(Object object) {
        int n = this.Find(object, 0);
        while (n >= 0) {
            this.RemoveAt(n);
            n = this.Find(object, n);
        }
    }

    public void Clear() {
        for (int i = 0; i < this.mSize; ++i) {
            this.mObjects[i] = null;
        }
        this.mSize = 0;
    }

    public int Find(Object object) {
        return this.Find(object, 0);
    }

    public int Find(Object object, int n) {
        if (n < 0) {
            n = 0;
        }
        for (int i = n; i < this.mSize; ++i) {
            if (this.mObjects[i] != object) continue;
            return i;
        }
        return -1;
    }

    public int ToArray(Object[] objectArray, int n) {
        int n2 = 0;
        if (objectArray != null) {
            for (int i = 0; i < n && i < this.mSize; ++i) {
                objectArray[i] = this.mObjects[i];
                ++n2;
            }
        }
        return n2;
    }

    public BlVector(BlVector blVector) {
    }

    public Object[] AllocateArray(int n) {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = null;
        }
        return objectArray;
    }

    public void IncreaseCapacity() {
        int n = this.mCapacity + this.mIncrement;
        Object[] objectArray = this.mObjects;
        this.mObjects = this.AllocateArray(n);
        for (int i = 0; i < this.mSize; ++i) {
            this.mObjects[i] = objectArray[i];
        }
        this.mCapacity = n;
        objectArray = null;
    }

    public static BlVector[] InstArrayBlVector(int n) {
        BlVector[] blVectorArray = new BlVector[n];
        for (int i = 0; i < n; ++i) {
            blVectorArray[i] = new BlVector();
        }
        return blVectorArray;
    }

    public static BlVector[][] InstArrayBlVector(int n, int n2) {
        BlVector[][] blVectorArray = new BlVector[n][];
        for (int i = 0; i < n; ++i) {
            blVectorArray[i] = new BlVector[n2];
            for (int j = 0; j < n2; ++j) {
                blVectorArray[i][j] = new BlVector();
            }
        }
        return blVectorArray;
    }

    public static BlVector[][][] InstArrayBlVector(int n, int n2, int n3) {
        BlVector[][][] blVectorArray = new BlVector[n][][];
        for (int i = 0; i < n; ++i) {
            blVectorArray[i] = new BlVector[n2][];
            for (int j = 0; j < n2; ++j) {
                blVectorArray[i][j] = new BlVector[n3];
                for (int k = 0; k < n3; ++k) {
                    blVectorArray[i][j][k] = new BlVector();
                }
            }
        }
        return blVectorArray;
    }
}

