/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import ca.jamdat.flight.BlArray;
import ca.jamdat.flight.FlBitmapImplementor;
import ca.jamdat.flight.FlBrowser;
import ca.jamdat.flight.FlDataStore;
import ca.jamdat.flight.Memory;
import ca.jamdat.flight.StringUtils;
import com.ea.sdk.SDKConfig;
import com.ea.sdk.SDKDebug;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKImpl;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKString;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Image;
import net.rim.device.api.ui.Font;
import net.rim.device.api.ui.UiApplication;
import net.rim.device.api.ui.component.Dialog;

public class SDKUtils
implements SDKDebug {
    public static final byte TRANS_NONE = 0;
    public static final byte TOP = 16;
    public static final byte BOTTOM = 32;
    public static final byte BASELINE = 64;
    public static final byte HCENTER = 1;
    public static final byte VCENTER = 2;
    public static final byte LEFT = 4;
    public static final byte RIGHT = 8;
    public static final int MAX_VIRTUAL_RECORDS = 256;

    public static Object loadFont(SDKImage sDKImage, byte[] byArray) {
        return SDKUtils.loadFontInternal(sDKImage, byArray, -1);
    }

    public static void setFont(Object object) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        sDKImpl.mSdkFont.mFontData = null;
        sDKImpl.mSdkFont.mProps = null;
        sDKImpl.mSdkFont.mImage = null;
        sDKImpl.mSdkFont.mUTFCodes = null;
        sDKImpl.mSdkFont.mISOOffsetMap = null;
        sDKImpl.mSdkFont.mCharOffsets = null;
        sDKImpl.mSdkFont.mCharAndGlyphData = null;
        sDKImpl.mSdkFont.mColorPalette = null;
        if (object != null) {
            if (object instanceof Font && SDKConfig.getSystemFontSupport()) {
                sDKImpl.mSdkFont.mProps = new byte[12];
                sDKImpl.mSdkFont.mProps[0] = 1;
                sDKImpl.mSdkFont.mProps[1] = 2;
                sDKImpl.mSdkFont.mProps[7] = 0;
                sDKImpl.mSdkFont.mProps[8] = 1;
                sDKImpl.mSdkFont.mProps[9] = 2;
                sDKImpl.mSdkFont.mProps[10] = 4;
                if (sDKImpl.mGraphics != null) {
                    SDKUtils.nativeSetFont(sDKImpl.mGraphics, object);
                }
            } else if (SDKConfig.getBitmapFontSupport() || SDKConfig.getRectangleFontSupport()) {
                sDKImpl.mSdkFont.mImage = ((Object[])object)[0];
                sDKImpl.mSdkFont.mProps = (byte[])((Object[])object)[1];
                sDKImpl.mSdkFont.mScanLength = (Integer)((Object[])object)[7];
                sDKImpl.mSdkFont.mUTFCodes = (short[])((Object[])object)[2];
                sDKImpl.mSdkFont.mISOOffsetMap = (short[])((Object[])object)[3];
                sDKImpl.mSdkFont.mCharOffsets = (short[])((Object[])object)[4];
                sDKImpl.mSdkFont.mCharAndGlyphData = (byte[])((Object[])object)[5];
                sDKImpl.mSdkFont.mColorPalette = (int[])((Object[])object)[6];
                if (sDKImpl.mLanguageEncodings != null && sDKImpl.mSdkFont.mProps[11] != sDKImpl.mLanguageEncodings[sDKImpl.mLangIndex] && sDKImpl.mLanguageEncodings[sDKImpl.mLangIndex] > 1) {
                    sDKImpl.refreshISOOffsets();
                }
            }
        }
        sDKImpl.mSdkFont.mFontData = object;
    }

    public static Object setFontImage(SDKImage sDKImage) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        SDKUtils.setFontImageInternal(sDKImage, -1);
        return sDKImpl.mSdkFont.mFontData;
    }

    public static Object setFontChunk(byte[] byArray) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        sDKImpl.mSdkFont.mFontData = null;
        sDKImpl.mSdkFont.mProps = null;
        sDKImpl.mSdkFont.mUTFCodes = null;
        sDKImpl.mSdkFont.mISOOffsetMap = null;
        sDKImpl.mSdkFont.mCharOffsets = null;
        sDKImpl.mSdkFont.mCharAndGlyphData = null;
        sDKImpl.mSdkFont.mColorPalette = null;
        Object[] objectArray = sDKImpl.loadFontChunk(byArray);
        Object[] objectArray2 = new Object[]{sDKImpl.mSdkFont.mImage, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], new Integer(sDKImpl.mSdkFont.mScanLength)};
        SDKUtils.setFont(objectArray2);
        return sDKImpl.mSdkFont.mFontData;
    }

    public static Object getFont() {
        return SDKImpl.getInstance().mSdkFont.mFontData;
    }

    public static void setCharSpacing(int n) {
        SDKImpl.getInstance().mSdkFont.mProps[6] = (byte)n;
    }

    public static int getCharSpacing() {
        return SDKImpl.getInstance().mSdkFont.mProps[6] & 0xFF;
    }

    public static void setTransform(int n) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        byte by = (byte)((n & 2) + (n >> 2 & 1));
        byte by2 = (byte)(((n >> 2 ^ n & 1) << 1) + (n >> 2 & 1));
        byte by3 = (byte)(sDKImpl.mSdkFont.mProps[0] << by);
        sDKImpl.mSdkFont.mProps[8] = (byte)(by3 & 0xF | by3 >> 4);
        by3 = (byte)(sDKImpl.mSdkFont.mProps[1] << by2);
        sDKImpl.mSdkFont.mProps[9] = (byte)(by3 & 0xF | by3 >> 4);
        sDKImpl.mSdkFont.mProps[7] = (byte)n;
    }

    public static void setSpaceSpacing(int n) {
        SDKImpl.getInstance().mSdkFont.mProps[5] = (byte)n;
    }

    public static int getSpaceSpacing() {
        return SDKImpl.getInstance().mSdkFont.mProps[5] & 0xFF;
    }

    public static void setLeadingSpacing(int n) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        if ((sDKImpl.mSdkFont.mProps[3] & 0xFF) + (sDKImpl.mSdkFont.mProps[4] & 0xFF) + n < 0) {
            n = -(sDKImpl.mSdkFont.mProps[3] & 255 + sDKImpl.mSdkFont.mProps[4] & 0xFF);
        }
        sDKImpl.mSdkFont.mProps[2] = (byte)n;
    }

    public static int getLeadingSpacing() {
        return SDKImpl.getInstance().mSdkFont.mProps[2];
    }

    public static int getBaselinePosition() {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        if ((sDKImpl.mSdkFont.mProps[10] & 4) != 0 && SDKConfig.getSystemFontSupport()) {
            return ((Font)sDKImpl.mSdkFont.mFontData).getBaseline();
        }
        if (SDKConfig.getBitmapFontSupport() || SDKConfig.getRectangleFontSupport()) {
            return sDKImpl.mSdkFont.mProps[3] & 0xFF;
        }
        return -1;
    }

    public static int getLineSize() {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        if ((sDKImpl.mSdkFont.mProps[10] & 4) != 0 && SDKConfig.getSystemFontSupport()) {
            return ((Font)sDKImpl.mSdkFont.mFontData).getHeight();
        }
        if (SDKConfig.getBitmapFontSupport() || SDKConfig.getRectangleFontSupport()) {
            return (sDKImpl.mSdkFont.mProps[3] & 0xFF) + (sDKImpl.mSdkFont.mProps[4] & 0xFF) + sDKImpl.mSdkFont.mProps[2];
        }
        return -1;
    }

    public static int[] getFontColorPalette() {
        return SDKImpl.getInstance().mSdkFont.mColorPalette;
    }

    public static void drawString(SDKString sDKString, int n, int n2, int n3) {
        SDKUtils.drawSubString(sDKString, 0, sDKString.length(), n, n2, n3);
    }

    public static void drawSubString(SDKString sDKString, int n, int n2, int n3, int n4, int n5) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        if (SDKConfig.getDebugEnabled()) {
            if (sDKImpl.mGraphics == null) {
                SDKUtils.debugLog("SDKUtils.drawSubString.Graphics are null, use setGraphics(Graphics)", 4);
            }
            if (sDKImpl.mSdkFont.mFontData == null) {
                SDKUtils.debugLog("SDKUtils.drawSubString .Font is null, use setFont(Object)", 4);
            }
            if (!(SDKConfig.getSystemFontSupport() || SDKConfig.getBitmapFontSupport() || SDKConfig.getRectangleFontSupport())) {
                SDKUtils.debugLog("SDKUtils.drawSubString .no font support enabled, you must enable at least 1 type of font support in SDKConfig", 4);
            }
        }
        if ((sDKImpl.mSdkFont.mProps[10] & 4) != 0 && SDKConfig.getSystemFontSupport()) {
            if (sDKImpl.mDrawStringBuff == null) {
                sDKImpl.mDrawStringBuff = new StringBuffer();
            }
            sDKImpl.mDrawStringBuff.setLength(0);
            for (int i = n; i < n + n2; ++i) {
                char c = sDKString.charAt(i);
                if (c == '\u00ad' && i != n + n2 - 1) continue;
                sDKImpl.mDrawStringBuff.append(c);
            }
            if (sDKImpl.mSdkFont.mProps[7] != 0 && SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog("SDKUtils.drawSubString .rendering of system fonts does not support transform: " + sDKImpl.mSdkFont.mProps[7], 4);
            }
            SDKUtils.nativeDrawString(sDKImpl.mGraphics, sDKImpl.mDrawStringBuff.toString(), n3, n4, n5);
            return;
        }
        if (SDKConfig.getBitmapFontSupport() || SDKConfig.getRectangleFontSupport()) {
            int n6;
            int n7 = sDKImpl.mSdkFont.mProps[3] & 0xFF;
            int n8 = SDKUtils.getLineSize();
            byte by = sDKImpl.mSdkFont.mProps[8];
            byte by2 = sDKImpl.mSdkFont.mProps[9];
            boolean bl = sDKImpl.mSdkFont.mScanLength != -1;
            boolean bl2 = (sDKImpl.mSdkFont.mProps[10] & 2) != 0;
            boolean bl3 = (sDKImpl.mSdkFont.mProps[10] & 0x80) != 0;
            int n9 = 0;
            int n10 = 0;
            if ((n5 & 8) != 0) {
                n9 -= SDKUtils.getSubStringSize(sDKString, n, n2);
            } else if ((n5 & 1) != 0) {
                n9 -= SDKUtils.getSubStringSize(sDKString, n, n2) >> 1;
            }
            if ((n5 & 0x40) != 0) {
                n10 -= n7;
            } else if ((n5 & 0x20) != 0) {
                n10 -= n8;
            }
            if (by == 1) {
                n3 += n9;
                n4 += n10;
            } else if (by == 4) {
                n3 -= n9;
                n4 -= n10;
            } else if (by == 2) {
                n3 -= n10;
                n4 += n9;
            } else if (by == 8) {
                n3 -= n10;
                n4 -= n9;
            }
            sDKImpl.mCurrPenPoint[0] = n3;
            sDKImpl.mCurrPenPoint[1] = n4;
            int n11 = sDKString.getEncoding();
            if (n11 != 1 && n11 != 0 && n11 != sDKImpl.mLanguageEncodings[sDKImpl.mLangIndex] && SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog("SDKUtils.drawSubString.SDKString [" + sDKString.toString() + "] has encoding=" + sDKString.getEncoding() + " but the currently set language has encoding: " + sDKImpl.mLanguageEncodings[sDKImpl.mLangIndex], 4);
            }
            byte by3 = (byte)((by & 5) != 0 ? (by & 4) >> 1 : ((by2 & 1) << 1) + ((~by2 & 2) >> 1));
            byte by4 = (byte)((by & 0xA) != 0 ? (by & 8) >> 2 : (by2 & 2) + (~by2 & 1));
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog("SDKUtils.drawSubString.offset = " + n + " len = " + n2 + " \"" + sDKString.toString() + "\"", 1);
                if (bl2 && SDKConfig.getRectangleFontSupport() && sDKImpl.mSdkFont.mProps[7] != 0) {
                    SDKUtils.debugLog("SDKUtils.drawSubString .rendering of rectangle fonts does not currently support transform: " + sDKImpl.mSdkFont.mProps[7], 4);
                }
            }
            int n12 = n6 = sDKImpl.mGraphics.getColor();
            for (int i = n; i < n + n2; ++i) {
                short s = sDKString.charCodeAt(i);
                if (s == 173 && i != n + n2 - 1) continue;
                short s2 = sDKImpl.getCharOffset(s, n11);
                int n13 = sDKImpl.getCharAdvance(s2);
                if (s2 == -1) {
                    if (s != 32) {
                        if (SDKConfig.getDebugEnabled()) {
                            SDKUtils.debugLog("SDKUtils.drawSubString.character not in Font: \\u" + (n11 == 0 || s < 128 ? s : sDKImpl.iso2utf(s)), 4);
                        }
                        sDKImpl.mGraphics.setColor(65280);
                        sDKImpl.mGraphics.fillRect(sDKImpl.mCurrPenPoint[0], sDKImpl.mCurrPenPoint[1], n13, n8);
                        sDKImpl.mGraphics.setColor(0xFF0000);
                        n12 = 0xFF0000;
                        sDKImpl.mGraphics.drawLine(sDKImpl.mCurrPenPoint[0], sDKImpl.mCurrPenPoint[1], sDKImpl.mCurrPenPoint[0] + n13, sDKImpl.mCurrPenPoint[1] + n8);
                        sDKImpl.mGraphics.drawLine(sDKImpl.mCurrPenPoint[0], sDKImpl.mCurrPenPoint[1] + n8, sDKImpl.mCurrPenPoint[0] + n13, sDKImpl.mCurrPenPoint[1]);
                    }
                    sDKImpl.advance(sDKImpl.mCurrPenPoint, n13);
                    continue;
                }
                short s3 = s2 = (short)(s2 + 1);
                s2 = (short)(s2 + 1);
                int n14 = sDKImpl.mSdkFont.mCharAndGlyphData[s3] & 0xFF;
                for (int j = 0; j < n14; ++j) {
                    int n15;
                    int n16;
                    int n17;
                    int n18;
                    int n19;
                    if (bl2 && SDKConfig.getRectangleFontSupport()) {
                        short s4 = s2;
                        s2 = (short)(s2 + 1);
                        n19 = sDKImpl.mSdkFont.mCharAndGlyphData[s4] & 0xFF;
                        short s5 = s2;
                        s2 = (short)(s2 + 1);
                        n18 = sDKImpl.mSdkFont.mCharAndGlyphData[s5];
                        short s6 = s2;
                        s2 = (short)(s2 + 1);
                        n17 = sDKImpl.mSdkFont.mCharAndGlyphData[s6];
                        if (bl3) {
                            n16 = sDKImpl.mSdkFont.mCharAndGlyphData[s2] >> 4 & 0xF;
                            short s7 = s2;
                            s2 = (short)(s2 + 1);
                            n15 = sDKImpl.mSdkFont.mCharAndGlyphData[s7] & 0xF;
                        } else {
                            short s8 = s2;
                            s2 = (short)(s2 + 1);
                            n16 = sDKImpl.mSdkFont.mCharAndGlyphData[s8] & 0xFF;
                            short s9 = s2;
                            s2 = (short)(s2 + 1);
                            n15 = sDKImpl.mSdkFont.mCharAndGlyphData[s9] & 0xFF;
                        }
                        if (sDKImpl.mSdkFont.mColorPalette[n19] != n12) {
                            sDKImpl.mGraphics.setColor(sDKImpl.mSdkFont.mColorPalette[n19]);
                            n12 = sDKImpl.mSdkFont.mColorPalette[n19];
                        }
                        sDKImpl.mGraphics.fillRect(sDKImpl.mCurrPenPoint[0] + n18, sDKImpl.mCurrPenPoint[1] + n7 - n17, n16, n15);
                    }
                    if (bl2 || !SDKConfig.getBitmapFontSupport()) continue;
                    short s10 = s2;
                    s2 = (short)(s2 + 1);
                    n19 = sDKImpl.mSdkFont.mCharAndGlyphData[s10] & 0xFF;
                    short s11 = s2;
                    s2 = (short)(s2 + 1);
                    n18 = sDKImpl.mSdkFont.mCharAndGlyphData[s11] & 0xFF;
                    short s12 = s2;
                    s2 = (short)(s2 + 1);
                    n17 = sDKImpl.mSdkFont.mCharAndGlyphData[s12];
                    short s13 = s2;
                    s2 = (short)(s2 + 1);
                    n16 = sDKImpl.mSdkFont.mCharAndGlyphData[s13];
                    short s14 = s2;
                    s2 = (short)(s2 + 1);
                    n15 = sDKImpl.mSdkFont.mCharAndGlyphData[s14] & 0xFF;
                    short s15 = s2;
                    s2 = (short)(s2 + 1);
                    int n20 = sDKImpl.mSdkFont.mCharAndGlyphData[s15] & 0xFF;
                    sDKImpl.mCurrPenTerms[0] = n17;
                    sDKImpl.mCurrPenTerms[1] = n16 - n7;
                    sDKImpl.mCurrPenTerms[2] = -n17 - n15;
                    sDKImpl.mCurrPenTerms[3] = n7 - n16 - n20;
                    int n21 = sDKImpl.mCurrPenPoint[0] + sDKImpl.mCurrPenTerms[by3];
                    int n22 = sDKImpl.mCurrPenPoint[1] + sDKImpl.mCurrPenTerms[by4];
                    sDKImpl.mGraphics.drawRegion((SDKImage)sDKImpl.mSdkFont.mImage, n19, n18, n15, n20, sDKImpl.mSdkFont.mProps[7], n21, n22, 0);
                }
                sDKImpl.advance(sDKImpl.mCurrPenPoint, n13);
            }
            sDKImpl.mGraphics.setColor(n6);
        }
    }

    public static void drawWrappedString(SDKString sDKString, short[] sArray, int n, int n2, int n3, int n4, int n5) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        int n6 = SDKUtils.getLineSize();
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if ((n5 & 2) != 0) {
            n9 = sArray[0] * n6 - sDKImpl.mSdkFont.mProps[2] >> 1;
            n5 ^= 2;
        } else if ((n5 & 0x20) != 0) {
            n9 = sArray[0] * n6 - sDKImpl.mSdkFont.mProps[2];
            n5 ^= 0x20;
        }
        n5 |= 0x10;
        if (sDKImpl.mSdkFont.mProps[9] == 1) {
            n3 -= n9;
            n7 = n6;
        } else if (sDKImpl.mSdkFont.mProps[9] == 4) {
            n3 += n9;
            n7 = -n6;
        } else if (sDKImpl.mSdkFont.mProps[9] == 2) {
            n4 -= n9;
            n8 = n6;
        } else {
            n4 += n9;
            n8 = -n6;
        }
        short s = sArray[(sArray[0] & 0xFFFF) + 2];
        for (int i = n; i < n + n2; ++i) {
            int n10 = sArray[i] & 0xFFFF;
            int n11 = (sArray[i + 1] & 0xFFFF) - n10;
            short s2 = sDKString.charCodeAt((sArray[i + 1] & 0xFFFF) - 1);
            if (s2 == s || s2 == 32) {
                --n11;
            }
            SDKUtils.drawSubString(sDKString, n10, n11, n3, n4, n5);
            n3 += n7;
            n4 += n8;
        }
    }

    public static short[] wrapString(SDKString sDKString, short[] sArray, int n, short s) {
        return SDKUtils.wrapSubString(sDKString, 0, sDKString.length(), sArray, n, s);
    }

    public static short[] wrapSubString(SDKString sDKString, int n, int n2, short[] sArray, int n3, short s) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        boolean bl = false;
        if (sArray == null) {
            if (sDKImpl.mWrapOffsets == null) {
                sDKImpl.mWrapOffsets = new short[50];
                sDKImpl.mWrapOffsetsLen = 50;
            }
            sArray = sDKImpl.mWrapOffsets;
            bl = true;
        }
        int n4 = sDKString.getEncoding();
        int n5 = 0;
        int n6 = 0;
        int n7 = -1;
        sArray[1] = (short)n;
        int n8 = 2;
        for (int i = n; i < n2 + n; ++i) {
            short s2 = sDKString.charCodeAt(i);
            if (bl && n8 + 3 >= sDKImpl.mWrapOffsetsLen) {
                sDKImpl.mWrapOffsets = new short[sDKImpl.mWrapOffsetsLen + 50];
                BlArray.Copy(sArray, 0, sDKImpl.mWrapOffsets, 0, sDKImpl.mWrapOffsetsLen);
                sArray = null;
                sArray = sDKImpl.mWrapOffsets;
                sDKImpl.mWrapOffsetsLen += 50;
            }
            if (s2 == s) {
                sArray[n8++] = (short)(i + 1);
                n5 = 0;
                n6 = 0;
                n7 = -1;
                continue;
            }
            int n9 = 0;
            if ((sDKImpl.mSdkFont.mProps[10] & 4) != 0 && SDKConfig.getSystemFontSupport()) {
                n9 = ((Font)sDKImpl.mSdkFont.mFontData).getAdvance(sDKString.charAt(i));
            } else if (SDKConfig.getBitmapFontSupport() || SDKConfig.getRectangleFontSupport()) {
                n9 = sDKImpl.getCharAdvance(sDKImpl.getCharOffset(s2, n4));
            }
            n6 += n9;
            if ((n5 += n9) > n3) {
                if (n7 == -1) {
                    sArray[n8++] = (short)i;
                    n5 = n9;
                    n6 = 0;
                    continue;
                }
                sArray[n8++] = (short)(n7 + 1);
                n7 = s2 == 32 || s2 == 173 ? i : -1;
                n5 = n6;
                n6 = 0;
                continue;
            }
            if (s2 != 32 && s2 != 173) continue;
            n7 = i;
            n6 = 0;
        }
        sArray[0] = (short)(n8 - 1);
        sArray[n8] = (short)(n2 + n);
        sArray[n8 + 1] = s;
        if (bl) {
            short[] sArray2 = new short[n8 + 2];
            BlArray.Copy(sArray, 0, sArray2, 0, n8 + 2);
            sArray = sArray2;
        }
        return sArray;
    }

    public static int getStringSize(SDKString sDKString) {
        return SDKUtils.getSubStringSize(sDKString, 0, sDKString.length());
    }

    public static int getSubStringSize(SDKString sDKString, int n, int n2) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        int n3 = 0;
        if (sDKImpl.mSdkFont.mFontData == null && SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog("SDKUtils.getSubStringSize.no font loaded, use setFont(Object)", 4);
        }
        if ((sDKImpl.mSdkFont.mProps[10] & 4) != 0 && SDKConfig.getSystemFontSupport()) {
            n3 = ((Font)sDKImpl.mSdkFont.mFontData).getAdvance(sDKString.toString(), n, n2);
        } else if (SDKConfig.getBitmapFontSupport() || SDKConfig.getRectangleFontSupport()) {
            int n4 = sDKString.getEncoding();
            for (int i = n; i < n + n2; ++i) {
                n3 += sDKImpl.getCharAdvance(sDKImpl.getCharOffset(sDKString.charCodeAt(i), n4));
            }
        }
        return n3;
    }

    public static boolean isLoadedStringsChunk(int n) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        byte by = sDKImpl.mChunkGroup[n];
        return sDKImpl.mChunkStringData[by] != null && sDKImpl.mGroupMap[by] == n;
    }

    public static int loadStringsChunk(int n) {
        SDKImpl sDKImpl;
        block22: {
            sDKImpl = SDKImpl.getInstance();
            SDKMIDlet sDKMIDlet = SDKMIDlet.getInstance();
            byte[] byArray = new byte[2];
            if (SDKConfig.getDebugEnabled()) {
                if (sDKImpl.mLangIndex == -1) {
                    SDKUtils.debugLog("SDKUtils.loadStringsChunk.language must be selected first!", 4);
                }
                if (n < 1 || n >= sDKImpl.mChunkGroup.length) {
                    SDKUtils.debugLog("SDKUtils.loadStringsChunk.chunkID '" + n + "' is out of bounds, valid range is [1," + sDKImpl.mChunkGroup.length + "] inclusive", 4);
                }
                if (sDKMIDlet == null) {
                    SDKUtils.debugLog("SDKUtils.loadStringsChunk.sdkMidlet is null, use setMidlet(MIDlet)", 4);
                }
            }
            if (SDKUtils.isLoadedStringsChunk(n) && !sDKImpl.mForceChunkLoad) {
                if (SDKConfig.getDebugEnabled()) {
                    SDKUtils.debugLog("SDKUtils.loadStringsChunk.chunkID: " + n + " already loaded, it won't be loaded again", 3);
                }
                return sDKImpl.mNumStringsPerChunk[n];
            }
            InputStream inputStream = null;
            try {
                int n2;
                byte by;
                byte by2 = by = (sDKImpl.mChunkFlags[n] & 0x40) == 0 ? sDKImpl.mLangIndex : (byte)0;
                if (sDKImpl.mChunkConfig == 0) {
                    if (SDKConfig.getDebugEnabled()) {
                        SDKUtils.debugLog("SDKUtils.loadStringsChunk.chunkID: " + n + " is being loaded using CHUNK_CONFIG_CONCAT for resIndex: " + by, 1);
                    }
                    inputStream = "".getClass().getResourceAsStream("/t_" + new String(sDKImpl.mLanguageIsocodes[by]).trim());
                    for (n2 = 1; n2 < n; ++n2) {
                        if ((sDKImpl.mChunkFlags[n2] & 0x40) != 0 && by != 0) continue;
                        SDKUtils.skipNative(inputStream, (sDKImpl.mNumStringsPerChunk[n2] + 1 << 1) + (sDKImpl.mChunkSize[by][n2] & 0xFFFF));
                    }
                } else if (sDKImpl.mChunkConfig == 1) {
                    if (SDKConfig.getDebugEnabled()) {
                        SDKUtils.debugLog("SDKUtils.loadStringsChunk.chunkID: " + n + " is being loaded using CHUNK_CONFIG_SEPARATE for resIndex: " + by, 1);
                    }
                    inputStream = "".getClass().getResourceAsStream("/t_" + new String(sDKImpl.mLanguageIsocodes[by]).trim() + n);
                } else if (SDKConfig.getDebugEnabled()) {
                    SDKUtils.debugLog("SDKUtils.loadStringsChunk.illegal value of chunk config: " + sDKImpl.mChunkConfig, 4);
                }
                n2 = sDKImpl.mChunkGroup[n];
                if (sDKImpl.mChunkStringOffsets[n2] == null) {
                    sDKImpl.mChunkStringOffsets[n2] = new short[sDKImpl.mGroupMaxNumOffsets[n2]];
                    if (SDKConfig.getDebugEnabled()) {
                        SDKUtils.debugLog("SDKUtils.loadStringsChunk.allocating mChunkStringOffsets[" + n2 + "] to be of size: " + sDKImpl.mGroupMaxNumOffsets[n2], 1);
                    }
                }
                for (int i = 0; i < sDKImpl.mNumStringsPerChunk[n] + 1; ++i) {
                    byArray[0] = (byte)inputStream.read();
                    byArray[1] = (byte)inputStream.read();
                    sDKImpl.mChunkStringOffsets[n2][i] = sDKImpl.bytesToShort(byArray, 0);
                    if (!SDKConfig.getDebugEnabled()) continue;
                    SDKUtils.debugLog("SDKUtils.loadStringsChunk.mChunkStringOffsets[" + n2 + "][" + i + "]: " + (sDKImpl.mChunkStringOffsets[n2][i] & 0xFFFF), 1);
                }
                if (sDKImpl.mChunkStringData[n2] == null) {
                    sDKImpl.mChunkStringData[n2] = new byte[sDKImpl.mGroupMaxSize[n2] & 0xFFFF];
                    if (SDKConfig.getDebugEnabled()) {
                        SDKUtils.debugLog("SDKUtils.loadStringsChunk.allocating mChunkStringData[" + n2 + "] to be of size: " + (sDKImpl.mGroupMaxSize[n2] & 0xFFFF), 1);
                    }
                }
                SDKUtils.readBytesNative(inputStream, sDKImpl.mChunkStringData[n2], 0, sDKImpl.mChunkSize[by][n] & 0xFFFF);
                sDKImpl.mGroupMap[n2] = (byte)n;
                if (SDKConfig.getDebugEnabled()) {
                    SDKUtils.debugLog("SDKUtils.loadStringsChunk.mGroupMap[" + n2 + "]: " + n, 1);
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                if (!SDKConfig.getDebugEnabled()) break block22;
                SDKUtils.debugLog("SDKUtils.loadStringsChunk.IOException, e.msg: " + iOException.getMessage(), 4);
            }
        }
        return sDKImpl.mNumStringsPerChunk[n];
    }

    public static void freeStringsChunk(int n) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        if (n > 0) {
            sDKImpl.mChunkStringData[sDKImpl.mChunkGroup[n]] = null;
            sDKImpl.mChunkStringOffsets[sDKImpl.mChunkGroup[n]] = null;
            sDKImpl.mChunkStringData[sDKImpl.mChunkGroup[n]] = null;
            sDKImpl.mChunkStringOffsets[sDKImpl.mChunkGroup[n]] = null;
        }
    }

    public static int loadTextHeader(byte[] byArray) {
        int n;
        int n2;
        int n3;
        int n4;
        SDKImpl sDKImpl = SDKImpl.getInstance();
        if (sDKImpl.mHdrLoaded) {
            return sDKImpl.mNumLangs;
        }
        int n5 = n4 = 0;
        n4 = (short)(n4 + 1);
        byte by = byArray[n5];
        int n6 = n4;
        n4 = (short)(n4 + 1);
        sDKImpl.mChunkConfig = byArray[n6];
        sDKImpl.mTextEncodings = (byArray[n4] & 0xFF) << 16 | (byArray[n4 + 1] & 0xFF) << 8 | byArray[n4 + 2] & 0xFF;
        n4 = (short)(n4 + 3);
        short s = sDKImpl.bytesToShort(byArray, n4);
        int n7 = n4 = (int)((short)(n4 + 2));
        n4 = (short)(n4 + 1);
        sDKImpl.mNumLangs = byArray[n7];
        int n8 = n4;
        n4 = (short)(n4 + 1);
        byte by2 = byArray[n8];
        int n9 = n4;
        n4 = (short)(n4 + 1);
        byte by3 = byArray[n9];
        sDKImpl.mNumStorageChunks = (byte)(by2 + 1);
        sDKImpl.mNumActualChunks = (byte)(by3 + 1);
        sDKImpl.mLanguageEncodings = new byte[sDKImpl.mNumLangs];
        sDKImpl.mLanguageIsocodes = new byte[sDKImpl.mNumLangs][];
        sDKImpl.mLanguageFontDifferentiator = new byte[sDKImpl.mNumLangs];
        sDKImpl.mNumStringsPerChunk = new short[sDKImpl.mNumActualChunks];
        sDKImpl.mChunkFlags = new byte[sDKImpl.mNumActualChunks];
        sDKImpl.mChunkGroup = new byte[sDKImpl.mNumActualChunks];
        sDKImpl.mChunkSize = new short[sDKImpl.mNumLangs][];
        sDKImpl.mGroupMaxSize = new short[sDKImpl.mNumActualChunks];
        for (n3 = 0; n3 < sDKImpl.mGroupMaxSize.length; ++n3) {
            sDKImpl.mGroupMaxSize[n3] = 0;
        }
        sDKImpl.mGroupMaxNumOffsets = new short[sDKImpl.mNumActualChunks];
        for (n3 = 0; n3 < sDKImpl.mGroupMaxNumOffsets.length; ++n3) {
            sDKImpl.mGroupMaxNumOffsets[n3] = 0;
        }
        sDKImpl.mGroupMap = new byte[sDKImpl.mNumActualChunks];
        sDKImpl.mChunkStringData = new byte[sDKImpl.mNumStorageChunks][];
        sDKImpl.mChunkStringOffsets = new short[sDKImpl.mNumStorageChunks][];
        for (n3 = 0; n3 < sDKImpl.mNumStorageChunks; ++n3) {
            sDKImpl.mChunkStringOffsets[n3] = null;
        }
        sDKImpl.mNumStringsPerChunk[0] = s;
        for (n3 = 0; n3 < sDKImpl.mNumLangs; ++n3) {
            sDKImpl.mChunkSize[n3] = new short[sDKImpl.mNumActualChunks];
        }
        for (n3 = 0; n3 < sDKImpl.mNumStorageChunks; ++n3) {
            sDKImpl.mChunkStringData[n3] = null;
        }
        n3 = (short)(s + 1);
        for (n2 = 0; n2 < sDKImpl.mNumLangs; ++n2) {
            sDKImpl.mLanguageIsocodes[n2] = new byte[5];
            for (n = 0; n < 5; ++n) {
                sDKImpl.mLanguageIsocodes[n2][n] = byArray[n4 + n];
            }
            int n10 = n4 = (int)((short)(n4 + 5));
            n4 = (short)(n4 + 1);
            sDKImpl.mLanguageEncodings[n2] = byArray[n10];
            int n11 = n4;
            n4 = (short)(n4 + 1);
            sDKImpl.mLanguageFontDifferentiator[n2] = byArray[n11];
            if (s <= 0) continue;
            if (sDKImpl.mChunkStringOffsets[0] == null) {
                sDKImpl.mChunkStringOffsets[0] = new short[sDKImpl.mNumLangs * n3];
            }
            for (n = 0; n < n3; ++n) {
                sDKImpl.mChunkStringOffsets[0][n2 * n3 + n] = sDKImpl.bytesToShort(byArray, n4);
                n4 = (short)(n4 + 2);
            }
        }
        if (s > 0) {
            n2 = sDKImpl.mChunkStringOffsets[0][sDKImpl.mNumLangs * n3 - 1];
            sDKImpl.mChunkStringData[0] = new byte[n2];
            Memory.Copy(sDKImpl.mChunkStringData[0], 0, byArray, n4, n2);
            n4 = (short)(n4 + n2);
        }
        for (n2 = 1; n2 < sDKImpl.mNumActualChunks; ++n2) {
            sDKImpl.mChunkFlags[n2] = (byte)(byArray[n4] & 0xC0);
            sDKImpl.mChunkGroup[n2] = (byte)(byArray[n4] & 0x3F);
            n4 = (short)(n4 + 1);
            sDKImpl.mNumStringsPerChunk[n2] = sDKImpl.bytesToShort(byArray, n4);
            n4 = (short)(n4 + 2);
            if (sDKImpl.mNumStringsPerChunk[n2] + 1 > sDKImpl.mGroupMaxNumOffsets[sDKImpl.mChunkGroup[n2]]) {
                sDKImpl.mGroupMaxNumOffsets[sDKImpl.mChunkGroup[n2]] = (short)(sDKImpl.mNumStringsPerChunk[n2] + 1);
            }
            for (n = 0; n < sDKImpl.mNumLangs; ++n) {
                sDKImpl.mChunkSize[n][n2] = sDKImpl.bytesToShort(byArray, n4);
                if ((sDKImpl.mChunkSize[n][n2] & 0xFFFF) > (sDKImpl.mGroupMaxSize[sDKImpl.mChunkGroup[n2]] & 0xFFFF)) {
                    sDKImpl.mGroupMaxSize[sDKImpl.mChunkGroup[n2]] = sDKImpl.mChunkSize[n][n2];
                }
                n4 = (short)(n4 + 2);
            }
        }
        if (sDKImpl.mLanguageEncodings[sDKImpl.mLangIndex] > 1) {
            sDKImpl.loadCharMap(sDKImpl.mLanguageEncodings[sDKImpl.mLangIndex]);
        }
        sDKImpl.mHdrLoaded = true;
        return sDKImpl.mNumLangs;
    }

    public static SDKString getHeaderString(int n, int n2, SDKString sDKString) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        if (n2 >= sDKImpl.mNumStringsPerChunk[0]) {
            return sDKString;
        }
        int n3 = n2 + (sDKImpl.mNumStringsPerChunk[0] + 1) * n;
        if (sDKString == null) {
            sDKString = new SDKString();
        } else if ((sDKString.mEncoding & 0x40) != 0) {
            sDKString.mPtr = null;
            sDKString.mPtr = null;
        }
        sDKString.mPtr = sDKImpl.mChunkStringData[0];
        sDKString.mOff = sDKImpl.mChunkStringOffsets[0][n3];
        sDKString.mCap = sDKString.mLen = sDKImpl.mChunkStringOffsets[0][n3 + 1] - sDKImpl.mChunkStringOffsets[0][n3] >> 1;
        sDKString.mEncoding = 0;
        return sDKString;
    }

    public static SDKString getString(int n, SDKString sDKString) {
        int n2;
        SDKImpl sDKImpl = SDKImpl.getInstance();
        int n3 = -1;
        int n4 = 0;
        for (n2 = 0; n2 < sDKImpl.mNumActualChunks; ++n2) {
            if (n >= (n4 += sDKImpl.mNumStringsPerChunk[n2])) continue;
            n3 = n2;
            break;
        }
        n2 = n - (n4 - sDKImpl.mNumStringsPerChunk[n3]);
        byte by = sDKImpl.mChunkGroup[n3];
        if (sDKString == null) {
            sDKString = new SDKString();
        } else if ((sDKString.mEncoding & 0x40) != 0) {
            sDKString.mPtr = null;
            sDKString.mPtr = null;
        }
        sDKString.mPtr = sDKImpl.mChunkStringData[by];
        sDKString.mOff = sDKImpl.mChunkStringOffsets[by][n2] & 0xFFFF;
        sDKString.mLen = (sDKImpl.mChunkStringOffsets[by][n2 + 1] & 0xFFFF) - (sDKImpl.mChunkStringOffsets[by][n2] & 0xFFFF);
        byte by2 = sDKImpl.mLanguageEncodings[sDKImpl.mLangIndex];
        if ((sDKImpl.mChunkFlags[n3] & 0xFFFFFFC1) != 0) {
            by2 = 0;
        }
        if (by2 == 0) {
            sDKString.mLen = (short)(sDKString.mLen >> 1);
        }
        sDKString.mEncoding = by2;
        sDKString.mCap = sDKString.mLen;
        return sDKString;
    }

    public static int getCurrentLanguage() {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        return sDKImpl.mLangIndex;
    }

    public static boolean setCurrentLanguage(int n) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        byte by = sDKImpl.mLangIndex;
        if (sDKImpl.mLanguageIsocodes != null && n >= 0 && n < sDKImpl.mNumLangs) {
            sDKImpl.mLangIndex = (byte)n;
        }
        if (sDKImpl.mLangIndex != by) {
            sDKImpl.mForceChunkLoad = true;
            for (int i = 1; i < sDKImpl.mNumActualChunks; ++i) {
                if (!SDKUtils.isLoadedStringsChunk(i) || (sDKImpl.mChunkFlags[i] & 0x40) != 0) continue;
                SDKUtils.loadStringsChunk(i);
            }
            sDKImpl.mForceChunkLoad = false;
            if (sDKImpl.mLanguageEncodings[sDKImpl.mLangIndex] != sDKImpl.mLanguageEncodings[by] && sDKImpl.mLanguageEncodings[sDKImpl.mLangIndex] > 1) {
                sDKImpl.loadCharMap(sDKImpl.mLanguageEncodings[sDKImpl.mLangIndex]);
            }
        }
        return sDKImpl.mLangIndex == n;
    }

    public static int getFontDifferentiator(int n) {
        return SDKImpl.getInstance().mLanguageFontDifferentiator[n];
    }

    public static void setGraphics(SDKGraphics sDKGraphics) {
        SDKImpl.getInstance().mGraphics = sDKGraphics;
    }

    public static long getRecordSizeAvailable() {
        return FlDataStore.GetInstance().GetSizeAvailable();
    }

    public static void saveRecord(int n, byte[] byArray) {
        FlDataStore.GetInstance().SaveByteArray(n, byArray, byArray.length);
        FlDataStore.GetInstance().Commit();
    }

    public static byte[] loadRecord(int n) {
        int n2 = FlDataStore.GetInstance().GetSize(n);
        if (n2 == -1) {
            return null;
        }
        byte[] byArray = new byte[n2];
        FlDataStore.GetInstance().LoadByteArray(n, byArray, n2);
        return byArray;
    }

    public static void removeRecord(int n) {
        FlDataStore.GetInstance().Remove(n);
        FlDataStore.GetInstance().Commit();
    }

    public static boolean isRecordEmpty(int n) {
        return !FlDataStore.GetInstance().Exists(n);
    }

    public static void debugLog(final String string, int n) {
        if (n >= SDKConfig.getDebugLevel() && SDKConfig.getDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.setLength(0);
            switch (n) {
                case 4: {
                    stringBuffer.append("E:");
                    break;
                }
                case 3: {
                    stringBuffer.append("W:");
                    break;
                }
                case 2: {
                    stringBuffer.append("S:");
                    break;
                }
                case 1: {
                    stringBuffer.append("I:");
                }
            }
            if (n >= 3) {
                UiApplication.getUiApplication().invokeLater(new Runnable(){

                    public void run() {
                        Dialog.alert((String)string);
                    }
                });
            }
            stringBuffer.append(string);
            System.out.println(stringBuffer.toString());
        }
    }

    public static long skipNative(InputStream inputStream, long l) throws IOException {
        return inputStream.skip(l);
    }

    public static int readBytesNative(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        return inputStream.read(byArray, n, n2);
    }

    public static int chooseLanguage(int n) {
        int n2;
        if (SDKImpl.getInstance().mLanguageIsocodes.length == 1) {
            return 0;
        }
        String string = SDKMIDlet.getAppProp("Force-Locale");
        int n3 = SDKImpl.getInstance().mLanguageIsocodes.length;
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = new String(SDKImpl.getInstance().mLanguageIsocodes[n2]);
        }
        if (n == -1) {
            int n4;
            n2 = 1;
            if (string == null) {
                n2 = 2;
            } else if ((string = string.toLowerCase().trim()).length() < 2) {
                n2 = 2;
            } else if (string.equals("menu")) {
                n2 = 1;
            } else if (string.startsWith("auto-")) {
                n2 = 3;
                string = string.substring(5);
            } else {
                n2 = 4;
            }
            for (n4 = 0; n4 < stringArray.length; ++n4) {
                if (stringArray[n4].length() <= 2) continue;
                String string2 = stringArray[n4].substring(0, 2);
                boolean bl = true;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (n4 == i || !stringArray[i].startsWith(string2)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                stringArray[n4] = string2;
            }
            if (n2 == 2 || n2 == 3 || n2 == 1) {
                n = SDKUtils.detectLanguage(stringArray);
                if (n2 == 1 && n > -1) {
                    n = -1 - n;
                }
            }
            if (n2 == 4 || n2 == 3 && n == -1) {
                for (n4 = 0; n4 < stringArray.length; ++n4) {
                    if (!string.startsWith(stringArray[n4])) continue;
                    n = n4;
                    break;
                }
            }
            if (n2 == 4 && n == -1) {
                n = SDKUtils.detectLanguage(stringArray);
            }
        }
        return n;
    }

    public static short bytesToShort(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    public static boolean platformRequest(String string) {
        return FlBrowser.GetInstance().LaunchURI(StringUtils.CreateString(StringUtils.ToRawString(StringUtils.CreateString(new String(string)))), true);
    }

    public static SDKImage createImage(int n, int n2) {
        SDKImage sDKImage = new SDKImage(n, n2);
        return sDKImage;
    }

    public static SDKImage createImage(byte[] byArray, int n, int n2) {
        SDKImage sDKImage = new SDKImage(byArray, n, n2);
        return sDKImage;
    }

    public static SDKImage createImage(String string) throws IOException {
        SDKImage sDKImage = new SDKImage(string);
        if (sDKImage.mBitmap.getImage() == null) {
            throw new IOException("Error creating SDKImage from a file path.");
        }
        return sDKImage;
    }

    public static SDKImage createImage(SDKInputStream sDKInputStream) throws IOException {
        SDKImage sDKImage = null;
        byte[] byArray = new byte[sDKInputStream.getLength()];
        sDKInputStream.read(byArray, 0, sDKInputStream.getLength());
        sDKImage = new SDKImage(byArray, 0, byArray.length);
        byArray = null;
        return sDKImage;
    }

    public static SDKImage createImage(InputStream inputStream) throws IOException {
        SDKImage sDKImage = null;
        sDKImage = new SDKImage();
        sDKImage.init(Image.createImage((InputStream)inputStream));
        return sDKImage;
    }

    public static SDKImage createImage(SDKImage sDKImage, int n, int n2, int n3, int n4, int n5) {
        SDKImage sDKImage2 = new SDKImage();
        sDKImage2.init(sDKImage);
        FlBitmapImplementor flBitmapImplementor = (FlBitmapImplementor)sDKImage2.mBitmap;
        flBitmapImplementor.mImage = Image.createImage((Image)flBitmapImplementor.mImage, (int)n, (int)n2, (int)n3, (int)n4, (int)n5);
        flBitmapImplementor.mDataWidth = (short)flBitmapImplementor.mImage.getWidth();
        flBitmapImplementor.mDataHeight = (short)flBitmapImplementor.mImage.getHeight();
        return sDKImage2;
    }

    public static SDKImage createRGBImage(int[] nArray, int n, int n2, int n3) {
        SDKImage sDKImage = new SDKImage(n, n2);
        sDKImage.initWithRGBData(nArray, n, n2, n3);
        return sDKImage;
    }

    public static SDKImage createRGBImage(Object object, int n, int n2, int n3) {
        return SDKUtils.createRGBImage((int[])object, n, n2, n3);
    }

    public static SDKGraphics createGraphics() {
        return new SDKGraphics();
    }

    public static Object loadFontInternal(Object object, byte[] byArray, int n) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        Object[] objectArray = sDKImpl.loadFontChunk(byArray);
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[]{object, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], new Integer(n)};
        return objectArray2;
    }

    public static void setFontImageInternal(Object object, int n) {
        SDKImpl sDKImpl = SDKImpl.getInstance();
        sDKImpl.mSdkFont.mFontData = null;
        sDKImpl.mSdkFont.mImage = object;
        sDKImpl.mSdkFont.mScanLength = n;
        sDKImpl.mSdkFont.mFontData = new Object[]{sDKImpl.mSdkFont.mImage, sDKImpl.mSdkFont.mProps, sDKImpl.mSdkFont.mUTFCodes, sDKImpl.mSdkFont.mISOOffsetMap, sDKImpl.mSdkFont.mCharOffsets, sDKImpl.mSdkFont.mCharAndGlyphData, sDKImpl.mSdkFont.mColorPalette, new Integer(sDKImpl.mSdkFont.mScanLength)};
    }

    public static void nativeSetFont(SDKGraphics sDKGraphics, Object object) {
        sDKGraphics.pd.NativeSetFont(object);
    }

    public static void nativeDrawString(SDKGraphics sDKGraphics, String string, int n, int n2, int n3) {
        sDKGraphics.pd.NativeDrawString(string, n, n2, n3);
    }

    public static byte detectLanguage(String[] stringArray) {
        int n = -1;
        String string = System.getProperty("microedition.locale");
        if (string != null) {
            int n2 = (string = string.toLowerCase().trim()).length();
            if (n2 < 2) {
                return -1;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() > n2 && stringArray[i].startsWith(string)) {
                    n = -1;
                    break;
                }
                if (!string.startsWith(stringArray[i])) continue;
                n = (byte)i;
                break;
            }
        }
        return (byte)n;
    }

    public static SDKUtils[] InstArraySDKUtils(int n) {
        SDKUtils[] sDKUtilsArray = new SDKUtils[n];
        for (int i = 0; i < n; ++i) {
            sDKUtilsArray[i] = new SDKUtils();
        }
        return sDKUtilsArray;
    }

    public static SDKUtils[][] InstArraySDKUtils(int n, int n2) {
        SDKUtils[][] sDKUtilsArray = new SDKUtils[n][];
        for (int i = 0; i < n; ++i) {
            sDKUtilsArray[i] = new SDKUtils[n2];
            for (int j = 0; j < n2; ++j) {
                sDKUtilsArray[i][j] = new SDKUtils();
            }
        }
        return sDKUtilsArray;
    }

    public static SDKUtils[][][] InstArraySDKUtils(int n, int n2, int n3) {
        SDKUtils[][][] sDKUtilsArray = new SDKUtils[n][][];
        for (int i = 0; i < n; ++i) {
            sDKUtilsArray[i] = new SDKUtils[n2][];
            for (int j = 0; j < n2; ++j) {
                sDKUtilsArray[i][j] = new SDKUtils[n3];
                for (int k = 0; k < n3; ++k) {
                    sDKUtilsArray[i][j][k] = new SDKUtils();
                }
            }
        }
        return sDKUtilsArray;
    }
}

