/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlString;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.TimeData;

public class TimeUtils {
    public static TimeData GetTime() {
        TimeData timeData = new TimeData();
        return timeData;
    }

    public static int GetHour(TimeData timeData) {
        return timeData.GetHour();
    }

    public static int GetMin(TimeData timeData) {
        return timeData.GetMin();
    }

    public static int GetSec(TimeData timeData) {
        return timeData.GetSec();
    }

    public static int GetYear(TimeData timeData) {
        return timeData.GetYear();
    }

    public static int GetMonth(TimeData timeData) {
        return timeData.GetMonth();
    }

    public static int GetDay(TimeData timeData) {
        return timeData.GetDay();
    }

    public static FlString Get12HourFormat(TimeData timeData, boolean bl, short s) {
        int n = timeData.GetHour();
        boolean bl2 = true;
        if (n > 12) {
            bl2 = false;
            n -= 12;
        }
        FlString flString = new FlString(n);
        flString.AddAssign(FlString.FromChar(s));
        int n2 = timeData.GetMin();
        if (n2 < 10) {
            flString.AddAssign(new FlString(0));
        }
        flString.AddAssign(new FlString(n2));
        if (bl) {
            flString.AddAssign(FlString.FromChar(s));
            int n3 = timeData.GetSec();
            if (n3 < 10) {
                flString.AddAssign(new FlString(0));
            }
            flString.AddAssign(new FlString(n3));
        }
        if (bl2) {
            flString.AddAssign(StringUtils.CreateString("am"));
        } else {
            flString.AddAssign(StringUtils.CreateString("pm"));
        }
        return flString;
    }

    public static FlString Get24HourFormat(TimeData timeData, boolean bl, short s) {
        FlString flString = new FlString(timeData.GetHour());
        flString.AddAssign(FlString.FromChar(s));
        int n = timeData.GetMin();
        if (n < 10) {
            flString.AddAssign(new FlString(0));
        }
        flString.AddAssign(new FlString(n));
        if (bl) {
            flString.AddAssign(FlString.FromChar(s));
            int n2 = timeData.GetSec();
            if (n2 < 10) {
                flString.AddAssign(new FlString(0));
            }
            flString.AddAssign(new FlString(n2));
        }
        return flString;
    }

    public static boolean IsDateValid(int n, int n2, int n3) {
        TimeData timeData = new TimeData(n2, n3, n);
        return timeData.IsDateValid();
    }

    public static int GetElapsedDays(TimeData timeData) {
        TimeData timeData2 = new TimeData();
        int n = TimeUtils.GetJulianDayNumber(timeData2);
        int n2 = TimeUtils.GetJulianDayNumber(timeData);
        return n - n2;
    }

    public static int GetElapsedYears(TimeData timeData) {
        int n = 0;
        TimeData timeData2 = new TimeData();
        n = timeData2.GetYear() - timeData.GetYear() - 1;
        if (timeData.GetMonth() < timeData2.GetMonth()) {
            ++n;
        } else if (timeData.GetMonth() == timeData2.GetMonth() && timeData.GetDay() <= timeData2.GetDay()) {
            ++n;
        }
        return n;
    }

    public static int GetJulianDayNumber(TimeData timeData) {
        int n = timeData.GetMonth();
        int n2 = timeData.GetYear();
        if (n < 3) {
            n += 12;
            --n2;
        }
        return timeData.GetDay() + (153 * n - 457) / 5 + 365 * n2 + n2 / 4 + 1721116;
    }

    public static FlString Get12HourFormat(TimeData timeData) {
        return TimeUtils.Get12HourFormat(timeData, false);
    }

    public static FlString Get12HourFormat(TimeData timeData, boolean bl) {
        return TimeUtils.Get12HourFormat(timeData, bl, (short)58);
    }

    public static FlString Get24HourFormat(TimeData timeData) {
        return TimeUtils.Get24HourFormat(timeData, false);
    }

    public static FlString Get24HourFormat(TimeData timeData, boolean bl) {
        return TimeUtils.Get24HourFormat(timeData, bl, (short)58);
    }

    public static TimeUtils[] InstArrayTimeUtils(int n) {
        TimeUtils[] timeUtilsArray = new TimeUtils[n];
        for (int i = 0; i < n; ++i) {
            timeUtilsArray[i] = new TimeUtils();
        }
        return timeUtilsArray;
    }

    public static TimeUtils[][] InstArrayTimeUtils(int n, int n2) {
        TimeUtils[][] timeUtilsArray = new TimeUtils[n][];
        for (int i = 0; i < n; ++i) {
            timeUtilsArray[i] = new TimeUtils[n2];
            for (int j = 0; j < n2; ++j) {
                timeUtilsArray[i][j] = new TimeUtils();
            }
        }
        return timeUtilsArray;
    }

    public static TimeUtils[][][] InstArrayTimeUtils(int n, int n2, int n3) {
        TimeUtils[][][] timeUtilsArray = new TimeUtils[n][][];
        for (int i = 0; i < n; ++i) {
            timeUtilsArray[i] = new TimeUtils[n2][];
            for (int j = 0; j < n2; ++j) {
                timeUtilsArray[i][j] = new TimeUtils[n3];
                for (int k = 0; k < n3; ++k) {
                    timeUtilsArray[i][j][k] = new TimeUtils();
                }
            }
        }
        return timeUtilsArray;
    }
}

