/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BlString;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Memory;

public class StringUtils {
    public static FlString CreateString(String string) {
        char[] cArray = string.toCharArray();
        short[] sArray = new short[cArray.length + 1];
        for (int i = 0; i < cArray.length; ++i) {
            sArray[i] = (short)cArray[i];
        }
        sArray[sArray.length - 1] = 0;
        return new FlString(sArray);
    }

    public static FlString CreateStringPtr(String string) {
        return StringUtils.CreateString(string);
    }

    public static FlString CreateString(short[] sArray) {
        FlString flString = new FlString(sArray);
        return flString;
    }

    public static FlString CreateString(FlString flString) {
        return flString;
    }

    public static FlString CreateString(BlString blString) {
        String string = new String(blString.ToUtf16());
        FlString flString = new FlString(string);
        return flString;
    }

    public static FlString CreateStringPtr(short[] sArray) {
        return new FlString(sArray);
    }

    public static FlString CreateFromANSIString(byte[] byArray, int n, int n2) {
        short[] sArray = new short[n + 1];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)Memory.MakeUnsignedByte(byArray[n2 + i]);
        }
        sArray[n] = 0;
        FlString flString = new FlString(sArray);
        sArray = null;
        return flString;
    }

    public static short[] ToRawString(FlString flString) {
        return flString.ToRawString();
    }

    public static FlString StringAdd(FlString flString, short[] sArray) {
        return flString.Add(sArray);
    }

    public static int StringLen(short[] sArray) {
        int n = 0;
        while (sArray[n] != 0) {
            ++n;
        }
        return n;
    }

    public static void StringNCopy(short[] sArray, short[] sArray2, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            sArray[n + i] = sArray2[n2 + i];
            if (sArray2[n2 + i] == 0) break;
        }
    }

    public static void StringNCopy(short[] sArray, short[] sArray2, int n) {
        StringUtils.StringNCopy(sArray, sArray2, 0, 0, n);
    }

    public static void StringCopy(short[] sArray, short[] sArray2) {
        int n = 0;
        while ((sArray[n] = sArray2[n]) != 0) {
            ++n;
        }
    }

    public static void StringCat(short[] sArray, short[] sArray2) {
        StringUtils.StringNCopy(sArray, sArray2, StringUtils.StringLen(sArray), 0, StringUtils.StringLen(sArray2) + 1);
    }

    public static void StringCat(FlString flString, short[] sArray) {
        flString.AddAssign(sArray);
    }

    public static int StringLong(short[] sArray, int n) {
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        int n2 = 16;
        sArray[--n2] = 0;
        do {
            sArray[--n2] = (short)(48 + n % 10);
        } while ((n /= 10) != 0);
        if (bl) {
            sArray[--n2] = 45;
        }
        return n2;
    }

    public static int StringLongLong(short[] sArray, long l) {
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        int n = 32;
        sArray[--n] = 0;
        do {
            sArray[--n] = (short)(48L + l % 10L);
        } while ((l /= 10L) != 0L);
        if (bl) {
            sArray[--n] = 45;
        }
        return n;
    }

    public static int StringCmp(short[] sArray, short[] sArray2) {
        return StringUtils.StringNCmp(sArray, sArray2, -1);
    }

    public static int StringNCmp(short[] sArray, short[] sArray2, int n) {
        short s = 0;
        short s2 = 0;
        for (int i = 0; n < 0 || i < n; ++i) {
            s = sArray[i];
            s2 = sArray2[i];
            if (s == s2 && s != 0) continue;
            return s - s2;
        }
        return s - s2;
    }

    public static int StringChr(short[] sArray, int n, short s) {
        do {
            if (sArray[n] != s) continue;
            return n;
        } while (sArray[n++] != 0);
        return -1;
    }

    public static int StringRChr(short[] sArray, short s) {
        int n = StringUtils.StringLen(sArray);
        if (n == 0) {
            return 0;
        }
        int n2 = n - 1;
        do {
            if (sArray[n2] != s) continue;
            return n2;
        } while (--n2 >= 0);
        return -1;
    }

    public static short[] StringDuplicate(short[] sArray) {
        short[] sArray2 = new short[StringUtils.StringLen(sArray) + 1];
        StringUtils.StringCopy(sArray2, sArray);
        return sArray2;
    }

    public static int StringFindSubstring(short[] sArray, short[] sArray2) {
        return StringUtils.StringFindSubstring(sArray, sArray2, 0);
    }

    public static int StringFindSubstring(short[] sArray, short[] sArray2, int n) {
        int n2 = -1;
        int n3 = 0;
        if (sArray2[n3] == 0) {
            return 0;
        }
        if (n != 0 && n >= StringUtils.StringLen(sArray)) {
            return -1;
        }
        int n4 = n;
        while (sArray[n4] != 0) {
            if (sArray[n4] == sArray2[n3]) {
                n2 = n4;
                do {
                    if (sArray2[n3] != 0) continue;
                    return n4;
                } while (sArray[n2++] == sArray2[n3++]);
                n3 = 0;
            }
            ++n4;
        }
        return -1;
    }

    public static void ChangePathSeparator(short[] sArray) {
        int n = 92;
        int n2 = StringUtils.StringLen(sArray);
        for (int i = 0; i < n2; ++i) {
            if (sArray[i] != 47 && sArray[i] != 92) continue;
            sArray[i] = n;
        }
    }

    public static boolean IsReservedURLCharacter(short s) {
        boolean bl = false;
        switch (s) {
            case 36: 
            case 38: 
            case 43: 
            case 44: 
            case 47: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: {
                bl = true;
            }
        }
        return bl;
    }

    public static boolean IsUnsafeURLCharacter(short s) {
        boolean bl;
        boolean bl2 = bl = s <= 31 || s >= 127;
        if (!bl) {
            switch (s) {
                case 32: 
                case 34: 
                case 35: 
                case 37: 
                case 60: 
                case 62: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 96: 
                case 123: 
                case 124: 
                case 125: 
                case 126: {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static boolean IsValidURL(FlString flString) {
        boolean bl = true;
        for (int i = 0; i < flString.GetLength(); ++i) {
            short s = flString.GetCharAt(i);
            if (s == 37 || !StringUtils.IsUnsafeURLCharacter(s)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static short ToHexDigit(short s) {
        FlString flString = new FlString(StringUtils.CreateString("0123456789abcdef"));
        return flString.GetCharAt(s & 0xF);
    }

    public static short FromHexDigit(short s) {
        FlString flString = new FlString(StringUtils.CreateString("0123456789abcdef"));
        if (s >= 65 && s <= 90) {
            s = (short)(s - 65 + 97);
        }
        return (short)flString.FindChar(s);
    }

    public static FlString EncodeURL(FlString flString, boolean bl) {
        FlString flString2 = new FlString();
        short[] sArray = StringUtils.ToRawString(flString);
        int n = FlString.GetUtf8EncodedDataSize(sArray);
        byte[] byArray = new byte[n];
        FlString.ConvertCharToUtf8(sArray, byArray);
        for (int i = 0; i < n - 1; ++i) {
            short s = byArray[i];
            if (StringUtils.IsUnsafeURLCharacter(s) || bl && StringUtils.IsReservedURLCharacter(s)) {
                flString2.InsertCharAt(flString2.GetLength(), (short)37);
                flString2.InsertCharAt(flString2.GetLength(), StringUtils.ToHexDigit((short)((s & 0xF0) / 16)));
                flString2.InsertCharAt(flString2.GetLength(), StringUtils.ToHexDigit((short)(s & 0xF)));
                continue;
            }
            flString2.InsertCharAt(flString2.GetLength(), s);
        }
        byArray = null;
        return flString2;
    }

    public static FlString DecodeURL(FlString flString) {
        int n = flString.GetLength();
        byte[] byArray = new byte[flString.GetLength() + 1];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            short s = flString.GetCharAt(i);
            if (s == 37 && i <= n - 3) {
                short s2 = (short)(StringUtils.FromHexDigit(flString.GetCharAt(i + 1)) * 16 + StringUtils.FromHexDigit(flString.GetCharAt(i + 2)));
                byArray[n2] = (byte)s2;
                i += 2;
            } else {
                byArray[n2] = (byte)s;
            }
            ++n2;
        }
        byArray[n2] = 0;
        FlString flString2 = new FlString(FlString.DecodeUTF8(byArray));
        byArray = null;
        return flString2;
    }

    public static FlString ToLowerCase(FlString flString) {
        FlString flString2 = new FlString(flString);
        int n = flString2.GetLength();
        for (int i = 0; i < n; ++i) {
            short s = flString2.GetCharAt(i);
            if (s < 65 || s > 90) continue;
            flString2.ReplaceCharAt(i, (short)(s - 65 + 97));
        }
        return flString2;
    }

    public static int StringAtoI(short[] sArray) {
        return Integer.parseInt(StringUtils.CreateJavaString(StringUtils.CreateString(sArray)));
    }

    public static long StringAtoLL(short[] sArray) {
        return Long.parseLong(StringUtils.CreateJavaString(StringUtils.CreateString(sArray)));
    }

    public static String CreateJavaString(FlString flString) {
        return StringUtils.CreateJavaString(flString, 0, flString.GetLength());
    }

    public static String CreateJavaString(FlString flString, int n, int n2) {
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)flString.GetCharAt(n++);
        }
        return new String(cArray);
    }

    public static int StringToBytes(String string, byte[] byArray, int n) {
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            byArray[n++] = (byte)(c >>> 8);
            byArray[n++] = (byte)(c & 0xFF);
        }
        return n;
    }

    public static FlString CreateFromANSIString(byte[] byArray, int n) {
        return StringUtils.CreateFromANSIString(byArray, n, 0);
    }

    public static FlString EncodeURL(FlString flString) {
        return StringUtils.EncodeURL(flString, true);
    }

    public static StringUtils[] InstArrayStringUtils(int n) {
        StringUtils[] stringUtilsArray = new StringUtils[n];
        for (int i = 0; i < n; ++i) {
            stringUtilsArray[i] = new StringUtils();
        }
        return stringUtilsArray;
    }

    public static StringUtils[][] InstArrayStringUtils(int n, int n2) {
        StringUtils[][] stringUtilsArray = new StringUtils[n][];
        for (int i = 0; i < n; ++i) {
            stringUtilsArray[i] = new StringUtils[n2];
            for (int j = 0; j < n2; ++j) {
                stringUtilsArray[i][j] = new StringUtils();
            }
        }
        return stringUtilsArray;
    }

    public static StringUtils[][][] InstArrayStringUtils(int n, int n2, int n3) {
        StringUtils[][][] stringUtilsArray = new StringUtils[n][][];
        for (int i = 0; i < n; ++i) {
            stringUtilsArray[i] = new StringUtils[n2][];
            for (int j = 0; j < n2; ++j) {
                stringUtilsArray[i][j] = new StringUtils[n3];
                for (int k = 0; k < n3; ++k) {
                    stringUtilsArray[i][j][k] = new StringUtils();
                }
            }
        }
        return stringUtilsArray;
    }
}

