/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.FlAppProperties;
import ca.jamdat.flight.FlKeyManager;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.J2MEApp;
import ca.jamdat.flight.Memory;
import ca.jamdat.flight.SoundManager;
import ca.jamdat.flight.SpecConstants;
import ca.jamdat.flight.StringUtils;
import ca.jamdat.flight.VideoMode;
import ca.jamdat.fuser.Constants;

public abstract class FlApplication {
    public static final byte ExitTypeNow = 0;
    public static final byte ExitTypeSoon = 1;
    public static final byte TimeFormat12H = 0;
    public static final byte TimeFormat24H = 1;
    public static final byte gameOrientationCurrent = 0;
    public static final byte gameOrientation0 = 1;
    public static final byte gameOrientation90 = 2;
    public static final byte gameOrientation180 = 4;
    public static final byte gameOrientation270 = 8;
    public static final byte gameOrientationSystem = 16;
    public static final byte softKeyPositionError = 0;
    public static final byte softKeyPositionLeft = 1;
    public static final byte softKeyPositionRight = 2;
    public static final byte softKeyPositionBottom = 16;
    public static final byte softKeyPositionTop = 32;
    public static final byte softKeyPositionBottomLeft = 17;
    public static final byte softKeyPositionBottomRight = 18;
    public static final byte softKeyPositionTopLeft = 33;
    public static final byte softKeyPositionTopRight = 34;
    public static final byte defaultGamingKeyPrimary = 0;
    public static final byte defaultGamingKeySecondary = 1;
    public static final byte playViewDefault = 0;
    public static final byte playViewDeck = 1;
    public static final byte playViewGames = 2;
    public static final byte playViewProfile = 3;
    public static final byte playViewFriends = 4;
    public static final byte playViewShowRoom = 5;
    public static final byte playViewArena = 6;
    public static final byte initialTime = 0;
    public static final byte lastSuspendTime = 1;
    public static final byte lastLong64 = 2;
    public long[] mLong64Array = null;
    public int mSupportedOrientations;
    public boolean mIsSuspended;
    public boolean mHasFocus = true;
    public boolean mDirty = true;
    public boolean mExitProcessed;
    public int mLastKeyDown = 0;
    public short[] mKeyMap = new short[73];
    public int mKeyRepeatTime;
    public boolean mIgnoreSecondKeyDown = true;
    public short[] mKeyGroupState = new short[73];
    static final int mMinFrameTimeMs = 1000 / SpecConstants.GetFlightFrameLimiterMaxFps();

    public void destruct() {
        FrameworkGlobals.GetInstance().mFlDataStore = null;
        FrameworkGlobals.GetInstance().mFlKeyManager = null;
        FrameworkGlobals.GetInstance().mFlPowerManager = null;
        FrameworkGlobals.GetInstance().mBlGlobal = null;
        FrameworkGlobals.GetInstance().mFlBrowser = null;
        this.mLong64Array = null;
    }

    public void FocusLost() {
    }

    public void FocusGained() {
    }

    public boolean QuitRequest() {
        return true;
    }

    public void SaveGame() {
    }

    public void Suspend() {
    }

    public void Resume() {
    }

    public void OnScreenSizeChange() {
    }

    public void OnSliderChange(boolean bl) {
    }

    public void OnMasterVolumeChange(short s) {
    }

    public void OnFrameLimit(int n) {
        int n2 = mMinFrameTimeMs - n;
        try {
            Thread.sleep(n2 < 1 ? 1L : (long)n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public short GetGameLanguage() {
        return 11;
    }

    public abstract void OnKeyDown(int var1);

    public abstract void OnKeyUp(int var1);

    public abstract void OnKeyRepeat(int var1);

    public abstract void OnExit();

    public abstract void OnTime(int var1, int var2);

    public static FlApplication GetInstance() {
        return FrameworkGlobals.GetInstance().application;
    }

    public static FlString GetJamdatBuildString() {
        FlString flString = new FlString(FlApplication.GetVersionString());
        return flString;
    }

    public static void Kill() {
    }

    public static boolean MemoryCardWasRemoved() {
        return false;
    }

    public static void Exit() {
        FlApplication.ProcessExit();
        FlApplication.OSExit();
    }

    public static void ProcessExit() {
        FlApplication flApplication = FlApplication.GetInstance();
        if (!flApplication.mExitProcessed) {
            flApplication.mExitProcessed = true;
        }
    }

    public static boolean HasExited() {
        return FlApplication.GetInstance().mExitProcessed;
    }

    public static FlString GetTitle() {
        return new FlString();
    }

    public static FlString GetDir() {
        return new FlString();
    }

    public static FlString GetDataDir() {
        return new FlString();
    }

    public static FlString GetExternalStorageDir() {
        return new FlString();
    }

    public static boolean IsExternalStorageReadable() {
        return false;
    }

    public static void DisplayMessage(FlString flString) {
    }

    public static byte GetMajorVersion() {
        return (byte)Constants.ApplicationMajorVersion();
    }

    public static byte GetMinorVersion() {
        return (byte)Constants.ApplicationMinorVersion();
    }

    public static short GetBuildVersion() {
        return (byte)Constants.ApplicationBuildVersion();
    }

    public static FlString GetVersionString() {
        FlString flString = new FlString(StringUtils.CreateString("."));
        FlString flString2 = new FlString(FlApplication.GetMajorVersion());
        flString2.AddAssign(flString);
        flString2.AddAssign(new FlString(FlApplication.GetMinorVersion()));
        flString2.AddAssign(flString);
        flString2.AddAssign(new FlString(FlApplication.GetBuildVersion()));
        return flString2;
    }

    public static FlString GetDeviceID() {
        return FlApplication.GetPropertyValue(StringUtils.CreateString("DeviceID"));
    }

    public static FlString GetCarrierID() {
        return FlApplication.GetPropertyValue(StringUtils.CreateString("CarrierID"));
    }

    public static FlString GetPlatformID() {
        return StringUtils.CreateString("3");
    }

    public static FlString GetHardwareKeyString() {
        FlString flString = new FlString(StringUtils.CreateString(","));
        FlString flString2 = new FlString(FlApplication.GetCarrierID());
        if (flString2.Equals(StringUtils.CreateString("9999"))) {
            return StringUtils.CreateString("1,2,390");
        }
        return flString2.Add(flString).Add(FlApplication.GetPlatformID()).Add(flString).Add(FlApplication.GetDeviceID());
    }

    public static short GetTCPPort() {
        return (short)FlApplication.GetPropertyValue(StringUtils.CreateString("TCPPort")).ToLong();
    }

    public static FlString GetServerAddr() {
        return FlApplication.GetPropertyValue(StringUtils.CreateString("ServerAddr"));
    }

    public static FlString GetPropertyValue(FlString flString) {
        FlAppProperties flAppProperties = new FlAppProperties();
        flAppProperties.Load();
        return flAppProperties.GetValue(flString);
    }

    public boolean IsPropertySet(FlString flString) {
        return flString.GetLength() > 0 && !flString.Equals(StringUtils.CreateString("NULL"));
    }

    public void SetOSWaitCursorVisible(boolean bl) {
    }

    public void SetDpadDisable(boolean bl) {
    }

    public void SetDirty(boolean bl) {
        this.mDirty = bl;
    }

    public boolean IsDirty() {
        return this.mDirty;
    }

    public void SendQuitRequestMsg() {
        this.OnExit();
    }

    public void SetIsSuspended(boolean bl) {
        this.mIsSuspended = bl;
    }

    public boolean GetIsSuspended() {
        return this.mIsSuspended;
    }

    public void SetHasFocus(boolean bl) {
        this.mHasFocus = bl;
    }

    public boolean HasFocus() {
        return this.mHasFocus;
    }

    public void SetFrameRate(short s) {
    }

    public void ReturnToOSGameMenu() {
    }

    public void OnKeyFromOS(int n, boolean bl) {
        switch (n) {
            case 0: {
                return;
            }
            case 12: {
                if (!bl) {
                    SoundManager.DecMasterVolume();
                }
                return;
            }
            case 11: {
                if (!bl) {
                    SoundManager.IncMasterVolume();
                }
                return;
            }
        }
        int n2 = this.GetTranslatedKey(n);
        short s = this.mKeyMap[n2];
        short s2 = this.mKeyGroupState[s];
        if (bl) {
            if (s2 == n) {
                this.mKeyGroupState[s] = 0;
                if (this.mLastKeyDown == n) {
                    this.mLastKeyDown = 0;
                }
                this.SendKeyUpMsg(n2);
            } else if (this.mIgnoreSecondKeyDown) {
                this.OnKeyFromOS(s2, true);
            }
        } else if (s2 != 0) {
            if (s == 0 || this.GetTranslatedKey(s2) != n2) {
                this.OnKeyFromOS(s2, true);
                if (!this.mIgnoreSecondKeyDown) {
                    this.OnKeyFromOS(n, false);
                }
            }
        } else {
            this.mKeyGroupState[s] = (short)n;
            this.mLastKeyDown = n;
            this.mKeyRepeatTime = Integer.MAX_VALUE;
            this.SendKeyDownMsg(n2);
        }
    }

    public void SendKeyUpToLastKeyDown() {
        for (int i = 0; i < 73; ++i) {
            this.OnKeyFromOS(this.mKeyGroupState[i], true);
        }
    }

    public boolean KeyIsDown(int n) {
        return this.GetTranslatedKey(this.mKeyGroupState[this.mKeyMap[n]]) == n;
    }

    public void MapKey(int n, int n2) {
        this.ResetDownKeys();
        this.mKeyMap[n] = (short)n2;
    }

    public void ResetDownKeys() {
        Memory.Set(this.mKeyGroupState, 0, 73);
        this.mLastKeyDown = 0;
    }

    public int GetTranslatedKey(int n) {
        if (this.mKeyMap[n] != 0) {
            n = this.mKeyMap[n];
        }
        return n;
    }

    public void UpdateSoftKey(int n, FlString flString) {
        J2MEApp.instance.GetCurrentScene().updateSoftKey(n, StringUtils.CreateJavaString(flString));
    }

    public int GetDefaultGamingKey(byte by, byte by2) {
        return 0;
    }

    public byte GetSoftKeyPosition(int n, byte by) {
        return 0;
    }

    public boolean IsNativeResolution(int n, int n2) {
        DisplayManager.GetInstance();
        VideoMode videoMode = new VideoMode(DisplayManager.GetVideoMode());
        return videoMode.GetWidth() == n && videoMode.GetHeight() == n2;
    }

    public int GetAllowedOrientations() {
        return 0;
    }

    public int GetAllowedNativeOrientations() {
        return 0;
    }

    public byte GetCurrentGameOrientation() {
        return 0;
    }

    public boolean SetGameOrientation(byte by, boolean bl) {
        return true;
    }

    public void SetSupportedGameOrientations(int n) {
        this.mSupportedOrientations = n;
    }

    public int GetSupportedGameOrientations() {
        return this.mSupportedOrientations;
    }

    public boolean GetIsSystemSelectedOrientation() {
        return true;
    }

    public void Invalidate() {
        this.SetDirty(true);
    }

    public void OnFocusLostFromOS() {
        if (this.HasFocus()) {
            this.SetHasFocus(false);
            this.Invalidate();
            this.ReleaseAllInput();
            this.FocusLost();
        }
    }

    public void OnFocusGainedFromOS() {
        if (!this.HasFocus()) {
            this.SetHasFocus(true);
            this.Invalidate();
            this.FocusGained();
        }
    }

    public void OnSuspendFromOS() {
        if (!this.GetIsSuspended()) {
            this.SetIsSuspended(true);
            this.mLong64Array[1] = FlApplication.GetRealTime();
            this.Suspend();
        }
    }

    public void OnResumeFromOS() {
        if (this.GetIsSuspended()) {
            this.SetIsSuspended(false);
            this.mLong64Array[0] = this.mLong64Array[0] + (FlApplication.GetRealTime() - this.mLong64Array[1]);
            this.mLong64Array[1] = 0L;
            this.Resume();
        }
    }

    public void ReleaseAllInput() {
        this.SendKeyUpToLastKeyDown();
    }

    public void Iteration(int n, int n2) {
        int n3 = this.mLastKeyDown;
        int n4 = this.mKeyRepeatTime;
        if (n3 != 0) {
            if (n4 == Integer.MAX_VALUE) {
                n4 = -350;
            } else if ((n4 += n2) > 150) {
                this.SendKeyRepeatMsg(this.GetTranslatedKey(n3));
                n4 = 0;
            }
        }
        this.mKeyRepeatTime = n4;
        this.OnTime(n, n2);
    }

    public byte GetTimeFormat() {
        return 1;
    }

    public FlString[] GetCommandLineArgs() {
        return null;
    }

    public int GetCommandLineArgsCount() {
        return 0;
    }

    public boolean GetGameKeyAltMode() {
        return FlKeyManager.GetInstance().GetGameKeyAltMode();
    }

    public void SetGameKeyAltMode(boolean bl) {
        FlKeyManager.GetInstance().SetGameKeyAltMode(bl);
    }

    public static long GetRunTime() {
        if (FlApplication.GetInstance().GetIsSuspended()) {
            return FlApplication.GetInstance().mLong64Array[1] - FlApplication.GetInstance().mLong64Array[0];
        }
        return FlApplication.GetRealTime() - FlApplication.GetInstance().mLong64Array[0];
    }

    public static long GetRealTime() {
        return System.currentTimeMillis();
    }

    public static String GetPropertyValue(String string) {
        FlAppProperties flAppProperties = new FlAppProperties();
        flAppProperties.Load();
        return flAppProperties.GetValue(string);
    }

    public void SetIgnoreSecondKeyDown(boolean bl) {
        this.mIgnoreSecondKeyDown = bl;
    }

    public void SetSingleKeyPress() {
        this.ResetDownKeys();
        for (short s = 0; s < 73; s = (short)(s + 1)) {
            if (this.mKeyMap[s] != s) continue;
            this.mKeyMap[s] = 0;
        }
    }

    public void SetMultiKeyPress() {
        this.ResetDownKeys();
        for (int n = 0; n < 73; n = (int)((short)(n + 1))) {
            if (this.mKeyMap[n] != 0) continue;
            this.mKeyMap[n] = n;
        }
    }

    public void OnDraw(DisplayContext displayContext) {
    }

    public FlApplication() {
        FrameworkGlobals.GetInstance().application = this;
        FlKeyManager.GetInstance();
        this.mLong64Array = new long[2];
        this.mLong64Array[0] = FlApplication.GetRealTime();
        this.mLong64Array[1] = 0L;
        this.SetSupportedGameOrientations(15);
    }

    public static void OSExit() {
        J2MEApp.instance.OSExit();
    }

    public void SendKeyDownMsg(int n) {
        this.OnKeyDown(n);
    }

    public void SendKeyUpMsg(int n) {
        this.OnKeyUp(n);
    }

    public void SendKeyRepeatMsg(int n) {
        this.OnKeyRepeat(n);
    }

    public int GetDefaultGamingKey(byte by) {
        return this.GetDefaultGamingKey(by, (byte)0);
    }

    public byte GetSoftKeyPosition(int n) {
        return this.GetSoftKeyPosition(n, (byte)0);
    }

    public boolean SetGameOrientation(byte by) {
        return this.SetGameOrientation(by, true);
    }
}

