/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.Entity;
import com.ea.game.GameArray;
import com.ea.game.GameConstants;
import com.ea.game.GameImpl;
import com.ea.game.IStringConstants;
import com.ea.game.Level;
import com.ea.sdk.SDKInputStream;
import java.io.IOException;

public class Trigger
implements Constants,
IStringConstants,
GameConstants {
    public boolean _active;
    public byte _type;
    public short _level_id;
    public byte[] _bdata;
    public short[] _sdata;

    boolean IsEvent() {
        if (this._type >= 60 && this._type <= 65) {
            return true;
        }
        return this._type < 80 || this._type > 96;
    }

    void Init() {
        int n;
        int n2;
        if (this.IsEvent()) {
            n2 = GameArray.BDATA_SIZE_EVENTS[this._type - 60];
            n = GameArray.SDATA_SIZE_EVENTS[this._type - 60];
        } else {
            n2 = GameArray.BDATA_SIZE_ACTIONS[this._type - 80];
            n = GameArray.SDATA_SIZE_ACTIONS[this._type - 80];
        }
        if (n2 != 0) {
            this._bdata = new byte[n2];
        }
        if (n != 0) {
            this._sdata = new short[n];
        }
    }

    void LoadTrigger(SDKInputStream sDKInputStream) throws IOException {
        this._level_id = sDKInputStream.readShort();
        if (this.IsEvent()) {
            this._active = sDKInputStream.read() > 0;
            this._sdata[0] = sDKInputStream.readShort();
            this._bdata[0] = (byte)sDKInputStream.read();
        } else {
            this._active = false;
            this._sdata[1] = sDKInputStream.readShort();
        }
        switch (this._type) {
            case 60: {
                this._sdata[3] = sDKInputStream.readShort();
                this._sdata[4] = sDKInputStream.readShort();
                this._bdata[1] = (byte)sDKInputStream.read();
                this._sdata[5] = sDKInputStream.readShort();
                this._sdata[1] = sDKInputStream.readShort();
                this._sdata[2] = sDKInputStream.readShort();
                this._bdata[2] = 0;
                this._sdata[1] = (short)(this._sdata[1] + Level._extraPixelsWidth);
                this._sdata[2] = (short)(this._sdata[2] + Level._extraPixelsHeightTop);
                break;
            }
            case 61: {
                this._sdata[3] = sDKInputStream.readShort();
                this._sdata[4] = sDKInputStream.readShort();
                this._sdata[5] = sDKInputStream.readShort();
                this._sdata[1] = sDKInputStream.readShort();
                this._sdata[2] = sDKInputStream.readShort();
                this._sdata[1] = (short)(this._sdata[1] + Level._extraPixelsWidth);
                this._sdata[2] = (short)(this._sdata[2] + Level._extraPixelsHeightTop);
                break;
            }
            case 62: {
                break;
            }
            case 63: {
                this._bdata[1] = (byte)sDKInputStream.read();
                break;
            }
            case 64: {
                this._bdata[1] = (byte)sDKInputStream.read();
                break;
            }
            case 65: {
                this._sdata[1] = sDKInputStream.readShort();
                break;
            }
            case 80: {
                this._sdata[2] = sDKInputStream.readShort();
                break;
            }
            case 81: {
                this._sdata[2] = sDKInputStream.readShort();
                this._bdata[0] = (byte)sDKInputStream.read();
                this._bdata[1] = (byte)sDKInputStream.read();
                this._bdata[2] = (byte)sDKInputStream.read();
                break;
            }
            case 82: {
                this._sdata[2] = sDKInputStream.readShort();
                this._sdata[3] = sDKInputStream.readShort();
                this._sdata[4] = sDKInputStream.readShort();
                this._sdata[5] = sDKInputStream.readShort();
                this._sdata[6] = sDKInputStream.readShort();
                this._sdata[7] = sDKInputStream.readShort();
                this._sdata[8] = sDKInputStream.readShort();
                break;
            }
            case 83: {
                this._sdata[2] = sDKInputStream.readShort();
                this._sdata[3] = sDKInputStream.readShort();
                this._sdata[4] = sDKInputStream.readShort();
                this._sdata[5] = sDKInputStream.readShort();
                this._sdata[6] = sDKInputStream.readShort();
                this._sdata[7] = sDKInputStream.readShort();
                break;
            }
            case 84: {
                this._sdata[2] = sDKInputStream.readShort();
                this._bdata[0] = (byte)sDKInputStream.read();
                this._bdata[1] = (byte)sDKInputStream.read();
                break;
            }
            case 85: {
                this._sdata[2] = sDKInputStream.readShort();
                break;
            }
            case 86: {
                this._bdata[0] = (byte)sDKInputStream.read();
                this._bdata[1] = (byte)sDKInputStream.read();
                this._bdata[2] = (byte)sDKInputStream.read();
                this._bdata[3] = (byte)sDKInputStream.read();
                this._bdata[4] = (byte)sDKInputStream.read();
                this._bdata[5] = (byte)sDKInputStream.read();
                break;
            }
            case 87: {
                this._sdata[4] = sDKInputStream.readShort();
                this._sdata[2] = sDKInputStream.readShort();
                this._sdata[3] = sDKInputStream.readShort();
                this._sdata[2] = (short)(this._sdata[2] + Level._extraPixelsWidth);
                this._sdata[3] = (short)(this._sdata[3] + Level._extraPixelsHeightTop);
                break;
            }
            case 88: {
                this._sdata[2] = sDKInputStream.readShort();
                this._bdata[0] = (byte)sDKInputStream.read();
                break;
            }
            case 89: {
                this._sdata[2] = sDKInputStream.readShort();
                this._bdata[0] = (byte)sDKInputStream.read();
                break;
            }
            case 90: {
                this._sdata[4] = sDKInputStream.readShort();
                this._sdata[2] = sDKInputStream.readShort();
                this._sdata[3] = sDKInputStream.readShort();
                this._sdata[2] = (short)(this._sdata[2] + Level._extraPixelsWidth);
                this._sdata[3] = (short)(this._sdata[3] + Level._extraPixelsHeightTop);
                break;
            }
            case 91: {
                this._sdata[2] = sDKInputStream.readShort();
                break;
            }
            case 92: {
                break;
            }
            case 93: {
                this._sdata[2] = sDKInputStream.readShort();
                this._bdata[0] = (byte)sDKInputStream.read();
                this._bdata[1] = (byte)sDKInputStream.read();
                break;
            }
            case 94: {
                this._sdata[4] = sDKInputStream.readShort();
                this._bdata[0] = (byte)sDKInputStream.read();
                this._sdata[2] = sDKInputStream.readShort();
                this._sdata[3] = sDKInputStream.readShort();
                this._sdata[2] = (short)(this._sdata[2] + Level._extraPixelsWidth);
                this._sdata[3] = (short)(this._sdata[3] + Level._extraPixelsHeightTop);
                break;
            }
            case 96: {
                this._bdata[0] = (byte)sDKInputStream.read();
            }
        }
    }

    boolean IsEntityInTrigger(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (this._type) {
            case 60: {
                n6 = this._sdata[1];
                n5 = this._sdata[2];
                n4 = this._sdata[3];
                n3 = this._sdata[4];
                break;
            }
            case 61: {
                n6 = this._sdata[1];
                n5 = this._sdata[2];
                n4 = this._sdata[3];
                n3 = this._sdata[4];
                break;
            }
        }
        return n >= n6 && n2 >= n5 && n <= n4 + n6 && n2 <= n3 + n5;
    }

    void ActivateTrigger() {
        Trigger trigger = Level.GetTriggerByLevelId(this._sdata[0]);
        if (!trigger._active) {
            trigger._active = true;
            trigger._sdata[0] = 0;
        }
        if (this._bdata[0] > 0) {
            this._active = false;
        }
    }

    void CheckPositionTrigger(Entity entity, int n, int n2) {
        if (!this._active) {
            return;
        }
        if (this._sdata[5] != -1 && entity._level_id != this._sdata[5]) {
            return;
        }
        if (this.IsEntityInTrigger(entity._pos_x >> 16, entity._pos_y >> 16) && !this.IsEntityInTrigger(n, n2)) {
            this._bdata[2] = (byte)(this._bdata[2] + 1);
        }
        if (this._bdata[2] >= this._bdata[1]) {
            this.ActivateTrigger();
            this._bdata[2] = 0;
        }
    }

    void CheckTrigger(Entity entity, boolean bl) {
        if (!this._active) {
            return;
        }
        switch (this._type) {
            case 61: {
                if (entity._level_id != this._sdata[5] || !this.IsEntityInTrigger(entity._pos_x >> 16, entity._pos_y >> 16)) break;
                this.ActivateTrigger();
                break;
            }
            case 62: {
                this.ActivateTrigger();
                break;
            }
            case 63: {
                if (bl) {
                    if (this._bdata[1] != 33) break;
                    this.ActivateTrigger();
                    break;
                }
                if (entity._bdata[15] != this._bdata[1]) break;
                this.ActivateTrigger();
                break;
            }
            case 64: {
                if (Level._nNPCAntEntities != this._bdata[1]) break;
                this.ActivateTrigger();
                break;
            }
            case 65: {
                if (GameImpl._nMessageIndex != this._sdata[1]) break;
                this.ActivateTrigger();
            }
        }
    }

    void Update() {
        if (!this._active) {
            return;
        }
        if (this._sdata[0] < this._sdata[1]) {
            this._sdata[0] = (short)(this._sdata[0] + 1);
            return;
        }
        this._active = false;
        switch (this._type) {
            case 80: {
                Entity entity = Level.GetEntityByLevelId(this._sdata[2]);
                if (entity == null) break;
                Level.EnableEntity(entity._id);
                break;
            }
            case 81: {
                if (GameImpl._pCrtWorm != null && GameImpl._pCrtWorm._bdata[12] == 1) {
                    GameImpl._pCrtWorm.Worm_SetState((byte)0);
                }
                int n = -1;
                GameImpl.SetMessage(this._sdata[2], -1, this._bdata[1], n);
                if (this._bdata[2] <= 0) break;
                GameImpl._triggered_top_message = true;
                break;
            }
            case 82: {
                for (int i = 2; i <= 8; ++i) {
                    if (this._sdata[i] == -1) continue;
                    Trigger trigger = Level.GetTriggerByLevelId(this._sdata[i]);
                    trigger._active = true;
                }
                break;
            }
            case 83: {
                for (int i = 2; i <= 7; ++i) {
                    if (this._sdata[i] == -1) continue;
                    Trigger trigger = Level.GetTriggerByLevelId(this._sdata[i]);
                    trigger._active = false;
                }
                break;
            }
            case 84: {
                Entity entity = Level.GetEntityByLevelId(this._sdata[2]);
                if (entity == null) break;
                if (Entity._tutorialAnim != null) {
                    Level.DisableEntity(Entity._tutorialAnim._id);
                    Entity._tutorialAnim = null;
                }
                Entity entity2 = Level.SpawnEntity(5);
                entity2.Init(5, entity._pos_x, entity._pos_y, null, null);
                entity2.SetSprite(5);
                entity2._bdata[0] = this._bdata[0];
                entity2._bdata[1] = this._bdata[1];
                if (entity2._bdata[1] != -1 && entity._bdata[5] == 1) {
                    entity2.SetCrtAnim(entity2._bdata[1]);
                } else {
                    entity2.SetCrtAnim(entity2._bdata[0]);
                }
                entity2._flags &= 0xFFFFFFBF;
                Entity._tutorialAnim = entity2;
                break;
            }
            case 85: {
                Entity entity = Level.GetEntityByLevelId(this._sdata[2]);
                if (entity == null || Entity._tutorialAnim == null) break;
                Level.DisableEntity(Entity._tutorialAnim._id);
                Entity._tutorialAnim = null;
                break;
            }
            case 86: {
                Level._isRealTime = this._bdata[0] > 0;
                Level._isTerrainIndestructible = this._bdata[1] > 0;
                Level._isWindDisabled = this._bdata[2] > 0;
                Level._isWeaponPanelDisabled = this._bdata[3] > 0;
                Level._isTimerDisabled = this._bdata[4] > 0;
                boolean bl = Level._isMinimapDisabled = this._bdata[5] > 0;
                if (!Level._isMinimapDisabled) {
                    Level._isBinocularDisbaled = false;
                    GameImpl._bBinocularTutorialOnce = false;
                } else {
                    Level._isBinocularDisbaled = true;
                }
                if (Level._isWeaponPanelDisabled) break;
                Level._bHaveBackpack = true;
                Level._flashBackpackTimer = GameImpl.GetGameTimer();
                break;
            }
            case 87: {
                Entity entity = Level.GetEntityByLevelId(this._sdata[4]);
                if (entity == null) break;
                short s = this._sdata[2];
                int n = this._sdata[3];
                Level.EnableEntity(entity._id);
                entity._sprite = 1;
                entity._nState = 0;
                entity.SetWormDirection(-1);
                entity._idata[5] = 32768;
                entity._health = entity._bdata[11];
                entity.SetCrtAnim(7);
                entity.UpdateBoundingBox();
                entity._bdata[18] = 0;
                Entity._damage_fall_taken = 0;
                entity._bSimpleRebound = false;
                entity.Worm_SetState((byte)16);
                entity._bdata[10] = 0;
                entity.SetCrtAnim(48);
                entity._flags |= 0x40;
                n = entity.PlaceObjectOnGround(s, n, false);
                entity.SetPosition(s << 16, n << 16);
                if (!Level._isRealTime) break;
                GameImpl._shootCounter = 0;
                break;
            }
            case 88: {
                Entity entity = Level.GetEntityByLevelId(this._sdata[2]);
                if (entity == null) break;
                entity._bdata[15] = this._bdata[0];
                break;
            }
            case 89: {
                Entity entity = Level.GetEntityByLevelId(this._sdata[2]);
                if (entity == null) break;
                if (this._bdata[0] == -1) {
                    GameImpl.MemSet(GameImpl._teamsWeapons[entity._bdata[3]], 0);
                    entity._bdata[15] = -1;
                    entity.Worm_SetState((byte)1);
                    break;
                }
                GameImpl._teamsWeapons[entity._bdata[3]][this._bdata[0]] = 0;
                if (GameImpl._pCrtWorm == null || GameImpl._pCrtWorm != entity || GameImpl._pCrtWorm._bdata[15] != this._bdata[0]) break;
                GameImpl._pCrtWorm._bdata[15] = -1;
                entity.Worm_SetState((byte)1);
                break;
            }
            case 90: {
                int n = this._sdata[2] - (GameImpl.SV_W >> 1);
                int n2 = this._sdata[3] - (GameImpl.SV_H >> 1);
                Level.DoScroll(n, n2);
                GameImpl.SetGamePlayState(11);
                GameImpl._timerWaitOnPosition = this._sdata[4];
                break;
            }
            case 91: {
                Entity entity = Level.GetEntityByLevelId(this._sdata[2]);
                if (entity == null) break;
                entity._flags |= 0x18;
                if (entity._type != 19) break;
                Level.RemoveObjectLevelCollisions(entity);
                break;
            }
            case 92: {
                GameImpl._winningTeam = 0;
                GameImpl.SetGamePlayState(12);
                break;
            }
            case 95: {
                while (GameImpl._nTopMessageStackPointer >= 0) {
                    GameImpl.PopMessage(1);
                }
                GameImpl._sTopMessageText = null;
                break;
            }
            case 93: {
                Entity entity = Level.GetEntityByLevelId(this._sdata[2]);
                if (entity == null) break;
                GameImpl._teamsWeapons[entity._bdata[3]][this._bdata[0]] = this._bdata[1];
                break;
            }
            case 94: {
                Entity entity = Level.GetEntityByLevelId(this._sdata[4]);
                if (entity == null) break;
                short s = this._sdata[2];
                short s2 = this._sdata[3];
                if (entity._type == 1 && (entity._flags & 0x18) == 0) {
                    if (this._bdata[0] == 1) {
                        entity.Worm_Teleport(s << 16, s2 << 16);
                        break;
                    }
                    entity.Worm_ChangePos(s << 16, s2 << 16);
                    break;
                }
                if (entity._type == 19 && (entity._flags & 0x18) == 0) {
                    int n = entity._sprite;
                    entity.SetSprite(1);
                    entity._crt_anim = -1;
                    entity.SetCrtAnim(entity._bdata[1]);
                    entity._idata[0] = s << 16;
                    entity._idata[1] = s2 << 16;
                    entity._bdata[0] = 1;
                    entity.SetSprite(n);
                    break;
                }
                entity._pos_x = s << 16;
                entity._pos_y = s2 << 16;
                break;
            }
            case 96: {
                GameImpl._bDisableUpdateWormControls = this._bdata[0] == 0;
            }
        }
    }
}

