/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.ForceInline;

public class FlDrawPropertyUtil {
    public static final int BitmapStencilNone = 0;
    public static final int BitmapStencilPositive = 512;
    public static final int BitmapStencilNegative = 1024;
    public static final int TransformNone = 0;
    public static final int TransformMirrorRot180 = 65536;
    public static final int TransformMirror = 131072;
    public static final int TransformRot180 = 196608;
    public static final int TransformMirrorRot270 = 262144;
    public static final int TransformRot90 = 327680;
    public static final int TransformRot270 = 393216;
    public static final int TransformMirrorRot90 = 458752;
    public static final int TileNone = 0;
    public static final int TileX = 524288;
    public static final int TileY = 0x100000;
    public static final int TileXY = 0x180000;

    public static int GetDefaultDrawProperty() {
        ForceInline.v();
        return 255;
    }

    public static int BmpTransformToTransform(byte by) {
        ForceInline.v();
        switch (by) {
            case 2: {
                return 131072;
            }
            case 1: {
                return 65536;
            }
            case 3: {
                return 196608;
            }
        }
        return 0;
    }

    public static int FlipXYToTransform(boolean bl, boolean bl2) {
        ForceInline.v();
        if (!bl) {
            return bl2 ? 65536 : 0;
        }
        return bl2 ? 196608 : 131072;
    }

    public static int MIDPTransformToTransform(int n) {
        ForceInline.v();
        return n << 16;
    }

    public static int TransformToMIDPTransform(int n) {
        ForceInline.v();
        return n >>> 16;
    }

    public static byte GetBmpTransform(int n) {
        ForceInline.v();
        switch (FlDrawPropertyUtil.GetTransform(n)) {
            case 131072: {
                return 2;
            }
            case 65536: {
                return 1;
            }
            case 196608: {
                return 3;
            }
        }
        return 0;
    }

    public static boolean IsFlippedX(int n) {
        int n2 = FlDrawPropertyUtil.GetTransform(n);
        return n2 == 196608 || n2 == 131072;
    }

    public static boolean IsFlippedY(int n) {
        int n2 = FlDrawPropertyUtil.GetTransform(n);
        return n2 == 196608 || n2 == 65536;
    }

    public static int ApplyTransform(int n, int n2) {
        ForceInline.v();
        return n & 0xFFF8FFFF | n2;
    }

    public static int GetTransform(int n) {
        ForceInline.v();
        return n & 0x70000;
    }

    public static boolean IsInitialOrientation(int n) {
        ForceInline.v();
        switch (FlDrawPropertyUtil.GetTransform(n)) {
            case 0: 
            case 65536: 
            case 131072: 
            case 196608: {
                return true;
            }
        }
        return false;
    }

    public static short GetAlpha(int n) {
        ForceInline.v();
        return 255;
    }

    public static int GetBitmapStencil(int n) {
        ForceInline.v();
        return 0;
    }

    public static int GetTile(int n) {
        ForceInline.v();
        return 0;
    }

    public static int GetJ2METransform(int n) {
        ForceInline.v();
        return FlDrawPropertyUtil.GetTransform(n) >>> 16;
    }

    public static FlDrawPropertyUtil[] InstArrayFlDrawPropertyUtil(int n) {
        FlDrawPropertyUtil[] flDrawPropertyUtilArray = new FlDrawPropertyUtil[n];
        for (int i = 0; i < n; ++i) {
            flDrawPropertyUtilArray[i] = new FlDrawPropertyUtil();
        }
        return flDrawPropertyUtilArray;
    }

    public static FlDrawPropertyUtil[][] InstArrayFlDrawPropertyUtil(int n, int n2) {
        FlDrawPropertyUtil[][] flDrawPropertyUtilArray = new FlDrawPropertyUtil[n][];
        for (int i = 0; i < n; ++i) {
            flDrawPropertyUtilArray[i] = new FlDrawPropertyUtil[n2];
            for (int j = 0; j < n2; ++j) {
                flDrawPropertyUtilArray[i][j] = new FlDrawPropertyUtil();
            }
        }
        return flDrawPropertyUtilArray;
    }

    public static FlDrawPropertyUtil[][][] InstArrayFlDrawPropertyUtil(int n, int n2, int n3) {
        FlDrawPropertyUtil[][][] flDrawPropertyUtilArray = new FlDrawPropertyUtil[n][][];
        for (int i = 0; i < n; ++i) {
            flDrawPropertyUtilArray[i] = new FlDrawPropertyUtil[n2][];
            for (int j = 0; j < n2; ++j) {
                flDrawPropertyUtilArray[i][j] = new FlDrawPropertyUtil[n3];
                for (int k = 0; k < n3; ++k) {
                    flDrawPropertyUtilArray[i][j][k] = new FlDrawPropertyUtil();
                }
            }
        }
        return flDrawPropertyUtilArray;
    }
}

