/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Color888;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlDrawPropertyUtil;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlRect;
import ca.jamdat.flight.ForceInline;
import ca.jamdat.flight.MIDPDisplayContextImp;
import ca.jamdat.flight.Vector2_short;
import ca.jamdat.flight.VideoMode;
import javax.microedition.lcdui.Image;

public abstract class DisplayContext {
    public static final byte resolutionPortrait = 0;
    public static final byte resolutionLandscape = 1;
    public static final byte resolutionCount = 2;
    public static final byte resolutionInvalid = 3;
    public static final byte bmpTransformIdentity = 0;
    public static final byte bmpTransformFlipY = 1;
    public static final byte bmpTransformFlipX = 2;
    public static final byte bmpTransformFlipDiag = 3;
    public static final byte alignmentLeft = 0;
    public static final byte alignmentCenter = 1;
    public static final byte alignmentRight = 2;
    public static final byte alignmentVTop = 0;
    public static final byte alignmentVBottom = 1;
    public static final byte alignmentVBaseline = 2;
    public static final byte alignmentVCenter = 3;
    public boolean mMSAAActive;
    public VideoMode mVideoMode;
    public boolean mInvertedLandscape;
    public short mClipRect_left;
    public short mClipRect_top;
    public short mClipRect_width;
    public short mClipRect_height;
    public boolean mBypassClipping;
    public short mCumulativeOffsetX;
    public short mCumulativeOffsetY;
    public FlRect mScreenRect;
    public int mClearNextFramesCount;

    public static short GetAlignmentOffsetX(byte by, short s, short s2) {
        short s3 = 0;
        if (by != 0) {
            s3 = (short)(s - s2);
            if (by == 1) {
                s3 = (short)(s3 >> 1);
            }
        }
        return s3;
    }

    public DisplayContext(VideoMode videoMode) {
        this.mVideoMode = new VideoMode(videoMode);
        this.mScreenRect = new FlRect(0, 0, (short)videoMode.GetWidth(), (short)videoMode.GetHeight());
    }

    public void destruct() {
    }

    public abstract void NativeDrawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void NativeDrawLine(int var1, int var2, int var3, int var4);

    public abstract void NativeDrawPixel(int var1, int var2);

    public abstract void NativeDrawRect(int var1, int var2, int var3, int var4);

    public abstract void NativeDrawRGB(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public abstract void NativeDrawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void NativeFillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void NativeFillRect(int var1, int var2, int var3, int var4);

    public abstract void NativeFillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void NativeFillTriangle(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void NativeDrawRegion(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public abstract int NativeGetClipHeight();

    public abstract int NativeGetClipWidth();

    public abstract int NativeGetClipX();

    public abstract int NativeGetClipY();

    public abstract void NativeSetClip(int var1, int var2, int var3, int var4);

    public abstract int NativeGetAlpha();

    public abstract int NativeGetARGB();

    public abstract int NativeGetRGB();

    public abstract void NativeSetAlpha(int var1);

    public abstract void NativeSetARGB(int var1);

    public abstract void NativeSetRGB(int var1);

    public abstract void NativeSetARGB(int var1, int var2, int var3, int var4);

    public abstract void NativeSetRGB(int var1, int var2, int var3);

    public abstract void NativeSetFont(Object var1);

    public void NativeDrawString(String string, int n, int n2, byte by, byte by2) {
    }

    public abstract void NativeDrawString(String var1, int var2, int var3, int var4);

    public abstract int NativeGetTranslatedX();

    public abstract int NativeGetTranslatedY();

    public abstract void NativeTranslate(int var1, int var2);

    public boolean MSAAIsActive() {
        return this.mMSAAActive;
    }

    public void ActivateMSAA(boolean bl) {
    }

    public abstract void DrawRGB(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public abstract void DrawRectangle(short var1, short var2, short var3, short var4, boolean var5, int var6, int var7, int var8, int var9);

    public abstract void DrawRoundRectangle(short var1, short var2, short var3, short var4, short var5, short var6, boolean var7, Color888 var8, int var9);

    public void DrawFrame(short s, short s2, short s3, short s4, Color888 color888, int n) {
        this.DrawRectangle((short)(s - this.mCumulativeOffsetX), (short)(s2 - this.mCumulativeOffsetY), s3, s4, false, color888.GetRed(), color888.GetGreen(), color888.GetBlue(), n);
    }

    public void DrawAbsoluteSolidRectangle(short s, short s2, short s3, short s4, int n, int n2, int n3, int n4) {
        this.DrawRectangle((short)(s - this.mCumulativeOffsetX), (short)(s2 - this.mCumulativeOffsetY), s3, s4, true, n, n2, n3, n4);
    }

    public abstract void DrawTriangle(short var1, short var2, short var3, short var4, short var5, short var6, boolean var7, Color888 var8, int var9);

    public void DrawAbsoluteLine(short s, short s2, short s3, short s4, Color888 color888, int n) {
        this.DrawLine((short)(s - this.mCumulativeOffsetX), (short)(s2 - this.mCumulativeOffsetY), (short)(s3 - this.mCumulativeOffsetX), (short)(s4 - this.mCumulativeOffsetY), color888, n);
    }

    public abstract void DrawLine(short var1, short var2, short var3, short var4, Color888 var5, int var6);

    public abstract void DrawPixel(short var1, short var2, Color888 var3, int var4);

    public void DrawCircle(Vector2_short vector2_short, short s, boolean bl, Color888 color888, Color888 color8882) {
        short s2 = (short)(vector2_short.GetX() - s);
        short s3 = (short)(vector2_short.GetY() - s);
        short s4 = (short)(s << 1);
        if (bl) {
            this.DrawArc(s2, s3, s4, s4, (short)0, (short)360, true, color888, 255);
        }
        this.DrawArc(s2, s3, s4, s4, (short)0, (short)360, false, color8882, 255);
    }

    public abstract void DrawArc(short var1, short var2, short var3, short var4, short var5, short var6, boolean var7, Color888 var8, int var9);

    public abstract void Clear(Color888 var1);

    public abstract void ClearFullscreen(Color888 var1);

    public void ClearNextFrames(int n) {
        this.mClearNextFramesCount = n;
    }

    public void DrawBitmapSection(FlBitmap flBitmap, short s, short s2, short s3, short s4, short s5, short s6, int n) {
        short s7 = (short)(s + this.mCumulativeOffsetX);
        short s8 = (short)(s2 + this.mCumulativeOffsetY);
        this.DrawAbsoluteBitmapSection(flBitmap, (int)s7, (int)s8, (int)s3, (int)s4, (int)s5, (int)s6, n);
    }

    public void DrawBitmapSection(FlBitmap flBitmap, short s, short s2, short s3, short s4, short s5, short s6, boolean bl, boolean bl2) {
        int n = 255;
        n = FlDrawPropertyUtil.ApplyTransform(n, FlDrawPropertyUtil.FlipXYToTransform(bl, bl2));
        this.DrawBitmapSection(flBitmap, s, s2, s3, s4, s5, s6, n);
    }

    public void DrawTiledBitmapSection(FlBitmap flBitmap, short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9, short s10, short s11, short s12, int n) {
        int n2;
        boolean bl = FlDrawPropertyUtil.IsFlippedX(n);
        boolean bl2 = FlDrawPropertyUtil.IsFlippedY(n);
        short s13 = this.mCumulativeOffsetX;
        short s14 = this.mCumulativeOffsetY;
        short s15 = (short)(s9 + s13);
        short s16 = (short)(s10 + s14);
        short s17 = s11;
        short s18 = s12;
        int n3 = this.mClipRect_left + this.mClipRect_width;
        int n4 = s15 + s17;
        int n5 = this.mClipRect_top + this.mClipRect_height;
        int n6 = s16 + s18;
        if (this.mClipRect_left > s15) {
            s15 = this.mClipRect_left;
        }
        if (this.mClipRect_top > s16) {
            s16 = this.mClipRect_top;
        }
        if (n3 < n4) {
            n4 = n3;
        }
        if (n5 < n6) {
            n6 = n5;
        }
        s17 = (short)(n4 - s15);
        s18 = (short)(n6 - s16);
        if (s17 <= 0 || s18 <= 0) {
            return;
        }
        n3 = s15 - s13;
        n4 = n3 + s17;
        n6 = n5 + s18;
        for (n5 = s16 - s14; n5 < n6; n5 += n2) {
            int n7;
            int n8 = (n5 - s10) % s2;
            int n9 = FlMath.Minimum((int)s2, n6 - n5 + n8);
            n2 = n9 - n8;
            int n10 = FlMath.Maximum(0, s4 - n8);
            int n11 = FlMath.Maximum(0, n8 - s4);
            int n12 = FlMath.Minimum((int)s8, n9 - s4);
            int n13 = FlMath.Maximum(0, n12 - n11);
            if (bl2) {
                n11 = s8 - n12;
                n12 = n11 + n13;
            }
            for (int i = n3; i < n4; i += n7) {
                int n14 = (i - s9) % s;
                int n15 = FlMath.Minimum((int)s, n4 - i + n14);
                n7 = n15 - n14;
                int n16 = FlMath.Maximum(0, s3 - n14);
                int n17 = FlMath.Maximum(0, n14 - s3);
                int n18 = FlMath.Minimum((int)s7, n15 - s3);
                int n19 = FlMath.Maximum(0, n18 - n17);
                if (bl) {
                    n17 = s7 - n18;
                    n18 = n17 + n19;
                }
                this.mBypassClipping = true;
                this.DrawBitmapSection(flBitmap, (short)(i + n16), (short)(n5 + n10), (short)(s5 + n17), (short)(s6 + n11), (short)n19, (short)n13, n);
            }
        }
        this.mBypassClipping = false;
    }

    public void DrawTiledBitmapSection(FlBitmap flBitmap, short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8, int n) {
        this.DrawTiledBitmapSection(flBitmap, s3, s4, (short)0, (short)0, s, s2, s3, s4, s5, s6, s7, s8, n);
    }

    public abstract void DrawAbsoluteBitmapSection(FlBitmap var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8);

    public abstract void DrawAbsoluteBitmapSection(FlBitmap var1, int var2, int var3, int var4, int var5, int var6, int var7, byte var8);

    public void DrawAbsoluteBitmapBypassClipping(FlBitmap flBitmap, int n, int n2) {
        this.DrawBitmapSection(flBitmap, (short)(n - this.mCumulativeOffsetX), (short)(n2 - this.mCumulativeOffsetY), (short)0, (short)0, flBitmap.GetWidth(), flBitmap.GetHeight(), false, false);
    }

    public void DrawAbsoluteBitmap(FlBitmap flBitmap, int n, int n2) {
        this.ResetClip();
        this.DrawAbsoluteBitmapBypassClipping(flBitmap, n, n2);
    }

    public void ResetClip() {
    }

    public void Set2DMode() {
    }

    public void OffsetBy(short s, short s2) {
        ForceInline.v();
        this.mCumulativeOffsetX = (short)(this.mCumulativeOffsetX + s);
        this.mCumulativeOffsetY = (short)(this.mCumulativeOffsetY + s2);
    }

    public boolean ApplicationIsPortrait() {
        return this.IsResolution(false, (byte)0);
    }

    public boolean ApplicationIsLandscape() {
        return this.IsResolution(false, (byte)1);
    }

    public boolean DeviceIsPortrait() {
        return this.IsResolution(true, (byte)0);
    }

    public boolean DeviceIsLandscape() {
        return this.IsResolution(true, (byte)1);
    }

    public boolean IsResolution(boolean bl, byte by) {
        return this.GetResolution(bl) == by;
    }

    public byte GetResolution(boolean bl) {
        VideoMode videoMode = null;
        videoMode = this.GetVideoMode();
        if (videoMode.GetWidth() <= videoMode.GetHeight()) {
            return 0;
        }
        return 1;
    }

    public short GetClippingRectLeft() {
        return (short)(this.GetAbsoluteClippingRectLeft() - this.GetCumulativeOffsetX());
    }

    public short GetClippingRectTop() {
        return (short)(this.GetAbsoluteClippingRectTop() - this.GetCumulativeOffsetY());
    }

    public short GetClippingRectWidth() {
        return this.GetAbsoluteClippingRectWidth();
    }

    public short GetClippingRectHeight() {
        return this.GetAbsoluteClippingRectHeight();
    }

    public void SetClippingRect(short s, short s2, short s3, short s4) {
        s = (short)(s + this.GetCumulativeOffsetX());
        s2 = (short)(s2 + this.GetCumulativeOffsetY());
        this.NativeSetClip(s, s2, s3, s4);
        this.SetAbsoluteClippingRect(s, s2, s3, s4);
    }

    public short GetAbsoluteClippingRectTop() {
        return this.mClipRect_top;
    }

    public short GetAbsoluteClippingRectLeft() {
        return this.mClipRect_left;
    }

    public short GetAbsoluteClippingRectWidth() {
        return this.mClipRect_width;
    }

    public short GetAbsoluteClippingRectHeight() {
        return this.mClipRect_height;
    }

    public void SetAbsoluteClippingRect(short s, short s2, short s3, short s4) {
        this.mClipRect_left = s;
        this.mClipRect_top = s2;
        this.mClipRect_width = s3;
        this.mClipRect_height = s4;
    }

    public void DrawClipRectInZBuffer() {
    }

    public void ClearClipRectInZBuffer() {
    }

    public void BeginScene() {
        if (this.mClearNextFramesCount > 0) {
            --this.mClearNextFramesCount;
            this.ClearFullscreen(new Color888(0, 0, 0));
        }
    }

    public void EndScene() {
    }

    public void Reload() {
    }

    public void RenderApplication() {
        this.BeginScene();
        FlApplication.GetInstance().OnDraw(this);
        this.EndScene();
        FlApplication.GetInstance().SetDirty(false);
    }

    public short GetCumulativeOffsetX() {
        return this.mCumulativeOffsetX;
    }

    public short GetCumulativeOffsetY() {
        return this.mCumulativeOffsetY;
    }

    public VideoMode GetVideoMode() {
        return this.mVideoMode;
    }

    public void SetVideoMode(VideoMode videoMode) {
        this.mVideoMode = videoMode;
    }

    public FlRect GetScreenRect() {
        return this.mScreenRect;
    }

    public void UpdateOrientation(VideoMode videoMode) {
        this.mScreenRect.Assign(new FlRect(0, 0, (short)videoMode.GetWidth(), (short)videoMode.GetHeight()));
        this.mVideoMode = videoMode;
    }

    public abstract byte GetDisplayAPI();

    public boolean InvertedLandscape() {
        return this.mInvertedLandscape;
    }

    public void SetInvertedLandscape(boolean bl) {
        this.mInvertedLandscape = bl;
    }

    public void EnableCoverageCheck(boolean bl) {
    }

    public void EnableVSync(boolean bl) {
    }

    public void GenericDrawArc(short s, short s2, short s3, short s4, short n, short s5, boolean bl, Color888 color888, int n2) {
        if (s3 == s4 && s5 >= 360) {
            short s6 = (short)(s3 >> 1);
            this.GenericDrawCircle((short)(s + s6), (short)(s2 + s6), s6, bl, color888, n2);
            return;
        }
        if (s3 <= 0 || s4 <= 0) {
            return;
        }
        while (n < 0) {
            n = (short)(n + 360);
        }
        n = (short)(n % 360);
        if (s5 > 360 || s5 < -360) {
            s5 = (short)360;
        }
        if (s5 < 0) {
            n = (short)(n + s5);
            s5 = -s5;
        }
        int n3 = n + s5;
        if (bl) {
            short s7 = (short)(s3 >> 1);
            short s8 = (short)(s4 >> 1);
            short s9 = (short)(s + s7);
            short s10 = (short)(s2 + s8);
            int n4 = n;
            short s11 = s5;
            while (s11 > 0) {
                int n5;
                if (n4 >= 270) {
                    n5 = s11 > 360 - n4 ? 360 : n4 + s11;
                    this.FillArcImpl(s9, s10, s7, s8, (short)n4, (short)n5, color888, n2);
                    s11 = (short)(s11 - (360 - n4));
                    n4 = 0;
                    continue;
                }
                if (n4 >= 180) {
                    n5 = s11 > 270 - n4 ? 270 : n4 + s11;
                    this.FillArcImpl(s9, s10, s7, s8, (short)n4, (short)n5, color888, n2);
                    s11 = (short)(s11 - (270 - n4));
                    n4 = 270;
                    continue;
                }
                if (n4 >= 90) {
                    n5 = s11 > 180 - n4 ? 180 : n4 + s11;
                    this.FillArcImpl(s9, s10, s7, s8, (short)n4, (short)n5, color888, n2);
                    s11 = (short)(s11 - (180 - n4));
                    n4 = 180;
                    continue;
                }
                n5 = s11 > 90 - n4 ? 90 : n4 + s11;
                this.FillArcImpl(s9, s10, s7, s8, (short)n4, (short)n5, color888, n2);
                s11 = (short)(s11 - (90 - n4));
                n4 = 90;
            }
        } else {
            for (int n6 = n; n6 != n3; n6 = (short)(n6 + 1)) {
                short s12 = (short)(s + (s3 >> 1) + ((s3 >> 1) * FlMath.Cos1024(n6) >> 10));
                short s13 = (short)(s2 + (s4 >> 1) - ((s4 >> 1) * FlMath.Sin1024(n6) >> 10));
                this.DrawPixel(s12, s13, color888);
            }
        }
    }

    public void GenericDrawCircle(short s, short s2, short n, boolean bl, Color888 color888, int n2) {
        int n3 = 1 - n;
        int n4 = 1;
        int n5 = -2 * n;
        int n6 = 0;
        int n7 = n;
        if (bl) {
            this.DrawLine((short)(s - n), s2, (short)(s + n), s2, color888, n2);
        } else {
            this.DrawPixel((short)(s + n), s2, color888);
            this.DrawPixel((short)(s - n), s2, color888);
        }
        this.DrawPixel(s, (short)(s2 + n), color888);
        this.DrawPixel(s, (short)(s2 - n), color888);
        while (n6 < n7) {
            if (n3 >= 0) {
                --n7;
                n3 += (n5 += 2);
            }
            ++n6;
            n3 += (n4 += 2);
            if (bl) {
                this.DrawLine((short)(s - n6), (short)(s2 + n7), (short)(s + n6), (short)(s2 + n7), color888, n2);
                this.DrawLine((short)(s - n6), (short)(s2 - n7), (short)(s + n6), (short)(s2 - n7), color888, n2);
                this.DrawLine((short)(s - n7), (short)(s2 + n6), (short)(s + n7), (short)(s2 + n6), color888, n2);
                this.DrawLine((short)(s - n7), (short)(s2 - n6), (short)(s + n7), (short)(s2 - n6), color888, n2);
                continue;
            }
            this.DrawPixel((short)(s + n6), (short)(s2 + n7), color888);
            this.DrawPixel((short)(s - n6), (short)(s2 + n7), color888);
            this.DrawPixel((short)(s + n6), (short)(s2 - n7), color888);
            this.DrawPixel((short)(s - n6), (short)(s2 - n7), color888);
            this.DrawPixel((short)(s + n7), (short)(s2 + n6), color888);
            this.DrawPixel((short)(s - n7), (short)(s2 + n6), color888);
            this.DrawPixel((short)(s + n7), (short)(s2 - n6), color888);
            this.DrawPixel((short)(s - n7), (short)(s2 - n6), color888);
        }
    }

    public void GenericDrawTriangle(short s, short s2, short s3, short s4, short s5, short s6, boolean bl, Color888 color888, int n) {
        this.DrawLine(s, s2, s3, s4, color888, n);
        this.DrawLine(s5, s6, s3, s4, color888, n);
        this.DrawLine(s, s2, s5, s6, color888, n);
        if (bl) {
            s = (short)(s + this.mCumulativeOffsetX);
            s2 = (short)(s2 + this.mCumulativeOffsetY);
            s3 = (short)(s3 + this.mCumulativeOffsetX);
            s4 = (short)(s4 + this.mCumulativeOffsetY);
            s5 = (short)(s5 + this.mCumulativeOffsetX);
            s6 = (short)(s6 + this.mCumulativeOffsetY);
            this.GenericFillAbsoluteTriangle(s, s2, s3, s4, s5, s6, color888, n);
        }
    }

    public void GenericFillAbsoluteTriangle(short s, short s2, short s3, short s4, short s5, short s6, Color888 color888, int n) {
        short s7 = 0;
        if (s4 < s2) {
            s7 = s3;
            s3 = s;
            s = s7;
            s7 = s4;
            s4 = s2;
            s2 = s7;
        }
        if (s6 < s2) {
            s7 = s5;
            s5 = s;
            s = s7;
            s7 = s6;
            s6 = s2;
            s2 = s7;
        }
        if (s6 < s4) {
            s7 = s5;
            s5 = s3;
            s3 = s7;
            s7 = s6;
            s6 = s4;
            s4 = s7;
        }
        int n2 = 8;
        int n3 = s << n2;
        int n4 = s2 << n2;
        int n5 = s3 << n2;
        int n6 = s4 << n2;
        int n7 = s5 << n2;
        int n8 = s6 << n2;
        int n9 = 0x40000000;
        int n10 = n6 > n4 ? (n5 - n3 << n2) / (n6 - n4) : n9;
        int n11 = n8 > n4 ? (n7 - n3 << n2) / (n8 - n4) : n9;
        int n12 = n8 > n6 ? (n7 - n5 << n2) / (n8 - n6) : n9;
        int n13 = n3;
        int n14 = n4;
        int n15 = n3;
        if (n10 == n9) {
            n15 = n5;
        }
        int n16 = n4;
        if (n10 > n11) {
            while (n14 < n6) {
                this.DrawAbsoluteLine((short)(n13 >> n2), (short)(n14 >> n2), (short)(n15 >> n2), (short)(n14 >> n2), color888, n);
                n14 += 1 << n2;
                n16 += 1 << n2;
                n13 += n11;
                n15 += n10;
            }
            n15 = n5;
            n16 = n6;
            while (n14 < n8) {
                this.DrawAbsoluteLine((short)(n13 >> n2), (short)(n14 >> n2), (short)(n15 >> n2), (short)(n14 >> n2), color888, n);
                n14 += 1 << n2;
                n16 += 1 << n2;
                n13 += n11;
                n15 += n12;
            }
        } else {
            while (n14 < n6) {
                this.DrawAbsoluteLine((short)(n13 >> n2), (short)(n14 >> n2), (short)(n15 >> n2), (short)(n14 >> n2), color888, n);
                n14 += 1 << n2;
                n16 += 1 << n2;
                n13 += n10;
                n15 += n11;
            }
            while (n14 < n8) {
                this.DrawAbsoluteLine((short)(n13 >> n2), (short)(n14 >> n2), (short)(n15 >> n2), (short)(n14 >> n2), color888, n);
                n14 += 1 << n2;
                n16 += 1 << n2;
                n13 += n12;
                n15 += n11;
            }
        }
    }

    public void GenericDrawRoundRectangle(short s, short s2, short s3, short s4, short s5, short s6, boolean bl, Color888 color888, int n) {
        short s7 = (short)(s + s3 - 1);
        short s8 = (short)(s2 + s4 - 1);
        if (s5 > s3) {
            s5 = s3;
        }
        if (s6 > s4) {
            s6 = s4;
        }
        short s9 = (short)(s5 >> 1);
        short s10 = (short)(s6 >> 1);
        short s11 = (short)(s + s9);
        short s12 = (short)(s7 - s9);
        short s13 = (short)(s2 + s10);
        short s14 = (short)(s8 - s10);
        this.DrawArc(s, s2, s5, s6, (short)90, (short)90, bl, color888, n);
        this.DrawArc((short)(s7 - s5), s2, s5, s6, (short)0, (short)90, bl, color888, n);
        this.DrawArc(s, (short)(s8 - s6), s5, s6, (short)180, (short)90, bl, color888, n);
        this.DrawArc((short)(s7 - s5), (short)(s8 - s6), s5, s6, (short)270, (short)90, bl, color888, n);
        if (bl) {
            int n2 = color888.GetRed();
            int n3 = color888.GetGreen();
            int n4 = color888.GetBlue();
            short s15 = (short)(s12 - s11 + 1);
            short s16 = (short)(s14 - s13 + 1);
            if (s15 > 0) {
                this.DrawRectangle(s11, s2, s15, s10, true, n2, n3, n4, n);
                this.DrawRectangle(s11, (short)(s14 + 1), s15, s10, true, n2, n3, n4, n);
            }
            if (s16 > 0) {
                this.DrawRectangle(s, s13, s3, s16, true, n2, n3, n4, n);
            }
        } else {
            if (s11 < s12) {
                this.DrawLine(s11, s2, s12, s2, color888, n);
                this.DrawLine(s11, s8, s12, s8, color888, n);
            }
            if (s13 < s14) {
                this.DrawLine(s, s13, s, s14, color888, n);
                this.DrawLine(s7, s13, s7, s14, color888, n);
            }
        }
    }

    public static DisplayContext CreateContext(VideoMode videoMode) {
        return new MIDPDisplayContextImp(videoMode);
    }

    public static DisplayContext CreateContext(FlBitmap flBitmap) {
        MIDPDisplayContextImp mIDPDisplayContextImp = new MIDPDisplayContextImp(flBitmap);
        return mIDPDisplayContextImp;
    }

    public void FillArcImpl(short s, short s2, short s3, short s4, short s5, short s6, Color888 color888, int n) {
        block41: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            short s7;
            short s8;
            block43: {
                block42: {
                    int n10;
                    block40: {
                        s8 = (short)(s3 * s3);
                        s7 = (short)(s4 * s4);
                        n9 = s + (s3 * FlMath.Cos1024(s5) >> 10);
                        n8 = s2 - (s4 * FlMath.Sin1024(s5) >> 10);
                        n7 = s + (s3 * FlMath.Cos1024(s6) >> 10);
                        n6 = s2 - (s4 * FlMath.Sin1024(s6) >> 10);
                        this.GenericDrawTriangle(s, s2, (short)n9, (short)n8, (short)n7, (short)n6, true, color888, n);
                        n5 = 0;
                        if (s5 >= 270) {
                            n5 = 3;
                        } else if (s5 >= 180) {
                            n5 = 2;
                        } else if (s5 >= 90) {
                            n5 = 1;
                        }
                        switch (n5) {
                            case 0: {
                                n4 = n7;
                                n10 = n6;
                                n3 = n9;
                                n2 = n8;
                                break;
                            }
                            case 1: {
                                n4 = n7;
                                n2 = n6;
                                n3 = n9;
                                n10 = n8;
                                break;
                            }
                            case 2: {
                                n4 = n9;
                                n2 = n6;
                                n3 = n7;
                                n10 = n8;
                                break;
                            }
                            default: {
                                n4 = n9;
                                n2 = n8;
                                n3 = n7;
                                n10 = n6;
                            }
                        }
                        if (n4 < 0) {
                            n4 = 0;
                        }
                        if (n4 < this.mClipRect_left) {
                            n4 = this.mClipRect_left;
                        }
                        if (n2 > this.mClipRect_top + this.mClipRect_height - 1) {
                            n2 = this.mClipRect_top + this.mClipRect_height - 1;
                        }
                        if (n3 > this.mClipRect_left + this.mClipRect_width - 1) {
                            n3 = this.mClipRect_left + this.mClipRect_width - 1;
                        }
                        if (n10 < 0) {
                            n10 = 0;
                        }
                        if (n10 < this.mClipRect_top) {
                            n10 = this.mClipRect_top;
                        }
                        if (n5 != 1) break block40;
                        block5: for (int i = n2; i >= n10; --i) {
                            int n11 = n4;
                            boolean bl = false;
                            while (true) {
                                if (!bl) {
                                    if ((n11 - s) * (n11 - s) * s7 + (i - s2) * (i - s2) * s8 <= s7 * s8) {
                                        bl = true;
                                    } else {
                                        ++n4;
                                    }
                                }
                                if (bl) {
                                    this.DrawPixel((short)n11, (short)i, color888);
                                }
                                if (n11 == n3 || (n9 - n7) * (i - n6) > (n11 - n7) * (n8 - n6)) continue block5;
                                ++n11;
                            }
                        }
                        break block41;
                    }
                    if (n5 != 0) break block42;
                    block7: for (int i = n2; i >= n10; --i) {
                        int n12 = n3;
                        boolean bl = false;
                        while (true) {
                            if (!bl) {
                                if ((n12 - s) * (n12 - s) * s7 + (i - s2) * (i - s2) * s8 <= s7 * s8) {
                                    bl = true;
                                } else {
                                    --n3;
                                }
                            }
                            if (bl) {
                                this.DrawPixel((short)n12, (short)i, color888);
                            }
                            if (n12 == n4 || (n9 - n7) * (i - n6) > (n12 - n7) * (n8 - n6)) continue block7;
                            --n12;
                        }
                    }
                    break block41;
                }
                if (n5 != 2) break block43;
                block9: for (int i = n10; i <= n2; ++i) {
                    int n13 = n4;
                    boolean bl = false;
                    while (true) {
                        if (!bl) {
                            if ((n13 - s) * (n13 - s) * s7 + (i - s2) * (i - s2) * s8 <= s7 * s8) {
                                bl = true;
                            } else {
                                ++n4;
                            }
                        }
                        if (bl) {
                            this.DrawPixel((short)n13, (short)i, color888);
                        }
                        if (n13 == n3 || (n9 - n7) * (i - n6) > (n13 - n7) * (n8 - n6)) continue block9;
                        ++n13;
                    }
                }
                break block41;
            }
            if (n5 != 3) break block41;
            block11: for (int i = n10; i <= n2; ++i) {
                int n14 = n3;
                boolean bl = false;
                while (true) {
                    if (!bl) {
                        if ((n14 - s) * (n14 - s) * s7 + (i - s2) * (i - s2) * s8 <= s7 * s8) {
                            bl = true;
                        } else {
                            --n3;
                        }
                    }
                    if (bl) {
                        this.DrawPixel((short)n14, (short)i, color888);
                    }
                    if (n14 == n4 || (n9 - n7) * (i - n6) > (n14 - n7) * (n8 - n6)) continue block11;
                    --n14;
                }
            }
        }
    }

    public void DrawRectangle(short s, short s2, short s3, short s4, boolean bl, int n, int n2, int n3) {
        this.DrawRectangle(s, s2, s3, s4, bl, n, n2, n3, 255);
    }

    public void DrawRoundRectangle(short s, short s2, short s3, short s4, short s5, short s6, boolean bl, Color888 color888) {
        this.DrawRoundRectangle(s, s2, s3, s4, s5, s6, bl, color888, 255);
    }

    public void DrawFrame(short s, short s2, short s3, short s4, Color888 color888) {
        this.DrawFrame(s, s2, s3, s4, color888, 255);
    }

    public void DrawAbsoluteSolidRectangle(short s, short s2, short s3, short s4, int n, int n2, int n3) {
        this.DrawAbsoluteSolidRectangle(s, s2, s3, s4, n, n2, n3, 255);
    }

    public void DrawAbsoluteLine(short s, short s2, short s3, short s4, Color888 color888) {
        this.DrawAbsoluteLine(s, s2, s3, s4, color888, 255);
    }

    public void DrawLine(short s, short s2, short s3, short s4, Color888 color888) {
        this.DrawLine(s, s2, s3, s4, color888, 255);
    }

    public void DrawPixel(short s, short s2, Color888 color888) {
        this.DrawPixel(s, s2, color888, 255);
    }

    public void DrawTiledBitmapSection(FlBitmap flBitmap, short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9, short s10, short s11, short s12) {
        this.DrawTiledBitmapSection(flBitmap, s, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, 255);
    }

    public void DrawTiledBitmapSection(FlBitmap flBitmap, short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8) {
        this.DrawTiledBitmapSection(flBitmap, s, s2, s3, s4, s5, s6, s7, s8, 255);
    }

    public void GenericFillAbsoluteTriangle(short s, short s2, short s3, short s4, short s5, short s6, Color888 color888) {
        this.GenericFillAbsoluteTriangle(s, s2, s3, s4, s5, s6, color888, 255);
    }
}

