/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

public class BlMath {
    public static float DEGREES_PER_RADIAN = 57.29578f;
    public static float RADIANS_PER_DEGREE = (float)Math.PI / 180;
    public static float QUARTER_PI = 0.7853982f;
    public static float HALF_PI = 1.5707964f;
    public static float THREE_QUARTER_PI = 2.3561945f;
    public static float PI = (float)Math.PI;
    public static float TWO_PI = (float)Math.PI * 2;
    public static float E = (float)Math.E;

    public static int Abs(int n) {
        return Math.abs(n);
    }

    public static long Abs(long l) {
        return Math.abs(l);
    }

    public static int Signum(int n) {
        return -n >> 31 & 1 | -(n >> 31 & 1);
    }

    public static long Signum(long l) {
        return -l >> 63 & 1L | -(l >> 63 & 1L);
    }

    public static int Min(int n, int n2) {
        if (n < n2) {
            n2 = n;
        }
        return n2;
    }

    public static long Min(long l, long l2) {
        if (l < l2) {
            l2 = l;
        }
        return l2;
    }

    public static int Min(int[] nArray, int n) {
        int n2 = nArray[0];
        for (int i = 1; i < n; ++i) {
            n2 = BlMath.Min(n2, nArray[i]);
        }
        return n2;
    }

    public static long Min(long[] lArray, int n) {
        long l = lArray[0];
        for (int i = 1; i < n; ++i) {
            l = BlMath.Min(l, lArray[i]);
        }
        return l;
    }

    public static int Max(int n, int n2) {
        if (n > n2) {
            n2 = n;
        }
        return n2;
    }

    public static long Max(long l, long l2) {
        if (l > l2) {
            l2 = l;
        }
        return l2;
    }

    public static int Max(int[] nArray, int n) {
        int n2 = nArray[0];
        for (int i = 1; i < n; ++i) {
            n2 = BlMath.Max(n2, nArray[i]);
        }
        return n2;
    }

    public static long Max(long[] lArray, int n) {
        long l = lArray[0];
        for (int i = 1; i < n; ++i) {
            l = BlMath.Max(l, lArray[i]);
        }
        return l;
    }

    public static int Pow(int n, int n2) {
        if (n == 0 || n2 < 0) {
            return 0;
        }
        if (n2 == 0) {
            return 1;
        }
        int n3 = 1;
        while (n2 != 0) {
            if ((n2 & 1) == 1) {
                n3 *= n;
            }
            n *= n;
            n2 >>= 1;
        }
        return n3;
    }

    public static long Pow(long l, long l2) {
        if (l2 < 0L || l == 0L) {
            return 0L;
        }
        if (l2 == 0L) {
            return 1L;
        }
        long l3 = 1L;
        while (l2 != 0L) {
            if ((l2 & 1L) != 0L) {
                l3 *= l;
            }
            l *= l;
            l2 >>= 1;
        }
        return l3;
    }

    public static boolean IsOdd(int n) {
        return (n & 1) == 1;
    }

    public static boolean IsOdd(long l) {
        return (l & 1L) == 1L;
    }

    public static boolean IsEven(int n) {
        return (n & 1) == 0;
    }

    public static boolean IsEven(long l) {
        return (l & 1L) == 0L;
    }

    public static boolean IsPower2(int n) {
        return (n & n - 1) == 0;
    }

    public static boolean IsPower2(long l) {
        return (l & l - 1L) == 0L;
    }

    public static float Abs(float f) {
        return Math.abs(f);
    }

    public static float Signum(float f) {
        return f < 0.0f ? -1.0f : (f > 0.0f ? 1.0f : f);
    }

    public static float Min(float f, float f2) {
        return Math.min(f, f2);
    }

    public static float Min(float[] fArray, int n) {
        float f = fArray[0];
        for (int i = 1; i < n; ++i) {
            f = BlMath.Min(f, fArray[i]);
        }
        return f;
    }

    public static float Max(float f, float f2) {
        return Math.max(f, f2);
    }

    public static float Max(float[] fArray, int n) {
        float f = fArray[0];
        for (int i = 1; i < n; ++i) {
            f = BlMath.Max(f, fArray[i]);
        }
        return f;
    }

    public static int Round(float f) {
        return (int)BlMath.Floor(f + 0.5f);
    }

    public static float Ceil(float f) {
        return (float)Math.ceil(f);
    }

    public static double Ceil(double d) {
        return Math.ceil(d);
    }

    public static float Floor(float f) {
        return (float)Math.floor(f);
    }

    public static double Floor(double d) {
        return Math.floor(d);
    }

    public static float Sqrt(float f) {
        return (float)Math.sqrt(f);
    }

    public static float Sin(float f) {
        return (float)Math.sin(f);
    }

    public static float Cos(float f) {
        return (float)Math.cos(f);
    }

    public static float Tan(float f) {
        return (float)Math.tan(f);
    }

    public static float ToRadians(float f) {
        return (float)Math.toRadians(f);
    }

    public static float ToDegrees(float f) {
        return (float)Math.toDegrees(f);
    }

    public static boolean IsNaN(float f) {
        return f != f;
    }

    public static boolean IsNaN(double d) {
        return d != d;
    }

    public static boolean IsNegativeZero(float f) {
        int n = Integer.MIN_VALUE;
        return Float.floatToIntBits(f) == n;
    }

    public static boolean IsNegativeZero(double d) {
        long l = Long.MIN_VALUE;
        return Double.doubleToLongBits(d) == l;
    }

    public static boolean IsPositiveZero(float f) {
        int n = 0;
        return Float.floatToIntBits(f) == n;
    }

    public static boolean IsPositiveZero(double d) {
        long l = 0L;
        return Double.doubleToLongBits(d) == l;
    }

    public static BlMath[] InstArrayBlMath(int n) {
        BlMath[] blMathArray = new BlMath[n];
        for (int i = 0; i < n; ++i) {
            blMathArray[i] = new BlMath();
        }
        return blMathArray;
    }

    public static BlMath[][] InstArrayBlMath(int n, int n2) {
        BlMath[][] blMathArray = new BlMath[n][];
        for (int i = 0; i < n; ++i) {
            blMathArray[i] = new BlMath[n2];
            for (int j = 0; j < n2; ++j) {
                blMathArray[i][j] = new BlMath();
            }
        }
        return blMathArray;
    }

    public static BlMath[][][] InstArrayBlMath(int n, int n2, int n3) {
        BlMath[][][] blMathArray = new BlMath[n][][];
        for (int i = 0; i < n; ++i) {
            blMathArray[i] = new BlMath[n2][];
            for (int j = 0; j < n2; ++j) {
                blMathArray[i][j] = new BlMath[n3];
                for (int k = 0; k < n3; ++k) {
                    blMathArray[i][j][k] = new BlMath();
                }
            }
        }
        return blMathArray;
    }
}

