/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.BlMath;

public class BlFixed {
    public static final int FP_8 = 8;
    public static final int FP_16 = 16;
    public static final int FP_24 = 24;
    public static final int FP_32 = 32;
    public static final int FP_40 = 40;
    public static final int FP_48 = 48;
    public static final int FP_56 = 56;

    public static int ToFixed32(int n, int n2) {
        return n << n2;
    }

    public static int ToInt32(int n, int n2) {
        return n >> n2;
    }

    public static int ToFixed32(float f, int n) {
        return (int)(f * (float)(1 << n));
    }

    public static float ToFloat(int n, int n2) {
        return (float)n / (float)(1 << n2);
    }

    public static int ToFixed32(double d, int n) {
        return (int)(d * (double)(1 << n));
    }

    public static double ToDouble(int n, int n2) {
        return (double)n / (double)(1 << n2);
    }

    public static int Abs(int n) {
        return BlMath.Abs(n);
    }

    public static int Signum(int n) {
        return BlMath.Signum(n);
    }

    public static int Min(int n, int n2) {
        return BlMath.Min(n, n2);
    }

    public static int Min(int[] nArray, int n) {
        return BlMath.Min(nArray, n);
    }

    public static int Max(int n, int n2) {
        return BlMath.Max(n, n2);
    }

    public static int Max(int[] nArray, int n) {
        return BlMath.Max(nArray, n);
    }

    public static int Ceil(int n, int n2) {
        return -(-n >> n2 << n2);
    }

    public static int Floor(int n, int n2) {
        return n >> n2 << n2;
    }

    public static int Mul(int n, int n2, int n3) {
        return (int)((long)n * (long)n2 >> n3);
    }

    public static int MulPower2(int n, int n2) {
        return n << n2;
    }

    public static int Div(int n, int n2, int n3) {
        return (int)(((long)n << n3) / (long)n2);
    }

    public static int DivPower2(int n, int n2) {
        return n >> n2;
    }

    public static int Inverse(int n, int n2) {
        long l = 0x4000000000000000L;
        l /= (long)n;
        return (int)(l >>= 62 - 2 * n2);
    }

    public static int Square(int n, int n2) {
        return BlFixed.Mul(n, n, n2);
    }

    public static int Pow(int n, int n2, int n3) {
        return 0;
    }

    public static int Sqrt(int n, int n2) {
        int n3 = 0;
        long l = n;
        n3 = (int)Math.sqrt(l <<= n2);
        return n3;
    }

    public static int Sin(int n, int n2) {
        int n3 = BlFixed.Pi(n2);
        int n4 = BlFixed.DivPower2(n3, 1);
        int n5 = BlFixed.MulPower2(n3, 1);
        if (n < 0) {
            while ((n += n5) < 0) {
            }
        } else if (n > n5) {
            while ((n -= n5) > n5) {
            }
        }
        int n6 = 1;
        if (n > n3) {
            if (n > n3 + n4) {
                n = (n3 << 1) - n;
                n6 = -1;
            } else {
                n -= n3;
                n6 = -1;
            }
        } else if (n > n4) {
            n = n3 - n;
        }
        int n7 = BlFixed.Square(n, n2);
        int n8 = BlFixed.ConvertFP16(498, n2);
        n8 = BlFixed.Mul(n8, n7, n2);
        n8 -= BlFixed.ConvertFP16(10882, n2);
        n8 = BlFixed.Mul(n8, n7, n2);
        n8 += 1 << n2;
        n8 = BlFixed.Mul(n8, n, n2);
        return n8 *= n6;
    }

    public static int Cos(int n, int n2) {
        int n3 = BlFixed.Pi(n2);
        int n4 = BlFixed.DivPower2(n3, 1);
        int n5 = BlFixed.MulPower2(n3, 1);
        if (n < 0) {
            while ((n += n5) < 0) {
            }
        } else if (n > n5) {
            while ((n -= n5) > n5) {
            }
        }
        int n6 = 1;
        if (n > n3) {
            if (n > n3 + n4) {
                n = (n3 << 1) - n;
            } else {
                n -= n3;
                n6 = -1;
            }
        } else if (n > n4) {
            n = n3 - n;
            n6 = -1;
        }
        int n7 = BlFixed.Square(n, n2);
        int n8 = BlFixed.Mul(BlFixed.ConvertFP16(2428, n2), n7, n2);
        n8 -= BlFixed.ConvertFP16(32551, n2);
        n8 = BlFixed.Mul(n8, n7, n2);
        n8 += 1 << n2;
        return n8 *= n6;
    }

    public static int Tan(int n, int n2) {
        int n3 = BlFixed.MulPower2(BlFixed.Pi(n2), 1);
        while (n > n3) {
            n -= n3;
        }
        while (n < 0) {
            n += n3;
        }
        int n4 = BlFixed.Square(n, n2);
        int n5 = BlFixed.ConvertFP16(13323, n2);
        n5 = BlFixed.Mul(n5, n4, n2);
        n5 += BlFixed.ConvertFP16(20810, n2);
        n5 = BlFixed.Mul(n5, n4, n2);
        n5 += BlFixed.One(n2);
        n5 = BlFixed.Mul(n, n5, n2);
        return n5;
    }

    public static int Asin(int n, int n2) {
        if (n < 0) {
            return -BlFixed.Asin(-n, n2);
        }
        int n3 = BlFixed.Sqrt(BlFixed.One(n2) - n, n2);
        int n4 = BlFixed.ConvertFP16(-1228, n2);
        n4 = BlFixed.Mul(n, n4, n2);
        n4 += BlFixed.ConvertFP16(4866, n2);
        n4 = BlFixed.Mul(n, n4, n2);
        n4 -= BlFixed.ConvertFP16(13901, n2);
        n4 = BlFixed.Mul(n, n4, n2);
        n4 += BlFixed.ConvertFP16(102939, n2);
        n4 = BlFixed.DivPower2(BlFixed.Pi(n2), 1) - BlFixed.Mul(n4, n3, n2);
        return n4;
    }

    public static int Acos(int n, int n2) {
        if (n < 0) {
            return -(BlFixed.Acos(-n, n2) - BlFixed.Pi(n2));
        }
        if (n >= BlFixed.One(n2)) {
            return 0;
        }
        int n3 = BlFixed.Sqrt(BlFixed.One(n2) - n, n2);
        int n4 = BlFixed.ConvertFP16(-1228, n2);
        n4 = BlFixed.Mul(n, n4, n2);
        n4 += BlFixed.ConvertFP16(4866, n2);
        n4 = BlFixed.Mul(n, n4, n2);
        n4 -= BlFixed.ConvertFP16(13901, n2);
        n4 = BlFixed.Mul(n, n4, n2);
        n4 += BlFixed.ConvertFP16(102939, n2);
        n4 = BlFixed.Mul(n4, n3, n2);
        return n4;
    }

    public static int Atan(int n, int n2) {
        if (BlFixed.Abs(n) > BlFixed.One(n2)) {
            if (n > 0) {
                return BlFixed.DivPower2(BlFixed.Pi(n2), 1) - BlFixed.Atan(BlFixed.Inverse(n, n2), n2);
            }
            return -BlFixed.DivPower2(BlFixed.Pi(n2), 1) - BlFixed.Atan(BlFixed.Inverse(n, n2), n2);
        }
        int n3 = BlFixed.Square(n, n2);
        int n4 = BlFixed.ConvertFP16(1365, n2);
        n4 = BlFixed.Mul(n4, n3, n2);
        n4 -= BlFixed.ConvertFP16(5579, n2);
        n4 = BlFixed.Mul(n4, n3, n2);
        n4 += BlFixed.ConvertFP16(11805, n2);
        n4 = BlFixed.Mul(n4, n3, n2);
        n4 -= BlFixed.ConvertFP16(21646, n2);
        n4 = BlFixed.Mul(n4, n3, n2);
        n4 += BlFixed.ConvertFP16(65527, n2);
        n4 = BlFixed.Mul(n, n4, n2);
        return n4;
    }

    public static int Atan2(int n, int n2, int n3) {
        if (BlFixed.Abs(n2) < BlFixed.Epsilon()) {
            if (BlFixed.Abs(n) < BlFixed.Epsilon()) {
                return 0;
            }
            if (n >= 0) {
                return BlFixed.DivPower2(BlFixed.Pi(n3), 1);
            }
            return -BlFixed.DivPower2(BlFixed.Pi(n3), 1);
        }
        int n4 = BlFixed.Div(n, n2, n3);
        if (n2 < 0) {
            int n5 = BlFixed.Atan(BlFixed.Abs(n4), n3);
            n5 = BlFixed.Pi(n3) - n5;
            if (n < 0) {
                return -n5;
            }
            return n5;
        }
        return BlFixed.Atan(n4, n3);
    }

    public static int Exp(int n, int n2) {
        return 0;
    }

    public static int Log(int n, int n2) {
        return 0;
    }

    public static int Log10(int n, int n2) {
        return 0;
    }

    public static int IncreaseFractionalPartSize(int n, int n2) {
        return n << n2;
    }

    public static int DecreaseFractionalPartSize(int n, int n2) {
        return n >> n2;
    }

    public static int Round(int n, int n2) {
        return BlFixed.ToInt32(BlFixed.Floor(n + BlFixed.Half(n2), n2), n2);
    }

    public static int Zero() {
        return 0;
    }

    public static int Epsilon() {
        return 10;
    }

    public static int OneHundredth(int n) {
        return BlFixed.Inverse(BlFixed.ToFixed32(100, n), n);
    }

    public static int Quarter(int n) {
        return 1 << n - 2;
    }

    public static int Half(int n) {
        return 1 << n - 1;
    }

    public static int ThreeQuarters(int n) {
        return 1 << n - 1 | 1 << n - 2;
    }

    public static int One(int n) {
        return 1 << n;
    }

    public static int QuarterPi(int n) {
        return BlFixed.ConvertFP16(51472, n);
    }

    public static int HalfPi(int n) {
        return BlFixed.ConvertFP16(102944, n);
    }

    public static int ThreeQuarterPi(int n) {
        return BlFixed.ConvertFP16(154416, n);
    }

    public static int Pi(int n) {
        return BlFixed.ConvertFP16(205887, n);
    }

    public static int TwoPi(int n) {
        return BlFixed.ConvertFP16(411775, n);
    }

    public static int DegreesPerRadian(int n) {
        return BlFixed.ConvertFP16(1144, n);
    }

    public static int RadiansPerDegree(int n) {
        return BlFixed.ConvertFP16(3754936, n);
    }

    public static int E(int n) {
        return BlFixed.ConvertFP16(178145, n);
    }

    public static int ConvertFP16(int n, int n2) {
        if (n2 == 16) {
            return n;
        }
        if (n2 < 16) {
            return n >> 16 - n2;
        }
        return n << n2 - 16;
    }

    public static int ToFixed32(int n) {
        return BlFixed.ToFixed32(n, 16);
    }

    public static int ToInt32(int n) {
        return BlFixed.ToInt32(n, 16);
    }

    public static int ToFixed32(float f) {
        return BlFixed.ToFixed32(f, 16);
    }

    public static float ToFloat(int n) {
        return BlFixed.ToFloat(n, 16);
    }

    public static int ToFixed32(double d) {
        return BlFixed.ToFixed32(d, 16);
    }

    public static double ToDouble(int n) {
        return BlFixed.ToDouble(n, 16);
    }

    public static int Ceil(int n) {
        return BlFixed.Ceil(n, 16);
    }

    public static int Floor(int n) {
        return BlFixed.Floor(n, 16);
    }

    public static int Mul(int n, int n2) {
        return BlFixed.Mul(n, n2, 16);
    }

    public static int Div(int n, int n2) {
        return BlFixed.Div(n, n2, 16);
    }

    public static int Inverse(int n) {
        return BlFixed.Inverse(n, 16);
    }

    public static int Square(int n) {
        return BlFixed.Square(n, 16);
    }

    public static int Pow(int n, int n2) {
        return BlFixed.Pow(n, n2, 16);
    }

    public static int Sqrt(int n) {
        return BlFixed.Sqrt(n, 16);
    }

    public static int Sin(int n) {
        return BlFixed.Sin(n, 16);
    }

    public static int Cos(int n) {
        return BlFixed.Cos(n, 16);
    }

    public static int Tan(int n) {
        return BlFixed.Tan(n, 16);
    }

    public static int Asin(int n) {
        return BlFixed.Asin(n, 16);
    }

    public static int Acos(int n) {
        return BlFixed.Acos(n, 16);
    }

    public static int Atan(int n) {
        return BlFixed.Atan(n, 16);
    }

    public static int Atan2(int n, int n2) {
        return BlFixed.Atan2(n, n2, 16);
    }

    public static int Exp(int n) {
        return BlFixed.Exp(n, 16);
    }

    public static int Log(int n) {
        return BlFixed.Log(n, 16);
    }

    public static int Log10(int n) {
        return BlFixed.Log10(n, 16);
    }

    public static int Round(int n) {
        return BlFixed.Round(n, 16);
    }

    public static int OneHundredth() {
        return BlFixed.OneHundredth(16);
    }

    public static int Quarter() {
        return BlFixed.Quarter(16);
    }

    public static int Half() {
        return BlFixed.Half(16);
    }

    public static int ThreeQuarters() {
        return BlFixed.ThreeQuarters(16);
    }

    public static int One() {
        return BlFixed.One(16);
    }

    public static int QuarterPi() {
        return BlFixed.QuarterPi(16);
    }

    public static int HalfPi() {
        return BlFixed.HalfPi(16);
    }

    public static int ThreeQuarterPi() {
        return BlFixed.ThreeQuarterPi(16);
    }

    public static int Pi() {
        return BlFixed.Pi(16);
    }

    public static int TwoPi() {
        return BlFixed.TwoPi(16);
    }

    public static int DegreesPerRadian() {
        return BlFixed.DegreesPerRadian(16);
    }

    public static int RadiansPerDegree() {
        return BlFixed.RadiansPerDegree(16);
    }

    public static int E() {
        return BlFixed.E(16);
    }

    public static BlFixed[] InstArrayBlFixed(int n) {
        BlFixed[] blFixedArray = new BlFixed[n];
        for (int i = 0; i < n; ++i) {
            blFixedArray[i] = new BlFixed();
        }
        return blFixedArray;
    }

    public static BlFixed[][] InstArrayBlFixed(int n, int n2) {
        BlFixed[][] blFixedArray = new BlFixed[n][];
        for (int i = 0; i < n; ++i) {
            blFixedArray[i] = new BlFixed[n2];
            for (int j = 0; j < n2; ++j) {
                blFixedArray[i][j] = new BlFixed();
            }
        }
        return blFixedArray;
    }

    public static BlFixed[][][] InstArrayBlFixed(int n, int n2, int n3) {
        BlFixed[][][] blFixedArray = new BlFixed[n][][];
        for (int i = 0; i < n; ++i) {
            blFixedArray[i] = new BlFixed[n2][];
            for (int j = 0; j < n2; ++j) {
                blFixedArray[i][j] = new BlFixed[n3];
                for (int k = 0; k < n3; ++k) {
                    blFixedArray[i][j][k] = new BlFixed();
                }
            }
        }
        return blFixedArray;
    }
}

