/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import ca.jamdat.flight.FlBrowser;
import com.ea.sdk.SDKConfig;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKImpl;
import com.ea.sdk.SDKKeys;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;
import java.util.Vector;
import javax.microedition.lcdui.Font;

public class SDKMoreGames16
implements SDKKeys {
    public static final int NORMAL_FONT = 0;
    public static final int UNSELECTED_BUTTON_FONT = 1;
    public static final int SELECTED_BUTTON_FONT = 2;
    public static final int SOFTKEY_FONT = 3;
    public static final int TITLE_FONT = 4;
    public static final int FONT_COUNT = 5;
    public static final String CONTEXT_MAIN_MENU = "mnu";
    public static final String CONTEXT_END_GAME = "end";
    public static final String CONTEXT_HALF_TIME = "hlf";
    private static final String REPORTING_CONTEXT_NAME = "ctx";
    private static final String REPORTING_LANGUAGE_NAME = "lng";
    private static final String REPORTING_JAD_NAME_PREFIX = "MG_REPORTING_NAME";
    private static final String REPORTING_JAD_VALUE_PREFIX = "MG_REPORTING_VALUE";
    private static final String CLASS_NAME = "SDKMoreGames16";
    private static final byte BINARY_FORMAT_MARKER = 1;
    private static final byte ANIM_MAX = 6;
    public static final byte RESULT_OK = 0;
    public static final byte RESULT_REFRESH_MENU = 1;
    private static final String STR_MG_PRODUCTS = "MG_PRODUCTS";
    private static final String STR_MG_IMPL = "MG_Impl";
    private static final String STR_MG_BUYURI = "MG_BUYURI_";
    private static final String STR_MG_CATURI = "MG_CATURI_";
    private static final String STR_MG_MGPANEL = "MG_MGPANEL";
    private static final String STR_IMPL_OFF = "off";
    private static final String STR_IMPL_STATIC = "static";
    private static final String STR_IMPL_WAP = "wap";
    private static final String STR_IMPL_WAP_STATIC = "wapstatic";
    private static final char SEPARATOR = ',';
    private static final String STR_GENERIC_ID = "LOG";
    private static final String STR_PANEL_PREFIX = "MGPANEL";
    private static final String STR_IMAGE_PREFIX = "mgi";
    private static final String STR_IMAGE_SEPARATOR = "_";
    private static final String STR_ICON_PREFIX = "mgc";
    private static final String STR_IMAGE_SUFIX = ".png";
    private static final int STRING_COUNT = 11;
    private static final int STRING_STATIC = 0;
    private static final int STRING_GENERIC = 1;
    private static final int STRING_GENERIC_BTN = 2;
    private static final int STRING_GENERIC_NAME = 3;
    private static final int STRING_CONFIRM = 4;
    private static final int STRING_SELECT = 5;
    private static final int STRING_BACK = 6;
    private static final int STRING_YES = 7;
    private static final int STRING_NO = 8;
    private static final int STRING_TITLE = 9;
    private static final int STRING_BUY = 10;
    private static final byte IMPL_OFF = 0;
    private static final byte IMPL_STATIC = 1;
    private static final byte IMPL_WAP = 2;
    private static final byte IMPL_WAPSTATIC = 3;
    private static final int STATE_GAME = 0;
    private static final int STATE_CONFIRM = 1;
    private static final int STATE_STATIC = 2;
    private static final int STATE_PANEL = 3;
    private static final int GENERIC_INDEX = -1;
    private static final int INVALID_INDEX = -2;
    private static final int PANEL_BITMASK = Integer.MIN_VALUE;
    private static final int BUTTON_BUY = 0;
    private static final int BUTTON_MORE = 1;
    private static final int BUTTON_NONE = 2;
    private static final int COLOR_BACKGROUND = -1;
    private static final int COLOR_HEADER_BG = -16757361;
    private static final int COLOR_BLUE = -16757361;
    private static final int COLOR_LIGHTBLUE = -9462329;
    private static final int COLOR_BLACK = -16777216;
    private static final byte SPACE_V_SOFTKEY_PADDING = 0;
    private static final byte SPACE_V_ABOVE_SOFTKEYS = 2;
    private static final byte SPACE_V_BETWEEN_BUTTONS = 2;
    private static final byte SPACE_V_ABOVE_BUTTONS = 2;
    private static final byte SPACE_V_BUTTON_TOP_PADDING = 2;
    private static final byte SPACE_V_BUTTON_BOTTOM_PADDING = 3;
    private static final byte SPACE_V_BELOW_HEADER = 1;
    private static final byte SPACE_V_TITLE_PADDING = 1;
    private static final byte SPACE_ARROW_SIZE = SDKConfig.getMoreGamesArrowSize();
    private static final byte SPACE_H_ARROW_SPACING = 1;
    private static final byte SPACE_H_ARROW_AREA = (byte)(0 + SPACE_ARROW_SIZE + 6);
    private static final byte SPACE_H_STATIC_PADDING = 10;
    private static final byte SPACE_H_BUTTON_DECORATION_SPACING = 3;
    private static final byte SPACE_H_BUTTON_PADDING = 6;
    private static final byte SPACE_H_TEXT = 2;
    private static final byte SPACE_V_MGP_BETWEEN_LINES = 4;
    private static final byte SPACE_ICON_TEXT_GAP = 4;
    private static final byte CHEAT_STATE_NO_CHEAT = -1;
    private static final byte CHEAT_STATE_OFF = 0;
    private static final byte CHEAT_STATE_STATIC = 1;
    private static final byte CHEAT_STATE_WAP = 2;
    private static final byte CHEAT_STATE_WAPSTATIC = 3;
    private static final byte CHEAT_STATE_ABSENT = 2;
    private static final byte CHEAT_TYPE_IMPLEMENTATION = 0;
    private static final byte CHEAT_TYPE_CATURI = 1;
    private static final byte CHEAT_TYPE_BUYURI = 2;
    private static final byte CHEAT_TYPE_PRODUCT_COUNT = 3;
    private static final byte CHEAT_TYPE_PRODUCT_ORDER = 4;
    private static final byte CHEATS_COUNT = 5;
    private static final byte[] cheatsStatus = new byte[5];
    private static boolean cheatsEnabled;
    private static final int CHEAT_STATE_CODE = 0;
    private static final int CHEAT_STATE_VALUE = 1;
    private static final short CHEAT_SEQ_PRODUCTS_NO = -26472;
    private static final short CHEAT_SEQ_PRODUCTS_ORDER = -26461;
    private static final short CHEAT_SEQ_IMPL = -26475;
    private static final short CHEAT_SEQ_CATURI = -26473;
    private static final short CHEAT_SEQ_BUYURI = -26476;
    private short keySequence;
    private int currentCheatState = 0;
    private int currentCheat = -1;
    private int screenHeight = -1;
    private int screenWidth = -1;
    private String[] productIDs;
    private short[] productNames;
    private short[] productCategories;
    private short[] productTags;
    private int[] screenOrder;
    private String[] buyUris;
    private String[] catUris;
    private short[] stringIDs = new short[11];
    private SDKString[] strings = new SDKString[11];
    private Object[] fonts;
    private int mode = 0;
    private boolean active;
    private int keyState;
    private SDKMIDlet sdkMidlet;
    private boolean drawSoftKeys = true;
    private int currentIndex;
    private int state = 0;
    private int previousState = 0;
    private int currentGameID;
    private String currentURI;
    private SDKImage currentImage;
    private SDKImage currentOverlay;
    private short currentOverlayX = (short)-1;
    private short currentOverlayY = (short)-1;
    private int currentSelectedPanelIndex;
    private int currentPanelScrollingIndex;
    private int actualItemCount;
    private short[] staticWrap;
    private short[] confirmWrap;
    private short[] tagWrap;
    private short[] titleWrap;
    private String currentContext;
    private SDKString currentTag;
    private SDKString currentName;
    private SDKString currentCtg;
    private boolean buyButtonEnabled = true;
    private boolean catButtonEnabled = true;
    private int currentButton = 0;
    private int currentPannelID;
    private int headerSize;
    private int layoutTitleY = 0;
    private int buttonWidth;
    private int anim = 6;
    private int layoutImageY;
    private int layoutArrowY;
    private int layoutTagY;
    private int layoutBuyButtonY;
    private int layoutCatButtonY;
    private int layoutSoftkeySize;
    private boolean drawHeader;
    private int layoutBottomArrowTipY;
    private int layoutTopArrowTipY;
    private int layoutListStartY;
    private int layoutHorizontalOffset;
    private int layoutPanelItemSize;
    private short[][] overlayX;
    private short[][] overlayY;
    private short[] panelTitles;
    private short[][] panelItemNames;
    private String[][] panelItemIDs;
    private SDKString[] currentPanelTargetNames;
    private SDKString currentPanelTitle;
    private int currentPanelTargetCount;
    private int fakeIconWidth;
    private int fakeIconHeight;
    private SDKString lskText;
    private SDKString rskText;
    private SDKImage[] currentPanelIcons;
    private static final boolean WAP_SUPPORTED = true;
    int scrollingOffset = 0;

    public SDKMoreGames16(int n, int n2) {
        if (SDKConfig.getDebugEnabled() && (n <= 0 || n2 <= 0)) {
            SDKUtils.debugLog("SDKMoreGames16::constructor was called with zero or negative screen size. Aborting...", 4);
        }
        this.screenWidth = n;
        this.screenHeight = n2;
        if (SDKConfig.getMoreGamesCheatsEnabled()) {
            for (int i = 0; i < cheatsStatus.length; ++i) {
                SDKMoreGames16.cheatsStatus[i] = -1;
            }
        }
    }

    public final void setScreenSize(int n, int n2) {
        if (SDKConfig.getDebugEnabled() && (n <= 0 || n2 <= 0)) {
            SDKUtils.debugLog("SDKMoreGames16setScreenSize:: was called with zero or negative screen size. Aborting...", 4);
        }
        boolean bl = n != this.screenWidth || n2 != this.screenHeight;
        this.screenWidth = n;
        this.screenHeight = n2;
        if (this.active && bl) {
            if (this.screenOrder[this.currentIndex] == -1 || (this.screenOrder[this.currentIndex] & Integer.MIN_VALUE) == 0) {
                this.doGameLayout();
            } else {
                this.doPanelLayout();
            }
            this.resetWrapStrings();
        }
    }

    public final void setProductData(byte[] byArray) {
        int n;
        int n2;
        short s;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (SDKConfig.getDebugEnabled() && byArray[0] != 1) {
            SDKUtils.debugLog("SDKMoreGames16setProductData::Binary format version for the moregames data is incorrect. expected=1, actual=" + byArray[0], 4);
        }
        int n8 = 1;
        int n9 = byArray[n8++];
        this.productIDs = new String[n9];
        this.productNames = new short[n9];
        this.productCategories = new short[n9];
        this.productTags = new short[n9];
        for (n7 = 0; n7 < n9; ++n7) {
            n6 = byArray[n8++];
            this.productIDs[n7] = new String(byArray, n8, n6);
            n8 += n6;
        }
        n7 = n9 << 1;
        n6 = n9 << 2;
        for (n5 = 0; n5 < n9; ++n5) {
            this.productNames[n5] = SDKUtils.bytesToShort(byArray, n8);
            this.productCategories[n5] = SDKUtils.bytesToShort(byArray, n8 + n7);
            this.productTags[n5] = SDKUtils.bytesToShort(byArray, n8 + n6);
            n8 += 2;
        }
        n8 += n6;
        for (n5 = 0; n5 < this.strings.length; ++n5) {
            this.stringIDs[n5] = SDKUtils.bytesToShort(byArray, n8);
            n8 += 2;
        }
        n5 = byArray[n8++];
        this.overlayX = new short[n5][];
        this.overlayY = new short[n5][];
        for (n4 = 0; n4 < n9; ++n4) {
            for (n3 = 0; n3 < n5; ++n3) {
                s = SDKUtils.bytesToShort(byArray, n8);
                n2 = SDKUtils.bytesToShort(byArray, n8 + 2);
                n8 += 4;
                if (s == -1 || n2 == -1) continue;
                if (this.overlayX[n3] == null) {
                    this.overlayX[n3] = new short[n9];
                    this.overlayY[n3] = new short[n9];
                    for (n = 0; n < n9; ++n) {
                        this.overlayX[n3][n] = -1;
                        this.overlayY[n3][n] = -1;
                    }
                }
                this.overlayX[n3][n4] = s;
                this.overlayY[n3][n4] = n2;
            }
        }
        n4 = byArray[n8++];
        this.panelTitles = new short[n4];
        this.panelItemNames = new short[n4][];
        this.panelItemIDs = new String[n4][];
        for (n3 = 0; n3 < n4; ++n3) {
            s = byArray[n8++];
            this.panelTitles[n3] = SDKUtils.bytesToShort(byArray, n8);
            n8 += 2;
            this.panelItemNames[n3] = new short[s];
            this.panelItemIDs[n3] = new String[s];
            for (n2 = 0; n2 < s; ++n2) {
                this.panelItemNames[n3][n2] = SDKUtils.bytesToShort(byArray, n8);
                n8 += 2;
                n = byArray[n8++];
                this.panelItemIDs[n3][n2] = new String(byArray, n8, n);
                n8 += n;
            }
        }
        if (SDKConfig.getDebugEnabled() && byArray.length != n8) {
            SDKUtils.debugLog("SDKMoreGames16setProductData::Garbage at the end of the product data? Leaving " + (byArray.length - n8) + " bytes unused", 3);
        }
    }

    public final void setFonts(Object[] objectArray) {
        if (SDKConfig.getDebugEnabled()) {
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null) {
                        SDKUtils.debugLog("SDKMoreGames16setFonts:: invalid parameter. The fonts must NOT be null.", 4);
                        continue;
                    }
                    if (objectArray[i] instanceof Object[] && (SDKConfig.getBitmapFontSupport() || SDKConfig.getRectangleFontSupport()) || objectArray[i] instanceof Font && SDKConfig.getSystemFontSupport()) continue;
                    SDKUtils.debugLog("SDKMoreGames16setFonts:: invalid parameter. One of the objects in the fonts array (index " + i + ") does not appear to be a font", 3);
                }
            } else {
                SDKUtils.debugLog("SDKMoreGames16setFonts:: invalid parameter. The font array is NULL.", 4);
            }
        }
        this.fonts = objectArray;
        Object object = SDKUtils.getFont();
        SDKUtils.setFont(objectArray[0]);
        this.fakeIconHeight = SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
        this.fakeIconWidth = SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
        SDKUtils.setFont(object);
    }

    public boolean isAvailable() {
        if (this.screenOrder == null || SDKConfig.getMoreGamesCheatsEnabled() && cheatsEnabled) {
            this.initialize();
        }
        return this.mode != 0;
    }

    public void initialize() {
        int n;
        String string;
        int n2;
        Object object;
        int n3;
        String string2;
        this.sdkMidlet = SDKMIDlet.getInstance();
        if (SDKConfig.getDebugEnabled() && this.sdkMidlet == null) {
            SDKUtils.debugLog("SDKMoreGames16initialize::called before the sdkMidlet is set. Aborting...", 4);
        }
        if ((string2 = this.getAppPropertyWrap(STR_MG_IMPL)) == null) {
            this.mode = 0;
            return;
        }
        String string3 = string2.toLowerCase();
        if (string3.equals(STR_IMPL_STATIC)) {
            this.mode = 1;
        } else {
            if (string3.equals(STR_IMPL_WAP_STATIC)) {
                // empty if block
            }
            if (string3.equals(STR_IMPL_WAP)) {
                this.mode = 2;
            } else if (string3.equals(STR_IMPL_WAP_STATIC)) {
                this.mode = 3;
            } else {
                this.mode = 0;
                return;
            }
        }
        String string4 = this.getAppPropertyWrap(STR_MG_PRODUCTS);
        if (string4 == null || string4.length() == 0) {
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog("SDKMoreGames16initialize::MG_PRODUCTS property in the JAD file is not set or could not be read. More Games will be disabled.", 3);
            }
            this.mode = 0;
            return;
        }
        int n4 = 0;
        int n5 = -1;
        block0: do {
            int n6;
            n3 = string4.indexOf(44, n5 + 1);
            object = null;
            object = n3 == -1 ? string4.substring(n5 + 1) : string4.substring(n5 + 1, n3);
            n5 = n3;
            if (((String)object).startsWith(STR_PANEL_PREFIX) && ((String)object).length() == STR_PANEL_PREFIX.length() + 1 && ((String)object).charAt(((String)object).length() - 1) >= '0' && ((String)object).charAt(((String)object).length() - 1) <= '9') {
                int n7;
                n6 = ((String)object).charAt(((String)object).length() - 1) - 48;
                String string5 = STR_MG_MGPANEL + n6;
                String string6 = this.getAppPropertyWrap(string5);
                if (string6 == null || n6 >= this.panelTitles.length) continue;
                boolean bl = false;
                n2 = -1;
                do {
                    string = (n7 = string6.indexOf(44, n2 + 1)) == -1 ? string6.substring(n2 + 1) : string6.substring(n2 + 1, n7);
                    n2 = n7;
                    for (n = 0; n < this.panelItemIDs[n6].length; ++n) {
                        if (!this.panelItemIDs[n6][n].equals(string)) continue;
                        bl = true;
                    }
                    if (!bl) continue;
                    ++n4;
                    continue block0;
                } while (n7 != -1);
                continue;
            }
            n6 = 0;
            for (int i = 0; i < this.productIDs.length; ++i) {
                if (!this.productIDs[i].equals(object)) continue;
                n6 = 1;
                break;
            }
            if (n6 == 0) continue;
            ++n4;
        } while (n3 != -1);
        if (n4 == 0) {
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog("SDKMoreGames16initialize::Found no valid advertised items in the JAD (MG_PRODUCTS property). More Games will be disabled.", 3);
            }
            this.mode = 0;
        }
        if (SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog("SDKMoreGames16initialize::Found " + n4 + " advertised items", 1);
        }
        this.screenOrder = new int[n4];
        this.buyUris = new String[n4];
        this.catUris = new String[n4];
        n5 = -1;
        n3 = 0;
        object = new Vector();
        Vector<Short> vector = new Vector<Short>();
        for (int i = 0; i < this.screenOrder.length; ++i) {
            int n8 = string4.indexOf(44, n5 + 1);
            String string7 = null;
            string7 = n8 == -1 ? string4.substring(n5 + 1) : string4.substring(n5 + 1, n8);
            n5 = n8;
            if (string7.startsWith(STR_PANEL_PREFIX) && string7.length() == STR_PANEL_PREFIX.length() + 1 && string7.charAt(string7.length() - 1) >= '0' && string7.charAt(string7.length() - 1) <= '9') {
                n2 = string7.charAt(string7.length() - 1) - 48;
                String string8 = STR_MG_MGPANEL + n2;
                string = this.getAppPropertyWrap(string8);
                if (string != null && n2 < this.panelTitles.length) {
                    int n9;
                    ((Vector)object).setSize(0);
                    vector.setSize(0);
                    n = -1;
                    do {
                        String string9 = (n9 = string.indexOf(44, n + 1)) == -1 ? string.substring(n + 1) : string.substring(n + 1, n9);
                        n = n9;
                        for (int j = 0; j < this.panelItemIDs[n2].length; ++j) {
                            if (!this.panelItemIDs[n2][j].equals(string9) || ((Vector)object).contains(string9)) continue;
                            ((Vector)object).addElement(string9);
                            vector.addElement(new Short(this.panelItemNames[n2][j]));
                        }
                    } while (n9 != -1);
                    if (((Vector)object).size() != 0) {
                        this.screenOrder[i] = n2 | Integer.MIN_VALUE;
                        n9 = ((Vector)object).size();
                        this.panelItemIDs[n2] = new String[n9];
                        this.panelItemNames[n2] = new short[n9];
                        for (int j = 0; j < n9; ++j) {
                            this.panelItemIDs[n2][j] = ((Vector)object).elementAt(j).toString();
                            this.panelItemNames[n2][j] = (Short)vector.elementAt(j);
                        }
                        if (n3 < n9) {
                            n3 = n9;
                        }
                        if (!SDKConfig.getDebugEnabled()) continue;
                        SDKUtils.debugLog("SDKMoreGames16initialize::Found Panel with index " + n2, 1);
                        continue;
                    }
                    --i;
                    continue;
                }
                if (SDKConfig.getDebugEnabled()) {
                    SDKUtils.debugLog("SDKMoreGames16initialize::Panel with index " + n2 + " is not defined! Skipping...", 3);
                }
                --i;
                continue;
            }
            this.screenOrder[i] = -2;
            this.buyUris[i] = null;
            this.catUris[i] = null;
            for (n2 = 0; n2 < this.productIDs.length; ++n2) {
                if (!this.productIDs[n2].equals(string7)) continue;
                this.screenOrder[i] = n2;
                this.buyUris[i] = this.getAppPropertyWrap(STR_MG_BUYURI + string7);
                this.catUris[i] = this.getAppPropertyWrap(STR_MG_CATURI + string7);
                if (this.buyUris[i] != null) {
                    this.buyUris[i] = this.buyUris[i].trim();
                }
                if (this.catUris[i] != null) {
                    this.catUris[i] = this.catUris[i].trim();
                }
                if (!SDKConfig.getDebugEnabled()) break;
                SDKUtils.debugLog("SDKMoreGames16initialize::Found Game " + string7 + ". CATURI=" + this.catUris[i] + " BUYURI=" + this.buyUris[i], 1);
                break;
            }
            if (this.screenOrder[i] != -2) continue;
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog("SDKMoreGames16initialize::Game '" + string7 + "' mentioned in the JAD (MG_PRODUCTS property) does not exist. Ignoring...", 3);
            }
            --i;
        }
        this.currentPanelTargetNames = new SDKString[n3];
        this.currentPanelIcons = new SDKImage[n3];
    }

    public final boolean isActive() {
        return this.active;
    }

    public final void update() {
        switch (this.state) {
            case 3: {
                if ((this.keyState & 0x804) != 0 && this.screenOrder.length > 0) {
                    --this.currentIndex;
                    if (this.currentIndex < 0) {
                        this.currentIndex = this.screenOrder.length - 1;
                    }
                    this.selectScreen(this.currentIndex);
                } else if ((this.keyState & 0x2008) != 0 && this.screenOrder.length > 0) {
                    ++this.currentIndex;
                    this.currentIndex %= this.screenOrder.length;
                    this.selectScreen(this.currentIndex);
                } else if ((this.keyState & 0x80040) != 0) {
                    this.active = false;
                    this.cleanUp();
                } else if ((this.keyState & 0x201) != 0) {
                    --this.currentSelectedPanelIndex;
                    this.scrollingOffset = 0;
                    if (this.currentSelectedPanelIndex < 0) {
                        this.currentSelectedPanelIndex = this.currentPanelTargetCount - 1;
                    }
                    this.setPanelScreenSoftKeys();
                } else if ((this.keyState & 0x8002) != 0) {
                    ++this.currentSelectedPanelIndex;
                    this.currentSelectedPanelIndex %= this.currentPanelTargetCount;
                    this.scrollingOffset = 0;
                    this.setPanelScreenSoftKeys();
                } else if ((this.keyState & 0x1030) != 0) {
                    String string = null;
                    if (this.mode == 2 || this.mode == 3) {
                        string = this.getAppPropertyWrap(STR_MG_BUYURI + this.panelItemIDs[this.screenOrder[this.currentIndex] & Integer.MAX_VALUE][this.currentSelectedPanelIndex]);
                    }
                    if (string == null) {
                        if (this.mode == 2) break;
                        this.setLeftSoftkeyText(null);
                        this.setRightSoftkeyText(this.strings[6]);
                        this.previousState = this.state;
                        this.state = 2;
                    } else {
                        if (this.mode == 2) {
                            // empty if block
                        }
                        this.currentURI = string;
                        this.previousState = this.state;
                        this.confirmBrowserLaunch();
                    }
                }
                if (this.currentSelectedPanelIndex < this.currentPanelScrollingIndex) {
                    this.currentPanelScrollingIndex = this.currentSelectedPanelIndex;
                    this.scrollingOffset = 0;
                }
                if (this.currentSelectedPanelIndex < this.currentPanelScrollingIndex + this.actualItemCount) break;
                this.currentPanelScrollingIndex = this.currentSelectedPanelIndex - this.actualItemCount + 1;
                this.scrollingOffset = 0;
                break;
            }
            case 0: {
                if ((this.keyState & 0x804) != 0) {
                    --this.currentIndex;
                    if (this.currentIndex < 0) {
                        this.currentIndex = this.screenOrder.length - 1;
                    }
                    this.selectScreen(this.currentIndex);
                    break;
                }
                if ((this.keyState & 0x2008) != 0) {
                    ++this.currentIndex;
                    this.currentIndex %= this.screenOrder.length;
                    this.selectScreen(this.currentIndex);
                    break;
                }
                if (((this.keyState & 0x201) != 0 || (this.keyState & 0x8002) != 0) && this.buyButtonEnabled && this.catButtonEnabled) {
                    if (this.currentButton == 1) {
                        this.currentButton = 0;
                        break;
                    }
                    this.currentButton = 1;
                    break;
                }
                if ((this.keyState & 0x80040) != 0) {
                    this.active = false;
                    this.cleanUp();
                    break;
                }
                if ((this.keyState & 0x1030) == 0) break;
                if (this.currentButton == 0) {
                    this.currentURI = this.buyUris[this.currentIndex];
                    this.previousState = this.state;
                    this.confirmBrowserLaunch();
                    break;
                }
                if (this.currentButton != 1) break;
                if (this.mode == 1 || this.mode == 3 && (this.catUris[this.currentIndex] == null || this.catUris[this.currentIndex].compareTo("") == 0)) {
                    this.setLeftSoftkeyText(null);
                    this.setRightSoftkeyText(this.strings[6]);
                    this.previousState = this.state;
                    this.state = 2;
                    break;
                }
                this.currentURI = this.catUris[this.currentIndex];
                this.previousState = this.state;
                this.confirmBrowserLaunch();
                break;
            }
            case 1: {
                if ((this.keyState & 0x80040) != 0) {
                    this.setLeftSoftkeyText(this.strings[5]);
                    this.setRightSoftkeyText(this.strings[6]);
                    this.state = this.previousState;
                    break;
                }
                if ((this.keyState & 0x20) == 0) break;
                this.applicationWillExit();
                String string = this.appendReportingParameters(this.currentURI);
                this.platformRequestImpl(string);
                SDKMIDlet.exit();
                break;
            }
            case 2: {
                if ((this.keyState & 0x80040) == 0) break;
                this.setLeftSoftkeyText(this.strings[5]);
                this.setRightSoftkeyText(this.strings[6]);
                this.state = this.previousState;
            }
        }
        this.keyState = 0;
    }

    private void setPanelScreenSoftKeys() {
        boolean bl;
        boolean bl2 = this.mode == 2 && null == this.getAppPropertyWrap(STR_MG_BUYURI + this.panelItemIDs[this.screenOrder[this.currentIndex] & Integer.MAX_VALUE][this.currentSelectedPanelIndex]) ? true : (bl = false);
        if (bl) {
            this.setLeftSoftkeyText(null);
        } else {
            this.setLeftSoftkeyText(this.strings[5]);
        }
        this.setRightSoftkeyText(this.strings[6]);
    }

    public final void setDrawSoftKeys(boolean bl) {
        this.drawSoftKeys = bl;
    }

    public final void paint(SDKGraphics sDKGraphics) {
        this.drawBackground(sDKGraphics);
        switch (this.state) {
            case 0: {
                --this.anim;
                if (this.anim < 0) {
                    this.anim = 6;
                }
                if (this.drawHeader) {
                    sDKGraphics.setColor(-16757361);
                    SDKUtils.setFont(this.fonts[4]);
                    sDKGraphics.fillRect(0, 0, this.screenWidth, this.headerSize);
                    SDKUtils.drawString(this.strings[9], this.screenWidth >> 1, 1, 17);
                }
                if (this.currentImage != null) {
                    sDKGraphics.drawImage(this.currentImage, this.screenWidth >> 1, this.layoutImageY, 17);
                    if (this.currentOverlay != null) {
                        sDKGraphics.drawImage(this.currentOverlay, (this.screenWidth - this.currentImage.getWidth() >> 1) + this.currentOverlayX, this.layoutImageY + this.currentOverlayY, 20);
                    }
                    if (this.screenOrder.length > 1) {
                        this.drawLeftArrow(sDKGraphics, (this.screenWidth - this.currentImage.getWidth() >> 2) - (SPACE_ARROW_SIZE >> 1), this.layoutArrowY);
                        this.drawRightArrow(sDKGraphics, this.screenWidth - (this.screenWidth - this.currentImage.getWidth() >> 2) + (SPACE_ARROW_SIZE >> 1), this.layoutArrowY);
                    }
                    SDKUtils.setFont(this.fonts[0]);
                    SDKUtils.drawWrappedString(this.currentName, this.titleWrap, 1, this.titleWrap[0], this.screenWidth >> 1, this.layoutTitleY, 17);
                    SDKUtils.drawWrappedString(this.currentTag, this.tagWrap, 1, this.tagWrap[0], this.screenWidth >> 1, this.layoutTagY, 17);
                } else {
                    SDKUtils.setFont(this.fonts[0]);
                    SDKUtils.drawString(this.currentName, this.screenWidth >> 1, this.layoutImageY, 17);
                    SDKUtils.drawWrappedString(this.currentTag, this.tagWrap, 1, this.tagWrap[0], this.screenWidth >> 1, this.layoutTagY, 17);
                    if (this.screenOrder.length > 1) {
                        this.drawLeftArrow(sDKGraphics, 1, this.layoutArrowY);
                        this.drawRightArrow(sDKGraphics, this.screenWidth - 1, this.layoutArrowY);
                    }
                }
                if (this.buyButtonEnabled) {
                    this.draw3DButton(sDKGraphics, this.layoutBuyButtonY, this.buttonWidth, this.strings[10], this.currentButton == 0);
                }
                if (!this.catButtonEnabled) break;
                this.draw3DButton(sDKGraphics, this.layoutCatButtonY, this.buttonWidth, this.currentCtg, this.currentButton == 1);
                break;
            }
            case 3: {
                --this.anim;
                if (this.anim < 0) {
                    this.anim = 6;
                }
                if (this.drawHeader) {
                    sDKGraphics.setColor(-16757361);
                    sDKGraphics.fillRect(0, 0, this.screenWidth, this.headerSize);
                    SDKUtils.setFont(this.fonts[4]);
                    SDKUtils.drawString(this.currentPanelTitle, this.screenWidth >> 1, 1, 17);
                }
                int n = this.layoutListStartY;
                SDKUtils.setFont(this.fonts[1]);
                for (int i = this.currentPanelScrollingIndex; i < this.currentPanelScrollingIndex + this.actualItemCount; ++i) {
                    if (i == this.currentSelectedPanelIndex) {
                        SDKUtils.setFont(this.fonts[2]);
                    }
                    int n2 = this.fakeIconWidth;
                    if (this.currentPanelIcons[i] != null) {
                        n2 = this.currentPanelIcons[i].getWidth();
                        sDKGraphics.drawImage(this.currentPanelIcons[i], this.layoutHorizontalOffset, n + (this.layoutPanelItemSize >> 1), 6);
                    }
                    int n3 = this.layoutHorizontalOffset + n2 + 4;
                    int n4 = n + (this.layoutPanelItemSize >> 1) - (SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() >> 1);
                    sDKGraphics.setClip(n3, n4, this.screenWidth - this.layoutHorizontalOffset - n3, SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing());
                    if (i == this.currentSelectedPanelIndex) {
                        SDKUtils.drawString(this.currentPanelTargetNames[i], n3 - (this.scrollingOffset >> 1), n4, 20);
                        ++this.scrollingOffset;
                        if (n3 - (this.scrollingOffset >> 1) + SDKUtils.getStringSize(this.currentPanelTargetNames[i]) < this.screenWidth - this.layoutHorizontalOffset) {
                            this.scrollingOffset = 0;
                        }
                    } else {
                        SDKUtils.drawString(this.currentPanelTargetNames[i], n3, n4, 20);
                    }
                    sDKGraphics.setClip(0, 0, this.screenWidth, this.screenHeight);
                    n += this.layoutPanelItemSize;
                    if (i != this.currentSelectedPanelIndex) continue;
                    SDKUtils.setFont(this.fonts[1]);
                }
                if (this.currentPanelScrollingIndex > 0) {
                    this.drawUpArrow(sDKGraphics, this.screenWidth >> 1, this.layoutTopArrowTipY);
                }
                if (this.currentPanelScrollingIndex + this.actualItemCount < this.currentPanelTargetCount) {
                    this.drawDownArrow(sDKGraphics, this.screenWidth >> 1, this.layoutBottomArrowTipY);
                }
                if (this.screenOrder.length <= 1) break;
                this.drawLeftArrow(sDKGraphics, this.layoutHorizontalOffset - SPACE_ARROW_SIZE >> 1, this.screenHeight >> 1);
                this.drawRightArrow(sDKGraphics, this.screenWidth - (this.layoutHorizontalOffset - SPACE_ARROW_SIZE >> 1), this.screenHeight >> 1);
                break;
            }
            case 2: {
                SDKUtils.setFont(this.fonts[0]);
                SDKUtils.drawWrappedString(this.strings[0], this.staticWrap, 1, this.staticWrap[0], this.screenWidth >> 1, this.screenHeight - this.layoutSoftkeySize >> 1, 3);
                break;
            }
            case 1: {
                SDKUtils.setFont(this.fonts[0]);
                SDKUtils.drawWrappedString(this.strings[4], this.confirmWrap, 1, this.confirmWrap[0], this.screenWidth >> 1, this.screenHeight - this.layoutSoftkeySize >> 1, 3);
            }
        }
        if (this.drawSoftKeys) {
            SDKUtils.setFont(this.fonts[3]);
            if (this.lskText != null) {
                SDKUtils.drawString(this.lskText, 2, this.screenHeight + SDKUtils.getLeadingSpacing() - 2, 36);
            }
            if (this.rskText != null) {
                SDKUtils.drawString(this.rskText, this.screenWidth - 2, this.screenHeight + SDKUtils.getLeadingSpacing() - 2, 40);
            }
        }
    }

    public byte processKey(int n) {
        if (SDKConfig.getMoreGamesCheatsEnabled()) {
            if (this.active) {
                this.keyState |= this.translateCode(n);
            } else {
                byte by = this.getKeyNumber(n);
                if (by == -1) {
                    this.keySequence = 0;
                    this.currentCheatState = 0;
                } else if (this.currentCheatState == 0) {
                    this.keySequence = (short)(this.keySequence << 4);
                    this.keySequence = (short)(this.keySequence | by + 1);
                    if (this.keySequence == -26472) {
                        this.currentCheat = 3;
                        this.currentCheatState = 1;
                    } else {
                        if (this.keySequence == -26461) {
                            SDKMoreGames16.cheatsStatus[4] = 1;
                            cheatsEnabled = true;
                            this.keySequence = 0;
                            if (SDKConfig.getDebugEnabled()) {
                                SDKUtils.debugLog("SDKMoreGames16processKey::Activated cheat type=4", 1);
                            }
                            return 1;
                        }
                        if (this.keySequence == -26475) {
                            this.currentCheat = 0;
                            this.currentCheatState = 1;
                        } else if (this.keySequence == -26473) {
                            this.currentCheat = 1;
                            this.currentCheatState = 1;
                        } else if (this.keySequence == -26476) {
                            this.currentCheat = 2;
                            this.currentCheatState = 1;
                        }
                    }
                } else if (this.currentCheatState == 1) {
                    boolean bl = false;
                    if (this.currentCheat == 0) {
                        bl = by < 0 || by > 3;
                    } else if (this.currentCheat == 2 || this.currentCheat == 1) {
                        boolean bl2 = bl = by < 0 || by > 2;
                    }
                    if (!bl) {
                        SDKMoreGames16.cheatsStatus[this.currentCheat] = by;
                        cheatsEnabled = true;
                        if (SDKConfig.getDebugEnabled()) {
                            SDKUtils.debugLog("SDKMoreGames16processKey::Activated cheat type=" + this.currentCheat + ", value=" + by, 1);
                        }
                    }
                    this.currentCheatState = 0;
                    this.keySequence = 0;
                    return 1;
                }
            }
            return 0;
        }
        if (this.active) {
            this.keyState |= this.translateCode(n);
        }
        return 0;
    }

    protected void drawBackground(SDKGraphics sDKGraphics) {
        sDKGraphics.setClip(0, 0, this.screenWidth, this.screenHeight);
        sDKGraphics.setColor(-1);
        sDKGraphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
    }

    protected byte getKeyNumber(int n) {
        for (int i = 0; i < 10; ++i) {
            if ((n & 128 << i) == 0) continue;
            return (byte)i;
        }
        return -1;
    }

    protected int translateCode(int n) {
        return n;
    }

    public void reset(String string) {
        if (SDKConfig.getDebugEnabled()) {
            if (this.sdkMidlet == null) {
                SDKUtils.debugLog("SDKMoreGames16reset:: was called before the sdkMidlet instance was set. Aborting...", 4);
            }
            if (this.productNames == null || this.productCategories == null || this.productTags == null) {
                SDKUtils.debugLog("SDKMoreGames16reset:: was called before seting the product data. Aborting...", 4);
            }
            if (!this.isAvailable()) {
                SDKUtils.debugLog("SDKMoreGames16reset:: was called even though MoreGames is unavailable. Aborting...", 4);
            }
            if (this.fonts == null) {
                SDKUtils.debugLog("SDKMoreGames16reset:: was called before the fonts were set. Aborting...", 4);
            }
            if (string == null || !string.equals(CONTEXT_MAIN_MENU) && !string.equals(CONTEXT_HALF_TIME) && !string.equals(CONTEXT_END_GAME)) {
                SDKUtils.debugLog("SDKMoreGames16reset::was called with an invalid context. Aborting...", 4);
            }
        }
        if (this.screenOrder == null || SDKConfig.getMoreGamesCheatsEnabled() && cheatsEnabled) {
            this.initialize();
        }
        for (int i = 0; i < this.strings.length; ++i) {
            this.strings[i] = SDKUtils.getString(this.stringIDs[i], null);
        }
        this.currentContext = string;
        this.currentIndex = 0;
        this.active = true;
        this.state = 0;
        this.selectScreen(0);
        SDKUtils.setFont(this.fonts[0]);
        this.resetWrapStrings();
    }

    private void resetWrapStrings() {
        this.staticWrap = SDKUtils.wrapString(this.strings[0], null, this.screenWidth - 10, (short)124);
        this.confirmWrap = SDKUtils.wrapString(this.strings[4], null, this.screenWidth - 10, (short)124);
    }

    private void selectScreen(int n) {
        if (this.screenOrder[n] == -1 || (this.screenOrder[n] & Integer.MIN_VALUE) == 0) {
            this.selectGame(n);
            this.state = 0;
        } else {
            this.selectPanel(n);
            this.state = 3;
        }
    }

    private void selectPanel(int n) {
        int n2;
        this.currentPannelID = this.screenOrder[n] & Integer.MAX_VALUE;
        for (n2 = 0; n2 < this.currentPanelIcons.length; ++n2) {
            this.currentPanelIcons[n2] = null;
        }
        for (n2 = 0; n2 < this.panelItemNames[this.currentPannelID].length; ++n2) {
            this.currentPanelTargetNames[n2] = SDKUtils.getString(this.panelItemNames[this.currentPannelID][n2], null);
            try {
                this.currentPanelIcons[n2] = SDKUtils.createImage("/mgc" + this.panelItemIDs[this.currentPannelID][n2].toLowerCase() + STR_IMAGE_SUFIX);
                continue;
            }
            catch (Exception exception) {
                if (!SDKConfig.getDebugEnabled()) continue;
                SDKUtils.debugLog("SDKMoreGames16:selectGame: cannot create icon from /mgc" + this.panelItemIDs[this.currentPannelID][n2].toLowerCase() + STR_IMAGE_SUFIX, 3);
            }
        }
        this.currentPanelTitle = SDKUtils.getString(this.panelTitles[this.currentPannelID], null);
        this.currentSelectedPanelIndex = 0;
        this.currentPanelScrollingIndex = 0;
        this.scrollingOffset = 0;
        this.currentPanelTargetCount = this.panelItemNames[this.currentPannelID].length;
        this.setPanelScreenSoftKeys();
        this.doPanelLayout();
    }

    protected void selectGame(int n) {
        this.currentGameID = this.screenOrder[n];
        if (this.currentGameID != -1) {
            block23: {
                try {
                    this.currentImage = SDKUtils.createImage("/mgi" + this.productIDs[this.currentGameID].toLowerCase() + STR_IMAGE_SUFIX);
                }
                catch (Exception exception) {
                    if (SDKConfig.getDebugEnabled()) {
                        SDKUtils.debugLog("SDKMoreGames16:selectGame: cannot create image from /mgi" + this.productIDs[this.currentGameID].toLowerCase() + STR_IMAGE_SUFIX, 3);
                    }
                    this.currentImage = null;
                }
                int n2 = SDKUtils.getCurrentLanguage();
                this.currentOverlay = null;
                this.currentOverlayX = (short)-1;
                this.currentOverlayY = (short)-1;
                if (this.overlayX[n2] != null && this.overlayX[n2][this.currentGameID] != -1) {
                    try {
                        this.currentOverlay = SDKUtils.createImage("/mgi" + this.productIDs[this.currentGameID].toLowerCase() + STR_IMAGE_SEPARATOR + SDKUtils.getCurrentLanguage() + STR_IMAGE_SUFIX);
                        this.currentOverlayX = this.overlayX[n2][this.currentGameID];
                        this.currentOverlayY = this.overlayY[n2][this.currentGameID];
                    }
                    catch (Exception exception) {
                        if (!SDKConfig.getDebugEnabled()) break block23;
                        SDKUtils.debugLog("SDKMoreGames16:selectGame: cannot create overlay image from /mgi" + this.productIDs[this.currentGameID].toLowerCase() + STR_IMAGE_SEPARATOR + SDKUtils.getCurrentLanguage() + STR_IMAGE_SUFIX, 3);
                    }
                }
            }
            this.currentTag = SDKUtils.getString(this.productTags[this.currentGameID], null);
            this.currentCtg = SDKUtils.getString(this.productCategories[this.currentGameID], null);
            this.currentName = SDKUtils.getString(this.productNames[this.currentGameID], null);
            switch (this.mode) {
                case 1: {
                    this.buyButtonEnabled = false;
                    this.catButtonEnabled = true;
                    this.currentButton = 1;
                    break;
                }
                case 2: {
                    this.buyButtonEnabled = this.buyUris[n] != null && this.buyUris[n].compareTo("") != 0;
                    boolean bl = this.catButtonEnabled = this.catUris[n] != null && this.catUris[n].compareTo("") != 0;
                    if (this.buyButtonEnabled) {
                        this.currentButton = 0;
                        break;
                    }
                    if (this.catButtonEnabled) {
                        this.currentButton = 1;
                        break;
                    }
                    this.currentButton = 2;
                    break;
                }
                case 3: {
                    this.catButtonEnabled = true;
                    if (this.buyUris[n] != null && this.buyUris[n].compareTo("") != 0) {
                        this.buyButtonEnabled = true;
                        this.currentButton = 0;
                        break;
                    }
                    this.buyButtonEnabled = false;
                    this.currentButton = 1;
                }
            }
        } else {
            try {
                this.currentImage = SDKUtils.createImage("/mgi" + STR_GENERIC_ID.toLowerCase() + STR_IMAGE_SUFIX);
            }
            catch (Exception exception) {
                if (SDKConfig.getDebugEnabled()) {
                    SDKUtils.debugLog("SDKMoreGames16:selectGame: cannot create image from /mgi" + STR_GENERIC_ID.toLowerCase() + STR_IMAGE_SUFIX, 3);
                }
                this.currentOverlay = null;
                this.currentOverlayX = (short)-1;
                this.currentOverlayY = (short)-1;
            }
            this.currentTag = this.strings[1];
            this.currentCtg = this.strings[2];
            this.currentName = this.strings[3];
            this.buyButtonEnabled = false;
            if (this.mode == 2 && (this.catUris[n] == null || this.catUris[n].compareTo("") == 0)) {
                this.catButtonEnabled = false;
                this.currentButton = 2;
            } else {
                this.catButtonEnabled = true;
                this.currentButton = 1;
            }
        }
        if (this.currentButton != 2) {
            this.setLeftSoftkeyText(this.strings[5]);
        } else {
            this.setLeftSoftkeyText(null);
        }
        this.setRightSoftkeyText(this.strings[6]);
        this.doGameLayout();
    }

    private void doPanelLayout() {
        int n = this.screenHeight;
        if (this.drawSoftKeys) {
            SDKUtils.setFont(this.fonts[3]);
            this.layoutSoftkeySize = SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() + 0 + 0;
            n -= this.layoutSoftkeySize;
        }
        n -= 2;
        --n;
        n -= SPACE_ARROW_SIZE << 1;
        n -= 8;
        SDKUtils.setFont(this.fonts[4]);
        this.headerSize = SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() + 1 + 1;
        this.drawHeader = true;
        SDKUtils.setFont(this.fonts[0]);
        int n2 = SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
        this.layoutPanelItemSize = this.currentPanelIcons[0] != null && this.currentPanelIcons[0].getHeight() > n2 ? this.currentPanelIcons[0].getHeight() : n2;
        this.layoutPanelItemSize += 4;
        int n3 = (n -= this.headerSize) / this.layoutPanelItemSize;
        int n4 = this.actualItemCount = n3 < this.currentPanelTargetCount ? n3 : this.currentPanelTargetCount;
        if ((n -= this.actualItemCount * (this.layoutPanelItemSize + 1)) < 0) {
            n = 0;
        }
        this.layoutBottomArrowTipY = this.screenHeight - this.layoutSoftkeySize - 2 - (n >> 2) + 3;
        this.layoutTopArrowTipY = this.headerSize + 1 + (n >> 2) + 3;
        this.layoutListStartY = this.headerSize + 1 + SPACE_ARROW_SIZE + (n >> 1) + 3 + 1;
        int n5 = 0;
        SDKUtils.setFont(this.fonts[1]);
        for (int i = 0; i < this.currentPanelTargetCount; ++i) {
            if (i == this.currentSelectedPanelIndex) {
                SDKUtils.setFont(this.fonts[2]);
            }
            int n6 = SDKUtils.getStringSize(this.currentPanelTargetNames[i]);
            if (i == this.currentSelectedPanelIndex) {
                SDKUtils.setFont(this.fonts[1]);
            }
            n6 += 4;
            n6 = this.currentPanelIcons[i] == null ? (n6 += this.fakeIconWidth) : (n6 += this.currentPanelIcons[i].getWidth());
            if (n6 <= n5) continue;
            n5 = n6;
        }
        this.layoutHorizontalOffset = this.screenWidth - n5 >> 1;
        if (this.layoutHorizontalOffset <= SPACE_ARROW_SIZE + 6 + 1) {
            this.layoutHorizontalOffset = SPACE_ARROW_SIZE + 6 + 1;
        }
    }

    private void doGameLayout() {
        int n;
        this.buttonWidth = (this.screenWidth << 2) / 5;
        int n2 = this.screenHeight;
        this.layoutSoftkeySize = 0;
        if (this.drawSoftKeys) {
            SDKUtils.setFont(this.fonts[3]);
            this.layoutSoftkeySize = SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() + 0 + 0;
            n2 -= this.layoutSoftkeySize;
        }
        n2 -= 2;
        if (this.catButtonEnabled) {
            n2 -= 5;
            if (this.currentButton == 1) {
                SDKUtils.setFont(this.fonts[2]);
            } else {
                SDKUtils.setFont(this.fonts[1]);
            }
            this.layoutCatButtonY = n2 -= SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
            n = SDKUtils.getStringSize(this.currentCtg) + 6 + SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() + 6;
            if (n > this.buttonWidth) {
                this.buttonWidth = n;
            }
        }
        if (this.buyButtonEnabled) {
            n2 -= 5;
            if (this.currentButton == 0) {
                SDKUtils.setFont(this.fonts[2]);
            } else {
                SDKUtils.setFont(this.fonts[1]);
            }
            this.layoutBuyButtonY = n2 -= SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
            n = SDKUtils.getStringSize(this.strings[10]) + 6 + SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() + 6;
            if (n > this.buttonWidth) {
                this.buttonWidth = n;
            }
        }
        if (this.catButtonEnabled && this.buyButtonEnabled) {
            this.layoutBuyButtonY = n2 -= 2;
        }
        n2 -= 2;
        if (this.currentImage != null) {
            SDKUtils.setFont(this.fonts[0]);
            this.tagWrap = SDKUtils.wrapString(this.currentTag, null, this.screenWidth - 2, (short)124);
            this.titleWrap = SDKUtils.wrapString(this.currentName, null, this.screenWidth - 2, (short)124);
            n2 -= this.tagWrap[0] * SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
            this.layoutTagY = n2 -= 5;
            this.layoutTitleY = n2 -= this.titleWrap[0] * SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
            this.layoutImageY = n2 -= this.currentImage.getHeight();
            this.layoutArrowY = this.layoutImageY + (this.currentImage.getHeight() >> 1);
        } else {
            SDKUtils.setFont(this.fonts[0]);
            this.tagWrap = SDKUtils.wrapString(this.currentTag, null, this.screenWidth - (SPACE_H_ARROW_AREA >> 1), (short)124);
            this.layoutTagY = n2 -= this.tagWrap[0] * SDKUtils.getLineSize();
            this.layoutImageY = n2 -= SDKUtils.getLineSize();
            this.layoutArrowY = this.layoutImageY + (SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() >> 1);
        }
        SDKUtils.setFont(this.fonts[4]);
        this.headerSize = SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing() + 1 + 1;
        if (--n2 >= this.headerSize) {
            this.drawHeader = true;
            n2 -= this.headerSize;
        } else {
            this.drawHeader = false;
        }
        if (n2 <= 0) {
            n2 = 0;
        } else {
            n = n2 * 3 / 10;
            int n3 = n2 >> 2;
            int n4 = n2 >> 2;
            this.layoutImageY -= n2 - n;
            this.layoutArrowY -= n2 - n;
            this.layoutTagY -= n2 - n - n3;
            this.layoutTitleY -= n2 - n - n3;
            this.layoutBuyButtonY -= n2 - n - n3 - n4;
            this.layoutCatButtonY -= n2 - n - n3 - n4;
        }
    }

    protected void setLeftSoftkeyText(SDKString sDKString) {
        this.lskText = sDKString;
    }

    void setLSKText(SDKString sDKString) {
        this.lskText = sDKString;
    }

    protected void setRightSoftkeyText(SDKString sDKString) {
        this.rskText = sDKString;
    }

    void setRSKText(SDKString sDKString) {
        this.rskText = sDKString;
    }

    protected void applicationWillExit() {
    }

    protected void platformRequestImpl(String string) {
        if (SDKConfig.getDebugEnabled()) {
            if (this.sdkMidlet == null) {
                SDKUtils.debugLog("SDKMoreGames16platformRequestImpl::called without setting the sdkmidlet first", 4);
            }
            SDKUtils.debugLog("SDKMoreGames16platformRequestImpl::launching browser to URL " + string, 1);
        }
        SDKUtils.platformRequest(string);
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SDKMIDlet.exit();
    }

    protected String getAppPropertyWrap(String string) {
        if (SDKConfig.getMoreGamesCheatsEnabled()) {
            if (cheatsEnabled) {
                if (string.startsWith(STR_MG_CATURI) ? cheatsStatus[1] == 2 : string.startsWith(STR_MG_BUYURI) && cheatsStatus[2] == 2) {
                    return null;
                }
                if (string.equals(STR_MG_IMPL)) {
                    switch (cheatsStatus[0]) {
                        case 0: {
                            return STR_IMPL_OFF;
                        }
                        case 1: {
                            return STR_IMPL_STATIC;
                        }
                        case 2: {
                            return STR_IMPL_WAP;
                        }
                        case 3: {
                            return STR_IMPL_WAP_STATIC;
                        }
                    }
                }
                if (string.equals(STR_MG_PRODUCTS)) {
                    int n;
                    String string2 = SDKMIDlet.getAppProp(string);
                    if (string2 == null) {
                        return null;
                    }
                    if (cheatsStatus[3] == 0) {
                        return "";
                    }
                    string2 = string2.trim();
                    if (cheatsStatus[3] != -1) {
                        n = -1;
                        for (int i = 0; i < cheatsStatus[3] && (n = string2.indexOf(44, n + 1)) != -1; ++i) {
                        }
                        if (n != -1) {
                            string2 = string2.substring(0, n);
                        }
                    }
                    if (cheatsStatus[4] != -1) {
                        n = string2.indexOf(44, 0);
                        if (n == -1) {
                            return string2;
                        }
                        string2 = string2.substring(n + 1) + ',' + string2.substring(0, n);
                    }
                    return string2;
                }
            }
            return SDKMIDlet.getAppProp(string);
        }
        return SDKMIDlet.getAppProp(string);
    }

    private String appendReportingParameters(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.indexOf(63) == -1) {
            stringBuffer.append('?');
        } else {
            stringBuffer.append('&');
        }
        stringBuffer.append(REPORTING_CONTEXT_NAME);
        stringBuffer.append('=');
        stringBuffer.append(this.currentContext);
        stringBuffer.append('&');
        stringBuffer.append(REPORTING_LANGUAGE_NAME);
        stringBuffer.append('=');
        stringBuffer.append(new String(SDKImpl.getInstance().mLanguageIsocodes[SDKUtils.getCurrentLanguage()]));
        for (int i = 1; i < 10; ++i) {
            String string2 = SDKMIDlet.getAppProp(REPORTING_JAD_NAME_PREFIX + i);
            if (string2 == null) continue;
            stringBuffer.append('&');
            stringBuffer.append(string2);
            stringBuffer.append('=');
            stringBuffer.append(SDKMIDlet.getAppProp(REPORTING_JAD_VALUE_PREFIX + i));
        }
        return stringBuffer.toString();
    }

    private void confirmBrowserLaunch() {
        if (FlBrowser.GetInstance().LaunchURIWillExit(false)) {
            this.setLeftSoftkeyText(this.strings[7]);
            this.setRightSoftkeyText(this.strings[8]);
            this.state = 1;
        } else {
            String string = this.appendReportingParameters(this.currentURI);
            this.platformRequestImpl(string);
            SDKMIDlet.exit();
        }
    }

    private void cleanUp() {
        int n;
        this.staticWrap = null;
        this.confirmWrap = null;
        this.tagWrap = null;
        this.currentURI = null;
        this.currentContext = null;
        this.currentImage = null;
        this.currentOverlay = null;
        this.currentTag = null;
        this.currentName = null;
        this.currentCtg = null;
        this.currentPanelTitle = null;
        this.lskText = null;
        this.rskText = null;
        for (n = 0; n < this.currentPanelIcons.length; ++n) {
            this.currentPanelIcons[n] = null;
        }
        for (n = 0; n < this.currentPanelTargetNames.length; ++n) {
            this.currentPanelTargetNames[n] = null;
        }
    }

    protected void drawLeftArrow(SDKGraphics sDKGraphics, int n, int n2) {
        n += this.anim >> 1;
        sDKGraphics.setColor(-16757361);
        for (int i = 0; i <= SPACE_ARROW_SIZE; ++i) {
            sDKGraphics.drawLine(n + i, n2 - i, n + i, n2 + i);
        }
        sDKGraphics.setColor(-9462329);
        sDKGraphics.drawLine(n, n2, n + SPACE_ARROW_SIZE, n2 - SPACE_ARROW_SIZE);
        sDKGraphics.drawLine(n, n2, n + SPACE_ARROW_SIZE, n2 + SPACE_ARROW_SIZE);
        sDKGraphics.drawLine(n + SPACE_ARROW_SIZE, n2 - SPACE_ARROW_SIZE, n + SPACE_ARROW_SIZE, n2 + SPACE_ARROW_SIZE);
    }

    protected void drawRightArrow(SDKGraphics sDKGraphics, int n, int n2) {
        n -= this.anim >> 1;
        sDKGraphics.setColor(-16757361);
        for (int i = 0; i <= SPACE_ARROW_SIZE; ++i) {
            sDKGraphics.drawLine(n - i, n2 - i, n - i, n2 + i);
        }
        sDKGraphics.setColor(-9462329);
        sDKGraphics.drawLine(n, n2, n - SPACE_ARROW_SIZE, n2 - SPACE_ARROW_SIZE);
        sDKGraphics.drawLine(n, n2, n - SPACE_ARROW_SIZE, n2 + SPACE_ARROW_SIZE);
        sDKGraphics.drawLine(n - SPACE_ARROW_SIZE, n2 - SPACE_ARROW_SIZE, n - SPACE_ARROW_SIZE, n2 + SPACE_ARROW_SIZE);
    }

    protected void draw3DButton(SDKGraphics sDKGraphics, int n, int n2, SDKString sDKString, boolean bl) {
        boolean bl2 = false;
        if (bl) {
            SDKUtils.setFont(this.fonts[2]);
            if (this.fonts[2] == this.fonts[1]) {
                bl2 = true;
            }
        } else {
            SDKUtils.setFont(this.fonts[1]);
        }
        int n3 = SDKUtils.getLineSize() - SDKUtils.getLeadingSpacing();
        int n4 = n3 + 3 + 2;
        int n5 = this.screenWidth - n2 >> 1;
        sDKGraphics.setColor(-16777216);
        sDKGraphics.fillRect(n5, n, n2, n4);
        sDKGraphics.setColor(-16757361);
        sDKGraphics.fillRect(n5, n, n2 - 1, n4 - 1);
        sDKGraphics.setColor(-9462329);
        sDKGraphics.drawLine(n5 + 1, n + 1, n5 + n2 - 2, n + 1);
        sDKGraphics.drawLine(n5 + 1, n + 1, n5 + 1, n + n4 - 3);
        if (bl2) {
            sDKGraphics.setColor(-1);
            int n6 = n5 + (n3 >> 1) + 3;
            int n7 = n + (n4 >> 1);
            int n8 = (n3 >> 1) - 1;
            for (int i = 0; i <= n8; ++i) {
                sDKGraphics.drawLine(n6 - i, n7 - i, n6 - i, n7 + i);
            }
        }
        SDKUtils.drawString(sDKString, this.screenWidth >> 1, n + 2, 17);
    }

    private void drawUpArrow(SDKGraphics sDKGraphics, int n, int n2) {
        sDKGraphics.setColor(-16757361);
        sDKGraphics.fillTriangle(n, n2 -= this.anim >> 1, n - SPACE_ARROW_SIZE, n2 + SPACE_ARROW_SIZE, n + SPACE_ARROW_SIZE, n2 + SPACE_ARROW_SIZE);
    }

    private void drawDownArrow(SDKGraphics sDKGraphics, int n, int n2) {
        sDKGraphics.setColor(-16757361);
        sDKGraphics.fillTriangle(n, n2 -= 6 - (this.anim >> 1), n - SPACE_ARROW_SIZE, n2 - SPACE_ARROW_SIZE, n + SPACE_ARROW_SIZE, n2 - SPACE_ARROW_SIZE);
    }

    public final void pointerReleased(int n, int n2) {
    }

    public final void pointerPressed(int n, int n2) {
    }

    public final void pointerDragged(int n, int n2) {
    }
}

