/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import ca.jamdat.flight.Color888;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.FlApplication;
import ca.jamdat.flight.VibrationManager;
import com.ea.game.GameImpl;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKConfig;
import com.ea.sdk.SDKGame;
import com.ea.sdk.SDKImpl;
import com.ea.sdk.SDKMIDlet;

public class GameApp
extends FlApplication {
    public SDKCanvas mSDKCanvas;
    public SDKGame mSDKGame;
    public SDKImpl mSDKImpl;
    public long mLostTime;
    public boolean mIsPaused;
    public long mPauseTime;
    static final long mMinFrameTime = 1000 / SDKConfig.getMaxFPS();

    public GameApp() {
        this.MapKey(9, 0);
        this.MapKey(7, 0);
        this.MapKey(13, 0);
        this.MapKey(14, 0);
        this.MapKey(10, 0);
        this.MapKey(72, 7);
        this.SetMultiKeyPress();
        VibrationManager.Get().SetEnabled(true);
        this.SetFrameRate((short)SDKConfig.getMaxFPS());
        SDKMIDlet.getInstance().LoadProperties();
        this.mSDKImpl = new SDKImpl();
        this.mSDKCanvas = new SDKCanvas();
        this.mSDKGame = new GameImpl(this.mSDKCanvas);
        this.mSDKGame.init();
    }

    public void destruct() {
        this.mSDKGame.exiting();
        this.mSDKCanvas = null;
        this.mSDKGame = null;
        this.mSDKImpl = null;
    }

    public static void GetFlightColorFromSDKColor(int n, Color888 color888) {
        color888.SetBlue((n & 0xFF) >> 0);
        color888.SetGreen((n & 0xFF00) >> 8);
        color888.SetRed((n & 0xFF0000) >> 16);
    }

    public static short GetOpacityFromSDKColor(int n) {
        return (short)((n & 0xFF000000) >> 24);
    }

    public void OnTime(int n, int n2) {
        long l;
        SDKCanvas sDKCanvas = this.mSDKCanvas;
        this.mPauseTime = l = FlApplication.GetRealTime();
        this.mSDKGame.update(l - this.mLostTime);
        this.Invalidate();
        sDKCanvas.ResetFrameKeyStates();
    }

    public void OnDraw(DisplayContext displayContext) {
        this.mSDKCanvas.paint(displayContext);
    }

    public void OnFrameLimit(int n) {
        long l = mMinFrameTime - (long)n;
        try {
            Thread.sleep(l < 1L ? 1L : l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void Suspend() {
        if (!this.mIsPaused) {
            this.mSDKGame.pause();
            this.mIsPaused = true;
        }
    }

    public void Resume() {
        if (this.mIsPaused) {
            this.mLostTime += FlApplication.GetRealTime() - this.mPauseTime;
            SDKCanvas.disableInput(0);
            this.mIsPaused = false;
            this.mSDKGame.resume();
        }
    }

    public void OnKeyDown(int n) {
        this.mSDKCanvas.FlightKeyEvt(n, true);
    }

    public void OnKeyRepeat(int n) {
    }

    public void OnKeyUp(int n) {
        this.mSDKCanvas.FlightKeyEvt(n, false);
    }

    public void OnExit() {
        FlApplication.Exit();
    }

    public static GameApp Get() {
        return (GameApp)FlApplication.GetInstance();
    }

    public static GameApp[] InstArrayGameApp(int n) {
        GameApp[] gameAppArray = new GameApp[n];
        for (int i = 0; i < n; ++i) {
            gameAppArray[i] = new GameApp();
        }
        return gameAppArray;
    }

    public static GameApp[][] InstArrayGameApp(int n, int n2) {
        GameApp[][] gameAppArray = new GameApp[n][];
        for (int i = 0; i < n; ++i) {
            gameAppArray[i] = new GameApp[n2];
            for (int j = 0; j < n2; ++j) {
                gameAppArray[i][j] = new GameApp();
            }
        }
        return gameAppArray;
    }

    public static GameApp[][][] InstArrayGameApp(int n, int n2, int n3) {
        GameApp[][][] gameAppArray = new GameApp[n][][];
        for (int i = 0; i < n; ++i) {
            gameAppArray[i] = new GameApp[n2][];
            for (int j = 0; j < n2; ++j) {
                gameAppArray[i][j] = new GameApp[n3];
                for (int k = 0; k < n3; ++k) {
                    gameAppArray[i][j][k] = new GameApp();
                }
            }
        }
        return gameAppArray;
    }
}

