/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Color888;
import ca.jamdat.flight.DisplayContext;
import ca.jamdat.flight.DisplayManager;
import ca.jamdat.flight.FlBitmap;
import ca.jamdat.flight.FlDrawPropertyUtil;
import ca.jamdat.flight.FlPixelFormat;
import ca.jamdat.flight.VideoMode;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MIDPDisplayContextImp
extends DisplayContext {
    private Graphics mGraphics;

    public MIDPDisplayContextImp(VideoMode videoMode) {
        super(videoMode);
    }

    public MIDPDisplayContextImp(FlBitmap flBitmap) {
        super(new VideoMode(flBitmap.GetWidth(), flBitmap.GetHeight(), FlPixelFormat.GetColorBitsPerPixel(flBitmap.GetPixelFormat())));
        this.SetGraphics(flBitmap.getImage().getGraphics());
    }

    public void NativeDrawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mGraphics.drawArc(n, n2, --n3, --n4, n5, n6);
    }

    public void NativeDrawLine(int n, int n2, int n3, int n4) {
        this.mGraphics.drawLine(n, n2, n3, n4);
    }

    public void NativeDrawPixel(int n, int n2) {
        this.NativeFillRect(n, n2, 1, 1);
    }

    public void NativeDrawRect(int n, int n2, int n3, int n4) {
        this.mGraphics.drawRect(n, n2, --n3, --n4);
    }

    public void NativeDrawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.mGraphics.drawRGB(nArray, n, n6, n2, n3, n4, n5, bl);
    }

    public void NativeDrawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mGraphics.drawRoundRect(n, n2, --n3, --n4, n5, n6);
    }

    public void NativeFillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mGraphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void NativeFillRect(int n, int n2, int n3, int n4) {
        this.mGraphics.fillRect(n, n2, n3, n4);
    }

    public void NativeFillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mGraphics.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void NativeFillTriangle(int n, int n2, int n3, int n4, int n5, int n6) {
        this.mGraphics.fillTriangle(n, n2, n3, n4, n5, n6);
    }

    public int NativeGetClipHeight() {
        return this.mGraphics.getClipHeight();
    }

    public int NativeGetClipWidth() {
        return this.mGraphics.getClipWidth();
    }

    public int NativeGetClipX() {
        return this.mGraphics.getClipX();
    }

    public int NativeGetClipY() {
        return this.mGraphics.getClipY();
    }

    public void NativeSetClip(int n, int n2, int n3, int n4) {
        this.mGraphics.setClip(n, n2, n3, n4);
    }

    public int NativeGetAlpha() {
        return 255;
    }

    public int NativeGetARGB() {
        return this.mGraphics.getColor();
    }

    public int NativeGetRGB() {
        return this.mGraphics.getColor();
    }

    public void NativeSetAlpha(int n) {
    }

    public void NativeSetARGB(int n) {
        this.NativeSetRGB(n & 0xFFFFFF);
    }

    public void NativeSetRGB(int n) {
        this.mGraphics.setColor(n);
    }

    public void NativeSetARGB(int n, int n2, int n3, int n4) {
        this.NativeSetAlpha(n);
        this.NativeSetRGB(n2, n3, n4);
    }

    public void NativeSetRGB(int n, int n2, int n3) {
        this.mGraphics.setColor(n, n2, n3);
    }

    public void NativeSetFont(Object object) {
        this.mGraphics.setFont((Font)object);
    }

    public void NativeDrawString(String string, int n, int n2, int n3) {
        this.mGraphics.drawString(string, n, n2, n3);
    }

    public void NativeDrawString(String string, int n, int n2, byte by, byte by2) {
        this.NativeDrawString(string, n, n2, this.TranslateAnchors(by, by2));
    }

    public int NativeGetTranslatedX() {
        return this.mGraphics.getTranslateX();
    }

    public int NativeGetTranslatedY() {
        return this.mGraphics.getTranslateY();
    }

    public void NativeTranslate(int n, int n2) {
        this.mGraphics.translate(n, n2);
    }

    public void NativeDrawRegion(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.mGraphics.drawRegion(image, n, n2, n3, n4, FlDrawPropertyUtil.TransformToMIDPTransform(n5), n6, n7, n8);
    }

    public void SetGraphics(Graphics graphics) {
        this.mGraphics = graphics;
    }

    private void SetClip(int n, int n2, int n3, int n4) {
    }

    public void Clear(Color888 color888) {
        int n = this.NativeGetARGB();
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        this.NativeSetARGB(255, color888.GetRed(), color888.GetGreen(), color888.GetBlue());
        this.NativeFillRect(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        this.NativeSetARGB(n);
    }

    public void ClearFullscreen(Color888 color888) {
        short s = DisplayManager.GetVideoModeRect().GetLeft();
        short s2 = DisplayManager.GetVideoModeRect().GetTop();
        short s3 = DisplayManager.GetVideoModeRect().GetWidth();
        short s4 = DisplayManager.GetVideoModeRect().GetHeight();
        int n = this.NativeGetARGB();
        this.SetClip(s, s2, s3, s4);
        this.NativeSetARGB(255, color888.GetRed(), color888.GetGreen(), color888.GetBlue());
        this.NativeFillRect(s, s2, s3, s4);
        this.NativeSetARGB(n);
    }

    public void ResetClip() {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
    }

    public void DrawAbsoluteBitmapBypassClipping(FlBitmap flBitmap, int n, int n2) {
        Image image = flBitmap.getImage();
        this.mGraphics.drawImage(image, n, n2, 20);
    }

    public void DrawAbsoluteBitmapSection(FlBitmap flBitmap, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.SetClip(n, n2, n5, n6);
        this.NativeSetAlpha(FlDrawPropertyUtil.GetAlpha(n7));
        Image image = flBitmap.getImage();
        this.NativeDrawRegion(image, n3, n4, n5, n6, FlDrawPropertyUtil.GetTransform(n7), n, n2, 20);
    }

    public void DrawAbsoluteBitmapSection(FlBitmap flBitmap, int n, int n2, int n3, int n4, int n5, int n6, byte by, short s) {
        int n7 = FlDrawPropertyUtil.ApplyTransform(255, FlDrawPropertyUtil.BmpTransformToTransform(by));
        this.DrawAbsoluteBitmapSection(flBitmap, n, n2, n3, n4, n5, n6, n7);
    }

    public void DrawAbsoluteBitmapSection(FlBitmap flBitmap, int n, int n2, int n3, int n4, int n5, int n6, byte by) {
        int n7 = FlDrawPropertyUtil.ApplyTransform(255, FlDrawPropertyUtil.BmpTransformToTransform(by));
        this.DrawAbsoluteBitmapSection(flBitmap, n, n2, n3, n4, n5, n6, n7);
    }

    public void DrawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        this.NativeDrawRGB(nArray, n, n2 += this.mCumulativeOffsetX, n3 += this.mCumulativeOffsetY, n4, n5, n6, bl);
    }

    public void DrawArc(short s, short s2, short s3, short s4, short s5, short s6, boolean bl, Color888 color888, int n) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        s = (short)(s + this.mCumulativeOffsetX);
        s2 = (short)(s2 + this.mCumulativeOffsetY);
        this.NativeSetARGB(FlDrawPropertyUtil.GetAlpha(n), color888.GetRed(), color888.GetGreen(), color888.GetBlue());
        if (bl) {
            this.NativeFillArc(s, s2, s3, s4, s5, s6);
        } else {
            this.NativeDrawArc(s, s2, s3, s4, s5, s6);
        }
    }

    public void DrawLine(short s, short s2, short s3, short s4, Color888 color888, int n) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        s = (short)(s + this.mCumulativeOffsetX);
        s2 = (short)(s2 + this.mCumulativeOffsetY);
        s3 = (short)(s3 + this.mCumulativeOffsetX);
        s4 = (short)(s4 + this.mCumulativeOffsetY);
        this.NativeSetARGB(FlDrawPropertyUtil.GetAlpha(n), color888.GetRed(), color888.GetGreen(), color888.GetBlue());
        this.NativeDrawLine(s, s2, s3, s4);
    }

    public void DrawPixel(short s, short s2, Color888 color888, int n) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        s = (short)(s + this.mCumulativeOffsetX);
        s2 = (short)(s2 + this.mCumulativeOffsetY);
        this.NativeSetARGB(FlDrawPropertyUtil.GetAlpha(n), color888.GetRed(), color888.GetGreen(), color888.GetBlue());
        this.NativeDrawPixel(s, s2);
    }

    public void DrawRectangle(short s, short s2, short s3, short s4, boolean bl, int n, int n2, int n3, int n4) {
        s = (short)(s + this.mCumulativeOffsetX);
        s2 = (short)(s2 + this.mCumulativeOffsetY);
        this.NativeSetARGB(FlDrawPropertyUtil.GetAlpha(n4), n, n2, n3);
        if (!bl) {
            this.FillRectangle(s, s2, s3, (short)1);
            this.FillRectangle(s, s2, (short)1, s4);
            this.FillRectangle(s, (short)(s2 + s4 - 1), s3, (short)1);
            this.FillRectangle((short)(s + s3 - 1), s2, (short)1, s4);
        } else {
            this.FillRectangle(s, s2, s3, s4);
        }
    }

    public void DrawRoundRectangle(short s, short s2, short s3, short s4, short s5, short s6, boolean bl, Color888 color888, int n) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        s = (short)(s + this.mCumulativeOffsetX);
        s2 = (short)(s2 + this.mCumulativeOffsetY);
        this.NativeSetARGB(FlDrawPropertyUtil.GetAlpha(n), color888.GetRed(), color888.GetGreen(), color888.GetBlue());
        if (bl) {
            this.NativeFillRoundRect(s, s2, s3, s4, s5, s6);
        } else {
            this.NativeDrawRoundRect(s, s2, s3, s4, s5, s6);
        }
    }

    public void DrawTriangle(short s, short s2, short s3, short s4, short s5, short s6, boolean bl, Color888 color888, int n) {
        this.SetClip(this.mClipRect_left, this.mClipRect_top, this.mClipRect_width, this.mClipRect_height);
        super.GenericDrawTriangle(s, s2, s3, s4, s5, s6, bl, color888, n);
    }

    private void FillRectangle(short s, short s2, short s3, short s4) {
        this.NativeFillRect(s, s2, s3, s4);
    }

    public byte GetDisplayAPI() {
        return 8;
    }

    private int TranslateAnchors(int n, int n2) {
        int n3 = 0;
        switch (n) {
            case 0: {
                n3 |= 4;
                break;
            }
            case 1: {
                n3 |= 1;
                break;
            }
            case 2: {
                n3 |= 8;
            }
        }
        switch (n2) {
            case 0: {
                n3 |= 0x10;
                break;
            }
            case 1: {
                n3 |= 0x20;
                break;
            }
            case 2: {
                n3 |= 0x40;
                break;
            }
            case 3: {
                n3 |= 2;
            }
        }
        return n3;
    }
}

