/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FrameworkGlobals;
import ca.jamdat.flight.MMAPISoundManagerImp;
import ca.jamdat.flight.SoundPlayer;
import ca.jamdat.flight.SpecConstants;

public class SoundManager {
    public MMAPISoundManagerImp mImplementor;
    public SoundPlayer[] mChannels = null;
    public short mMasterVolume = (short)255;
    public short mScaledMasterVolume;
    public boolean mIsMuted;
    public boolean mIsPauseSoundsOnInterrupt;

    public SoundManager() {
        this.mImplementor = new MMAPISoundManagerImp();
        this.mScaledMasterVolume = this.CalculateScaledMasterVolume();
        FrameworkGlobals.GetInstance().soundManager = this;
        this.mChannels = SoundPlayer.InstArraySoundPlayer(1);
    }

    public static SoundManager Get() {
        if (FrameworkGlobals.GetInstance().soundManager == null) {
            FrameworkGlobals.GetInstance().soundManager = new SoundManager();
        }
        return FrameworkGlobals.GetInstance().soundManager;
    }

    public void destruct() {
        this.mChannels = null;
    }

    public SoundPlayer GetChannelSoundPlayer(int n) {
        return this.mChannels[n];
    }

    public void SetMuted(boolean bl) {
        this.mImplementor.SetMuted(bl);
    }

    public boolean IsMuted() {
        return this.mImplementor.IsMuted();
    }

    public void SetPauseSoundsOnInterrupt() {
        this.mIsPauseSoundsOnInterrupt = true;
    }

    public boolean IsPauseSoundsOnInterrupt() {
        return this.mIsPauseSoundsOnInterrupt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void PauseAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            for (int i = 0; i < 1; ++i) {
                this.mChannels[i].Pause();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ResumeAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            for (int i = 0; i < 1; ++i) {
                if (!this.mChannels[i].IsPaused()) continue;
                this.mChannels[i].Play();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void StopAllSoundPlayers() {
        SoundManager soundManager = SoundManager.Get();
        synchronized (soundManager) {
            for (int i = 0; i < 1; ++i) {
                this.mChannels[i].Stop();
            }
        }
    }

    public void SetMasterVolume(short s) {
        if (s > 255) {
            s = (short)255;
        }
        if (s < 0) {
            s = 0;
        }
        this.mMasterVolume = s;
        this.mScaledMasterVolume = this.CalculateScaledMasterVolume();
        for (int i = 0; i < 1; ++i) {
            this.mChannels[i].SetNativeVolume();
        }
        FrameworkGlobals.GetInstance().application.OnMasterVolumeChange(s);
    }

    public short GetMasterVolume() {
        return this.mMasterVolume;
    }

    public short GetScaledMasterVolume() {
        return this.mScaledMasterVolume;
    }

    public static void IncMasterVolume() {
        SoundManager soundManager = FrameworkGlobals.GetInstance().soundManager;
        soundManager.SetMasterVolume((short)(soundManager.mMasterVolume + 51));
    }

    public static void DecMasterVolume() {
        SoundManager soundManager = FrameworkGlobals.GetInstance().soundManager;
        soundManager.SetMasterVolume((short)(soundManager.mMasterVolume - 51));
    }

    public static int CalculateNativePlayerVolume(short s, int n) {
        return n * s * FrameworkGlobals.GetInstance().soundManager.GetScaledMasterVolume() >> 16;
    }

    public short CalculateScaledMasterVolume() {
        if (SpecConstants.GetMasterVolumeScaleFactor() > 0) {
            return (short)(this.mMasterVolume << (short)SpecConstants.GetMasterVolumeScaleFactor());
        }
        if (SpecConstants.GetMasterVolumeScaleFactor() < 0) {
            return (short)(this.mMasterVolume >> (short)(-SpecConstants.GetMasterVolumeScaleFactor()));
        }
        return this.mMasterVolume;
    }

    public static int CalculateNativePlayerVolume(short s) {
        return SoundManager.CalculateNativePlayerVolume(s, 100);
    }

    public static SoundManager[] InstArraySoundManager(int n) {
        SoundManager[] soundManagerArray = new SoundManager[n];
        for (int i = 0; i < n; ++i) {
            soundManagerArray[i] = new SoundManager();
        }
        return soundManagerArray;
    }

    public static SoundManager[][] InstArraySoundManager(int n, int n2) {
        SoundManager[][] soundManagerArray = new SoundManager[n][];
        for (int i = 0; i < n; ++i) {
            soundManagerArray[i] = new SoundManager[n2];
            for (int j = 0; j < n2; ++j) {
                soundManagerArray[i][j] = new SoundManager();
            }
        }
        return soundManagerArray;
    }

    public static SoundManager[][][] InstArraySoundManager(int n, int n2, int n3) {
        SoundManager[][][] soundManagerArray = new SoundManager[n][][];
        for (int i = 0; i < n; ++i) {
            soundManagerArray[i] = new SoundManager[n2][];
            for (int j = 0; j < n2; ++j) {
                soundManagerArray[i][j] = new SoundManager[n3];
                for (int k = 0; k < n3; ++k) {
                    soundManagerArray[i][j][k] = new SoundManager();
                }
            }
        }
        return soundManagerArray;
    }
}

