/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.Array_byte;
import ca.jamdat.flight.FlMath;
import ca.jamdat.flight.FlString;
import ca.jamdat.flight.Stream;
import ca.jamdat.flight.StringUtils;
import java.io.IOException;
import java.io.InputStream;

public class LibraryStream
extends Stream {
    public static final byte kSizeOfReadByte = 1;
    public static final byte kSizeOfReadInt = 4;
    public static final byte kSizeOfReadChar = 2;
    public static final byte kSizeOfReadShort = 2;
    public static final byte kEofValue = -1;
    public InputStream mInputStream;
    public FlString mFileName;
    public int mError;
    public int mSegmentSize;
    public int mLibrarySize;
    public int mCurrentSegment;
    public int mPositionInSegment;
    public int mSizeOfCurrentSegment;
    public int mCurrentDecompressionSegIndex;
    public byte[] mBuffer = new byte[4];

    public LibraryStream(FlString flString) {
        this.mFileName = new FlString();
        this.Create(flString);
    }

    public void destruct() {
        this.Close();
    }

    public static boolean FileExists(FlString flString) {
        boolean bl = false;
        InputStream inputStream = System.out.getClass().getResourceAsStream(StringUtils.CreateJavaString(flString));
        if (inputStream == null) {
            bl = false;
        } else {
            bl = true;
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public static InputStream GetResourceAsStream(String string) {
        InputStream inputStream = System.out.getClass().getResourceAsStream(string);
        return inputStream;
    }

    public static byte[] GetResourceAsByteArray(String string) {
        int n;
        InputStream inputStream = LibraryStream.GetResourceAsStream("/" + string);
        Array_byte array_byte = new Array_byte();
        try {
            n = inputStream.read();
        }
        catch (IOException iOException) {
            n = -1;
        }
        while (n != -1) {
            array_byte.Insert((byte)n);
            try {
                n = inputStream.read();
            }
            catch (IOException iOException) {
                n = -1;
            }
        }
        byte[] byArray = new byte[array_byte.End()];
        array_byte.CopyInto(byArray, array_byte.End());
        return byArray;
    }

    public void Skip(int n) {
        this.SetPosition(this.GetPosition() + n);
    }

    public int Read(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = n2;
        int n5 = n + n2;
        do {
            int n6;
            if ((n6 = this.mSizeOfCurrentSegment - this.mPositionInSegment) <= 0) {
                this.CloseSegment();
                ++this.mCurrentSegment;
                this.OpenSegment(this.mCurrentSegment);
                n6 = this.mSizeOfCurrentSegment;
            }
            n3 = FlMath.Minimum(n4, n6);
            try {
                int n7 = 0;
                while ((n7 += this.mInputStream.read(byArray, n5 - n4 + n7, n3 - n7)) != n3) {
                    if (n7 >= 0) continue;
                    throw new IOException();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mPositionInSegment += n3;
        } while ((n4 -= n3) > 0);
        return n2;
    }

    public int Read(byte[] byArray, int n) {
        return this.Read(byArray, this.GetPosition(), n);
    }

    public int Write(byte[] byArray, int n) {
        return 0;
    }

    public int ReadLong() {
        byte[] byArray = this.mBuffer;
        this.Read(byArray, 0, 4);
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    public static int ReadLong(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    public short ReadShort() {
        byte[] byArray = this.mBuffer;
        this.Read(byArray, 0, 2);
        return (short)(byArray[0] << 8 | byArray[1] & 0xFF);
    }

    public short ReadChar() {
        return this.ReadShort();
    }

    public byte ReadByte() {
        if (this.mPositionInSegment >= this.mSizeOfCurrentSegment) {
            this.CloseSegment();
            ++this.mCurrentSegment;
            this.OpenSegment(this.mCurrentSegment);
        }
        byte[] byArray = this.mBuffer;
        try {
            int n;
            while ((n = this.mInputStream.read(byArray, 0, 1)) < 1) {
                if (n >= 0) continue;
                throw new IOException();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ++this.mPositionInSegment;
        return byArray[0];
    }

    public int GetSize() {
        return this.mLibrarySize;
    }

    public void SetPosition(int n) {
        int n2;
        int n3 = this.GetSize();
        int n4 = 0;
        int n5 = this.mSegmentSize;
        if (n >= n3) {
            n4 = (n3 - 1) / n5;
            n = n3 - n4 * n5;
        } else {
            n4 = n / n5;
            n %= n5;
        }
        if (n4 == this.mCurrentSegment && n >= this.mPositionInSegment) {
            n -= this.mPositionInSegment;
        } else {
            this.mCurrentSegment = n4;
            this.CloseSegment();
            this.OpenSegment(this.mCurrentSegment);
        }
        int n6 = -1;
        try {
            for (n2 = 0; n2 < n && n6 != 0; n2 += n6) {
                n6 = (int)this.mInputStream.skip(n - n2);
            }
        }
        catch (Exception exception) {
            this.mError = 1;
            exception.printStackTrace();
        }
        this.mPositionInSegment += n2;
    }

    public int GetPosition() {
        return this.mPositionInSegment + this.mCurrentSegment * this.mSegmentSize;
    }

    public boolean IsEndOfFile() {
        return this.GetPosition() == this.GetSize();
    }

    public boolean IsOpen() {
        return this.mInputStream != null;
    }

    public boolean IsValid() {
        return this.mInputStream != null;
    }

    public int GetLastError() {
        return this.mError;
    }

    public void Close() {
        this.CloseSegment();
    }

    public void Create(FlString flString) {
        this.mFileName.Assign(FlString.FromChar((short)47).Add(flString).Add(FlString.FromChar((short)46)));
        this.OpenSegment(0);
        if (this.IsOpen()) {
            int n = 0;
            int n2 = 0;
            this.mSizeOfCurrentSegment = this.mLibrarySize = 4096;
            n = this.ReadLong();
            n2 = this.ReadLong();
            this.mPositionInSegment += 8;
            if (n == 0 || n2 < n) {
                n = n2;
            }
            this.mSizeOfCurrentSegment = n;
            this.mLibrarySize = n2;
            this.mSegmentSize = n;
            this.SetPosition(0);
        }
    }

    public void CloseSegment() {
        try {
            this.mInputStream.close();
        }
        catch (Exception exception) {
            this.mError = 1;
            exception.printStackTrace();
        }
        this.mInputStream = null;
    }

    public void OpenSegment(int n) {
        int n2 = this.mSegmentSize;
        if (n2 > 0) {
            int n3 = this.mLibrarySize / n2;
            this.mSizeOfCurrentSegment = n < n3 ? n2 : this.mLibrarySize - n3 * n2;
        }
        this.mPositionInSegment = 0;
        InputStream inputStream = this.GetInputStreamOnSegment(n);
        if (inputStream == null) {
            this.mInputStream = null;
            this.mError = 1;
        } else {
            this.mInputStream = inputStream;
            this.mError = 0;
        }
    }

    public InputStream GetInputStreamOnSegment(int n) {
        String string = StringUtils.CreateJavaString(this.mFileName.Add(new FlString(n)));
        InputStream inputStream = LibraryStream.GetResourceAsStream(string);
        return inputStream;
    }
}

