/*
 * Decompiled with CFR 0.152.
 */
package ca.jamdat.flight;

import ca.jamdat.flight.FlString;
import ca.jamdat.flight.JavaBasicFileStream;
import ca.jamdat.flight.Memory;
import ca.jamdat.flight.Stream;
import ca.jamdat.flight.StringUtils;

public class FileStream
extends Stream {
    public FlString mFileName;
    public byte mFileMode;
    public int mNativeFileSize;
    public boolean mIsCRCValid;
    public int mBufferSize;
    public byte[] mBuffer;
    public int mDataEndPos;
    public int mCurrentPos;
    public byte[] mTmpArray = new byte[4];

    public static boolean FileExists(FlString flString) {
        return JavaBasicFileStream.FileExists(flString);
    }

    public static boolean IsSpaceAvailable(int n) {
        return JavaBasicFileStream.GetAvailableSpace(n);
    }

    public static boolean IsSpaceAvailable(int n, int n2) {
        return JavaBasicFileStream.GetAvailableSpace(n, n2);
    }

    public static boolean FileDelete(FlString flString) {
        return JavaBasicFileStream.FileDelete(flString);
    }

    public FileStream(FlString flString, byte by, int n, boolean bl) {
        this.mFileMode = by;
        this.mNativeFileSize = -1;
        this.mFileName = new FlString(flString);
        switch (this.mFileMode) {
            case 0: {
                this.InitReadMode(n);
                break;
            }
            case 1: 
            case 2: {
                int n2 = this.GetHeaderSize();
                this.mBufferSize = n + n2;
                this.mBuffer = new byte[this.mBufferSize];
                this.mNativeFileSize = n2;
                this.mCurrentPos = n2;
                this.mDataEndPos = n2;
                this.mIsCRCValid = true;
                break;
            }
        }
    }

    public void destruct() {
    }

    public int Read(byte[] byArray, int n) {
        System.arraycopy(this.mBuffer, this.mCurrentPos, byArray, 0, n);
        this.mCurrentPos += n;
        return n;
    }

    public int Write(byte[] byArray, int n) {
        System.arraycopy(byArray, 0, this.mBuffer, this.mCurrentPos, n);
        this.mCurrentPos += n;
        if (this.mCurrentPos > this.mDataEndPos) {
            this.mDataEndPos = this.mCurrentPos;
            this.mNativeFileSize = this.mCurrentPos;
        }
        return n;
    }

    public void Skip(int n) {
        this.SetPosition(this.GetPosition() + n);
    }

    public int GetSize() {
        return this.mNativeFileSize - this.GetHeaderSize();
    }

    public int GetPosition() {
        return this.mCurrentPos - this.GetHeaderSize();
    }

    public void SetPosition(int n) {
        this.mCurrentPos = this.GetHeaderSize() + n;
    }

    public boolean IsEndOfFile() {
        return this.mCurrentPos >= this.mDataEndPos;
    }

    public boolean IsValid() {
        return this.mIsCRCValid;
    }

    public boolean IsOpen() {
        return this.mBuffer != null;
    }

    public byte GetFileErrorState() {
        byte by = 0;
        return by;
    }

    public byte GetLicenseState() {
        byte by = 0;
        return by;
    }

    public void ManageLicense(byte by) {
    }

    public void Close() {
        if (this.mFileMode != 0) {
            this.AssignCRC();
            JavaBasicFileStream.WriteFile(this.mFileName, this.mBuffer, this.mDataEndPos, this.mFileMode);
        }
        this.mBuffer = null;
        this.mFileName = null;
    }

    public byte ReadByte() {
        return this.mBuffer[this.mCurrentPos++];
    }

    public short ReadShort() {
        short s = (short)(((this.mBuffer[this.mCurrentPos] & 0xFF) << 8) + (this.mBuffer[this.mCurrentPos + 1] & 0xFF));
        this.mCurrentPos += 2;
        return s;
    }

    public int ReadLong() {
        byte[] byArray = this.mBuffer;
        int n = this.mCurrentPos;
        int n2 = (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
        this.mCurrentPos += 4;
        return n2;
    }

    public FlString ReadString() {
        int n = this.ReadShort();
        short[] sArray = new short[n + 1];
        if (n != 0) {
            for (int i = 0; i < n; ++i) {
                sArray[i] = this.ReadShort();
            }
        }
        sArray[n] = 0;
        FlString flString = new FlString(sArray);
        sArray = null;
        return flString;
    }

    public void WriteByte(byte by) {
        this.mTmpArray[0] = by;
        this.Write(this.mTmpArray, 1);
    }

    public void WriteShort(short s) {
        this.mTmpArray[0] = (byte)(0xFF & s >> 8);
        this.mTmpArray[1] = (byte)(0xFF & s);
        this.Write(this.mTmpArray, 2);
    }

    public void WriteLong(int n) {
        byte[] byArray = this.mTmpArray;
        byArray[0] = (byte)(0xFF & n >> 24);
        byArray[1] = (byte)(0xFF & n >> 16);
        byArray[2] = (byte)(0xFF & n >> 8);
        byArray[3] = (byte)(0xFF & n);
        this.Write(byArray, 4);
    }

    public void WriteString(FlString flString) {
        flString.Write(this);
    }

    public void WriteText(FlString flString) {
        flString.Write(this, false);
    }

    public boolean CanRead() {
        return this.mFileMode == 0;
    }

    public boolean CanWrite() {
        return this.mFileMode != 0;
    }

    public FlString ReadLine() {
        int n = -1;
        int n2 = -1;
        byte[] byArray = new byte[2048];
        int n3 = 0;
        n = this.ReadByte();
        if (n != 10) {
            while (!this.IsEndOfFile() && n3 < 2046) {
                n2 = this.ReadByte();
                if (n2 == 10) {
                    if (n != 13) {
                        byArray[n3++] = n;
                    }
                    byArray[n3++] = 0;
                    return StringUtils.CreateString(StringUtils.ToRawString(StringUtils.CreateString(new String(byArray))));
                }
                byArray[n3++] = n;
                n = n2;
            }
            byArray[n3++] = n;
        }
        byArray[n3++] = 0;
        return StringUtils.CreateString(StringUtils.ToRawString(StringUtils.CreateString(new String(byArray))));
    }

    public FlString GetFileName() {
        return this.mFileName;
    }

    public void InitReadMode(int n) {
        this.GetNativeFileSize();
        this.mBufferSize = this.mNativeFileSize;
        if (this.mBufferSize > 0) {
            this.mBuffer = new byte[this.mBufferSize];
        }
        this.mIsCRCValid = this.mBuffer == null || this.RefreshBuffer(0) == -1 ? false : this.VerifyCRC();
    }

    public boolean VerifyCRC() {
        if (this.mNativeFileSize > this.GetHeaderSize()) {
            int n = (int)Memory.CalculateCRC(this.mBuffer, this.GetHeaderSize(), this.mDataEndPos - this.GetHeaderSize());
            this.mCurrentPos = 0;
            int n2 = this.ReadLong();
            this.mCurrentPos = this.GetHeaderSize();
            return n == n2;
        }
        return false;
    }

    public void AssignCRC() {
        int n = (int)Memory.CalculateCRC(this.mBuffer, this.GetHeaderSize(), this.mDataEndPos - this.GetHeaderSize());
        this.mCurrentPos = 0;
        this.WriteLong(n);
    }

    public int RefreshBuffer(int n) {
        int n2 = 0;
        this.mBuffer = JavaBasicFileStream.ReadFile(this.mFileName);
        if (this.mBuffer == null) {
            return -1;
        }
        this.mNativeFileSize = this.mBufferSize = this.mBuffer.length;
        this.mDataEndPos = n2 = this.mBufferSize;
        this.mCurrentPos = this.GetHeaderSize();
        return n2;
    }

    public int GetNativeFileSize() {
        if (this.mNativeFileSize < 0) {
            int n = 0;
            n = JavaBasicFileStream.GetFileSize(this.mFileName);
            if (n > 0) {
                this.mNativeFileSize = n;
            }
        }
        return this.mNativeFileSize;
    }

    public int GetCRCSize() {
        return 4;
    }

    public int GetHeaderSize() {
        int n = this.GetCRCSize();
        return n;
    }

    public FileStream(FlString flString) {
        this(flString, 0);
    }

    public FileStream(FlString flString, byte by) {
        this(flString, by, 1024);
    }

    public FileStream(FlString flString, byte by, int n) {
        this(flString, by, n, true);
    }

    public void InitReadMode() {
        this.InitReadMode(1024);
    }
}

