/*
 * Decompiled with CFR 0.152.
 */
package com.ea.sdk;

import ca.jamdat.flight.LibraryStream;
import com.ea.sdk.SDKConfig;
import com.ea.sdk.SDKDebug;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKMIDlet;
import com.ea.sdk.SDKUtils;
import java.io.IOException;
import java.io.InputStream;

public class SDKInputStream
extends InputStream
implements SDKDebug {
    public static final int IMAGE_NO_PALETTE = -1;
    private static String CLASS_NAME;
    private static boolean mIndexLoaded;
    private static int mDataFileCount;
    private static int mExtraLocalizationsCount;
    private static int[] mLastResourceIDs;
    private static int[][] mDataFileSizes;
    private static int mNbRes;
    private static boolean[][] mLocDesc;
    private static int[] mDefaultOff;
    private static int[][] mSuplOff;
    private static int mLocalization;
    private static InputStream mLastClosedIS;
    private static int mLastClosedDfi;
    private static int mLastClosedRealPos;
    private static int mLastClosedLocale;
    private static final byte[] PLTE;
    private InputStream is;
    private int is_pos = 0;
    private int res_offset;
    private int res_length;
    private int res_dfi;
    private int res_locale;
    private String res_filename;

    private static int readNum(InputStream inputStream, int n) throws IOException {
        int n2 = 0;
        int n3 = n << 3;
        for (int i = 0; i < n3; i += 8) {
            n2 |= (inputStream.read() & 0xFF) << i;
        }
        return n2;
    }

    private static long skipNative(InputStream inputStream, long l) throws IOException {
        return SDKUtils.skipNative(inputStream, l);
    }

    private static int readBytesNative(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException {
        return SDKUtils.readBytesNative(inputStream, byArray, n, n2);
    }

    public static boolean setLocale(int n) {
        if (!mIndexLoaded) {
            SDKInputStream.initLoader();
        }
        if (n < 0 || n > mExtraLocalizationsCount) {
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog(CLASS_NAME + "setLocale::locale_id out of bounds: " + n, 3);
            }
            return false;
        }
        mLocalization = n;
        if (SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog(CLASS_NAME + "setLocale::setting   locale_id: " + n, 1);
        }
        return true;
    }

    private static void initLoader() {
        block18: {
            InputStream inputStream;
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog(CLASS_NAME + "initLoader::reading the index file", 1);
                if (mIndexLoaded) {
                    SDKUtils.debugLog(CLASS_NAME + "initLoader::initLoader called twice!", 3);
                }
            }
            if ((inputStream = SDKMIDlet.getInstance().getClass().getResourceAsStream("/index")) == null && SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog(CLASS_NAME + "initLoader:: cannot read index file (getResourceAsStream on /index returned null)", 4);
            }
            try {
                int n;
                int n2;
                int n3;
                if (SDKConfig.getDebugEnabled()) {
                    n3 = SDKInputStream.readNum(inputStream, 1);
                    if (n3 != 0) {
                        SDKUtils.debugLog(CLASS_NAME + "initLoader:: index version byte  does not match the expected value; required version is: " + 0, 4);
                    }
                } else {
                    SDKInputStream.readNum(inputStream, 1);
                }
                mDataFileCount = SDKInputStream.readNum(inputStream, 2);
                n3 = SDKInputStream.readNum(inputStream, 1);
                mExtraLocalizationsCount = SDKInputStream.readNum(inputStream, 1);
                int n4 = mDataFileCount;
                int n5 = mExtraLocalizationsCount;
                if (SDKConfig.getDebugEnabled()) {
                    SDKUtils.debugLog(CLASS_NAME + "initLoader::dft::dataFileCount: " + n4, 1);
                    SDKUtils.debugLog(CLASS_NAME + "initLoader::dft::bytesPerOffset: " + n3, 1);
                    SDKUtils.debugLog(CLASS_NAME + "initLoader::dft::extraLocalizationsCount: " + n5, 1);
                }
                mLastResourceIDs = new int[n4];
                mDataFileSizes = new int[n4][n5 + 1];
                for (n2 = 0; n2 < n4; ++n2) {
                    SDKInputStream.mLastResourceIDs[n2] = SDKInputStream.readNum(inputStream, 2);
                    if (SDKConfig.getDebugEnabled()) {
                        SDKUtils.debugLog(CLASS_NAME + "initLoader::dft::mLastResourceIDs[" + n2 + "]:  " + mLastResourceIDs[n2], 1);
                    }
                    for (n = 0; n < n5 + 1; ++n) {
                        SDKInputStream.mDataFileSizes[n2][n] = SDKInputStream.readNum(inputStream, n3);
                        if (!SDKConfig.getDebugEnabled()) continue;
                        SDKUtils.debugLog(CLASS_NAME + "initLoader::dft::mDataFileSizes[" + n2 + "][" + n + "]:   " + mDataFileSizes[n2][n], 1);
                    }
                    SDKInputStream.readNum(inputStream, n3);
                }
                n2 = mNbRes = SDKInputStream.readNum(inputStream, 2);
                if (SDKConfig.getDebugEnabled()) {
                    SDKUtils.debugLog(CLASS_NAME + "initLoader::ridot::mNbRes" + n2, 1);
                }
                n = n5 / 8;
                if (n5 % 8 > 0) {
                    ++n;
                }
                mLocDesc = new boolean[n2][n5];
                mDefaultOff = new int[n2];
                mSuplOff = new int[n2][];
                for (int i = 0; i < n2; ++i) {
                    int n6;
                    int n7 = SDKInputStream.readNum(inputStream, n);
                    int n8 = 0;
                    for (n6 = 0; n6 < n5; ++n6) {
                        boolean bl = SDKInputStream.mLocDesc[i][n6] = (n7 & 1 << n6) != 0;
                        if (!mLocDesc[i][n6]) continue;
                        ++n8;
                    }
                    SDKInputStream.mDefaultOff[i] = SDKInputStream.readNum(inputStream, n3);
                    if (SDKConfig.getDebugEnabled()) {
                        SDKUtils.debugLog(CLASS_NAME + "initLoader::ridot::mDefaultOff[" + i + "]: " + mDefaultOff[i], 1);
                    }
                    SDKInputStream.mSuplOff[i] = new int[n8];
                    n6 = 0;
                    for (int j = 0; j < n5; ++j) {
                        if (!mLocDesc[i][j]) continue;
                        SDKInputStream.mSuplOff[i][n6++] = SDKInputStream.readNum(inputStream, n3);
                        if (!SDKConfig.getDebugEnabled()) continue;
                        SDKUtils.debugLog(CLASS_NAME + "initLoader::ridot::mSuplOff[" + i + "][" + (n6 - 1) + "]: " + mSuplOff[i][n6 - 1], 1);
                    }
                }
            }
            catch (IOException iOException) {
                if (!SDKConfig.getDebugEnabled()) break block18;
                SDKUtils.debugLog(CLASS_NAME + "initLoader:: cannot read index file: " + iOException.getMessage(), 4);
            }
        }
        mIndexLoaded = true;
    }

    private static int[] findObject(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = mLocalization;
        if (n5 == 0) {
            n4 = mDefaultOff[n];
        } else if (mLocDesc[n][n5 - 1]) {
            int n6 = 0;
            for (n3 = 0; n3 < n5 - 1; ++n3) {
                if (!mLocDesc[n][n3]) continue;
                ++n6;
            }
            n4 = mSuplOff[n][n6];
        } else {
            n5 = 0;
            n4 = mDefaultOff[n];
        }
        int[] nArray = mLastResourceIDs;
        n3 = 0;
        for (n2 = 0; n2 < mDataFileCount; ++n2) {
            if (nArray[n2] < n || n2 <= 0 || nArray[n2 - 1] >= n) continue;
            n3 = n2;
            break;
        }
        n2 = 0;
        if (n == nArray[n3]) {
            n2 = mDataFileSizes[n3][n5] - n4;
        } else {
            for (int i = n + 1; i < mNbRes; ++i) {
                if (n5 == 0) {
                    n2 = mDefaultOff[i] - n4;
                    break;
                }
                if (!mLocDesc[i][n5 - 1]) {
                    if (i != nArray[n3]) continue;
                    n2 = mDataFileSizes[n3][n5] - n4;
                    break;
                }
                int n7 = -1;
                for (int j = 0; j < n5; ++j) {
                    if (!mLocDesc[i][j]) continue;
                    ++n7;
                }
                n2 = mSuplOff[i][n7] - n4;
                break;
            }
        }
        return new int[]{n3, n4, n2, n5};
    }

    public static void purgeCache() {
        if (SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog(CLASS_NAME + "purgeCache::   called", 1);
        }
        if (mLastClosedIS != null) {
            try {
                mLastClosedIS.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            mLastClosedIS = null;
        }
    }

    public static byte[] loadResourceAsByteArray(int n) {
        if (SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog(CLASS_NAME + "loadResourceAsByteArray:: Res=" + n, 1);
        }
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            byte[] byArray = new byte[sDKInputStream.getLength()];
            sDKInputStream.read(byArray);
            sDKInputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog(CLASS_NAME + "loadResourceAsByteArray::  IOException when loading resource=" + n + "; e.msg: " + iOException.getMessage(), 4);
            }
            return null;
        }
    }

    public static void loadResourceAsByteArray(int n, byte[] byArray, int n2) {
        if (SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog(CLASS_NAME + "loadResourceAsByteArray(int, byte[], int):: Res=" + n, 1);
            if (byArray == null) {
                SDKUtils.debugLog(CLASS_NAME + "loadResourceAsByteArray(int, byte[], int):: Buffer is null", 4);
            }
            if (n2 >= byArray.length || n2 < 0) {
                SDKUtils.debugLog(CLASS_NAME + "loadResourceAsByteArray(int,  byte[], int):: Offset is outside the specified array. Buffer size=" + byArray.length + ", offset=" + n2, 4);
            }
        }
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            if (SDKConfig.getDebugEnabled() && sDKInputStream.getLength() > byArray.length - n2) {
                SDKUtils.debugLog(CLASS_NAME + "loadResourceAsByteArray(int,  byte[], int):: The byte array passed as a parameter" + " is not big enough to hold the entire resource starting with the offset specified. Only the first " + (byArray.length - n2) + " bytes will be read.", 3);
            }
            sDKInputStream.read(byArray, n2, sDKInputStream.getLength());
            sDKInputStream.close();
        }
        catch (IOException iOException) {
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog(CLASS_NAME + "loadResourceAsByteArray::  IOException when loading resource=" + n + "; e.msg: " + iOException.getMessage(), 4);
            }
            return;
        }
    }

    public static byte[] loadResourceAsByteArray(String string, byte[] byArray, int n) {
        try {
            if (string.charAt(0) == '/') {
                string = string.substring(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return LibraryStream.GetResourceAsByteArray(string);
    }

    public static SDKImage loadImageObject(int n) {
        if (SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog(CLASS_NAME + "loadImageObject:: Image=" + n, 1);
        }
        try {
            SDKInputStream sDKInputStream = new SDKInputStream(n);
            SDKImage sDKImage = sDKInputStream.readImage();
            sDKInputStream.close();
            return sDKImage;
        }
        catch (Throwable throwable) {
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog(CLASS_NAME + "loadImageObject:: IOException when loading image=" + n + "; e.msg: " + throwable.getMessage(), 4);
            }
            return null;
        }
    }

    public static SDKImage loadImageObjectWithPalette(int n, int n2) {
        return SDKInputStream.loadImageObjectWithPalette(n, new int[]{n2})[0];
    }

    public static final SDKImage[] loadImageObjectWithPalette(int n, int[] nArray) {
        Object object;
        if (SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog(CLASS_NAME + "loadImageObjectWithPalette(int, int[]):: Image=" + n, 1);
            object = new StringBuffer();
            for (int i = 0; i < nArray.length; ++i) {
                ((StringBuffer)object).append(nArray[i] + " ");
                if (i >= nArray.length - 1 || nArray[i] <= nArray[i + 1]) continue;
                SDKUtils.debugLog(CLASS_NAME + "loadImageObjectWithPalette(int, int[])::" + "  Palette IDs are not in order. Performance will not be optimal.", 3);
            }
            ((StringBuffer)object).append(")");
            SDKUtils.debugLog(CLASS_NAME + "loadImageObjectWithPalette(int, int[])::palResIDs: " + ((StringBuffer)object).toString(), 1);
        }
        try {
            int n2;
            object = new SDKInputStream(n);
            byte[] byArray = new byte[((SDKInputStream)object).getLength()];
            ((SDKInputStream)object).read(byArray);
            ((SDKInputStream)object).close();
            SDKImage[] sDKImageArray = new SDKImage[nArray.length];
            for (n2 = 0; n2 < sDKImageArray.length; ++n2) {
                if (nArray[n2] != -1) continue;
                sDKImageArray[n2] = SDKUtils.createImage(byArray, 0, byArray.length);
                break;
            }
            for (n2 = 0; n2 < sDKImageArray.length; ++n2) {
                if (nArray[n2] == -1) continue;
                SDKInputStream sDKInputStream = new SDKInputStream(nArray[n2]);
                byte[] byArray2 = new byte[sDKInputStream.getLength()];
                sDKInputStream.read(byArray2);
                sDKInputStream.close();
                for (int i = 0; i < byArray.length - 4 && (byArray[i] != PLTE[0] || byArray[i + 1] != PLTE[1] || byArray[i + 2] != PLTE[2] || byArray[i + 3] != PLTE[3]); ++i) {
                }
                System.arraycopy(byArray2, 0, byArray, i -= 4, byArray2.length);
                sDKImageArray[n2] = SDKUtils.createImage(byArray, 0, byArray.length);
            }
            return sDKImageArray;
        }
        catch (IOException iOException) {
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog(CLASS_NAME + "loadImageObjectWithPalette(int,  int[]):: IOException, ex.msg: " + iOException.getMessage(), 4);
            }
            return null;
        }
    }

    public SDKInputStream(int n) throws IOException {
        if (SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog(CLASS_NAME + "constructor::new stream requested on resource " + n, 1);
        }
        if (!mIndexLoaded) {
            SDKInputStream.initLoader();
        }
        int[] nArray = SDKInputStream.findObject(n);
        this.res_dfi = nArray[0];
        this.res_offset = nArray[1];
        this.res_length = nArray[2];
        this.res_locale = nArray[3];
        if (SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog(CLASS_NAME + "constructor::res_dfi: " + this.res_dfi, 1);
            SDKUtils.debugLog(CLASS_NAME + "constructor::res_offset: " + this.res_offset, 1);
            SDKUtils.debugLog(CLASS_NAME + "constructor::res_length: " + this.res_length, 1);
            SDKUtils.debugLog(CLASS_NAME + "constructor::res_locale: " + this.res_locale, 1);
        }
        this.res_filename = "/df" + this.res_dfi + "_" + this.res_locale;
        if (mLastClosedIS != null && this.res_dfi == mLastClosedDfi && mLastClosedLocale == this.res_locale && mLastClosedRealPos <= this.res_offset) {
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog(CLASS_NAME + "constructor:: Reusing   a native stream on file " + this.res_filename, 1);
            }
            this.is = mLastClosedIS;
            mLastClosedIS = null;
            SDKInputStream.skipNative(this.is, this.res_offset - mLastClosedRealPos);
        } else {
            this.is = SDKMIDlet.getInstance().getClass().getResourceAsStream(this.res_filename);
            if (SDKConfig.getDebugEnabled()) {
                SDKUtils.debugLog(CLASS_NAME + "constructor:: Opening   a new native stream on file " + this.res_filename, 1);
            }
            if (this.res_offset > 0) {
                SDKInputStream.skipNative(this.is, this.res_offset);
            }
        }
        this.is_pos = 0;
    }

    public void close() throws IOException {
        if (mLastClosedIS != null && mLastClosedIS != this.is) {
            mLastClosedIS.close();
        }
        mLastClosedIS = this.is;
        mLastClosedDfi = this.res_dfi;
        mLastClosedRealPos = this.res_offset + this.is_pos;
        mLastClosedLocale = this.res_locale;
    }

    public int read() throws IOException {
        if (this.is_pos >= this.res_length) {
            return -1;
        }
        ++this.is_pos;
        return this.is.read();
    }

    public int read(byte[] byArray) throws IOException {
        if (byArray == null && SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog(CLASS_NAME + "read(byte[]):: Buffer is null", 4);
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (byArray == null && SDKConfig.getDebugEnabled()) {
            SDKUtils.debugLog(CLASS_NAME + "read(byte[],int,int):: Buffer is null", 4);
        }
        if (this.is_pos >= this.res_length) {
            return -1;
        }
        int n4 = n2;
        if (this.is_pos + n4 > this.res_length) {
            n4 = this.res_length - this.is_pos;
        }
        if ((n3 = SDKInputStream.readBytesNative(this.is, byArray, n, n4)) != -1) {
            this.is_pos += n3;
        }
        return n3;
    }

    public short readShort() throws IOException {
        return (short)(this.read() & 0xFF | (this.read() & 0xFF) << 8);
    }

    public short readShortBE() throws IOException {
        return (short)((this.read() & 0xFF) << 8 | this.read() & 0xFF);
    }

    public int readInt() throws IOException {
        return this.read() | this.read() << 8 | this.read() << 16 | this.read() << 24;
    }

    public int readIntBE() throws IOException {
        return (this.read() & 0xFF) << 24 | (this.read() & 0xFF) << 16 | (this.read() & 0xFF) << 8 | this.read() & 0xFF;
    }

    public int readNum(int n) throws IOException {
        this.is_pos += n;
        return SDKInputStream.readNum(this, n);
    }

    public SDKImage readImage() throws IOException {
        return SDKUtils.createImage(this);
    }

    public int getLength() {
        return this.res_length;
    }

    public int available() {
        return this.res_length - this.is_pos;
    }

    public long skip(long l) throws IOException {
        long l2 = SDKInputStream.skipNative(this.is, l);
        if (l2 > 0L) {
            this.is_pos = (int)((long)this.is_pos + l2);
        }
        return l2;
    }

    public void reset() throws IOException {
        this.is = SDKMIDlet.getInstance().getClass().getResourceAsStream(this.res_filename);
        SDKInputStream.skipNative(this.is, this.res_offset);
        this.is_pos = 0;
    }

    static {
        mLastClosedDfi = -1;
        mLastClosedRealPos = -1;
        mLastClosedLocale = -1;
        PLTE = new byte[]{80, 76, 84, 69};
        if (SDKConfig.getDebugEnabled()) {
            CLASS_NAME = "SDKInputStream::";
        }
    }
}

