/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.GameConstants;
import com.ea.game.GameImpl;
import com.ea.game.IStringConstants;

public class Shot
implements Constants,
IStringConstants,
GameConstants {
    byte _nShotWeapon = (byte)-1;
    int _nShotGoodDamage = 0;
    int _nShotBadDamage = 0;
    int _nShotMinDamage;
    int _nShotMaxDamage;
    int _nShotStartX = 0;
    int _nShotStartY = 0;
    int _nShotTargetX = 0;
    int _nShotTargetY = 0;
    int _nShotPX = 0;
    int _nShotPY = 0;
    int _nShotPower;
    int _nShotRadius = 0;
    int _nShotAngle = 0;
    int _nShotDirection = 0;
    int _nShotDX = 0;
    int _nShotDY = 0;
    int _nShotType = -1;

    Shot() {
    }

    int CompareTo(Shot shot) {
        int n;
        if (shot == null) {
            return 1;
        }
        if (this._nShotWeapon == -1) {
            return -1;
        }
        if (this._nShotBadDamage <= 0 && shot._nShotBadDamage > 0) {
            return 1;
        }
        if (this._nShotBadDamage > 0 && shot._nShotBadDamage <= 0) {
            return -1;
        }
        if (this._nShotGoodDamage > 0 && shot._nShotGoodDamage <= 0) {
            return 1;
        }
        if (this._nShotGoodDamage <= 0 && shot._nShotGoodDamage > 0) {
            return -1;
        }
        if (this._nShotType == shot._nShotType) {
            if (this.ComputeShotValue() < shot.ComputeShotValue()) {
                return -1;
            }
            return 1;
        }
        int n2 = this.ShotValue();
        if (n2 < (n = shot.ShotValue()) * 5 / 6) {
            return -1;
        }
        return 1;
    }

    int ShotValue() {
        int n = this._nShotGoodDamage;
        int n2 = this._nShotBadDamage;
        return (n + 25 << 16) / (n2 + 25);
    }

    int ComputeShotValue() {
        int n = 0;
        switch (this._nShotType) {
            case 0: {
                int n2 = Math.abs(this._nShotPX - this._nShotTargetX) + Math.abs(this._nShotPY - this._nShotTargetY);
                int n3 = GameImpl.Clamp(n2 / 960, 0, 65536);
                n -= n3 * 1000;
                n2 = Math.abs(this._nShotStartX - this._nShotPX) + Math.abs(this._nShotStartY - this._nShotPY);
                n3 = GameImpl.Clamp(n2 / 960, 0, 65536);
                n -= n3 * 500;
                n3 = (this._nShotGoodDamage - this._nShotBadDamage) / 100;
                n += n3 * 230;
                break;
            }
            case 1: {
                int n4 = Math.abs(this._nShotPX - this._nShotTargetX) + Math.abs(this._nShotPY - this._nShotTargetY);
                int n5 = GameImpl.Clamp(n4 / 960, 0, 65536);
                n -= n5 * 20;
                n4 = Math.abs(this._nShotStartX - this._nShotPX) + Math.abs(this._nShotStartY - this._nShotPY);
                n5 = GameImpl.Clamp(n4 / 960, 0, 65536);
                n -= n5 * 20;
                n5 = (this._nShotGoodDamage - this._nShotBadDamage) / 20;
                n += n5 * 5;
                break;
            }
            case 3: {
                n = this._nShotGoodDamage - this._nShotBadDamage;
            }
        }
        return n;
    }
}

