/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.Constants;
import com.ea.game.Entity;
import com.ea.game.Entity2;
import com.ea.game.GameArray;
import com.ea.game.GameConstants;
import com.ea.game.GameImpl;
import com.ea.game.Region;
import com.ea.game.Trigger;
import com.ea.game.XSprite;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKInputStream;

public class Level
implements Constants,
GameConstants {
    public static int _crt_level = -1;
    static int _maxTeamInLevel = 2;
    static int _level_timer;
    static long _last_time;
    static int _lastCellOffset;
    static int[] _lastLevelPlayed;
    static int _sea_level;
    static int _loaded_level_index;
    static boolean _isRealTime;
    static boolean _isTerrainIndestructible;
    static boolean _isWindDisabled;
    static boolean _isWeaponPanelDisabled;
    static boolean _isTimerDisabled;
    static boolean _isMinimapDisabled;
    static boolean _isBinocularDisbaled;
    static final int LEVEL_TERRAIN_DATA = 0;
    static final int LEVEL_ENTITIES_DATA = 1;
    static final int LEVEL_DATA_SIZE = 2;
    static final int[] _border_colors;
    static boolean _lightningStrikeSpawned;
    static int randWormCtr;
    public static boolean _bCursorScroll;
    public static int _nCamX;
    public static int _nCamY;
    public static int _cameraState;
    public static int _nDestX;
    public static int _nDestY;
    public static boolean _camAtDestination;
    static int _nCamSpd;
    static int _nCamSumSpeedMax;
    static int _nCamMaxSpd;
    public static int _nCursorDX;
    public static int _nCursorDY;
    public static int _nCursorPosX;
    public static int _nCursorPosY;
    public static int _nCursorSpdX;
    public static int _nCursorSpdY;
    public static int _followEntityPointer;
    public static boolean _fixCamera;
    public static boolean _bCameraIsShakin;
    public static int _nCameraShakes;
    public static int _nCameraMaxShakes;
    public static int _nMaxOffsetX;
    public static int _nMaxOffsetY;
    public static final byte F_TILE_FULL = 8;
    public static final byte F_TILE_RGB = 16;
    public static final byte F_TILE_EMPTY = 32;
    static final int RGB_MAP_LEVEL = 0;
    static final int TILED_MAP_LEVEL = 1;
    static int _level_draw_type;
    public static byte[] _tiles_flags;
    public static int _currentTileSetSprite;
    public static int _backgroundSprite;
    public static int _level_tw;
    public static int _level_th;
    public static int _level_tiles_size;
    static boolean _bResetCDB;
    public static int _extra_empty_tiles_per_row;
    public static int _cachedTileIndex;
    public static int _cachedColumnIndex;
    static int[][] _tileset_rgbData;
    static int[] _tileRgbData;
    public static int _map_w;
    public static int _map_h;
    public static int _nrTiles;
    public static short[] _tilePalette;
    public static byte[] _map;
    static final int BACKGROUND_IMAGE_TW = 4;
    static final int BACKGROUND_IMAGE_TH = 2;
    static int[] _invalidator_rect;
    static boolean _bInvalidatorCDB;
    public static int _CDB_view_tx;
    public static int _CDB_view_ty;
    public static int _CDB_orig_tx;
    public static int _CDB_orig_ty;
    public static int _CDB_xo;
    public static int _CDB_yo;
    public static int _CDB_oldX;
    public static int _CDB_oldY;
    public static int _CDB_x;
    public static int _CDB_y;
    public static int _CDB_w;
    public static int _CDB_h;
    public static int _CDB_nrRegions;
    public static Region[] _CDB_regions;
    public static int _CDB_separator;
    static int _nLevelMarkPoints;
    static int[][] _aLevelMarkPoints;
    static int _nPoints;
    static int[][] _aPoints;
    static int _nSeed;
    static int _nStyle;
    static int _nGran0;
    static int _nGran1;
    static int _nXScl;
    static int _nYScl;
    static int _nLandMaxWidth;
    static int _nLandMaxHeight;
    static int _nLandWidth;
    static int _nLandHeight;
    static int _colX;
    static int _colY;
    static int detX;
    static int detY;
    static byte[] pMaskSmaller;
    static byte[] pMaskSmall;
    static byte[] pMaskMed;
    static byte[] pMaskBig;
    static byte[] pMaskBiggest;
    static Entity[] _entities;
    static Entity[][] _entities_order;
    static int[] _lengths_order;
    static Entity _entLevel;
    static byte[] _entities_usage;
    static final byte USED_ENTITY = 1;
    static final byte UNUSED_ENTITY = 0;
    static int _lastSpawnedIndex;
    static int _nFishEntities;
    static int _nFirstWormIndex;
    static int _nWormsEntities;
    static int _nFirstBarrelIndex;
    static int _nOilBarrelsEntities;
    static int _nFirstMineIndex;
    static int _nMineEntities;
    static int _nNPCAntEntities;
    static int _nFirstAISensorIndex;
    static int _nAISensorEntities;
    static boolean _bHaveBackpack;
    static int _flashBackpackTimer;
    static int _nMaxUsedEntities;
    private static byte[] _aLandscapeColMask;
    static int _extraPixelsWidth;
    static int _extraPixelsHeightTop;
    static int _extraPixelsHeightBottom;
    public static long _turnTimeLeft;
    public static long _turnTimeStarted;
    public static long _timePerTurn;
    public static long _timeDiff;
    public static int _timerState;
    public static long _retreatTimer;
    public static long _currentRetreatTime;
    public static boolean _bResumeTimerFromMenu;
    static int _nrTriggerEvents;
    static int _nrTriggerActions;
    static Trigger[] _triggerEvents;
    static Trigger[] _triggerActions;

    static void FreeLevelData() {
        Level.ReleaseTriggers();
        Level.FreeCachedTiles();
        Level.DisableAllEntities();
        GameImpl._bDrawCinematicBars = false;
        System.gc();
    }

    static void InitLevel() {
        _last_time = GameImpl.canvas.getAppTime();
        _level_timer = 0;
        _crt_level = -1;
        GameImpl.finishedGame = false;
        Level.ResetCamera();
        _nFishEntities = 0;
        _nFirstBarrelIndex = -1;
        _nOilBarrelsEntities = 0;
        _nFirstWormIndex = -1;
        _nWormsEntities = 0;
        _nFirstMineIndex = -1;
        _nMineEntities = 0;
        _nNPCAntEntities = 0;
        Entity._currentArmageddonNumber = 0;
        GameImpl._bDrawCinematicBars = false;
        Entity._bDisablePauseMenu = false;
        Entity._targetShowCursor = false;
        Entity._changingWind = false;
        GameImpl._nLastActiveTeam = 4;
        GameImpl.MemSet(GameImpl._nPreviousWorm, 0);
        GameImpl.MemSet(GameImpl._nTeamWormCount, 0);
        GameImpl.MemSet(GameImpl._tips_drawn, 0);
        Level.InitParameters();
        if (GameImpl.IsTutorial()) {
            _isBinocularDisbaled = true;
        }
        Level.InitEntities();
        Level.InitTriggers();
        GameImpl._currentTurn = 0;
        GameImpl._cratesSpawned = 0;
        GameImpl._ach_unlock_now_msk = 0;
        Level.ClearLevel();
        Level.UnshiftCollisions();
        _level_draw_type = 0;
        GameImpl._windSpeedMin = 0;
        GameImpl._windSpeedMax = 32768;
        GameImpl._windForceDirection = 0;
        GameImpl._bForceMinimap = false;
        GameImpl._bDrawLife = false;
        GameImpl._sMessageText = null;
        GameImpl._sTopMessageText = null;
        GameImpl._bDisableUpdateWormControls = false;
        _bResumeTimerFromMenu = false;
        GameImpl._gBB.setClip(0, 0, GameImpl.CDB_W, GameImpl.CDB_H);
    }

    static void InitParameters() {
        _isRealTime = false;
        _isTerrainIndestructible = false;
        _isWindDisabled = false;
        _isWeaponPanelDisabled = false;
        _isTimerDisabled = false;
        _isBinocularDisbaled = false;
    }

    static void ClearLevel() {
        Level.ClearTileMap();
    }

    static void ClearOffTimes() {
    }

    static void ClearStatistics() {
    }

    static void UpdateOffTimes() {
    }

    static void CreateLevel(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        Level.InitLevel();
        if (bl) {
            Level.GenerateNewLevel(n3, n4);
        } else {
            GameImpl._nGameMode = 0;
            n7 = Level.GetLevelResourceIndex(n);
            Level.LoadLevelPoints(n7 + 0);
            Level.GenerateLevelBasedOnPoints();
        }
        _loaded_level_index = n7;
    }

    static void InitTeamWeapons() {
        int n;
        _bHaveBackpack = true;
        for (n = 0; n < 36; ++n) {
            GameImpl._teamsWeapons[0][n] = 0;
        }
        GameImpl._unlocked_weapons[0] = -1;
        GameImpl._unlocked_weapons[1] = -1;
        GameImpl._unlocked_weapons[2] = 2;
        GameImpl._unlocked_weapons[3] = -1;
        GameImpl._unlocked_weapons[4] = 2;
        GameImpl._unlocked_weapons[14] = 2;
        GameImpl._unlocked_weapons[15] = 1;
        GameImpl._unlocked_weapons[33] = -1;
        GameImpl._unlocked_weapons[34] = -1;
        GameImpl._unlocked_weapons[35] = -1;
        GameImpl._unlocked_weapons[12] = 3;
        GameImpl._unlocked_weapons[8] = 3;
        if (GameImpl._nLevelType == 0 || GameImpl._nLevelType == 2) {
            for (n = 0; n < 5; ++n) {
                int n2;
                if (GameImpl._nGameMode == 1 && GameImpl._nLevelType == 2) {
                    for (n2 = 0; n2 < 36; ++n2) {
                        GameImpl._teamsWeapons[n][n2] = 0;
                    }
                    GameImpl._teamsWeapons[n][0] = -1;
                    GameImpl._teamsWeapons[n][1] = -1;
                    GameImpl._teamsWeapons[n][3] = -1;
                    GameImpl._teamsWeapons[n][26] = 3;
                    GameImpl._teamsWeapons[n][14] = 4;
                    GameImpl._teamsWeapons[n][20] = 3;
                    GameImpl._teamsWeapons[n][33] = -1;
                    GameImpl._teamsWeapons[n][34] = -1;
                    GameImpl._teamsWeapons[n][35] = -1;
                    continue;
                }
                if (GameImpl._nGameMode == 4 && GameImpl._nLevelType == 2) {
                    for (n2 = 0; n2 < 36; ++n2) {
                        GameImpl._teamsWeapons[n][n2] = 0;
                    }
                    GameImpl._teamsWeapons[n][0] = -1;
                    GameImpl._teamsWeapons[n][1] = -1;
                    GameImpl._teamsWeapons[n][3] = -1;
                    GameImpl._teamsWeapons[n][31] = 3;
                    GameImpl._teamsWeapons[n][7] = 3;
                    GameImpl._teamsWeapons[n][8] = 3;
                    GameImpl._teamsWeapons[n][9] = 3;
                    GameImpl._teamsWeapons[n][12] = 3;
                    GameImpl._teamsWeapons[n][14] = 3;
                    GameImpl._teamsWeapons[n][17] = 1;
                    GameImpl._teamsWeapons[n][21] = 3;
                    GameImpl._teamsWeapons[n][30] = 1;
                    GameImpl._teamsWeapons[n][33] = -1;
                    GameImpl._teamsWeapons[n][34] = -1;
                    GameImpl._teamsWeapons[n][35] = -1;
                    continue;
                }
                if (GameImpl._nGameMode == 5 && GameImpl._nLevelType == 2) {
                    for (n2 = 0; n2 < 36; ++n2) {
                        GameImpl._teamsWeapons[n][n2] = 0;
                    }
                    GameImpl._teamsWeapons[n][3] = -1;
                    GameImpl._teamsWeapons[n][15] = 1;
                    GameImpl._teamsWeapons[n][9] = -1;
                    GameImpl._teamsWeapons[n][21] = 4;
                    GameImpl._teamsWeapons[n][27] = 3;
                    GameImpl._teamsWeapons[n][32] = 2;
                    GameImpl._teamsWeapons[n][2] = 2;
                    GameImpl._teamsWeapons[n][20] = 2;
                    GameImpl._teamsWeapons[n][14] = 3;
                    GameImpl._teamsWeapons[n][8] = -1;
                    GameImpl._teamsWeapons[n][26] = 4;
                    GameImpl._teamsWeapons[n][33] = -1;
                    GameImpl._teamsWeapons[n][34] = -1;
                    GameImpl._teamsWeapons[n][35] = -1;
                    continue;
                }
                if (GameImpl._nGameMode == 2 && GameImpl._nLevelType == 2) {
                    for (n2 = 0; n2 < 36; ++n2) {
                        GameImpl._teamsWeapons[n][n2] = 0;
                    }
                    GameImpl._teamsWeapons[n][0] = -1;
                    GameImpl._teamsWeapons[n][2] = -1;
                    GameImpl._teamsWeapons[n][8] = -1;
                    continue;
                }
                System.arraycopy(GameImpl._unlocked_weapons, 0, GameImpl._teamsWeapons[n], 0, 36);
                for (n2 = 0; n2 < 36; ++n2) {
                    int[] nArray = GameImpl._teamsWeapons[n];
                    int n3 = n2;
                    nArray[n3] = nArray[n3] + GameImpl._unlocked_crate_weapons[n2];
                }
            }
        } else if (GameImpl._nLevelType == 1) {
            if (!GameImpl._isFiringRange) {
                System.arraycopy(GameImpl._unlocked_weapons, 0, GameImpl._teamsWeapons[0], 0, 36);
                for (n = 0; n < 36; ++n) {
                    int[] nArray = GameImpl._teamsWeapons[0];
                    int n4 = n;
                    nArray[n4] = nArray[n4] + GameImpl._unlocked_crate_weapons[n];
                }
            } else {
                for (n = 0; n < 36; ++n) {
                    GameImpl._teamsWeapons[0][n] = -1;
                }
            }
            if (GameImpl.IsTutorial()) {
                _bHaveBackpack = false;
            }
        }
        for (n = 0; n < 5; ++n) {
            GameImpl._teamsWeapons[n][33] = -1;
            GameImpl._teamsWeapons[n][34] = -1;
            GameImpl._teamsWeapons[n][35] = -1;
        }
    }

    static void GenerateNewLevel(int n, int n2) {
        if (n == -1) {
            n = GameImpl.random(4);
        }
        if (n2 == -1) {
            Level.SetSeed(GameImpl._random.nextInt());
            n2 = Level.IRandom();
        }
        _extraPixelsWidth = 0;
        Level.GenerateLandscape(n2, n);
    }

    static void UpdateLevel() {
        long l = GameImpl.canvas.getAppTime();
        _level_timer = (int)((long)_level_timer + (l - _last_time));
        _last_time = l;
        try {
            Level.UpdateCursor();
            Level.UpdateCamera();
            Level.CDB_Update();
            Level.CDB_Invalidator_Update();
            Level.UpdateEntities();
            Level.UpdateTriggers();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void DrawLevel(SDKGraphics sDKGraphics) {
        try {
            sDKGraphics.setClip(0, 0, GameConstants.SCREEN_WIDTH, GameConstants.SCREEN_HEIGHT);
            Level.ComputeZorders();
            Level.DrawEntities(sDKGraphics);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void EndLevel(int n) {
        GameImpl.SetGameState(4);
    }

    static boolean IsFixedEntity(int n) {
        return false;
    }

    static boolean IsCDBEntity(Entity entity) {
        return false;
    }

    static void ApplyTileset(int n) {
        if (_backgroundSprite != -1) {
            GameImpl.FreeSprite(_backgroundSprite);
        }
        if (n != -1) {
            _currentTileSetSprite = GameImpl._gen_lvl_tileset;
        } else {
            int n2 = GameImpl.random(5);
            _currentTileSetSprite = 43 + n2;
        }
        try {
            GameImpl.LoadSprite(_currentTileSetSprite);
            _backgroundSprite = Level.GetBackgroundSprite(_currentTileSetSprite);
            GameImpl.LoadSprite(_backgroundSprite);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void ModifyCachedTile(int n, int[] nArray, int n2, int n3, int n4, byte by, boolean bl) {
        int n5 = Level.GetUnshiftedTileIndex(n);
        int n6 = n % _level_tw * 64;
        int n7 = n / _level_tw * 64;
        for (int i = 0; i < 64; ++i) {
            for (int j = 0; j < 64; ++j) {
                int n8;
                int n9 = n6 - n2 + i;
                int n10 = n7 - n3 + j;
                if (n9 < 0 || n9 >= n4 || n10 < 0 || n10 * n4 >= nArray.length || ((n8 = nArray[n9 + n10 * n4]) & 0xFF000000) == 0 || bl && Level.GetLandscapeCollision(n6 + i, n7 + j) != 0) continue;
                Level.SetLandscapeCollision(n6 + i, n7 + j, by);
            }
        }
    }

    static void SetLandscapeImagePixel(int n, int n2, int n3) {
    }

    static void GetmaxTeams() {
        _maxTeamInLevel = 0;
        for (int i = 0; i < 5; ++i) {
            if (GameImpl._teamsHealth[i] == 0) continue;
            ++_maxTeamInLevel;
        }
    }

    static void InitHealthBars() {
        int n;
        if (_isRealTime) {
            return;
        }
        GameImpl.MemSet(GameImpl._teamsHealth, 0);
        for (n = _nFirstWormIndex; n < _nFirstWormIndex + _nWormsEntities; ++n) {
            if (Level._entities[n]._type != 1 || _entities[n].Worm_IsDyingOrDead()) continue;
            if (GameImpl._nGameMode == 1 && GameImpl._nLevelType == 2) {
                Level._entities[n]._health = 200;
            }
            byte by = Level._entities[n]._bdata[3];
            GameImpl._teamsHealth[by] = GameImpl._teamsHealth[by] + Level._entities[n]._health;
        }
        GameImpl._healthBarMaxValue = GameImpl._teamsHealth[0];
        for (n = 1; n < GameImpl._teamsHealth.length; ++n) {
            if (GameImpl._healthBarMaxValue >= GameImpl._teamsHealth[n]) continue;
            GameImpl._healthBarMaxValue = GameImpl._teamsHealth[n];
        }
    }

    static void UpdateHealthBars() {
        int n;
        if (_isRealTime) {
            return;
        }
        System.arraycopy(GameImpl._teamsHealth, 0, GameImpl._oldTeamsHealth, 0, 5);
        GameImpl.MemSet(GameImpl._teamsHealth, 0);
        for (n = _nFirstWormIndex; n < _nFirstWormIndex + _nWormsEntities; ++n) {
            if (Level._entities[n]._type != 1 || _entities[n].Worm_IsDyingOrDead()) continue;
            byte by = Level._entities[n]._bdata[3];
            GameImpl._teamsHealth[by] = GameImpl._teamsHealth[by] + Level._entities[n]._health;
        }
        GameImpl._bDrawLife = true;
        for (n = 0; n < 5; ++n) {
            GameImpl._teamsHealthDivision[n] = (GameImpl._oldTeamsHealth[n] - GameImpl._teamsHealth[n]) / 20;
            GameImpl._teamsHealthDivision[n] = GameImpl._teamsHealthDivision[n] + (GameImpl._teamsHealthDivision[n] > 0 ? 1 : -1) * 2;
        }
        GameImpl._drawLifeTimer = GameImpl.canvas.getAppTime();
    }

    static void DrawDebugPoints(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(-65536);
        for (int i = 0; i < _nPoints; ++i) {
            int n = _aPoints[i][0];
            int n2 = _aPoints[i][1];
            int n3 = n >> 16;
            int n4 = n2 >> 16;
            sDKGraphics.fillRect(n3 - 2 - _nCamX + 192, n4 - 2 - _nCamY + 192, 4, 4);
        }
    }

    static void DrawSearchPath(SDKGraphics sDKGraphics, int n) {
    }

    static void ComputeZorders() {
        GameImpl.MemSet(_lengths_order, 0);
        for (int i = 0; i < _nMaxUsedEntities; ++i) {
            if (_entities_usage[i] != 1) continue;
            Entity entity = _entities[i];
            int n = entity._z_order;
            if (!GameImpl.IntersectsRectRect(_nCamX - 100, _nCamY - 80, GameImpl.SV_W + 100 + 100, GameImpl.SV_H + 80 + 80, (entity._pos_x >> 16) + entity._bbox[0], (entity._pos_y >> 16) + entity._bbox[1], entity._bbox[2] - entity._bbox[0], entity._bbox[3] - entity._bbox[1]) && entity != GameImpl._pCrtWorm) continue;
            Level._entities_order[n][Level._lengths_order[n]] = _entities[i];
            int n2 = n;
            _lengths_order[n2] = _lengths_order[n2] + 1;
        }
    }

    static int GetLevelResourceIndex(int n) {
        int n2;
        int n3 = 136;
        for (int i = 0; i < n; ++i) {
            n3 += 2;
        }
        Level._lastLevelPlayed[n] = n2 = 0;
        return n3;
    }

    static void SetWormsHats() {
        int n;
        if (GameImpl._nLevelType == 0 || GameImpl._nLevelType == 2 && GameImpl._nGameControls == 0) {
            if (GameImpl._nLevelType == 0) {
                GameImpl._chosen_hats[0] = GameArray._kFactionsHats[0];
                GameImpl._chosen_dance[0] = GameArray._kFactionsDance[0];
                GameImpl._chosen_tomb[0] = GameArray._kFactionsTomb[0];
                GameImpl._chosen_hats[1] = GameArray._kFactionsHats[GameImpl._currfaction + 1];
                GameImpl._chosen_dance[1] = GameArray._kFactionsDance[GameImpl._currfaction + 1];
                GameImpl._chosen_tomb[1] = GameArray._kFactionsTomb[GameImpl._currfaction + 1];
            } else {
                GameImpl._chosen_hats[1] = GameImpl._chosen_hats[0];
                GameImpl._chosen_hats[2] = GameImpl._chosen_hats[0];
                while (GameImpl._chosen_hats[0] == GameImpl._chosen_hats[1] || GameImpl._chosen_hats[1] == GameImpl._chosen_hats[2] || GameImpl._chosen_hats[0] == GameImpl._chosen_hats[2]) {
                    n = GameImpl.random(0, 4);
                    int n2 = GameImpl.random(0, 4);
                    GameImpl._chosen_hats[1] = GameArray._kFactionsHats[n];
                    GameImpl._chosen_dance[1] = GameArray._kFactionsDance[n];
                    GameImpl._chosen_tomb[1] = GameArray._kFactionsTomb[n];
                    GameImpl._chosen_hats[2] = GameArray._kFactionsHats[n2];
                    GameImpl._chosen_dance[2] = GameArray._kFactionsDance[n2];
                    GameImpl._chosen_tomb[2] = GameArray._kFactionsTomb[n2];
                }
            }
        } else if (GameImpl._nLevelType == 1) {
            GameImpl._chosen_hats[0] = GameArray._kFactionsHats[0];
            GameImpl._chosen_dance[0] = GameArray._kFactionsDance[0];
            GameImpl._chosen_tomb[0] = GameArray._kFactionsTomb[0];
            if (GameImpl._nActiveIslandID != -1 && !GameImpl.IsTutorial()) {
                GameImpl._chosen_hats[1] = GameArray._kFactionsHats[GameImpl._campaignData[GameImpl._nActiveIslandID][10] + 1];
                GameImpl._chosen_dance[1] = GameArray._kFactionsDance[GameImpl._campaignData[GameImpl._nActiveIslandID][10] + 1];
                GameImpl._chosen_tomb[1] = GameArray._kFactionsTomb[GameImpl._campaignData[GameImpl._nActiveIslandID][10] + 1];
                if (GameImpl._campaignData[GameImpl._nActiveIslandID][11] != GameImpl._campaignData[GameImpl._nActiveIslandID][12]) {
                    GameImpl._chosen_hats[2] = GameArray._kFactionsHats[GameImpl._campaignData[GameImpl._nActiveIslandID][12] + 1];
                    GameImpl._chosen_dance[2] = GameArray._kFactionsDance[GameImpl._campaignData[GameImpl._nActiveIslandID][12] + 1];
                    GameImpl._chosen_tomb[2] = GameArray._kFactionsTomb[GameImpl._campaignData[GameImpl._nActiveIslandID][12] + 1];
                }
            }
        }
        for (n = 0; n < _nMaxUsedEntities; ++n) {
            if (_entities_usage[n] != 1 || Level._entities[n]._type != 1) continue;
            if (GameImpl._nLevelType == 1) {
                _entities[n].SetHats(GameImpl._chosen_hats[Level._entities[n]._bdata[3]]);
                continue;
            }
            _entities[n].SetHats(GameImpl._chosen_hats[Level._entities[n]._bdata[3]]);
        }
    }

    static int GetBackgroundSprite(int n) {
        switch (n) {
            case 43: {
                return 48;
            }
            case 44: {
                return 49;
            }
            case 45: {
                return 50;
            }
            case 46: {
                return 51;
            }
            case 47: {
                return 52;
            }
        }
        return 43;
    }

    static int GetShiftedTileIndex(int n) {
        int n2 = n;
        n2 = n + _extra_empty_tiles_per_row / 2 + n / 15 * _extra_empty_tiles_per_row;
        return n2 += _extraPixelsHeightTop / 64 * _level_tw;
    }

    static int GetUnshiftedTileIndex(int n) {
        int n2 = n;
        n2 = n - _extraPixelsHeightTop / 64 * _level_tw;
        n2 -= (1 + 2 * (n2 / _level_tw)) * (_extraPixelsWidth / 64);
        return n2;
    }

    public static void EndCreateLevel(boolean bl, int n, int n2, int n3, int n4, int n5, int n6) {
        _crt_level = n;
        _bResetCDB = true;
        int n7 = 0;
        if (!bl) {
            n7 = _loaded_level_index;
        }
        Level.SpawnLevelEntity();
        if (bl) {
            Level.SpawnWorms(GameImpl._team_worms);
            Level.SpawnLevelObjects(3, 12);
            Level.SpawnLevelObjects(3, 13);
        } else {
            Level.LoadEntities(n7 + 1);
            Level.CheckTriggers((short)62, null, false);
        }
        SDKInputStream.purgeCache();
        System.gc();
        Level.ResetCamera();
        Level.InitHealthBars();
        Level.InitTeamWeapons();
        Level.GetmaxTeams();
        GameImpl._loadingStatus = 1;
        Level.SetWormsHats();
        randWormCtr = _nFirstWormIndex;
        Entity.useLight = true;
        int n8 = _nFirstWormIndex;
        for (int i = 0; i < 4; ++i) {
            Entity.rememberDamageCausedByHumans[i] = n8++;
        }
        for (n8 = 0; n8 < 4; ++n8) {
            Constants.wormStatusArray[n8] = 0;
            Constants.wormStatusArray2[n8] = 0;
        }
    }

    static void ApplyTilesetAndTileFlags(int n) {
        Level.ApplyTileset(n);
        Level.ShiftCollisions();
        Level.InitTileFlags();
    }

    public static void ResetCamera() {
        _nCamMaxSpd = 20;
        _nCamSpd = 8;
        _nCamSumSpeedMax = 0;
        _camAtDestination = false;
        _nCursorPosX = GameConstants.SCREEN_WIDTH / 2;
        _nCursorPosY = GameConstants.SCREEN_HEIGHT / 2;
        _nCamX = 0;
        _nCamY = 0;
    }

    public static void DoScroll(int n, int n2) {
        _nDestX = n < 0 ? 0 : n;
        _nDestY = n2 < 0 ? 0 : n2;
        _nCursorDX = _nCursorPosX - _nCamX;
        _nCursorDY = _nCursorPosY - _nCamY;
        _nCamSpd = 8;
        Level.SetCameraState(1);
    }

    public static void ShakeCamera() {
        if (_nCameraShakes >= _nCameraMaxShakes) {
            Level.StopCameraShake();
        }
        int n = (GameImpl.random(_nMaxOffsetX) + 2) * (_nCameraShakes % 2 == 1 ? 1 : -1);
        int n2 = (GameImpl.random(_nMaxOffsetY) + 2) * (_nCameraShakes % 2 == 1 ? 1 : -1);
        _nCamX += n;
        _nCamY += n2;
        ++_nCameraShakes;
    }

    public static void StartCameraShake(int n) {
    }

    public static void StopCameraShake() {
        _bCameraIsShakin = false;
        _nCameraShakes = 0;
        _nCameraMaxShakes = 0;
    }

    public static void DoFollowEntity(int n) {
        _followEntityPointer = n;
        _nCamSpd = 8;
        Level.SetCameraState(3);
    }

    static void SetCameraState(int n) {
        if (_cameraState == n) {
            return;
        }
        switch (_cameraState) {
            case 3: {
                _followEntityPointer = -1;
                break;
            }
            case 2: {
                _nCursorPosX = _nCamX + GameConstants.SCREEN_WIDTH / 2;
                _nCursorPosY = _nCamY + GameConstants.SCREEN_HEIGHT / 2;
                break;
            }
            case 0: {
                Entity._targetShowCursor = false;
                break;
            }
            case 4: {
                _fixCamera = false;
            }
        }
        _cameraState = n;
    }

    static void UpdateCamera() {
        switch (_cameraState) {
            case 0: {
                Level.Update_State_Cursor();
                break;
            }
            case 2: {
                Level.Update_State_CenterCursor();
                break;
            }
            case 1: {
                Level.Update_State_Scroll();
                break;
            }
            case 3: {
                Level.Update_State_FollowEntity();
            }
        }
        if (_bCameraIsShakin) {
            Level.ShakeCamera();
        }
    }

    private static boolean MoveCamera() {
        int n;
        int n2 = _nDestX - _nCamX;
        int n3 = _nDestY - _nCamY;
        int n4 = Math.abs(n2);
        int n5 = Math.abs(n3);
        int n6 = n4 + n5;
        _camAtDestination = false;
        if (n6 <= 0) {
            _nCamX = _nDestX;
            _nCamY = _nDestY;
            _camAtDestination = true;
            return false;
        }
        if (n6 <= _nCamSpd) {
            _nCamX = _nDestX;
            _nCamY = _nDestY;
            _camAtDestination = false;
            return true;
        }
        n6 = n4 > n5 ? n4 : n5;
        n2 = (n2 * _nCamSpd << 6) / n6;
        n3 = (n3 * _nCamSpd << 6) / n6;
        if (_nCamSumSpeedMax != 0 && (n = Math.abs(n2) + Math.abs(n3)) > _nCamSumSpeedMax) {
            n2 = (n2 * _nCamSumSpeedMax << 6) / n;
            n3 = (n3 * _nCamSumSpeedMax << 6) / n;
        }
        _nCamX = (_nCamX << 6) + n2 >> 6;
        _nCamY = (_nCamY << 6) + n3 >> 6;
        return true;
    }

    private static void Update_State_Cursor() {
        _bCursorScroll = false;
        if (_nCamX > _nCursorPosX - 80) {
            _nCamX = _nCursorPosX - 80;
            _bCursorScroll = true;
            if (_nCamX < 0) {
                _nCamX = 0;
            }
        }
        if (_nCamX < _nCursorPosX + 80 - GameImpl.SV_W) {
            _nCamX = _nCursorPosX + 80 - GameImpl.SV_W;
            _bCursorScroll = true;
            if (_nCamX > _nLandMaxWidth - GameImpl.SV_W) {
                _nCamX = _nLandMaxWidth - GameImpl.SV_W;
            }
        }
        if (_nCamY > _nCursorPosY - 0 - 80) {
            _nCamY = _nCursorPosY - 0 - 80;
            _bCursorScroll = true;
            if (_nCamY < 0) {
                _nCamY = 0;
            }
        }
        if (_nCamY + GameImpl.SV_H < _nCursorPosY + 80) {
            _nCamY = _nCursorPosY + 80 - GameImpl.SV_H;
            _bCursorScroll = true;
            if (_nCamY > _nLandMaxHeight - GameImpl.SV_H) {
                _nCamY = _nLandMaxHeight - GameImpl.SV_H;
            }
        }
    }

    private static void Update_State_CenterCursor() {
        _bCursorScroll = true;
        _nCamX = _nCursorPosX - (GameImpl.SV_W >> 1);
        _nCamY = _nCursorPosY - (GameImpl.SV_H >> 1);
        if (_nCamX < 0) {
            _nCamX = 0;
        }
        if (_nCamX > _nLandMaxWidth - GameImpl.SV_W) {
            _nCamX = _nLandMaxWidth - GameImpl.SV_W;
        }
        if (_nCamY < 0) {
            _nCamY = 0;
        }
        if (_nCamY > _nLandMaxHeight - GameImpl.SV_H) {
            _nCamY = _nLandMaxHeight - GameImpl.SV_H;
        }
    }

    private static void Update_State_Scroll() {
        boolean bl = false;
        if ((_nCamSpd += 4) > _nCamMaxSpd) {
            _nCamSpd = _nCamMaxSpd;
        }
        if (Level.MoveCamera()) {
            if (_nCamX < 0) {
                _nCamX = 0;
                bl = true;
            }
            if (_nCamX > _nLandMaxWidth - GameImpl.SV_W) {
                _nCamX = _nLandMaxWidth - GameImpl.SV_W;
                bl = true;
            }
            if (_nCamY < 0) {
                _nCamY = 0;
                bl = true;
            }
            if (_nCamY > _nLandMaxHeight - GameImpl.SV_H) {
                _nCamY = _nLandMaxHeight - GameImpl.SV_H;
                bl = true;
            }
        } else {
            if (_nCamX < 0) {
                _nCamX = 0;
            }
            if (_nCamX > _nLandMaxWidth - GameImpl.SV_W) {
                _nCamX = _nLandMaxWidth - GameImpl.SV_W;
            }
            if (_nCamY < 0) {
                _nCamY = 0;
            }
            if (_nCamY > _nLandMaxHeight - GameImpl.SV_H) {
                _nCamY = _nLandMaxHeight - GameImpl.SV_H;
            }
            bl = true;
        }
        _nCursorPosX = _nCamX + _nCursorDX;
        _nCursorPosY = _nCamY + _nCursorDY;
        if (bl) {
            Level.SetCameraState(2);
        }
    }

    private static void Update_State_FollowEntity() {
        Entity entity = Level.GetEntitySafe(_followEntityPointer);
        if (entity == null) {
            return;
        }
        if ((_nCamSpd += 4) > _nCamMaxSpd) {
            _nCamSpd = _nCamMaxSpd;
        }
        _bCursorScroll = false;
        int n = 0;
        if (GameImpl.GetGameState() == 7 && GameImpl._sTopMessageText != null && GameImpl.IsTutorial()) {
            n = 40;
        }
        _nDestX = entity._type == 1 && entity == GameImpl._pCrtWorm && !GameImpl._bRetreating && Entity2.IsRangedWeapon(entity._bdata[15]) ? (entity._pos_x >> 16) - (GameImpl.SV_W >> 1) + entity._bdata[5] * Constants.AIM_OFFSET_X : (entity._pos_x >> 16) - (GameImpl.SV_W >> 1);
        _nDestY = (entity._pos_y >> 16) - (GameImpl.SV_H >> 1) - n;
        _nCursorDX = _nCursorPosX - _nCamX;
        _nCursorDY = _nCursorPosY - _nCamY;
        if (_nDestX < 0) {
            _nDestX = 0;
        }
        if (_nDestX > _nLandMaxWidth - GameImpl.SV_W) {
            _nDestX = _nLandMaxWidth - GameImpl.SV_W;
        }
        if (_nDestY < 0) {
            _nDestY = 0;
        }
        if (_nDestY > _nLandMaxHeight - GameImpl.SV_H) {
            _nDestY = _nLandMaxHeight - GameImpl.SV_H;
        }
        Level.MoveCamera();
        _nCursorPosX = _nCamX + _nCursorDX;
        _nCursorPosY = _nCamY + _nCursorDY;
    }

    public static void UpdateCursor() {
        if (GameImpl.GetGameState() == 7 && (GameImpl._nGamePlayState == 11 || GameImpl._nGamePlayState == 4 || GameImpl._nGamePlayState == 7)) {
            return;
        }
        if (_cameraState != 2 && _cameraState != 0) {
            return;
        }
        if (GameImpl.isKeyPressed(2052)) {
            if (_nCursorSpdX > 0) {
                _nCursorSpdX = 0;
            }
            if ((_nCursorSpdX -= 13) < -26) {
                _nCursorSpdX = -26;
            }
        } else if (GameImpl.isKeyPressed(8200)) {
            if (_nCursorSpdX < 0) {
                _nCursorSpdX = 0;
            }
            if ((_nCursorSpdX += 13) > 26) {
                _nCursorSpdX = 26;
            }
        } else {
            _nCursorSpdX = 0;
        }
        if (GameImpl.isKeyPressed(513)) {
            if (_nCursorSpdY > 0) {
                _nCursorSpdY = 0;
            }
            if ((_nCursorSpdY -= 13) < -26) {
                _nCursorSpdY = -26;
            }
        } else if (GameImpl.isKeyPressed(32770)) {
            if (_nCursorSpdY < 0) {
                _nCursorSpdY = 0;
            }
            if ((_nCursorSpdY += 13) > 26) {
                _nCursorSpdY = 26;
            }
        } else {
            _nCursorSpdY = 0;
        }
        if (_nCursorSpdX > 0) {
            if ((_nCursorPosX += _nCursorSpdX) > _nLandMaxWidth - 15) {
                _nCursorPosX = _nLandMaxWidth - 15;
            }
        } else if (_nCursorSpdX < 0 && (_nCursorPosX += _nCursorSpdX) < 15) {
            _nCursorPosX = 15;
        }
        if (_nCursorSpdY > 0) {
            if ((_nCursorPosY += _nCursorSpdY) > _sea_level - 10) {
                _nCursorPosY = _sea_level - 10;
            }
        } else if (_nCursorSpdY < 0) {
            _nCursorPosY += _nCursorSpdY;
            int n = -55;
            if (GameImpl.GetGameState() == 7 && (GameImpl._pCrtWorm._bdata[15] == 14 || GameImpl._pCrtWorm._bdata[15] == 28 || GameImpl._pCrtWorm._bdata[15] == 17 || GameImpl._pCrtWorm._bdata[15] == 6 || GameImpl._pCrtWorm._bdata[15] == 17 || GameImpl._pCrtWorm._bdata[15] == 5 || GameImpl._pCrtWorm._bdata[15] == 11) || GameImpl.GetGameState() == 18) {
                n = 25;
            }
            if (_nCursorPosY < n) {
                _nCursorPosY = n;
            }
        }
    }

    static void ClearTileMap() {
        _tiles_flags = null;
        System.gc();
    }

    public static void InitTileFlags() {
        int n = -1;
        int n2 = -1;
        if (_tiles_flags == null) {
            _tiles_flags = new byte[_level_tw * _level_tw];
        }
        _level_tiles_size = _level_tw * _level_th;
        GameImpl.MemSet(_tiles_flags, (byte)32);
        int n3 = 0;
        for (int i = 0; i < 90; ++i) {
            int n4;
            boolean bl = false;
            boolean bl2 = false;
            n = n2;
            int n5 = i % 15;
            int n6 = i / 15;
            for (n4 = 0; n4 < 64; ++n4) {
                for (int j = 0; j < 8; ++j) {
                    n3 = n6 * 7680 + n4 * 120 + n5 * 8 + j;
                    if (n3 >= _aLandscapeColMask.length) {
                        bl = true;
                        continue;
                    }
                    int n7 = _aLandscapeColMask[n3];
                    if (n7 == n2) {
                        bl2 = true;
                        continue;
                    }
                    if (n7 == 0) {
                        bl = true;
                        continue;
                    }
                    n = 16;
                    break;
                }
                if (n == 16) break;
                n = bl && bl2 ? 16 : (bl ? 32 : 8);
            }
            n4 = Level.GetShiftedTileIndex(i);
            n4 = i + _extra_empty_tiles_per_row / 2 + i / 15 * _extra_empty_tiles_per_row;
            Level._tiles_flags[n4 += Level._extraPixelsHeightTop / 64 * Level._level_tw] = n;
        }
    }

    public static int[] CacheTile(int n) {
        GameImpl.MemSet(_tileRgbData, 0);
        int n2 = n;
        int n3 = n % _level_tw;
        int n4 = n / _level_tw;
        if (n3 < _extra_empty_tiles_per_row / 2 || n3 >= 15 + _extra_empty_tiles_per_row / 2) {
            return _tileRgbData;
        }
        if (n4 < _extraPixelsHeightTop / 64 || n4 >= 6 + _extraPixelsHeightTop / 64) {
            return _tileRgbData;
        }
        n2 = (n4 - _extraPixelsHeightTop / 64) * 15 + (n3 - _extra_empty_tiles_per_row / 2);
        if (_tiles_flags[n] != 16) {
            return _tileRgbData;
        }
        int n5 = Level.GetTilesetModule(n);
        if (_tileset_rgbData == null) {
            _tileset_rgbData = new int[GameImpl._sprites[Level._currentTileSetSprite]._modules][];
        }
        if (_tileset_rgbData[n5] == null) {
            Level._tileset_rgbData[n5] = new int[4096];
            int[] nArray = GameImpl._sprites[_currentTileSetSprite].DecodeModule(n5, 0, 0);
            System.arraycopy(nArray, 0, _tileset_rgbData[n5], 0, 4096);
            nArray = null;
        }
        System.arraycopy(_tileset_rgbData[n5], 0, _tileRgbData, 0, 4096);
        int n6 = 0;
        int n7 = n % _level_tw * 64;
        int n8 = n / _level_tw * 64;
        int n9 = 0;
        int n10 = 0;
        int n11 = 1;
        for (int i = 0; i < 64; i += n11) {
            n10 = 0;
            for (int j = 0; j < 64; ++j) {
                n10 = Level.GetLandscapeCollision(n7 + i, n8 + j);
                n9 = i + j * 64;
                if (n10 < 1) {
                    Level._tileRgbData[n9] = 0;
                    continue;
                }
                ++n6;
            }
        }
        if (n6 == 0) {
            Level._tiles_flags[n] = 32;
        }
        return _tileRgbData;
    }

    public static int GetTilesetModule(int n) {
        int n2 = n % _level_tw % 2;
        int n3 = n / _level_tw % 2;
        return n2 + n3 * 2;
    }

    public static void FreeCachedTiles() {
        _tileset_rgbData = null;
        _cachedTileIndex = 0;
        _cachedColumnIndex = 0;
        _nCamX = 0;
        _nCamY = 0;
        System.gc();
    }

    static void CDB_Invalidator_Init() {
        GameImpl.ResetRect(_invalidator_rect);
    }

    static void CDB_AddInvalidateRegion(int[] nArray) {
        _bInvalidatorCDB = true;
        GameImpl.RectUnion(_invalidator_rect, _invalidator_rect, nArray);
    }

    static void CDB_AddInvalidateRegion(int n, int n2, int n3, int n4) {
        _bInvalidatorCDB = true;
        Level._invalidator_rect[0] = Math.min(_invalidator_rect[0], n);
        Level._invalidator_rect[1] = Math.min(_invalidator_rect[1], n2);
        Level._invalidator_rect[2] = Math.max(_invalidator_rect[2], n + n3);
        Level._invalidator_rect[3] = Math.max(_invalidator_rect[3], n2 + n4);
    }

    static void CDB_Invalidator_Update() {
        if (_bInvalidatorCDB) {
            _bInvalidatorCDB = false;
            Level.CDB_InvalidatePixels(_invalidator_rect[0], _invalidator_rect[1], _invalidator_rect[2] - _invalidator_rect[0], _invalidator_rect[3] - _invalidator_rect[1], false);
            GameImpl.ResetRect(_invalidator_rect);
        }
    }

    static void __CDB_INVALIDATOR() {
    }

    static void InitTileMap() {
        _CDB_w = GameImpl.CDB_W;
        _CDB_h = GameImpl.CDB_H;
        _level_draw_type = 1;
    }

    static void CDB_Update() {
        int n;
        int n2;
        int n3;
        if (!_bResetCDB) {
            n3 = _nCamX - _CDB_view_tx * 64;
            if (n3 < 0) {
                n2 = (63 - n3) / 64;
                if (n2 >= GameImpl.CDB_TW) {
                    _bResetCDB = true;
                } else {
                    _CDB_view_tx -= n2;
                    if ((_CDB_orig_tx -= n2) < 0) {
                        n = n2 + _CDB_orig_tx;
                        if (n != 0) {
                            Level.CDB_InvalidateTilesV(0, n, _CDB_view_tx - _CDB_orig_tx);
                        }
                        Level.CDB_InvalidateTilesV(_CDB_orig_tx += GameImpl.CDB_TW, n2 - n, _CDB_view_tx);
                    } else {
                        Level.CDB_InvalidateTilesV(_CDB_orig_tx, n2, _CDB_view_tx);
                    }
                }
            } else if (n3 > GameImpl.CDB_W - GameImpl.SV_W) {
                n2 = (n3 - (GameImpl.CDB_W - GameImpl.SV_W) + 63) / 64;
                if (n2 >= GameImpl.CDB_TW) {
                    _bResetCDB = true;
                } else {
                    n = _CDB_orig_tx + n2 - GameImpl.CDB_TW;
                    if (n >= 0) {
                        Level.CDB_InvalidateTilesV(_CDB_orig_tx, GameImpl.CDB_TW - _CDB_orig_tx, _CDB_view_tx + GameImpl.CDB_TW);
                        if (n != 0) {
                            Level.CDB_InvalidateTilesV(0, n, _CDB_view_tx + GameImpl.CDB_TW + GameImpl.CDB_TW - _CDB_orig_tx);
                        }
                        _CDB_orig_tx = n;
                    } else {
                        Level.CDB_InvalidateTilesV(_CDB_orig_tx, n2, _CDB_view_tx + GameImpl.CDB_TW);
                        _CDB_orig_tx += n2;
                    }
                    _CDB_view_tx += n2;
                }
            }
        }
        if (!_bResetCDB) {
            n3 = _nCamY - _CDB_view_ty * 64;
            if (n3 < 0) {
                n2 = (63 - n3) / 64;
                if (n2 >= GameImpl.CDB_TH) {
                    _bResetCDB = true;
                } else {
                    _CDB_view_ty -= n2;
                    if ((_CDB_orig_ty -= n2) < 0) {
                        n = n2 + _CDB_orig_ty;
                        if (n != 0) {
                            Level.CDB_InvalidateTilesH(0, n, _CDB_view_ty - _CDB_orig_ty);
                        }
                        Level.CDB_InvalidateTilesH(_CDB_orig_ty += GameImpl.CDB_TH, n2 - n, _CDB_view_ty);
                    } else {
                        Level.CDB_InvalidateTilesH(_CDB_orig_ty, n2, _CDB_view_ty);
                    }
                }
            } else if (n3 > GameImpl.CDB_H - GameImpl.SV_H) {
                n2 = (n3 - (GameImpl.CDB_H - GameImpl.SV_H) + 63) / 64;
                if (n2 >= GameImpl.CDB_TH) {
                    _bResetCDB = true;
                } else {
                    n = _CDB_orig_ty + n2 - GameImpl.CDB_TH;
                    if (n >= 0) {
                        Level.CDB_InvalidateTilesH(_CDB_orig_ty, GameImpl.CDB_TH - _CDB_orig_ty, _CDB_view_ty + GameImpl.CDB_TH);
                        if (n != 0) {
                            Level.CDB_InvalidateTilesH(0, n, _CDB_view_ty + GameImpl.CDB_TH + GameImpl.CDB_TH - _CDB_orig_ty);
                        }
                        _CDB_orig_ty = n;
                    } else {
                        Level.CDB_InvalidateTilesH(_CDB_orig_ty, n2, _CDB_view_ty + GameImpl.CDB_TH);
                        _CDB_orig_ty += n2;
                    }
                    _CDB_view_ty += n2;
                }
            }
        }
        if (_bResetCDB) {
            _bResetCDB = false;
            _CDB_view_tx = _nCamX / 64;
            if (_CDB_view_tx > _level_tw - GameImpl.CDB_TW) {
                _CDB_view_tx = _level_tw - GameImpl.CDB_TW;
            }
            if ((_CDB_view_ty = _nCamY / 64) > _level_th - GameImpl.CDB_TH) {
                _CDB_view_ty = _level_th - GameImpl.CDB_TH;
            }
            _CDB_orig_tx = 0;
            _CDB_orig_ty = 0;
            Level.CDB_InvalidateTiles(0, 0, GameImpl.CDB_TW, GameImpl.CDB_TH, _CDB_view_tx, _CDB_view_ty);
        }
    }

    static void CDB_Invalidate(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11 = n / 64;
        int n12 = n2 / 64;
        int n13 = (n + n3 - 1) / 64 + 1;
        int n14 = (n2 + n4 - 1) / 64 + 1;
        if (n11 < _CDB_view_tx) {
            n11 = _CDB_view_tx;
        }
        if (n13 > _CDB_view_tx + GameImpl.CDB_TW) {
            n13 = _CDB_view_tx + GameImpl.CDB_TW;
        }
        if (n13 - n11 <= 0) {
            return;
        }
        if (n12 < _CDB_view_ty) {
            n12 = _CDB_view_ty;
        }
        if (n14 > _CDB_view_ty + GameImpl.CDB_TH) {
            n14 = _CDB_view_ty + GameImpl.CDB_TH;
        }
        if (n14 - n12 <= 0) {
            return;
        }
        int n15 = n11 + _CDB_orig_tx - _CDB_view_tx;
        int n16 = n15 - GameImpl.CDB_TW;
        if (n16 < 0) {
            n16 = 0;
        }
        if ((n10 = GameImpl.CDB_TW - n15) > (n9 = n13 - n11)) {
            n10 = n9;
        }
        if ((n8 = n9 - n10) > n9) {
            n8 = n9;
        }
        n13 = n11 + n9 - n8;
        int n17 = n12 + _CDB_orig_ty - _CDB_view_ty;
        int n18 = n17 - GameImpl.CDB_TH;
        if (n18 < 0) {
            n18 = 0;
        }
        if ((n7 = GameImpl.CDB_TH - n17) > (n6 = n14 - n12)) {
            n7 = n6;
        }
        if ((n5 = n6 - n7) > n6) {
            n5 = n6;
        }
        n14 = n12 + n6 - n5;
        if (n10 > 0) {
            if (n7 > 0) {
                Level.CDB_InvalidateTiles(n15, n17, n10, n7, n11, n12);
            }
            if (n5 > 0) {
                Level.CDB_InvalidateTiles(n15, n18, n10, n5, n11, n14);
            }
        }
        if (n8 > 0) {
            if (n7 > 0) {
                Level.CDB_InvalidateTiles(n16, n17, n8, n7, n13, n12);
            }
            if (n5 > 0) {
                Level.CDB_InvalidateTiles(n16, n18, n8, n5, n13, n14);
            }
        }
    }

    static void CDB_InvalidatePixels(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = n;
        int n6 = n2;
        int n7 = n + n3;
        int n8 = n2 + n4;
        if (bl) {
            if (n5 < _nCamX) {
                n5 = _nCamX;
            }
            if (n7 > _nCamX + GameImpl.SV_W) {
                n7 = _nCamX + GameImpl.SV_W;
            }
            if (n7 - n5 <= 0) {
                return;
            }
            if (n6 < _nCamY) {
                n6 = _nCamY;
            }
            if (n8 > _nCamY + GameImpl.SV_H) {
                n8 = _nCamY + GameImpl.SV_H;
            }
            if (n8 - n6 <= 0) {
                return;
            }
            n3 = n7 - n5;
            n4 = n8 - n6;
            Level.CDB_InvalidateArea(n5 - _nCamX, n6 - _nCamY, n3, n4, n5, n6, bl);
        } else {
            int n9;
            int n10;
            int n11;
            int n12;
            int n13 = _CDB_view_tx * 64;
            int n14 = _CDB_view_ty * 64;
            int n15 = _CDB_orig_tx * 64;
            int n16 = _CDB_orig_ty * 64;
            int n17 = GameImpl.CDB_W;
            int n18 = GameImpl.CDB_H;
            if (n5 < n13) {
                n5 = n13;
            }
            if (n7 > n13 + n17) {
                n7 = n13 + n17;
            }
            if (n7 - n5 <= 0) {
                return;
            }
            if (n6 < n14) {
                n6 = n14;
            }
            if (n8 > n14 + n18) {
                n8 = n14 + n18;
            }
            if (n8 - n6 <= 0) {
                return;
            }
            int n19 = n5 + n15 - n13;
            int n20 = n19 - n17;
            if (n20 < 0) {
                n20 = 0;
            }
            if ((n12 = n17 - n19) > (n3 = n7 - n5)) {
                n12 = n3;
            }
            if ((n11 = n3 - n12) > n3) {
                n11 = n3;
            }
            n7 = n5 + n3 - n11;
            int n21 = n6 + n16 - n14;
            int n22 = n21 - n18;
            if (n22 < 0) {
                n22 = 0;
            }
            if ((n10 = n18 - n21) > (n4 = n8 - n6)) {
                n10 = n4;
            }
            if ((n9 = n4 - n10) > n4) {
                n9 = n4;
            }
            n8 = n6 + n4 - n9;
            if (n12 > 0) {
                if (n10 > 0) {
                    Level.CDB_InvalidateArea(n19, n21, n12, n10, n5, n6, bl);
                }
                if (n9 > 0) {
                    Level.CDB_InvalidateArea(n19, n22, n12, n9, n5, n8, bl);
                }
            }
            if (n11 > 0) {
                if (n10 > 0) {
                    Level.CDB_InvalidateArea(n20, n21, n11, n10, n7, n6, bl);
                }
                if (n9 > 0) {
                    Level.CDB_InvalidateArea(n20, n22, n11, n9, n7, n8, bl);
                }
            }
        }
    }

    private static void CDB_InvalidateTilesV(int n, int n2, int n3) {
        if (_CDB_orig_ty > 0) {
            Level.CDB_InvalidateTiles(n, 0, n2, _CDB_orig_ty, n3, _CDB_view_ty + GameImpl.CDB_TH - _CDB_orig_ty);
            Level.CDB_InvalidateTiles(n, _CDB_orig_ty, n2, GameImpl.CDB_TH - _CDB_orig_ty, n3, _CDB_view_ty);
        } else {
            Level.CDB_InvalidateTiles(n, 0, n2, GameImpl.CDB_TH, n3, _CDB_view_ty);
        }
    }

    private static void CDB_InvalidateTilesH(int n, int n2, int n3) {
        if (_CDB_orig_tx > 0) {
            Level.CDB_InvalidateTiles(0, n, _CDB_orig_tx, n2, _CDB_view_tx + GameImpl.CDB_TW - _CDB_orig_tx, n3);
            Level.CDB_InvalidateTiles(_CDB_orig_tx, n, GameImpl.CDB_TW - _CDB_orig_tx, n2, _CDB_view_tx, n3);
        } else {
            Level.CDB_InvalidateTiles(0, n, GameImpl.CDB_TW, n2, _CDB_view_tx, n3);
        }
    }

    private static void CDB_InvalidateTiles(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = n * 64;
        int n8 = n2 * 64;
        int n9 = n3 * 64;
        int n10 = n4 * 64;
        int n11 = n5 * 64;
        int n12 = n6 * 64;
        GameImpl._gBB.setClip(n7, n8, n9, n10);
        XSprite.SetGraphics(GameImpl._gBB);
        if (n3 == 1) {
            int n13 = n8 + n10;
            int n14 = n5 + n6 * _level_tw;
            int n15 = n8;
            while (n15 < n13) {
                Level.CDB_DrawTile(n14, n7, n15);
                n15 += 64;
                n14 += _level_tw;
            }
        } else if (n4 == 1) {
            int n16 = n7 + n9;
            int n17 = n5 + n6 * _level_tw;
            int n18 = n7;
            while (n18 < n16) {
                Level.CDB_DrawTile(n17, n18, n8);
                n18 += 64;
                ++n17;
            }
        } else {
            int n19 = n7 + n9;
            int n20 = n8 + n10;
            int n21 = n5 + n6 * _level_tw;
            int n22 = n8;
            while (n22 < n20) {
                int n23 = n21;
                int n24 = n7;
                while (n24 < n19) {
                    Level.CDB_DrawTile(n23, n24, n22);
                    n24 += 64;
                    ++n23;
                }
                n22 += 64;
                n21 += _level_tw;
            }
        }
        Level.CDB_DrawBackgroundEntities(n7, n8, n9, n10, n11, n12);
    }

    private static void CDB_InvalidateArea(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7;
        int n8;
        int n9 = n3;
        int n10 = n4;
        if (n9 * n10 > 81920) {
            if (n3 > n4) {
                Level.CDB_InvalidateArea(n, n2, n3 >> 1, n4, n5, n6, bl);
                Level.CDB_InvalidateArea(n + (n3 >> 1), n2, n3 - (n3 >> 1), n4, n5 + (n3 >> 1), n6, bl);
            } else {
                Level.CDB_InvalidateArea(n, n2, n3, n4 >> 1, n5, n6, bl);
                Level.CDB_InvalidateArea(n, n2 + (n4 >> 1), n3, n4 - (n4 >> 1), n5, n6 + (n4 >> 1), bl);
            }
            return;
        }
        int n11 = n;
        int n12 = n2;
        XSprite._op = 0;
        XSprite.SetGraphics(GameImpl._gBB);
        int n13 = n5 / 64;
        int n14 = n6 / 64;
        int n15 = n13 + n14 * _level_tw;
        int n16 = n13 * 64 - n5;
        int n17 = n8 = n14 * 64 - n6;
        while (n17 < n10) {
            n7 = n15;
            int n18 = n16;
            while (n18 < n9) {
                Level.CDB_DrawTile(n7, n18, n17);
                n18 += 64;
                ++n7;
            }
            n17 += 64;
            n15 += _level_tw;
        }
        n17 = _nCamX;
        n7 = _nCamY;
        _nCamX = n5;
        _nCamY = n6;
        _nCamX = n17;
        _nCamY = n7;
        XSprite._op = 0;
    }

    private static void CDB_DrawBackgroundEntities(int n, int n2, int n3, int n4, int n5, int n6) {
    }

    static void CDB_Draw(SDKGraphics sDKGraphics) {
        int n = _nCamX - (_CDB_view_tx - _CDB_orig_tx) * 64;
        int n2 = _nCamY - (_CDB_view_ty - _CDB_orig_ty) * 64;
        int n3 = GameImpl.SV_X - n;
        int n4 = GameImpl.SV_Y - n2;
        int n5 = GameImpl.SV_X + GameImpl.SV_W - GameImpl.CDB_W - n3;
        if (n5 > 0) {
            int n6 = GameImpl.CDB_W - GameImpl.SV_X + n3;
            int n7 = n3 + GameImpl.CDB_W;
            int n8 = GameImpl.SV_Y + GameImpl.SV_H - GameImpl.CDB_H - n4;
            if (n8 > 0) {
                int n9 = GameImpl.CDB_H - GameImpl.SV_Y + n4;
                int n10 = n4 + GameImpl.CDB_H;
                sDKGraphics.setClip(GameImpl.SV_X, GameImpl.SV_Y, n6, n9);
                sDKGraphics.drawImage(GameImpl._imgBB, n3, n4, 0);
                sDKGraphics.setClip(GameImpl.SV_X, n10, n6, n8);
                sDKGraphics.drawImage(GameImpl._imgBB, n3, n10, 0);
                sDKGraphics.setClip(n7, GameImpl.SV_Y, n5, GameImpl.SV_H);
                sDKGraphics.drawImage(GameImpl._imgBB, n7, n4, 0);
                sDKGraphics.setClip(n7, n10, n5, n8);
                sDKGraphics.drawImage(GameImpl._imgBB, n7, n10, 0);
            } else {
                sDKGraphics.setClip(GameImpl.SV_X, GameImpl.SV_Y, n6, GameImpl.SV_H);
                sDKGraphics.drawImage(GameImpl._imgBB, n3, n4, 0);
                sDKGraphics.setClip(n7, GameImpl.SV_Y, n5, GameImpl.SV_H);
                sDKGraphics.drawImage(GameImpl._imgBB, n7, n4, 0);
            }
        } else {
            int n11 = GameImpl.SV_Y + GameImpl.SV_H - GameImpl.CDB_H - n4;
            if (n11 > 0) {
                int n12 = GameImpl.CDB_H - GameImpl.SV_Y + n4;
                int n13 = n4 + GameImpl.CDB_H;
                sDKGraphics.setClip(GameImpl.SV_X, GameImpl.SV_Y, GameImpl.SV_W, n12);
                sDKGraphics.drawImage(GameImpl._imgBB, n3, n4, 0);
                sDKGraphics.setClip(GameImpl.SV_X, n13, GameImpl.SV_W, n11);
                sDKGraphics.drawImage(GameImpl._imgBB, n3, n13, 0);
            } else {
                sDKGraphics.setClip(GameImpl.SV_X, GameImpl.SV_Y, GameImpl.SV_W, GameImpl.SV_H);
                sDKGraphics.drawImage(GameImpl._imgBB, n3, n4, 0);
            }
        }
        sDKGraphics.setClip(GameImpl.SV_X, GameImpl.SV_Y, GameImpl.SV_W, GameImpl.SV_H);
    }

    private static void CDB_DrawTile(int n, int n2, int n3) {
        if (n < 0) {
            return;
        }
        int n4 = n % _level_tw * 64;
        int n5 = n / _level_tw * 64;
        GameImpl._gBB.setClip(n2, n3, 64, 64);
        XSprite.SetGraphics(GameImpl._gBB);
        int n6 = n % _level_tw % 4 * 64;
        int n7 = n / _level_tw % 6 * 64;
        if (n5 >= 512) {
            GameImpl._gBB.setColor(Level.CDB_GetBackgroundColor(false));
            GameImpl._gBB.fillRect(n2, n3, 64, 64);
        } else if (n5 >= 384) {
            GameImpl._sprites[_backgroundSprite].DrawFrame(0, n2 - n6, n3 - n7, 0);
        } else {
            GameImpl._gBB.setColor(Level.CDB_GetBackgroundColor(true));
            GameImpl._gBB.fillRect(n2, n3, 64, 64);
        }
        int n8 = Level.GetTilesetModule(n);
        if (n8 >= 0 && n8 < GameImpl._sprites[Level._currentTileSetSprite]._modules) {
            if ((_tiles_flags[n] & 8) != 0) {
                XSprite._op = 0;
                GameImpl._sprites[_currentTileSetSprite].DrawFrame(n8, n2, n3, 0);
            } else if ((_tiles_flags[n] & 0x10) != 0) {
                GameImpl._gBB.drawRGB(Level.CacheTile(n), 0, 64, n2, n3, 64, 64, true);
            }
        }
    }

    private static int CDB_GetBackgroundColor(boolean bl) {
        if (_backgroundSprite == 48) {
            return bl ? 16233761 : 5466672;
        }
        if (_backgroundSprite == 49) {
            return bl ? 1057072 : 9743419;
        }
        if (_backgroundSprite == 50) {
            return bl ? 0x111918 : 11902210;
        }
        if (_backgroundSprite == 51) {
            return bl ? 42470 : 12759605;
        }
        return bl ? 14397077 : 7568331;
    }

    public static void _CDB_init(int n, int n2) {
        _CDB_separator = -1;
        _CDB_x = n;
        _CDB_y = n2;
        _CDB_xo = 0;
        _CDB_yo = 0;
        _CDB_oldX = n;
        _CDB_oldY = n2;
        _CDB_nrRegions = 0;
        Level._CDB_addRegion(n, n2, _CDB_xo, _CDB_yo, _CDB_w, _CDB_h);
    }

    public static void _CDB_moveX(int n) {
        int n2 = _CDB_xo;
        if ((_CDB_xo += n) >= _CDB_w) {
            Level._CDB_findXRegion(_CDB_x + _CDB_w, n2, _CDB_w - n2);
            Level._CDB_findXRegion(_CDB_x + _CDB_w + (_CDB_w - n2), 0, _CDB_xo -= _CDB_w);
            return;
        }
        if (_CDB_xo < 0) {
            Level._CDB_findXRegion(_CDB_x + n, _CDB_xo += _CDB_w, _CDB_w - _CDB_xo);
            Level._CDB_findXRegion(_CDB_x + n + _CDB_w - _CDB_xo, 0, n2);
            return;
        }
        if (n > 0) {
            Level._CDB_findXRegion(_CDB_x + _CDB_w, n2, n);
        } else {
            Level._CDB_findXRegion(_CDB_x + n, n2 + n, -n);
        }
    }

    public static void _CDB_findXRegion(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        Level._CDB_addRegion(n, _CDB_y, n2, _CDB_yo, n3, _CDB_h - _CDB_yo);
        if (_CDB_yo != 0) {
            Level._CDB_addRegion(n, _CDB_y + (_CDB_h - _CDB_yo), n2, 0, n3, _CDB_yo);
        }
    }

    public static void _CDB_moveY(int n) {
        int n2 = _CDB_yo;
        if ((_CDB_yo += n) >= _CDB_h) {
            Level._CDB_findYRegion(_CDB_y + _CDB_h, n2, _CDB_h - n2);
            Level._CDB_findYRegion(_CDB_y + _CDB_h + (_CDB_h - n2), 0, _CDB_yo -= _CDB_h);
            return;
        }
        if (_CDB_yo < 0) {
            Level._CDB_findYRegion(_CDB_y + n, _CDB_yo += _CDB_h, _CDB_h - _CDB_yo);
            Level._CDB_findYRegion(_CDB_y + n + _CDB_h - _CDB_yo, 0, n2);
            return;
        }
        if (n > 0) {
            Level._CDB_findYRegion(_CDB_y + _CDB_h, n2, n);
        } else {
            Level._CDB_findYRegion(_CDB_y + n, n2 + n, -n);
        }
    }

    public static void _CDB_findYRegion(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        Level._CDB_addRegion(_CDB_x, n, _CDB_xo, n2, _CDB_w - _CDB_xo, n3);
        if (_CDB_xo != 0) {
            Level._CDB_addRegion(_CDB_x + (_CDB_w - _CDB_xo), n, 0, n2, _CDB_xo, n3);
        }
    }

    public static void _CDB_addRegion(int n, int n2, int n3, int n4, int n5, int n6) {
        Region region = new Region();
        region.x = (short)n;
        region.y = (short)n2;
        region.xo = (short)n3;
        region.yo = (short)n4;
        region.w = (short)n5;
        region.h = (short)n6;
        Level._CDB_regions[Level._CDB_nrRegions++] = region;
    }

    public static void _CDB_update(int n, int n2) {
        int n3;
        _CDB_separator = 0;
        if (_bResetCDB) {
            Level._CDB_init(n, n2);
            _bResetCDB = false;
            return;
        }
        _CDB_nrRegions = 0;
        int n4 = n - _CDB_oldX;
        if (n4 <= -_CDB_w || n4 >= _CDB_w) {
            Level._CDB_init(n, n2);
            return;
        }
        if (n4 != 0) {
            Level._CDB_moveX(n4);
        }
        _CDB_x = n;
        _CDB_oldX = n;
        if (_CDB_separator != -1) {
            _CDB_separator = _CDB_nrRegions;
        }
        if ((n3 = n2 - _CDB_oldY) <= -_CDB_h || n3 >= _CDB_h) {
            Level._CDB_init(n, n2);
            return;
        }
        if (n3 != 0) {
            Level._CDB_moveY(n3);
        }
        _CDB_y = n2;
        _CDB_oldY = n2;
    }

    public static void _CDB_blitToScreen(SDKGraphics sDKGraphics) {
        if (_CDB_w - _CDB_xo != 0) {
            if (_CDB_h - _CDB_yo != 0) {
                sDKGraphics.drawRegion(GameImpl._imgBB, _CDB_xo, _CDB_yo, _CDB_w - _CDB_xo, _CDB_h - _CDB_yo, 0, GameImpl.SV_X, GameImpl.SV_Y, 20);
            }
            if (_CDB_yo != 0) {
                sDKGraphics.drawRegion(GameImpl._imgBB, _CDB_xo, 0, _CDB_w - _CDB_xo, _CDB_yo, 0, GameImpl.SV_X, _CDB_h - _CDB_yo + GameImpl.SV_Y, 20);
            }
        }
        if (_CDB_xo != 0) {
            if (_CDB_h - _CDB_yo != 0) {
                sDKGraphics.drawRegion(GameImpl._imgBB, 0, _CDB_yo, _CDB_xo, _CDB_h - _CDB_yo, 0, _CDB_w - _CDB_xo + GameImpl.SV_X, GameImpl.SV_Y, 20);
            }
            if (_CDB_yo != 0) {
                sDKGraphics.drawRegion(GameImpl._imgBB, 0, 0, _CDB_xo, _CDB_yo, 0, _CDB_w - _CDB_xo + GameImpl.SV_X, _CDB_h - _CDB_yo + GameImpl.SV_Y, 20);
            }
        }
    }

    static int[] BSpline(int n, int n2) {
        int[] nArray = new int[4];
        int n3 = (int)((long)n * (long)n >> 16);
        int n4 = (int)((long)n * (long)n3 >> 16);
        nArray[0] = -n4 + 3 * n3 - 3 * n + 65536;
        nArray[1] = 3 * n4 - 6 * n3 + 262144;
        nArray[2] = -3 * n4 + 3 * n3 + 3 * n + 65536;
        nArray[3] = n4;
        int[] nArray2 = new int[2];
        for (int i = 0; i < 2; ++i) {
            nArray2[i] = ((int)((long)nArray[0] * (long)_aPoints[n2][i] >> 16) + (int)((long)nArray[1] * (long)_aPoints[n2 + 1][i] >> 16) + (int)((long)nArray[2] * (long)_aPoints[n2 + 2][i] >> 16) + (int)((long)nArray[3] * (long)_aPoints[n2 + 3][i] >> 16)) / 6;
        }
        nArray = null;
        return nArray2;
    }

    static void SpawnAISensors(int n) {
        int n2 = 0;
        int n3 = 0;
        n2 = 0xC00000;
        n3 = 0xC00000;
        _nAISensorEntities = _nPoints;
        for (int i = 0; i < _nPoints; ++i) {
            Entity entity = Level.SpawnEntity(200);
            entity.UpdateBoundingBox();
            if (i == 0) {
                _nFirstAISensorIndex = entity._id;
            }
            entity._sdata = new short[20];
            entity._idata = new int[20];
            entity._bdata = new byte[10];
            entity._pos_x = _aPoints[i][0] + n2;
            entity._pos_y = _aPoints[i][1] + n3;
        }
        Entity2.makeSensorAdjustments(1);
    }

    static void TraceBSpline() {
        int n = 0;
        int n2 = 0;
        int[] nArray = null;
        boolean bl = true;
        for (int i = 0; i < _nPoints - 4; ++i) {
            for (int j = 0; j < 65536; j += 13107) {
                if (bl) {
                    bl = false;
                    nArray = Level.BSpline(j, i);
                } else {
                    nArray = Level.BSpline(j, i);
                    Level.LandPlot(n >> 8, n2 >> 8, nArray[0] >> 8, nArray[1] >> 8);
                }
                n = nArray[0];
                n2 = nArray[1];
                nArray = null;
            }
        }
        nArray = null;
    }

    static void FloodOutline(int n) {
        boolean bl = false;
        byte by = 0;
        int n2 = 1;
        byte by2 = 0;
        byte by3 = 0;
        boolean bl2 = false;
        for (int i = n * 64; i < (n + 1) * 64; i += n2) {
            byte by4 = by;
            by2 = by;
            for (int j = 0; j < _nLandHeight; ++j) {
                if ((by4 = (byte)((byte)(by4 ^ Level.GetLandscapeCollision(i, j)))) != 0) {
                    by3 = by4;
                    Level.SetLandscapeCollision(i, j, by3);
                }
                by2 = by4;
            }
        }
    }

    static void LandPlot(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        if (n > n3) {
            int n7 = n;
            n = n3;
            n3 = n7;
            n7 = n2;
            n2 = n4;
            n4 = n7;
        }
        if ((n = (n6 = n) + 128 - 1 >> 8) == (n3 = (n5 = n3) + 128 - 1 >> 8)) {
            return;
        }
        int n8 = n5 - n6;
        int n9 = ((n4 <<= 8) - (n2 <<= 8)) / n8;
        int n10 = (n << 8) + 128 - n6;
        n2 += n9 * n10;
        n10 = (n3 << 8) + 128 - n5;
        n4 += n9 * n10;
        n8 = n3 - n;
        n9 = n4 - n2;
        n8 = n3 - n;
        n9 = (n4 - (n2 += 32768)) / n8;
        while (n8-- > 0) {
            Level.LandFlip(n++, n2 >> 16);
            n2 += n9;
        }
    }

    static void LandFlip(int n, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        Level.SetLandscapeCollision(n, n2, (byte)(Level.GetLandscapeCollision(n, n2) ^ 1));
    }

    static void SetSeed(int n) {
        _nSeed = n;
    }

    static int IRandom() {
        int n;
        int n2 = _nSeed;
        int n3 = n2 * 1664525;
        _nSeed = n = n3 + 1013904223;
        return _nSeed;
    }

    static int IRandom(int n, int n2) {
        return n + Math.abs(Level.IRandom()) % (n2 - n);
    }

    static void GenerateLandscape(int n, int n2) {
        int n3 = n & 0xFFFF;
        _nGran0 = n3 % 101;
        _nGran1 = n3 / 101 % 101;
        _nSeed = n;
        _nStyle = n2;
        _nGran0 = (_nGran0 << 16) / 50 + 32768;
        _nGran1 = (_nGran1 << 16) / 50 + 32768;
        _nXScl = 65536 + (Level.IRandom() & 0xFFFF);
        _nYScl = 65536 + (Level.IRandom() & 0xFFFF) / 2;
        Level.GenerateOutline(_nStyle);
    }

    static void GenerateOutline(int n) {
        Level.InitLevelMarkPoints(n);
        if (n == 1) {
            Level.LineSub(n, Constants.SINGLE_LANDMASS_MAX_HEIGHT);
        } else {
            Level.LineSub(n, 64);
        }
    }

    static void InitLevelMarkPoints(int n) {
        switch (n) {
            case 0: {
                _nLevelMarkPoints = 4;
                Level._aLevelMarkPoints[0][0] = 1 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[0][1] = 16 * _nLandHeight / 16 - 1 << 16;
                Level._aLevelMarkPoints[1][0] = 2 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[1][1] = 6 * _nLandHeight / 16 << 16;
                Level._aLevelMarkPoints[2][0] = 14 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[2][1] = 6 * _nLandHeight / 16 << 16;
                Level._aLevelMarkPoints[3][0] = 15 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[3][1] = 16 * _nLandHeight / 16 - 1 << 16;
                break;
            }
            case 3: {
                _nLevelMarkPoints = 8;
                Level._aLevelMarkPoints[0][0] = 1 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[0][1] = 16 * _nLandHeight / 16 - 1 << 16;
                Level._aLevelMarkPoints[1][0] = 2 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[1][1] = 6 * _nLandHeight / 16 << 16;
                Level._aLevelMarkPoints[2][0] = 5 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[2][1] = 6 * _nLandHeight / 16 << 16;
                Level._aLevelMarkPoints[3][0] = 6 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[3][1] = 16 * _nLandHeight / 16 << 16;
                Level._aLevelMarkPoints[4][0] = 10 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[4][1] = 16 * _nLandHeight / 16 << 16;
                Level._aLevelMarkPoints[5][0] = 11 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[5][1] = 6 * _nLandHeight / 16 << 16;
                Level._aLevelMarkPoints[6][0] = 14 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[6][1] = 6 * _nLandHeight / 16 << 16;
                Level._aLevelMarkPoints[7][0] = 15 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[7][1] = 16 * _nLandHeight / 16 - 1 << 16;
                break;
            }
            case 1: {
                _nLevelMarkPoints = 4;
                Level._aLevelMarkPoints[0][0] = 1 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[0][1] = 16 * _nLandHeight / 16 - 1 << 16;
                Level._aLevelMarkPoints[1][0] = 2 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[1][1] = 12 * _nLandHeight / 16 << 16;
                Level._aLevelMarkPoints[2][0] = 14 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[2][1] = 12 * _nLandHeight / 16 << 16;
                Level._aLevelMarkPoints[3][0] = 15 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[3][1] = 16 * _nLandHeight / 16 - 1 << 16;
                break;
            }
            case 2: {
                _nLevelMarkPoints = 5;
                Level._aLevelMarkPoints[0][0] = 1 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[0][1] = 16 * _nLandHeight / 16 - 1 << 16;
                Level._aLevelMarkPoints[1][0] = 2 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[1][1] = 4 * _nLandHeight / 16 << 16;
                Level._aLevelMarkPoints[2][0] = 8 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[2][1] = 16 * _nLandHeight / 16 - 1 << 16;
                Level._aLevelMarkPoints[3][0] = 14 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[3][1] = 4 * _nLandHeight / 16 - 1 << 16;
                Level._aLevelMarkPoints[4][0] = 15 * _nLandWidth / 16 << 16;
                Level._aLevelMarkPoints[4][1] = 16 * _nLandHeight / 16 - 1 << 16;
            }
        }
    }

    static void LineSub(int n, int n2) {
        int n3;
        _nPoints = 0;
        for (n3 = 0; n3 < 3; ++n3) {
            Level._aPoints[Level._nPoints][0] = _aLevelMarkPoints[0][0];
            Level._aPoints[Level._nPoints][1] = _aLevelMarkPoints[0][1];
            ++_nPoints;
        }
        int n4 = 0;
        n3 = 1;
        while (n3 < _nLevelMarkPoints) {
            Level.LineTest(_aLevelMarkPoints[n4][0], _aLevelMarkPoints[n4][1], _aLevelMarkPoints[n3][0], _aLevelMarkPoints[n3][1], true, 1);
            n4 = n3++;
        }
        n4 = 0;
        n3 = 1;
        while (n3 < _nLevelMarkPoints) {
            Level.LineSub(_aLevelMarkPoints[n4][0], _aLevelMarkPoints[n4][1], _aLevelMarkPoints[n3][0], _aLevelMarkPoints[n3][1], n2, Level.IRandom(), n);
            n4 = n3++;
        }
        for (n3 = 0; n3 < 4; ++n3) {
            Level._aPoints[Level._nPoints][0] = _aLevelMarkPoints[_nLevelMarkPoints - 1][0];
            Level._aPoints[Level._nPoints][1] = _aLevelMarkPoints[_nLevelMarkPoints - 1][1];
            ++_nPoints;
        }
        Level.ClearLandscapeCollisions();
        Level.TraceBSpline();
    }

    static int LineTestLengthBefHeight(int n, int n2, int n3, int n4, boolean bl, int n5) {
        int n6 = 0;
        int n7 = n;
        int n8 = n3;
        if ((n = n7 + 128 - 1 >> 8) == (n3 = n8 + 128 - 1 >> 8)) {
            return 0;
        }
        int n9 = n8 - n7;
        int n10 = ((n4 <<= 8) - (n2 <<= 8)) / n9;
        int n11 = (n << 8) + 128 - n7;
        n2 += n10 * n11;
        n11 = (n3 << 8) + 128 - n8;
        n4 += n10 * n11;
        n9 = n3 - n;
        n10 = n4 - n2;
        int n12 = Math.abs(n9);
        int n13 = n9 < 0 ? -1 : 1;
        n2 += 32768;
        n10 /= n12;
        if (bl) {
            while (n12-- > 0) {
                Level.SetLandscapeCollision(n, n2 >> 16, (byte)n5);
                n += n13;
                n2 += n10;
            }
            return 0;
        }
        int n14 = 0;
        while (n12-- > 0) {
            int n15 = n14;
            int n16 = n2 >> 16;
            n14 += Level.GetLandscapeCollision(n, n16);
            if ((n2 += n10) >> 16 != n16) {
                n14 += Level.GetLandscapeCollision(n, n2 >> 16);
            }
            if (n14 != n15) {
                _colX = n << 16;
                _colY = n2;
                if (++n6 == 1) {
                    detX = _colX;
                    detY = _colY;
                }
                n15 = n14;
            }
            n += n13;
        }
        return n14;
    }

    static int LineTestHeightBefLength(int n, int n2, int n3, int n4, boolean bl, int n5) {
        int n6 = 0;
        int n7 = n2;
        int n8 = n4;
        if ((n2 = n7 + 128 - 1 >> 8) == (n4 = n8 + 128 - 1 >> 8)) {
            return 0;
        }
        int n9 = n8 - n7;
        int n10 = ((n3 <<= 8) - (n <<= 8)) / n9;
        int n11 = (n2 << 8) + 128 - n7;
        n += n10 * n11;
        n11 = (n4 << 8) + 128 - n8;
        n3 += n10 * n11;
        n10 = n3 - n;
        n9 = n4 - n2;
        int n12 = Math.abs(n9);
        int n13 = n9 < 0 ? -1 : 1;
        n += 32768;
        n10 /= n12;
        if (bl) {
            while (n12-- > 0) {
                Level.SetLandscapeCollision(n >> 16, n2, (byte)n5);
                n2 += n13;
                n += n10;
            }
            return 0;
        }
        int n14 = 0;
        while (n12-- > 0) {
            int n15 = n14;
            int n16 = n >> 16;
            n14 += Level.GetLandscapeCollision(n16, n2);
            if ((n += n10) >> 16 != n16) {
                n14 += Level.GetLandscapeCollision(n >> 16, n2);
            }
            if (n14 != n15) {
                _colX = n;
                _colY = n2 << 16;
                if (++n6 == 1) {
                    detX = _colX;
                    detY = _colY;
                }
                n15 = n14;
            }
            n2 += n13;
        }
        return n14;
    }

    static int LineTest(int n, int n2, int n3, int n4, boolean bl, int n5) {
        int n6 = Math.abs((n3 >>= 8) - (n >>= 8)) >= Math.abs((n4 >>= 8) - (n2 >>= 8)) ? Level.LineTestLengthBefHeight(n, n2, n3, n4, bl, n5) : Level.LineTestHeightBefLength(n, n2, n3, n4, bl, n5);
        return n6;
    }

    static void LineSub(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        GameImpl._vector[0] = n3 - n;
        GameImpl._vector[1] = n4 - n2;
        int n8 = GameImpl.Normalize(GameImpl._vector);
        if (n8 >> 16 >= n5) {
            Level.LineTest(n, n2, n3, n4, true, 0);
            int n9 = n + n3 >> 1;
            int n10 = n2 + n4 >> 1;
            if (n9 >> 16 >= 16 && n10 >> 16 >= 16 && n9 >> 16 < _nLandWidth - 16 && n10 >> 16 < _nLandHeight - 16) {
                int n11 = GameImpl.Clamp(n8 / _nLandWidth, 0, 65536);
                int n12 = _nGran0 + (int)((long)(_nGran1 - _nGran0) * (long)n11 >> 16);
                int n13 = (int)((long)n12 * (long)n8 >> 16);
                int n14 = GameImpl._vector[0];
                int n15 = GameImpl._vector[1];
                int n16 = (int)((long)((n6 & 0xFFFF) - 32768) * (long)n13 >> 16);
                n9 = (n + n3 >> 1) - (int)((long)((int)((long)n15 * (long)n16 >> 16)) * (long)_nXScl >> 16);
                n10 = (n2 + n4 >> 1) + (int)((long)((int)((long)n14 * (long)n16 >> 16)) * (long)_nYScl >> 16);
                if (n9 >> 16 < 16 || n10 >> 16 < 16 || n9 >> 16 >= _nLandWidth - 16 || n10 >> 16 >= _nLandHeight - 16 || Level.LineTest(n, n2, n9, n10, false, 0) != 0 || Level.LineTest(n9, n10, n3, n4, false, 0) != 0) {
                    n9 = n + n3 >> 1;
                    n10 = n2 + n4 >> 1;
                }
            }
            Level.LineTest(n, n2, n9, n10, true, 1);
            Level.LineTest(n9, n10, n3, n4, true, 1);
            Level.LineSub(n, n2, n9, n10, n5, (int)((long)(n6 * 1664525) + 1013904223L), n7);
            Level.LineSub(n9, n10, n3, n4, n5, (int)((long)(n6 * 1164525) + 1013904223L + 2000000000L), n7);
        } else {
            Level._aPoints[Level._nPoints][0] = n;
            Level._aPoints[Level._nPoints][1] = n7 == 1 ? (n2 >> 16 < Constants.SINGLE_LANDMASS_LOW_HEIGHT ? n2 + (Constants.SINGLE_LANDMASS_MAX_HEIGHT << 16) : (n2 >> 16 < Constants.SINGLE_LANDMASS_MAX_HEIGHT && n2 >> 16 >= Constants.SINGLE_LANDMASS_LOW_HEIGHT ? n2 + (Constants.SINGLE_LANDMASS_MID_HEIGHT << 16) : n2)) : n2;
            ++_nPoints;
        }
    }

    static int clampRadius(int n) {
        if (n <= 8) {
            return 8;
        }
        if (n <= 16) {
            return 16;
        }
        if (n <= 32) {
            return 32;
        }
        if (n <= 48) {
            return 48;
        }
        return 60;
    }

    static void GenerateWhole(int n, int n2, int n3) {
        if (_isTerrainIndestructible) {
            return;
        }
        int n4 = Level.clampRadius(n3);
        switch (n4) {
            case 0: {
                break;
            }
            case 8: {
                Level.MaskAndReplace(pMaskSmaller, n - n4, n2 - n4, n4 << 1, n4 << 1);
                break;
            }
            case 16: {
                Level.MaskAndReplace(pMaskSmall, n - n4, n2 - n4, n4 << 1, n4 << 1);
                break;
            }
            case 32: {
                Level.MaskAndReplace(pMaskMed, n - n4, n2 - n4, n4 << 1, n4 << 1);
                break;
            }
            case 48: {
                Level.MaskAndReplace(pMaskBig, n - n4, n2 - n4, n4 << 1, n4 << 1);
                break;
            }
            default: {
                Level.MaskAndReplace(pMaskBiggest, n - n4, n2 - n4, n4 << 1, n4 << 1);
            }
        }
        Level.UpdateWormEntitiesGroundCollisions();
    }

    static void GenerateCircleMask(byte[] byArray, int n) {
        GameImpl.MemSet(byArray, (byte)-1);
        int n2 = 1 - n;
        int n3 = 1;
        int n4 = -2 * n;
        int n5 = 0;
        int n6 = n;
        int n7 = n;
        int n8 = n;
        int n9 = 2 * n + 1;
        int n10 = 1 + (n9 >> 3);
        int n11 = n7;
        int n12 = (n11 >> 3) + (n8 + n) * n10;
        byArray[n12] = (byte)(byArray[n12] & ~(1 << n11 % 8));
        n11 = n7;
        int n13 = (n11 >> 3) + (n8 - n) * n10;
        byArray[n13] = (byte)(byArray[n13] & ~(1 << n11 % 8));
        n11 = n7 + n;
        int n14 = (n11 >> 3) + n8 * n10;
        byArray[n14] = (byte)(byArray[n14] & ~(1 << n11 % 8));
        n11 = n7 - n;
        int n15 = (n11 >> 3) + n8 * n10;
        byArray[n15] = (byte)(byArray[n15] & ~(1 << n11 % 8));
        int n16 = n8 * n9;
        for (n11 = n7 - n; n11 <= n7 + n; ++n11) {
            int n17 = (n11 >> 3) + n8 * n10;
            byArray[n17] = (byte)(byArray[n17] & ~(1 << n11 % 8));
        }
        while (n5 < n6) {
            if (n2 >= 0) {
                --n6;
                n2 += (n4 += 2);
            }
            n2 += (n3 += 2);
            n16 = (n8 + n6) * n9;
            for (n11 = n7 - ++n5; n11 <= n7 + n5; ++n11) {
                int n18 = (n11 >> 3) + (n8 + n6) * n10;
                byArray[n18] = (byte)(byArray[n18] & ~(1 << n11 % 8));
            }
            n16 = (n8 - n6) * n9;
            for (n11 = n7 - n5; n11 <= n7 + n5; ++n11) {
                int n19 = (n11 >> 3) + (n8 - n6) * n10;
                byArray[n19] = (byte)(byArray[n19] & ~(1 << n11 % 8));
            }
            n16 = (n8 + n5) * n9;
            for (n11 = n7 - n6; n11 <= n7 + n6; ++n11) {
                int n20 = (n11 >> 3) + (n8 + n5) * n10;
                byArray[n20] = (byte)(byArray[n20] & ~(1 << n11 % 8));
            }
            n16 = (n8 - n5) * n9;
            for (n11 = n7 - n6; n11 <= n7 + n6; ++n11) {
                int n21 = (n11 >> 3) + (n8 - n5) * n10;
                byArray[n21] = (byte)(byArray[n21] & ~(1 << n11 % 8));
            }
        }
    }

    static void MaskAndReplace(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        boolean bl = false;
        int n7 = 0;
        int n8 = 0;
        n = n >> 3 << 3;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n9 = 1 + (n3 + 1 >> 3);
        int n10 = _nLandWidth >> 3;
        for (n6 = 0; n6 < n9; ++n6) {
            int n11 = n - _extraPixelsWidth + (n6 << 3) >> 3;
            int n12 = n2 - _extraPixelsHeightTop;
            n5 = 0;
            while (n5 < n4 + 1) {
                if (n11 < n10 && n12 < _nLandHeight && n11 >= 0 && n12 >= 0) {
                    int n13 = n12 * n10 + n11;
                    _aLandscapeColMask[n13] = (byte)(_aLandscapeColMask[n13] & byArray[n6 + n5 * n9]);
                }
                ++n5;
                ++n12;
            }
        }
        n5 = n / 64 * 64;
        int n14 = n2 / 64 * 64;
        for (n7 = n5; n7 < n + n3; n7 += 64) {
            for (n8 = n14; n8 < n2 + n4; n8 += 64) {
                n6 = n7 / 64 + n8 / 64 * _level_tw;
                if (n6 < 0 || n6 >= _level_tw * (_level_th - _extraPixelsHeightBottom / 64)) continue;
                if (_tiles_flags[n6] == 8) {
                    Level._tiles_flags[n6] = 16;
                } else if (_tiles_flags[n6] == 32) continue;
                Level.CDB_Invalidate(n7, n8, 64, 64);
            }
        }
    }

    static void InitEntities() {
        if (_entities == null) {
            _entities = new Entity[250];
            _entities_usage = new byte[250];
            for (int i = 0; i < 250; ++i) {
                Level._entities[i] = new Entity(i);
            }
            _entities_order = new Entity[7][250];
            _lengths_order = new int[7];
        }
        Level.ClearEntities();
    }

    static void ClearEntities() {
        for (int i = 0; i < 250; ++i) {
            if (_entities[i] == null) continue;
            _entities[i].Reset();
            Level._entities_usage[i] = 0;
        }
        _nMaxUsedEntities = 0;
        _entLevel = null;
    }

    static void ReleaseEntities() {
        for (int i = 0; i < 250; ++i) {
            if (_entities[i] == null) continue;
            _entities[i].Free();
            Level._entities[i] = null;
        }
        _entities = null;
        _entLevel = null;
        System.gc();
    }

    static void DrawEntities(SDKGraphics sDKGraphics) {
        Level.DrawEntities(sDKGraphics, true);
    }

    static void DrawEntities(SDKGraphics sDKGraphics, boolean bl) {
        int n;
        XSprite.SetGraphics(sDKGraphics);
        if (bl) {
            Level.CDB_Draw(sDKGraphics);
            Level.CDB_Invalidator_Update();
        }
        if (GameImpl._railgunProjectyle != null && (GameImpl._railgunProjectyle._flags & 0x18) == 0) {
            GameImpl.DrawRailgunLine(sDKGraphics, GameImpl._railgunFrame);
            if (GameImpl._railgunStartFrames >= 12) {
                Entity2.DrawRailgunHead(GameImpl._railgunProjectyle._pos_x, GameImpl._railgunProjectyle._pos_y, GameImpl._railgunProjectyle._velX, GameImpl._railgunProjectyle._velY, GameImpl._railgunAngle);
            }
        }
        for (n = 1; n < 6; ++n) {
            for (int i = 0; i < _lengths_order[n]; ++i) {
                try {
                    _entities_order[n][i].Draw(sDKGraphics);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        for (n = 0; n < _lengths_order[6]; ++n) {
            try {
                _entities_order[6][n].Draw(sDKGraphics);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (GameImpl._pCrtWorm != null && GameImpl._pCrtWorm._nState == 3 && (GameImpl._pCrtWorm._bdata[15] == 1 || GameImpl._pCrtWorm._bdata[15] == 7 || GameImpl._pCrtWorm._bdata[15] == 19 || GameImpl._pCrtWorm._bdata[15] == 25)) {
            n = GameImpl.SV_X + (GameImpl._pCrtWorm._pos_x >> 16) - _nCamX;
            int n2 = GameImpl.SV_Y + (GameImpl._pCrtWorm._pos_y >> 16) - _nCamY + 0;
            GameImpl.DrawFusedWeaponIconAndTimer(sDKGraphics, GameImpl._pCrtWorm._bdata[15], n, n2 + -36);
        }
        if (GameImpl.GetGameState() == 7 || GameImpl.GetGameState() == 18 || GameImpl.GetGameState() == 19) {
            GameImpl.DrawWater(sDKGraphics);
        }
    }

    static void UpdateEntities() {
        for (int i = 0; i < _nMaxUsedEntities; ++i) {
            if (_entities_usage[i] != 1) continue;
            _entities[i].Update();
        }
    }

    static void DrawCDBEntities(SDKGraphics sDKGraphics) {
    }

    static void LoadEntities(int n) {
        try {
            SDKInputStream sDKInputStream = null;
            try {
                sDKInputStream = new SDKInputStream(n);
                while (sDKInputStream.available() > 0) {
                    int n2 = sDKInputStream.read() & 0xFF;
                    if (n2 >= 60 && n2 <= 65) {
                        Trigger trigger = Level.AddTriggerEvent(n2);
                        trigger.LoadTrigger(sDKInputStream);
                        continue;
                    }
                    if (n2 >= 80 && n2 <= 96) {
                        Trigger trigger = Level.AddTriggerAction(n2);
                        trigger.LoadTrigger(sDKInputStream);
                        continue;
                    }
                    if (n2 == 0) continue;
                    int n3 = n2;
                    Entity entity = null;
                    entity = Level.SpawnEntity(n3);
                    entity.Load(sDKInputStream, n2);
                    if (n2 != 1) continue;
                    if (_nFirstWormIndex == -1) {
                        _nFirstWormIndex = entity._id;
                    }
                    ++_nWormsEntities;
                    if (GameImpl.IsTutorial()) continue;
                    entity._flags |= 0x10;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            sDKInputStream.close();
            SDKInputStream.purgeCache();
            sDKInputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void LoadLevelPoints(int n) {
        _nPoints = 0;
        try {
            SDKInputStream sDKInputStream = null;
            try {
                sDKInputStream = new SDKInputStream(n);
                while (sDKInputStream.available() > 0) {
                    int n2 = (sDKInputStream.read() & 0xFF) + ((sDKInputStream.read() & 0xFF) << 8);
                    for (int i = 0; i < n2; ++i) {
                        Level._aPoints[Level._nPoints][0] = (short)((sDKInputStream.read() & 0xFF) + ((sDKInputStream.read() & 0xFF) << 8)) << 16;
                        Level._aPoints[Level._nPoints][1] = (short)((sDKInputStream.read() & 0xFF) + ((sDKInputStream.read() & 0xFF) << 8)) << 16;
                        ++_nPoints;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            sDKInputStream.close();
            SDKInputStream.purgeCache();
            sDKInputStream = null;
            System.gc();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void GenerateLevelBasedOnPoints() {
        Level.ClearLandscapeCollisions();
        Level.TraceBSpline();
    }

    static Entity GetEntityByLevelId(int n) {
        for (int i = 0; i < _nMaxUsedEntities; ++i) {
            if (Level._entities[i]._level_id != n) continue;
            return _entities[i];
        }
        return null;
    }

    static Entity GetEntityUnsafe(int n) {
        return _entities[n];
    }

    static Entity GetEntitySafe(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n & 0xFFFF;
        if (_entities_usage[n2] == 1) {
            return _entities[n2];
        }
        return null;
    }

    static int GetUnusedEntityIndex() {
        for (int i = 0; i < 250; ++i) {
            if (_entities_usage[i] != 0) continue;
            return i;
        }
        return -1;
    }

    static void DisableEntity(int n) {
        Entity entity = _entities[n];
        if (entity._type == 12 || entity._type == 9 || entity._type == 1) {
            Level.RemoveObjectLevelCollisions(entity);
        }
        if (entity._type != 1) {
            Level._entities_usage[n] = 0;
        }
        if (entity._type == 19) {
            entity._flags &= 0xFFFFFFDF;
        }
        int n2 = 0;
        for (n2 = _nMaxUsedEntities - 1; n2 >= 0 && _entities_usage[n2] != 1; --n2) {
        }
        _nMaxUsedEntities = n2 + 1;
        entity._flags |= 0x18;
    }

    static void EnableEntity(int n) {
        Level._entities_usage[n] = 1;
        Level._entities[n]._flags &= 0xFFFFFFE7;
        if (Level._entities[n]._type == 19) {
            _entities[n].SetSprite(1);
            Level._entities[n]._crt_anim = -1;
            _entities[n].SetCrtAnim(Level._entities[n]._bdata[1]);
            _entities[n].UpdateBoundingBox();
            _entities[n].SetSprite(1);
            _entities[n].SetCrtAnim(69);
            Level._entities[n]._flags |= 0x40;
        }
    }

    static void UpdateWormEntitiesGroundCollisions() {
        for (int i = _nFirstWormIndex; i < _nFirstWormIndex + _nWormsEntities; ++i) {
            if (_entities_usage[i] != 1 || Level._entities[i]._type != 1) continue;
            Level._entities[i]._flags |= 0x400;
        }
    }

    static void SpawnWorms(int[] nArray) {
        _nFirstWormIndex = -1;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            for (n = 0; n < nArray[i]; ++n) {
                Entity entity = Level.SpawnRandomWorm(n2);
                ++n2;
                entity.SetWormTeam(i);
                if (!GameImpl.IsTutorial()) {
                    entity._flags |= 0x10;
                }
                if (GameImpl._nLevelType == 1) {
                    if (GameImpl._campaignData[GameImpl._nActiveIslandID][1] == 1) {
                        entity._health = 100;
                        GameImpl._nGameMode = 3;
                    } else if (entity._bdata[3] == 0) {
                        entity._health = GameImpl._campaignData[GameImpl._nActiveIslandID][1];
                    } else if (entity._bdata[3] == 1) {
                        entity._health = GameImpl._campaignData[GameImpl._nActiveIslandID][13];
                    } else if (entity._bdata[3] == 2) {
                        entity._health = GameImpl._campaignData[GameImpl._nActiveIslandID][14];
                    }
                }
                int n3 = i;
                GameImpl._nTeamWormCount[n3] = GameImpl._nTeamWormCount[n3] + 1;
            }
        }
        _nWormsEntities = n2;
    }

    static Entity SpawnEntity(int n) {
        return Level.SpawnEntity(n, _entities);
    }

    static Entity SpawnEntity(int n, Entity[] entityArray) {
        Entity entity = null;
        int n2 = 0;
        if (entityArray == _entities) {
            n2 = Level.GetUnusedEntityIndex();
            if (n2 < 0) {
                return null;
            }
            _lastSpawnedIndex = n2;
            entity = _entities[n2];
            Level._entities_usage[n2] = 1;
            if (n == 19) {
                ++_nNPCAntEntities;
            }
            if (n2 >= _nMaxUsedEntities) {
                _nMaxUsedEntities = n2 + 1;
            }
        }
        entity.Reset();
        entity._type = n;
        entity._id = n2;
        if (entity._type != 23) {
            entity.Init();
        }
        return entity;
    }

    static void SpawnLevelEntity() {
        _entLevel = Level.SpawnEntity(7);
    }

    static Entity SpawnParticleGenerator(short s, byte by, byte by2, byte by3) {
        Entity entity = Level.SpawnEntity(17);
        if (entity == null) {
            return null;
        }
        entity.Init(17, entity._pos_x, entity._pos_x, null, null);
        entity._sdata[0] = s;
        entity._bdata[0] = by;
        entity._bdata[1] = by2;
        entity._bdata[2] = by3;
        entity._timer = 0L;
        return entity;
    }

    static Entity SpawnRandomCrate() {
        int n = 0;
        int n2 = 0;
        Entity entity = Level.SpawnEntity(9);
        entity._sprite = 12;
        entity.SetCrtAnim(2);
        entity.UpdateBoundingBox();
        entity._flags |= 0x40;
        entity._flags |= 0x20;
        entity._pos_x = n << 16;
        boolean bl = false;
        while (!bl) {
            n = Level.IRandom(292, 1052);
            n2 = Level.IRandom(192, 576);
            entity._pos_x = n << 16;
            entity._pos_y = n2 << 16;
            if (!entity.CollideWith(_entLevel, entity._pos_x, entity._pos_y)) continue;
            bl = true;
            entity._pos_y = 0x320000;
            entity._pos_y = entity.PlaceObjectOnGround(entity._pos_x >> 16, entity._pos_y >> 16, false) << 16;
        }
        Level.DoFollowEntity(entity._id);
        entity._sprite = 12;
        entity._flags |= 0x40;
        entity._flags |= 0x20;
        if (GameImpl._nGameMode != 4 && GameImpl._nGameMode != 3 && GameImpl.random(100) < 25) {
            entity._idata[0] = -1;
            entity.SetCrtAnim(3);
        } else if (GameImpl._nGameMode == 5) {
            if (!_lightningStrikeSpawned) {
                _lightningStrikeSpawned = true;
                entity._idata[0] = 24;
                entity.SetCrtAnim(2);
            } else {
                entity._idata[0] = -1;
                entity.SetCrtAnim(3);
            }
        } else {
            int n3 = GameArray.CRATE_WEAPONS_NO;
            entity._idata[0] = GameArray.CRATE_WEAPONS[GameImpl.random(n3)];
            entity.SetCrtAnim(2);
        }
        return entity;
    }

    static void SpawnLevelObjects(int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            Entity entity = Level.SpawnEntity(n2);
            entity.UpdateBoundingBox();
            bl = false;
            n5 = 0;
            while (!bl && n5 < 40) {
                int n6;
                n3 = GameImpl.random(_extraPixelsWidth, 960 + _extraPixelsWidth);
                n4 = GameImpl.random(_extraPixelsHeightTop, 384 + _extraPixelsHeightTop);
                entity._pos_x = n3 << 16;
                entity._pos_y = n4 << 16;
                if (!entity.CollideWith(_entLevel, n3 << 16, n4 << 16)) {
                    if ((n4 = entity.PlaceObjectOnGround(n3, n4, false)) < _sea_level) {
                        bl = true;
                    }
                } else {
                    if (n2 == 13 || n2 == 12) {
                        bl = false;
                        continue;
                    }
                    if ((n4 = entity.PlaceObjectOnGround(n3, n4, true)) > 0x180000 && n4 < _sea_level) {
                        bl = true;
                    }
                }
                for (n6 = _nFirstBarrelIndex; n6 < _nOilBarrelsEntities + _nFirstBarrelIndex - 1; ++n6) {
                    Entity entity2 = _entities[n6];
                    if (!entity.CollideWith(entity2, n3 << 16, n4 << 16)) continue;
                }
                entity.SetPosition(n3 << 16, n4 << 16);
                if (bl && n2 == 13 && entity.CheckMineCollisionsWithWorms()) {
                    bl = false;
                }
                if (bl) {
                    n6 = -1;
                    int n7 = -1;
                    if (n2 == 12 && _nFirstBarrelIndex != -1) {
                        n6 = _nFirstBarrelIndex;
                        n7 = _nFirstBarrelIndex + _nOilBarrelsEntities - 1;
                    } else if (n2 == 13 && _nFirstMineIndex != -1) {
                        n6 = _nFirstMineIndex;
                        n7 = _nFirstMineIndex + _nMineEntities - 1;
                    }
                    if (n6 != -1) {
                        bl = Level.VerifySpawnDistance(entity, n6, n7, 30);
                    }
                    if (n2 == 13 && bl && _nFirstBarrelIndex != -1) {
                        bl = Level.VerifySpawnDistance(entity, _nFirstBarrelIndex, _nFirstBarrelIndex + _nOilBarrelsEntities, 6);
                    }
                }
                if (bl && n2 == 12) {
                    for (n6 = _nFirstWormIndex; n6 < _nFirstWormIndex + _nWormsEntities; ++n6) {
                        if (_entities_usage[n6] != 1 || Level._entities[n6]._type != 1 || _entities[n6].Worm_IsDyingOrDead() || !entity.CollideWith(_entities[n6], entity._pos_x, entity._pos_y)) continue;
                        bl = false;
                        break;
                    }
                }
                ++n5;
            }
            if (!bl) {
                --_nOilBarrelsEntities;
                if (_nFirstBarrelIndex == entity._id) {
                    _nFirstBarrelIndex = -1;
                }
                Level.DisableEntity(entity._id);
                continue;
            }
            if (n2 == 12) {
                Level.AddObjectLevelCollisions(entity, (byte)1);
                if (_nFirstBarrelIndex == -1) {
                    _nFirstBarrelIndex = entity._id;
                }
                ++_nOilBarrelsEntities;
            }
            if (n2 != 13) continue;
            if (_nFirstMineIndex == -1) {
                _nFirstMineIndex = entity._id;
            }
            ++_nMineEntities;
        }
    }

    static boolean VerifySpawnDistance(Entity entity, int n, int n2, int n3) {
        if (n < 0) {
            n = 0;
        }
        for (int i = n; i < n2; ++i) {
            if ((Math.abs((Level._entities[i]._pos_x >> 16) - (entity._pos_x >> 16)) > Math.abs((Level._entities[i]._pos_y >> 16) - (entity._pos_y >> 16)) ? Math.abs((Level._entities[i]._pos_x >> 16) - (entity._pos_x >> 16)) : Math.abs((Level._entities[i]._pos_y >> 16) - (entity._pos_y >> 16))) >= n3) continue;
            return false;
        }
        return true;
    }

    static Entity SpawnText(byte by, int n, int n2) {
        Entity entity = Level.SpawnEntity(10);
        entity.Init(10, n + 25 << 16, n2 + -34 << 16, null, null);
        entity._bdata[0] = by;
        return entity;
    }

    public static int GetNextActiveWorm() {
        int n = GameImpl._nPreviousWorm[GameImpl._nCurrentActiveTeam];
        do {
            if (++n < _nFirstWormIndex) {
                n = _nFirstWormIndex;
            }
            if (n <= _nFirstWormIndex + _nWormsEntities - 1) continue;
            n = _nFirstWormIndex;
        } while (Level._entities[n]._type != 1 || _entities[n].Worm_IsDyingOrDead() || Level._entities[n]._bdata[3] != GameImpl._nCurrentActiveTeam || (Level._entities[n]._flags & 0x18) != 0);
        return n;
    }

    static void InflictCollateralDamage(int n, int n2, int n3, int n4) {
        Entity entity;
        int n5 = 0;
        n2 <<= 16;
        int n6 = GameArray._kProjectilesInfo[n][0];
        int n7 = GameArray._kProjectilesInfo[n][1];
        for (int i = 0; i < _nMaxUsedEntities; ++i) {
            int n8;
            if (_entities_usage[i] != 1) continue;
            entity = _entities[i];
            if (entity._type != 1 && entity._type != 12 && entity._type != 13 && entity._type != 9 && entity._type != 14 && entity._type != 19 && entity._type != 27 || n2 == 0 || n == 8 && entity._type == 1 && (entity._nState == 20 || entity == GameImpl._pCrtWorm) || n == 31 && entity == GameImpl._pCrtWorm || n == 28 && entity == GameImpl._pCrtWorm && entity._nState == 24 && entity._bdata[15] == 32 || (n == 16 || n == 12) && entity._type == 1 && entity == GameImpl._pCrtWorm || n == 19 && entity._type == 1 && entity._nState == 24 || n == 8 && entity._type == 1 && entity._bdata[13] == 1) continue;
            GameImpl._vector[0] = entity._pos_x - n3;
            GameImpl._vector[1] = entity.GetWormCenterY() - n4;
            if (n == 31 || n == 2) {
                GameImpl._vector[0] = GameImpl._pCrtWorm._bdata[5] * Math.abs(entity._pos_x - n3);
            }
            if ((n8 = GameImpl.Normalize(GameImpl._vector)) > n2 || (n5 = n == 31 ? 0x1E0000 : (n6 << 16) + (int)((long)(n7 - n6 << 16) * (long)((int)(((long)n2 - (long)n8 << 16) / (long)n2)) >> 16)) >> 16 == 0) continue;
            if (n == 2 && entity._type == 1) {
                if (entity._nState == 18 || entity._bHitByPunch) continue;
                entity._bHitByPunch = true;
            }
            int n9 = (int)((long)GameImpl._vector[0] * (long)n5 >> 16) / 3;
            int n10 = (int)((long)GameImpl._vector[1] * (long)n5 >> 16) / 3;
            if (n == 16 && entity._type == 1) {
                int n11 = GameImpl._pCrtWorm._idata[5] * 180 >> 16;
                int n12 = GameImpl.Sin(n11);
                int n13 = GameImpl.Cos(n11);
                n9 = GameImpl._pCrtWorm._bdata[5] * (int)(983040L * (long)n12 >> 16);
                n10 = (int)(983040L * (long)n13 >> 16);
                entity._bdata[17] = 1;
            }
            if (n == 12) {
                n9 = 0;
                n10 = 0;
            }
            if (n == 23) {
                n10 = -131072;
            }
            if (n == 2) {
                n9 = 131072 * (GameImpl._vector[0] > 0 ? 1 : -1);
                n10 = -786432;
            }
            n9 = (int)((long)n9 * 65536L >> 16);
            n10 = (int)((long)n10 * 65536L >> 16);
            if (GameImpl.IsTutorial()) {
                n9 = 0;
                n10 = 0;
            }
            entity.Force(n9, n10);
            if (entity._type == 1) {
                entity.Worm_SetState((byte)11);
            }
            entity.HandleHit(n, n5 >> 16);
        }
        entity = null;
    }

    static int FindClosestObject(int n, int n2, int n3) {
        boolean bl = false;
        int n4 = 0;
        int n5 = -1;
        for (int i = 0; i < _nMaxUsedEntities; ++i) {
            if (_entities_usage[i] != 1 || Level._entities[i]._type != n3) continue;
            int n6 = Math.abs(Level._entities[i]._pos_x - n) + Math.abs(Level._entities[i]._pos_y - n2);
            if (bl && n6 >= n4) continue;
            n4 = n6;
            bl = true;
            n5 = i;
        }
        return n5;
    }

    static void PrintParticleCreated() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < _nMaxUsedEntities; ++i) {
            if ((Level._entities[i]._flags & 0x18) == 0) {
                ++n2;
            }
            if (Level._entities[i]._type != 18) continue;
            ++n;
        }
    }

    static void ClearParticleGenerators() {
        for (int i = 0; i < _nMaxUsedEntities; ++i) {
            if (Level._entities[i]._type != 17) continue;
            Level.DisableEntity(i);
        }
    }

    static void DisableAllEntities() {
        if (_entities == null) {
            return;
        }
        for (int i = 0; i < 250; ++i) {
            Level.DisableEntity(i);
        }
        Entity._tutorialAnim = null;
    }

    static Entity GetNextTargetWorm(int n) {
        int n2 = 65536000;
        int n3 = -1;
        for (int i = _nFirstWormIndex; i < _nFirstWormIndex + _nWormsEntities; ++i) {
            if (i == Entity._targetWorm._id || (Level._entities[i]._flags & 0x10) == 16 || _entities_usage[i] != 1 || Level._entities[i]._type != 1 || Level._entities[i]._pos_y >= (_sea_level << 16) + 0x180000 || Level._entities[i]._pos_y >= _nLandMaxHeight << 16 || Level._entities[i]._pos_x <= 192 || Level._entities[i]._pos_x >= _nLandMaxWidth - 192 << 16 || Level._entities[i]._pos_x >> 16 <= 192) continue;
            int n4 = Level._entities[i]._pos_x - Entity._targetWorm._pos_x;
            if (n == 0) {
                if (n4 <= 0 || n4 >= n2) continue;
                n2 = n4;
                n3 = i;
                continue;
            }
            if (n4 >= 0 || Math.abs(n4) >= Math.abs(n2)) continue;
            n2 = n4;
            n3 = i;
        }
        if (GameImpl._isFiringRange && n3 == -1) {
            n3 = Entity._targetWorm._id;
        }
        if (n3 == -1) {
            return null;
        }
        return _entities[n3];
    }

    static void DealAxeDamage() {
        if (GameImpl._nGameMode == 4 || GameImpl._bAxeDamageDone) {
            return;
        }
        for (int i = _nFirstWormIndex; i < _nFirstWormIndex + _nWormsEntities; ++i) {
            if (_entities_usage[i] != 1 || !Level._entities[i]._bHitByAxe || Level._entities[i]._type != 1) continue;
            Level._entities[i]._idata[9] = Level._entities[i]._idata[9] + GameArray._kProjectilesInfo[12][0];
            if (!Level._entities[i]._bEffectedByGas) continue;
            Level.DoFollowEntity(Level._entities[i]._id);
            _entities[i].SetSprite(1);
            _entities[i].SetCrtAnim(82);
        }
        GameImpl._bAxeDamageDone = true;
    }

    static Entity SpawnRandomWorm(int n) {
        int n2 = 0;
        int n3 = 0;
        Entity entity = Level.SpawnEntity(1);
        boolean bl = false;
        block0: while (!bl) {
            n2 = Level.IRandom(292, 1052);
            n3 = Level.IRandom(192, 576);
            entity._pos_x = n2 << 16;
            entity._pos_y = n3 << 16;
            if (entity.Worm_Collided(n2 << 16, n3 << 16)) {
                if ((n3 = entity.PlaceObjectOnGround(n2, n3, true)) > 24 && n3 < _sea_level) {
                    bl = true;
                }
            } else if ((n3 = entity.PlaceObjectOnGround(n2, n3, false)) < _sea_level) {
                bl = true;
            }
            if (!bl || _nFirstWormIndex == -1) continue;
            for (int i = _nFirstWormIndex; i < _nFirstWormIndex + n; ++i) {
                if ((Math.abs((Level._entities[i]._pos_x >> 16) - n2) > Math.abs((Level._entities[i]._pos_y >> 16) - n3) ? Math.abs((Level._entities[i]._pos_x >> 16) - n2) : Math.abs((Level._entities[i]._pos_y >> 16) - n3)) >= 30) continue;
                bl = false;
                continue block0;
            }
        }
        entity.SetPosition(n2 << 16, n3 << 16);
        if (_nFirstWormIndex == -1) {
            _nFirstWormIndex = entity._id;
        }
        return entity;
    }

    public static void SetLandscapeCollision(int n, int n2, byte by) {
        if (n >= _nLandWidth + _extraPixelsWidth || n2 >= _nLandHeight + _extraPixelsHeightTop || n < _extraPixelsWidth || n2 < _extraPixelsHeightTop) {
            return;
        }
        int n3 = n - _extraPixelsWidth + (n2 - _extraPixelsHeightTop) * _nLandWidth;
        int n4 = n3 >> 3;
        int n5 = n3 & 7;
        if (by != 0) {
            int n6 = n4;
            _aLandscapeColMask[n6] = (byte)(_aLandscapeColMask[n6] | 1 << n5);
        } else {
            int n7 = n4;
            _aLandscapeColMask[n7] = (byte)(_aLandscapeColMask[n7] & ~(1 << n5));
        }
    }

    public static void ClearLandscapeCollisions() {
        GameImpl.MemSet(_aLandscapeColMask, (byte)0);
    }

    public static int GetLandscapeCollision(int n, int n2) {
        if (n >= _nLandWidth + _extraPixelsWidth || n2 >= _nLandHeight + _extraPixelsHeightTop || n < _extraPixelsWidth || n2 < _extraPixelsHeightTop) {
            return 0;
        }
        int n3 = n - _extraPixelsWidth + (n2 - _extraPixelsHeightTop) * _nLandWidth;
        int n4 = n3 >> 3;
        int n5 = n3 & 7;
        if ((_aLandscapeColMask[n4] & 1 << n5) != 0) {
            return 1;
        }
        return 0;
    }

    static boolean IsEmptySpaceUnder(int n, int n2) {
        return 0 == Level.GetLandscapeCollision(n, n2 + 1);
    }

    static void ShiftCollisions() {
        _extraPixelsWidth = 192;
        _extraPixelsHeightTop = 192;
        _extraPixelsHeightBottom = 64;
        _extra_empty_tiles_per_row = 2 * _extraPixelsWidth / 64;
        _level_tw = 15 + _extra_empty_tiles_per_row;
        _level_th = 6 + (_extraPixelsHeightTop + _extraPixelsHeightBottom) / 64;
        _nLandMaxWidth = 960 + 2 * _extraPixelsWidth;
        _nLandMaxHeight = 384 + _extraPixelsHeightTop + _extraPixelsHeightBottom;
        _sea_level = _nLandMaxHeight - 64;
    }

    static void AddWormsLevelCollisions() {
        for (int i = _nFirstWormIndex; i < _nFirstWormIndex + _nWormsEntities; ++i) {
            if (_entities_usage[i] != 1 || Level._entities[i]._type != 1 || _entities[i].Worm_IsDyingOrDead()) continue;
            Level.AddObjectLevelCollisions(_entities[i], (byte)1);
        }
    }

    static void RemoveWormsLevelCollisions() {
        for (int i = _nFirstWormIndex; i < _nFirstWormIndex + _nWormsEntities; ++i) {
            if (_entities_usage[i] != 1 || Level._entities[i]._type != 1 || _entities[i].Worm_IsDyingOrDead()) continue;
            Level.RemoveObjectLevelCollisions(_entities[i]);
        }
    }

    static void AddObjectLevelCollisions(Entity entity, byte by) {
        int n = (entity._pos_x >> 16) + entity._bbox[0];
        int n2 = (entity._pos_y >> 16) + entity._bbox[1];
        int n3 = entity._bbox[2] - entity._bbox[0];
        int n4 = entity._bbox[3] - entity._bbox[1];
        for (int i = n; i < n + n3; ++i) {
            for (int j = n2; j < n2 + n4; ++j) {
                Level.SetLandscapeCollision(i, j, by);
            }
        }
    }

    static void RemoveObjectLevelCollisions(Entity entity) {
        int n = (entity._pos_x >> 16) + entity._bbox[0];
        int n2 = (entity._pos_y >> 16) + entity._bbox[1];
        int n3 = entity._bbox[2] - entity._bbox[0];
        int n4 = entity._bbox[3] - entity._bbox[1];
        for (int i = n; i < n + n3; ++i) {
            for (int j = n2; j < n2 + n4; ++j) {
                Level.SetLandscapeCollision(i, j, (byte)0);
            }
        }
    }

    static void UnshiftCollisions() {
        _nLandMaxWidth = 960;
        _extraPixelsWidth = 0;
        _nLandMaxHeight = 384;
        _extraPixelsHeightTop = 0;
        _extraPixelsHeightBottom = 0;
        _sea_level = _nLandMaxHeight - 64;
    }

    static boolean RectCollideWithLand(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        if (bl) {
            n5 = 0;
        }
        return Level.GetLandscapeCollision(n, n2) > n5 || Level.GetLandscapeCollision(n + n3, n2) > n5 || Level.GetLandscapeCollision(n, n2 + n4) > n5 || Level.GetLandscapeCollision(n + n3 / 2, n2 + n4 / 2) > n5 || Level.GetLandscapeCollision(n + n3, n2 + n4) > n5;
    }

    static boolean RectCollideWithLandCenter(int n, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        return Level.GetLandscapeCollision(n - n3, n2 - n4) > n5 || Level.GetLandscapeCollision(n + n3, n2 - n4) > n5 || Level.GetLandscapeCollision(n + 0, n2 + 0) > n5 || Level.GetLandscapeCollision(n - n3, n2 + n4) > n5 || Level.GetLandscapeCollision(n + n3, n2 + n4) > n5;
    }

    static void SetTimerState(int n) {
        if (_timerState == n) {
            return;
        }
        _timerState = n;
    }

    static void UpdateTimer() {
        if (GameImpl._isFiringRange) {
            _isRealTime = true;
        }
        if (_timerState == 0) {
            return;
        }
        if (GameImpl._bRetreating && !_isRealTime) {
            if ((Level.CheckRetreatTimer() || GameImpl._bDontRetreat) && !GameImpl._bDontEndTurn) {
                GameImpl._bRetreating = false;
                Level.HideTimer();
            }
        } else {
            if (_isRealTime) {
                return;
            }
            _turnTimeLeft = GameImpl._nGameMode == 1 && GameImpl._nLevelType == 2 ? _turnTimeStarted + 16000L - GameImpl.canvas.getAppTime() + _timeDiff : _turnTimeStarted + _timePerTurn - GameImpl.canvas.getAppTime() + _timeDiff;
            if (_turnTimeLeft < 6000L && (GameImpl._tips_drawn_flag & 1) == 0) {
                GameImpl.SetDrawTip(1);
            }
            if (_turnTimeLeft <= 0L && (GameImpl._nGamePlayState == 2 || GameImpl._nGamePlayState == 4 || GameImpl._nGamePlayState == 3)) {
                GameImpl.SetGamePlayState(5);
                if (GameImpl._pCrtWorm != null && GameImpl._pCrtWorm._nState == 2) {
                    GameImpl._pCrtWorm.Worm_SetState((byte)1);
                }
            }
        }
    }

    static void ResetTimer() {
        _timeDiff = 0L;
        _turnTimeStarted = GameImpl.canvas.getAppTime();
        Level.SetTimerState(2);
    }

    static void StartTimer() {
        _timeDiff = 0L;
        Level.SetTimerState(1);
    }

    static void StartRetreatTimer() {
        if (GameImpl._pCrtWorm != null && GameImpl._pCrtWorm._bdata[12] == 1) {
            GameImpl._bRetreating = true;
            _retreatTimer = GameImpl.canvas.getAppTime() - _timeDiff;
            GameImpl._retreatStartTime = GameImpl._nGameTimer;
        }
        if (GameImpl._pCrtWorm._bdata[12] == 0) {
            Level.HideTimer();
        }
    }

    static boolean CheckRetreatTimer() {
        return GameImpl.canvas.getAppTime() - (_retreatTimer + _timeDiff) > _currentRetreatTime;
    }

    static void HideTimer() {
        Level.SetTimerState(0);
    }

    static void StopTimer() {
        Level.SetTimerState(2);
    }

    static void PauseTimer() {
        _timeDiff = GameImpl.canvas.getAppTime() - _timeDiff;
        Level.HideTimer();
    }

    static void ResumeTimer() {
        if (GameImpl._pCrtWorm != null) {
            GameImpl._pCrtWorm._timer += GameImpl.canvas.getAppTime() - _timeDiff;
        }
        if (_timerState != 0) {
            return;
        }
        _timeDiff = GameImpl.canvas.getAppTime() - _timeDiff;
        Level.SetTimerState(1);
    }

    static void InitTriggers() {
        int n;
        _nrTriggerActions = 0;
        _nrTriggerEvents = 0;
        _triggerEvents = new Trigger[250];
        _triggerActions = new Trigger[250];
        for (n = 0; n < 250; ++n) {
            Level._triggerEvents[n] = new Trigger();
        }
        for (n = 0; n < 250; ++n) {
            Level._triggerActions[n] = new Trigger();
        }
    }

    static void ReleaseTriggers() {
        _nrTriggerActions = 0;
        _nrTriggerEvents = 0;
        _triggerEvents = null;
        _triggerActions = null;
        System.gc();
    }

    static Trigger AddTriggerEvent(int n) {
        if (_nrTriggerEvents >= 250) {
            return null;
        }
        Trigger trigger = _triggerEvents[_nrTriggerEvents++];
        trigger._type = (byte)n;
        trigger.Init();
        return trigger;
    }

    static Trigger AddTriggerAction(int n) {
        if (_nrTriggerActions >= 250) {
            return null;
        }
        Trigger trigger = _triggerActions[_nrTriggerActions++];
        trigger._type = (byte)n;
        trigger.Init();
        return trigger;
    }

    static void CheckPositionTriggers(Entity entity, int n, int n2) {
        for (int i = 0; i < _nrTriggerEvents; ++i) {
            if (Level._triggerEvents[i]._type != 60) continue;
            _triggerEvents[i].CheckPositionTrigger(entity, n >> 16, n2 >> 16);
        }
    }

    static void CheckTriggers(short s, Entity entity, boolean bl) {
        for (int i = 0; i < _nrTriggerEvents; ++i) {
            if (Level._triggerEvents[i]._type != s) continue;
            _triggerEvents[i].CheckTrigger(entity, bl);
        }
    }

    static void UpdateTriggers() {
        for (int i = 0; i < _nrTriggerActions; ++i) {
            _triggerActions[i].Update();
        }
    }

    static Trigger GetTriggerByLevelId(int n) {
        int n2;
        for (n2 = 0; n2 < _nrTriggerEvents; ++n2) {
            if (Level._triggerEvents[n2]._level_id != n) continue;
            return _triggerEvents[n2];
        }
        for (n2 = 0; n2 < _nrTriggerActions; ++n2) {
            if (Level._triggerActions[n2]._level_id != n) continue;
            return _triggerActions[n2];
        }
        return null;
    }

    static {
        _lastCellOffset = 0;
        _lastLevelPlayed = new int[24];
        _border_colors = new int[]{2436621, 3751995, 5061401, 7616000, 3223343};
        _lightningStrikeSpawned = false;
        randWormCtr = -1;
        _camAtDestination = false;
        _nCamSpd = 0;
        _nCamSumSpeedMax = 0;
        _nCamMaxSpd = 20;
        _nCursorPosX = GameConstants.SCREEN_WIDTH / 2;
        _nCursorPosY = GameConstants.SCREEN_HEIGHT / 2;
        _followEntityPointer = -1;
        _fixCamera = false;
        _bCameraIsShakin = false;
        _nCameraShakes = 0;
        _nCameraMaxShakes = 0;
        _level_draw_type = 0;
        _currentTileSetSprite = -1;
        _backgroundSprite = -1;
        _extra_empty_tiles_per_row = 0;
        _tileRgbData = new int[4096];
        _invalidator_rect = new int[5];
        _bInvalidatorCDB = true;
        _CDB_regions = new Region[24];
        _aLevelMarkPoints = new int[16][2];
        _nLandMaxWidth = 960;
        _nLandMaxHeight = 384;
        _nLandWidth = 960;
        _nLandHeight = 384;
        pMaskSmaller = new byte[51];
        pMaskSmall = new byte[165];
        pMaskMed = new byte[585];
        pMaskBig = new byte[1261];
        pMaskBiggest = new byte[1936];
        _nFishEntities = 0;
        _nFirstWormIndex = -1;
        _nNPCAntEntities = 0;
        _nAISensorEntities = 0;
        _bHaveBackpack = true;
        _flashBackpackTimer = -1;
        _aLandscapeColMask = new byte[46081];
        _extraPixelsWidth = 0;
        _extraPixelsHeightTop = 0;
        _extraPixelsHeightBottom = 0;
        _timePerTurn = 46000L;
        _timeDiff = 0L;
        _bResumeTimerFromMenu = false;
    }
}

